.TH FOTOXX 1 2017-08-01 "Linux" "Fotoxx man page"

.SH NAME
 Fotoxx - photo/image editor and collection manager

.SH SYNOPSIS
 \fBFotoxx\fR [ \fBoptions\fR ] [ \fIfile\fR | \fIdirectory\fR ]

.SH DESCRIPTION
 Organize and manage a large image collection. Edit and optimize 
 photos and other images, search images, and perform batch operations. 
 Fotoxx is a GTK application which operates in its own window. 
 The included user manual explains its operation in great detail.
 The following is a summary of capabilities.

.SH OVERVIEW

Image edit functions include:
 - View and edit most image and RAW file types
 - Works internally with 24-bits/color, outputs 8 or 16 bits/color
 - Trim (crop), Resize, Flip, Level, Rotate, Add Text
 - Adjust brightness/color/contrast using movable curves
 - Edit the brightness distribution directly for best balance
 - Eliminate color caste and reduce fog/haze - Retinex method
 - Enhance faint details - magnify gradients, flatten distribution
 - Sharpen, Blur, Reduce noise, Remove red-eyes, fix perspective
 - Edit selected objects or areas separately within an image
 - Special function to select complex edges such as hair or trees
 - Copy and paste selected objects or areas across images
 - Remove a color caste that may vary across the image
 - Fix vignetting and other brightness uniformity problems
 - Warp (stretch/distort) an image by dragging the mouse
 - Record edits for one image, apply to any number of images
 - Special effects (drawing, painting, cartoon, 3D relief ...)
 - Edit and apply canned and custom convolution kernels
 - Pixel edit with variable brush transparency and blending
 - Paint retouch functions locally and gradually with the mouse
 - Smart erase: remove ground litter, power lines, etc.
 - Erase dust: remove dust spots on images from scanned slides
 - Flatten photo of a curved book page, stretch compressed text
 - Write text on an image (font/color/transparency/shadow/angle)
 - Mashup: Arrange images and formatted text in a layout
 - Panorama, HDR and Stack composites (hand-held camera OK)
 - Combine multiple photos with varying focus depths (HDF)
 - Show videos as images and thumbnails, edit metadata, play
 - Use Gimp, ImageMagick, etc. as plug-in functions

Utility functions include:
 - Context aware help available via the F1 key
 - Thumbnail browser and navigator, click image to view/edit
 - Hierarchical directory view - expand or collapse at each level
 - Custom "favorites" menu with user content and layout
 - Assign custom keyboard shortcuts to menu functions
 - Bookmark image locations, jump to bookmarked location
 - Edit any image metadata (EXIF/IPTC tags, dates, comments...)
 - Convert image color profile (e.g. sRGB <-> Adobe RGB)
 - Search and report any metadata - reports thumbnails with text
 - Use geotags from camera GPS, add/edit geotags manually
 - Search images by time, location, tags ... any metadata
 - World map at any scale, click on a marker for image gallery
 - Save and recall named map locations (map position and scale)
 - Batch convert format, resize, move, export, burn DVD/BlueRay
 - Batch rename images, insert dates and sequence numbers
 - Batch convert RAW files to tiff-8/16, png-8/16, jpeg
 - Batch add/change metadata (tags, time, location ... any)
 - Print image at any size for any paper format
 - Calibrate printer for more accurate printed colors
 - Create albums (views), arrange images, drag & drop
 - Slide-show with animated transitions and image pan/zoom
 - 360° panorama image viewer
 - Monitor color and gamma test patterns

.SH OPTIONS
Command line options
 \fB-v\fR                 print version and exit
 \fB-lang\fR \fIcode\fR   specify language (de, fr ...)
 \fB-prev\fR              open last file from the previous session
 \fB-recent\fR            show a gallery of most recent files 
 \fIfile\fR               initial image file to view or edit
 \fIdirectory\fR          initial directory for image gallery

.SH SEE ALSO
 The home page for Fotoxx is at https://kornelix.net

.SH AUTHORS
 Written by Mike Cornelison <kornelix@posteo.de>
 https://kornelix.net

