#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 6;

use File::Basename qw( dirname );
use File::Spec;

use lib './t/lib';

use FC_Solve::ShaAndLen;

{
    my $string = "HelloWorld";

    my $sha = FC_Solve::ShaAndLen->new();

    $sha->add($string);

    # TEST
    is ($sha->len(), 10, "Length is 10");

    # TEST
    is ($sha->hexdigest(),
        "872e4e50ce9990d8b041330c47c9ddd11bec6b503ae9386a99da8584e9bb12c4",
        "Hex digest is OK."
    );
}

{
    my $sha = FC_Solve::ShaAndLen->new();

    $sha->add("Hello");
    $sha->add("World");

    # TEST
    is ($sha->len(), 10, "Length is 10");

    # TEST
    is ($sha->hexdigest(),
        "872e4e50ce9990d8b041330c47c9ddd11bec6b503ae9386a99da8584e9bb12c4",
        "Hex digest is OK."
    );
}

{
    my $sha = FC_Solve::ShaAndLen->new();

    my $data_dir = File::Spec->catdir( dirname( __FILE__), 'data' );

    open my $in, "<", "$data_dir/sample-solutions/fcs-freecell-24.txt";
    $sha->add_file($in);
    close($in);

    # TEST
    is ($sha->len(), 31811, "Length for add_file() is 32280");

    # TEST
    is ($sha->hexdigest(),
        "e838102eafd8984dad80528e5bad1abe9f1cc669628495fce2c58e61cf2c3558",
        "Hex digest is OK for add_file()"
    );
}

=head1 COPYRIGHT AND LICENSE

Copyright (c) 2008 Shlomi Fish

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

=cut

