/* gmpc-database-update-tracker.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-database-update-tracker.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include "gmpc-extras.h"
#include <glib/gi18n-lib.h>
#include <time.h>
#include <playlist3-messages.h>
#include <libmpd/libmpd.h>
#include <plugin.h>
#include <gmpc-profiles.h>
#include <main.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GmpcToolsDatabaseUpdateTrackerPrivate {
	GtkImage* image;
};


static gpointer gmpc_tools_database_update_tracker_parent_class = NULL;

#define use_transition_mb TRUE
#define some_unique_name_mb VERSION
#define GMPC_TOOLS_DATABASE_UPDATE_TRACKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_TOOLS_TYPE_DATABASE_UPDATE_TRACKER, GmpcToolsDatabaseUpdateTrackerPrivate))
enum  {
	GMPC_TOOLS_DATABASE_UPDATE_TRACKER_DUMMY_PROPERTY
};
static gint* gmpc_tools_database_update_tracker_real_get_version (GmpcPluginBase* base, int* result_length1);
static const gchar* gmpc_tools_database_update_tracker_real_get_name (GmpcPluginBase* base);
static void gmpc_tools_database_update_tracker_start_updating (GmpcToolsDatabaseUpdateTracker* self);
static void gmpc_tools_database_update_tracker_stop_updating (GmpcToolsDatabaseUpdateTracker* self);
static void gmpc_tools_database_update_tracker_show_message (GmpcToolsDatabaseUpdateTracker* self, gint db_time);
static void gmpc_tools_database_update_tracker_connection_changed (GmpcToolsDatabaseUpdateTracker* self, GmpcConnection* gc, MpdObj* server, gint connection);
static void gmpc_tools_database_update_tracker_status_changed (GmpcToolsDatabaseUpdateTracker* self, GmpcConnection* gc, MpdObj* server, ChangedStatusType what);
static GObject * gmpc_tools_database_update_tracker_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gmpc_tools_database_update_tracker_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* mi, ChangedStatusType what, gpointer self);
static void _gmpc_tools_database_update_tracker_connection_changed_gmpc_connection_connection_changed (GmpcConnection* _sender, MpdObj* mi, gint connect, gpointer self);
static void gmpc_tools_database_update_tracker_finalize (GObject* obj);

static const gint GMPC_TOOLS_DATABASE_UPDATE_TRACKER_version[3] = {0, 0, 2};

static gint* gmpc_tools_database_update_tracker_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcToolsDatabaseUpdateTracker * self;
	gint* result = NULL;
	gint* _tmp0_;
	self = (GmpcToolsDatabaseUpdateTracker*) base;
	_tmp0_ = GMPC_TOOLS_DATABASE_UPDATE_TRACKER_version;
	*result_length1 = G_N_ELEMENTS (GMPC_TOOLS_DATABASE_UPDATE_TRACKER_version);
	result = _tmp0_;
	return result;
}


static const gchar* gmpc_tools_database_update_tracker_real_get_name (GmpcPluginBase* base) {
	GmpcToolsDatabaseUpdateTracker * self;
	const gchar* result = NULL;
	self = (GmpcToolsDatabaseUpdateTracker*) base;
	result = "Database Update Tracker";
	return result;
}


static void gmpc_tools_database_update_tracker_start_updating (GmpcToolsDatabaseUpdateTracker* self) {
	GtkImage* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->image != NULL) {
		return;
	}
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("gtk-refresh", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->image);
	self->priv->image = g_object_ref_sink (_tmp0_);
	gtk_widget_show ((GtkWidget*) self->priv->image);
	_tmp1_ = _ ("MPD is rescanning the database");
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->image, _tmp1_);
	main_window_add_status_icon ((GtkWidget*) self->priv->image);
}


static void gmpc_tools_database_update_tracker_stop_updating (GmpcToolsDatabaseUpdateTracker* self) {
	GtkContainer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->image == NULL) {
		return;
	}
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self->priv->image);
	gtk_container_remove (_tmp0_, (GtkWidget*) self->priv->image);
	_g_object_unref0 (self->priv->image);
	self->priv->image = NULL;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = 64;
	strftime (buffer, buffer_length1, format, &(*self));
	_tmp1_ = g_strdup ((const gchar*) buffer);
	result = _tmp1_;
	buffer = (g_free (buffer), NULL);
	return result;
}


static void gmpc_tools_database_update_tracker_show_message (GmpcToolsDatabaseUpdateTracker* self, gint db_time) {
	time_t r_time;
	gchar* message = NULL;
	struct tm _tmp0_ = {0};
	struct tm _tmp1_ = {0};
	struct tm tm;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	r_time = (time_t) db_time;
	g_time_local (r_time, &_tmp0_);
	_tmp1_ = _tmp0_;
	tm = _tmp1_;
	_tmp2_ = _ ("MPD Database has been updated at:");
	_tmp3_ = g_time_format (&tm, "%c");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s %s", _tmp2_, _tmp4_);
	_g_free0 (message);
	message = _tmp5_;
	_g_free0 (_tmp4_);
	playlist3_show_error_message ((const gchar*) message, ERROR_INFO);
	_g_free0 (message);
}


static void gmpc_tools_database_update_tracker_connection_changed (GmpcToolsDatabaseUpdateTracker* self, GmpcConnection* gc, MpdObj* server, gint connection) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (gc != NULL);
	g_return_if_fail (server != NULL);
	if (connection == 1) {
		gchar* _tmp0_ = NULL;
		gchar* id;
		gboolean _tmp3_;
		_tmp0_ = gmpc_profiles_get_current (gmpc_profiles);
		id = _tmp0_;
		if (id != NULL) {
			gint _tmp1_;
			gint dut;
			gint _tmp2_;
			gint serv_dut;
			_tmp1_ = gmpc_profiles_get_db_update_time (gmpc_profiles, id);
			dut = _tmp1_;
			_tmp2_ = mpd_server_get_database_update_time (server);
			serv_dut = _tmp2_;
			if (dut != serv_dut) {
				gmpc_tools_database_update_tracker_show_message (self, serv_dut);
				gmpc_profiles_set_db_update_time (gmpc_profiles, id, serv_dut);
			}
		}
		_tmp3_ = mpd_status_db_is_updating (server);
		if (_tmp3_) {
			gmpc_tools_database_update_tracker_start_updating (self);
		}
		_g_free0 (id);
	} else {
		gmpc_tools_database_update_tracker_stop_updating (self);
	}
}


static void gmpc_tools_database_update_tracker_status_changed (GmpcToolsDatabaseUpdateTracker* self, GmpcConnection* gc, MpdObj* server, ChangedStatusType what) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gc != NULL);
	g_return_if_fail (server != NULL);
	_tmp0_ = gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self);
	if (!_tmp0_) {
		return;
	}
	if ((what & MPD_CST_UPDATING) == MPD_CST_UPDATING) {
		gboolean _tmp1_;
		_tmp1_ = mpd_status_db_is_updating (server);
		if (_tmp1_) {
			gmpc_tools_database_update_tracker_start_updating (self);
		} else {
			gmpc_tools_database_update_tracker_stop_updating (self);
		}
	}
	if ((what & MPD_CST_DATABASE) == MPD_CST_DATABASE) {
		gchar* _tmp2_ = NULL;
		gchar* id;
		_tmp2_ = gmpc_profiles_get_current (gmpc_profiles);
		id = _tmp2_;
		if (id != NULL) {
			gint _tmp3_;
			gint dut;
			gint _tmp4_;
			gint serv_dut;
			_tmp3_ = gmpc_profiles_get_db_update_time (gmpc_profiles, id);
			dut = _tmp3_;
			_tmp4_ = mpd_server_get_database_update_time (connection);
			serv_dut = _tmp4_;
			if (dut != serv_dut) {
				gmpc_tools_database_update_tracker_show_message (self, serv_dut);
				gmpc_profiles_set_db_update_time (gmpc_profiles, id, serv_dut);
			}
			gmpc_tools_database_update_tracker_stop_updating (self);
		}
		_g_free0 (id);
	}
}


GmpcToolsDatabaseUpdateTracker* gmpc_tools_database_update_tracker_construct (GType object_type) {
	GmpcToolsDatabaseUpdateTracker * self = NULL;
	self = (GmpcToolsDatabaseUpdateTracker*) gmpc_plugin_base_construct (object_type);
	return self;
}


GmpcToolsDatabaseUpdateTracker* gmpc_tools_database_update_tracker_new (void) {
	return gmpc_tools_database_update_tracker_construct (GMPC_TOOLS_TYPE_DATABASE_UPDATE_TRACKER);
}


static void _gmpc_tools_database_update_tracker_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* mi, ChangedStatusType what, gpointer self) {
	gmpc_tools_database_update_tracker_status_changed (self, _sender, mi, what);
}


static void _gmpc_tools_database_update_tracker_connection_changed_gmpc_connection_connection_changed (GmpcConnection* _sender, MpdObj* mi, gint connect, gpointer self) {
	gmpc_tools_database_update_tracker_connection_changed (self, _sender, mi, connect);
}


static GObject * gmpc_tools_database_update_tracker_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcToolsDatabaseUpdateTracker * self;
	parent_class = G_OBJECT_CLASS (gmpc_tools_database_update_tracker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_TOOLS_DATABASE_UPDATE_TRACKER (obj);
	((GmpcPluginBase*) self)->plugin_type = 8 + 4;
	g_signal_connect_object (gmpcconn, "status-changed", (GCallback) _gmpc_tools_database_update_tracker_status_changed_gmpc_connection_status_changed, self, 0);
	g_signal_connect_object (gmpcconn, "connection-changed", (GCallback) _gmpc_tools_database_update_tracker_connection_changed_gmpc_connection_connection_changed, self, 0);
	return obj;
}


static void gmpc_tools_database_update_tracker_class_init (GmpcToolsDatabaseUpdateTrackerClass * klass) {
	gmpc_tools_database_update_tracker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcToolsDatabaseUpdateTrackerPrivate));
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_tools_database_update_tracker_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_tools_database_update_tracker_real_get_name;
	G_OBJECT_CLASS (klass)->constructor = gmpc_tools_database_update_tracker_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_tools_database_update_tracker_finalize;
}


static void gmpc_tools_database_update_tracker_instance_init (GmpcToolsDatabaseUpdateTracker * self) {
	self->priv = GMPC_TOOLS_DATABASE_UPDATE_TRACKER_GET_PRIVATE (self);
	self->priv->image = NULL;
}


static void gmpc_tools_database_update_tracker_finalize (GObject* obj) {
	GmpcToolsDatabaseUpdateTracker * self;
	self = GMPC_TOOLS_DATABASE_UPDATE_TRACKER (obj);
	_g_object_unref0 (self->priv->image);
	G_OBJECT_CLASS (gmpc_tools_database_update_tracker_parent_class)->finalize (obj);
}


GType gmpc_tools_database_update_tracker_get_type (void) {
	static volatile gsize gmpc_tools_database_update_tracker_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_tools_database_update_tracker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcToolsDatabaseUpdateTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_tools_database_update_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcToolsDatabaseUpdateTracker), 0, (GInstanceInitFunc) gmpc_tools_database_update_tracker_instance_init, NULL };
		GType gmpc_tools_database_update_tracker_type_id;
		gmpc_tools_database_update_tracker_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcToolsDatabaseUpdateTracker", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_tools_database_update_tracker_type_id__volatile, gmpc_tools_database_update_tracker_type_id);
	}
	return gmpc_tools_database_update_tracker_type_id__volatile;
}



