/***************************************************************************
 *            dlgsetup.c
 *
 *  Mon May 10 20:25:07 2004
 *  Copyright  2004  Vladimir Đokić
 *  vladeck@gnome-ppp.org
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "gnome-ppp.h"


void on_detect (GtkWidget *widget, gpointer data)
{
	int i;
	
	gnome_ppp.detect = gtk_message_dialog_new (GTK_WINDOW (gnome_ppp.gnome_ppp.window),
						GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
						GTK_MESSAGE_INFO,
						GTK_BUTTONS_CANCEL,
						_("Detecting your modem..."));
	g_signal_connect_swapped (G_OBJECT (gnome_ppp.detect), "response",
					G_CALLBACK (on_detect_cancel), NULL);
	gtk_widget_show (gnome_ppp.detect);
	
	i = 0;
	wvdialconf.cmd[i++] = "wvdialconf";
	wvdialconf.cmd[i++] = "/dev/null";
	wvdialconf.cmd[i++] = NULL;
	
	if (!g_spawn_async_with_pipes (NULL,
					(char **)wvdialconf.cmd,
					NULL,
					G_SPAWN_SEARCH_PATH,
					NULL, NULL,
					&wvdialconf.pid,
					&wvdialconf.in_pipe,
					&wvdialconf.out_pipe,
					&wvdialconf.err_pipe,
					&wvdialconf.error)) {		
		g_warning (_("GNOME PPP: Command failed: %s\n"), wvdialconf.error->message);
		g_error_free (wvdialconf.error);
		wvdialconf.error = NULL;
	} else {
		/* stdout */
		wvdialconf.out = g_io_channel_unix_new (wvdialconf.out_pipe);
		g_io_channel_set_encoding (wvdialconf.out, NULL, NULL);
		wvdialconf.out_tag = g_io_add_watch (wvdialconf.out,
						(G_IO_IN | G_IO_HUP | G_IO_ERR),
						on_wvdialconf_out,
						NULL );
		g_io_channel_unref (wvdialconf.out);
		/* stderr */
		wvdialconf.err = g_io_channel_unix_new (wvdialconf.err_pipe);
		g_io_channel_set_encoding (wvdialconf.err, NULL, NULL);
		wvdialconf.err_tag = g_io_add_watch (wvdialconf.err,
						(G_IO_IN | G_IO_HUP | G_IO_ERR),
						on_wvdialconf_err,
						NULL );
		g_io_channel_unref (wvdialconf.err);
	}
}

void on_phone_nums (GtkWidget *widget, gpointer data)
{
	gtk_widget_show (gnome_ppp.phone.window);
}

void on_init_strs (GtkWidget *widget, gpointer data)
{
	gtk_widget_show (gnome_ppp.init_strs.window);
}

void on_phone_num_edited (GtkCellRendererText *renderer, gchar *path, gchar *string, gpointer data)
{
	GtkTreeModel *model = (GtkTreeModel *)data;
	GtkTreePath *tree_path = gtk_tree_path_new_from_string (path);
	GtkTreeIter iter;
	gchar *old_value;
	
	gint column = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (renderer), "column"));
	gtk_tree_model_get_iter (model, &iter, tree_path);
	
        gtk_tree_model_get (model, &iter, column, &old_value, -1);
	g_free (old_value);

	gtk_list_store_set (GTK_LIST_STORE (data), &iter, column, string, -1);
	gtk_tree_path_free (tree_path);
	
	/* reload phone list in gnome ppp window */
	const gchar *phone;
		
	phone = gtk_entry_get_text (GTK_ENTRY(GTK_BIN (gnome_ppp.gnome_ppp.phone)->child));
		
	/* ... code to come... */
	gtk_entry_set_text( GTK_ENTRY(GTK_BIN (gnome_ppp.gnome_ppp.phone)->child), phone);
}

void on_init_str_edited (GtkCellRendererText *renderer, gchar *path, gchar *string, gpointer data)
{
	GtkTreeModel *model = (GtkTreeModel *)data;
	GtkTreePath *tree_path = gtk_tree_path_new_from_string (path);
	GtkTreeIter iter;
	gchar *old_value;
	
	gint column = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (renderer), "column"));
	gtk_tree_model_get_iter (model, &iter, tree_path);
	
        gtk_tree_model_get (model, &iter, column, &old_value, -1);
	g_free (old_value);

	gtk_list_store_set (GTK_LIST_STORE (data), &iter, column, string, -1);
	gtk_tree_path_free (tree_path);
}

void on_dial_attempts_changed (GtkWidget *widget, gpointer data)
{
	gdouble time;
	
	time = gtk_spin_button_get_value (GTK_SPIN_BUTTON (gnome_ppp.setup.spin_dial_attempts));
		
	if (time != 0.0)
		gtk_label_set_text (GTK_LABEL (gnome_ppp.setup.label_dial_attempts), "");
	else
		gtk_label_set_text (GTK_LABEL (gnome_ppp.setup.label_dial_attempts), _("forever"));
}

void on_dns_edited (GtkCellRendererText *renderer, gchar *path, gchar *string, gpointer data)
{
	GtkTreeModel *model = (GtkTreeModel *)data;
	GtkTreePath *tree_path = gtk_tree_path_new_from_string (path);
	GtkTreeIter iter;
	gchar *old_value;
	
	gint column = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (renderer), "column"));
	gtk_tree_model_get_iter (model, &iter, tree_path);
	
        gtk_tree_model_get (model, &iter, column, &old_value, -1);
	g_free (old_value);

	gtk_list_store_set (GTK_LIST_STORE (data), &iter, column, string, -1);
	gtk_tree_path_free (tree_path);
}

void on_static_ip (GtkWidget *widget, gpointer data)
{
	gtk_widget_set_sensitive (gnome_ppp.setup.label_ip, FALSE);
	gtk_widget_set_sensitive (gnome_ppp.setup.entry_ip, FALSE);
}

void on_dynamic_ip (GtkWidget *widget, gpointer data)
{
	gtk_widget_set_sensitive (gnome_ppp.setup.label_ip, TRUE);
	gtk_widget_set_sensitive (gnome_ppp.setup.entry_ip, TRUE);
}

void on_auto_dns (GtkWidget *widget, gpointer data)
{
	gtk_widget_set_sensitive (gnome_ppp.setup.list_dns, FALSE);
}

void on_manual_dns (GtkWidget *widget, gpointer data)
{
	gtk_widget_set_sensitive (gnome_ppp.setup.list_dns, TRUE);
}

void on_custom_reply (GtkWidget *widget, gpointer data)
{
	gboolean toggled = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.custom_reply));
	
	if (toggled == TRUE) {
		gtk_widget_set_sensitive (gnome_ppp.setup.label_reply, TRUE);
		gtk_widget_set_sensitive (gnome_ppp.setup.entry_reply, TRUE);
	} else {
		gtk_widget_set_sensitive (gnome_ppp.setup.label_reply, FALSE);
		gtk_widget_set_sensitive (gnome_ppp.setup.entry_reply, FALSE);
	}
}

void on_idle_changed (GtkWidget *widget, gpointer data)
{
	gdouble time;
	
	time = gtk_spin_button_get_value (GTK_SPIN_BUTTON (gnome_ppp.setup.spin_idle));
		
	if (time != 0.0) {
		gtk_widget_set_sensitive (gnome_ppp.setup.auto_reconnect, FALSE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.auto_reconnect), FALSE);
				
		if (time == 1.0 || time == 21.0 || time == 31.0 || time == 41.0
			|| time == 51.0 || time == 61.0 || time == 71.0 || time == 81.0
			|| time == 91.0 || time == 101.0 || time == 121.0 || time == 131.0
			|| time == 141.0 || time == 151.0 || time == 161.0 || time == 171.0
			|| time == 181.0 || time == 191.0 || time == 201.0 || time == 221.0
			|| time == 231.0)
			gtk_label_set_text (GTK_LABEL (gnome_ppp.setup.label_idle), _("second"));
		else
			gtk_label_set_text (GTK_LABEL (gnome_ppp.setup.label_idle), _("seconds"));
	} else {
		gtk_widget_set_sensitive (gnome_ppp.setup.auto_reconnect, TRUE);				
		gtk_label_set_text (GTK_LABEL (gnome_ppp.setup.label_idle), gettext("disabled"));
	}
}

void on_setup_close (GtkWidget *widget, gpointer data)
{
	write_conf ();
	gtk_widget_hide (gnome_ppp.setup.window);
}
