//**************************************************************************************************
//                                         PnlGnuCapOP.hpp                                         *
//                                        -----------------                                        *
// Description : This class derives from the Analysis Panel base class and provides a GUI for a    *
//               user to configure a Operating Point Analysis for GNU-Cap electronic circuit       *
//               simulator.                                                                        *
// Started     : 2003-11-06                                                                        *
// Last Update : 2015-01-05                                                                        *
// Copyright   : (C) 2003 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef PNLGNUCAPOP_HPP
#define PNLGNUCAPOP_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "base/PnlAnaBase.hpp"
#include "netlist/SimnGnuCap.hpp"

//**************************************************************************************************

class PnlGnuCapOP : public PnlAnaBase
{
  private :

    void  Create( void );

    void  InitScale( void );

  public :

          PnlGnuCapOP( wxWindow * poWin );
         ~PnlGnuCapOP( );

    bool  bClear( void );

    bool  bLoad( SimnGnuCap & roSimn );
    bool  bSave( SimnGnuCap & roSimn );

    // Event handlers
    void  OnScale  ( wxCommandEvent & roEvtCmd );
    void  OnSrcName( wxCommandEvent & roEvtCmd );

    // Leave this as the last line as private access is envoked by macro
    wxDECLARE_EVENT_TABLE( );
};

//**************************************************************************************************

#endif // PNLGNUCAPOP_HPP
