#ifndef _SWITCHER_H
#define _SWITCHER_H

#include <string>
#include <vector>
#include "applet.h"

class Switcher : public Applet {
  public:
    Switcher(AppletWindowParams params, const std::string& apps_icon, const std::string& phone_icon, const std::string& launch_icon);
    virtual AppAction OnMousePress(int x, int y);
    virtual AppAction OnMouseRelease(int x, int y);
    virtual void OnRotate(Rotation r);
    virtual ~Switcher(){}

  private:
    struct Button {
	int px, py, w, h;
	std::string action;
	std::string look;
	Button(int a, int b, int c, int d, const std::string& t, const std::string& l):px(a), py(b), w(c), h(d), action(t), look(l){}
    };
    int lastx, lasty;
    int pressed_button;
    std::vector<Button> buttons;
    void DrawButtons();
    std::string apps_icon;
    std::string phone_icon;
    std::string launch_icon;
};

#endif
