/* testlist.c generated by valac 0.52.0, the Vala compiler
 * generated from testlist.vala, do not modify */

/* testlist.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_LIST_TESTS (list_tests_get_type ())
#define LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_TESTS, ListTests))
#define LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_TESTS, ListTestsClass))
#define IS_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_TESTS))
#define IS_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_TESTS))
#define LIST_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_TESTS, ListTestsClass))

typedef struct _ListTests ListTests;
typedef struct _ListTestsClass ListTestsClass;
typedef struct _ListTestsPrivate ListTestsPrivate;
enum  {
	LIST_TESTS_0_PROPERTY,
	LIST_TESTS_NUM_PROPERTIES
};
static GParamSpec* list_tests_properties[LIST_TESTS_NUM_PROPERTIES];
typedef void (*GeeTestCaseTestMethod) (gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _ListTests {
	CollectionTests parent_instance;
	ListTestsPrivate * priv;
};

struct _ListTestsClass {
	CollectionTestsClass parent_class;
	void (*test_duplicates_are_retained) (ListTests* self);
};

static gpointer list_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeTestCase, g_object_unref)
GType collection_tests_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CollectionTests, g_object_unref)
GType list_tests_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ListTests, g_object_unref)
void list_tests_test_duplicates_are_retained (ListTests* self);
ListTests* list_tests_construct (GType object_type,
                                 const gchar* name);
CollectionTests* collection_tests_construct (GType object_type,
                                             const gchar* name);
void gee_test_case_add_test (GeeTestCase* self,
                             const gchar* name,
                             GeeTestCaseTestMethod test,
                             gpointer test_target,
                             GDestroyNotify test_target_destroy_notify);
void list_tests_test_iterator_is_ordered (ListTests* self);
static void _list_tests_test_iterator_is_ordered_gee_test_case_test_method (gpointer self);
void list_tests_test_list_iterator (ListTests* self);
static void _list_tests_test_list_iterator_gee_test_case_test_method (gpointer self);
static void _list_tests_test_duplicates_are_retained_gee_test_case_test_method (gpointer self);
void list_tests_test_get (ListTests* self);
static void _list_tests_test_get_gee_test_case_test_method (gpointer self);
void list_tests_test_set (ListTests* self);
static void _list_tests_test_set_gee_test_case_test_method (gpointer self);
void list_tests_test_insert (ListTests* self);
static void _list_tests_test_insert_gee_test_case_test_method (gpointer self);
void list_tests_test_remove_at (ListTests* self);
static void _list_tests_test_remove_at_gee_test_case_test_method (gpointer self);
void list_tests_test_index_of (ListTests* self);
static void _list_tests_test_index_of_gee_test_case_test_method (gpointer self);
void list_tests_test_first (ListTests* self);
static void _list_tests_test_first_gee_test_case_test_method (gpointer self);
void list_tests_test_last (ListTests* self);
static void _list_tests_test_last_gee_test_case_test_method (gpointer self);
void list_tests_test_insert_all (ListTests* self);
static void _list_tests_test_insert_all_gee_test_case_test_method (gpointer self);
void list_tests_test_slice (ListTests* self);
static void _list_tests_test_slice_gee_test_case_test_method (gpointer self);
gchar** test_data_get_data (gint* result_length1);
guint* test_data_get_drawn_numbers (gint* result_length1);
static void list_tests_real_test_duplicates_are_retained (ListTests* self);
static GType list_tests_get_type_once (void);

static void
_list_tests_test_iterator_is_ordered_gee_test_case_test_method (gpointer self)
{
	list_tests_test_iterator_is_ordered ((ListTests*) self);
}

static void
_list_tests_test_list_iterator_gee_test_case_test_method (gpointer self)
{
	list_tests_test_list_iterator ((ListTests*) self);
}

static void
_list_tests_test_duplicates_are_retained_gee_test_case_test_method (gpointer self)
{
	list_tests_test_duplicates_are_retained ((ListTests*) self);
}

static void
_list_tests_test_get_gee_test_case_test_method (gpointer self)
{
	list_tests_test_get ((ListTests*) self);
}

static void
_list_tests_test_set_gee_test_case_test_method (gpointer self)
{
	list_tests_test_set ((ListTests*) self);
}

static void
_list_tests_test_insert_gee_test_case_test_method (gpointer self)
{
	list_tests_test_insert ((ListTests*) self);
}

static void
_list_tests_test_remove_at_gee_test_case_test_method (gpointer self)
{
	list_tests_test_remove_at ((ListTests*) self);
}

static void
_list_tests_test_index_of_gee_test_case_test_method (gpointer self)
{
	list_tests_test_index_of ((ListTests*) self);
}

static void
_list_tests_test_first_gee_test_case_test_method (gpointer self)
{
	list_tests_test_first ((ListTests*) self);
}

static void
_list_tests_test_last_gee_test_case_test_method (gpointer self)
{
	list_tests_test_last ((ListTests*) self);
}

static void
_list_tests_test_insert_all_gee_test_case_test_method (gpointer self)
{
	list_tests_test_insert_all ((ListTests*) self);
}

static void
_list_tests_test_slice_gee_test_case_test_method (gpointer self)
{
	list_tests_test_slice ((ListTests*) self);
}

ListTests*
list_tests_construct (GType object_type,
                      const gchar* name)
{
	ListTests * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ListTests*) collection_tests_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] iterator is ordered", _list_tests_test_iterator_is_ordered_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] list iterator", _list_tests_test_list_iterator_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] duplicates are retained", _list_tests_test_duplicates_are_retained_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] get", _list_tests_test_get_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] set", _list_tests_test_set_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] insert", _list_tests_test_insert_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] remove_at", _list_tests_test_remove_at_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] index_of", _list_tests_test_index_of_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] first", _list_tests_test_first_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] last", _list_tests_test_last_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] insert_all", _list_tests_test_insert_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] slice", _list_tests_test_slice_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	return self;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
list_tests_test_iterator_is_ordered (ListTests* self)
{
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeIterator* iterator = NULL;
	GeeList* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	gchar** data = NULL;
	gint _tmp6_ = 0;
	gchar** _tmp7_;
	gint data_length1;
	gint _data_size_;
	guint* idx = NULL;
	gint _tmp8_ = 0;
	guint* _tmp9_;
	gint idx_length1;
	gint _idx_size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	guint* _tmp13_;
	gint _tmp13__length1;
	GeeList* _tmp17_;
	GeeIterator* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	guint* _tmp25_;
	gint _tmp25__length1;
	GeeIterator* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = test_list;
	_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
	iterator = _tmp4_;
	_tmp5_ = iterator;
	_vala_assert (!gee_iterator_next (_tmp5_), "! iterator.next ()");
	_tmp7_ = test_data_get_data (&_tmp6_);
	data = _tmp7_;
	data_length1 = _tmp6_;
	_data_size_ = data_length1;
	_tmp9_ = test_data_get_drawn_numbers (&_tmp8_);
	idx = _tmp9_;
	idx_length1 = _tmp8_;
	_idx_size_ = idx_length1;
	_tmp10_ = data;
	_tmp10__length1 = data_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp10_;
		s_collection_length1 = _tmp10__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				GeeList* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = test_list;
				_tmp12_ = s;
				_vala_assert (gee_collection_add ((GeeCollection*) _tmp11_, _tmp12_), "test_list.add (s)");
			}
		}
	}
	_tmp13_ = idx;
	_tmp13__length1 = idx_length1;
	{
		guint* i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp13_;
		i_collection_length1 = _tmp13__length1;
		for (i_it = 0; i_it < i_collection_length1; i_it = i_it + 1) {
			guint i = 0U;
			i = i_collection[i_it];
			{
				GeeList* _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				_tmp14_ = test_list;
				_tmp15_ = data;
				_tmp15__length1 = data_length1;
				_tmp16_ = _tmp15_[i];
				_vala_assert (gee_collection_add ((GeeCollection*) _tmp14_, _tmp16_), "test_list.add (data[i])");
			}
		}
	}
	_tmp17_ = test_list;
	_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
	_g_object_unref0 (iterator);
	iterator = _tmp18_;
	_tmp19_ = data;
	_tmp19__length1 = data_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp19_;
		s_collection_length1 = _tmp19__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				GeeIterator* _tmp20_;
				GeeIterator* _tmp21_;
				gpointer _tmp22_;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				_tmp20_ = iterator;
				_vala_assert (gee_iterator_next (_tmp20_), "iterator.next()");
				_tmp21_ = iterator;
				_tmp22_ = gee_iterator_get (_tmp21_);
				_tmp23_ = (gchar*) _tmp22_;
				_tmp24_ = s;
				_vala_assert (g_strcmp0 (_tmp23_, _tmp24_) == 0, "iterator.get () == s");
				_g_free0 (_tmp23_);
			}
		}
	}
	_tmp25_ = idx;
	_tmp25__length1 = idx_length1;
	{
		guint* i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp25_;
		i_collection_length1 = _tmp25__length1;
		for (i_it = 0; i_it < i_collection_length1; i_it = i_it + 1) {
			guint i = 0U;
			i = i_collection[i_it];
			{
				GeeIterator* _tmp26_;
				GeeIterator* _tmp27_;
				gpointer _tmp28_;
				gchar* _tmp29_;
				gchar** _tmp30_;
				gint _tmp30__length1;
				const gchar* _tmp31_;
				_tmp26_ = iterator;
				_vala_assert (gee_iterator_next (_tmp26_), "iterator.next()");
				_tmp27_ = iterator;
				_tmp28_ = gee_iterator_get (_tmp27_);
				_tmp29_ = (gchar*) _tmp28_;
				_tmp30_ = data;
				_tmp30__length1 = data_length1;
				_tmp31_ = _tmp30_[i];
				_vala_assert (g_strcmp0 (_tmp29_, _tmp31_) == 0, "iterator.get () == data[i]");
				_g_free0 (_tmp29_);
			}
		}
	}
	_tmp32_ = iterator;
	_vala_assert (!gee_iterator_next (_tmp32_), "! iterator.next ()");
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_list);
}

void
list_tests_test_list_iterator (ListTests* self)
{
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeListIterator* iterator = NULL;
	GeeListIterator* _tmp2_;
	GeeListIterator* _tmp3_;
	GeeListIterator* _tmp4_;
	GeeListIterator* _tmp5_;
	GeeListIterator* _tmp6_;
	GeeListIterator* _tmp7_;
	gpointer _tmp8_;
	gchar* _tmp9_;
	GeeListIterator* _tmp10_;
	GeeListIterator* _tmp11_;
	GeeListIterator* _tmp12_;
	GeeListIterator* _tmp13_;
	gpointer _tmp14_;
	gchar* _tmp15_;
	GeeListIterator* _tmp16_;
	GeeListIterator* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GeeListIterator* _tmp20_;
	GeeListIterator* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GeeListIterator* _tmp24_;
	GeeListIterator* _tmp25_;
	GeeListIterator* _tmp26_;
	gpointer _tmp27_;
	gchar* _tmp28_;
	GeeListIterator* _tmp29_;
	GeeListIterator* _tmp30_;
	GeeListIterator* _tmp31_;
	GeeListIterator* _tmp32_;
	GeeListIterator* _tmp33_;
	GeeListIterator* _tmp34_;
	GeeListIterator* _tmp35_;
	gpointer _tmp36_;
	gchar* _tmp37_;
	GeeListIterator* _tmp38_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_vala_assert (test_list != NULL, "test_list != null");
	_tmp2_ = gee_list_list_iterator (test_list);
	iterator = _tmp2_;
	_tmp3_ = iterator;
	_vala_assert (!gee_iterator_has_next ((GeeIterator*) _tmp3_), "! iterator.has_next ()");
	_tmp4_ = iterator;
	_vala_assert (!gee_iterator_next ((GeeIterator*) _tmp4_), "! iterator.next ()");
	_vala_assert (gee_collection_add ((GeeCollection*) test_list, "one"), "test_list.add (\"one\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_list, "two"), "test_list.add (\"two\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_list, "three"), "test_list.add (\"three\")");
	_tmp5_ = gee_list_list_iterator (test_list);
	_g_object_unref0 (iterator);
	iterator = _tmp5_;
	_tmp6_ = iterator;
	_vala_assert (gee_iterator_next ((GeeIterator*) _tmp6_), "iterator.next()");
	_tmp7_ = iterator;
	_tmp8_ = gee_iterator_get ((GeeIterator*) _tmp7_);
	_tmp9_ = (gchar*) _tmp8_;
	_vala_assert (g_strcmp0 (_tmp9_, "one") == 0, "iterator.get () == \"one\"");
	_g_free0 (_tmp9_);
	_tmp10_ = iterator;
	_vala_assert (gee_list_iterator_index (_tmp10_) == 0, "iterator.index () == 0");
	_tmp11_ = iterator;
	gee_list_iterator_set (_tmp11_, "new one");
	_tmp12_ = iterator;
	_vala_assert (gee_iterator_next ((GeeIterator*) _tmp12_), "iterator.next()");
	_tmp13_ = iterator;
	_tmp14_ = gee_iterator_get ((GeeIterator*) _tmp13_);
	_tmp15_ = (gchar*) _tmp14_;
	_vala_assert (g_strcmp0 (_tmp15_, "two") == 0, "iterator.get () == \"two\"");
	_g_free0 (_tmp15_);
	_tmp16_ = iterator;
	_vala_assert (gee_list_iterator_index (_tmp16_) == 1, "iterator.index () == 1");
	_tmp17_ = iterator;
	gee_list_iterator_set (_tmp17_, "new two");
	_tmp18_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp19_ = _tmp18_;
	_vala_assert (_tmp19_ == 3, "test_list.size == 3");
	_tmp20_ = iterator;
	_vala_assert (gee_list_iterator_index (_tmp20_) == 1, "iterator.index () == 1");
	_tmp21_ = iterator;
	gee_list_iterator_add (_tmp21_, "after two");
	_tmp22_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp23_ = _tmp22_;
	_vala_assert (_tmp23_ == 4, "test_list.size == 4");
	_tmp24_ = iterator;
	_vala_assert (gee_list_iterator_index (_tmp24_) == 2, "iterator.index () == 2");
	_tmp25_ = iterator;
	_vala_assert (gee_iterator_next ((GeeIterator*) _tmp25_), "iterator.next()");
	_tmp26_ = iterator;
	_tmp27_ = gee_iterator_get ((GeeIterator*) _tmp26_);
	_tmp28_ = (gchar*) _tmp27_;
	_vala_assert (g_strcmp0 (_tmp28_, "three") == 0, "iterator.get () == \"three\"");
	_g_free0 (_tmp28_);
	_tmp29_ = iterator;
	_vala_assert (gee_list_iterator_index (_tmp29_) == 3, "iterator.index () == 3");
	_tmp30_ = iterator;
	gee_list_iterator_set (_tmp30_, "new three");
	_tmp31_ = iterator;
	_vala_assert (!gee_iterator_has_next ((GeeIterator*) _tmp31_), "! iterator.has_next ()");
	_tmp32_ = iterator;
	_vala_assert (!gee_iterator_next ((GeeIterator*) _tmp32_), "! iterator.next ()");
	_tmp33_ = gee_list_list_iterator (test_list);
	_g_object_unref0 (iterator);
	iterator = _tmp33_;
	_tmp34_ = iterator;
	_vala_assert (gee_iterator_next ((GeeIterator*) _tmp34_), "iterator.next ()");
	_tmp35_ = iterator;
	_tmp36_ = gee_iterator_get ((GeeIterator*) _tmp35_);
	_tmp37_ = (gchar*) _tmp36_;
	_vala_assert (g_strcmp0 (_tmp37_, "new one") == 0, "iterator.get () == \"new one\"");
	_g_free0 (_tmp37_);
	_tmp38_ = iterator;
	_vala_assert (gee_list_iterator_index (_tmp38_) == 0, "iterator.index () == 0");
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_list);
}

static void
list_tests_real_test_duplicates_are_retained (ListTests* self)
{
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_vala_assert (test_list != NULL, "test_list != null");
	_vala_assert (gee_collection_add ((GeeCollection*) test_list, "one"), "test_list.add (\"one\")");
	_vala_assert (gee_collection_contains ((GeeCollection*) test_list, "one"), "test_list.contains (\"one\")");
	_tmp2_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_ == 1, "test_list.size == 1");
	_vala_assert (gee_collection_add ((GeeCollection*) test_list, "one"), "test_list.add (\"one\")");
	_vala_assert (gee_collection_contains ((GeeCollection*) test_list, "one"), "test_list.contains (\"one\")");
	_tmp4_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_ == 2, "test_list.size == 2");
	_vala_assert (gee_collection_add ((GeeCollection*) test_list, "one"), "test_list.add (\"one\")");
	_vala_assert (gee_collection_contains ((GeeCollection*) test_list, "one"), "test_list.contains (\"one\")");
	_tmp6_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp7_ == 3, "test_list.size == 3");
	_vala_assert (gee_collection_remove ((GeeCollection*) test_list, "one"), "test_list.remove (\"one\")");
	_vala_assert (gee_collection_contains ((GeeCollection*) test_list, "one"), "test_list.contains (\"one\")");
	_tmp8_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_ == 2, "test_list.size == 2");
	_vala_assert (gee_collection_remove ((GeeCollection*) test_list, "one"), "test_list.remove (\"one\")");
	_vala_assert (gee_collection_contains ((GeeCollection*) test_list, "one"), "test_list.contains (\"one\")");
	_tmp10_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp11_ = _tmp10_;
	_vala_assert (_tmp11_ == 1, "test_list.size == 1");
	_vala_assert (gee_collection_remove ((GeeCollection*) test_list, "one"), "test_list.remove (\"one\")");
	_vala_assert (!gee_collection_contains ((GeeCollection*) test_list, "one"), "!test_list.contains (\"one\")");
	_tmp12_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp13_ = _tmp12_;
	_vala_assert (_tmp13_ == 0, "test_list.size == 0");
	_g_object_unref0 (test_list);
}

void
list_tests_test_duplicates_are_retained (ListTests* self)
{
	ListTestsClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LIST_TESTS_GET_CLASS (self);
	if (_klass_->test_duplicates_are_retained) {
		_klass_->test_duplicates_are_retained (self);
	}
}

void
list_tests_test_get (ListTests* self)
{
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	gchar** data = NULL;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint data_length1;
	gint _data_size_;
	guint* idx = NULL;
	gint _tmp4_ = 0;
	guint* _tmp5_;
	gint idx_length1;
	gint _idx_size_;
	GeeList* _tmp6_;
	GeeList* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	GeeList* _tmp13_;
	gpointer _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	guint* _tmp30_;
	gint _tmp30__length1;
	GeeList* _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp3_ = test_data_get_data (&_tmp2_);
	data = _tmp3_;
	data_length1 = _tmp2_;
	_data_size_ = data_length1;
	_tmp5_ = test_data_get_drawn_numbers (&_tmp4_);
	idx = _tmp5_;
	idx_length1 = _tmp4_;
	_idx_size_ = idx_length1;
	_tmp6_ = test_list;
	_vala_assert (_tmp6_ != NULL, "test_list != null");
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp7_;
		gpointer _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = test_list;
		_tmp8_ = gee_list_get (_tmp7_, 0);
		_tmp9_ = (gchar*) _tmp8_;
		_g_free0 (_tmp9_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp10_ = test_list;
	_tmp11_ = data;
	_tmp11__length1 = data_length1;
	_tmp12_ = _tmp11_[0];
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp10_, _tmp12_), "test_list.add (data[0])");
	_tmp13_ = test_list;
	_tmp14_ = gee_list_get (_tmp13_, 0);
	_tmp15_ = (gchar*) _tmp14_;
	_tmp16_ = data;
	_tmp16__length1 = data_length1;
	_tmp17_ = _tmp16_[0];
	_vala_assert (g_strcmp0 (_tmp15_, _tmp17_) == 0, "test_list.get (0) == data[0]");
	_g_free0 (_tmp15_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp18_;
		gpointer _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = test_list;
		_tmp19_ = gee_list_get (_tmp18_, 1);
		_tmp20_ = (gchar*) _tmp19_;
		_g_free0 (_tmp20_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp21_;
		gpointer _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = test_list;
		_tmp22_ = gee_list_get (_tmp21_, -1);
		_tmp23_ = (gchar*) _tmp22_;
		_g_free0 (_tmp23_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				gchar** _tmp26_;
				gint _tmp26__length1;
				GeeList* _tmp27_;
				gchar** _tmp28_;
				gint _tmp28__length1;
				const gchar* _tmp29_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				_tmp26_ = data;
				_tmp26__length1 = data_length1;
				if (!(i < _tmp26__length1)) {
					break;
				}
				_tmp27_ = test_list;
				_tmp28_ = data;
				_tmp28__length1 = data_length1;
				_tmp29_ = _tmp28_[i];
				_vala_assert (gee_collection_add ((GeeCollection*) _tmp27_, _tmp29_), "test_list.add (data[i])");
			}
		}
	}
	_tmp30_ = idx;
	_tmp30__length1 = idx_length1;
	{
		guint* j_collection = NULL;
		gint j_collection_length1 = 0;
		gint _j_collection_size_ = 0;
		gint j_it = 0;
		j_collection = _tmp30_;
		j_collection_length1 = _tmp30__length1;
		for (j_it = 0; j_it < j_collection_length1; j_it = j_it + 1) {
			guint j = 0U;
			j = j_collection[j_it];
			{
				GeeList* _tmp31_;
				gpointer _tmp32_;
				gchar* _tmp33_;
				gchar** _tmp34_;
				gint _tmp34__length1;
				const gchar* _tmp35_;
				_tmp31_ = test_list;
				_tmp32_ = gee_list_get (_tmp31_, (gint) j);
				_tmp33_ = (gchar*) _tmp32_;
				_tmp34_ = data;
				_tmp34__length1 = data_length1;
				_tmp35_ = _tmp34_[j];
				_vala_assert (g_strcmp0 (_tmp33_, _tmp35_) == 0, "test_list.get ((int)j) == data[j]");
				_g_free0 (_tmp33_);
			}
		}
	}
	_tmp36_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp36_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp37_;
		gpointer _tmp38_;
		gchar* _tmp39_;
		_tmp37_ = test_list;
		_tmp38_ = gee_list_get (_tmp37_, 0);
		_tmp39_ = (gchar*) _tmp38_;
		_g_free0 (_tmp39_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}

void
list_tests_test_set (ListTests* self)
{
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeList* _tmp10_;
	GeeList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GeeList* _tmp14_;
	gpointer _tmp15_;
	gchar* _tmp16_;
	GeeList* _tmp17_;
	GeeList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	GeeList* _tmp21_;
	gpointer _tmp22_;
	gchar* _tmp23_;
	GeeList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GeeList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = test_list;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_ == 0, "test_list.size == 0");
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp6_;
		_tmp6_ = test_list;
		gee_list_set (_tmp6_, 0, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp7_ = test_list;
	_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_ == 0, "test_list.size == 0");
	_tmp10_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp10_, "one"), "test_list.add (\"one\")");
	_tmp11_ = test_list;
	_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	_vala_assert (_tmp13_ == 1, "test_list.size == 1");
	_tmp14_ = test_list;
	_tmp15_ = gee_list_get (_tmp14_, 0);
	_tmp16_ = (gchar*) _tmp15_;
	_vala_assert (g_strcmp0 (_tmp16_, "one") == 0, "test_list.get (0) == \"one\"");
	_g_free0 (_tmp16_);
	_tmp17_ = test_list;
	gee_list_set (_tmp17_, 0, "two");
	_tmp18_ = test_list;
	_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_vala_assert (_tmp20_ == 1, "test_list.size == 1");
	_tmp21_ = test_list;
	_tmp22_ = gee_list_get (_tmp21_, 0);
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (g_strcmp0 (_tmp23_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp23_);
	_tmp24_ = test_list;
	_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	_vala_assert (_tmp26_ == 1, "test_list.size == 1");
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp27_;
		_tmp27_ = test_list;
		gee_list_set (_tmp27_, 1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp28_ = test_list;
	_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	_vala_assert (_tmp30_ == 1, "test_list.size == 1");
	_g_object_unref0 (test_list);
}

void
list_tests_test_insert (ListTests* self)
{
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GeeList* _tmp11_;
	gpointer _tmp12_;
	gchar* _tmp13_;
	GeeList* _tmp14_;
	GeeList* _tmp15_;
	gpointer _tmp16_;
	gchar* _tmp17_;
	GeeList* _tmp18_;
	gpointer _tmp19_;
	gchar* _tmp20_;
	GeeList* _tmp21_;
	GeeList* _tmp22_;
	gpointer _tmp23_;
	gchar* _tmp24_;
	GeeList* _tmp25_;
	gpointer _tmp26_;
	gchar* _tmp27_;
	GeeList* _tmp28_;
	gpointer _tmp29_;
	gchar* _tmp30_;
	GeeList* _tmp32_;
	GeeList* _tmp33_;
	gpointer _tmp34_;
	gchar* _tmp35_;
	GeeList* _tmp36_;
	gpointer _tmp37_;
	gchar* _tmp38_;
	GeeList* _tmp39_;
	gpointer _tmp40_;
	gchar* _tmp41_;
	GeeList* _tmp42_;
	gpointer _tmp43_;
	gchar* _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp3_;
		_tmp3_ = test_list;
		gee_list_insert (_tmp3_, 1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp4_ = test_list;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_vala_assert (_tmp6_ == 0, "test_list.size == 0");
	_tmp7_ = test_list;
	gee_list_insert (_tmp7_, 0, "one");
	_tmp8_ = test_list;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_assert (_tmp10_ == 1, "test_list.size == 1");
	_tmp11_ = test_list;
	_tmp12_ = gee_list_get (_tmp11_, 0);
	_tmp13_ = (gchar*) _tmp12_;
	_vala_assert (g_strcmp0 (_tmp13_, "one") == 0, "test_list.get (0) == \"one\"");
	_g_free0 (_tmp13_);
	_tmp14_ = test_list;
	gee_list_insert (_tmp14_, 0, "two");
	_tmp15_ = test_list;
	_tmp16_ = gee_list_get (_tmp15_, 0);
	_tmp17_ = (gchar*) _tmp16_;
	_vala_assert (g_strcmp0 (_tmp17_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp17_);
	_tmp18_ = test_list;
	_tmp19_ = gee_list_get (_tmp18_, 1);
	_tmp20_ = (gchar*) _tmp19_;
	_vala_assert (g_strcmp0 (_tmp20_, "one") == 0, "test_list.get (1) == \"one\"");
	_g_free0 (_tmp20_);
	_tmp21_ = test_list;
	gee_list_insert (_tmp21_, 1, "three");
	_tmp22_ = test_list;
	_tmp23_ = gee_list_get (_tmp22_, 0);
	_tmp24_ = (gchar*) _tmp23_;
	_vala_assert (g_strcmp0 (_tmp24_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp24_);
	_tmp25_ = test_list;
	_tmp26_ = gee_list_get (_tmp25_, 1);
	_tmp27_ = (gchar*) _tmp26_;
	_vala_assert (g_strcmp0 (_tmp27_, "three") == 0, "test_list.get (1) == \"three\"");
	_g_free0 (_tmp27_);
	_tmp28_ = test_list;
	_tmp29_ = gee_list_get (_tmp28_, 2);
	_tmp30_ = (gchar*) _tmp29_;
	_vala_assert (g_strcmp0 (_tmp30_, "one") == 0, "test_list.get (2) == \"one\"");
	_g_free0 (_tmp30_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp31_;
		_tmp31_ = test_list;
		gee_list_insert (_tmp31_, 4, "four");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp32_ = test_list;
	gee_list_insert (_tmp32_, 3, "four");
	_tmp33_ = test_list;
	_tmp34_ = gee_list_get (_tmp33_, 0);
	_tmp35_ = (gchar*) _tmp34_;
	_vala_assert (g_strcmp0 (_tmp35_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp35_);
	_tmp36_ = test_list;
	_tmp37_ = gee_list_get (_tmp36_, 1);
	_tmp38_ = (gchar*) _tmp37_;
	_vala_assert (g_strcmp0 (_tmp38_, "three") == 0, "test_list.get (1) == \"three\"");
	_g_free0 (_tmp38_);
	_tmp39_ = test_list;
	_tmp40_ = gee_list_get (_tmp39_, 2);
	_tmp41_ = (gchar*) _tmp40_;
	_vala_assert (g_strcmp0 (_tmp41_, "one") == 0, "test_list.get (2) == \"one\"");
	_g_free0 (_tmp41_);
	_tmp42_ = test_list;
	_tmp43_ = gee_list_get (_tmp42_, 3);
	_tmp44_ = (gchar*) _tmp43_;
	_vala_assert (g_strcmp0 (_tmp44_, "four") == 0, "test_list.get (3) == \"four\"");
	_g_free0 (_tmp44_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp45_;
		_tmp45_ = test_list;
		gee_list_insert (_tmp45_, -1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}

void
list_tests_test_remove_at (ListTests* self)
{
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gchar** data = NULL;
	gint _tmp9_ = 0;
	gchar** _tmp10_;
	gint data_length1;
	gint _data_size_;
	guint* idx = NULL;
	gint _tmp11_ = 0;
	guint* _tmp12_;
	gint idx_length1;
	gint _idx_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GeeList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GeeList* _tmp20_;
	gpointer _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	GeeList* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	GeeList* _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	gpointer _tmp39_;
	gchar* _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar** _tmp42_;
	gint _tmp42__length1;
	const gchar* _tmp43_;
	GeeList* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length1;
	guint expected_size = 0U;
	gchar** _tmp56_;
	gint _tmp56__length1;
	gint current_idx = 0;
	GeeList* _tmp107_;
	gint _tmp108_;
	gint _tmp109_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp3_;
		gpointer _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = test_list;
		_tmp4_ = gee_list_remove_at (_tmp3_, 0);
		_tmp5_ = (gchar*) _tmp4_;
		_g_free0 (_tmp5_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp6_;
		gpointer _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = test_list;
		_tmp7_ = gee_list_remove_at (_tmp6_, 1);
		_tmp8_ = (gchar*) _tmp7_;
		_g_free0 (_tmp8_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp10_ = test_data_get_data (&_tmp9_);
	data = _tmp10_;
	data_length1 = _tmp9_;
	_data_size_ = data_length1;
	_tmp12_ = test_data_get_drawn_numbers (&_tmp11_);
	idx = _tmp12_;
	idx_length1 = _tmp11_;
	_idx_size_ = idx_length1;
	_tmp13_ = data;
	_tmp13__length1 = data_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp13_;
		s_collection_length1 = _tmp13__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				GeeList* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = test_list;
				_tmp15_ = s;
				_vala_assert (gee_collection_add ((GeeCollection*) _tmp14_, _tmp15_), "test_list.add (s)");
			}
		}
	}
	_tmp16_ = test_list;
	_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = data;
	_tmp19__length1 = data_length1;
	_vala_assert (_tmp18_ == _tmp19__length1, "test_list.size == data.length");
	_tmp20_ = test_list;
	_tmp21_ = gee_list_remove_at (_tmp20_, 0);
	_tmp22_ = (gchar*) _tmp21_;
	_tmp23_ = data;
	_tmp23__length1 = data_length1;
	_tmp24_ = _tmp23_[0];
	_vala_assert (g_strcmp0 (_tmp22_, _tmp24_) == 0, "test_list.remove_at (0) == data[0]");
	_g_free0 (_tmp22_);
	_tmp25_ = test_list;
	_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = data;
	_tmp28__length1 = data_length1;
	_vala_assert (_tmp27_ == (_tmp28__length1 - 1), "test_list.size == data.length - 1");
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				gchar** _tmp31_;
				gint _tmp31__length1;
				GeeList* _tmp32_;
				gpointer _tmp33_;
				gchar* _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				const gchar* _tmp36_;
				if (!_tmp29_) {
					gint _tmp30_;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp31_ = data;
				_tmp31__length1 = data_length1;
				if (!(i < (_tmp31__length1 - 1))) {
					break;
				}
				_tmp32_ = test_list;
				_tmp33_ = gee_list_get (_tmp32_, i - 1);
				_tmp34_ = (gchar*) _tmp33_;
				_tmp35_ = data;
				_tmp35__length1 = data_length1;
				_tmp36_ = _tmp35_[i];
				_vala_assert (g_strcmp0 (_tmp34_, _tmp36_) == 0, "test_list.get (i - 1) == data[i]");
				_g_free0 (_tmp34_);
			}
		}
	}
	_tmp37_ = test_list;
	_tmp38_ = data;
	_tmp38__length1 = data_length1;
	_tmp39_ = gee_list_remove_at (_tmp37_, _tmp38__length1 - 2);
	_tmp40_ = (gchar*) _tmp39_;
	_tmp41_ = data;
	_tmp41__length1 = data_length1;
	_tmp42_ = data;
	_tmp42__length1 = data_length1;
	_tmp43_ = _tmp41_[_tmp42__length1 - 1];
	_vala_assert (g_strcmp0 (_tmp40_, _tmp43_) == 0, "test_list.remove_at (data.length - 2) == data[data.length - 1]");
	_g_free0 (_tmp40_);
	_tmp44_ = test_list;
	_tmp45_ = gee_collection_get_size ((GeeCollection*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = data;
	_tmp47__length1 = data_length1;
	_vala_assert (_tmp46_ == (_tmp47__length1 - 2), "test_list.size == data.length - 2");
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp48_ = FALSE;
			_tmp48_ = TRUE;
			while (TRUE) {
				gchar** _tmp50_;
				gint _tmp50__length1;
				GeeList* _tmp51_;
				gpointer _tmp52_;
				gchar* _tmp53_;
				gchar** _tmp54_;
				gint _tmp54__length1;
				const gchar* _tmp55_;
				if (!_tmp48_) {
					gint _tmp49_;
					_tmp49_ = i;
					i = _tmp49_ + 1;
				}
				_tmp48_ = FALSE;
				_tmp50_ = data;
				_tmp50__length1 = data_length1;
				if (!(i < (_tmp50__length1 - 2))) {
					break;
				}
				_tmp51_ = test_list;
				_tmp52_ = gee_list_get (_tmp51_, i - 1);
				_tmp53_ = (gchar*) _tmp52_;
				_tmp54_ = data;
				_tmp54__length1 = data_length1;
				_tmp55_ = _tmp54_[i];
				_vala_assert (g_strcmp0 (_tmp53_, _tmp55_) == 0, "test_list.get (i - 1) == data[i]");
				_g_free0 (_tmp53_);
			}
		}
	}
	_tmp56_ = data;
	_tmp56__length1 = data_length1;
	expected_size = (guint) (_tmp56__length1 - 2);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp57_ = FALSE;
			_tmp57_ = TRUE;
			while (TRUE) {
				guint* _tmp59_;
				gint _tmp59__length1;
				gint to_remove = 0;
				guint* _tmp60_;
				gint _tmp60__length1;
				guint _tmp61_;
				gboolean _tmp62_ = FALSE;
				guint* _tmp63_;
				gint _tmp63__length1;
				guint _tmp64_;
				gchar** _tmp65_;
				gint _tmp65__length1;
				GeeList* _tmp81_;
				gpointer _tmp82_;
				gchar* _tmp83_;
				gchar** _tmp84_;
				gint _tmp84__length1;
				guint* _tmp85_;
				gint _tmp85__length1;
				guint _tmp86_;
				const gchar* _tmp87_;
				GeeList* _tmp88_;
				gint _tmp89_;
				gint _tmp90_;
				guint _tmp91_;
				if (!_tmp57_) {
					guint _tmp58_;
					_tmp58_ = i;
					i = _tmp58_ + 1;
				}
				_tmp57_ = FALSE;
				_tmp59_ = idx;
				_tmp59__length1 = idx_length1;
				if (!(i < ((guint) _tmp59__length1))) {
					break;
				}
				_tmp60_ = idx;
				_tmp60__length1 = idx_length1;
				_tmp61_ = _tmp60_[i];
				to_remove = ((gint) _tmp61_) - 1;
				_tmp63_ = idx;
				_tmp63__length1 = idx_length1;
				_tmp64_ = _tmp63_[i];
				_tmp65_ = data;
				_tmp65__length1 = data_length1;
				if (_tmp64_ == ((guint) (_tmp65__length1 - 1))) {
					_tmp62_ = TRUE;
				} else {
					guint* _tmp66_;
					gint _tmp66__length1;
					guint _tmp67_;
					_tmp66_ = idx;
					_tmp66__length1 = idx_length1;
					_tmp67_ = _tmp66_[i];
					_tmp62_ = _tmp67_ == ((guint) 0);
				}
				if (_tmp62_) {
					continue;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp68_ = FALSE;
						_tmp68_ = TRUE;
						while (TRUE) {
							guint* _tmp70_;
							gint _tmp70__length1;
							guint _tmp71_;
							guint* _tmp72_;
							gint _tmp72__length1;
							guint _tmp73_;
							if (!_tmp68_) {
								guint _tmp69_;
								_tmp69_ = j;
								j = _tmp69_ + 1;
							}
							_tmp68_ = FALSE;
							if (!(j < i)) {
								break;
							}
							_tmp70_ = idx;
							_tmp70__length1 = idx_length1;
							_tmp71_ = _tmp70_[j];
							_tmp72_ = idx;
							_tmp72__length1 = idx_length1;
							_tmp73_ = _tmp72_[i];
							if (_tmp71_ < _tmp73_) {
								gboolean _tmp74_ = FALSE;
								guint* _tmp75_;
								gint _tmp75__length1;
								guint _tmp76_;
								gchar** _tmp77_;
								gint _tmp77__length1;
								gint _tmp80_;
								_tmp75_ = idx;
								_tmp75__length1 = idx_length1;
								_tmp76_ = _tmp75_[j];
								_tmp77_ = data;
								_tmp77__length1 = data_length1;
								if (_tmp76_ == ((guint) (_tmp77__length1 - 1))) {
									_tmp74_ = TRUE;
								} else {
									guint* _tmp78_;
									gint _tmp78__length1;
									guint _tmp79_;
									_tmp78_ = idx;
									_tmp78__length1 = idx_length1;
									_tmp79_ = _tmp78_[j];
									_tmp74_ = _tmp79_ == ((guint) 0);
								}
								if (_tmp74_) {
									continue;
								}
								_tmp80_ = to_remove;
								to_remove = _tmp80_ - 1;
							}
						}
					}
				}
				_tmp81_ = test_list;
				_tmp82_ = gee_list_remove_at (_tmp81_, to_remove);
				_tmp83_ = (gchar*) _tmp82_;
				_tmp84_ = data;
				_tmp84__length1 = data_length1;
				_tmp85_ = idx;
				_tmp85__length1 = idx_length1;
				_tmp86_ = _tmp85_[i];
				_tmp87_ = _tmp84_[_tmp86_];
				_vala_assert (g_strcmp0 (_tmp83_, _tmp87_) == 0, "test_list.remove_at (to_remove) == data[idx[i]]");
				_g_free0 (_tmp83_);
				_tmp88_ = test_list;
				_tmp89_ = gee_collection_get_size ((GeeCollection*) _tmp88_);
				_tmp90_ = _tmp89_;
				expected_size = expected_size - 1;
				_tmp91_ = expected_size;
				_vala_assert (((guint) _tmp90_) == _tmp91_, "test_list.size == --expected_size");
			}
		}
	}
	current_idx = 0;
	{
		guint i = 0U;
		i = (guint) 1;
		{
			gboolean _tmp92_ = FALSE;
			_tmp92_ = TRUE;
			while (TRUE) {
				gchar** _tmp94_;
				gint _tmp94__length1;
				gboolean skip = FALSE;
				GeeList* _tmp100_;
				gint _tmp101_;
				gpointer _tmp102_;
				gchar* _tmp103_;
				gchar** _tmp104_;
				gint _tmp104__length1;
				guint _tmp105_;
				const gchar* _tmp106_;
				if (!_tmp92_) {
					guint _tmp93_;
					_tmp93_ = i;
					i = _tmp93_ + 1;
				}
				_tmp92_ = FALSE;
				_tmp94_ = data;
				_tmp94__length1 = data_length1;
				if (!(i < ((guint) (_tmp94__length1 - 1)))) {
					break;
				}
				skip = FALSE;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp95_ = FALSE;
						_tmp95_ = TRUE;
						while (TRUE) {
							guint* _tmp97_;
							gint _tmp97__length1;
							guint* _tmp98_;
							gint _tmp98__length1;
							guint _tmp99_;
							if (!_tmp95_) {
								gint _tmp96_;
								_tmp96_ = j;
								j = _tmp96_ + 1;
							}
							_tmp95_ = FALSE;
							_tmp97_ = idx;
							_tmp97__length1 = idx_length1;
							if (!(j < _tmp97__length1)) {
								break;
							}
							_tmp98_ = idx;
							_tmp98__length1 = idx_length1;
							_tmp99_ = _tmp98_[j];
							if (i == _tmp99_) {
								skip = TRUE;
								break;
							}
						}
					}
				}
				if (skip) {
					continue;
				}
				_tmp100_ = test_list;
				_tmp101_ = current_idx;
				current_idx = _tmp101_ + 1;
				_tmp102_ = gee_list_get (_tmp100_, _tmp101_);
				_tmp103_ = (gchar*) _tmp102_;
				_tmp104_ = data;
				_tmp104__length1 = data_length1;
				_tmp105_ = i;
				_tmp106_ = _tmp104_[_tmp105_];
				_vala_assert (g_strcmp0 (_tmp103_, _tmp106_) == 0, "test_list.get(current_idx++) == data[i]");
				_g_free0 (_tmp103_);
			}
		}
	}
	_tmp107_ = test_list;
	_tmp108_ = gee_collection_get_size ((GeeCollection*) _tmp107_);
	_tmp109_ = _tmp108_;
	_vala_assert (_tmp109_ == current_idx, "test_list.size == current_idx");
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp110_;
		gpointer _tmp111_;
		gchar* _tmp112_;
		_tmp110_ = test_list;
		_tmp111_ = gee_list_remove_at (_tmp110_, current_idx);
		_tmp112_ = (gchar*) _tmp111_;
		_g_free0 (_tmp112_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp113_;
		gpointer _tmp114_;
		gchar* _tmp115_;
		_tmp113_ = test_list;
		_tmp114_ = gee_list_remove_at (_tmp113_, -1);
		_tmp115_ = (gchar*) _tmp114_;
		_g_free0 (_tmp115_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}

void
list_tests_test_index_of (ListTests* self)
{
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	gchar** data = NULL;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint data_length1;
	gint _data_size_;
	guint* idx = NULL;
	gint _tmp4_ = 0;
	guint* _tmp5_;
	gint idx_length1;
	gint _idx_size_;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	GeeList* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	GeeList* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	GeeList* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp3_ = test_data_get_data (&_tmp2_);
	data = _tmp3_;
	data_length1 = _tmp2_;
	_data_size_ = data_length1;
	_tmp5_ = test_data_get_drawn_numbers (&_tmp4_);
	idx = _tmp5_;
	idx_length1 = _tmp4_;
	_idx_size_ = idx_length1;
	_tmp6_ = test_list;
	_vala_assert (_tmp6_ != NULL, "test_list != null");
	_tmp7_ = test_list;
	_tmp8_ = data;
	_tmp8__length1 = data_length1;
	_tmp9_ = _tmp8_[0];
	_vala_assert (gee_list_index_of (_tmp7_, _tmp9_) == -1, "test_list.index_of (data[0]) == -1");
	_tmp10_ = test_list;
	_tmp11_ = data;
	_tmp11__length1 = data_length1;
	_tmp12_ = _tmp11_[0];
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp10_, _tmp12_), "test_list.add (data[0])");
	_tmp13_ = test_list;
	_tmp14_ = data;
	_tmp14__length1 = data_length1;
	_tmp15_ = _tmp14_[0];
	_vala_assert (gee_list_index_of (_tmp13_, _tmp15_) == 0, "test_list.index_of (data[0]) == 0");
	_tmp16_ = test_list;
	_tmp17_ = data;
	_tmp17__length1 = data_length1;
	_tmp18_ = _tmp17_[1];
	_vala_assert (gee_list_index_of (_tmp16_, _tmp18_) == -1, "test_list.index_of (data[1]) == -1");
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				gchar** _tmp21_;
				gint _tmp21__length1;
				GeeList* _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				guint* _tmp25_;
				gint _tmp25__length1;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp21_ = data;
				_tmp21__length1 = data_length1;
				if (!(i < _tmp21__length1)) {
					break;
				}
				_tmp22_ = test_list;
				_tmp23_ = data;
				_tmp23__length1 = data_length1;
				_tmp24_ = _tmp23_[i];
				_vala_assert (gee_collection_add ((GeeCollection*) _tmp22_, _tmp24_), "test_list.add (data[i])");
				_tmp25_ = idx;
				_tmp25__length1 = idx_length1;
				{
					guint* j_collection = NULL;
					gint j_collection_length1 = 0;
					gint _j_collection_size_ = 0;
					gint j_it = 0;
					j_collection = _tmp25_;
					j_collection_length1 = _tmp25__length1;
					for (j_it = 0; j_it < j_collection_length1; j_it = j_it + 1) {
						guint j = 0U;
						j = j_collection[j_it];
						{
							if (j <= ((guint) i)) {
								GeeList* _tmp26_;
								gchar** _tmp27_;
								gint _tmp27__length1;
								const gchar* _tmp28_;
								_tmp26_ = test_list;
								_tmp27_ = data;
								_tmp27__length1 = data_length1;
								_tmp28_ = _tmp27_[j];
								_vala_assert (((guint) gee_list_index_of (_tmp26_, _tmp28_)) == j, "test_list.index_of (data[j]) == j");
							} else {
								GeeList* _tmp29_;
								gchar** _tmp30_;
								gint _tmp30__length1;
								const gchar* _tmp31_;
								_tmp29_ = test_list;
								_tmp30_ = data;
								_tmp30__length1 = data_length1;
								_tmp31_ = _tmp30_[j];
								_vala_assert (gee_list_index_of (_tmp29_, _tmp31_) == -1, "test_list.index_of (data[j]) == -1");
							}
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (test_list);
}

void
list_tests_test_first (ListTests* self)
{
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	gpointer _tmp8_;
	gchar* _tmp9_;
	GeeList* _tmp10_;
	gpointer _tmp11_;
	gchar* _tmp12_;
	GeeList* _tmp13_;
	gpointer _tmp14_;
	gchar* _tmp15_;
	GeeList* _tmp16_;
	GeeList* _tmp17_;
	GeeList* _tmp18_;
	gpointer _tmp19_;
	gchar* _tmp20_;
	GeeList* _tmp21_;
	gpointer _tmp22_;
	gchar* _tmp23_;
	GeeList* _tmp24_;
	gpointer _tmp25_;
	gchar* _tmp26_;
	GeeList* _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp3_;
		gpointer _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = test_list;
		_tmp4_ = gee_list_first (_tmp3_);
		_tmp5_ = (gchar*) _tmp4_;
		_g_free0 (_tmp5_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp6_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp6_, "one"), "test_list.add (\"one\")");
	_tmp7_ = test_list;
	_tmp8_ = gee_list_first (_tmp7_);
	_tmp9_ = (gchar*) _tmp8_;
	_vala_assert (g_strcmp0 (_tmp9_, "one") == 0, "test_list.first () == \"one\"");
	_g_free0 (_tmp9_);
	_tmp10_ = test_list;
	_tmp11_ = gee_list_first (_tmp10_);
	_tmp12_ = (gchar*) _tmp11_;
	_tmp13_ = test_list;
	_tmp14_ = gee_list_get (_tmp13_, 0);
	_tmp15_ = (gchar*) _tmp14_;
	_vala_assert (g_strcmp0 (_tmp12_, _tmp15_) == 0, "test_list.first () == test_list.get (0)");
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	_tmp16_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp16_, "two"), "test_list.add (\"two\")");
	_tmp17_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp17_, "three"), "test_list.add (\"three\")");
	_tmp18_ = test_list;
	_tmp19_ = gee_list_first (_tmp18_);
	_tmp20_ = (gchar*) _tmp19_;
	_vala_assert (g_strcmp0 (_tmp20_, "one") == 0, "test_list.first () == \"one\"");
	_g_free0 (_tmp20_);
	_tmp21_ = test_list;
	_tmp22_ = gee_list_first (_tmp21_);
	_tmp23_ = (gchar*) _tmp22_;
	_tmp24_ = test_list;
	_tmp25_ = gee_list_get (_tmp24_, 0);
	_tmp26_ = (gchar*) _tmp25_;
	_vala_assert (g_strcmp0 (_tmp23_, _tmp26_) == 0, "test_list.first () == test_list.get (0)");
	_g_free0 (_tmp26_);
	_g_free0 (_tmp23_);
	_tmp27_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp27_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp28_;
		gpointer _tmp29_;
		gchar* _tmp30_;
		_tmp28_ = test_list;
		_tmp29_ = gee_list_first (_tmp28_);
		_tmp30_ = (gchar*) _tmp29_;
		_g_free0 (_tmp30_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}

void
list_tests_test_last (ListTests* self)
{
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	gpointer _tmp8_;
	gchar* _tmp9_;
	GeeList* _tmp10_;
	gpointer _tmp11_;
	gchar* _tmp12_;
	GeeList* _tmp13_;
	GeeList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gpointer _tmp17_;
	gchar* _tmp18_;
	GeeList* _tmp19_;
	GeeList* _tmp20_;
	GeeList* _tmp21_;
	gpointer _tmp22_;
	gchar* _tmp23_;
	GeeList* _tmp24_;
	gpointer _tmp25_;
	gchar* _tmp26_;
	GeeList* _tmp27_;
	GeeList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gpointer _tmp31_;
	gchar* _tmp32_;
	GeeList* _tmp33_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp3_;
		gpointer _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = test_list;
		_tmp4_ = gee_list_last (_tmp3_);
		_tmp5_ = (gchar*) _tmp4_;
		_g_free0 (_tmp5_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp6_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp6_, "one"), "test_list.add (\"one\")");
	_tmp7_ = test_list;
	_tmp8_ = gee_list_last (_tmp7_);
	_tmp9_ = (gchar*) _tmp8_;
	_vala_assert (g_strcmp0 (_tmp9_, "one") == 0, "test_list.last () == \"one\"");
	_g_free0 (_tmp9_);
	_tmp10_ = test_list;
	_tmp11_ = gee_list_last (_tmp10_);
	_tmp12_ = (gchar*) _tmp11_;
	_tmp13_ = test_list;
	_tmp14_ = test_list;
	_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = gee_list_get (_tmp13_, _tmp16_ - 1);
	_tmp18_ = (gchar*) _tmp17_;
	_vala_assert (g_strcmp0 (_tmp12_, _tmp18_) == 0, "test_list.last () == test_list.get (test_list.size - 1)");
	_g_free0 (_tmp18_);
	_g_free0 (_tmp12_);
	_tmp19_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp19_, "two"), "test_list.add (\"two\")");
	_tmp20_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp20_, "three"), "test_list.add (\"three\")");
	_tmp21_ = test_list;
	_tmp22_ = gee_list_last (_tmp21_);
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (g_strcmp0 (_tmp23_, "three") == 0, "test_list.last () == \"three\"");
	_g_free0 (_tmp23_);
	_tmp24_ = test_list;
	_tmp25_ = gee_list_last (_tmp24_);
	_tmp26_ = (gchar*) _tmp25_;
	_tmp27_ = test_list;
	_tmp28_ = test_list;
	_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = gee_list_get (_tmp27_, _tmp30_ - 1);
	_tmp32_ = (gchar*) _tmp31_;
	_vala_assert (g_strcmp0 (_tmp26_, _tmp32_) == 0, "test_list.last () == test_list.get (test_list.size - 1)");
	_g_free0 (_tmp32_);
	_g_free0 (_tmp26_);
	_tmp33_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp33_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp34_;
		gpointer _tmp35_;
		gchar* _tmp36_;
		_tmp34_ = test_list;
		_tmp35_ = gee_list_last (_tmp34_);
		_tmp36_ = (gchar*) _tmp35_;
		_g_free0 (_tmp36_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}

void
list_tests_test_insert_all (ListTests* self)
{
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeArrayList* dummy = NULL;
	GeeArrayList* _tmp3_;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeArrayList* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GeeList* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GeeArrayList* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GeeList* _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* _tmp23_;
	GeeArrayList* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeList* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	GeeArrayList* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GeeList* _tmp32_;
	GeeArrayList* _tmp33_;
	GeeList* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	GeeArrayList* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	GeeList* _tmp40_;
	GeeArrayList* _tmp41_;
	GeeArrayList* _tmp42_;
	GeeArrayList* _tmp43_;
	GeeArrayList* _tmp44_;
	GeeList* _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	GeeList* _tmp50_;
	GeeArrayList* _tmp51_;
	GeeList* _tmp52_;
	GeeList* _tmp53_;
	GeeList* _tmp54_;
	GeeArrayList* _tmp55_;
	GeeArrayList* _tmp56_;
	GeeArrayList* _tmp57_;
	GeeList* _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	GeeArrayList* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	GeeList* _tmp64_;
	GeeArrayList* _tmp65_;
	GeeList* _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	GeeArrayList* _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	GeeList* _tmp72_;
	gpointer _tmp73_;
	gchar* _tmp74_;
	GeeList* _tmp75_;
	gpointer _tmp76_;
	gchar* _tmp77_;
	GeeList* _tmp78_;
	gpointer _tmp79_;
	gchar* _tmp80_;
	GeeList* _tmp81_;
	gpointer _tmp82_;
	gchar* _tmp83_;
	GeeList* _tmp84_;
	gpointer _tmp85_;
	gchar* _tmp86_;
	GeeList* _tmp87_;
	gpointer _tmp88_;
	gchar* _tmp89_;
	GeeList* _tmp90_;
	GeeArrayList* _tmp91_;
	GeeList* _tmp92_;
	GeeList* _tmp93_;
	GeeList* _tmp94_;
	GeeList* _tmp95_;
	GeeArrayList* _tmp96_;
	GeeArrayList* _tmp97_;
	GeeArrayList* _tmp98_;
	GeeList* _tmp99_;
	gint _tmp100_;
	gint _tmp101_;
	GeeArrayList* _tmp102_;
	gint _tmp103_;
	gint _tmp104_;
	GeeList* _tmp105_;
	GeeArrayList* _tmp106_;
	GeeList* _tmp107_;
	gint _tmp108_;
	gint _tmp109_;
	GeeArrayList* _tmp110_;
	gint _tmp111_;
	gint _tmp112_;
	GeeList* _tmp113_;
	gpointer _tmp114_;
	gchar* _tmp115_;
	GeeList* _tmp116_;
	gpointer _tmp117_;
	gchar* _tmp118_;
	GeeList* _tmp119_;
	gpointer _tmp120_;
	gchar* _tmp121_;
	GeeList* _tmp122_;
	gpointer _tmp123_;
	gchar* _tmp124_;
	GeeList* _tmp125_;
	gpointer _tmp126_;
	gchar* _tmp127_;
	GeeList* _tmp128_;
	gpointer _tmp129_;
	gchar* _tmp130_;
	GeeList* _tmp131_;
	gpointer _tmp132_;
	gchar* _tmp133_;
	GeeList* _tmp134_;
	GeeArrayList* _tmp135_;
	GeeList* _tmp136_;
	GeeList* _tmp137_;
	GeeList* _tmp138_;
	GeeArrayList* _tmp139_;
	GeeArrayList* _tmp140_;
	GeeArrayList* _tmp141_;
	GeeList* _tmp142_;
	gint _tmp143_;
	gint _tmp144_;
	GeeArrayList* _tmp145_;
	gint _tmp146_;
	gint _tmp147_;
	GeeList* _tmp148_;
	GeeArrayList* _tmp149_;
	GeeList* _tmp150_;
	gint _tmp151_;
	gint _tmp152_;
	GeeArrayList* _tmp153_;
	gint _tmp154_;
	gint _tmp155_;
	GeeList* _tmp156_;
	gpointer _tmp157_;
	gchar* _tmp158_;
	GeeList* _tmp159_;
	gpointer _tmp160_;
	gchar* _tmp161_;
	GeeList* _tmp162_;
	gpointer _tmp163_;
	gchar* _tmp164_;
	GeeList* _tmp165_;
	gpointer _tmp166_;
	gchar* _tmp167_;
	GeeList* _tmp168_;
	gpointer _tmp169_;
	gchar* _tmp170_;
	GeeList* _tmp171_;
	gpointer _tmp172_;
	gchar* _tmp173_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	dummy = _tmp3_;
	_tmp4_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "zero"), "test_list.add (\"zero\")");
	_tmp5_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "one"), "test_list.add (\"one\")");
	_tmp6_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp6_, "two"), "test_list.add (\"two\")");
	_tmp7_ = test_list;
	_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_ == 3, "test_list.size == 3");
	_tmp10_ = dummy;
	_tmp11_ = gee_collection_get_is_empty ((GeeCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	_vala_assert (_tmp12_, "dummy.is_empty");
	_tmp13_ = test_list;
	_tmp14_ = dummy;
	gee_list_insert_all (_tmp13_, 0, (GeeCollection*) _tmp14_);
	_tmp15_ = test_list;
	_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	_vala_assert (_tmp17_ == 3, "test_list.size == 3");
	_tmp18_ = dummy;
	_tmp19_ = gee_collection_get_is_empty ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_vala_assert (_tmp20_, "dummy.is_empty");
	_tmp21_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp21_);
	_tmp22_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp22_);
	_tmp23_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, "zero"), "dummy.add (\"zero\")");
	_tmp24_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, "one"), "dummy.add (\"one\")");
	_tmp25_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, "two"), "dummy.add (\"two\")");
	_tmp26_ = test_list;
	_tmp27_ = gee_collection_get_is_empty ((GeeCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp28_, "test_list.is_empty");
	_tmp29_ = dummy;
	_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
	_tmp31_ = _tmp30_;
	_vala_assert (_tmp31_ == 3, "dummy.size == 3");
	_tmp32_ = test_list;
	_tmp33_ = dummy;
	gee_list_insert_all (_tmp32_, 0, (GeeCollection*) _tmp33_);
	_tmp34_ = test_list;
	_tmp35_ = gee_collection_get_size ((GeeCollection*) _tmp34_);
	_tmp36_ = _tmp35_;
	_vala_assert (_tmp36_ == 3, "test_list.size == 3");
	_tmp37_ = dummy;
	_tmp38_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp37_);
	_tmp39_ = _tmp38_;
	_vala_assert (_tmp39_ == 3, "dummy.size == 3");
	_tmp40_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp40_);
	_tmp41_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp41_);
	_tmp42_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, "zero"), "dummy.add (\"zero\")");
	_tmp43_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, "one"), "dummy.add (\"one\")");
	_tmp44_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, "two"), "dummy.add (\"two\")");
	_tmp45_ = test_list;
	_tmp46_ = gee_collection_get_is_empty ((GeeCollection*) _tmp45_);
	_tmp47_ = _tmp46_;
	_vala_assert (_tmp47_, "test_list.is_empty");
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp48_;
		GeeArrayList* _tmp49_;
		_tmp48_ = test_list;
		_tmp49_ = dummy;
		gee_list_insert_all (_tmp48_, 1, (GeeCollection*) _tmp49_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp50_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp50_);
	_tmp51_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp51_);
	_tmp52_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp52_, "three"), "test_list.add (\"three\")");
	_tmp53_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp53_, "four"), "test_list.add (\"four\")");
	_tmp54_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp54_, "five"), "test_list.add (\"five\")");
	_tmp55_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp55_, "zero"), "dummy.add (\"zero\")");
	_tmp56_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, "one"), "dummy.add (\"one\")");
	_tmp57_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp57_, "two"), "dummy.add (\"two\")");
	_tmp58_ = test_list;
	_tmp59_ = gee_collection_get_size ((GeeCollection*) _tmp58_);
	_tmp60_ = _tmp59_;
	_vala_assert (_tmp60_ == 3, "test_list.size == 3");
	_tmp61_ = dummy;
	_tmp62_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp61_);
	_tmp63_ = _tmp62_;
	_vala_assert (_tmp63_ == 3, "dummy.size == 3");
	_tmp64_ = test_list;
	_tmp65_ = dummy;
	gee_list_insert_all (_tmp64_, 0, (GeeCollection*) _tmp65_);
	_tmp66_ = test_list;
	_tmp67_ = gee_collection_get_size ((GeeCollection*) _tmp66_);
	_tmp68_ = _tmp67_;
	_vala_assert (_tmp68_ == 6, "test_list.size == 6");
	_tmp69_ = dummy;
	_tmp70_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp69_);
	_tmp71_ = _tmp70_;
	_vala_assert (_tmp71_ == 3, "dummy.size == 3");
	_tmp72_ = test_list;
	_tmp73_ = gee_list_get (_tmp72_, 0);
	_tmp74_ = (gchar*) _tmp73_;
	_vala_assert (g_strcmp0 (_tmp74_, "zero") == 0, "test_list.get (0) == \"zero\"");
	_g_free0 (_tmp74_);
	_tmp75_ = test_list;
	_tmp76_ = gee_list_get (_tmp75_, 1);
	_tmp77_ = (gchar*) _tmp76_;
	_vala_assert (g_strcmp0 (_tmp77_, "one") == 0, "test_list.get (1) == \"one\"");
	_g_free0 (_tmp77_);
	_tmp78_ = test_list;
	_tmp79_ = gee_list_get (_tmp78_, 2);
	_tmp80_ = (gchar*) _tmp79_;
	_vala_assert (g_strcmp0 (_tmp80_, "two") == 0, "test_list.get (2) == \"two\"");
	_g_free0 (_tmp80_);
	_tmp81_ = test_list;
	_tmp82_ = gee_list_get (_tmp81_, 3);
	_tmp83_ = (gchar*) _tmp82_;
	_vala_assert (g_strcmp0 (_tmp83_, "three") == 0, "test_list.get (3) == \"three\"");
	_g_free0 (_tmp83_);
	_tmp84_ = test_list;
	_tmp85_ = gee_list_get (_tmp84_, 4);
	_tmp86_ = (gchar*) _tmp85_;
	_vala_assert (g_strcmp0 (_tmp86_, "four") == 0, "test_list.get (4) == \"four\"");
	_g_free0 (_tmp86_);
	_tmp87_ = test_list;
	_tmp88_ = gee_list_get (_tmp87_, 5);
	_tmp89_ = (gchar*) _tmp88_;
	_vala_assert (g_strcmp0 (_tmp89_, "five") == 0, "test_list.get (5) == \"five\"");
	_g_free0 (_tmp89_);
	_tmp90_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp90_);
	_tmp91_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp91_);
	_tmp92_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp92_, "zero"), "test_list.add (\"zero\")");
	_tmp93_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp93_, "one"), "test_list.add (\"one\")");
	_tmp94_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp94_, "five"), "test_list.add (\"five\")");
	_tmp95_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp95_, "six"), "test_list.add (\"six\")");
	_tmp96_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp96_, "two"), "dummy.add (\"two\")");
	_tmp97_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp97_, "three"), "dummy.add (\"three\")");
	_tmp98_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp98_, "four"), "dummy.add (\"four\")");
	_tmp99_ = test_list;
	_tmp100_ = gee_collection_get_size ((GeeCollection*) _tmp99_);
	_tmp101_ = _tmp100_;
	_vala_assert (_tmp101_ == 4, "test_list.size == 4");
	_tmp102_ = dummy;
	_tmp103_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp102_);
	_tmp104_ = _tmp103_;
	_vala_assert (_tmp104_ == 3, "dummy.size == 3");
	_tmp105_ = test_list;
	_tmp106_ = dummy;
	gee_list_insert_all (_tmp105_, 2, (GeeCollection*) _tmp106_);
	_tmp107_ = test_list;
	_tmp108_ = gee_collection_get_size ((GeeCollection*) _tmp107_);
	_tmp109_ = _tmp108_;
	_vala_assert (_tmp109_ == 7, "test_list.size == 7");
	_tmp110_ = dummy;
	_tmp111_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp110_);
	_tmp112_ = _tmp111_;
	_vala_assert (_tmp112_ == 3, "dummy.size == 3");
	_tmp113_ = test_list;
	_tmp114_ = gee_list_get (_tmp113_, 0);
	_tmp115_ = (gchar*) _tmp114_;
	_vala_assert (g_strcmp0 (_tmp115_, "zero") == 0, "test_list.get (0) == \"zero\"");
	_g_free0 (_tmp115_);
	_tmp116_ = test_list;
	_tmp117_ = gee_list_get (_tmp116_, 1);
	_tmp118_ = (gchar*) _tmp117_;
	_vala_assert (g_strcmp0 (_tmp118_, "one") == 0, "test_list.get (1) == \"one\"");
	_g_free0 (_tmp118_);
	_tmp119_ = test_list;
	_tmp120_ = gee_list_get (_tmp119_, 2);
	_tmp121_ = (gchar*) _tmp120_;
	_vala_assert (g_strcmp0 (_tmp121_, "two") == 0, "test_list.get (2) == \"two\"");
	_g_free0 (_tmp121_);
	_tmp122_ = test_list;
	_tmp123_ = gee_list_get (_tmp122_, 3);
	_tmp124_ = (gchar*) _tmp123_;
	_vala_assert (g_strcmp0 (_tmp124_, "three") == 0, "test_list.get (3) == \"three\"");
	_g_free0 (_tmp124_);
	_tmp125_ = test_list;
	_tmp126_ = gee_list_get (_tmp125_, 4);
	_tmp127_ = (gchar*) _tmp126_;
	_vala_assert (g_strcmp0 (_tmp127_, "four") == 0, "test_list.get (4) == \"four\"");
	_g_free0 (_tmp127_);
	_tmp128_ = test_list;
	_tmp129_ = gee_list_get (_tmp128_, 5);
	_tmp130_ = (gchar*) _tmp129_;
	_vala_assert (g_strcmp0 (_tmp130_, "five") == 0, "test_list.get (5) == \"five\"");
	_g_free0 (_tmp130_);
	_tmp131_ = test_list;
	_tmp132_ = gee_list_get (_tmp131_, 6);
	_tmp133_ = (gchar*) _tmp132_;
	_vala_assert (g_strcmp0 (_tmp133_, "six") == 0, "test_list.get (6) == \"six\"");
	_g_free0 (_tmp133_);
	_tmp134_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp134_);
	_tmp135_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp135_);
	_tmp136_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp136_, "zero"), "test_list.add (\"zero\")");
	_tmp137_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp137_, "one"), "test_list.add (\"one\")");
	_tmp138_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp138_, "two"), "test_list.add (\"two\")");
	_tmp139_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp139_, "three"), "dummy.add (\"three\")");
	_tmp140_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp140_, "four"), "dummy.add (\"four\")");
	_tmp141_ = dummy;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) _tmp141_, "five"), "dummy.add (\"five\")");
	_tmp142_ = test_list;
	_tmp143_ = gee_collection_get_size ((GeeCollection*) _tmp142_);
	_tmp144_ = _tmp143_;
	_vala_assert (_tmp144_ == 3, "test_list.size == 3");
	_tmp145_ = dummy;
	_tmp146_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp145_);
	_tmp147_ = _tmp146_;
	_vala_assert (_tmp147_ == 3, "dummy.size == 3");
	_tmp148_ = test_list;
	_tmp149_ = dummy;
	gee_list_insert_all (_tmp148_, 3, (GeeCollection*) _tmp149_);
	_tmp150_ = test_list;
	_tmp151_ = gee_collection_get_size ((GeeCollection*) _tmp150_);
	_tmp152_ = _tmp151_;
	_vala_assert (_tmp152_ == 6, "test_list.size == 6");
	_tmp153_ = dummy;
	_tmp154_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp153_);
	_tmp155_ = _tmp154_;
	_vala_assert (_tmp155_ == 3, "dummy.size == 3");
	_tmp156_ = test_list;
	_tmp157_ = gee_list_get (_tmp156_, 0);
	_tmp158_ = (gchar*) _tmp157_;
	_vala_assert (g_strcmp0 (_tmp158_, "zero") == 0, "test_list.get (0) == \"zero\"");
	_g_free0 (_tmp158_);
	_tmp159_ = test_list;
	_tmp160_ = gee_list_get (_tmp159_, 1);
	_tmp161_ = (gchar*) _tmp160_;
	_vala_assert (g_strcmp0 (_tmp161_, "one") == 0, "test_list.get (1) == \"one\"");
	_g_free0 (_tmp161_);
	_tmp162_ = test_list;
	_tmp163_ = gee_list_get (_tmp162_, 2);
	_tmp164_ = (gchar*) _tmp163_;
	_vala_assert (g_strcmp0 (_tmp164_, "two") == 0, "test_list.get (2) == \"two\"");
	_g_free0 (_tmp164_);
	_tmp165_ = test_list;
	_tmp166_ = gee_list_get (_tmp165_, 3);
	_tmp167_ = (gchar*) _tmp166_;
	_vala_assert (g_strcmp0 (_tmp167_, "three") == 0, "test_list.get (3) == \"three\"");
	_g_free0 (_tmp167_);
	_tmp168_ = test_list;
	_tmp169_ = gee_list_get (_tmp168_, 4);
	_tmp170_ = (gchar*) _tmp169_;
	_vala_assert (g_strcmp0 (_tmp170_, "four") == 0, "test_list.get (4) == \"four\"");
	_g_free0 (_tmp170_);
	_tmp171_ = test_list;
	_tmp172_ = gee_list_get (_tmp171_, 5);
	_tmp173_ = (gchar*) _tmp172_;
	_vala_assert (g_strcmp0 (_tmp173_, "five") == 0, "test_list.get (5) == \"five\"");
	_g_free0 (_tmp173_);
	_g_object_unref0 (dummy);
	_g_object_unref0 (test_list);
}

void
list_tests_test_slice (ListTests* self)
{
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* dummy = NULL;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	GeeList* _tmp9_;
	GeeList* _tmp10_;
	GeeList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GeeList* _tmp14_;
	GeeList* _tmp15_;
	GeeList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GeeList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GeeList* _tmp22_;
	gpointer _tmp23_;
	gchar* _tmp24_;
	GeeList* _tmp25_;
	gpointer _tmp26_;
	gchar* _tmp27_;
	GeeList* _tmp28_;
	gpointer _tmp29_;
	gchar* _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		_tmp3_ = test_list;
		_tmp4_ = gee_list_slice (_tmp3_, 1, 4);
		_g_object_unref0 (dummy);
		dummy = _tmp4_;
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp5_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "zero"), "test_list.add (\"zero\")");
	_tmp6_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp6_, "one"), "test_list.add (\"one\")");
	_tmp7_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp7_, "two"), "test_list.add (\"two\")");
	_tmp8_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp8_, "three"), "test_list.add (\"three\")");
	_tmp9_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp9_, "four"), "test_list.add (\"four\")");
	_tmp10_ = test_list;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp10_, "five"), "test_list.add (\"five\")");
	_tmp11_ = test_list;
	_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	_vala_assert (_tmp13_ == 6, "test_list.size == 6");
	_tmp14_ = test_list;
	_tmp15_ = gee_list_slice (_tmp14_, 1, 4);
	_g_object_unref0 (dummy);
	dummy = _tmp15_;
	_tmp16_ = dummy;
	_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
	_tmp18_ = _tmp17_;
	_vala_assert (_tmp18_ == 3, "dummy.size == 3");
	_tmp19_ = test_list;
	_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
	_tmp21_ = _tmp20_;
	_vala_assert (_tmp21_ == 6, "test_list.size == 6");
	_tmp22_ = dummy;
	_tmp23_ = gee_list_get (_tmp22_, 0);
	_tmp24_ = (gchar*) _tmp23_;
	_vala_assert (g_strcmp0 (_tmp24_, "one") == 0, "dummy.get (0) == \"one\"");
	_g_free0 (_tmp24_);
	_tmp25_ = dummy;
	_tmp26_ = gee_list_get (_tmp25_, 1);
	_tmp27_ = (gchar*) _tmp26_;
	_vala_assert (g_strcmp0 (_tmp27_, "two") == 0, "dummy.get (1) == \"two\"");
	_g_free0 (_tmp27_);
	_tmp28_ = dummy;
	_tmp29_ = gee_list_get (_tmp28_, 2);
	_tmp30_ = (gchar*) _tmp29_;
	_vala_assert (g_strcmp0 (_tmp30_, "three") == 0, "dummy.get (2) == \"three\"");
	_g_free0 (_tmp30_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp31_;
		GeeList* _tmp32_;
		_tmp31_ = test_list;
		_tmp32_ = gee_list_slice (_tmp31_, 0, 9);
		_g_object_unref0 (dummy);
		dummy = _tmp32_;
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (dummy);
	_g_object_unref0 (test_list);
}

static void
list_tests_class_init (ListTestsClass * klass,
                       gpointer klass_data)
{
	list_tests_parent_class = g_type_class_peek_parent (klass);
	((ListTestsClass *) klass)->test_duplicates_are_retained = (void (*) (ListTests*)) list_tests_real_test_duplicates_are_retained;
}

static void
list_tests_instance_init (ListTests * self,
                          gpointer klass)
{
}

static GType
list_tests_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ListTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListTests), 0, (GInstanceInitFunc) list_tests_instance_init, NULL };
	GType list_tests_type_id;
	list_tests_type_id = g_type_register_static (TYPE_COLLECTION_TESTS, "ListTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return list_tests_type_id;
}

GType
list_tests_get_type (void)
{
	static volatile gsize list_tests_type_id__volatile = 0;
	if (g_once_init_enter (&list_tests_type_id__volatile)) {
		GType list_tests_type_id;
		list_tests_type_id = list_tests_get_type_once ();
		g_once_init_leave (&list_tests_type_id__volatile, list_tests_type_id);
	}
	return list_tests_type_id__volatile;
}

