/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2017 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Menger Sponge formula created by Knighty,
 * Modulus Operation applied by mancoast
 * @reference
 *
 http://www.fractalforums.com/new-theories-and-research/escape-time-algorithm-defined-using-the-quotient-and-remainder-functions/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "ModulusMengerSpongeIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 ModulusMengerSpongeIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(fractal);

	z.x = fabs(z.x);
	z.y = fabs(z.y);
	z.z = fabs(z.z);

	if (z.x - z.y < 0.0f)
	{
		REAL temp = z.x;
		z.x = z.y;
		z.y = temp;
	}
	if (z.x - z.z < 0.0f)
	{
		REAL temp = z.x;
		z.x = z.z;
		z.z = temp;
	}
	if (z.y - z.z < 0.0f)
	{
		REAL temp = z.y;
		z.y = z.z;
		z.z = temp;
	}

	z *= 3.0f;

	z.x -= 2.0f;
	z.y -= 2.0f;

	if (fmod(z.z, M_PI_F) > 2.0f) z.z -= 2.0f;

	aux->DE *= 3.0f;
	return z;
}