/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "Command.h"
//#include "Log.h"

#include <map>
#include <iostream>

static map<string,Command*>* actions = 0;

Command::Command(const string& name):
	name_(name)
{
	if(actions == 0)
		actions = new map<string,Command*>;

	(*actions)[name] = this;
}

Command::~Command()
{
	// Not called
}


void Command::execute(const string& name,IconObject* p)
{
	map<string,Command*>::iterator j = actions->find(name);
	if(j == actions->end())
		//Log::error(p) << name << ": action not found" << endl;
		cout << name << ": action not found" << endl;
	else
		(*j).second->execute(p);
}	

bool Command::isValid(const string& name)
{
	map<string,Command*>::iterator j = actions->find(name);
	return (j != actions->end());		
}	