//
//  dataset.cpp
//  Mothur
//
//  Created by Sarah Westcott on 3/24/16.
//  Copyright (c) 2016 Schloss Lab. All rights reserved.
//

#include "dataset.h"
/***********************************************************************/
TestDataSet::TestDataSet() {
    m = MothurOut::getInstance();
}
/***********************************************************************/
void TestDataSet::createCountTable() {
    fillGroup();
    fillNames();
    ct = new CountTable();
    for (map<string, string>::iterator itNameMap = nameMap.begin(); itNameMap !=nameMap.end(); itNameMap++) {
        string firstCol = itNameMap->first;
        string secondCol = itNameMap->second;
        vector<string> names;
        m->splitAtChar(secondCol, names, ',');
        
        //set to 0
        map<string, int> groupCounts;
        int total = 0;
        vector<string> Groups = gMap->getNamesOfGroups();
        ct->setNamesOfGroups(Groups);
        for (int i = 0; i < Groups.size(); i++) { groupCounts[Groups[i]] = 0; }
        
        //get counts for each of the users groups
        for (int i = 0; i < names.size(); i++) {
            string group = gMap->getGroup(names[i]);
            
            map<string, int>::iterator it = groupCounts.find(group);
            
            //if not found, then this sequence is not from a group we care about
            if (it != groupCounts.end()) {
                it->second++;
                total++;
            }
        }
        
        if (total != 0) {
            vector<int> abunds;
            for (map<string, int>::iterator it = groupCounts.begin(); it != groupCounts.end(); it++) { abunds.push_back(it->second); }
            ct->push_back(firstCol, abunds);
        }
    }
    delete gMap;
    nameMap.clear();
}
/***********************************************************************/

vector<string> TestDataSet::getSubsetFNGFiles(int numSeqs) {
    fillSeqs();
    vector<Sequence> subsetSeqs;
    for (int i = 0; i < numSeqs; i++) { subsetSeqs.push_back(seqs[i]); }
    seqs.clear();
    
    fillNames();
    fillGroup();
    ofstream out, out2, out3;
    m->openOutputFile("tempSeqs.txt", out); m->openOutputFile("tempNames.txt", out2); m->openOutputFile("tempGroup.txt", out3);
    for (int i = 0; i < subsetSeqs.size(); i++) {
        subsetSeqs[i].printSequence(out);
        out2 << subsetSeqs[i].getName() << '\t' << nameMap[subsetSeqs[i].getName()] << '\n';
        out3 << subsetSeqs[i].getName() << '\t' << gMap->getGroup(subsetSeqs[i].getName()) << '\n';
    }
    nameMap.clear();
    delete gMap;
    
    vector<string> filenames; filenames.push_back("tempSeqs.txt"); filenames.push_back("tempNames.txt"); filenames.push_back("tempGroup.txt");
    
    return filenames;
}
/***********************************************************************/

void TestDataSet::fillSeqs() {
    //fill seqs with final.fasta
    seqs.clear();
string name = "GQY1XT001CFHYQ";
string align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1(name, align);
seqs.push_back(newSeq1);
name = "GQY1XT001C44N8";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq2(name, align);
seqs.push_back(newSeq2);
name = "GQY1XT001C296C";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq3(name, align);
seqs.push_back(newSeq3);
name = "GQY1XT001ARCB1";
align = "C-T--C-T--GA-T-A-C-T-G-T--CG-G-G-C--T-A-G-A-G-T-T-T-AG-TT-G-C-G-G-T-A--GG-C-GG-A-ATG-T-A-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AG-A-TC-A-T-A-CA-G-A-AC-A-CC-GA-T-T-GC-GAA-GG-CAG-C-TT-A--CCAA-AC-TA-C-G-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AT--AA-C-T-G-G-TT-G-T-C--G-G-C-G------------ATA-AAA---------T-G-T-C-G-G-T-G-A-C--TA--A-G-C-G-AA-A-G-C-G-A-TAA-G-TTA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq4(name, align);
seqs.push_back(newSeq4);
name = "GQY1XT001A146F";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq5(name, align);
seqs.push_back(newSeq5);
name = "GQY1XT001CE14C";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq6(name, align);
seqs.push_back(newSeq6);
name = "GQY1XT001DOO7Q";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq7(name, align);
seqs.push_back(newSeq7);
name = "GQY1XT001A2EZX";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq8(name, align);
seqs.push_back(newSeq8);
name = "GQY1XT001AYMEB";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq9(name, align);
seqs.push_back(newSeq9);
name = "GQY1XT001DC1IC";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-C-G------------ATA-TAC---------G-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq10(name, align);
seqs.push_back(newSeq10);
name = "GQY1XT001DE4SZ";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq11(name, align);
seqs.push_back(newSeq11);
name = "GQY1XT001BNM96";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq12(name, align);
seqs.push_back(newSeq12);
name = "GQY1XT001AK7BA";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq13(name, align);
seqs.push_back(newSeq13);
name = "GQY1XT001BCUK5";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq14(name, align);
seqs.push_back(newSeq14);
name = "GQY1XT001A05IW";
align = "A-C--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GC-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GGA-GG-CGG-C-TT-A--CTGG-AC-GG-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq15(name, align);
seqs.push_back(newSeq15);
name = "GQY1XT001AN2XX";
align = "C-G--T-T--GA-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-T-G-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-T-C--C-G-G-G-T--C-------GAA-TGA-----G-A-T-C-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq16(name, align);
seqs.push_back(newSeq16);
name = "GQY1XT001CTNPK";
align = "C-A--G-A--GA-A-A-C-C-G-T--AT-A-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-GT-G-T-C----G-G---------------GA-AA------------C---C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq17(name, align);
seqs.push_back(newSeq17);
name = "GQY1XT001D5GRM";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-A-A-C--T-C-G-A-G-A-G-G-GA-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-C-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TT-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CT-CC-T-A-TCT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-C-G-G-CT-G-C-C--C-G-G-G-C--C-------GAT-TGA-----G-G-T-C-T-G-G-G-T-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq18(name, align);
seqs.push_back(newSeq18);
name = "GQY1XT001DR1VM";
align = "A-T--T-G--GA-A-A-C-T-G-G--TT-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-G-A--AG-T-GG-A-ATT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TA-T-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-C--CTGG-TC-TG-C-A-ACT--GACA-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T--G-G-G-G-G-----------TC-GA--------A-C-C-T-C-A-G-T-G-C-T--GA--A-G-T-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq19(name, align);
seqs.push_back(newSeq19);
name = "GQY1XT001BA2S8";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq20(name, align);
seqs.push_back(newSeq20);
name = "GQY1XT001EGASM";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-G--A-G-G-G-G--G---C----CA-A-----G-C-C-C-C-C-T-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq21(name, align);
seqs.push_back(newSeq21);
name = "GQY1XT001BKUTY";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------AAA-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq22(name, align);
seqs.push_back(newSeq22);
name = "GQY1XT001AFH3B";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--T-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq23(name, align);
seqs.push_back(newSeq23);
name = "GQY1XT001BPI4U";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq24(name, align);
seqs.push_back(newSeq24);
name = "GQY1XT001A7N0G";
align = "A-A--A-A--GA-T-A-C-T-G-C--AA-A-G-C--T-A-G-A-G-T-A-T-GA-CA-G-A-G-G-C-A--AG-T-GG-A-ACT-A-C-A-T-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AA--AT-A-TA-T-G-T-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-GT-CG-A-T-ACT--GACA-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCC-T-AAAC-G-A-TG-AG--TA-C-T-A-A-GT-G-T-T--G-G-T---------------GA-GA------------A-T-C-A-G-T-G-C-T--GA--A-G-T-T-AA-C-G-C-A-T-TAA-G-TAC-TCC-GCC-T-G-AGT-AG-TA--CG-TA-C-G-C-A-AGTATGAA";
Sequence newSeq25(name, align);
seqs.push_back(newSeq25);
name = "GQY1XT001AIUIJ";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq26(name, align);
seqs.push_back(newSeq26);
name = "GQY1XT001EDNHY";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-AC-C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq27(name, align);
seqs.push_back(newSeq27);
name = "GQY1XT001DPAC5";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-G----T---T----CA-AG----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq28(name, align);
seqs.push_back(newSeq28);
name = "GQY1XT001D93B0";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-A-A-C--T-C-G-A-G-A-G-G-GA-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-C-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TT-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CT-CC-T-G-TCT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-C-G-G-TT-G-C-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq29(name, align);
seqs.push_back(newSeq29);
name = "GQY1XT001AM8UY";
align = "A-T--T-T--GA-A-A-C-T-G-T--AG-G-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq30(name, align);
seqs.push_back(newSeq30);
name = "GQY1XT001DXDJ4";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-A-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-G--A-G-G-G-T--G---C----TA-A-----G-C-A-T-C-C-T-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq31(name, align);
seqs.push_back(newSeq31);
name = "GQY1XT001BO1NW";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq32(name, align);
seqs.push_back(newSeq32);
name = "GQY1XT001CUIQF";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----TAGA-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq33(name, align);
seqs.push_back(newSeq33);
name = "GQY1XT001CQ0HR";
align = "A-T--T-T--CA-A-A-C-T-G-G--AA-G-T-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--T-------GTC-AT------G-A-C-C-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-T-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGATTAAA";
Sequence newSeq34(name, align);
seqs.push_back(newSeq34);
name = "GQY1XT001BUOY9";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq35(name, align);
seqs.push_back(newSeq35);
name = "GQY1XT001A5M3K";
align = "T-T--T-G--GA-A-A-C-T-G-C--CT-G-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq36(name, align);
seqs.push_back(newSeq36);
name = "GQY1XT001APUDR";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGGGG-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq37(name, align);
seqs.push_back(newSeq37);
name = "GQY1XT001DTSOS";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GGA-GG-CGG-C-TT-G--CTGG-AC-GG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-CG-G-G-G-G----A---C----AT-AA----G-T-T-T-C-C-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-C-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq38(name, align);
seqs.push_back(newSeq38);
name = "GQY1XT001DOHBW";
align = "T-T--T-G--GG-A-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq39(name, align);
seqs.push_back(newSeq39);
name = "GQY1XT001DLRT5";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq40(name, align);
seqs.push_back(newSeq40);
name = "GQY1XT001B1YL9";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq41(name, align);
seqs.push_back(newSeq41);
name = "GQY1XT001COTQS";
align = "T-T--T-T--GA-A-A-C-T-G-T--AG-G-G-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATTCC-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq42(name, align);
seqs.push_back(newSeq42);
name = "GQY1XT001B2H0U";
align = "A-G--T-T--GA-A-A-C-T-G-G--CT-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-T-T--GG-C-GG-A-ATT-C-C-G-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-C-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CA-A--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CTG-T-AAAC-G-A-TG-AT--AA-C-T-A-G-GT-G-TGG--G-G-G---G----------TCT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GC--A-GC--T-AA-C-G-C-A-A-TAA-G-TTA-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq43(name, align);
seqs.push_back(newSeq43);
name = "GQY1XT001BHSTH";
align = "A-T--T-T--GA-A-A-C-T-G-T--AG-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq44(name, align);
seqs.push_back(newSeq44);
name = "GQY1XT001A11OV";
align = "A-T--C-G--GA-A-A-C-C-G-G--GC-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-C--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TG-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-C--GG--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq45(name, align);
seqs.push_back(newSeq45);
name = "GQY1XT001DEX9U";
align = "A-T--T-T--GA-A-A-C-T-G-T--AG-T-T-C--T-T-G-A-G-T-G-A-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AT-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GACC------C-C-T-T-C-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq46(name, align);
seqs.push_back(newSeq46);
name = "GQY1XT001D9BN9";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-A-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-G-A-G-GT-G-T-C--G-G-G-A-G--G---C----AG-A-----G-C-C-T-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq47(name, align);
seqs.push_back(newSeq47);
name = "GQY1XT001DW1V5";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C--AAGAATGAA";
Sequence newSeq48(name, align);
seqs.push_back(newSeq48);
name = "GQY1XT001AWZI0";
align = "A-T--T-G--GA-A-A-C-T-G-T--CG-C-G-C--T-C-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AC-A-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq49(name, align);
seqs.push_back(newSeq49);
name = "GQY1XT001ALHWC";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-C-G-C--T-C-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-TGT-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AT-G-----G-C-C-C-C-C-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq50(name, align);
seqs.push_back(newSeq50);
name = "GQY1XT001ECPOA";
align = "A-T--T-T--GG-A-A-C-T-G-T--GT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-G-G-G----T---T----TA-CG----G-A-C-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq51(name, align);
seqs.push_back(newSeq51);
name = "GQY1XT001D7RD3";
align = "A-T--A-A--CG-A-A-C-T-A-T--CT-A-G-C--T-A-G-A-G-T-A-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-A-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A-----------GG-AA--------T-T-C-C-C-G-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-CAC-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq52(name, align);
seqs.push_back(newSeq52);
name = "GQY1XT001BXUR6";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq53(name, align);
seqs.push_back(newSeq53);
name = "GQY1XT001AG9HZ";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-C--C---CT---AA-G-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq54(name, align);
seqs.push_back(newSeq54);
name = "GQY1XT001A1M68";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq55(name, align);
seqs.push_back(newSeq55);
name = "GQY1XT001EC06X";
align = "T-T--T-T--GA-A-A-C-T-G-C--AG-A-G-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TC-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G----------ACT-GA-CC-----C-C-A-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq56(name, align);
seqs.push_back(newSeq56);
name = "GQY1XT001CTFHS";
align = "T-T--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq57(name, align);
seqs.push_back(newSeq57);
name = "GQY1XT001CIUF3";
align = "A-C--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AC-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq58(name, align);
seqs.push_back(newSeq58);
name = "GQY1XT001BXD8S";
align = "T-C--T-G--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-A-C-TG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq59(name, align);
seqs.push_back(newSeq59);
name = "GQY1XT001AF1Q3";
align = "A-C--T-G--GG-A-A-C-T-G-T--CA-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-C-A-ACT--GACG-TTG-A-GG--C-C-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-TA--TA-C-C-A-G-GT-G-T-C--G-G-A-T-A--T---C----AA-G-----G-A-T-A-T-C-C-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-ACC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq60(name, align);
seqs.push_back(newSeq60);
name = "GQY1XT001C8QTK";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--CGA------GT-GA------G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq61(name, align);
seqs.push_back(newSeq61);
name = "GQY1XT001BVJNO";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-TGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq62(name, align);
seqs.push_back(newSeq62);
name = "GQY1XT001ETRS5";
align = "A-T--T-G--GG-A-A-C-T-A-C--CG-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-A--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--C---C----AG-G-----G-G-C-C-C-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq63(name, align);
seqs.push_back(newSeq63);
name = "GQY1XT001EQW3X";
align = "T-T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq64(name, align);
seqs.push_back(newSeq64);
name = "GQY1XT001EJ7DU";
align = "T-C--T-G--GA-A-A-C-T-A-T--GT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq65(name, align);
seqs.push_back(newSeq65);
name = "GQY1XT001DWRL7";
align = "G-T--T-T--GA-A-A-C-T-G-T--TC-T-T-C--T-T-G-A-G-T-G-A-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AT-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GACC------C-C-C-T-C-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq66(name, align);
seqs.push_back(newSeq66);
name = "GQY1XT001D79TR";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq67(name, align);
seqs.push_back(newSeq67);
name = "GQY1XT001B6C9Z";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq68(name, align);
seqs.push_back(newSeq68);
name = "GQY1XT001EI480";
align = "G-A--T-C--AA-A-A-C-T-G-C--AA-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G----------ACT-GA-CC-----C-C-A-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGATTGAA";
Sequence newSeq69(name, align);
seqs.push_back(newSeq69);
name = "GQY1XT001EE24J";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq70(name, align);
seqs.push_back(newSeq70);
name = "GQY1XT001EDBEC";
align = "C-G--T-T--GA-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-T-G-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-T-C--C-G-G-G-T--CGA------AT-GA------G-A-T-C-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq71(name, align);
seqs.push_back(newSeq71);
name = "GQY1XT001D47YY";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--CGA------TT-GA------G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq72(name, align);
seqs.push_back(newSeq72);
name = "GQY1XT001CNUHI";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq73(name, align);
seqs.push_back(newSeq73);
name = "GQY1XT001BH4P4";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---C----ATAA-----G-A-C-T-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq74(name, align);
seqs.push_back(newSeq74);
name = "GQY1XT001AWI4W";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq75(name, align);
seqs.push_back(newSeq75);
name = "GQY1XT001AMRXQ";
align = "A-T--T-G--GA-A-A-C-T-G-C--AT-A-T-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-A-G--G---C----AA-A-----G-C-C-T-T-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq76(name, align);
seqs.push_back(newSeq76);
name = "GQY1XT001EISNU";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AG-G-----G-C-C-C-C-C-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq77(name, align);
seqs.push_back(newSeq77);
name = "GQY1XT001EDAPN";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq78(name, align);
seqs.push_back(newSeq78);
name = "GQY1XT001E06HP";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq79(name, align);
seqs.push_back(newSeq79);
name = "GQY1XT001DXX0D";
align = "T-A--C-C--AA-A-A-C-T-G-T--TG-G-A-C--T-T-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TT-G--CTGG-AC-TG-T-A-ACT--GACA-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-G--T-------ATC-GA-C----T-C-C-C-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-T-TAA-G-TAT-TCC-GCC-T-G-GGG-AC-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq80(name, align);
seqs.push_back(newSeq80);
name = "GQY1XT001DK76L";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq81(name, align);
seqs.push_back(newSeq81);
name = "GQY1XT001DC2Z9";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq82(name, align);
seqs.push_back(newSeq82);
name = "GQY1XT001D8HIW";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-----G-G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq83(name, align);
seqs.push_back(newSeq83);
name = "GQY1XT001CYGKE";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq84(name, align);
seqs.push_back(newSeq84);
name = "GQY1XT001CTAEP";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq85(name, align);
seqs.push_back(newSeq85);
name = "GQY1XT001CHFDU";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq86(name, align);
seqs.push_back(newSeq86);
name = "GQY1XT001CAHA5";
align = "A-T--C-A--GA-A-A-C-T-G-T--TG-A-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T--G-G-G-A-G--G---T----TT-CC----G-C-C-T-C-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq87(name, align);
seqs.push_back(newSeq87);
name = "GQY1XT001AU3JG";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-T--T-------CTA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq88(name, align);
seqs.push_back(newSeq88);
name = "GQY1XT001A7KLW";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq89(name, align);
seqs.push_back(newSeq89);
name = "GQY1XT001EVNLV";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---CT---AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq90(name, align);
seqs.push_back(newSeq90);
name = "GQY1XT001DZCL2";
align = "A-T--T-T--GA-A-A-C-T-G-T--AC-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----CCC-T-C-C-G---T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq91(name, align);
seqs.push_back(newSeq91);
name = "GQY1XT001DUZOP";
align = "T-T--T-A--GA-A-A-C-T-G-C--TC-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-T-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACA-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-AA----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq92(name, align);
seqs.push_back(newSeq92);
name = "GQY1XT001DD4OA";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-C-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGT-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-T-G--C---C----AA-A-----G-G-C-A-T-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq93(name, align);
seqs.push_back(newSeq93);
name = "GQY1XT001CLQ8T";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq94(name, align);
seqs.push_back(newSeq94);
name = "GQY1XT001CI64O";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-TGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq95(name, align);
seqs.push_back(newSeq95);
name = "GQY1XT001C21E5";
align = "C-A--C-T--GA-T-A-C-T-G-T--TA-G-A-C--T-T-G-A-G-T-A-T-GG-AA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-GC-CA-A-G-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-T--A-G-T-A-G---------TTTC-GA-TG-----C-T-A-C-T-A-G-T-G-C-C--GG--A-G-T-A-AA-C-A-C-A-A-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq96(name, align);
seqs.push_back(newSeq96);
name = "GQY1XT001BATAU";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq97(name, align);
seqs.push_back(newSeq97);
name = "GQY1XT001B2L2T";
align = "T-T--T-T--GA-A-A-C-T-G-A--GT-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AA-A-----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq98(name, align);
seqs.push_back(newSeq98);
name = "GQY1XT001EKTYL";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq99(name, align);
seqs.push_back(newSeq99);
name = "GQY1XT001EH08T";
align = "T-C--T-G--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-G-G-G--T---T----AACA-----G-A-C-C-C-C-C-G-G-T-G-C-C--GA--A-G-C-C-AA-C-G-C-A-T-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq100(name, align);
seqs.push_back(newSeq100);
name = "GQY1XT001EBAXG";
align = "T-T--T-T--GG-A-A-C-T-A-T--CT-A-G-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-C-G--C---C----AT-A-----G-G-C-G-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq101(name, align);
seqs.push_back(newSeq101);
name = "GQY1XT001DZX4H";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq102(name, align);
seqs.push_back(newSeq102);
name = "GQY1XT001DX9HF";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--CGA------GT-GA------G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq103(name, align);
seqs.push_back(newSeq103);
name = "GQY1XT001D6C10";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq104(name, align);
seqs.push_back(newSeq104);
name = "GQY1XT001CU6G0";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq105(name, align);
seqs.push_back(newSeq105);
name = "GQY1XT001CCIKR";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq106(name, align);
seqs.push_back(newSeq106);
name = "GQY1XT001C5FNH";
align = "A-T--T-T--CA-A-A-C-T-G-G--AA-G-T-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--T-------GTC-AT------G-A-C-T-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-T-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGAATGAA";
Sequence newSeq107(name, align);
seqs.push_back(newSeq107);
name = "GQY1XT001BW5GI";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C-----A-GG----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq108(name, align);
seqs.push_back(newSeq108);
name = "GQY1XT001BKKRF";
align = "T-T--T-G--GA-A-A-CTT-T-T--TT-T-G-C--T-G-G-A-G-T-A-C-CG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--A---C----AA-A-----G-T-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq109(name, align);
seqs.push_back(newSeq109);
name = "GQY1XT001BFDG3";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq110(name, align);
seqs.push_back(newSeq110);
name = "GQY1XT001BA1UZ";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-C-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--C---C----GA-C-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq111(name, align);
seqs.push_back(newSeq111);
name = "GQY1XT001B7B4F";
align = "T-T--T-T--GA-A-A-C-T-G-T--TG-A-A-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----A--AA----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq112(name, align);
seqs.push_back(newSeq112);
name = "GQY1XT001B3HER";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AG-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq113(name, align);
seqs.push_back(newSeq113);
name = "GQY1XT001AZUJZ";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C----G-G-G-G--A---C----CG-AC----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq114(name, align);
seqs.push_back(newSeq114);
name = "GQY1XT001AVTPK";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq115(name, align);
seqs.push_back(newSeq115);
name = "GQY1XT001AGP1J";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq116(name, align);
seqs.push_back(newSeq116);
name = "GQY1XT001AESMQ";
align = "T-T--T-T--GG-A-A-C-T-G-C--GT-G-T-C--T-T-G-A-G-T-G-A-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-C-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AT-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-A-G-G---------TATT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq117(name, align);
seqs.push_back(newSeq117);
name = "GQY1XT001EXMDA";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--CGA------TT-GA------G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq118(name, align);
seqs.push_back(newSeq118);
name = "GQY1XT001EHLX1";
align = "T-T--T-T--GA-A-A-C-T-G-T--GT-T-G-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----AA-G-----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq119(name, align);
seqs.push_back(newSeq119);
name = "GQY1XT001EEPSH";
align = "A-T--T-G--GG-A-A-C-T-G-G--CG-C-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-A--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-G-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-C-C--C---C----AT-T-----G-G-G-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq120(name, align);
seqs.push_back(newSeq120);
name = "GQY1XT001E0WEO";
align = "A-T--T-G--GA-A-A-C-T-G-G--CG-A-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-G-C-G--C---C----AC-G-----G-G-C-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq121(name, align);
seqs.push_back(newSeq121);
name = "GQY1XT001DV57S";
align = "A-T--T-T--GA-A-A-C-T-G-T---T-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----CCC-T-C-C-G---T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq122(name, align);
seqs.push_back(newSeq122);
name = "GQY1XT001DC1ON";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GT--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq123(name, align);
seqs.push_back(newSeq123);
name = "GQY1XT001D0EZV";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-CG-G-G-G-C----A---C----AT-AA----G-T-G-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-C-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq124(name, align);
seqs.push_back(newSeq124);
name = "GQY1XT001D07O6";
align = "A-C--T-C--AA-A-A-C-T-G-C--AG-C-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq125(name, align);
seqs.push_back(newSeq125);
name = "GQY1XT001CVG08";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq126(name, align);
seqs.push_back(newSeq126);
name = "GQY1XT001CTARO";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq127(name, align);
seqs.push_back(newSeq127);
name = "GQY1XT001CPLJN";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq128(name, align);
seqs.push_back(newSeq128);
name = "GQY1XT001CB5IC";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq129(name, align);
seqs.push_back(newSeq129);
name = "GQY1XT001C281B";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq130(name, align);
seqs.push_back(newSeq130);
name = "GQY1XT001BWUNQ";
align = "G-T--T-T--GA-A-A-C-T-G-T--CG-T-T-C--T-T-G-A-G-T-G-A-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AT-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq131(name, align);
seqs.push_back(newSeq131);
name = "GQY1XT001BUCXD";
align = "T-T--T-G--GA-A-A-C-T-G-C--GA-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AA-A-----G-C-C-C-C-T-C-G-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-A-TAA-G-CAC-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq132(name, align);
seqs.push_back(newSeq132);
name = "GQY1XT001BQUGT";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq133(name, align);
seqs.push_back(newSeq133);
name = "GQY1XT001BNNDP";
align = "T-T--T-G--GA-A-A-C-T-G-T--GG-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq134(name, align);
seqs.push_back(newSeq134);
name = "GQY1XT001BN9CV";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq135(name, align);
seqs.push_back(newSeq135);
name = "GQY1XT001BL21S";
align = "C-C--T-T--GG-A-A-C-T-G-T--GC-G-G-C--T-G-G-A-G-T-G-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-CG-G-G-G-G-A--C---G----AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq136(name, align);
seqs.push_back(newSeq136);
name = "GQY1XT001BD93X";
align = "A-C--T-C--AA-A-A-C-T-G-C--AG-C-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AGA-T--A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq137(name, align);
seqs.push_back(newSeq137);
name = "GQY1XT001B7SJ3";
align = "T-T--T-G--GA-A-A-C-T-G-T--GG-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-A-G-A--G---C----AA-A-----G-C-T-T-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C--AAGAATGAA";
Sequence newSeq138(name, align);
seqs.push_back(newSeq138);
name = "GQY1XT001B79N5";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GG------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq139(name, align);
seqs.push_back(newSeq139);
name = "GQY1XT001AXXKK";
align = "A-T--A-T--AA-A-A-C-T-G-G--GG-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCC-T-AAAC-G-A-TG-GA--TA-C-T-A-G-AC-G-A-A--G-G-G-A-G--TA------TTT-C-------A-C-T-C-T-C-T-G-T-G-T-C--GA--A-G-C-C-AA-C-G-C-G-A-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq140(name, align);
seqs.push_back(newSeq140);
name = "GQY1XT001APMMG";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-GG----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq141(name, align);
seqs.push_back(newSeq141);
name = "GQY1XT001AO6DL";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-----G-G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq142(name, align);
seqs.push_back(newSeq142);
name = "GQY1XT001AI1JK";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-TCG--G-G-G-G-T--T---C----AA-G-----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq143(name, align);
seqs.push_back(newSeq143);
name = "GQY1XT001AE5A7";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq144(name, align);
seqs.push_back(newSeq144);
name = "GQY1XT001A77FU";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq145(name, align);
seqs.push_back(newSeq145);
name = "GQY1XT001EZU1F";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq146(name, align);
seqs.push_back(newSeq146);
name = "GQY1XT001EY0VF";
align = "A-T--T-G--GG-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-C-G-G--G---C----AA-A-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq147(name, align);
seqs.push_back(newSeq147);
name = "GQY1XT001EWITF";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq148(name, align);
seqs.push_back(newSeq148);
name = "GQY1XT001EVEB5";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C----T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--GC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq149(name, align);
seqs.push_back(newSeq149);
name = "GQY1XT001ERVUL";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq150(name, align);
seqs.push_back(newSeq150);
name = "GQY1XT001EPR0H";
align = "T-T--T-G--GA-A-A-C-T-G-T--TA-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq151(name, align);
seqs.push_back(newSeq151);
name = "GQY1XT001EPKYE";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq152(name, align);
seqs.push_back(newSeq152);
name = "GQY1XT001EM0TN";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq153(name, align);
seqs.push_back(newSeq153);
name = "GQY1XT001EHL10";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq154(name, align);
seqs.push_back(newSeq154);
name = "GQY1XT001EH8KN";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq155(name, align);
seqs.push_back(newSeq155);
name = "GQY1XT001EFRAG";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-GG----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq156(name, align);
seqs.push_back(newSeq156);
name = "GQY1XT001EDZY7";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq157(name, align);
seqs.push_back(newSeq157);
name = "GQY1XT001E3LM5";
align = "A-T--T-G--GA-A-A-C-T-G-T--CG-C-G-C--T-C-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AG-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq158(name, align);
seqs.push_back(newSeq158);
name = "GQY1XT001E1X2E";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-G-G-G-C-C--C---T----AA-G-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq159(name, align);
seqs.push_back(newSeq159);
name = "GQY1XT001DWYDQ";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq160(name, align);
seqs.push_back(newSeq160);
name = "GQY1XT001DN9I6";
align = "A-T--T-T--GA-A-A-C-T---G--TT-T-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA--C-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-TGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq161(name, align);
seqs.push_back(newSeq161);
name = "GQY1XT001DJWFM";
align = "T-T--T-G--GA-A-A-C-T-G-T--GG-A-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C--AAGAATGAA";
Sequence newSeq162(name, align);
seqs.push_back(newSeq162);
name = "GQY1XT001DHVO8";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-A-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq163(name, align);
seqs.push_back(newSeq163);
name = "GQY1XT001DH4I4";
align = "T-T--T-T--GA-A-A-C-T-G-T--TG-A-A-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-C-G--C---C----AT-AG----G-C-G---T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq164(name, align);
seqs.push_back(newSeq164);
name = "GQY1XT001DADJM";
align = "T-T--T-G--GG-A-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq165(name, align);
seqs.push_back(newSeq165);
name = "GQY1XT001D5TRF";
align = "A-T--C-T--AA-A-A-C-T-G-T--TG-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-A-G-GC-GAA-GG-CGA-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCC-T-AAAC-G-A-TG-GA--TA-C-T-A-G-AG-G-A-A--G-G-G-G-G--T-------ATA-A-------A-CTC-C-TCC-T-G-T-C-T-C--GA--A-G-C-A-AA-C-G-C-G-A-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq166(name, align);
seqs.push_back(newSeq166);
name = "GQY1XT001D2UY9";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq167(name, align);
seqs.push_back(newSeq167);
name = "GQY1XT001D1463";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-G--G-G-A-G-G--A---C----TG-A-----C-C-C-C-T-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq168(name, align);
seqs.push_back(newSeq168);
name = "GQY1XT001CWRV8";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-C-G-C--T-C-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-TGT-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G---G-G--G---C----A--T-----G-G-C-C-C-C-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq169(name, align);
seqs.push_back(newSeq169);
name = "GQY1XT001CVRVK";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--CAA------AT-GA------G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq170(name, align);
seqs.push_back(newSeq170);
name = "GQY1XT001CUC2B";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-G-G-G-G----G---C----AG-AG----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq171(name, align);
seqs.push_back(newSeq171);
name = "GQY1XT001CRFHI";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq172(name, align);
seqs.push_back(newSeq172);
name = "GQY1XT001CQZ2F";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq173(name, align);
seqs.push_back(newSeq173);
name = "GQY1XT001CMO4M";
align = "A-T--C-T--AA-A-A-C-T-G-G--TA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-A-G-GC-GAA-GG-CGA-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCC-T-AAAC-G-A-TG-GA--TA-C-T-A-G-AG-G-A-A--G-G-G-G-G--T-------ATA-AA-C----T-C-C-T-C-C-T-G-T-C-T-C--GA--A-G-C-A-AA-C-G-C-G-A-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq174(name, align);
seqs.push_back(newSeq174);
name = "GQY1XT001CF4I5";
align = "..T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq175(name, align);
seqs.push_back(newSeq175);
name = "GQY1XT001CEE8H";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-TCCG-G-GCC-G------------ATT-GAGG--------C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq176(name, align);
seqs.push_back(newSeq176);
name = "GQY1XT001CCAN6";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq177(name, align);
seqs.push_back(newSeq177);
name = "GQY1XT001C9X04";
align = "A-T--T-T--CA-A-A-C-T-G-G--AA-G-T-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-TC-T--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--T-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G-T--C-------G-C-AA------G-A-C-T-T-C-G-G-T-G-C-C--GT--A-G-T-T-AA-C-G-C-A-T-TAA-G-TGC-TCC-GCC-T-G-GGG-AG-TA--CG-CA-C-G-C-A-AGTGTGAA";
Sequence newSeq178(name, align);
seqs.push_back(newSeq178);
name = "GQY1XT001C9UYZ";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-TCCG-G-GCC-G------------ATT-GAGG--------C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq179(name, align);
seqs.push_back(newSeq179);
name = "GQY1XT001C610G";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq180(name, align);
seqs.push_back(newSeq180);
name = "GQY1XT001C4J0B";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------AAA-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq181(name, align);
seqs.push_back(newSeq181);
name = "GQY1XT001C2OS7";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----CA-AG----G-C-C-C-T-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq182(name, align);
seqs.push_back(newSeq182);
name = "GQY1XT001C1WMY";
align = "T-T--T-G--GA-A-A-C-T-G-T--TA-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq183(name, align);
seqs.push_back(newSeq183);
name = "GQY1XT001BT9LZ";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq184(name, align);
seqs.push_back(newSeq184);
name = "GQY1XT001BRS60";
align = "C-T--T-G--CG-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-A-A-ACT--GACG-CTG-A-GG--T-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G-T--C--------GA-AA------G-A-C-T-T-C-G-G-T-G-C-C--GC--A-G-T-T-AA-C-G-C-A-A-TAA-G-TGC-TCC-GCC-T-G-GGG-AG-TA--CG-CA-C-G-C-A-AGTGTGAA";
Sequence newSeq185(name, align);
seqs.push_back(newSeq185);
name = "GQY1XT001BLMSS";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-A-G-A--G---C----AA--A----G-C-T-T-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq186(name, align);
seqs.push_back(newSeq186);
name = "GQY1XT001BFEVN";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq187(name, align);
seqs.push_back(newSeq187);
name = "GQY1XT001BCRZC";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq188(name, align);
seqs.push_back(newSeq188);
name = "GQY1XT001BBF5C";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----CA-AG----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq189(name, align);
seqs.push_back(newSeq189);
name = "GQY1XT001BAF72";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq190(name, align);
seqs.push_back(newSeq190);
name = "GQY1XT001B9Y3W";
align = "T-T--T-T--GA-A-A-C-T-G-T--GT-A-A-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--A---C----AA-A-----G-T-C-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq191(name, align);
seqs.push_back(newSeq191);
name = "GQY1XT001B9XO1";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq192(name, align);
seqs.push_back(newSeq192);
name = "GQY1XT001B7NBQ";
align = "G-C--C-G--GG-T-A-C-G-G-G--CG-G-G-C--T-T-G-A-G-T-G-C-GG-TA-G-G-G-G-A-G--AC-T-GG-A-ATT-C-C-C-G-GT-GT-A-A-CGGT-G-GAA--TG-T-GT-AG--AT-A-TC-G-G-G-AA-G-A-AC-A-CC-AA-T-G-GC-GAA-GG-CAG-G-TC-T--CTGG-GC-CG-T-T-ACT--GACG-CTG-A-GG--A-G-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-G-TG-GA--TG-C-T-G-G-AT-G-T-G--G-G-G-C-C--C------TTTT-TC-C----G-G-G-T-C-C-T-G-T-G-T-C--GG--A-G-C-T-AA-C-G-C-G-T-TAA-G-CAT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTAAA";
Sequence newSeq193(name, align);
seqs.push_back(newSeq193);
name = "GQY1XT001B6B6X";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq194(name, align);
seqs.push_back(newSeq194);
name = "GQY1XT001B5FDE";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq195(name, align);
seqs.push_back(newSeq195);
name = "GQY1XT001B44ZE";
align = "G-T--T-C--AA-A-A-C-T-G-T--TC-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G----------ACT-GA-CC-----C-C-A-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq196(name, align);
seqs.push_back(newSeq196);
name = "GQY1XT001B3RRH";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------AAA-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq197(name, align);
seqs.push_back(newSeq197);
name = "GQY1XT001B1FMW";
align = "T-T--T-T--GA-A-A-C-T-G-T--GT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-C-G--C---C----AA-A-----G-G-C-G-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq198(name, align);
seqs.push_back(newSeq198);
name = "GQY1XT001B0S0G";
align = "A-T--T-T--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACA-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G----C---C----CA-CA----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq199(name, align);
seqs.push_back(newSeq199);
name = "GQY1XT001AZ7TX";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq200(name, align);
seqs.push_back(newSeq200);
name = "GQY1XT001AWGGS";
align = "T-T--T-G--GG-G-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq201(name, align);
seqs.push_back(newSeq201);
name = "GQY1XT001AW13I";
align = "T-C--T-G--GG-A-A-C-T-G-C--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq202(name, align);
seqs.push_back(newSeq202);
name = "GQY1XT001AVVL8";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------AAA-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq203(name, align);
seqs.push_back(newSeq203);
name = "GQY1XT001AVDQY";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-T-G-G----G---T----AT-GG----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq204(name, align);
seqs.push_back(newSeq204);
name = "GQY1XT001AP7WE";
align = "T-C--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq205(name, align);
seqs.push_back(newSeq205);
name = "GQY1XT001AN9R6";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq206(name, align);
seqs.push_back(newSeq206);
name = "GQY1XT001AMF1Z";
align = "C-C--T-G--CG-A-A-C-T-G-G--GA-T-G-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-T-A-ACT--GACA-CTG-A-GG--T-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G-T--C--------GC-AA------G-A-C-T-T-C-G-G-T-G-C-C--GT--A-G-T-T-AA-C-G-C-A-T-TAA-G-TGC-TCC-GCC-T-G-GGG-AG-TA--CG-CA-C-G-C-A-AGTGTGAA";
Sequence newSeq207(name, align);
seqs.push_back(newSeq207);
name = "GQY1XT001AL3PU";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq208(name, align);
seqs.push_back(newSeq208);
name = "GQY1XT001AIOL2";
align = "G-T--T-C--TA-A-A-C-T-G-C--CG-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AGA-T--A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq209(name, align);
seqs.push_back(newSeq209);
name = "GQY1XT001AFW79";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq210(name, align);
seqs.push_back(newSeq210);
name = "GQY1XT001AEZLH";
align = "G-T--C-C--CG-A-A-C-T-G-G--GC-G-C-C--T-C-G-A-G-T-G-C-GG-TA-G-G-G-G-A-G--AT-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-GAA--TG-C-GC-AG--AT-A-TC-G-G-G-AA-G-A-AC-A-CC-GA-T-G-GC-GAA-GG-CAG-A-TC-T--CTGG-GC-CG-C-C-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-T-AGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CT-A-G-CCG-T-AAAC-G-A-TG-GG--CG-C-T-A-G-GT-G-T-G--G-G-G-A-G-----------CG-AT-TG-----C-T-C-T-C-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-CGC-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTAAA";
Sequence newSeq211(name, align);
seqs.push_back(newSeq211);
name = "GQY1XT001A7064";
align = "A-T--T-G--GA-A-A-C-T-G-T--GC-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AT-G-----G-C-C-C-C-T-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq212(name, align);
seqs.push_back(newSeq212);
name = "GQY1XT001A6CSK";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GGA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----A--GG----G-C-C-C-C-C-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq213(name, align);
seqs.push_back(newSeq213);
name = "GQY1XT001A5XOT";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq214(name, align);
seqs.push_back(newSeq214);
name = "GQY1XT001A5J6A";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-----G-G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq215(name, align);
seqs.push_back(newSeq215);
name = "GQY1XT001A0G36";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq216(name, align);
seqs.push_back(newSeq216);
name = "GQY1XT001EZZNX";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-AC-C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq217(name, align);
seqs.push_back(newSeq217);
name = "GQY1XT001EZL0F";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GG------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq218(name, align);
seqs.push_back(newSeq218);
name = "GQY1XT001EZ03E";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-C-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq219(name, align);
seqs.push_back(newSeq219);
name = "GQY1XT001EYZ4F";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq220(name, align);
seqs.push_back(newSeq220);
name = "GQY1XT001EYTQI";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G--T---A----TG-G-----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq221(name, align);
seqs.push_back(newSeq221);
name = "GQY1XT001EYNL7";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CG-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq222(name, align);
seqs.push_back(newSeq222);
name = "GQY1XT001EYE6M";
align = "G-T--T-C--AA-A-A-C-T-GTT--TT-T-T-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AA--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq223(name, align);
seqs.push_back(newSeq223);
name = "GQY1XT001EXZXC";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-AG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-GCC-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq224(name, align);
seqs.push_back(newSeq224);
name = "GQY1XT001EXZLY";
align = "C-G--T-T--GA-A-A-C-TAG-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-G-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC---CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq225(name, align);
seqs.push_back(newSeq225);
name = "GQY1XT001EXOOM";
align = "A-T--C-T--AA-A-A-C-T-G-G--TA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-A-G-GC-GAA-GG-CGA-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCC-T-AAAC-G-A-TG-GA--TA-C-T-A-G-AG-G-A-A--G-G-G-G-G--T-------ATA-A-------A-C-TCC-TCC-T-G-T-C-T-C--GA--A-G-C-A-AA-C-G-C-G-A-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq226(name, align);
seqs.push_back(newSeq226);
name = "GQY1XT001EX24Z";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAG-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq227(name, align);
seqs.push_back(newSeq227);
name = "GQY1XT001EWUBU";
align = "C-G----T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq228(name, align);
seqs.push_back(newSeq228);
name = "GQY1XT001EWJBM";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G---GA-AG-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-GG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GTGG-T-C--CGGGG-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq229(name, align);
seqs.push_back(newSeq229);
name = "GQY1XT001EVP68";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-T-G-G----G---T----AT-GG----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq230(name, align);
seqs.push_back(newSeq230);
name = "GQY1XT001EVO39";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CG-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq231(name, align);
seqs.push_back(newSeq231);
name = "GQY1XT001EUELE";
align = "C-T--C-T--GA-T-A-C-T-G-T--CG-G-G-C--T-A-G-A-G-T-T-T-AG-TT-G-C-G-G-T-A--GG-C-GG-A-ATG-T-A-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AG-A-TC-A-T-A-CA-G-A-AC-A-CC-GA-T-T-GC-GAA-GG-CAG-C-TT-A--CCAA-AC-TA-C-G-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AT--AA-C-T-G-G-TT-G-T----C-----G-G--C-------GA--TAA-----A-A-T-G-T-C-G-G-T-G-A-C--TA--A-G-C-G-AA-A-G-C-G-A-TAA-G-TTA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq232(name, align);
seqs.push_back(newSeq232);
name = "GQY1XT001EU3ZN";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq233(name, align);
seqs.push_back(newSeq233);
name = "GQY1XT001ETY3N";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-ACGT-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq234(name, align);
seqs.push_back(newSeq234);
name = "GQY1XT001ETV5R";
align = "A-T--T-T--GA-A-A-C-T-G-T--AG-T-T-C--T-T-G-A-G-T-G-A-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AT-T-A-ACT--GACG-CTG-A-GG--C-GACG-AAA-G-CGG-TGGG-G--AGC-A-AA-CA-GG-ATTAGACTA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GACC------C-C-T-T-C-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq235(name, align);
seqs.push_back(newSeq235);
name = "GQY1XT001ETSII";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq236(name, align);
seqs.push_back(newSeq236);
name = "GQY1XT001ET9BS";
align = "A-T--C-G--GA-A-A-C-C-G-G--GC-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-C--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TG-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-T--G-G-G-A-G--G---T----TT-CC----G-C-C-T-C-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq237(name, align);
seqs.push_back(newSeq237);
name = "GQY1XT001ESYFW";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-TGG-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq238(name, align);
seqs.push_back(newSeq238);
name = "GQY1XT001ESY2M";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq239(name, align);
seqs.push_back(newSeq239);
name = "GQY1XT001ES0NY";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------GAG-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq240(name, align);
seqs.push_back(newSeq240);
name = "GQY1XT001EQOBG";
align = "T-C--T-G--GA-A-A-C-T-A-T--GT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq241(name, align);
seqs.push_back(newSeq241);
name = "GQY1XT001EQCKJ";
align = "A-T--T-G--GG-A-A-C-T-G-G--CG-C-G-C--T-G-G-A-G-T-G-C-CG-GA---G-G-G-T----AG-C-GG-A-ATT---C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-A--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-G-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-C-C--C---C----AT-T-----G-G-G-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq242(name, align);
seqs.push_back(newSeq242);
name = "GQY1XT001EQ1UK";
align = "T-T--T-G--GG-A-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq243(name, align);
seqs.push_back(newSeq243);
name = "GQY1XT001EPWKA";
align = "A-GT-T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-CTTT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-CGG------------ATA-TAC---------A-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq244(name, align);
seqs.push_back(newSeq244);
name = "GQY1XT001EPCM9";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAG-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq245(name, align);
seqs.push_back(newSeq245);
name = "GQY1XT001EPA06";
align = "T-T--T-T--GG-A-A-C-T-A-T--CT-A-G-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----CA-AG----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-A-TAA-G-CAC-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq246(name, align);
seqs.push_back(newSeq246);
name = "GQY1XT001EOW0D";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq247(name, align);
seqs.push_back(newSeq247);
name = "GQY1XT001EMQDS";
align = "A-T--T-G--GG-A-A-C-T-A-C--CG-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G---G-G--G---C----TT-C-----G-G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq248(name, align);
seqs.push_back(newSeq248);
name = "GQY1XT001EMIPL";
align = "T-C--T-G--GA-A-A-C-T-G-C--GT-C-G-C--T-G-G-A-G-T-A-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AGA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-TCG--G-G-G-G-A--C---G----AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq249(name, align);
seqs.push_back(newSeq249);
name = "GQY1XT001EM91Y";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-AGG-GT-G-T-C--G-G-G-G-G--C---C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T---GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq250(name, align);
seqs.push_back(newSeq250);
name = "GQY1XT001EM3V4";
align = "A-T--A-A--GA-A-A-C-T-G-T--CG-G-A-C--T-T-G-A-G-T-A-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C---A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-G-G-G-AA-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-A-A-ACT--GACG-CTG-A-GT--C-A-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--G-G-C-A-A--G---G----A--A---------T-T-G-T-C-G-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq251(name, align);
seqs.push_back(newSeq251);
name = "GQY1XT001ELV8X";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq252(name, align);
seqs.push_back(newSeq252);
name = "GQY1XT001ELC1A";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------AT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq253(name, align);
seqs.push_back(newSeq253);
name = "GQY1XT001EL9FP";
align = "T-T--T-T--GA-A-A-C-T-G-C--AG-A-G-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATTCC-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq254(name, align);
seqs.push_back(newSeq254);
name = "GQY1XT001EKKMD";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-GG----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq255(name, align);
seqs.push_back(newSeq255);
name = "GQY1XT001EJY90";
align = "A-C--T-C--AA-A-A-C-T-G-C--AG-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AGA-T--A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq256(name, align);
seqs.push_back(newSeq256);
name = "GQY1XT001EJXCX";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-A-A-C--T-C-G-A-G-A-G-G-GA-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-C-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TT-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CT-CC-T-G-TCT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-C-G-G-CT-G-C-C--C-G-G-G-C--C-------GAT-TGG-----G-G-T-C-T-G-G-G-T-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq257(name, align);
seqs.push_back(newSeq257);
name = "GQY1XT001EJVJ8";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---C---ATA-A-----G-A-C-T-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq258(name, align);
seqs.push_back(newSeq258);
name = "GQY1XT001EJSIK";
align = "A-T--T-T--CA-A-A-C-T-G-G--AA-G-T-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-AC-TG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--TG------GTC-ATC-----G-A-C-C-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-T-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGATTAAA";
Sequence newSeq259(name, align);
seqs.push_back(newSeq259);
name = "GQY1XT001EJC79";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq260(name, align);
seqs.push_back(newSeq260);
name = "GQY1XT001EJ8V5";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq261(name, align);
seqs.push_back(newSeq261);
name = "GQY1XT001EJ37H";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq262(name, align);
seqs.push_back(newSeq262);
name = "GQY1XT001EJ24C";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--T---G----TC-A-----T-G-A-C-C-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-T-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGATTAAA";
Sequence newSeq263(name, align);
seqs.push_back(newSeq263);
name = "GQY1XT001EIQO8";
align = "A-T--T-G--GA-A-A-C-T-G-T--TT-A-A-C--T-G-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-T-G--G---C----AA-A-----G-C-C-A-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq264(name, align);
seqs.push_back(newSeq264);
name = "GQY1XT001EHRTI";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-----G-G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq265(name, align);
seqs.push_back(newSeq265);
name = "GQY1XT001EHPLG";
align = "T-T--T-T--GA-A-A-C-T-G-T--AT-G-A-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CA-G-G-G-A----G---C-----A-AA----G-C-T-T-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq266(name, align);
seqs.push_back(newSeq266);
name = "GQY1XT001EHPDN";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq267(name, align);
seqs.push_back(newSeq267);
name = "GQY1XT001EHHQV";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G---A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-CCAA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq268(name, align);
seqs.push_back(newSeq268);
name = "GQY1XT001EH12T";
align = "A-G--G-C--GA-T-A-C-G-G-G--CATA-A-C--T-T-G-A-G-T-A-C-TG-TA-G-G-G-G-T-A--AC-T-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GC-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GA-T-G-GC-GAA-GG-CAG-G-TT-A--CTGG-GC-AG-T-T-ACT--GACG-CTG-A-GG--A-G-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-G-TG-GG--CG-C-T-A-G-GT-G-T-G--A-G-G-G-T--C-------TTT-CA-C----G-A-C-T-T-T-C-G-T-G-C-C--GT--A-G-C-T-AA-C-G-C-A-T-TAA-G-CGC-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTAAA";
Sequence newSeq269(name, align);
seqs.push_back(newSeq269);
name = "GQY1XT001EGK7D";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-G----T---T----CA-AG----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq270(name, align);
seqs.push_back(newSeq270);
name = "GQY1XT001EG5VE";
align = "A-T--T-G--GA-A-A-C-T-G-C--AT-A-T-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----GA-A-----G-C-C-C-T-T-T-G-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq271(name, align);
seqs.push_back(newSeq271);
name = "GQY1XT001EFRQ9";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-CA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq272(name, align);
seqs.push_back(newSeq272);
name = "GQY1XT001EEEZ6";
align = "C-G--C-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq273(name, align);
seqs.push_back(newSeq273);
name = "GQY1XT001EE22V";
align = "C-G--T-T--GA-A-A-C-T-G----GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-G--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-C-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-G-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq274(name, align);
seqs.push_back(newSeq274);
name = "GQY1XT001EDXUZ";
align = "A-T--T-G--GA-A-A-C-T-G-T--TA-A-G-C--T-G-G-A-G-T-A-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---C---ATG-G-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq275(name, align);
seqs.push_back(newSeq275);
name = "GQY1XT001EDVDZ";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-AAGTG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq276(name, align);
seqs.push_back(newSeq276);
name = "GQY1XT001ECOVZ";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GGAA-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AG-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C--AAGAATGAA";
Sequence newSeq277(name, align);
seqs.push_back(newSeq277);
name = "GQY1XT001EC1PC";
align = "G-T--T-C--AA-A-A-C-T-G-T--TC-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AGA-T--A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G----------ACT-GA-CC-----C-C-A-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq278(name, align);
seqs.push_back(newSeq278);
name = "GQY1XT001EBNLI";
align = "C-C--T-G--CG-A-A-C-T-G-G--GT-T-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AT--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-T-T-ACT--GACA-CTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G-T--C--------GC-AA------G-A-C-T-T-C-G-G-T-G-C-C--GC--A-G-T-T-AA-C-G-C-A-T-TAA-G-TGC-TCC-GCC-T-G-GGG-AG-TA--CG-TA-C-G-C-A-AGTATGAA";
Sequence newSeq279(name, align);
seqs.push_back(newSeq279);
name = "GQY1XT001EBKJQ";
align = "A-T--T-T--GG-A-A-C-T-G-T--GT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-T--T---C----AA-GA------A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T---GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq280(name, align);
seqs.push_back(newSeq280);
name = "GQY1XT001EAXM4";
align = "C-G--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-G-G-A-C--C--------GA-CG------G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq281(name, align);
seqs.push_back(newSeq281);
name = "GQY1XT001EADVY";
align = "T-T--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-T-T-A-G-GT-G-T-C--G-G-T-G-A--G---C----AA-A-----G-C-T-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-A-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq282(name, align);
seqs.push_back(newSeq282);
name = "GQY1XT001EA7AT";
align = "A-T--T-G--GG-A-A-C-T-A-C--CG-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq283(name, align);
seqs.push_back(newSeq283);
name = "GQY1XT001E3176";
align = "..T--C-T--GA-T-A-C-T-G-C--TG-T-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--C-------AT--A-------A---G-A-C-TTCTG-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq284(name, align);
seqs.push_back(newSeq284);
name = "GQY1XT001E304Z";
align = "T-T--T-A--GA-A-A-C-T-G-C--TC-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-T-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----TA-GA----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq285(name, align);
seqs.push_back(newSeq285);
name = "GQY1XT001E1O3T";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-G-G-G--A---C---ATA-A-----G-T-T-T-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq286(name, align);
seqs.push_back(newSeq286);
name = "GQY1XT001E076I";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------GAG-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq287(name, align);
seqs.push_back(newSeq287);
name = "GQY1XT001DZ8G2";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-C-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq288(name, align);
seqs.push_back(newSeq288);
name = "GQY1XT001DZ55W";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq289(name, align);
seqs.push_back(newSeq289);
name = "GQY1XT001DYZRF";
align = "A-C--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T---ATG-G-----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq290(name, align);
seqs.push_back(newSeq290);
name = "GQY1XT001DYT64";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--G-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq291(name, align);
seqs.push_back(newSeq291);
name = "GQY1XT001DYSF1";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-A--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-G-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-G-C-C----C---C----AT-TG----G-G-G-C---C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq292(name, align);
seqs.push_back(newSeq292);
name = "GQY1XT001DYRS9";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq293(name, align);
seqs.push_back(newSeq293);
name = "GQY1XT001DYPI5";
align = "A-T--T-T--CA-A-A-C-T-G-G--AA-G-T-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-AC-TG-T-G-ACT--GACG-CTGAA-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--T-------GTC-AT------G-A-C-C-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-T-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGATTAAA";
Sequence newSeq294(name, align);
seqs.push_back(newSeq294);
name = "GQY1XT001DYN2K";
align = "T-A--C-C--AA-A-A-C-T-G-T--TG-G-A-C--T-C-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--AA-T-GG-A-ATT-C-C-C-A-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TT-G--CTGG-AC-TG-T-A-ACT--GACA-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-G--T-------ATC-GA-T----T-C-C-C-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-T-TAA-G-TAT-TCC-GCC-T-G-GGG-AC-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq295(name, align);
seqs.push_back(newSeq295);
name = "GQY1XT001DYM8E";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GAGG-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G---C--C-G-G-T-G--CG------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq296(name, align);
seqs.push_back(newSeq296);
name = "GQY1XT001DYDGQ";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq297(name, align);
seqs.push_back(newSeq297);
name = "GQY1XT001DXFSS";
align = "A-T--T-T--GA-A-A-C-T---G--TT-T-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq298(name, align);
seqs.push_back(newSeq298);
name = "GQY1XT001DXCE4";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq299(name, align);
seqs.push_back(newSeq299);
name = "GQY1XT001DWX52";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-C-G-C--T-C-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-TGT-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C-----A-TG----G-C-C-C-C-C-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq300(name, align);
seqs.push_back(newSeq300);
name = "GQY1XT001DW3U5";
align = "A-T--T-T--GA-A-A-C-T-G-T--AG-T-T-C--T-T-G-A-G-T-G-A-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AT-T-A-ACT-GAACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GACC------C-C-T-T-C-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-CAA-AGGTTGAA";
Sequence newSeq301(name, align);
seqs.push_back(newSeq301);
name = "GQY1XT001DVWF7";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-A-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq302(name, align);
seqs.push_back(newSeq302);
name = "GQY1XT001DVSKQ";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AGA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--C---C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq303(name, align);
seqs.push_back(newSeq303);
name = "GQY1XT001DVP26";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq304(name, align);
seqs.push_back(newSeq304);
name = "GQY1XT001DUPBA";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq305(name, align);
seqs.push_back(newSeq305);
name = "GQY1XT001DUJQE";
align = "T-C--T-G--GA-A-A-C-T-G-C--GT-C-G-C--T-G-G-A-G-T-A-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AGA-G-C-G-TGGG-G--AGC---AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-C--G-G-G---G--A---C----GA-C-----A-G-T-G-C-C-C-G-G-T-G-C-C--GC--C-G---C-AA-C-G-C-A-G-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq306(name, align);
seqs.push_back(newSeq306);
name = "GQY1XT001DUC9E";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-G-C--C---C----GA-A-----G-G-G-C-G-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq307(name, align);
seqs.push_back(newSeq307);
name = "GQY1XT001DU5IH";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-T-T-A-G-GT-G-T-C--G-G-T-G-A--G---C----AA-A-----G-C-T-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-A-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq308(name, align);
seqs.push_back(newSeq308);
name = "GQY1XT001DU5G9";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GT--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq309(name, align);
seqs.push_back(newSeq309);
name = "GQY1XT001DTZQL";
align = "T-T--T-G--GG-A-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-A-A-GCT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-C--G-G-A-G-G-----------GG-AA--------C-C-T-T-C-G-G-T-G-C-C--GG--A-G-T-A-AA-C-A-C-A-A-TAA-G-CAC-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq310(name, align);
seqs.push_back(newSeq310);
name = "GQY1XT001DTVYI";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-GG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq311(name, align);
seqs.push_back(newSeq311);
name = "GQY1XT001DTDNX";
align = "T-T--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq312(name, align);
seqs.push_back(newSeq312);
name = "GQY1XT001DT8QU";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--CGA------AT-GG------G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq313(name, align);
seqs.push_back(newSeq313);
name = "GQY1XT001DT73O";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T---G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq314(name, align);
seqs.push_back(newSeq314);
name = "GQY1XT001DS1JN";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq315(name, align);
seqs.push_back(newSeq315);
name = "GQY1XT001DRPPW";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq316(name, align);
seqs.push_back(newSeq316);
name = "GQY1XT001DRHRE";
align = "A-T--T-T--GA-A-A-C-T-G-T--AG-G-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-GCC----------GAT-TG-AG-----G-T-C-T-G-G-G-T-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq317(name, align);
seqs.push_back(newSeq317);
name = "GQY1XT001DQU6D";
align = "A-C--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---CT---AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq318(name, align);
seqs.push_back(newSeq318);
name = "GQY1XT001DQOL0";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-GCAAGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq319(name, align);
seqs.push_back(newSeq319);
name = "GQY1XT001DQH6M";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq320(name, align);
seqs.push_back(newSeq320);
name = "GQY1XT001DQB6Y";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-A-----G-A-A-C-C-TCC-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq321(name, align);
seqs.push_back(newSeq321);
name = "GQY1XT001DQ6WQ";
align = "C-G----T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq322(name, align);
seqs.push_back(newSeq322);
name = "GQY1XT001DPU46";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-G-G-G-G----G---C----CA-AG----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq323(name, align);
seqs.push_back(newSeq323);
name = "GQY1XT001DPMQQ";
align = "T-C--T-T--GG-A-A-C-T-G-C--GC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-G-ACT--GACG-TTG-A-GG--C-C-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C---AGA-G-----A-C-T-G-C-C-C-G-G-TGG-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq324(name, align);
seqs.push_back(newSeq324);
name = "GQY1XT001DPG56";
align = "C-G--T-T--GA-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-T-G-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq325(name, align);
seqs.push_back(newSeq325);
name = "GQY1XT001DORYK";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-TGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq326(name, align);
seqs.push_back(newSeq326);
name = "GQY1XT001DOMBN";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq327(name, align);
seqs.push_back(newSeq327);
name = "GQY1XT001DOITQ";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGAG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq328(name, align);
seqs.push_back(newSeq328);
name = "GQY1XT001DOESM";
align = "ATT--T-T--GA-A-A-C-T-G-T--GT-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq329(name, align);
seqs.push_back(newSeq329);
name = "GQY1XT001DO480";
align = "C-T--T-G--CG-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-TGG--GTG-G-G-T--A--------TG-GA------C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq330(name, align);
seqs.push_back(newSeq330);
name = "GQY1XT001DNKOZ";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq331(name, align);
seqs.push_back(newSeq331);
name = "GQY1XT001DMXE2";
align = "C-C--T-T--GG-A-A-C-T-G-C--AT-G-G-C--T-G-G-A-G-T-G---CG-GA-G---G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-CG-G-G-G-G-A--C---G----AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq332(name, align);
seqs.push_back(newSeq332);
name = "GQY1XT001DMKGX";
align = "A-C--T-C--GG-A-A-C-T-G-G--CG-T-G-C--T-A-G-A-G-T-G-T-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AA-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-T--C---CG---AC-A-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq333(name, align);
seqs.push_back(newSeq333);
name = "GQY1XT001DM11M";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--C---T----AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq334(name, align);
seqs.push_back(newSeq334);
name = "GQY1XT001DLPOT";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-AGAACGGT-G-AAA--TG-C-AT-AGA-AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG--AA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq335(name, align);
seqs.push_back(newSeq335);
name = "GQY1XT001DLMPA";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T---G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq336(name, align);
seqs.push_back(newSeq336);
name = "GQY1XT001DL5J3";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGGAGG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq337(name, align);
seqs.push_back(newSeq337);
name = "GQY1XT001DL4BQ";
align = "T-T--T-G--GA-A-A-C-T-G-T--TC-A-A-C--T-T-G-A-G-T-G-C-AG-AA-G-G-G-G-A-G--AG-T-GG-A-ATT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-T--A-G-G-C-C--C---T----AT-CC----G-G-G-G-C-T-T-A-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq338(name, align);
seqs.push_back(newSeq338);
name = "GQY1XT001DL47B";
align = "A-T--T-T--GG-A-A-C-T-G-T--GT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----TA-CG----G-A-C-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq339(name, align);
seqs.push_back(newSeq339);
name = "GQY1XT001DIUN5";
align = "A-T--T-G--GA-A-A-C-T-G-T--CC-A-A-C--T-T-G-A-A-T-G-C-AG-AA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-A--CTGG-TC-TG-T-G-ATT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq340(name, align);
seqs.push_back(newSeq340);
name = "GQY1XT001DIS0K";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-AG----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq341(name, align);
seqs.push_back(newSeq341);
name = "GQY1XT001DIM47";
align = "A-T--T-T--GA-A-A-C-T-G-T--AC-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-AGG-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-CGG-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA--C-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGGAGG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq342(name, align);
seqs.push_back(newSeq342);
name = "GQY1XT001DIDBJ";
align = "A-T--T-G--GA-A-A-C-T-G-T--CG-C-G-C--T-C-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---ACC-A-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA-CGG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq343(name, align);
seqs.push_back(newSeq343);
name = "GQY1XT001DHWUM";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACC--GACA-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-C-C-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq344(name, align);
seqs.push_back(newSeq344);
name = "GQY1XT001DHOP9";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq345(name, align);
seqs.push_back(newSeq345);
name = "GQY1XT001DHLYL";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-TGG-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATGGC-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-TGG--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-TGG-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq346(name, align);
seqs.push_back(newSeq346);
name = "GQY1XT001DH9DZ";
align = "C-G--T-T--GA-A-A-C-T-G----GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-GCGGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq347(name, align);
seqs.push_back(newSeq347);
name = "GQY1XT001DGVVI";
align = "A-T--T-T--GA-A-A-C-T-G-T--TG-G-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq348(name, align);
seqs.push_back(newSeq348);
name = "GQY1XT001DFIYO";
align = "C-G--T-T--GA-A-A-C-T-G-G--GT-G-TCC--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GG------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq349(name, align);
seqs.push_back(newSeq349);
name = "GQY1XT001DFEAQ";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq350(name, align);
seqs.push_back(newSeq350);
name = "GQY1XT001DFBY0";
align = "T-T--T-T--GA-A-A-C-T-G-A--GT-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C--G-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----A--AA----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq351(name, align);
seqs.push_back(newSeq351);
name = "GQY1XT001DETP8";
align = "A-T--T-T--GA-A-A-C-T-G-T--CA-G-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq352(name, align);
seqs.push_back(newSeq352);
name = "GQY1XT001DEOXH";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------AAA-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq353(name, align);
seqs.push_back(newSeq353);
name = "GQY1XT001DEN9A";
align = "T-C--T-T--GG-A-A-C-T-G-T--GC-G-G-C--T-G-G-A-G-T-G---CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-CG-G-G-G-C-A--C---G----AC-A-----G-T-G-C-T-T-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGA-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq354(name, align);
seqs.push_back(newSeq354);
name = "GQY1XT001DEM5V";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-T-G-C--T-G-A-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CA-G-G-G-G----G---C-----A-GG----G-C-C-C-C-C-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq355(name, align);
seqs.push_back(newSeq355);
name = "GQY1XT001DEK0W";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G---C--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq356(name, align);
seqs.push_back(newSeq356);
name = "GQY1XT001DE7OZ";
align = "C-G----T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-CT-G---T--C-C-G-G-T--T-------CTA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq357(name, align);
seqs.push_back(newSeq357);
name = "GQY1XT001DDTEX";
align = "A-C--T-C--AA-A-A-C-T-G-C--AG-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-TCC--G-G-C-C-C----------GAT-TG-GG-----G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq358(name, align);
seqs.push_back(newSeq358);
name = "GQY1XT001DDAO6";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AA-A-----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq359(name, align);
seqs.push_back(newSeq359);
name = "GQY1XT001DD70H";
align = "A-T--T-T--C--A-A-C-T-G-G--AA-G-T-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--T-------GTC-AT------G-A-C-T-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-G-T-A-T-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGATTAAA";
Sequence newSeq360(name, align);
seqs.push_back(newSeq360);
name = "GQY1XT001DD2SA";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq361(name, align);
seqs.push_back(newSeq361);
name = "GQY1XT001DCJ7D";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-A-G-AGGTT-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-G--A-G-G-G-T--G---C-----T-A----AG-C-A-T-C-C-T-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq362(name, align);
seqs.push_back(newSeq362);
name = "GQY1XT001DC7XN";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGGGG-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq363(name, align);
seqs.push_back(newSeq363);
name = "GQY1XT001DBUC8";
align = "A-T--T-T--GA-A-A-C-T-G-T--CA-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--A---C----GA-CA----G-T-T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq364(name, align);
seqs.push_back(newSeq364);
name = "GQY1XT001DBJBB";
align = "A-T--T-G--GG-A-A-C-T-A-C--CG-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq365(name, align);
seqs.push_back(newSeq365);
name = "GQY1XT001DB8H8";
align = "A-T--T-G--GG-A-A-C-T-G-G--CG-C-G-C--T-G-G-A-G-T-G-C-CG-GA---G-G-G-T-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AG-G-----G-C-C-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq366(name, align);
seqs.push_back(newSeq366);
name = "GQY1XT001DAG24";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-C--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq367(name, align);
seqs.push_back(newSeq367);
name = "GQY1XT001D9K26";
align = "C-C--T-G--CG-A-A-C-T-G-G--GA-T-G-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq368(name, align);
seqs.push_back(newSeq368);
name = "GQY1XT001D8B8W";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-C-G-G--G---C----AA-A-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq369(name, align);
seqs.push_back(newSeq369);
name = "GQY1XT001D8755";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq370(name, align);
seqs.push_back(newSeq370);
name = "GQY1XT001D7OHA";
align = "T-C--T-G--GA-A-A-C-T-G-T-GTA-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq371(name, align);
seqs.push_back(newSeq371);
name = "GQY1XT001D7MZG";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAGC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C-----A-GG----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq372(name, align);
seqs.push_back(newSeq372);
name = "GQY1XT001D7GR1";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq373(name, align);
seqs.push_back(newSeq373);
name = "GQY1XT001D6II6";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-T-CG-GA---G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-C-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AC-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq374(name, align);
seqs.push_back(newSeq374);
name = "GQY1XT001D5V6Q";
align = "C-G--T-G--GA-A-A-C-C-G-A--GC-A-G-C--T-A-G-A-G-T-G-C-AG-TA-G-A-G-G-A-T--CG-T-GG-A-ATT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-GA-T--CTGG-GC-TG-C-A-ACT--GACG-CTC-A-GT--C-C-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TA-C-T-A-A-GT-G-T-T--G-G---G-G-----------TC-AA--------A-C-C-T-C-A-G-T-G-C-T--GC--A-G-T-T-AA-C-G-C-A-A-TAA-G-TAC-TCC-GCC-T-G-AGT-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq375(name, align);
seqs.push_back(newSeq375);
name = "GQY1XT001D53Q1";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq376(name, align);
seqs.push_back(newSeq376);
name = "GQY1XT001D4YFG";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGGGG-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-GCC-T-G-GGG-AG-TA--CG-CA-C-G-C-A-AGTGTGAA";
Sequence newSeq377(name, align);
seqs.push_back(newSeq377);
name = "GQY1XT001D4IEY";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------GAG-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq378(name, align);
seqs.push_back(newSeq378);
name = "GQY1XT001D4G6Q";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--C---A----GA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq379(name, align);
seqs.push_back(newSeq379);
name = "GQY1XT001D450X";
align = "T-C--T-G--GG-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AG-G-----G-C-C-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq380(name, align);
seqs.push_back(newSeq380);
name = "GQY1XT001D3T3X";
align = "T-C--T-G--GA-A-A-C-T-G-C--GC-C-G-C--T-G-G-A-G-T-A-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AGA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-C--G-G-G-G-G--A---CG---AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq381(name, align);
seqs.push_back(newSeq381);
name = "GQY1XT001D3IK7";
align = "A-T--A-A--GA-A-A-C-T-G-T--CG-G-A-C--T-T-G-A-G-T-A-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-C-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-G-G-G-AA-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-A-A-ACT--GACG-CTG-A-GT--C-A-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-TCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--G-G-C-A-A-----------GG-AA--------T-T-G-T-C-G-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq382(name, align);
seqs.push_back(newSeq382);
name = "GQY1XT001D2RSU";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq383(name, align);
seqs.push_back(newSeq383);
name = "GQY1XT001D2QXP";
align = "A-T--T-T--GA-A-A-C-T-G-T--AG-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq384(name, align);
seqs.push_back(newSeq384);
name = "GQY1XT001D2C3B";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq385(name, align);
seqs.push_back(newSeq385);
name = "GQY1XT001D1Z7R";
align = "A-T--T-C--AA-A-A-C-T-G-A--CT-G-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-G-T--GG-T-GG-A-ATT-T-C-C-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-G-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-CA-C--CTGG-AC-TA-A-T-ACT--GACA-CTG-A-GG--T-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-TC--AA-C-T-A-G-CC-G-T-T--G-G-A-A-G--C-------CTT-GA------G-C-T-T-T-T-A-G-T-G-G-C--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-TTG-ACC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTAAA";
Sequence newSeq386(name, align);
seqs.push_back(newSeq386);
name = "GQY1XT001D12EL";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-T-CG-GA---G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq387(name, align);
seqs.push_back(newSeq387);
name = "GQY1XT001D0XYA";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq388(name, align);
seqs.push_back(newSeq388);
name = "GQY1XT001D0UJP";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-TAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GA------G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq389(name, align);
seqs.push_back(newSeq389);
name = "GQY1XT001D0MQQ";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AGA-T--A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-GTG-G-G----------TAT-GG-AC-----C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq390(name, align);
seqs.push_back(newSeq390);
name = "GQY1XT001D0E4F";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-G-G-G----T---C----AT-AA----G-A-C-T-T-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq391(name, align);
seqs.push_back(newSeq391);
name = "GQY1XT001D03R0";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-TG-G-G-G-G----T---C-------GA------A-C-C-T---C-A-G-T-G-C-T--GA--A-G-T-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq392(name, align);
seqs.push_back(newSeq392);
name = "GQY1XT001D033P";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AA-A-----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq393(name, align);
seqs.push_back(newSeq393);
name = "GQY1XT001CYUAQ";
align = "A-T--T-T--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACA-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CA-G-G-G-A----G---C-----A-AA----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq394(name, align);
seqs.push_back(newSeq394);
name = "GQY1XT001CYN5E";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq395(name, align);
seqs.push_back(newSeq395);
name = "GQY1XT001CXLAN";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq396(name, align);
seqs.push_back(newSeq396);
name = "GQY1XT001CXJOX";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G---A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq397(name, align);
seqs.push_back(newSeq397);
name = "GQY1XT001CXGFO";
align = "T-T--T-T--GA-A-A-C-T-G-T--AG-G-G-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-A--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-A-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G-----------GT-AA-GG-----C-C-C-C-C-G-G-T-G-C-C--GT--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq398(name, align);
seqs.push_back(newSeq398);
name = "GQY1XT001CX3HF";
align = "T-T--T-G--GA-A-A-C-T-G-T--TA-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq399(name, align);
seqs.push_back(newSeq399);
name = "GQY1XT001CWL63";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--C---C----GA-C-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq400(name, align);
seqs.push_back(newSeq400);
name = "GQY1XT001CWKMA";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------GAG-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq401(name, align);
seqs.push_back(newSeq401);
name = "GQY1XT001CW63U";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-TCCG-G-G-C-C-G----------AAT-GG-GG-----C-C---T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq402(name, align);
seqs.push_back(newSeq402);
name = "GQY1XT001CW42X";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq403(name, align);
seqs.push_back(newSeq403);
name = "GQY1XT001CW2KE";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C--AAGAATGAA";
Sequence newSeq404(name, align);
seqs.push_back(newSeq404);
name = "GQY1XT001CVWLK";
align = "A-T--C-G--GA-A-A-C-C-G-G--GC-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-C--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--T-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq405(name, align);
seqs.push_back(newSeq405);
name = "GQY1XT001CV50F";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq406(name, align);
seqs.push_back(newSeq406);
name = "GQY1XT001CUPYI";
align = "T-C--T-G-GAA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq407(name, align);
seqs.push_back(newSeq407);
name = "GQY1XT001CUJ15";
align = "T-C--T-G--GA-A-A-C-T-G-C--GT-C-G-C--T-G-G-A-G-T-A-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AGA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-CG-G-G-G-G-A--C---G----AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq408(name, align);
seqs.push_back(newSeq408);
name = "GQY1XT001CTW9V";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq409(name, align);
seqs.push_back(newSeq409);
name = "GQY1XT001CTKIZ";
align = "T-T--T-G--GA-A-A-C-T-G-T--GG-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-A-G-A--G---C----AA-A-----G-C-T-T-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-GT-T-C-G-CAAGAATGAA";
Sequence newSeq410(name, align);
seqs.push_back(newSeq410);
name = "GQY1XT001CTF9O";
align = "A-T--T-T--CA-A-A-C-T-G-G--AA-G-T-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-GTG-G-G--T-------ATG-GA------C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq411(name, align);
seqs.push_back(newSeq411);
name = "GQY1XT001CT4ZD";
align = "C-G--T-T--GA-A-A-C-C-T-G--GC-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGAG----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T---GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq412(name, align);
seqs.push_back(newSeq412);
name = "GQY1XT001CSW2S";
align = "A-T--C-T--AA-A-A-C-T-G-G--TA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-A-G-GC-GAA-GG-CGA-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCC-T-AAAC-G-A-TG-GA--TA-C-T-A-G-AG-G-A-A--G-G-G-G-G--T-------ATA-A-------A-C-TCC-TCC-T-G-T-C-T-C--GA--A-G-C-A-AA-C-G-C-G-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq413(name, align);
seqs.push_back(newSeq413);
name = "GQY1XT001CSRVL";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-C-G------------ATA-TAC---------A-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq414(name, align);
seqs.push_back(newSeq414);
name = "GQY1XT001CSIAG";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAG--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----CCC-T-C-C-G---T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq415(name, align);
seqs.push_back(newSeq415);
name = "GQY1XT001CSF7O";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-AG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq416(name, align);
seqs.push_back(newSeq416);
name = "GQY1XT001CRZOA";
align = "A-T--T-T--GA-A-A-C-T-G-T--AG-G-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq417(name, align);
seqs.push_back(newSeq417);
name = "GQY1XT001CRZFM";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq418(name, align);
seqs.push_back(newSeq418);
name = "GQY1XT001CRXBF";
align = "A-T--T-T--GG-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-TGT-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AT-G-----G-C-C-C-C-C-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq419(name, align);
seqs.push_back(newSeq419);
name = "GQY1XT001CQH75";
align = "A-T--T-G--GA-A-G-C-T-G-T--CG-C-G-C--T-C-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AC-A-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq420(name, align);
seqs.push_back(newSeq420);
name = "GQY1XT001CQAZN";
align = "T-T--T-T--GG-A-A-C-T-G-T--CA-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq421(name, align);
seqs.push_back(newSeq421);
name = "GQY1XT001CPWEO";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------AAA-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq422(name, align);
seqs.push_back(newSeq422);
name = "GQY1XT001CPUCT";
align = "C-G--T-T--G--A-A-C-T-G-G--GG-C-C-T--T-G-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-G-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq423(name, align);
seqs.push_back(newSeq423);
name = "GQY1XT001CPP9D";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq424(name, align);
seqs.push_back(newSeq424);
name = "GQY1XT001CPONM";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--CGA------GT-GA------G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq425(name, align);
seqs.push_back(newSeq425);
name = "GQY1XT001CPKJY";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq426(name, align);
seqs.push_back(newSeq426);
name = "GQY1XT001COH2D";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-ACGGT-G-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AT-G-----G-C-C-C-C-C-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq427(name, align);
seqs.push_back(newSeq427);
name = "GQY1XT001COC8H";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-CCGGGG-G-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq428(name, align);
seqs.push_back(newSeq428);
name = "GQY1XT001CO725";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq429(name, align);
seqs.push_back(newSeq429);
name = "GQY1XT001CNM4Q";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G----------GCA-AA-GC-----C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq430(name, align);
seqs.push_back(newSeq430);
name = "GQY1XT001CMN1O";
align = "T-T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq431(name, align);
seqs.push_back(newSeq431);
name = "GQY1XT001CMIJN";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------GAG-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq432(name, align);
seqs.push_back(newSeq432);
name = "GQY1XT001CMEK1";
align = "T-T--T-T--GG-A-A-C-T-G-T--CA-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACA-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-G-----G-C-T-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq433(name, align);
seqs.push_back(newSeq433);
name = "GQY1XT001CM3X9";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-GTT-C--G-G-G-T-C--CAAA-----TG-AG------G-A-T-C-T-G-A-G-T-G-A-T--ACA-A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCCGACC-T-G-GGG-AG-TA--CG-CCGG-G-CAA-ACGGTGAA";
Sequence newSeq434(name, align);
seqs.push_back(newSeq434);
name = "GQY1XT001CLRZ4";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G---T--C-C-G-G-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-GCGGTGAA";
Sequence newSeq435(name, align);
seqs.push_back(newSeq435);
name = "GQY1XT001CLQMC";
align = "T-C--T-G-GAA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq436(name, align);
seqs.push_back(newSeq436);
name = "GQY1XT001CKBTX";
align = "A-C--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-CG-GA---G-G-G-T-A--AG-C-GG-A-ATT-C-C-G-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GC-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-GT-T---T----AC-G-----G-A-C-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq437(name, align);
seqs.push_back(newSeq437);
name = "GQY1XT001CJVHK";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-T-G--C---C----AA-A-----G-G-C-T-C-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq438(name, align);
seqs.push_back(newSeq438);
name = "GQY1XT001CJKVR";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T--T-C-G-G-G----T---C----AA-AT----G-A-G-A-T-C-T-GAG-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq439(name, align);
seqs.push_back(newSeq439);
name = "GQY1XT001CJ8YZ";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-G-ACT--GACG-TTG-A-GG--C-C-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AG-A-----G-A-C-TGC-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq440(name, align);
seqs.push_back(newSeq440);
name = "GQY1XT001CI4ZB";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq441(name, align);
seqs.push_back(newSeq441);
name = "GQY1XT001CGUEK";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq442(name, align);
seqs.push_back(newSeq442);
name = "GQY1XT001CFUML";
align = "T-T--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T--G-G-G-G-G--T---C----GA-A-------C---C---T-C-A-G-T-G-C-T--GA--A-G-T-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq443(name, align);
seqs.push_back(newSeq443);
name = "GQY1XT001CFTIS";
align = "C-A--G-A--GA-A-A-C-C-G-T--AT-A-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-GT-G-T----C-------G--G-------GA---AA-----C-C-G-G-T---G-C-T---G----A---A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq444(name, align);
seqs.push_back(newSeq444);
name = "GQY1XT001CFB0Z";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--CGA------AT-GG------G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq445(name, align);
seqs.push_back(newSeq445);
name = "GQY1XT001CF9D9";
align = "A-T--T-G--GA-A-A-C-T-G-T--CC-A-A-C--T-T-G-A-A-T-G-C-AG-AA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-A--CTGG-TC-TG-T-G-ATT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-T--GG--A-G-T-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq446(name, align);
seqs.push_back(newSeq446);
name = "GQY1XT001CF1VL";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-TCCG-G-GCC-G------------ATT-GAGG--------C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq447(name, align);
seqs.push_back(newSeq447);
name = "GQY1XT001CEOFM";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq448(name, align);
seqs.push_back(newSeq448);
name = "GQY1XT001CDKVO";
align = "A-T--T-T--GG-A-A-C-T-G-T--AA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGAATGAA";
Sequence newSeq449(name, align);
seqs.push_back(newSeq449);
name = "GQY1XT001CDDPN";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq450(name, align);
seqs.push_back(newSeq450);
name = "GQY1XT001CD2TW";
align = "T-T--T-T--GG-A-A-C-T-A-T--CT-A-G-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CA-G-G-G-A----G---C-----A-AA----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq451(name, align);
seqs.push_back(newSeq451);
name = "GQY1XT001CCYF2";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--C---C----GA-C-----G-G-T-C-T-C-C-G-G-C-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGA-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq452(name, align);
seqs.push_back(newSeq452);
name = "GQY1XT001CCWT6";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TAGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq453(name, align);
seqs.push_back(newSeq453);
name = "GQY1XT001CCR1M";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq454(name, align);
seqs.push_back(newSeq454);
name = "GQY1XT001CCI1I";
align = "A-T--T-T-CAA-A-A-C-T-G-G--AA-G-T-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--T-------GTC-AT------G-A-C-C-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-T-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGATTAAA";
Sequence newSeq455(name, align);
seqs.push_back(newSeq455);
name = "GQY1XT001CCGUZ";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-T-G--G---C----AA-A-----G-C-C-A-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq456(name, align);
seqs.push_back(newSeq456);
name = "GQY1XT001CCE0U";
align = "T-T--T-T--GA-A-A-C-T-G-T--AG-G-G-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-A--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-A-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G----------GTA-AG-GC-----C-C-C-C-C-G-G-T-G-C-C--GT--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq457(name, align);
seqs.push_back(newSeq457);
name = "GQY1XT001CC1XY";
align = "T-T--T-G--GA-A-A-C-T-G-C--GA-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---G----CA-A-----A-GCC-C-C-T-C-G-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-A-TAA-G-CAC-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq458(name, align);
seqs.push_back(newSeq458);
name = "GQY1XT001CBVTY";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G---A-G-T-A--TG-C-GG-A-ATG-C---T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq459(name, align);
seqs.push_back(newSeq459);
name = "GQY1XT001CBFFO";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq460(name, align);
seqs.push_back(newSeq460);
name = "GQY1XT001CB1V8";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA--C-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGAATGAA";
Sequence newSeq461(name, align);
seqs.push_back(newSeq461);
name = "GQY1XT001CAQ0P";
align = "T-T--T-G--GA-A-A-C-T-G-C--CT-G-A-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GC-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GGA-GG-CGG-C-TT-A--CTGG-AC-GG-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq462(name, align);
seqs.push_back(newSeq462);
name = "GQY1XT001CAKTI";
align = "A-C--A-T--AA-A-A-C-T-G-G--GA-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-T-C-C-A-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TT-G-G-G-AA-G-A-AC-A-CC-GG-A-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCC-T-AAAC-G-A-TG-GA--TA-C-T-A-G-AC-G-A-A--G-G-G-G-G--T-------ACA-A-------A-CTC-C-TCC-T-G-T-G-T-C--GA--A-G-C-A-AA-C-G-C-G-A-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq463(name, align);
seqs.push_back(newSeq463);
name = "GQY1XT001CAG4J";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GT-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-T----T---C----AA-GA------A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq464(name, align);
seqs.push_back(newSeq464);
name = "GQY1XT001C9TCH";
align = "G-T--T-C--CG-G-A-C-T-G-G--GC-G-G-C--T-C-G-A-G-T-G-C-GG-TA-G-A-G-G-A-G--AG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-GAA--TG-C-GC-AG--AT-A-TC-G-G-G-AA-G-A-AC-A-CC-GA-T-G-GC-GAA-GG-CAG-C-TC-T--CTGG-GC-CG-T-C-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-T-GGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CC-A-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G-----------AT-CC-C------C-C-C-T-C-C-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTAAA";
Sequence newSeq465(name, align);
seqs.push_back(newSeq465);
name = "GQY1XT001C9SSG";
align = "C-GT-T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C---G-A-G--G-------CTT-CGA-------C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq466(name, align);
seqs.push_back(newSeq466);
name = "GQY1XT001C9NGS";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----GA--C----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq467(name, align);
seqs.push_back(newSeq467);
name = "GQY1XT001C9K3I";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq468(name, align);
seqs.push_back(newSeq468);
name = "GQY1XT001C8MW2";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-A-----G-A-A-C-C-TCC-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq469(name, align);
seqs.push_back(newSeq469);
name = "GQY1XT001C8MIJ";
align = "A-T--T-G--GG-A-A-C-T-A-C--CG-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-AG--G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TTG---CTGG-AC-AG-TA--ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq470(name, align);
seqs.push_back(newSeq470);
name = "GQY1XT001C8MC2";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--C---A----GA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq471(name, align);
seqs.push_back(newSeq471);
name = "GQY1XT001C868Q";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-G-G-G----T---C----AT-AA----G-A-C-T-T-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq472(name, align);
seqs.push_back(newSeq472);
name = "GQY1XT001C7YPJ";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C---G---G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACAGTGAA";
Sequence newSeq473(name, align);
seqs.push_back(newSeq473);
name = "GQY1XT001C7PTU";
align = "A-T--C-T--AA-A-A-C-T-G-G--TA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----TAGA-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq474(name, align);
seqs.push_back(newSeq474);
name = "GQY1XT001C7C75";
align = "C-G--T-TG-GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-G-T--C-C-G---G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq475(name, align);
seqs.push_back(newSeq475);
name = "GQY1XT001C79Z4";
align = "T-T--T-TG-GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq476(name, align);
seqs.push_back(newSeq476);
name = "GQY1XT001C718S";
align = "C-T--C-T--GA-T-A-C-T-G-T--CG-G-G-C--T-A-G-A-G-T-T-T-AG-TT-G-C-G-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-C-G-G----------AGTCAAGGC---------T-C-TGC-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq477(name, align);
seqs.push_back(newSeq477);
name = "GQY1XT001C6ZPG";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-TCCG-G-GCC-GA-----------ATG-GGG---------C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq478(name, align);
seqs.push_back(newSeq478);
name = "GQY1XT001C6YHZ";
align = "C-GT-T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------AAA-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-GAC-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq479(name, align);
seqs.push_back(newSeq479);
name = "GQY1XT001C6PIP";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq480(name, align);
seqs.push_back(newSeq480);
name = "GQY1XT001C61JR";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-C-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq481(name, align);
seqs.push_back(newSeq481);
name = "GQY1XT001C5ZY5";
align = "T-C--T-T--GG-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G---CG-GA-G---G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-CA-G-G-G-C-A--C---G----AC-A-----G-T-G-C-T-T-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq482(name, align);
seqs.push_back(newSeq482);
name = "GQY1XT001C4V1I";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-G-C--C---C----GA-A-----G-G-G-C-G-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq483(name, align);
seqs.push_back(newSeq483);
name = "GQY1XT001C4G89";
align = "C-G--T-T--GA-A-A-C-T-G-G---G-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq484(name, align);
seqs.push_back(newSeq484);
name = "GQY1XT001C4B5B";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------AAA-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq485(name, align);
seqs.push_back(newSeq485);
name = "GQY1XT001C48GV";
align = "T-C--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-T-G-A-G-T-G-C-AG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-C-G-G-A--GT--C----AA-G-----G-C-T-C-T-G-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq486(name, align);
seqs.push_back(newSeq486);
name = "GQY1XT001C2094";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq487(name, align);
seqs.push_back(newSeq487);
name = "GQY1XT001C1ENK";
align = "T-C--T-G--GA-A-A-C-T-G-C--CT-G-G-C--T-G-G-A-G-T-A-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T---AGA-A-----G-G-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq488(name, align);
seqs.push_back(newSeq488);
name = "GQY1XT001C1E97";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq489(name, align);
seqs.push_back(newSeq489);
name = "GQY1XT001C1E4P";
align = "A-T--C-T--AA-A-A-C-T-G-G--TA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG---ATA-TT-A-G-G-AG-G-A-AC-A-CC-AG-A-G-GC-GAA-GG-CGA-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCC-T-AAAC-G-A-TG-GA--TA-C-T-A-G-AG-G-A-A--G-G-G-G-G---------TATA-AA-CT-----C-C-T-C-C-T-G-T-C-T-C--GA--A-G-C-A-AA-C-G-C-G-A-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq490(name, align);
seqs.push_back(newSeq490);
name = "GQY1XT001C1E0Z";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATTCC-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GT--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq491(name, align);
seqs.push_back(newSeq491);
name = "GQY1XT001C1C86";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-TCC--G-GCCCG------------ATT-GGG---------G-GCT-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq492(name, align);
seqs.push_back(newSeq492);
name = "GQY1XT001C0JEM";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq493(name, align);
seqs.push_back(newSeq493);
name = "GQY1XT001C0IZK";
align = "A-T--T-T--GA-A-A-C-T-G-T--AG-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-CTG-G-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T----G-G-G-G-A----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq494(name, align);
seqs.push_back(newSeq494);
name = "GQY1XT001C08ZG";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-C-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq495(name, align);
seqs.push_back(newSeq495);
name = "GQY1XT001C02D6";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G---G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-T-G--G---C----AA-A-----G-C-C-A-T-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq496(name, align);
seqs.push_back(newSeq496);
name = "GQY1XT001BZGJ5";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--CGA------AT-GG------G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq497(name, align);
seqs.push_back(newSeq497);
name = "GQY1XT001BZEEW";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq498(name, align);
seqs.push_back(newSeq498);
name = "GQY1XT001BZ5JC";
align = "T-T--T-T--GA-A-A-C-T-G-A--GT-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGCA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AA-A-----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq499(name, align);
seqs.push_back(newSeq499);
name = "GQY1XT001BYJE7";
align = "C-G--T-T--G--A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq500(name, align);
seqs.push_back(newSeq500);
name = "GQY1XT001BYHUX";
align = "T-T--T-T--GG-A-A-C-T-A-T--CT-A-G-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq501(name, align);
seqs.push_back(newSeq501);
name = "GQY1XT001BY7S6";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--C---T----AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq502(name, align);
seqs.push_back(newSeq502);
name = "GQY1XT001BXVN0";
align = "A-A--A-A--GA-T-A-C-T-G-C--AA-A-G-C--T-A-G-A-G-T-A-T-GA-CA-G-A-G-G-C-A--AG-T-GG-A-ACT-A-C-A-T-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AA--AT-A-TA-T-G-T-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-GT-CG-A-T-ACT--GACA-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCC-T-AAAC-G-A-TG-AG--TA-C-T-A-A-GT-G-T-T--G-G-T--------------GAG-GA------------A-T-C-A-G-T-G-C-T--GA--A-G-T-T-AA-C-G-C-A-T-TAA-G-TAC-TCC-GCC-T-G-AGT-AG-TA--CG-TA-C-G-C-A-AGTATGAA";
Sequence newSeq503(name, align);
seqs.push_back(newSeq503);
name = "GQY1XT001BXRJZ";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-GC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq504(name, align);
seqs.push_back(newSeq504);
name = "GQY1XT001BXP1D";
align = "C-T--T-G--CG-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AGAC-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-T-CTTGG-AC-TG-A-A-ACT--GACG-CTG-A-GG--T-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G-T--C--------GA-AA------G-A-C-T-T-C-G-G-T-G-C-C--GC--A-G-T-T-AA-C-G-C-A-A-TAA-G-TGC-TCC-GCC-T-G-GGGAGG-TA--CG-CA-C-G-C-A-AGTGTGAA";
Sequence newSeq505(name, align);
seqs.push_back(newSeq505);
name = "GQY1XT001BX4K9";
align = "A-T--T-T--GA-A-A-C-T-G-T---T-T-T-C--T-T-G-A-G-T-G-A-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AT-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GACC------C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-A-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq506(name, align);
seqs.push_back(newSeq506);
name = "GQY1XT001BWQQE";
align = "..T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----A--AA----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-T-A-AGAATGAA";
Sequence newSeq507(name, align);
seqs.push_back(newSeq507);
name = "GQY1XT001BWFAY";
align = "A-T--T-G--GA-A-A-C-T-G-T--AG-A-A-C--T-A-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-G-C--C---C----GA-A-----G-G-G-C-G-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq508(name, align);
seqs.push_back(newSeq508);
name = "GQY1XT001BWD9D";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-C-G-C--T-C-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq509(name, align);
seqs.push_back(newSeq509);
name = "GQY1XT001BW2CO";
align = "T-C--T-G--GA-A-A-C-T-A-T--GT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq510(name, align);
seqs.push_back(newSeq510);
name = "GQY1XT001BVPPE";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq511(name, align);
seqs.push_back(newSeq511);
name = "GQY1XT001BV13J";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq512(name, align);
seqs.push_back(newSeq512);
name = "GQY1XT001BV02F";
align = "G-C--T-T--GA-A-A-C-T-G-T--GT-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-TG--C-A-CG-AAA-G-C-A-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CTG-T-AAAC-G-A-TG-AT--TG-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GG--A-G-T-A-AA-C-A-C-A-A-TAA-G-CAA-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq513(name, align);
seqs.push_back(newSeq513);
name = "GQY1XT001BUOWZ";
align = "T-T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-G-C--C---CT---AA-G-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq514(name, align);
seqs.push_back(newSeq514);
name = "GQY1XT001BUI0U";
align = "A-T--T-T--GG-A-A-C-T-G-T--GT-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-TGG-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq515(name, align);
seqs.push_back(newSeq515);
name = "GQY1XT001BUBF2";
align = "A-T--T-T--GG-A-A-C-T-G-T--AA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq516(name, align);
seqs.push_back(newSeq516);
name = "GQY1XT001BTIDT";
align = "T-C--T-G--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-G-G-T--T---A----AC-A-----G-A-C-C-C-C-C-G-G-T-G-C-C--GA--A-G-C-C-AA-C-G-C-A-T-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq517(name, align);
seqs.push_back(newSeq517);
name = "GQY1XT001BSD18";
align = "C-G----T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq518(name, align);
seqs.push_back(newSeq518);
name = "GQY1XT001BSBWI";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq519(name, align);
seqs.push_back(newSeq519);
name = "GQY1XT001BS7HX";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-G-G-G-A-C--C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGGAGG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq520(name, align);
seqs.push_back(newSeq520);
name = "GQY1XT001BRX1J";
align = "T-T--T-G--GA-A-A-C-T-G-TA-TA-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-A-----G-A-A-C-C-TCC-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq521(name, align);
seqs.push_back(newSeq521);
name = "GQY1XT001BRNZN";
align = "G-T--T-T--GA-A-A-C-T-G-T--TC-T-T-C--T-T-G-A-G-T-G-A-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AT-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq522(name, align);
seqs.push_back(newSeq522);
name = "GQY1XT001BRLCO";
align = "G-T--T-C--AA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AAA-T--A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-GTG-G-G----------TAT-GG-AC-----C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq523(name, align);
seqs.push_back(newSeq523);
name = "GQY1XT001BR887";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--A---C----TG-A-----C-C-C-C-A-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGATTGAA";
Sequence newSeq524(name, align);
seqs.push_back(newSeq524);
name = "GQY1XT001BQRGU";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq525(name, align);
seqs.push_back(newSeq525);
name = "GQY1XT001BQN60";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-T-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq526(name, align);
seqs.push_back(newSeq526);
name = "GQY1XT001BQKS9";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--C-------ATA-AGA-----C-T-T-C-T-G-T-G-C-C-G-----G--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq527(name, align);
seqs.push_back(newSeq527);
name = "GQY1XT001BQBAR";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq528(name, align);
seqs.push_back(newSeq528);
name = "GQY1XT001BQ2OX";
align = "T-C--T-G--GA-A-A-C-T-A-T--GT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-TGA--GG-C-AG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq529(name, align);
seqs.push_back(newSeq529);
name = "GQY1XT001BPBSW";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq530(name, align);
seqs.push_back(newSeq530);
name = "GQY1XT001BOO42";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq531(name, align);
seqs.push_back(newSeq531);
name = "GQY1XT001BOD0P";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACA-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-AG----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq532(name, align);
seqs.push_back(newSeq532);
name = "GQY1XT001BNX1P";
align = "T-T--C-T--GA-T-A-C-T-G-C--TG-T-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-GTG-G-G--T-------ATG-GA------C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TG--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq533(name, align);
seqs.push_back(newSeq533);
name = "GQY1XT001BNKMD";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AG-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AC-A-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq534(name, align);
seqs.push_back(newSeq534);
name = "GQY1XT001BNINJ";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq535(name, align);
seqs.push_back(newSeq535);
name = "GQY1XT001BNHEB";
align = "A-T--T-C--AA-A-A-C-T-G-C--GA-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC---AAATA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-GT-G-T------C-G-G-G----------A----A--------A-C-----C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq536(name, align);
seqs.push_back(newSeq536);
name = "GQY1XT001BNEKF";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T----G-G-G-G-G----------CGT-CA--A-----G-C-T-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq537(name, align);
seqs.push_back(newSeq537);
name = "GQY1XT001BND9V";
align = "C-GT-T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq538(name, align);
seqs.push_back(newSeq538);
name = "GQY1XT001BMICD";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq539(name, align);
seqs.push_back(newSeq539);
name = "GQY1XT001BMGFB";
align = "A-T--T-T--CA-A-A-C-T-G-G--AA-G-T-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-TC-T--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--T-------GTC-AT------G-A-C-C-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-GAC-A-T-TAA-G-TAT-TCC-GCC-T-G-GGGAGG-TA--CG-GT-C-G-C-A-AGATTAAA";
Sequence newSeq540(name, align);
seqs.push_back(newSeq540);
name = "GQY1XT001BM6X4";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGGCC-GT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---CT---AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq541(name, align);
seqs.push_back(newSeq541);
name = "GQY1XT001BLVK4";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-A-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq542(name, align);
seqs.push_back(newSeq542);
name = "GQY1XT001BLQ5R";
align = "T-T--T-G--GA-A-A-C-T-G-C--CT-G-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq543(name, align);
seqs.push_back(newSeq543);
name = "GQY1XT001BL97L";
align = "T-C--T-G--GG-A-A-C-T-G-C--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--A---CG---AC-A-----G-T-T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq544(name, align);
seqs.push_back(newSeq544);
name = "GQY1XT001BKNRP";
align = "A-C--T-G-GAA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GC-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GGA-GG-CGG-C-TT-A--CTGG-AC-GA-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq545(name, align);
seqs.push_back(newSeq545);
name = "GQY1XT001BKMWZ";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-GG----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq546(name, align);
seqs.push_back(newSeq546);
name = "GQY1XT001BKLLZ";
align = "..T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq547(name, align);
seqs.push_back(newSeq547);
name = "GQY1XT001BKCW6";
align = "A-A--C-C--AA-A-A-C-T-G-C--AA-C-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq548(name, align);
seqs.push_back(newSeq548);
name = "GQY1XT001BKB24";
align = "T-T--T-T--GA-A-A-C-T-G-T--GT-T-G-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT---C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AA-A-----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq549(name, align);
seqs.push_back(newSeq549);
name = "GQY1XT001BK3EB";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---C---ATA-A-----G-A-C-T-T-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq550(name, align);
seqs.push_back(newSeq550);
name = "GQY1XT001BJ3RN";
align = "T-T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq551(name, align);
seqs.push_back(newSeq551);
name = "GQY1XT001BJ21N";
align = "A-C--T-C--AA-A-A-C-T-G-C--AG-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq552(name, align);
seqs.push_back(newSeq552);
name = "GQY1XT001BIYD4";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G---GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--CGA------GT-GA------G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq553(name, align);
seqs.push_back(newSeq553);
name = "GQY1XT001BIPG4";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-CGG-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GTGG-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq554(name, align);
seqs.push_back(newSeq554);
name = "GQY1XT001BHUGP";
align = "T-C--T-G--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-A-C-TG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq555(name, align);
seqs.push_back(newSeq555);
name = "GQY1XT001BHQ7A";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq556(name, align);
seqs.push_back(newSeq556);
name = "GQY1XT001BH0TX";
align = "C-G--T-T--GA-A-A-C-T-G----GT-T-T-C--T-T-G-A-G-C-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq557(name, align);
seqs.push_back(newSeq557);
name = "GQY1XT001BG7V4";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq558(name, align);
seqs.push_back(newSeq558);
name = "GQY1XT001BFAJA";
align = "G-T--T-C--AA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AA--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-TCG--G-T-G-G-G----------TAT-GG-AC-----C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq559(name, align);
seqs.push_back(newSeq559);
name = "GQY1XT001BEFPN";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq560(name, align);
seqs.push_back(newSeq560);
name = "GQY1XT001BE0A4";
align = "C-A--G-A--GA-A-A-C-C-G-T--AT-A-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-GT-G-T-C----G-G---------------GA-AA------------C---C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGAATGAA";
Sequence newSeq561(name, align);
seqs.push_back(newSeq561);
name = "GQY1XT001BDJ3H";
align = "T-T--C-T--GA-T-A-C-T-G-C--TG-T-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A----G-G-G-T--C-------AT--A-------A---G-A-C-TTCTG-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-GCC-T-G-GGGAGG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq562(name, align);
seqs.push_back(newSeq562);
name = "GQY1XT001BDFRW";
align = "T-A--C-C--AA-A-A-C-T-G-T--TG-G-A-C--T-T-G-A-G-T-G-C-A--GA-G-G-G-G-C-A--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-GC-CA-A-G-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-T--A-G-T-A-G--T-------TTC-GA-T----G-C-T-A-C-T-A-G-T-G-C-C--GG--A-G-T-A-AA-C-A-C-A-A-TAA-G-TAT-CCC-TCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq563(name, align);
seqs.push_back(newSeq563);
name = "GQY1XT001BD58P";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GC-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq564(name, align);
seqs.push_back(newSeq564);
name = "GQY1XT001BD0XN";
align = "G-T--T-T--GA-A-A-C-T-G-T--GA-G-G-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATTCC-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-A--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-A-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq565(name, align);
seqs.push_back(newSeq565);
name = "GQY1XT001BCZ7K";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq566(name, align);
seqs.push_back(newSeq566);
name = "GQY1XT001BCYTA";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--CGA------GT-GA------G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq567(name, align);
seqs.push_back(newSeq567);
name = "GQY1XT001BCW2Z";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-TGG--GTG-G-GT-----------ATG-GACC--------C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq568(name, align);
seqs.push_back(newSeq568);
name = "GQY1XT001BCVHH";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T---G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq569(name, align);
seqs.push_back(newSeq569);
name = "GQY1XT001BCT3V";
align = "A-T--T-T--GA-A-A-C-T-G-T--TG-A-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-T-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq570(name, align);
seqs.push_back(newSeq570);
name = "GQY1XT001BC8K4";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-GC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTT-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq571(name, align);
seqs.push_back(newSeq571);
name = "GQY1XT001BC02D";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTGG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq572(name, align);
seqs.push_back(newSeq572);
name = "GQY1XT001BBL1N";
align = "C-T--T-T--GGAA-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-GAA--TG-C-GC-AG--AT-A-TC-G-G-G-AA-G-A-AC-A-CC-GA-T-G-GC-GAA-GG-CAG-C-TC-T--CTGG-GC-CG-T-C-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-T-GGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CC-A-G-CCG-T-AAAC-G-A-TG-GA--CG-C-T-A-G-GT-G-T-G--G-G-G-G-G-----------AC-CT-G------C-C-C-T-C-C-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-CGT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTAAA";
Sequence newSeq573(name, align);
seqs.push_back(newSeq573);
name = "GQY1XT001BB0AL";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq574(name, align);
seqs.push_back(newSeq574);
name = "GQY1XT001BAPQ9";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C----T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACAGTGAA";
Sequence newSeq575(name, align);
seqs.push_back(newSeq575);
name = "GQY1XT001BALRK";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T----G-T-G-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq576(name, align);
seqs.push_back(newSeq576);
name = "GQY1XT001BAB67";
align = "..T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CG-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq577(name, align);
seqs.push_back(newSeq577);
name = "GQY1XT001BAARR";
align = "C-G--T-T--GA-A-A-C-T-G-G---G-G-C-C--T-T-G-A-G-T---G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq578(name, align);
seqs.push_back(newSeq578);
name = "GQY1XT001B9E2H";
align = "A-T--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq579(name, align);
seqs.push_back(newSeq579);
name = "GQY1XT001B8XHJ";
align = "..T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GGA-GG-CGG-C-TT-G--CTGG-AC-GG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq580(name, align);
seqs.push_back(newSeq580);
name = "GQY1XT001B8XAS";
align = "T-T--T-G--GA-A-A-C-T-G-T--TC-A-A-C--T-T-G-A-G-T-G-C-AG-AA-G-G-G-G-A-G--AG-T-GG-A-ATT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T--G-G-G-A-G--G---T----TT-CC----G-C-C-T-C-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq581(name, align);
seqs.push_back(newSeq581);
name = "GQY1XT001B8MR4";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-T-G--G---C----AA-A-----G-C-C-A-T-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq582(name, align);
seqs.push_back(newSeq582);
name = "GQY1XT001B8G73";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-TCG--G-G-G-G-C--A---G----AG-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq583(name, align);
seqs.push_back(newSeq583);
name = "GQY1XT001B7WUW";
align = "A-T--T-T--GG-A-A-C-T-G-T--AA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATTCC-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G--T---C----TG-A-----C-C-C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq584(name, align);
seqs.push_back(newSeq584);
name = "GQY1XT001B7WRH";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq585(name, align);
seqs.push_back(newSeq585);
name = "GQY1XT001B7WHA";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATTCC-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----CA-AG----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq586(name, align);
seqs.push_back(newSeq586);
name = "GQY1XT001B7DYD";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---CT---AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq587(name, align);
seqs.push_back(newSeq587);
name = "GQY1XT001B6OQ6";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----TAGA-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-C-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq588(name, align);
seqs.push_back(newSeq588);
name = "GQY1XT001B69EC";
align = "T-C--T-G-GAA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GATA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq589(name, align);
seqs.push_back(newSeq589);
name = "GQY1XT001B60C3";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq590(name, align);
seqs.push_back(newSeq590);
name = "GQY1XT001B5SFC";
align = "C-G--T-T--GA-A-A-C-T-G-A--C--G-T-C----T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq591(name, align);
seqs.push_back(newSeq591);
name = "GQY1XT001B5NV4";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G----G---C----AG-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq592(name, align);
seqs.push_back(newSeq592);
name = "GQY1XT001B3YIX";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-G-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq593(name, align);
seqs.push_back(newSeq593);
name = "GQY1XT001B3X0W";
align = "C-G----T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq594(name, align);
seqs.push_back(newSeq594);
name = "GQY1XT001B3FMW";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-AA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq595(name, align);
seqs.push_back(newSeq595);
name = "GQY1XT001B33L9";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq596(name, align);
seqs.push_back(newSeq596);
name = "GQY1XT001B2NMD";
align = "T-T--T-G--GA-A-A-C-T-G-C--CT-G-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq597(name, align);
seqs.push_back(newSeq597);
name = "GQY1XT001B2LC1";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-GG----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq598(name, align);
seqs.push_back(newSeq598);
name = "GQY1XT001B2BSQ";
align = "A-A--A-A--GA-T-A-C-T-G-C--AA-A-G-C--T-A-G-A-G-T-A-T-GA-CA-G-A-G-G-C-A--AG-T-GG-A-ACT-A-C-A-T-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AA--AT-A-TA-T-G-T-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-GT-CG-A-T-ACT--GACA-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCC-T-AAAC-G-A-TG-AG--TA-C-T-A-A-GT-G-T----T-G-G-T-G--A-------GAA-TCA---------G---T-----G-C-T-G----A---A-G-T-T-AA-C-G-C-A-T-TAA-G-TAC-TCC-GCC-T-G-AGT-AG-TA--CG-TA-C-G-C-A-AGTATGAA";
Sequence newSeq599(name, align);
seqs.push_back(newSeq599);
name = "GQY1XT001B1NT0";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq600(name, align);
seqs.push_back(newSeq600);
name = "GQY1XT001B1L47";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq601(name, align);
seqs.push_back(newSeq601);
name = "GQY1XT001B16R1";
align = "T-T--T-G--GA-A-A-C-T-G-T--TC-A-T-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---C---ATA-A-----G-A-C-T-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq602(name, align);
seqs.push_back(newSeq602);
name = "GQY1XT001B15LZ";
align = "A-T--T-T--GA-A-A-C-T-G-T--CA-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-G-G-A----A---C----GA-CA----G-T-T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq603(name, align);
seqs.push_back(newSeq603);
name = "GQY1XT001B0XDL";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-----G-G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq604(name, align);
seqs.push_back(newSeq604);
name = "GQY1XT001B0RDE";
align = "A-T--T-G--GA-A-A-C-T-G-T--CG-C-G-C--T-C-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-G-T--C-G-G-G-G--G---C----AC-A-----C-G-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq605(name, align);
seqs.push_back(newSeq605);
name = "GQY1XT001B0PXR";
align = "C-G--T-T--GA-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-T-G-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-T-C--C-G-G-G-T--CGA------AT-GA------G-A-T-C-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq606(name, align);
seqs.push_back(newSeq606);
name = "GQY1XT001B0NDH";
align = "C-A--C-T--GA-T-A-C-T-G-T--TA-G-A-C--T-T-G-A-G-T-A-T-GG-AA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-GC-CA-A-G-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-T--A-G-T-A-G--T-------T-TCGA-T----G-C-T-A-C-T-A-G-T-G-C-C--GG--A-G-T-A-AA-C-A-C-A-A-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq607(name, align);
seqs.push_back(newSeq607);
name = "GQY1XT001B0LOS";
align = "T-C--T-G--GA-A-A-C-T-A-T--GT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq608(name, align);
seqs.push_back(newSeq608);
name = "GQY1XT001B05N5";
align = "A-T--T-T--GA-A-A-C-T-G-T--AT-T-T-CT-T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----CCC-T-C-C-G---T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq609(name, align);
seqs.push_back(newSeq609);
name = "GQY1XT001AZULT";
align = "A-T--T-G--GA-A-A-C-T-G-T--AA-A-T-C--T-T-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA--A----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq610(name, align);
seqs.push_back(newSeq610);
name = "GQY1XT001AZRLQ";
align = "A-T--T-G--GA-A-A-C-T-G-G--TT-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-G-A--AG-T-GG-A-ATT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TA-T-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-C--CTGG-TC-TG-C-A-ACT--GACA-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T----G-G-G-G-----------TC-GA--------A-C-C-T-C-A-G-T-G-C-T--GA--A-G-T-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGGAGG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq611(name, align);
seqs.push_back(newSeq611);
name = "GQY1XT001AZHRG";
align = "C-G--T-T--GA-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-T-G-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-T-C--C-G-G-G-T--C-------GAA-TGA-----G-A-T-C-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq612(name, align);
seqs.push_back(newSeq612);
name = "GQY1XT001AZAPT";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--T-------GTC-AT------G-A-C-C-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-T-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGATTAAA";
Sequence newSeq613(name, align);
seqs.push_back(newSeq613);
name = "GQY1XT001AYX7D";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-A-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq614(name, align);
seqs.push_back(newSeq614);
name = "GQY1XT001AYQ5Z";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq615(name, align);
seqs.push_back(newSeq615);
name = "GQY1XT001AXRGB";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq616(name, align);
seqs.push_back(newSeq616);
name = "GQY1XT001AXG2N";
align = "T-T--T-G--GA-A-A-C-T-G-T--TA-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq617(name, align);
seqs.push_back(newSeq617);
name = "GQY1XT001AXDRE";
align = "G-T--T-T--GA-A-A-C-T-G-T--TC-T-T-C--T-T-G-A-G-T-G-A-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AT-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G-AGGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-C------C-C-C-T-C-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq618(name, align);
seqs.push_back(newSeq618);
name = "GQY1XT001AWWIG";
align = "C-A--C-T--GA-T-A-C-T-G-T--TA-G-A-C--T-T-G-A-G-T-A-T-GG-AA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-GC-CA-A-G-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-T--A-G-T-A-G--T---T----TC-G-----A-T-G-C-T-A-CTA-G-T-G-C-C--GG--A-G-T-A-AA-C-A-C-A-A-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq619(name, align);
seqs.push_back(newSeq619);
name = "GQY1XT001AW8WD";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq620(name, align);
seqs.push_back(newSeq620);
name = "GQY1XT001AW1W6";
align = "T-T--T-T--GA-A-A-C-T-G-A--GT-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq621(name, align);
seqs.push_back(newSeq621);
name = "GQY1XT001AW0BB";
align = "..T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq622(name, align);
seqs.push_back(newSeq622);
name = "GQY1XT001AVY6F";
align = "T-T--T-G--GA-A-A-C-T-G-A--GC-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-A-G--G---C----AA-A-----G-C-C-T-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C--AAGAATGAA";
Sequence newSeq623(name, align);
seqs.push_back(newSeq623);
name = "GQY1XT001AVXPI";
align = "T-T--T-G--GG-A-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-A-----GAC-C-C-A-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq624(name, align);
seqs.push_back(newSeq624);
name = "GQY1XT001AVW8R";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq625(name, align);
seqs.push_back(newSeq625);
name = "GQY1XT001AVR1M";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCC-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-T-G--C---C----AA-A-----G-G-C-T-C-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq626(name, align);
seqs.push_back(newSeq626);
name = "GQY1XT001AV5CD";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T---GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq627(name, align);
seqs.push_back(newSeq627);
name = "GQY1XT001AUELS";
align = "T-T--T-T--GG-A-A-C-T-A-T--CA-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-A-A-ACT--GACA-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-T--A---C----AA-A-----G-T-A-C-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq628(name, align);
seqs.push_back(newSeq628);
name = "GQY1XT001ATVXJ";
align = "C-A--G-A--GA-A-A-C-C-G-T--AT-A-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-GT-G-T-C------G---G--G--------AA-A---------C-------C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq629(name, align);
seqs.push_back(newSeq629);
name = "GQY1XT001ATLSJ";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G--A---C-----T-GA----C-C-C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq630(name, align);
seqs.push_back(newSeq630);
name = "GQY1XT001ATF02";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-C-A-G-GT-G-TCG--G-G-T-G-T--C---G----AA-G-----G-A-C-G-G-C-C-G-G-T-G-C-C--GC--A-G-C-G-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq631(name, align);
seqs.push_back(newSeq631);
name = "GQY1XT001ASOCW";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T---G-CA-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-T-G-GT-G-T-C--G-G-G-G-G--G---C----TAGA-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq632(name, align);
seqs.push_back(newSeq632);
name = "GQY1XT001ASDN9";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq633(name, align);
seqs.push_back(newSeq633);
name = "GQY1XT001AS27U";
align = "T-C--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-G-G-A-G-T-G-C-GG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq634(name, align);
seqs.push_back(newSeq634);
name = "GQY1XT001ARTKK";
align = "..T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq635(name, align);
seqs.push_back(newSeq635);
name = "GQY1XT001ARRPS";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GGA-GG-CGG-C-TT-G--CTGG-AC-GG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-T-G-G----G---T----AT-GG----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq636(name, align);
seqs.push_back(newSeq636);
name = "GQY1XT001AREMS";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GC-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-C--C---T----AA-G-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq637(name, align);
seqs.push_back(newSeq637);
name = "GQY1XT001AQOQL";
align = "C-C--T-T--GG-A-A-C-T-G-T--GC-G-G-C--T-G-G-A-G-T-G-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--A---CG---AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq638(name, align);
seqs.push_back(newSeq638);
name = "GQY1XT001AQKOI";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-G-C--T-A-G-G-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----TA-C-----G-G-A-CGC-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq639(name, align);
seqs.push_back(newSeq639);
name = "GQY1XT001AQ7W0";
align = "C-G--T-T--GA-A-A-C-T-G----GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-C-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq640(name, align);
seqs.push_back(newSeq640);
name = "GQY1XT001APAHX";
align = "C-A--T-G--GA-A-A-C-T-G-G--TT-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-CAA-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--T-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq641(name, align);
seqs.push_back(newSeq641);
name = "GQY1XT001AP4SY";
align = "A-T--T-T--GG-A-A-C-T-G-T--AA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq642(name, align);
seqs.push_back(newSeq642);
name = "GQY1XT001AOQFM";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G---G-G---------GACT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq643(name, align);
seqs.push_back(newSeq643);
name = "GQY1XT001AOPM0";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-G-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-T---G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq644(name, align);
seqs.push_back(newSeq644);
name = "GQY1XT001AOKG2";
align = "T-T--T-G--GA-A-A-C-TGG-C--GG-G-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-G-G-G-C-C--C---T----AA-G-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq645(name, align);
seqs.push_back(newSeq645);
name = "GQY1XT001AOB1H";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-GT-T---T----AC-G-----G-A-C-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq646(name, align);
seqs.push_back(newSeq646);
name = "GQY1XT001AMBT9";
align = "A-T--T-C--AA-A-A-C-T-G-C--GA-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------CGT-CA-A------G-C-T-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq647(name, align);
seqs.push_back(newSeq647);
name = "GQY1XT001AL3K5";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C----T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--CAA-CG-AAA-G-CGG-TGGG-T--ATC-G-AA-CA-GG-ATTAGACTA-CCCT-GGTA-GT-C-CA-C-GCAAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-C-G-C-C--C-------GAG-TG------G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq648(name, align);
seqs.push_back(newSeq648);
name = "GQY1XT001AKULV";
align = "A-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T---ATG-G-----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq649(name, align);
seqs.push_back(newSeq649);
name = "GQY1XT001AKJCY";
align = "A-T--T-T--GA-A-A-C-T-G-T--AG-G-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-T-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-G--AC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq650(name, align);
seqs.push_back(newSeq650);
name = "GQY1XT001AJPC9";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-C-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-A-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AC-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGGAAG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq651(name, align);
seqs.push_back(newSeq651);
name = "GQY1XT001AJMR4";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-GTC-----------AT-AA--------G-A-CTT-C-T-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq652(name, align);
seqs.push_back(newSeq652);
name = "GQY1XT001AJ700";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq653(name, align);
seqs.push_back(newSeq653);
name = "GQY1XT001AJ20W";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G----------GTA-AG-GC-----C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq654(name, align);
seqs.push_back(newSeq654);
name = "GQY1XT001AIWYF";
align = "T-A--G-C--TA-A-A-C-T-G-C--TA-A-G-C--T-C-G-A-G-A-C-C-GT-TA-G-G-G-G-T-A--AC-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-GAGT-G-AAA--TC-C-GT-AG--AT-A-TT-A-G-A-AG-GA--AC-A-CC-GA-T-A-GC-GTA-GG-CAG-G-TT-A--CTGG-GA-CG-G-T-TCT--GACA-CTA-A-GG--C-A-CG-AAA-G-C-G-TAGG-G--AGC-A-AA-CG-GG-ATTAG-ATA-CCCC-GGTA-GT-C-TA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-CA-G-T-T--T-T-G-G-G---------TATC-GA-CC-----C-C-T-A-G-A-G-T-T-G-C--GA--A-GC--T-AA-C-G-C-G-T-TAA-G-TAT-CCC-ACC-T-G-TGT-AG-TA--CG-AT-C-G-C-A-AGATTAAA";
Sequence newSeq655(name, align);
seqs.push_back(newSeq655);
name = "GQY1XT001AILS4";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--CGA------GT-GA------G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-G-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq656(name, align);
seqs.push_back(newSeq656);
name = "GQY1XT001AIBN7";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq657(name, align);
seqs.push_back(newSeq657);
name = "GQY1XT001AI3O1";
align = "T-T--T-G--GA-A-A-C-T-G----CC-G-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq658(name, align);
seqs.push_back(newSeq658);
name = "GQY1XT001AHO2K";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAG-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq659(name, align);
seqs.push_back(newSeq659);
name = "GQY1XT001AGROC";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--GCG-G-G-G----------ACT-CG-AC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq660(name, align);
seqs.push_back(newSeq660);
name = "GQY1XT001AGKBN";
align = "C-C--T-G--CG-A-A-C-T-G-G--GT-T-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT---C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-G--GGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq661(name, align);
seqs.push_back(newSeq661);
name = "GQY1XT001AGG6W";
align = "A-T--T-T-CAA-A-A-C-T-G-G--AA-G-T-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--T-------GTC-AT------G-A-C-C-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-T-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq662(name, align);
seqs.push_back(newSeq662);
name = "GQY1XT001AGC6C";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-A-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-G--A-G-G-G-T--G---C----TA-AG----C-A-T-C-C-T---G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq663(name, align);
seqs.push_back(newSeq663);
name = "GQY1XT001AFXPL";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-G-G-G-G----G---C----AG-AG----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq664(name, align);
seqs.push_back(newSeq664);
name = "GQY1XT001AFXF7";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq665(name, align);
seqs.push_back(newSeq665);
name = "GQY1XT001AFX9C";
align = "T-T--T-G-GAA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq666(name, align);
seqs.push_back(newSeq666);
name = "GQY1XT001AEO5Y";
align = "A-G----T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-C-G------------ATA-TAC---------G-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-CAT-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq667(name, align);
seqs.push_back(newSeq667);
name = "GQY1XT001AEDFI";
align = "A-T--T-G--GA-A-A-C-T-G-G--CG-A-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCC-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-G-C-G--C---C----AC-G-----G-G-C-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGGAGG-TA--CG-TT-C-G-C-A-AGGATGAA";
Sequence newSeq668(name, align);
seqs.push_back(newSeq668);
name = "GQY1XT001AD3AA";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq669(name, align);
seqs.push_back(newSeq669);
name = "GQY1XT001A8ZAM";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-A-G-A-G-T-A-C-AG-GA-G-G-G-G-T-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TC-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--A--------CT-GA----C-C-C-C-A-T-C-C-G-T-G-C-C--GG--A-G-TTA--A-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-GCA-A-CG-GTGAA";
Sequence newSeq670(name, align);
seqs.push_back(newSeq670);
name = "GQY1XT001A8Y8K";
align = "T-C--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-T-G-A-G-T-G-C-AG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--GCG-G-A-G--T---C----AA-G-----G-C-T-C-T-G-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq671(name, align);
seqs.push_back(newSeq671);
name = "GQY1XT001A8WF3";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-A-A-ACT--GACA-CTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-T--A---C----AA-A-----G-T-A-C-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq672(name, align);
seqs.push_back(newSeq672);
name = "GQY1XT001A8T80";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GACC------C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq673(name, align);
seqs.push_back(newSeq673);
name = "GQY1XT001A8Q74";
align = "A-T--T-G--GA-A-A-C-T-G-C--GG-G-A-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-G-G----G---C----AC-G-----G-C---C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq674(name, align);
seqs.push_back(newSeq674);
name = "GQY1XT001A8163";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A--------GA-AT------G-ATCCC-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq675(name, align);
seqs.push_back(newSeq675);
name = "GQY1XT001A6YXB";
align = "T-C--T-T--GG-A-A-C-T-G-C--GC-G-G-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-CG-G-G-G-C-A--C---G----AC-A-----G-T-G-C-T-T-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq676(name, align);
seqs.push_back(newSeq676);
name = "GQY1XT001A5HGV";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------AAA-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq677(name, align);
seqs.push_back(newSeq677);
name = "GQY1XT001A5DA8";
align = "T-T--T-G--GG-A-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-CG-G-G-G-C----A---C----AT-AA----G-T-G-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-C-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq678(name, align);
seqs.push_back(newSeq678);
name = "GQY1XT001A4XYG";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq679(name, align);
seqs.push_back(newSeq679);
name = "GQY1XT001A4O71";
align = "A-T--T-G--GA-A-A-C-T-G-C--GC-A-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-G-G-G--G---C----AG-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq680(name, align);
seqs.push_back(newSeq680);
name = "GQY1XT001A3N9X";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq681(name, align);
seqs.push_back(newSeq681);
name = "GQY1XT001A2ZIR";
align = "T-T--T-T--GA-A-A-C-T-G-T--GT-T-G-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----A--AG----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq682(name, align);
seqs.push_back(newSeq682);
name = "GQY1XT001A2D1V";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----GA-A-----G-C-C-C-T-T-T-G-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq683(name, align);
seqs.push_back(newSeq683);
name = "GQY1XT001A26B8";
align = "T-T--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----TAGA-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq684(name, align);
seqs.push_back(newSeq684);
name = "GQY1XT001A22CL";
align = "C-T--C-T--GA-T-A-C-T-G-T--CG-G-G-C--T-A-G-A-G-T-T-T-AG-TT-G-C-G-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-TCCG-G-GCC-GA-----------ATG-GGG---------C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq685(name, align);
seqs.push_back(newSeq685);
name = "GQY1XT001A20SJ";
align = "A-T--T-T--CA-A-A-C-T-G-G--AA-G-T-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G-------CAG-AG------G-C-C-CTT-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq686(name, align);
seqs.push_back(newSeq686);
name = "GQY1XT001A1OAD";
align = "A-T--T-T--GGAA-A-C-T-G-T--AA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AC-A-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq687(name, align);
seqs.push_back(newSeq687);
name = "GQY1XT001A03SX";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAT-GAA-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-AGTAA-G-TAA-TCC-ACC-T-G-GGGAGG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq688(name, align);
seqs.push_back(newSeq688);
name = "GQY1XT001A1T0J";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq689(name, align);
seqs.push_back(newSeq689);
name = "GQY1XT001CWZS4";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--C---C----GA-C-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq690(name, align);
seqs.push_back(newSeq690);
name = "GQY1XT001BF21Z";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq691(name, align);
seqs.push_back(newSeq691);
name = "GQY1XT001BSUXQ";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq692(name, align);
seqs.push_back(newSeq692);
name = "GQY1XT001DEAMX";
align = "A-T--T-T--GA-A-A-C-T---G--TT-T-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-TGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq693(name, align);
seqs.push_back(newSeq693);
name = "GQY1XT001BHQ8W";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq694(name, align);
seqs.push_back(newSeq694);
name = "GQY1XT001BH6RQ";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq695(name, align);
seqs.push_back(newSeq695);
name = "GQY1XT001EYPWE";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----TAGA-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq696(name, align);
seqs.push_back(newSeq696);
name = "GQY1XT001DG39T";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq697(name, align);
seqs.push_back(newSeq697);
name = "GQY1XT001EYPCU";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq698(name, align);
seqs.push_back(newSeq698);
name = "GQY1XT001EGKMY";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-T-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq699(name, align);
seqs.push_back(newSeq699);
name = "GQY1XT001C40V6";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq700(name, align);
seqs.push_back(newSeq700);
name = "GQY1XT001EHCCH";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq701(name, align);
seqs.push_back(newSeq701);
name = "GQY1XT001DSKV4";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq702(name, align);
seqs.push_back(newSeq702);
name = "GQY1XT001DBATA";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq703(name, align);
seqs.push_back(newSeq703);
name = "GQY1XT001BMQ72";
align = "T-T--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq704(name, align);
seqs.push_back(newSeq704);
name = "GQY1XT001ENQS7";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-G-G-G-A-C--C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq705(name, align);
seqs.push_back(newSeq705);
name = "GQY1XT001EDG3L";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AG-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C--AAGAATGAA";
Sequence newSeq706(name, align);
seqs.push_back(newSeq706);
name = "GQY1XT001DW4OA";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq707(name, align);
seqs.push_back(newSeq707);
name = "GQY1XT001D559F";
align = "A-T--T-T--GA-A-A-C-T-G-T--AC-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq708(name, align);
seqs.push_back(newSeq708);
name = "GQY1XT001C74CB";
align = "T-C--T-T--GG-A-A-C-T-G-C--GC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-G-ACT--GACG-TTG-A-GG--C-C-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C---AGA-G-----A-C-T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq709(name, align);
seqs.push_back(newSeq709);
name = "GQY1XT001BYB9O";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq710(name, align);
seqs.push_back(newSeq710);
name = "GQY1XT001BGXA5";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq711(name, align);
seqs.push_back(newSeq711);
name = "GQY1XT001A69AD";
align = "A-T--T-T--GA-A-A-C-T-G-T--AT-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq712(name, align);
seqs.push_back(newSeq712);
name = "GQY1XT001EZ7ET";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq713(name, align);
seqs.push_back(newSeq713);
name = "GQY1XT001E1YNT";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq714(name, align);
seqs.push_back(newSeq714);
name = "GQY1XT001DDQVF";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq715(name, align);
seqs.push_back(newSeq715);
name = "GQY1XT001CTZM0";
align = "A-T--T-T--GA-A-A-C-T-G-T---T-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA--C-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq716(name, align);
seqs.push_back(newSeq716);
name = "GQY1XT001CCJT7";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq717(name, align);
seqs.push_back(newSeq717);
name = "GQY1XT001C9JY3";
align = "T-T--T-G--GA-A-A-C-T-T-T--TT-T-G-C--T-G-G-A-G-T-A-C-CG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--A---C----AA-A-----G-T-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq718(name, align);
seqs.push_back(newSeq718);
name = "GQY1XT001C5F0S";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq719(name, align);
seqs.push_back(newSeq719);
name = "GQY1XT001BSRO2";
align = "A-T--T-T--GA-A-A-C-T-G-T--TG-A-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq720(name, align);
seqs.push_back(newSeq720);
name = "GQY1XT001B9VA2";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq721(name, align);
seqs.push_back(newSeq721);
name = "GQY1XT001ARVHF";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq722(name, align);
seqs.push_back(newSeq722);
name = "GQY1XT001AOG78";
align = "C-T--C-T--GA-T-A-C-T-G-T--CG-G-G-C--T-A-G-A-G-T-T-T-AG-TT-G-C-G-G-T-A--GG-C-GG-A-ATG-T-A-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AG-A-TC-A-T-A-CA-G-A-AC-A-CC-GA-T-T-GC-GAA-GG-CAG-C-TT-A--CCAA-AC-TA-C-G-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AT--AA-C-T-G-G-TT-G-T-C--G-G-C-G------------ATA-AAA---------T-G-T-C-G-G-T-G-A-C--TA--A-G-C-G-AA-A-G-C-G-A-TAA-G-TTA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq723(name, align);
seqs.push_back(newSeq723);
name = "GQY1XT001AEGP7";
align = "T-C--T-G--GA-A-A-C-T-G-C--GG-C-G-C--T-G-G-A-G-T-A-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AGA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-C--G-G-G-G-G--A---CG---AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq724(name, align);
seqs.push_back(newSeq724);
name = "GQY1XT001EX0ZP";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq725(name, align);
seqs.push_back(newSeq725);
name = "GQY1XT001EPHS5";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----CCC-T-C-C-G---T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq726(name, align);
seqs.push_back(newSeq726);
name = "GQY1XT001EP1JC";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-T-G--C---C----AA-A-----G-G-C-T-C-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq727(name, align);
seqs.push_back(newSeq727);
name = "GQY1XT001EHN7S";
align = "T-T--T-T--GA-A-A-C-T-G-T--AG-G-G-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq728(name, align);
seqs.push_back(newSeq728);
name = "GQY1XT001EFUZQ";
align = "T-T--T-G--GA-A-A-C-T-G-C--GA-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-TCG--G-G-G-G-G--G---C----AA-A-----G-C-C-C-C-T-C-G-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-A-TAA-G-CAC-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C--AAGAATGAA";
Sequence newSeq729(name, align);
seqs.push_back(newSeq729);
name = "GQY1XT001EDYY1";
align = "C-G--T-T--GA-A-A-C-T-G-G---C-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq730(name, align);
seqs.push_back(newSeq730);
name = "GQY1XT001ECG24";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--CGA------AT-GA------G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq731(name, align);
seqs.push_back(newSeq731);
name = "GQY1XT001EB301";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-TCCGGG-G-G-GA-----------ATG-GCC---------C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq732(name, align);
seqs.push_back(newSeq732);
name = "GQY1XT001DQWXH";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-TAG--G-G-G-G-T--A---T----CG-A-----T-T-C-C-C-T-C-T-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-T-TAA-G-TAT-TCC-GCC-T-G-GGG-AC-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq733(name, align);
seqs.push_back(newSeq733);
name = "GQY1XT001DOMXB";
align = "C-T--C-T--GA-T-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-TCC--G-G-T-T------------CTACGGG---------A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq734(name, align);
seqs.push_back(newSeq734);
name = "GQY1XT001DGEAP";
align = "A-T--T-G--GA-A-A-C-T-G-C--AT-A-T-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-T-G--G---C----AA-A-----G-C-C-A-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq735(name, align);
seqs.push_back(newSeq735);
name = "GQY1XT001CYFOT";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-A-A-C--T-C-G-A-G-A-G-G-GA-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq736(name, align);
seqs.push_back(newSeq736);
name = "GQY1XT001CYCIB";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C-----A-GG----G-C-C-C-C-C-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq737(name, align);
seqs.push_back(newSeq737);
name = "GQY1XT001CXUJD";
align = "A-T--T-T--GG-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-G-G-G-C--T---C----AC-G-----G-G-C-G-C-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq738(name, align);
seqs.push_back(newSeq738);
name = "GQY1XT001CXMNA";
align = "T-C--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-T-G-A-G-T-G-C-AG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-C-G-G-A--GT--C----AA-G-----G-C-T-C-T-G-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq739(name, align);
seqs.push_back(newSeq739);
name = "GQY1XT001CW602";
align = "A-T--T-T--GG-A-A-C-T-G-T--GT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----TA-C-----G-G-A-CGC-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq740(name, align);
seqs.push_back(newSeq740);
name = "GQY1XT001CVQSF";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-G-ACT--GACG-TTG-A-GG--C-C-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-C--G-G-G-G-G--G-------CAG-GGG-----C-C-C-C-C-C-G-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-T-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq741(name, align);
seqs.push_back(newSeq741);
name = "GQY1XT001CMS04";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----CA-AG----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq742(name, align);
seqs.push_back(newSeq742);
name = "GQY1XT001CIFR7";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq743(name, align);
seqs.push_back(newSeq743);
name = "GQY1XT001CHEOP";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-G-G-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-T-G--G---C----AA-A-----G-C-C-A-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq744(name, align);
seqs.push_back(newSeq744);
name = "GQY1XT001BUH2B";
align = "T-T--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq745(name, align);
seqs.push_back(newSeq745);
name = "GQY1XT001BTJY0";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-A-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AG-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq746(name, align);
seqs.push_back(newSeq746);
name = "GQY1XT001BPBAW";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-TCG--G-G-G-G-T--T---C----AA-G-----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq747(name, align);
seqs.push_back(newSeq747);
name = "GQY1XT001BGSX9";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq748(name, align);
seqs.push_back(newSeq748);
name = "GQY1XT001BGF0U";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq749(name, align);
seqs.push_back(newSeq749);
name = "GQY1XT001BDDJJ";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq750(name, align);
seqs.push_back(newSeq750);
name = "GQY1XT001BC7OS";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq751(name, align);
seqs.push_back(newSeq751);
name = "GQY1XT001B0P0B";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATT-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq752(name, align);
seqs.push_back(newSeq752);
name = "GQY1XT001AZ42D";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GGAA-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq753(name, align);
seqs.push_back(newSeq753);
name = "GQY1XT001AKTCW";
align = "T-T--C-T--GA-T-A-C-T-G-C--TG-T-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G----T---C----AT-A-----A-G-A-C-T-T-C-T-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq754(name, align);
seqs.push_back(newSeq754);
name = "GQY1XT001A0V8W";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-AC-C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq755(name, align);
seqs.push_back(newSeq755);
name = "GQY1XT001A058D";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-C--C---CT---AA-G-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq756(name, align);
seqs.push_back(newSeq756);
name = "GQY1XT001EZCXH";
align = "A-C--T-T--GA-A-A-C-T-G-G--GT-G-T-C--T-T-G-A-G-G-G-C-AG-GA-G-A-G-G-A-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-T--CTGG-AC-TG-T-A-CCT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-T--AGC-G-AA-CG-GG-ATTAG-ATA-CCCC-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-A-G-G---------TATC-GA-CT-----C-C-T-T-C-T-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-GCC-T-G-GGG-AC-TA--CG-GT-C-G-C-A-AGAATGAA";
Sequence newSeq757(name, align);
seqs.push_back(newSeq757);
name = "GQY1XT001EZ8GE";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATG-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-A-----G-A-A-C-C-TCC-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq758(name, align);
seqs.push_back(newSeq758);
name = "GQY1XT001EYYS5";
align = "A-C--T-C--GG-A-A-C-T-G-G--CG-T-G-C--T-A-G-A-G-T-G-T-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq759(name, align);
seqs.push_back(newSeq759);
name = "GQY1XT001EYPAX";
align = "T-C--T-G-GAA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-AGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq760(name, align);
seqs.push_back(newSeq760);
name = "GQY1XT001EYIV1";
align = "G-T--T-C--CG-G-A-C-T-G-G--GC-G-G-C--T-C-G-A-G-T-G-C-GG-TA-G-A-G-G-A-G--AG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-GAA--TG-C-GC-AG--AT-A-TC-G-G-G-AA-G-A-AC-A-CC-GA-T-G-GC-GAA-GG-CAG-C-TC-T--CTGG-GC-CG-T-C-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-T-GGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CC-A-G-CCG-T-AAAT-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G-----------AT-CC-C------C-C-C-T-C-C-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTAAA";
Sequence newSeq761(name, align);
seqs.push_back(newSeq761);
name = "GQY1XT001EXIVG";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G---T--G-A-G-G-G--G---C----CA-A-----G-C-C-C-C-C-T-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq762(name, align);
seqs.push_back(newSeq762);
name = "GQY1XT001EXEU5";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-T-C--C-G-G-G-T--C-------GAA-TGA-----GAG-GTC-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq763(name, align);
seqs.push_back(newSeq763);
name = "GQY1XT001EXAZ7";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq764(name, align);
seqs.push_back(newSeq764);
name = "GQY1XT001EWK0A";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq765(name, align);
seqs.push_back(newSeq765);
name = "GQY1XT001EW7MF";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq766(name, align);
seqs.push_back(newSeq766);
name = "GQY1XT001EW2K2";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq767(name, align);
seqs.push_back(newSeq767);
name = "GQY1XT001EVP92";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------AAA-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq768(name, align);
seqs.push_back(newSeq768);
name = "GQY1XT001EVHL0";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-C-A-G-GT-G-T-C--G-G-G-G-C--A---C---ATA-A-----G-T-G-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq769(name, align);
seqs.push_back(newSeq769);
name = "GQY1XT001EV8AL";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq770(name, align);
seqs.push_back(newSeq770);
name = "GQY1XT001EV1R0";
align = "T-T--T-G--GA-A-A-C-T-G-T--TA-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C--AAGAATGAA";
Sequence newSeq771(name, align);
seqs.push_back(newSeq771);
name = "GQY1XT001EURY9";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq772(name, align);
seqs.push_back(newSeq772);
name = "GQY1XT001EUIOC";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-GAA-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-GTGGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TTGG-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq773(name, align);
seqs.push_back(newSeq773);
name = "GQY1XT001EU9X6";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq774(name, align);
seqs.push_back(newSeq774);
name = "GQY1XT001ETFKQ";
align = "C-A--G-A--GA-A-A-C-C-G-T--AT-A-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-GT-G-T----C-G-G-------------------G------A-A-A-C---C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq775(name, align);
seqs.push_back(newSeq775);
name = "GQY1XT001ETF05";
align = "C-G--T-T--GA-A-A-C-G-G-G--TT-TTAGCC-T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq776(name, align);
seqs.push_back(newSeq776);
name = "GQY1XT001ETDKY";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C----T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAG--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GATA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TC-G-G-C-A-ACGGTGAA";
Sequence newSeq777(name, align);
seqs.push_back(newSeq777);
name = "GQY1XT001ET5SK";
align = "A-T--T-G--GG-A-A-C-T-A-C-CGG-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---C----ATAA-----G-A-C-T-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq778(name, align);
seqs.push_back(newSeq778);
name = "GQY1XT001EQWOD";
align = "T-C--T-G--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-A-----G-A-A-C-C-TCC-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq779(name, align);
seqs.push_back(newSeq779);
name = "GQY1XT001EQIV5";
align = "T-C--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-T-G-A-G-T-G-C-AG-GA-G-G-G-G-T-A--AG-C-GG-A-A-T-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--GCG-G-A-G--T---C----AA-G-----G-C-T-C-T-G-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq780(name, align);
seqs.push_back(newSeq780);
name = "GQY1XT001EPE74";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq781(name, align);
seqs.push_back(newSeq781);
name = "GQY1XT001EP30T";
align = "C-C--T-G--CG-A-A-C-T-G-G--GA-T-G-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G--------CC-AAG-----GCC-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq782(name, align);
seqs.push_back(newSeq782);
name = "GQY1XT001ENZ1M";
align = "T-C--T-G--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq783(name, align);
seqs.push_back(newSeq783);
name = "GQY1XT001ENH1J";
align = "A-T--T-T--GA-A-A-C-T-G-T---T-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq784(name, align);
seqs.push_back(newSeq784);
name = "GQY1XT001EMKVP";
align = "T-T--T-T--GG-A-A-C-T-A-T--CA-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGGATGAA";
Sequence newSeq785(name, align);
seqs.push_back(newSeq785);
name = "GQY1XT001EMC11";
align = "T-C--T-G--GA-A-A-C-T-G-C--GC-C-G-C--T-G-G-A-G-T-A-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AGA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-C--G-G-G-G-G--A---CG---AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq786(name, align);
seqs.push_back(newSeq786);
name = "GQY1XT001EMATT";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-A-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-G--A-G-G-G-T--G---C----TA-A-----G-C-A-T-C-C-T-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq787(name, align);
seqs.push_back(newSeq787);
name = "GQY1XT001EMAQQ";
align = "A-T--T-T--GA-A-A-C-T-G-T--AT-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T----G-G-G-G-G----------ACT-GA-CC-----CCC-T-C-C-G---T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq788(name, align);
seqs.push_back(newSeq788);
name = "GQY1XT001EM827";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-C-A-ACT--GACG-TTG-A-GG--C-C-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-TA-C-G-CCG-T-AAAC-G-A-TG-TA--TA-C-C-A-G-GT-G-T-C--G-G---A-T--A---T----CA-A-----G-G-A-T-A-TCC-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-ACC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq789(name, align);
seqs.push_back(newSeq789);
name = "GQY1XT001EM7A3";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-C-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-CG-G-G-G-C----A---C----AT-AA----G-T-G-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-C-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq790(name, align);
seqs.push_back(newSeq790);
name = "GQY1XT001EM6RV";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-G-G-G--T---T----AACA-----G-A-C-C-C-C-C-G-G-T-G-C-C--GA--A-G-C-C-AA-C-G-C-A-T-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq791(name, align);
seqs.push_back(newSeq791);
name = "GQY1XT001ELZVI";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-G-T--C-G-G-G-A--C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq792(name, align);
seqs.push_back(newSeq792);
name = "GQY1XT001EKQHH";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq793(name, align);
seqs.push_back(newSeq793);
name = "GQY1XT001EKMAO";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C----T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq794(name, align);
seqs.push_back(newSeq794);
name = "GQY1XT001EKHHJ";
align = "A-T--T-G--GA-A-A-C-T-G-C--AT-A-T-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G----G---C----AG-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq795(name, align);
seqs.push_back(newSeq795);
name = "GQY1XT001EJU1D";
align = "A-C--T-C--AA-A-A-C-T-G-C--AG-C-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AGA-T--A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAAGG-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GTGG-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-TGG-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq796(name, align);
seqs.push_back(newSeq796);
name = "GQY1XT001EJ2FF";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CG-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq797(name, align);
seqs.push_back(newSeq797);
name = "GQY1XT001EHO81";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAAGG-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CTGG-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq798(name, align);
seqs.push_back(newSeq798);
name = "GQY1XT001EGVLY";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCC-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GA------G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq799(name, align);
seqs.push_back(newSeq799);
name = "GQY1XT001EGSME";
align = "T-T--T-G--GA-A-A-C-T-G-C--GA-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-C--G-G-G-G-G--C---A----AA-G-------C-C-C-C-T-C-G-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-A-TAA-G-CAC-TCC-ACC-T---GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq800(name, align);
seqs.push_back(newSeq800);
name = "GQY1XT001EGAZT";
align = "A-C--T-C--GG-A-A-C-T-G-G--CG-T-G-C--T-A-G-A-G-T-G-T-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq801(name, align);
seqs.push_back(newSeq801);
name = "GQY1XT001EEXO8";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C---G----AT-TG----G-G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq802(name, align);
seqs.push_back(newSeq802);
name = "GQY1XT001EENTR";
align = "T-T--T-T--GA-A-A-C-T-G-T--GT-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq803(name, align);
seqs.push_back(newSeq803);
name = "GQY1XT001EEIYW";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GT--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq804(name, align);
seqs.push_back(newSeq804);
name = "GQY1XT001EDTAQ";
align = "C-G--T-T--GA-A-A-C-T-G----GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-AGG-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-GAAA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq805(name, align);
seqs.push_back(newSeq805);
name = "GQY1XT001ECTBL";
align = "T-C--T-T--GG-A-A-C-T-G-C--GC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-G-ACT--GACG-TTG-A-GG--C-C-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq806(name, align);
seqs.push_back(newSeq806);
name = "GQY1XT001ECQ1R";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-A-CC-GA-T-T-GC-GAA-GG-CAG-C-TT-A--CCAA-AC-TA-C-G-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq807(name, align);
seqs.push_back(newSeq807);
name = "GQY1XT001EA3NI";
align = "C-G--T-T--G--A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-GCT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-GCGGTGAA";
Sequence newSeq808(name, align);
seqs.push_back(newSeq808);
name = "GQY1XT001E3JUH";
align = "C-G--T-T--GA-A-A-C-T-G-G---G-A-G-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq809(name, align);
seqs.push_back(newSeq809);
name = "GQY1XT001E2UEG";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G----A---C----CG-AC----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq810(name, align);
seqs.push_back(newSeq810);
name = "GQY1XT001E10W9";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-GTCCGG-G-G-G-GA-----------ATG-GCC---------C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq811(name, align);
seqs.push_back(newSeq811);
name = "GQY1XT001E0KPB";
align = "A-T--T-T--GA-A-A-C-T-G-T---T-T-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq812(name, align);
seqs.push_back(newSeq812);
name = "GQY1XT001E0777";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G---T--C-G-G-G-G--A-------GGA---A-----T-T-C-C-C-G---G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-CAC-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq813(name, align);
seqs.push_back(newSeq813);
name = "GQY1XT001E02IL";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-C-G------------ATA-TAC---------A-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq814(name, align);
seqs.push_back(newSeq814);
name = "GQY1XT001DZXJA";
align = "T-T--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-AC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-C--C---CT---AA-G-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq815(name, align);
seqs.push_back(newSeq815);
name = "GQY1XT001DZJKO";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq816(name, align);
seqs.push_back(newSeq816);
name = "GQY1XT001DYOCU";
align = "T-T--C-T--GA-T-A-C-T-G-C--TG-T-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-A--G-G-G-G-T--C-------AT--A-------A---G-A-C-TTCTG-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq817(name, align);
seqs.push_back(newSeq817);
name = "GQY1XT001DYGKE";
align = "T-T--T-T--GA-A-A-C-T-G-A--GT-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq818(name, align);
seqs.push_back(newSeq818);
name = "GQY1XT001DXUGT";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------AT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq819(name, align);
seqs.push_back(newSeq819);
name = "GQY1XT001DX0D5";
align = "A-T--A-A--GA-A-A-C-T-G-T--CG-G-A-C--T-T-G-A-G-T-A-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-C-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-G-G-G-AA-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-A-A-ACT--GACG-CTG-A-GT--C-A-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--G-G-C-A-A-----------GG-AA--------T-T-G-T-C-G-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGAATGAA";
Sequence newSeq820(name, align);
seqs.push_back(newSeq820);
name = "GQY1XT001DX0CQ";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-GT-T---T----AC-G-----G-A-C-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq821(name, align);
seqs.push_back(newSeq821);
name = "GQY1XT001DWG63";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq822(name, align);
seqs.push_back(newSeq822);
name = "GQY1XT001DW6TO";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq823(name, align);
seqs.push_back(newSeq823);
name = "GQY1XT001DVLUO";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-A-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-TGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq824(name, align);
seqs.push_back(newSeq824);
name = "GQY1XT001DUDVJ";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G--A---C----TG-A-----C-C-C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-TGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq825(name, align);
seqs.push_back(newSeq825);
name = "GQY1XT001DT2OI";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-G---GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-G-AAGG-CGG-C-CT-G--CTGG-GC-TC-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T----G-G-GTG-G----------ACT-GA-CC-----C-C-A-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq826(name, align);
seqs.push_back(newSeq826);
name = "GQY1XT001DSPP3";
align = "A-T--T-T--GA-A-A-C-T-G-T--TG-A-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T----G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq827(name, align);
seqs.push_back(newSeq827);
name = "GQY1XT001DSLZ5";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-T-C--C-G-G-G-T--CGA------AT-GA------G-A-T-C-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq828(name, align);
seqs.push_back(newSeq828);
name = "GQY1XT001DSCYV";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq829(name, align);
seqs.push_back(newSeq829);
name = "GQY1XT001DRNKQ";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-TC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq830(name, align);
seqs.push_back(newSeq830);
name = "GQY1XT001DRMG3";
align = "A-T--T-T--GA-A-A-C-T---G--TT-T-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq831(name, align);
seqs.push_back(newSeq831);
name = "GQY1XT001DQ4UV";
align = "T-C--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-T-G-A-G-T-G-C-AG-GA---G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-GCT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGCA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T---ATG-G-----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq832(name, align);
seqs.push_back(newSeq832);
name = "GQY1XT001DPYJ6";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-A-G--G---C----AA-A-----G-C-C-T-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq833(name, align);
seqs.push_back(newSeq833);
name = "GQY1XT001DOJ3N";
align = "C-G--T-C--GT-A-G-A-C-T-G--GT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq834(name, align);
seqs.push_back(newSeq834);
name = "GQY1XT001DN337";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGG-G-G-G--G--------AA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq835(name, align);
seqs.push_back(newSeq835);
name = "GQY1XT001DN193";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-G-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--CGA------GT-GA------G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq836(name, align);
seqs.push_back(newSeq836);
name = "GQY1XT001DMV4N";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq837(name, align);
seqs.push_back(newSeq837);
name = "GQY1XT001DM54B";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-G-G-G--T---T----AACA-----G-A-C-C-C-C-C-G-G-T-G-C-C--GA--A-G-C-C-AA-C-G-C-A-T-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq838(name, align);
seqs.push_back(newSeq838);
name = "GQY1XT001DLXQL";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-TCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq839(name, align);
seqs.push_back(newSeq839);
name = "GQY1XT001DLSU0";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-CT-T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-GG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq840(name, align);
seqs.push_back(newSeq840);
name = "GQY1XT001DL380";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq841(name, align);
seqs.push_back(newSeq841);
name = "GQY1XT001DKSU0";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq842(name, align);
seqs.push_back(newSeq842);
name = "GQY1XT001DKKIC";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TC-G-G-C-A-ACGGTGAA";
Sequence newSeq843(name, align);
seqs.push_back(newSeq843);
name = "GQY1XT001DKIM9";
align = "T-C--T-G--GA-A-A-C-T-A-TG-GT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-G-T--T---C----CA-AG----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq844(name, align);
seqs.push_back(newSeq844);
name = "GQY1XT001DK8XV";
align = "C-G--T-T--GA-A-A-C-T-G-G---G-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq845(name, align);
seqs.push_back(newSeq845);
name = "GQY1XT001DJFPN";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-A-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq846(name, align);
seqs.push_back(newSeq846);
name = "GQY1XT001DJ8OY";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-GCT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-G--A-G-G-G------------TGCTAAG---------C-A-TCC-T-G-G-T-G-C-CGA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq847(name, align);
seqs.push_back(newSeq847);
name = "GQY1XT001DIGSI";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq848(name, align);
seqs.push_back(newSeq848);
name = "GQY1XT001DH9T4";
align = "T-T--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----TA-C-----G-G-A-CGC-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq849(name, align);
seqs.push_back(newSeq849);
name = "GQY1XT001DH5LL";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq850(name, align);
seqs.push_back(newSeq850);
name = "GQY1XT001DGUTC";
align = "C-A--G-A--GA-A-A-C-C-G-T--AT-A-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-GT-G-T-C----G-G---------------GA-AA------------C---C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq851(name, align);
seqs.push_back(newSeq851);
name = "GQY1XT001DGUJB";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---C----AT-A-----A-G-A-C-T-TCC-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq852(name, align);
seqs.push_back(newSeq852);
name = "GQY1XT001DGLDS";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------GAG-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq853(name, align);
seqs.push_back(newSeq853);
name = "GQY1XT001DGLC1";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq854(name, align);
seqs.push_back(newSeq854);
name = "GQY1XT001DGL64";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-T-C--C-G-G-G-T--CGA------AT-GA------G-A-T-C-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq855(name, align);
seqs.push_back(newSeq855);
name = "GQY1XT001DG1MD";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq856(name, align);
seqs.push_back(newSeq856);
name = "GQY1XT001DEX8G";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq857(name, align);
seqs.push_back(newSeq857);
name = "GQY1XT001DET7J";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq858(name, align);
seqs.push_back(newSeq858);
name = "GQY1XT001DDWCI";
align = "A-T--T-T--GG-A-A-C-TGG-T--AT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-G-G-G-C--T---C----AC-G-----G-G-C-G-C-T-C-G-G-TGG-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq859(name, align);
seqs.push_back(newSeq859);
name = "GQY1XT001DDLUW";
align = "T-T--T-G--GA-A-A-C-T-G-T--GA-A-G-C--T-G-G-A-G-T---G-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq860(name, align);
seqs.push_back(newSeq860);
name = "GQY1XT001DDAN0";
align = "A-T--T-G--G--A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-TCG--G-G-G-G-C--T---C----AC-G-----G-G-C-G-C-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq861(name, align);
seqs.push_back(newSeq861);
name = "GQY1XT001DCR8A";
align = "T-T--T-A--GA-A-A-C-T-G-G--CA-A-A-C--T-A-G-A-G-T-G-C-AG-TA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-T-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-GC-TG-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TA-C-T-A-A-GT-G-G-T--C-G-G---------------GC-AA------------C---C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAC-TCC-GCC-T-G-AGTAGG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq862(name, align);
seqs.push_back(newSeq862);
name = "GQY1XT001DCR44";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GTGG-TCG--G-G-G-G-T--T---C----AA-G-----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq863(name, align);
seqs.push_back(newSeq863);
name = "GQY1XT001DBLBC";
align = "T-C--T-T--GG-A-A-C-T-G-C--AT-G-G-C--T-G-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-G-ACT--GACG-TTG-A-GG--C-C-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGG-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-T-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq864(name, align);
seqs.push_back(newSeq864);
name = "GQY1XT001DB2I6";
align = "C-G--T-T--GA-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-T-G-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-TCCG-G-GTC-G------------AAT-GAG---------ATC-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq865(name, align);
seqs.push_back(newSeq865);
name = "GQY1XT001DABCU";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq866(name, align);
seqs.push_back(newSeq866);
name = "GQY1XT001D9Y8F";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-TGT--G-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq867(name, align);
seqs.push_back(newSeq867);
name = "GQY1XT001D7Y5M";
align = "A-C--T-C--AA-A-A-C-T-G-C--AG-C-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq868(name, align);
seqs.push_back(newSeq868);
name = "GQY1XT001D7XCR";
align = "..T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-G-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq869(name, align);
seqs.push_back(newSeq869);
name = "GQY1XT001D7GRK";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-GTT-GAA-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq870(name, align);
seqs.push_back(newSeq870);
name = "GQY1XT001D63XM";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-A-C--T-G-G-A-G-T-G-T-CG-GA---G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G----G---C----AG-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq871(name, align);
seqs.push_back(newSeq871);
name = "GQY1XT001D50JU";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq872(name, align);
seqs.push_back(newSeq872);
name = "GQY1XT001D4JG2";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-G-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq873(name, align);
seqs.push_back(newSeq873);
name = "GQY1XT001D4C8Y";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T-------CAT-AAG-----A-C-T-T-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq874(name, align);
seqs.push_back(newSeq874);
name = "GQY1XT001D37QE";
align = "A-T--T-T--GG-A-A-C-T-G-T--GT-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-T--T---T----AC-G-----G-A-C-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq875(name, align);
seqs.push_back(newSeq875);
name = "GQY1XT001D26Z9";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-C-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-CG-G-C-G-G----G---C-----A-CG----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq876(name, align);
seqs.push_back(newSeq876);
name = "GQY1XT001D17ZG";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---CT---AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq877(name, align);
seqs.push_back(newSeq877);
name = "GQY1XT001D0ZS2";
align = "C-C--T-T--GG-A-A-C-T-G-T--GC-G-G-C--T-G-G-A-G-T-G---CG-GA-G---G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-CG-G-G-G-G-A--C---G----AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq878(name, align);
seqs.push_back(newSeq878);
name = "GQY1XT001D0XR5";
align = "A-C--T-C--GG-A-A-C-T-G-G--CG-T-G-C--T-A-G-A-G-T-G-T-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-GT---T---C----AA-GG----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq879(name, align);
seqs.push_back(newSeq879);
name = "GQY1XT001CZEGP";
align = "A-T--T-T--GG-A-A-C-T-A-T--CA-A-G-C--T-G-G-A-G-T-A-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-T-GG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A-----------GG-AA--------T-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAC-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq880(name, align);
seqs.push_back(newSeq880);
name = "GQY1XT001CYRVV";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G--GGC-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G---T--C-C-G-G-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq881(name, align);
seqs.push_back(newSeq881);
name = "GQY1XT001CYQ63";
align = "..T--T-T--GA-A-A-C-T-G-C--AG-A-G-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TC-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T--G-G-G-G-G----------TC--GA--------A-C-C-T-C-A-G-T-G-C-T--GA--A-G-T-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq882(name, align);
seqs.push_back(newSeq882);
name = "GQY1XT001CXKEA";
align = "C-T--C-T--GA-T-A-C-T-G-T--CG-G-G-C--T-A-G-A-G-T-T-T-AG-TT-G-C-G-G-T-A--GG-C-GG-A-ATG-T-A-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AG-A-TC-A-T-A-CA-G-A-AC-A-CC-GA-T-T-GC-GAA-GG-CAG-C-TT-A--CCAA-AC-TA-C-G-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AT--AA-C-T-G-G-TT-G-T-C--G-G-C-G------------ATA-AAA---------T-G-T-C-G-G-T-G-A-C--TA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq883(name, align);
seqs.push_back(newSeq883);
name = "GQY1XT001CX3Z9";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq884(name, align);
seqs.push_back(newSeq884);
name = "GQY1XT001CWSQ6";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-C-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AC-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq885(name, align);
seqs.push_back(newSeq885);
name = "GQY1XT001CWP9L";
align = "T-C--T-G--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-G-G-G--T---T----AA-CA----G-A-C-C-C-C-C-G-G-T-G-C-C--GA--A-G-C-C-AA-C-G-C-A-T-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq886(name, align);
seqs.push_back(newSeq886);
name = "GQY1XT001CWL08";
align = "A-T--T-T--GG-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-C--T---C----AC-G-----G-G-C-G-C-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T---GGG-AG-TA--CG-CT-C-G-C-A-AGAATGAA";
Sequence newSeq887(name, align);
seqs.push_back(newSeq887);
name = "GQY1XT001CW00N";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AAGG-----G-C-C-C-T-C-C-G-A-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq888(name, align);
seqs.push_back(newSeq888);
name = "GQY1XT001CVAAI";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CG-------AT-TG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq889(name, align);
seqs.push_back(newSeq889);
name = "GQY1XT001CU0DC";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGGCCG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq890(name, align);
seqs.push_back(newSeq890);
name = "GQY1XT001CU014";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-G-G-G----T---C----AT-AA----G-A-C-T-T-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq891(name, align);
seqs.push_back(newSeq891);
name = "GQY1XT001CTH8F";
align = "G-T--T-T--GA-A-A-C-T-G-T--GA-G-G-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-A--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-A-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq892(name, align);
seqs.push_back(newSeq892);
name = "GQY1XT001CT7MI";
align = "A-T--T-T--GG-A-A-C-T-G-T--GT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-GT-T---T----AC-G-----G-A-C-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq893(name, align);
seqs.push_back(newSeq893);
name = "GQY1XT001CT48N";
align = "T-T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-G-G-C--A---C---ATA-A-----G-T-G-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-C-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq894(name, align);
seqs.push_back(newSeq894);
name = "GQY1XT001CSO5P";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-GCAAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-C-G-C-C--C-------GAGTGGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq895(name, align);
seqs.push_back(newSeq895);
name = "GQY1XT001CS3JZ";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq896(name, align);
seqs.push_back(newSeq896);
name = "GQY1XT001CREXW";
align = "A-T--T-T--GA-A-A-C-T-G-T--GT-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-CTG-A-GG----G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq897(name, align);
seqs.push_back(newSeq897);
name = "GQY1XT001CQMXT";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq898(name, align);
seqs.push_back(newSeq898);
name = "GQY1XT001CQJTC";
align = "T-C--T-G--GA-A-A-C-T-A-T--GT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T---ATG-G-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq899(name, align);
seqs.push_back(newSeq899);
name = "GQY1XT001CPDJX";
align = "T-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C----G-G-G-G--A---C----CG-AC----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq900(name, align);
seqs.push_back(newSeq900);
name = "GQY1XT001COZPO";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq901(name, align);
seqs.push_back(newSeq901);
name = "GQY1XT001COXEE";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq902(name, align);
seqs.push_back(newSeq902);
name = "GQY1XT001CON9S";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq903(name, align);
seqs.push_back(newSeq903);
name = "GQY1XT001CNX9I";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-C--C---CT---AA-G-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq904(name, align);
seqs.push_back(newSeq904);
name = "GQY1XT001CNBJ0";
align = "T-T--T-T--GA-A-A-C-T-G-C--AG-A-G-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--GG-C-GG-AATTC-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TC-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T----G-G-G-G-G--G-------TCT-GAC-----C-C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq905(name, align);
seqs.push_back(newSeq905);
name = "GQY1XT001CLKQS";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-A-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq906(name, align);
seqs.push_back(newSeq906);
name = "GQY1XT001CKMKE";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-C-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-GCT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-T-C--C-G-G-G-T--C-------GAA-TGA-----G-A-T-C-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq907(name, align);
seqs.push_back(newSeq907);
name = "GQY1XT001CK4HA";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-TGG-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq908(name, align);
seqs.push_back(newSeq908);
name = "GQY1XT001CJ4OA";
align = "T-T--T-G--GA-A-A-C-T-G-T--GG-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq909(name, align);
seqs.push_back(newSeq909);
name = "GQY1XT001CJ4BB";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq910(name, align);
seqs.push_back(newSeq910);
name = "GQY1XT001CIWFS";
align = "T-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-C-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G----A---C----CG-AC----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq911(name, align);
seqs.push_back(newSeq911);
name = "GQY1XT001CIELQ";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq912(name, align);
seqs.push_back(newSeq912);
name = "GQY1XT001CHZHN";
align = "A-T--T-T--GA-A-A-C-T---G--TT-T-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-TGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq913(name, align);
seqs.push_back(newSeq913);
name = "GQY1XT001CH6TQ";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----AA-G-----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq914(name, align);
seqs.push_back(newSeq914);
name = "GQY1XT001CGX5Q";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-A-G--G---C----AA-A-----G-C-C-T-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq915(name, align);
seqs.push_back(newSeq915);
name = "GQY1XT001CGU9N";
align = "T-C--T-G--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GT--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq916(name, align);
seqs.push_back(newSeq916);
name = "GQY1XT001CGNFH";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq917(name, align);
seqs.push_back(newSeq917);
name = "GQY1XT001CFHVA";
align = "A-T--A-A--CG-A-A-C-T-A-T--CT-A-G-C--T-A-G-A-G-T-A-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-A-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AT--AA-C-T-G-G-TT-G-T-C--G-G-C-G-A-----------TA-AA--------A-T-G-T-C-G-G-T-G-A-C--TA--A-G-C-G-AA-A-G-C-G-A-TAA-G-TTA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq918(name, align);
seqs.push_back(newSeq918);
name = "GQY1XT001CEW6A";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq919(name, align);
seqs.push_back(newSeq919);
name = "GQY1XT001CETAI";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-G-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--GC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq920(name, align);
seqs.push_back(newSeq920);
name = "GQY1XT001CDZ21";
align = "C-C--T-G--CG-A-A-C-T-G-G--GA-T-G-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-C--C--------CT-AAGG----G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq921(name, align);
seqs.push_back(newSeq921);
name = "GQY1XT001CCZ3D";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-CGTT-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq922(name, align);
seqs.push_back(newSeq922);
name = "GQY1XT001CCX22";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq923(name, align);
seqs.push_back(newSeq923);
name = "GQY1XT001CCMSC";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--CGA------GT-GA------G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-C-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq924(name, align);
seqs.push_back(newSeq924);
name = "GQY1XT001CCDO5";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--A-------CGA-CAG-----T-G-C-C-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq925(name, align);
seqs.push_back(newSeq925);
name = "GQY1XT001CC4MW";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-ACTG-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq926(name, align);
seqs.push_back(newSeq926);
name = "GQY1XT001CBZH8";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq927(name, align);
seqs.push_back(newSeq927);
name = "GQY1XT001CBQMW";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------AAA-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq928(name, align);
seqs.push_back(newSeq928);
name = "GQY1XT001C9VTR";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G---T--C-G-C-G-G--A-------GTC-AAG-----G-C-T-C-T-GCG-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq929(name, align);
seqs.push_back(newSeq929);
name = "GQY1XT001C9PNP";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq930(name, align);
seqs.push_back(newSeq930);
name = "GQY1XT001C9D54";
align = "A-C--T-C--AA-A-A-C-T-G-C--AG-C-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CC-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T----G-G-G-G-G----------TCT-GA--C-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq931(name, align);
seqs.push_back(newSeq931);
name = "GQY1XT001C94DS";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----CCC-T-C-C-G---T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq932(name, align);
seqs.push_back(newSeq932);
name = "GQY1XT001C8DG5";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-G-G-G-G----G---C----CA-AG----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq933(name, align);
seqs.push_back(newSeq933);
name = "GQY1XT001C87G9";
align = "C----A-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-T-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-CGG-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GTGG-T-C--CGGGG-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq934(name, align);
seqs.push_back(newSeq934);
name = "GQY1XT001C85TH";
align = "T-T--T-T--GA-A-A-C-T-G-C--AG-A-G-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq935(name, align);
seqs.push_back(newSeq935);
name = "GQY1XT001C7K6X";
align = "T-C--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-T-G-A-G-T-G-C-AG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-G----T---T----CA-AG----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq936(name, align);
seqs.push_back(newSeq936);
name = "GQY1XT001C5X81";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACA-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G----C---C----CA-CA----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq937(name, align);
seqs.push_back(newSeq937);
name = "GQY1XT001C5RKW";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATTCC-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-AC-C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq938(name, align);
seqs.push_back(newSeq938);
name = "GQY1XT001C5R30";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq939(name, align);
seqs.push_back(newSeq939);
name = "GQY1XT001C5OQA";
align = "G-T--T-C--AA-A-A-C-T-T-C--TT-G-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AGA-T--A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-A-G-G-G----------ACT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq940(name, align);
seqs.push_back(newSeq940);
name = "GQY1XT001C5OF6";
align = "T-T--T-T--GA-A-A-C-T-G-C--AG-A-G-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A----------CCC-AAGGG-----T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq941(name, align);
seqs.push_back(newSeq941);
name = "GQY1XT001C5JUW";
align = "T-T--T-G--GG-A-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-G-G-G--T---T----AACA-----G-A-C-C-C-C-C-G-G-T-G-C-C--GA--A-G-C-C-AA-C-G-C-A-T-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq942(name, align);
seqs.push_back(newSeq942);
name = "GQY1XT001C5GUL";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-CAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq943(name, align);
seqs.push_back(newSeq943);
name = "GQY1XT001C59AH";
align = "T-T--T-T--GG-A-A-C-T-G-T--GT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----TA-CG----G-A-C-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-A-G-C-A-ACGGTGAA";
Sequence newSeq944(name, align);
seqs.push_back(newSeq944);
name = "GQY1XT001C3K31";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq945(name, align);
seqs.push_back(newSeq945);
name = "GQY1XT001C3J66";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq946(name, align);
seqs.push_back(newSeq946);
name = "GQY1XT001C2HG4";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGCGAA";
Sequence newSeq947(name, align);
seqs.push_back(newSeq947);
name = "GQY1XT001C2GSX";
align = "A-C--T-C--GG-A-A-C-T-G-G--CG-T-G-C--T-A-G-A-G-T-G-T-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq948(name, align);
seqs.push_back(newSeq948);
name = "GQY1XT001C1ZEV";
align = "T-C--T-G--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-A-C-TG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq949(name, align);
seqs.push_back(newSeq949);
name = "GQY1XT001C1QWT";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq950(name, align);
seqs.push_back(newSeq950);
name = "GQY1XT001C136W";
align = "T-T--T-G--G--A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-AC-C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq951(name, align);
seqs.push_back(newSeq951);
name = "GQY1XT001C0R97";
align = "C-A--G-A--GA-A-A-C-C-G-T--AT-A-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq952(name, align);
seqs.push_back(newSeq952);
name = "GQY1XT001C0JOK";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C----T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--AG------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACAGTGAA";
Sequence newSeq953(name, align);
seqs.push_back(newSeq953);
name = "GQY1XT001C09ZC";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-T-C--C-G-G-G-T--C-------GAA-TGA-----G-A-T-C-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq954(name, align);
seqs.push_back(newSeq954);
name = "GQY1XT001C07XU";
align = "C-G--T-T--GA-A-A-C-T-T-G--GT-T-T-C----T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq955(name, align);
seqs.push_back(newSeq955);
name = "GQY1XT001BZ1JQ";
align = "T-T--T-G--GA-A-A-C-T-G-T--TA-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq956(name, align);
seqs.push_back(newSeq956);
name = "GQY1XT001BXU25";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq957(name, align);
seqs.push_back(newSeq957);
name = "GQY1XT001BXOYU";
align = "C-G--C-A--TG-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC--AA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGG-G-G-G--G--------AA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq958(name, align);
seqs.push_back(newSeq958);
name = "GQY1XT001BWXPR";
align = "T-C--T-G--GG-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq959(name, align);
seqs.push_back(newSeq959);
name = "GQY1XT001BWNL7";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-C-G-G-A--GT--C----AA-G-----G-C-T-C-T-G-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq960(name, align);
seqs.push_back(newSeq960);
name = "GQY1XT001BV5DU";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-A-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq961(name, align);
seqs.push_back(newSeq961);
name = "GQY1XT001BTPWD";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-T--G-G-G-T-G------C----CA-AA----G-G-C-T-C-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq962(name, align);
seqs.push_back(newSeq962);
name = "GQY1XT001BSM39";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TT-A--CCAA-AC-TA-C-G-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq963(name, align);
seqs.push_back(newSeq963);
name = "GQY1XT001BSIYP";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T---G-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-G-G-G-G-G--C---C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq964(name, align);
seqs.push_back(newSeq964);
name = "GQY1XT001BR1RG";
align = "A-T--T-G--GA-A-A-C-T-G-T--TT-A-A-C--T-G-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-T-G--G---C----AA-A-----G-C-C-A-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq965(name, align);
seqs.push_back(newSeq965);
name = "GQY1XT001BQOC4";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq966(name, align);
seqs.push_back(newSeq966);
name = "GQY1XT001BQ6PL";
align = "C-G--T-T--GA-A-A-C-T-G-A--C--G-T-C--T-T-G-A-G-T-G-G-GC-GA-A-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq967(name, align);
seqs.push_back(newSeq967);
name = "GQY1XT001BQ5P4";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq968(name, align);
seqs.push_back(newSeq968);
name = "GQY1XT001BPLGT";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq969(name, align);
seqs.push_back(newSeq969);
name = "GQY1XT001BPJSB";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGGGG-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq970(name, align);
seqs.push_back(newSeq970);
name = "GQY1XT001BORQD";
align = "ATT--T-T--GA-A-A-C-T-GTT--TT-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T----G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGAATGAA";
Sequence newSeq971(name, align);
seqs.push_back(newSeq971);
name = "GQY1XT001BODJS";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-TC-AG-T-G-GC-GGA-GG-CGG-C-TT-G--CTGG-AC-GG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-CG-G-G-G-G----A---C-----A-TA----G-T-T-T-C-C-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-C-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq972(name, align);
seqs.push_back(newSeq972);
name = "GQY1XT001BODBA";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---C---ATA-A-----G-A-C-T-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq973(name, align);
seqs.push_back(newSeq973);
name = "GQY1XT001BOBWZ";
align = "T-T--T-G--GA-A-A-C-T-G-C--GA-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-TCG--G-G-G-G-G--G---C----AA-A-----G-C-C-C-C-T-C-G-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq974(name, align);
seqs.push_back(newSeq974);
name = "GQY1XT001BNP5A";
align = "T-C--T-G--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-A-C-TG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-AC-C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq975(name, align);
seqs.push_back(newSeq975);
name = "GQY1XT001BLW7T";
align = "A-T--T-G--GA-A-A-C-T-G-T--AG-A-A-C--T-A-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-CC-T-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G--A---C----TG-A-----C-C-C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TA--TCCCACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq976(name, align);
seqs.push_back(newSeq976);
name = "GQY1XT001BLL0X";
align = "T-C--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-G-G-A-G-T-G-C-GG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---C---ATA-A-----G-A-C-T-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq977(name, align);
seqs.push_back(newSeq977);
name = "GQY1XT001BLGDV";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A---G-T----GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-AA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-C-G------------ATA-TAC---------G-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq978(name, align);
seqs.push_back(newSeq978);
name = "GQY1XT001BLF40";
align = "T-T--T-T--GA-A-A-C-T-G-C--AG-A-G-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TC-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-TCG--G-G-G-G-G----------CCA-AG-GC-----C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq979(name, align);
seqs.push_back(newSeq979);
name = "GQY1XT001BLEJH";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-T--T---C----AA-G-----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T---GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq980(name, align);
seqs.push_back(newSeq980);
name = "GQY1XT001BKFDJ";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq981(name, align);
seqs.push_back(newSeq981);
name = "GQY1XT001BJGWI";
align = "A-T--T-T--GG-A-A-C-T-G-T--GT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq982(name, align);
seqs.push_back(newSeq982);
name = "GQY1XT001BIZXC";
align = "A-T--T-G--GG-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-C-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq983(name, align);
seqs.push_back(newSeq983);
name = "GQY1XT001BIRIE";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--TGCCCCG-----------AGTG-AGG---------G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq984(name, align);
seqs.push_back(newSeq984);
name = "GQY1XT001BIC49";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq985(name, align);
seqs.push_back(newSeq985);
name = "GQY1XT001BI4NP";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-C--C---CT---AA-G-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq986(name, align);
seqs.push_back(newSeq986);
name = "GQY1XT001BHX1B";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T---G-GC-GA-A-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq987(name, align);
seqs.push_back(newSeq987);
name = "GQY1XT001BHSU0";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-AC-C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq988(name, align);
seqs.push_back(newSeq988);
name = "GQY1XT001BH3PR";
align = "C-C--T-G--CG-A-A-C-T-G-G--GA-T-G-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-GTG-G-G-T--A--------TG-GA------C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq989(name, align);
seqs.push_back(newSeq989);
name = "GQY1XT001BGZRP";
align = "C-A--G-A--GA-A-A-C-C-G-T--AT-A-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GC-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-C-G-G--G---C----AA-A-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq990(name, align);
seqs.push_back(newSeq990);
name = "GQY1XT001BGXQP";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-T-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAG";
Sequence newSeq991(name, align);
seqs.push_back(newSeq991);
name = "GQY1XT001BFXWS";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq992(name, align);
seqs.push_back(newSeq992);
name = "GQY1XT001BFWOA";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GT-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq993(name, align);
seqs.push_back(newSeq993);
name = "GQY1XT001BF5QA";
align = "A-C--T-G--AG-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-TA--TA-C-C-A-G-GT-G-T-C--G-G-G-C-A--T---CG---A--A----GG-A-T-G-G-C-C-G-G-T-G-C-C--GT--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-ACC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq994(name, align);
seqs.push_back(newSeq994);
name = "GQY1XT001BDRKB";
align = "A-T--T-T--GA-A-A-C-T---G--TT-T-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-TGC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq995(name, align);
seqs.push_back(newSeq995);
name = "GQY1XT001BCL2I";
align = "A-T--T-T--GA-A-A-C-T-GTT--TT-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----CCC-T-C-C-G---T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq996(name, align);
seqs.push_back(newSeq996);
name = "GQY1XT001BCCY2";
align = "C-G--T-T--GA-A-A-C-T---G--AC-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-GA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq997(name, align);
seqs.push_back(newSeq997);
name = "GQY1XT001BC5ZU";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---C----AT-AA----G-A-C-T-T-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq998(name, align);
seqs.push_back(newSeq998);
name = "GQY1XT001BBVJO";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-AC-C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq999(name, align);
seqs.push_back(newSeq999);
name = "GQY1XT001BBFG5";
align = "C-GT-T-T--GA-A-ACC-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G---A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TTCCG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACCGT-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1000(name, align);
seqs.push_back(newSeq1000);
name = "GQY1XT001BAG3V";
align = "C-C--T-G--CG-A-A-C-T-G-G--GA-T-G-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G--------CC-AA------G-GCCCT-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1001(name, align);
seqs.push_back(newSeq1001);
name = "GQY1XT001B9TIV";
align = "A-T--T-T--GG-A-A-C-T-A-T--CA-A-G-C--T-A-G-A-G-T-A-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-A-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--------GCTAG-AG--------C-C-CTT-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1002(name, align);
seqs.push_back(newSeq1002);
name = "GQY1XT001B9I8C";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1003(name, align);
seqs.push_back(newSeq1003);
name = "GQY1XT001B9GME";
align = "C-A--G-A--GA-A-A-C-C-G-T--AT-A-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-GC-CA-G-G-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-GTT-A-GTAGTT---------------TCGATG-----------C-TACTA-G-T-G-C-C--GG--A-G-T-A-AA-C-A-C-A-A-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq1004(name, align);
seqs.push_back(newSeq1004);
name = "GQY1XT001B7GQG";
align = "A-T--T-T--GG-A-A-C-T-G-T--GT-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----TA-CG----G-A-C-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1005(name, align);
seqs.push_back(newSeq1005);
name = "GQY1XT001B6YL8";
align = "T-C--T-T--GG-A-A-C-T-G-C--GC-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GC-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GGA-GG-CGG-C-TT-A--CTGG-AC-GG-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1006(name, align);
seqs.push_back(newSeq1006);
name = "GQY1XT001B6W23";
align = "A-T--C-A--GA-A-A-C-T-G-T--TG-A-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A---G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T--G-G-G-A-G--G---T----TT-CC----G-C-C-T-C-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1007(name, align);
seqs.push_back(newSeq1007);
name = "GQY1XT001B6E9B";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-TGC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1008(name, align);
seqs.push_back(newSeq1008);
name = "GQY1XT001B5BKI";
align = "A-T--T-T--GG-A-A-C-T-G-T--GT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-C-G-G----G---C-----A-GG----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1009(name, align);
seqs.push_back(newSeq1009);
name = "GQY1XT001B4UWB";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-A-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-G-A-G-GT-G-T-C--G-G---G-A--G---G----CA-GA----G-C-C-T-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1010(name, align);
seqs.push_back(newSeq1010);
name = "GQY1XT001B4M8E";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AC-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1011(name, align);
seqs.push_back(newSeq1011);
name = "GQY1XT001B4J0M";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-GCCC-G---T----AAGG-----G-G-C-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1012(name, align);
seqs.push_back(newSeq1012);
name = "GQY1XT001B4H50";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-TAA-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G---G-G--G---T----AA-G-----G-C---C-C-C-C-G-G-T-G-C-C--GT--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1013(name, align);
seqs.push_back(newSeq1013);
name = "GQY1XT001B3PMW";
align = "T-T--T-T--GA-A-A-C-T-G-T--TG-A-A-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1014(name, align);
seqs.push_back(newSeq1014);
name = "GQY1XT001B32FR";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATG-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1015(name, align);
seqs.push_back(newSeq1015);
name = "GQY1XT001B2GF9";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C--G-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1016(name, align);
seqs.push_back(newSeq1016);
name = "GQY1XT001AZX5J";
align = "G-T--T-C--AA-A-A-C-T-G-A--TA-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T----G-G-G-G-G----------ACT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TTA-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1017(name, align);
seqs.push_back(newSeq1017);
name = "GQY1XT001AZW3I";
align = "A-T--T-C--AA-A-A-C-T-G-C--GA-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T----G-G-G-G-G----------CGT-CA-A------G-C-T-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1018(name, align);
seqs.push_back(newSeq1018);
name = "GQY1XT001AZ0Q5";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T----G-A-G-G-G--G---C----CA-A-----G-C-C-C-C-C-T-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1019(name, align);
seqs.push_back(newSeq1019);
name = "GQY1XT001AYX5B";
align = "T-T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-A-----G-A-A-C-C-TCC-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1020(name, align);
seqs.push_back(newSeq1020);
name = "GQY1XT001AXGVN";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--C---C----CA-AG----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1021(name, align);
seqs.push_back(newSeq1021);
name = "GQY1XT001AXFH3";
align = "C-T--C-T--GA-T-A-C-T-G-T--CG-G-G-C--T-A-G-A-GTT-T-T-AG-TT-G-C-G-G-T-A--GG-C-GG-A-ATG-T-A-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-GG--AG-A-TC-A-T-A-CA-G-A-AC-A-CC-GA-T-T-GC-GAA-GG-CAG-C-TT-A--CCAA-AC-TA-C-G-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AT--AA-C-T-G-G-TT-G-T-C--G-G-C-G------------ATA-AAA---------T-G-T-C-G-G-T-G-A-C--TA--A-G-C-G-AA-A-G-C-G-A-TAA-G-TTA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1022(name, align);
seqs.push_back(newSeq1022);
name = "GQY1XT001AWXTO";
align = "T-T--T-G--GG-A-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--C---A----GA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1023(name, align);
seqs.push_back(newSeq1023);
name = "GQY1XT001AWQD2";
align = "T-T--T-T--GA-A-A-C-T-G-C--AG-A-G-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TC-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G----------ACT-GA-CC-----C-C-A-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1024(name, align);
seqs.push_back(newSeq1024);
name = "GQY1XT001AWCF3";
align = "C-C--T-T--GG-A-A-C-T-G-T--GC-G-G-C--T-G-G-A-G-T-G-C--G-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----CA-AG----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1025(name, align);
seqs.push_back(newSeq1025);
name = "GQY1XT001AW9VM";
align = "A-T--T-G-GAA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-AG----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1026(name, align);
seqs.push_back(newSeq1026);
name = "GQY1XT001AVNVM";
align = "G-T--T-C--CG-G-A-C-TGG-G--GC-G-G-C--T-C-G-A-G-T-G-C-GG-TA-G-A-G-G-A-G--AG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-GAA--TG-C-GC-AG--AT-A-TC-G-G-G-AA-G-A-AC-A-CC-GA-T-G-GC-GAA-GG-CAG-C-TC-T--CTGG-GC-CG-T-C-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-T--GGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CC-A-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G-----------AT-CC-C------C-C-C-T-C-C-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTAAA";
Sequence newSeq1027(name, align);
seqs.push_back(newSeq1027);
name = "GQY1XT001AV50O";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1028(name, align);
seqs.push_back(newSeq1028);
name = "GQY1XT001AV0AG";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--CGA------TT-GA------G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1029(name, align);
seqs.push_back(newSeq1029);
name = "GQY1XT001AUH91";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1030(name, align);
seqs.push_back(newSeq1030);
name = "GQY1XT001AUEHA";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1031(name, align);
seqs.push_back(newSeq1031);
name = "GQY1XT001ASTYP";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-CTG-C-G-T-G-C-C--GG--A-G-T-T-AA-C-G-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1032(name, align);
seqs.push_back(newSeq1032);
name = "GQY1XT001AS6OS";
align = "A-C--T-C--GG-A-A-C-T-G-G--CG-T-G-C--T-A-G-A-G-T-G-T-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AA-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-T--C---C----GA-CA----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1033(name, align);
seqs.push_back(newSeq1033);
name = "GQY1XT001ARMXF";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-G-GCA--C---A----TA-AG----T-G-G-C-C---C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-ACT-TAA-G-TAT-TCC-ACC-T-G-GGA-GG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1034(name, align);
seqs.push_back(newSeq1034);
name = "GQY1XT001AQXRW";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CCC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CTGG-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1035(name, align);
seqs.push_back(newSeq1035);
name = "GQY1XT001AQWB0";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1036(name, align);
seqs.push_back(newSeq1036);
name = "GQY1XT001AQSSN";
align = "..T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-G-G-C--A---C---ATA-A-----G-T-G-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-C-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1037(name, align);
seqs.push_back(newSeq1037);
name = "GQY1XT001AQKX4";
align = "..T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1038(name, align);
seqs.push_back(newSeq1038);
name = "GQY1XT001AQ61I";
align = "A----T-G--GA-A-A-C-T-G-C--AT-A-T-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-A-G--G---C----AA-A-----G-C-C-T-T-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--TG-TT-C-G-C-A-AGAATGGA";
Sequence newSeq1039(name, align);
seqs.push_back(newSeq1039);
name = "GQY1XT001AOO50";
align = "C-A--G-A--GA-A-A-C-C-G-T--AT-A-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-C-AAAC-G-G-TG-AA--TA-C-T-A-A-GT-G-T-C----G-G---------------GA-AA------------C---C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq1040(name, align);
seqs.push_back(newSeq1040);
name = "GQY1XT001ANP6T";
align = "..T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-C-AG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1041(name, align);
seqs.push_back(newSeq1041);
name = "GQY1XT001ANOK9";
align = "T-T--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1042(name, align);
seqs.push_back(newSeq1042);
name = "GQY1XT001AMRUB";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-T-G--C---C----AA-A-----G-G-C-T-C-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1043(name, align);
seqs.push_back(newSeq1043);
name = "GQY1XT001ALJLO";
align = "C-C--T-T--GG-A-A-C-T-G-G--TT-G-G-C--T-G-G-A-G-T-G-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-CG-G-G-G-G-A--C---G----AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1044(name, align);
seqs.push_back(newSeq1044);
name = "GQY1XT001AJ2QW";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---C---ATA-A-----G-A-C-T-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1045(name, align);
seqs.push_back(newSeq1045);
name = "GQY1XT001AHUSC";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1046(name, align);
seqs.push_back(newSeq1046);
name = "GQY1XT001AHUAL";
align = "A-T--C-T--AA-A-A-C-T-G-T--GA-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-A-G-GC-GAA-GG-CGA-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCC-T-AAAC-G-A-TG-GA--TA-C-T-A-G-AG-G-A-A--G-G-G-G-G--T-------ATA-A-------A-C-TCC-TCC-T-G-T-C-T-C--GA--A-G-C-A-AA-C-G-C-G-A-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1047(name, align);
seqs.push_back(newSeq1047);
name = "GQY1XT001AGOD0";
align = "C-G--T-T--GA-A-A-C-T-G-T--AG-G-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GACC------C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1048(name, align);
seqs.push_back(newSeq1048);
name = "GQY1XT001AG9L4";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGG-G-G-G--G--------AA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1049(name, align);
seqs.push_back(newSeq1049);
name = "GQY1XT001AF8KT";
align = "C-G--T-T--GA-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-T-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-----G-G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1050(name, align);
seqs.push_back(newSeq1050);
name = "GQY1XT001AF4C6";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G------------ACCCAAG---------GGTCTCC-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1051(name, align);
seqs.push_back(newSeq1051);
name = "GQY1XT001AEZPI";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G------------GGCCAAGGC-------C-C-TCC-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1052(name, align);
seqs.push_back(newSeq1052);
name = "GQY1XT001AEYWL";
align = "T-T--T-G-GAA-A-A-C-T-G-T--AT-A-G-C--T-G-A-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1053(name, align);
seqs.push_back(newSeq1053);
name = "GQY1XT001A9O5F";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C--G-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-G--A-G-G-G-G--G---C----CA-A-----G-C-C-C-C-C-T-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1054(name, align);
seqs.push_back(newSeq1054);
name = "GQY1XT001A9M51";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1055(name, align);
seqs.push_back(newSeq1055);
name = "GQY1XT001A9L9E";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GGAA-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--T-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1056(name, align);
seqs.push_back(newSeq1056);
name = "GQY1XT001A9ETE";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGGGG-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1057(name, align);
seqs.push_back(newSeq1057);
name = "GQY1XT001A95IK";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G---T--C-G-G-G-G--A---C----CG-AC----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1058(name, align);
seqs.push_back(newSeq1058);
name = "GQY1XT001A913G";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1059(name, align);
seqs.push_back(newSeq1059);
name = "GQY1XT001A8KO0";
align = "C----A-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGG-G-G-G--G--------AA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1060(name, align);
seqs.push_back(newSeq1060);
name = "GQY1XT001A84F0";
align = "A-T--T-G--GA-A-A-C-T-G-T--AG-A-A-C--T-A-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-GT-G-T-C--G-G------------G-----A--A----------A---C-C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq1061(name, align);
seqs.push_back(newSeq1061);
name = "GQY1XT001A7RP1";
align = "A-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-GAC--C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1062(name, align);
seqs.push_back(newSeq1062);
name = "GQY1XT001A7CBN";
align = "A-G--T-T--GA-T-A-C-T-G-G--AT-A-T-C--T-T-G-A-G-T-G-C-AG-TT-G-A-G-G-C-A--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-G--CTAA-GC-TG-C-A-ACT--GACA-TTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CGG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-C-G------------ATA-TAC---------G-G-C-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1063(name, align);
seqs.push_back(newSeq1063);
name = "GQY1XT001A79DG";
align = "C-G--T-T-GAA-A-A-C-T-G-A--CG-T-T-C--T-T-G-AGG-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GGAA-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CCC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1064(name, align);
seqs.push_back(newSeq1064);
name = "GQY1XT001A6ZCJ";
align = "A-T--T-G--GA-A-A-C-T-G-T--TT-A-A-C--T-G-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-GT-G-T-C----G-G-G----A--------AA-------------C-----C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq1065(name, align);
seqs.push_back(newSeq1065);
name = "GQY1XT001A6TCB";
align = "T-C--T-G--GA-A-A-C-T-A-T--GT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-GG----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1066(name, align);
seqs.push_back(newSeq1066);
name = "GQY1XT001A6PVD";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-GG--CG-C-T-A-G-GT-G-T-C--CGGGG-G-G--G--------AA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1067(name, align);
seqs.push_back(newSeq1067);
name = "GQY1XT001A5XMR";
align = "T-T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1068(name, align);
seqs.push_back(newSeq1068);
name = "GQY1XT001A5HB1";
align = "A-C--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AG-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1069(name, align);
seqs.push_back(newSeq1069);
name = "GQY1XT001A4YSE";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------AT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1070(name, align);
seqs.push_back(newSeq1070);
name = "GQY1XT001A4NL2";
align = "T-T--T-G--GA-A-A-C-T-G-T--TA-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1071(name, align);
seqs.push_back(newSeq1071);
name = "GQY1XT001A3MZI";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-AC-C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1072(name, align);
seqs.push_back(newSeq1072);
name = "GQY1XT001A3K6U";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-C--CTGG-TC-TG-C-A-ACT--GACA-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-G-T--T-G-G-G-G--G---T----CG-A-----A-C---C---T-C-A-G-T-G-C-T--GA--A-G-T-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGGAGG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq1073(name, align);
seqs.push_back(newSeq1073);
name = "GQY1XT001A3DE2";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-G-GCA--C---A----TA-AG----T-G-G-C-C---C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-C-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1074(name, align);
seqs.push_back(newSeq1074);
name = "GQY1XT001A3B9P";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AG-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-C--C---CT---AA-G-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1075(name, align);
seqs.push_back(newSeq1075);
name = "GQY1XT001A3680";
align = "A-T--T-T--GA-A-A-C-T-G-T--AG-G-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-GCT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A----------ACGACA-GT-----T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1076(name, align);
seqs.push_back(newSeq1076);
name = "GQY1XT001A2FJ5";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-G-T--T---C----AA-G-----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1077(name, align);
seqs.push_back(newSeq1077);
name = "GQY1XT001A2E5Q";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------AAA-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1078(name, align);
seqs.push_back(newSeq1078);
name = "GQY1XT001A1NGX";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-TC-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1079(name, align);
seqs.push_back(newSeq1079);
name = "GQY1XT001A0Y0K";
align = "C-G--T-T--GA-A-A-C-T-G-A--C--G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-T-C--C-G-G-G-T--C-------GAA-TGA-----G-A-T-C-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1080(name, align);
seqs.push_back(newSeq1080);
name = "GQY1XT001C8WLX";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1081(name, align);
seqs.push_back(newSeq1081);
name = "GQY1XT001ARWIN";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1082(name, align);
seqs.push_back(newSeq1082);
name = "GQY1XT001DWF91";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--CGA------AT-GA------G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1083(name, align);
seqs.push_back(newSeq1083);
name = "GQY1XT001A6L7F";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1084(name, align);
seqs.push_back(newSeq1084);
name = "GQY1XT001DCSAA";
align = "A-T--T-T--GA-A-A-C-T-G-T--GT-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1085(name, align);
seqs.push_back(newSeq1085);
name = "GQY1XT001AO4OF";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1086(name, align);
seqs.push_back(newSeq1086);
name = "GQY1XT001EYTUJ";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1087(name, align);
seqs.push_back(newSeq1087);
name = "GQY1XT001DX7JG";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1088(name, align);
seqs.push_back(newSeq1088);
name = "GQY1XT001DD6MN";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-GC-T---C----AC-G-----G-G-C-G-C-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1089(name, align);
seqs.push_back(newSeq1089);
name = "GQY1XT001A2X6V";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1090(name, align);
seqs.push_back(newSeq1090);
name = "GQY1XT001ER71E";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGGGG-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1091(name, align);
seqs.push_back(newSeq1091);
name = "GQY1XT001EK6NY";
align = "T-C--T-G--GA-A-A-C-T-G-T--AG-A-G-C--T-G-G-A-G-T-G-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-C-G-G-T--A---C----GA-A-----G-T-A-C-T-G-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1092(name, align);
seqs.push_back(newSeq1092);
name = "GQY1XT001E0S28";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1093(name, align);
seqs.push_back(newSeq1093);
name = "GQY1XT001DWQKZ";
align = "T-T--T-T--GA-A-A-C-T-G-T--TG-A-A-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-T-A-ACT--GACA-CTG-A-GG--T-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G-T--C--------GC-AA------G-A-C-T-T-C-G-G-T-G-C-C--GT--A-G-T-T-AA-C-G-C-A-T-TAA-G-TGC-TCC-GCC-T-G-GGG-AG-TA--CG-CA-C-G-C-A-AGTGTGAA";
Sequence newSeq1094(name, align);
seqs.push_back(newSeq1094);
name = "GQY1XT001DMFJ7";
align = "A-C--T-C--GG-A-A-C-T-G-G--CG-T-G-C--T-A-G-A-G-T-G-T-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AA-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-G-G-T-C--C---G----AC-A-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1095(name, align);
seqs.push_back(newSeq1095);
name = "GQY1XT001DEIXZ";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1096(name, align);
seqs.push_back(newSeq1096);
name = "GQY1XT001CRU7B";
align = "T-T--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1097(name, align);
seqs.push_back(newSeq1097);
name = "GQY1XT001CQC5Q";
align = "T-C--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-T-A-A-G-T-G-C-AG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-C-G-G-A--GT--C----AA-G-----G-C-T-C-T-G-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1098(name, align);
seqs.push_back(newSeq1098);
name = "GQY1XT001EURNN";
align = "A-T--T-G--GA-A-A-C-T-G-T--CG-G-A-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-T-G--G---C----AA-A-----G-C-C-A-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1099(name, align);
seqs.push_back(newSeq1099);
name = "GQY1XT001ETZ76";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-GTG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1100(name, align);
seqs.push_back(newSeq1100);
name = "GQY1XT001E25J6";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1101(name, align);
seqs.push_back(newSeq1101);
name = "GQY1XT001DUTRF";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1102(name, align);
seqs.push_back(newSeq1102);
name = "GQY1XT001DP8X2";
align = "A-T--T-T--GA-A-A-C-T-G-T--AT-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----CCC-T-C-C-G---T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1103(name, align);
seqs.push_back(newSeq1103);
name = "GQY1XT001DDM4B";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1104(name, align);
seqs.push_back(newSeq1104);
name = "GQY1XT001CV0CL";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GG------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1105(name, align);
seqs.push_back(newSeq1105);
name = "GQY1XT001CRXFZ";
align = "A-A--C-T--AA-A-A-C-T-A-T--CT-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-A-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-T--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-A--G-G-A-G-A--T-------GAA-TA------A-T-C-T-T-C-T-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1106(name, align);
seqs.push_back(newSeq1106);
name = "GQY1XT001CJN5F";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GATG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-T-G--C---C----AA-A-----G-G-C-T-C-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1107(name, align);
seqs.push_back(newSeq1107);
name = "GQY1XT001C8VP3";
align = "C-C--T-G--CG-A-A-C-T-G-G--GT-T-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-T-T-ACT--GACA-CTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G-T--C--------GC-AA------G-A-C-T-T-C-G-G-T-G-C-C--GC--A-G-T-T-AA-C-G-C-A-T-TAA-G-TGC-TCC-GCC-T-G-GGG-AG-TA--CG-TA-C-G-C-A-AGTATGAA";
Sequence newSeq1108(name, align);
seqs.push_back(newSeq1108);
name = "GQY1XT001BWP2E";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AG-A-----GAC-T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1109(name, align);
seqs.push_back(newSeq1109);
name = "GQY1XT001BPR6V";
align = "C-A--G-A--GA-A-A-C-C-G-T--AT-A-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-GT-G-T-C--G-G---G------------A-A--AC---------------C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq1110(name, align);
seqs.push_back(newSeq1110);
name = "GQY1XT001BH3F6";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1111(name, align);
seqs.push_back(newSeq1111);
name = "GQY1XT001B6491";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1112(name, align);
seqs.push_back(newSeq1112);
name = "GQY1XT001AUFBS";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1113(name, align);
seqs.push_back(newSeq1113);
name = "GQY1XT001AT9WW";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1114(name, align);
seqs.push_back(newSeq1114);
name = "GQY1XT001APJL5";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-CCGGGG-G-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1115(name, align);
seqs.push_back(newSeq1115);
name = "GQY1XT001A79Q2";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1116(name, align);
seqs.push_back(newSeq1116);
name = "GQY1XT001A5DY7";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1117(name, align);
seqs.push_back(newSeq1117);
name = "GQY1XT001A57CJ";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1118(name, align);
seqs.push_back(newSeq1118);
name = "GQY1XT001A180R";
align = "A-A--C-T--AA-A-A-C-T-A-T--TT-T-T-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-A--G-G-A-G-A--T-------ATT-A-----A-G-T-C-T-T-C-T-G-T-G-C-C--G---TCG-C-A-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1119(name, align);
seqs.push_back(newSeq1119);
name = "GQY1XT001EZ0T4";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1120(name, align);
seqs.push_back(newSeq1120);
name = "GQY1XT001EYASV";
align = "G-C--C-G--GG-T-A-C-G-G-G--CG-G-G-C--T-T-G-A-G-T-G-C-GG-TA-G-G-G-G-A-G--AC-T-GG-A-ATTCC-C-C-G-GT-GT-A-A-CGGT-G-GAA--TG-T-GT-AG--AT-A-TC-G-G-G-AA-G-A-AC-A-CC-AA-T-G-GC-GAA-GG-CAG-G-TC-T--CTGG-GC-CG-T-T-ACT--GACG-CTG-A-GG--A-G-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-G-TG-GA--TG-C-T-G-G-AT-G-T-G--G-G-G-C-C--C------TTTT-TC-C----G-G-G-T-C-C-T-G-T-G-T-C--GG--A-G-C-T-AA-C-G-C-G-T-TAA-G-CAT-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTAAA";
Sequence newSeq1121(name, align);
seqs.push_back(newSeq1121);
name = "GQY1XT001EX8JH";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1122(name, align);
seqs.push_back(newSeq1122);
name = "GQY1XT001EWSQ7";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1123(name, align);
seqs.push_back(newSeq1123);
name = "GQY1XT001EWJ0G";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---C----ATAA-----G-A-C-T-T-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1124(name, align);
seqs.push_back(newSeq1124);
name = "GQY1XT001EWCLZ";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1125(name, align);
seqs.push_back(newSeq1125);
name = "GQY1XT001EW4SG";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GG------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1126(name, align);
seqs.push_back(newSeq1126);
name = "GQY1XT001EVMR1";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-T--T-------CTA-CG------G-G-A-C-T-G-G-G-C-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1127(name, align);
seqs.push_back(newSeq1127);
name = "GQY1XT001ESC8I";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-TGG-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1128(name, align);
seqs.push_back(newSeq1128);
name = "GQY1XT001ES7A7";
align = "T-T--T-G--GA-A-A-C-T-G-T--AC-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-T-G--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1129(name, align);
seqs.push_back(newSeq1129);
name = "GQY1XT001ERCRU";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-GCG-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GTGG-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1130(name, align);
seqs.push_back(newSeq1130);
name = "GQY1XT001EPXLK";
align = "A-T--T-T--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-A--G-G-A-G------------ATATTAAG--------TCT-T-C-T-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1131(name, align);
seqs.push_back(newSeq1131);
name = "GQY1XT001EPRKA";
align = "C-G----T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1132(name, align);
seqs.push_back(newSeq1132);
name = "GQY1XT001EP50F";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-GTCCGG-G-G-G-GA-----------ATG-GCC---------C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1133(name, align);
seqs.push_back(newSeq1133);
name = "GQY1XT001ENIJK";
align = "T-T--T-G--GA-A-A-C-T-G-A--GC-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GGA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-A-G--G---C----AA-A-----G-C-C-T-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C--AAGAATGAA";
Sequence newSeq1134(name, align);
seqs.push_back(newSeq1134);
name = "GQY1XT001ELQAV";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1135(name, align);
seqs.push_back(newSeq1135);
name = "GQY1XT001EL1XN";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------GAG-TAA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1136(name, align);
seqs.push_back(newSeq1136);
name = "GQY1XT001EK9UC";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GG------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1137(name, align);
seqs.push_back(newSeq1137);
name = "GQY1XT001EJ6IE";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1138(name, align);
seqs.push_back(newSeq1138);
name = "GQY1XT001EINOB";
align = "G-T--T-T--GA-A-A-C-T-G-T--GG-G-G-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-A--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-A-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGGAGG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1139(name, align);
seqs.push_back(newSeq1139);
name = "GQY1XT001EHR1D";
align = "C-G--T-T--GA-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-T-G-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1140(name, align);
seqs.push_back(newSeq1140);
name = "GQY1XT001EG89W";
align = "A-C--T-C--AA-A-A-C-T-G-C--AG-C-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC---AAACA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1141(name, align);
seqs.push_back(newSeq1141);
name = "GQY1XT001EE7HC";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1142(name, align);
seqs.push_back(newSeq1142);
name = "GQY1XT001EDX2L";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-GTG-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--CGA------TT-GA------G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1143(name, align);
seqs.push_back(newSeq1143);
name = "GQY1XT001ECV6N";
align = "T-T--T-G--GA-A-A-C-T-G-T--TA-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C--AAGAATGAA";
Sequence newSeq1144(name, align);
seqs.push_back(newSeq1144);
name = "GQY1XT001EC768";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1145(name, align);
seqs.push_back(newSeq1145);
name = "GQY1XT001EC5ZD";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TG-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-C--GG--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1146(name, align);
seqs.push_back(newSeq1146);
name = "GQY1XT001EBILS";
align = "C-GT-T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1147(name, align);
seqs.push_back(newSeq1147);
name = "GQY1XT001E5VFY";
align = "A-T--T-G--GA-A-A-C-T-G-T--AG-A-A-C--T-A-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G---G--C---C----CG-A-----A-G-G-G-C-GTC-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1148(name, align);
seqs.push_back(newSeq1148);
name = "GQY1XT001E4RC6";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T---G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACCGT-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1149(name, align);
seqs.push_back(newSeq1149);
name = "GQY1XT001E26E5";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1150(name, align);
seqs.push_back(newSeq1150);
name = "GQY1XT001DZGN2";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C---G---G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1151(name, align);
seqs.push_back(newSeq1151);
name = "GQY1XT001DY9EE";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GC-G-T----T-G-G-A-G--G-------GTT-TCC-----G-C-C-CTT-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1152(name, align);
seqs.push_back(newSeq1152);
name = "GQY1XT001DXZ94";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1153(name, align);
seqs.push_back(newSeq1153);
name = "GQY1XT001DXXRY";
align = "C-GT-T-T--GA-A-A-C-T-G-A--TT-TGT-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1154(name, align);
seqs.push_back(newSeq1154);
name = "GQY1XT001DX5YX";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C----T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----TCC-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1155(name, align);
seqs.push_back(newSeq1155);
name = "GQY1XT001DWB8A";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1156(name, align);
seqs.push_back(newSeq1156);
name = "GQY1XT001DW661";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T---G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-TGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1157(name, align);
seqs.push_back(newSeq1157);
name = "GQY1XT001DVVV9";
align = "A-T--T-T--GG-A-A-C-T-G-T--TA-A-G-C--T-G-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGGAGG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1158(name, align);
seqs.push_back(newSeq1158);
name = "GQY1XT001DVRMX";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1159(name, align);
seqs.push_back(newSeq1159);
name = "GQY1XT001DUGOQ";
align = "A-T--C-A--GA-A-A-C-T-G-T--TG-A-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AA-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-A-A-TG-AG--TG-C-T-A-G-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-C--GG--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1160(name, align);
seqs.push_back(newSeq1160);
name = "GQY1XT001DSKYO";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1161(name, align);
seqs.push_back(newSeq1161);
name = "GQY1XT001DQEX4";
align = "C-G----T--GA-A-A-C-T-G-A--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1162(name, align);
seqs.push_back(newSeq1162);
name = "GQY1XT001DPQ0U";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G---A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1163(name, align);
seqs.push_back(newSeq1163);
name = "GQY1XT001DP988";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1164(name, align);
seqs.push_back(newSeq1164);
name = "GQY1XT001DOEFT";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAGGTGA-----GCC-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1165(name, align);
seqs.push_back(newSeq1165);
name = "GQY1XT001DMV73";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1166(name, align);
seqs.push_back(newSeq1166);
name = "GQY1XT001DMAIL";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1167(name, align);
seqs.push_back(newSeq1167);
name = "GQY1XT001DJKAP";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1168(name, align);
seqs.push_back(newSeq1168);
name = "GQY1XT001DIY7I";
align = "T-T--T-T--GA-A-A-C-T-G-T--GT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-T-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-TCC-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-A-TAT-TCC-ACC-T---GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1169(name, align);
seqs.push_back(newSeq1169);
name = "GQY1XT001DI2F4";
align = "T-C--T-G--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-A-C-TG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-G--A-G-G-G-G--G---C----CA-A-----G-C-C-C-C-C-T-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1170(name, align);
seqs.push_back(newSeq1170);
name = "GQY1XT001DG89M";
align = "A-C--T-C--AA-A-A-C-T-G-C--AG-C-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A----------CCC-AAGGG-----T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1171(name, align);
seqs.push_back(newSeq1171);
name = "GQY1XT001DFPOZ";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-CT-T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1172(name, align);
seqs.push_back(newSeq1172);
name = "GQY1XT001DFNZA";
align = "A-C--T-C--AA-A-A-C-T-G-C--AG-C-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-T-A-ACT--GACA-CTG-A-GG--T-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G-T--C--------GC-AA------G-A-C-T-T-C-G-G-T-G-C-C--GT--A-G-T-T-AA-C-G-C-A-T-TAA-G-TGC-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1173(name, align);
seqs.push_back(newSeq1173);
name = "GQY1XT001DFFH1";
align = "G-T--C-C--CG-G-A-C-T-G-G--GC-G-G-C--T-C-G-A-G-T-G-C-GG-TA-G-A-G-G-A-G--AG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-GAA--TG-C-GC-AG--AT-A-TC-G-G-G-AA-G-A-AC-A-CC-GA-T-G-GC-GAA-GG-CAG-C-TC-T--CTGG-GC-CG-T-C-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-T-GGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CC-A-G-CCG-T-AAAC-G-A-TG-GG--CG-C-T-A-G-GT-G-T-G--G-G-G-G-G-----------AC-GA-T------C-C-C-T-C-C-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-CGC-CCC-GCC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTAAA";
Sequence newSeq1174(name, align);
seqs.push_back(newSeq1174);
name = "GQY1XT001DECCK";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G--A---C----TG-A-----C-C-C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1175(name, align);
seqs.push_back(newSeq1175);
name = "GQY1XT001DDP54";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-G--------G----TA-AG----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1176(name, align);
seqs.push_back(newSeq1176);
name = "GQY1XT001DCWXL";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1177(name, align);
seqs.push_back(newSeq1177);
name = "GQY1XT001DCROU";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GA------G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1178(name, align);
seqs.push_back(newSeq1178);
name = "GQY1XT001DCHHZ";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1179(name, align);
seqs.push_back(newSeq1179);
name = "GQY1XT001DBR6R";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-CT-G---T--C-C-G-G-G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1180(name, align);
seqs.push_back(newSeq1180);
name = "GQY1XT001DBR15";
align = "A-T--T-T--GA-A-A-C-TGT-T--TT-T-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-AA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-TGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1181(name, align);
seqs.push_back(newSeq1181);
name = "GQY1XT001DB6W5";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--ATAA-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CAGGG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TTCGG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1182(name, align);
seqs.push_back(newSeq1182);
name = "GQY1XT001DB48V";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T----GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CTGG-T-T--T-G-C-G------------ATA-TACC--------A-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1183(name, align);
seqs.push_back(newSeq1183);
name = "GQY1XT001DAXHO";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1184(name, align);
seqs.push_back(newSeq1184);
name = "GQY1XT001DA3NK";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GA------G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1185(name, align);
seqs.push_back(newSeq1185);
name = "GQY1XT001D9XV0";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1186(name, align);
seqs.push_back(newSeq1186);
name = "GQY1XT001D9PEI";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------AT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1187(name, align);
seqs.push_back(newSeq1187);
name = "GQY1XT001D9NS0";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1188(name, align);
seqs.push_back(newSeq1188);
name = "GQY1XT001D9LBF";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG---T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1189(name, align);
seqs.push_back(newSeq1189);
name = "GQY1XT001D90UB";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGG-G-G-G--G--------AA-TG------G-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1190(name, align);
seqs.push_back(newSeq1190);
name = "GQY1XT001D7SQ4";
align = "T-T--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1191(name, align);
seqs.push_back(newSeq1191);
name = "GQY1XT001D73BL";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-C-A-G-GT-G-T-C--G-G-G-T-G--T---C----GA-A-----G-G-A-CGG-C-C-G-G-T-G-C-C--GC--A-G-C-G-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1192(name, align);
seqs.push_back(newSeq1192);
name = "GQY1XT001D6WIL";
align = "G-T--T-C--AA-A-A-C-T-G-C--AG-G-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AGA-T--A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-A-G----------A-T-CA-AA-----C-T-T-T-C-C-G-T-G-C-C--GG--A-G-T-A-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1193(name, align);
seqs.push_back(newSeq1193);
name = "GQY1XT001D54HY";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-A-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1194(name, align);
seqs.push_back(newSeq1194);
name = "GQY1XT001D4WJX";
align = "C-G----T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1195(name, align);
seqs.push_back(newSeq1195);
name = "GQY1XT001D4IMR";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-TCC--G-GCCCG------------ATT-GGG---------G-GCT-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1196(name, align);
seqs.push_back(newSeq1196);
name = "GQY1XT001D4AF7";
align = "T-C--T-G-GAA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1197(name, align);
seqs.push_back(newSeq1197);
name = "GQY1XT001D404H";
align = "CAT--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--CGA------GT-GA------G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1198(name, align);
seqs.push_back(newSeq1198);
name = "GQY1XT001D3JL9";
align = "A-C--T-G--GG-A-A-C-T-G-T--CA-G-A-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-TAA--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-C-A-ACT--GACG-TTG-A-GG--C-C-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-TA--TA-C-C-A-G-GT-G-T-C--G-G-A-T-A--T---C----AA-G-----G-A-T-A-T-C-C-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-ACC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1199(name, align);
seqs.push_back(newSeq1199);
name = "GQY1XT001D36LX";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1200(name, align);
seqs.push_back(newSeq1200);
name = "GQY1XT001D34SX";
align = "C-T--C-T--GA-T-A-C-T-G-T--CG-G-G-C--T-A-G-A-G-T-T-T-AG-TT-G-C-G-G-T-A--GG-C-GG-A-ATG-T-A-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AG-A-TC-A-T-A-CA-G-A-AC-A-CC-GA-T-T-GC-GAA-GG-CAG-C-TT-A--CCAA-AC-TA-C-G-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AT--AA-C-T-G-G-TT-G-T-C--G-G-C-G------------ATA-AAA---------T-G-T-C-G-G-T-G-A-C--TA--A-G-C-G-AA-A-G-C-G-A-TAA-G-TTA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1201(name, align);
seqs.push_back(newSeq1201);
name = "GQY1XT001D2Z78";
align = "C-G--T-T--GA-A-A-C-T-G-G---G-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGGGG-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1202(name, align);
seqs.push_back(newSeq1202);
name = "GQY1XT001D26TY";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1203(name, align);
seqs.push_back(newSeq1203);
name = "GQY1XT001D0PS5";
align = "A-T--T-T--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-G-T-G-G----G---T----AT-GG----A-C-C-C-A-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1204(name, align);
seqs.push_back(newSeq1204);
name = "GQY1XT001D096N";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1205(name, align);
seqs.push_back(newSeq1205);
name = "GQY1XT001CZLBS";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1206(name, align);
seqs.push_back(newSeq1206);
name = "GQY1XT001CZJDF";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1207(name, align);
seqs.push_back(newSeq1207);
name = "GQY1XT001CZIDF";
align = "A-T--T-T--GG-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-G-G-G-C--T---C----AC-G-----G-G-C-G-C-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1208(name, align);
seqs.push_back(newSeq1208);
name = "GQY1XT001CYTB5";
align = "C-G--T-T--GA-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-T-G-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1209(name, align);
seqs.push_back(newSeq1209);
name = "GQY1XT001CXSFV";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-AA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1210(name, align);
seqs.push_back(newSeq1210);
name = "GQY1XT001CVW9J";
align = "C-T--C-T--GA-T-A-C-T-G-T--CG-G-G-C--T-A-G-A-G-T-T-T-AG-TT-G-C-G-G-T-A--GG-C-GG-A-ATG-T-A-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AG-A-TC-A-T-A-CA-G-A-AC-A-CC-GA-T-T-GC-GAA-GG-CAG-C-TT-A--CCAA-AC-TA-C-G-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-CG-G-G-G-G-----------ACGA-CAG---------T-GCCCC-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1211(name, align);
seqs.push_back(newSeq1211);
name = "GQY1XT001CVNYD";
align = "G-T--T-C--AA-A-A-C-T-G-A--TA-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq1212(name, align);
seqs.push_back(newSeq1212);
name = "GQY1XT001CVDAV";
align = "A-T--T-T--GG-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-TCG--G-G-G-G-C--T---C----AC-G-----G-G-C-G-C-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1213(name, align);
seqs.push_back(newSeq1213);
name = "GQY1XT001CTR8U";
align = "G-A--T-C--AA-A-A-C-T-G-C--AA-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1214(name, align);
seqs.push_back(newSeq1214);
name = "GQY1XT001CT03W";
align = "T-C--T-G--GA-A-A-C-T-G-C--GT-C-G-C--T-T-G-G-A-G-T-A-CG-GG-A-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AGA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A--C---G----AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1215(name, align);
seqs.push_back(newSeq1215);
name = "GQY1XT001CSFPB";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1216(name, align);
seqs.push_back(newSeq1216);
name = "GQY1XT001CSE8M";
align = "C-G----T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--CGA------TT-GA------G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1217(name, align);
seqs.push_back(newSeq1217);
name = "GQY1XT001CS75Q";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1218(name, align);
seqs.push_back(newSeq1218);
name = "GQY1XT001CRCO3";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1219(name, align);
seqs.push_back(newSeq1219);
name = "GQY1XT001CR3OY";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G---G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1220(name, align);
seqs.push_back(newSeq1220);
name = "GQY1XT001CQNP0";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C----T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1221(name, align);
seqs.push_back(newSeq1221);
name = "GQY1XT001CQISV";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1222(name, align);
seqs.push_back(newSeq1222);
name = "GQY1XT001CO2B2";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1223(name, align);
seqs.push_back(newSeq1223);
name = "GQY1XT001CO0A6";
align = "C-G----T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G---GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1224(name, align);
seqs.push_back(newSeq1224);
name = "GQY1XT001CN21H";
align = "C-G--T-TC-GA-A-A-C-TAG-GA-GG-C-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1225(name, align);
seqs.push_back(newSeq1225);
name = "GQY1XT001CMSDB";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C---G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1226(name, align);
seqs.push_back(newSeq1226);
name = "GQY1XT001CMP9R";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-T--T-------CTA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1227(name, align);
seqs.push_back(newSeq1227);
name = "GQY1XT001CM9OV";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-C-G-C--T-C-G-A-G-T-G-C-CG-GA-G-G---GGC-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---CT---AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1228(name, align);
seqs.push_back(newSeq1228);
name = "GQY1XT001CM539";
align = "A-T--C-A--GA-A-A-C-T-G-T--TG-A-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G---G--A---G----CA-AA----G-C-T-T-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1229(name, align);
seqs.push_back(newSeq1229);
name = "GQY1XT001CM0Q4";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAACGG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-C-G------------ATA-TAC---------G-G-T-A-A-G-C-A-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1230(name, align);
seqs.push_back(newSeq1230);
name = "GQY1XT001CLDR0";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1231(name, align);
seqs.push_back(newSeq1231);
name = "GQY1XT001CKNS4";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1232(name, align);
seqs.push_back(newSeq1232);
name = "GQY1XT001CJLK2";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--C-------GAG-TGA-----G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1233(name, align);
seqs.push_back(newSeq1233);
name = "GQY1XT001CJIIR";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1234(name, align);
seqs.push_back(newSeq1234);
name = "GQY1XT001CJAFS";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-T-C--C-G-G-G-T--CGA------AT-GA------G-A-T-C-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1235(name, align);
seqs.push_back(newSeq1235);
name = "GQY1XT001CJ3M8";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-T-C-A-AGAATGAA";
Sequence newSeq1236(name, align);
seqs.push_back(newSeq1236);
name = "GQY1XT001CJ0AB";
align = "T-T--T-G--GA-A-A-C-T-G-C--CT-G-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CGAAAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1237(name, align);
seqs.push_back(newSeq1237);
name = "GQY1XT001CIODF";
align = "C-G--T-T--GA-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-T-G-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-G-G-TT-G-TCCG-G-GTC-G------------AAT-GAGA--------T-C-T-G-G-G-C-G-G-C--GA--A-G-C-G-AA-A-G-C-G-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1238(name, align);
seqs.push_back(newSeq1238);
name = "GQY1XT001CID7T";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CG-------AT-TG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1239(name, align);
seqs.push_back(newSeq1239);
name = "GQY1XT001CIB8G";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-C-G-C--T-C-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-GTACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G--A---C----TG-A-----C-C-C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1240(name, align);
seqs.push_back(newSeq1240);
name = "GQY1XT001CH8FI";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T--G-G-G-A-G--G---T----TT-CC----G-C-C-T-C-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1241(name, align);
seqs.push_back(newSeq1241);
name = "GQY1XT001CFUS2";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------AT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1242(name, align);
seqs.push_back(newSeq1242);
name = "GQY1XT001CFEOC";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGGGG-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1243(name, align);
seqs.push_back(newSeq1243);
name = "GQY1XT001CFDUW";
align = "C-GT-T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1244(name, align);
seqs.push_back(newSeq1244);
name = "GQY1XT001CED3S";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----TAGA-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGGTTGAA";
Sequence newSeq1245(name, align);
seqs.push_back(newSeq1245);
name = "GQY1XT001CE5F9";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--CAA------AT-GA------G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1246(name, align);
seqs.push_back(newSeq1246);
name = "GQY1XT001CCIDU";
align = "G-T--T-C--AA-A-A-C-T-G-C--AG-G-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC---AAACA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-C----------CCA-CA-GG-----G-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1247(name, align);
seqs.push_back(newSeq1247);
name = "GQY1XT001CBTVR";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1248(name, align);
seqs.push_back(newSeq1248);
name = "GQY1XT001CB6LJ";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--CGA------AT-GA------G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1249(name, align);
seqs.push_back(newSeq1249);
name = "GQY1XT001CAO9E";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--C---C----CA-A-----G-G-G-T-C-TCC-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1250(name, align);
seqs.push_back(newSeq1250);
name = "GQY1XT001C9TKV";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-C--CGA------TT-GG------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1251(name, align);
seqs.push_back(newSeq1251);
name = "GQY1XT001C9NXV";
align = "T-C--T-T--GG-A-A-C-T-G-C--GC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1252(name, align);
seqs.push_back(newSeq1252);
name = "GQY1XT001C8JHR";
align = "T-T--T-T--GA-A-A-C-T-G-T--AG-G-G-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATTCC-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1253(name, align);
seqs.push_back(newSeq1253);
name = "GQY1XT001C7ZUB";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGGAGG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1254(name, align);
seqs.push_back(newSeq1254);
name = "GQY1XT001C7O3D";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1255(name, align);
seqs.push_back(newSeq1255);
name = "GQY1XT001C6LWA";
align = "C-G--T-T--GA-A-A-C-T-G----GG-G-C-C--T-T-G-A-G-T---G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTGAA-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1256(name, align);
seqs.push_back(newSeq1256);
name = "GQY1XT001C6HBD";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1257(name, align);
seqs.push_back(newSeq1257);
name = "GQY1XT001C653P";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GATA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1258(name, align);
seqs.push_back(newSeq1258);
name = "GQY1XT001C5MUK";
align = "ATT--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-ACCC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G-AGGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-AG----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA-CGG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1259(name, align);
seqs.push_back(newSeq1259);
name = "GQY1XT001C4W7P";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAGTGGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1260(name, align);
seqs.push_back(newSeq1260);
name = "GQY1XT001C34WE";
align = "C-C--T-G--CG-A-A-C-T-G-G--GA-T-G-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-GC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1261(name, align);
seqs.push_back(newSeq1261);
name = "GQY1XT001C2MZ1";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-C-AG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1262(name, align);
seqs.push_back(newSeq1262);
name = "GQY1XT001C24KA";
align = "C-G--T-T--GA-A-A-C-T-G----GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1263(name, align);
seqs.push_back(newSeq1263);
name = "GQY1XT001C1J8R";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1264(name, align);
seqs.push_back(newSeq1264);
name = "GQY1XT001C063V";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-A-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TA-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1265(name, align);
seqs.push_back(newSeq1265);
name = "GQY1XT001BZVNE";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-T--T-------CTA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1266(name, align);
seqs.push_back(newSeq1266);
name = "GQY1XT001BZDM7";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-G-T--C-G-G-G-G--G---CT---CA-C-----G-G-G-CGC-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1267(name, align);
seqs.push_back(newSeq1267);
name = "GQY1XT001BY007";
align = "T-C--T-G-GAA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1268(name, align);
seqs.push_back(newSeq1268);
name = "GQY1XT001BXHIS";
align = "T-T--T-G--GG-A-A-C-T-G-T--TT-T-G-C--T-G-G-A-G-T-A-T-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CA-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-C-A-G-GT-G-T-CG-G-G-T-G-T--C---G----AA-G-----G-A-C-G-G-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1269(name, align);
seqs.push_back(newSeq1269);
name = "GQY1XT001BX11Y";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C----T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-T-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1270(name, align);
seqs.push_back(newSeq1270);
name = "GQY1XT001BWODL";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--TCG-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TTC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1271(name, align);
seqs.push_back(newSeq1271);
name = "GQY1XT001BW0YY";
align = "C-G--T-T--GA-A-A-C-T-G-A--C--G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1272(name, align);
seqs.push_back(newSeq1272);
name = "GQY1XT001BVIE9";
align = "AGT--T-G-GAA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-G----T---T----CA-AG----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1273(name, align);
seqs.push_back(newSeq1273);
name = "GQY1XT001BVA7U";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-GA--TA-C-T-C-G-CT-G-T-T----T-G-C-G--A--------TA-T-A-------C-G-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1274(name, align);
seqs.push_back(newSeq1274);
name = "GQY1XT001BUF2I";
align = "G-T--T-C--AA-A-A-C-T-G-T--TC-T-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AGA-T--A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCA-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G----------ACT-GA-CC-----C-C-A-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1275(name, align);
seqs.push_back(newSeq1275);
name = "GQY1XT001BSJ6O";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1276(name, align);
seqs.push_back(newSeq1276);
name = "GQY1XT001BROZN";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1277(name, align);
seqs.push_back(newSeq1277);
name = "GQY1XT001BPYYS";
align = "A-C--T-G--GG-A-A-C-T-G-T--CA-G-A-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-C-A-ACT--GACG-TTG-A-GG--C-C-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-TA--TA-C-C-A-G-GT-G-T-C--G-G-A-T-A--T---C----AA-G-----G-A-T-A-T-C-C-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-ACC-ACC-T-G-GGGAGG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1278(name, align);
seqs.push_back(newSeq1278);
name = "GQY1XT001BN5O9";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1279(name, align);
seqs.push_back(newSeq1279);
name = "GQY1XT001BLPCS";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-G--CGA------GT-GA------G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1280(name, align);
seqs.push_back(newSeq1280);
name = "GQY1XT001BKAZ3";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1281(name, align);
seqs.push_back(newSeq1281);
name = "GQY1XT001BJITH";
align = "A-T--T-G--GA-A-A-C-T-A-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-AG----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1282(name, align);
seqs.push_back(newSeq1282);
name = "GQY1XT001BJIGU";
align = "C-C--T-T--GG-A-A-C-T-G-C--AT-G-G-C--T-G-G-A-G-T-G-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-CG-G-G-G-G-A--C---G----AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGAATGAA";
Sequence newSeq1283(name, align);
seqs.push_back(newSeq1283);
name = "GQY1XT001BJ3FA";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1284(name, align);
seqs.push_back(newSeq1284);
name = "GQY1XT001BIZB8";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1285(name, align);
seqs.push_back(newSeq1285);
name = "GQY1XT001BI4HN";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AT-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-A-G-G---------TATT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1286(name, align);
seqs.push_back(newSeq1286);
name = "GQY1XT001BH4H2";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1287(name, align);
seqs.push_back(newSeq1287);
name = "GQY1XT001BGGFI";
align = "C-G--T-T--GA-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-T-G-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1288(name, align);
seqs.push_back(newSeq1288);
name = "GQY1XT001BFQBJ";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-G-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1289(name, align);
seqs.push_back(newSeq1289);
name = "GQY1XT001BE8ZJ";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--CGA------AT-GA------G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1290(name, align);
seqs.push_back(newSeq1290);
name = "GQY1XT001BDSVG";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1291(name, align);
seqs.push_back(newSeq1291);
name = "GQY1XT001BDGGT";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1292(name, align);
seqs.push_back(newSeq1292);
name = "GQY1XT001BDBLL";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-TCC--G-GCCCG------------ATT-GGG---------G-GCT-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1293(name, align);
seqs.push_back(newSeq1293);
name = "GQY1XT001BCIU5";
align = "C-G--T-T--GA-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-T-G-GC-GA-G-A-A-G-T-A--CG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1294(name, align);
seqs.push_back(newSeq1294);
name = "GQY1XT001BADJQ";
align = "A-C--T-C--GG-A-A-C-T-G-G--CG-T-G-C--T-A-G-A-G-T-G-T-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-GT-T---C----AA-G-----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1295(name, align);
seqs.push_back(newSeq1295);
name = "GQY1XT001B9ID3";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1296(name, align);
seqs.push_back(newSeq1296);
name = "GQY1XT001B948Z";
align = "A-T--T-G--GA-A-A-C-T-G-T--TG-A-T-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----GA-A-----G-C-C-G-T-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1297(name, align);
seqs.push_back(newSeq1297);
name = "GQY1XT001B92EF";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1298(name, align);
seqs.push_back(newSeq1298);
name = "GQY1XT001B91G9";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1299(name, align);
seqs.push_back(newSeq1299);
name = "GQY1XT001B8YZD";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-TCCG-G-G-G-G------------GAA-TGG---------C-C-C-C-T-G-G-GTG-C--CAC-A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1300(name, align);
seqs.push_back(newSeq1300);
name = "GQY1XT001B8ILX";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1301(name, align);
seqs.push_back(newSeq1301);
name = "GQY1XT001B7HR5";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1302(name, align);
seqs.push_back(newSeq1302);
name = "GQY1XT001B78LF";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATT-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1303(name, align);
seqs.push_back(newSeq1303);
name = "GQY1XT001B760U";
align = "A-T--T-T--GG-A-A-C-T-A-T--CA-A-G-C--T-A-G-A-G-T-A-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A-----------GG-AA--------T-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAC-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1304(name, align);
seqs.push_back(newSeq1304);
name = "GQY1XT001B5012";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-A-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1305(name, align);
seqs.push_back(newSeq1305);
name = "GQY1XT001B3JPS";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-T--T-------CTA-CGG-----G-A-C-T-G-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1306(name, align);
seqs.push_back(newSeq1306);
name = "GQY1XT001B2Z3X";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1307(name, align);
seqs.push_back(newSeq1307);
name = "GQY1XT001B2WW2";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-ACCGT-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1308(name, align);
seqs.push_back(newSeq1308);
name = "GQY1XT001B2ISN";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1309(name, align);
seqs.push_back(newSeq1309);
name = "GQY1XT001AZODE";
align = "T-T--T-T--GA-A-A-C-T-G-T--AG-G-G-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATTCC-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1310(name, align);
seqs.push_back(newSeq1310);
name = "GQY1XT001AZIY5";
align = "A-T--C-G--GA-A-A-C-C-G-G--GC-A-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-C--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--T-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1311(name, align);
seqs.push_back(newSeq1311);
name = "GQY1XT001AZ137";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-T-T-ACT--GACA-CTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CCG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G----T---C----GC-AA----G---A-C-T-T-C-G-G-T-G-C-C--GC--A-G-T-T-AA-C-G-C-A-T-TAA-G-TGC-TCC-GCC-T-G-GGG-AG-TA--CG-TA-C-G-C-A-AGTATGAA";
Sequence newSeq1312(name, align);
seqs.push_back(newSeq1312);
name = "GQY1XT001AZ0J0";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1313(name, align);
seqs.push_back(newSeq1313);
name = "GQY1XT001AXWM2";
align = "T-T--T-G--GG-A-A-C-T-G-T--TT-T-G-C--T-G-G-A-G-T-A-T-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-GT-T---C----AA-G-----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1314(name, align);
seqs.push_back(newSeq1314);
name = "GQY1XT001AXWKG";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-G-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-GT-A--CCGG-CG-CC-A-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1315(name, align);
seqs.push_back(newSeq1315);
name = "GQY1XT001AXFW6";
align = "T-T--T-T--GA-A-A-C-T-G-T--AG-G-G-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATTCC-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-GG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq1316(name, align);
seqs.push_back(newSeq1316);
name = "GQY1XT001AWGFR";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1317(name, align);
seqs.push_back(newSeq1317);
name = "GQY1XT001AVIEN";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1318(name, align);
seqs.push_back(newSeq1318);
name = "GQY1XT001ARHZE";
align = "A-C--T-G--AG-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-TA--TA-C-C-A-G-GT-G-T-C--G-G-G-C-A--T---C----AA-G-----G-A-T-G-G-C-C-G-G-T-G-C-C--GT--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-ACC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1319(name, align);
seqs.push_back(newSeq1319);
name = "GQY1XT001APWQ4";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C---G---G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1320(name, align);
seqs.push_back(newSeq1320);
name = "GQY1XT001AP3GC";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-AT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1321(name, align);
seqs.push_back(newSeq1321);
name = "GQY1XT001AOY82";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1322(name, align);
seqs.push_back(newSeq1322);
name = "GQY1XT001AOTBI";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--CACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1323(name, align);
seqs.push_back(newSeq1323);
name = "GQY1XT001ANPOD";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1324(name, align);
seqs.push_back(newSeq1324);
name = "GQY1XT001AN0O0";
align = "T-C--T-G--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-G-G-G--T---T----AA-C-----A-G-A-C-C-C-C-G-G-T-G-C-C--GA--A-G-C-C-AA-C-G-C-A-T-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1325(name, align);
seqs.push_back(newSeq1325);
name = "GQY1XT001AM04G";
align = "C-T--T-G--CG-A-A-C-T-G-G--CA-G-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AA-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-GTC--C-------GAC-AG------G-G-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1326(name, align);
seqs.push_back(newSeq1326);
name = "GQY1XT001AJDZP";
align = "C-G--T-T-GAA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1327(name, align);
seqs.push_back(newSeq1327);
name = "GQY1XT001AJBW8";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-GCG-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1328(name, align);
seqs.push_back(newSeq1328);
name = "GQY1XT001AJ8JE";
align = "A-C--T-C--GG-A-A-C-T-G-G--CG-T-G-C--T-A-G-A-G-T-G-T-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1329(name, align);
seqs.push_back(newSeq1329);
name = "GQY1XT001AHQ4E";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1330(name, align);
seqs.push_back(newSeq1330);
name = "GQY1XT001AGQKS";
align = "T-C--T-G--GA-A-A-C-T-G-C--CC-G-G-C--T-G-G-A-G-T-G-C-GG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-G-T--T---A----AC-A-----G-A-C-C-C-C-C-G-G-T-G-C-C--GA--A-G-C-C-AA-C-G-C-A-T-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1331(name, align);
seqs.push_back(newSeq1331);
name = "GQY1XT001AFW2U";
align = "A----T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--T-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1332(name, align);
seqs.push_back(newSeq1332);
name = "GQY1XT001AF3OR";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-G-T--T---C----AA-G-----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATAAA";
Sequence newSeq1333(name, align);
seqs.push_back(newSeq1333);
name = "GQY1XT001AEJCX";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAG-TTG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1334(name, align);
seqs.push_back(newSeq1334);
name = "GQY1XT001A9WRU";
align = "C-G--T-T--GA-A-A-C-T-G-G---G-G-C-C--T-T-G-A-G-T---G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1335(name, align);
seqs.push_back(newSeq1335);
name = "GQY1XT001A9CWO";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C----T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1336(name, align);
seqs.push_back(newSeq1336);
name = "GQY1XT001A90IT";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-C-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C----G-G-G-G--A---C----CG-AC----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1337(name, align);
seqs.push_back(newSeq1337);
name = "GQY1XT001A8LEY";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGC-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1338(name, align);
seqs.push_back(newSeq1338);
name = "GQY1XT001A6JJ4";
align = "T-T--T-T--GA-A-A-C-T-G-T--GT-T-G-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----A--AA----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1339(name, align);
seqs.push_back(newSeq1339);
name = "GQY1XT001A5ZJV";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C---G---G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1340(name, align);
seqs.push_back(newSeq1340);
name = "GQY1XT001A5X5F";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1341(name, align);
seqs.push_back(newSeq1341);
name = "GQY1XT001A4Y95";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-A-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1342(name, align);
seqs.push_back(newSeq1342);
name = "GQY1XT001A3TPF";
align = "A-T--T-T--GG-A-A-C-T-G-T--AA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GTGG-T-C--G-G-G-T-G--G---C----AA-A-----G-C-C-A-T-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1343(name, align);
seqs.push_back(newSeq1343);
name = "GQY1XT001A35IX";
align = "A-T--T-T--GA-A-A-C-T---G--TT-T-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1344(name, align);
seqs.push_back(newSeq1344);
name = "GQY1XT001A2MTB";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CCC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1345(name, align);
seqs.push_back(newSeq1345);
name = "GQY1XT001A103Z";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G---A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-ATGG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1346(name, align);
seqs.push_back(newSeq1346);
name = "GQY1XT001AH00T";
align = "T-T--T-T--GA-A-A-C-T-G-C--AG-A-G-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATT---C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TC-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G----------ACT-GA-CC-----C-C-A-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1347(name, align);
seqs.push_back(newSeq1347);
name = "GQY1XT001B2VYN";
align = "T-T--T-T--GA-A-A-C-T-G-T--GT-T-G-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1348(name, align);
seqs.push_back(newSeq1348);
name = "GQY1XT001C5VZB";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C-----A-GG----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1349(name, align);
seqs.push_back(newSeq1349);
name = "GQY1XT001C3CGW";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1350(name, align);
seqs.push_back(newSeq1350);
name = "GQY1XT001BX1WD";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1351(name, align);
seqs.push_back(newSeq1351);
name = "GQY1XT001ERPB8";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1352(name, align);
seqs.push_back(newSeq1352);
name = "GQY1XT001EK4QD";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1353(name, align);
seqs.push_back(newSeq1353);
name = "GQY1XT001E0JJ6";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1354(name, align);
seqs.push_back(newSeq1354);
name = "GQY1XT001DI6MT";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C----T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1355(name, align);
seqs.push_back(newSeq1355);
name = "GQY1XT001CTMYM";
align = "A-T--T-G--GG-A-A-C-T-G-G--CA-A-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-T-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1356(name, align);
seqs.push_back(newSeq1356);
name = "GQY1XT001CGMM4";
align = "G-T--T-C--AA-A-A-C-T-T-C--TT-G-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AGA-T--A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1357(name, align);
seqs.push_back(newSeq1357);
name = "GQY1XT001C8CYT";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1358(name, align);
seqs.push_back(newSeq1358);
name = "GQY1XT001C1TAA";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1359(name, align);
seqs.push_back(newSeq1359);
name = "GQY1XT001ARJ71";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1360(name, align);
seqs.push_back(newSeq1360);
name = "GQY1XT001ANOGE";
align = "C-G--T-T--GA-A-A-C-T---G--AC-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1361(name, align);
seqs.push_back(newSeq1361);
name = "GQY1XT001A1PQ5";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1362(name, align);
seqs.push_back(newSeq1362);
name = "GQY1XT001EWMVA";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GA------G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1363(name, align);
seqs.push_back(newSeq1363);
name = "GQY1XT001EU4WB";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1364(name, align);
seqs.push_back(newSeq1364);
name = "GQY1XT001ES0JB";
align = "C-G--T-T--GA-A-A-C-T-G-G---G-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--CGA------AT-GG------G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1365(name, align);
seqs.push_back(newSeq1365);
name = "GQY1XT001ENTCB";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-C-T-A-AT-T-G-T--G-T-G-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1366(name, align);
seqs.push_back(newSeq1366);
name = "GQY1XT001EN26C";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1367(name, align);
seqs.push_back(newSeq1367);
name = "GQY1XT001EK1FO";
align = "T-T--T-G--GA-A-A-C-T-G-T--GG-A-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-TC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1368(name, align);
seqs.push_back(newSeq1368);
name = "GQY1XT001ECKCE";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--C---C----CA-AG----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-T-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1369(name, align);
seqs.push_back(newSeq1369);
name = "GQY1XT001DWTG9";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--CGA------AT-GA------G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1370(name, align);
seqs.push_back(newSeq1370);
name = "GQY1XT001DG6NS";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1371(name, align);
seqs.push_back(newSeq1371);
name = "GQY1XT001DDPZU";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-AG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-AAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1372(name, align);
seqs.push_back(newSeq1372);
name = "GQY1XT001DBZNZ";
align = "A-T--C-A--GA-A-A-C-T-G-T--TG-A-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--T-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1373(name, align);
seqs.push_back(newSeq1373);
name = "GQY1XT001DA6U8";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1374(name, align);
seqs.push_back(newSeq1374);
name = "GQY1XT001CU13S";
align = "A----T-T--GA-A-A-C-T-G-T--TG-A-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1375(name, align);
seqs.push_back(newSeq1375);
name = "GQY1XT001COMF5";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1376(name, align);
seqs.push_back(newSeq1376);
name = "GQY1XT001CLMLV";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-T--CAA------AT-GA------G-A-T-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1377(name, align);
seqs.push_back(newSeq1377);
name = "GQY1XT001CK4OI";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1378(name, align);
seqs.push_back(newSeq1378);
name = "GQY1XT001CGNXV";
align = "T-T--T-G--GG-A-A-C-T-G-T--TT-T-G-C--T-G-G-A-G-T-A-T-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CA-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-C-A-G-GT-G-T-CG-G-G-T-G-T--C---G----AA-G-----G-A-C-G-G-C-C-G-G-T-G-C-C--GC--A-G-C-G-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1379(name, align);
seqs.push_back(newSeq1379);
name = "GQY1XT001CAUVT";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1380(name, align);
seqs.push_back(newSeq1380);
name = "GQY1XT001BRZLF";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1381(name, align);
seqs.push_back(newSeq1381);
name = "GQY1XT001BNGMO";
align = "T-C--T-G--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-G-G-G--T---T----AA-CA----G-A-C-C-C-C-C-G-G-T-G-C-C--GA--A-G-C-C-AA-C-G-C-A-T-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1382(name, align);
seqs.push_back(newSeq1382);
name = "GQY1XT001BLEL1";
align = "A-T--T-T--GA-A-A-C-T-G-T--AT-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----CCC-T-C-C-G---T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1383(name, align);
seqs.push_back(newSeq1383);
name = "GQY1XT001BI8Q8";
align = "C-C--T-T--GG-A-A-C-T-G-C--AT-G-G-C--T-G-G-A-G-T-G-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-CG-G-G-G-G-A--C---G----AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1384(name, align);
seqs.push_back(newSeq1384);
name = "GQY1XT001BGINZ";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-T--T-------CTA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1385(name, align);
seqs.push_back(newSeq1385);
name = "GQY1XT001BAFIL";
align = "C-T--T-G--CG-A-A-C-T-G-T--CA-G-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-A-A-ACT--GACG-CTG-A-GG--T-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G-T--C--------GA-AA------G-A-C-T-T-C-G-G-T-G-C-C--GC--A-G-T-T-AA-C-G-C-A-A-TAA-G-TGC-TCC-GCC-T-G-GGG-AG-TA--CG-CA-C-G-C-A-AGTGTGAA";
Sequence newSeq1386(name, align);
seqs.push_back(newSeq1386);
name = "GQY1XT001BADAL";
align = "T-T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GT--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1387(name, align);
seqs.push_back(newSeq1387);
name = "GQY1XT001B9YU3";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1388(name, align);
seqs.push_back(newSeq1388);
name = "GQY1XT001B9LVE";
align = "T-C--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-T-G-A-G-T-G-C-AG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--C---T----CA-C-----G-G-G-C-GCT-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1389(name, align);
seqs.push_back(newSeq1389);
name = "GQY1XT001B7LFF";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GA------G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1390(name, align);
seqs.push_back(newSeq1390);
name = "GQY1XT001AVZNJ";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-GT-T---C----AA-G-----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1391(name, align);
seqs.push_back(newSeq1391);
name = "GQY1XT001ALAP8";
align = "A-T--T-G--GA-A-A-C-T-G-T--TA-A-G-C--T-G-G-A-G-T-A-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-T-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-A-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1392(name, align);
seqs.push_back(newSeq1392);
name = "GQY1XT001AK5P4";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1393(name, align);
seqs.push_back(newSeq1393);
name = "GQY1XT001A44RE";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--T-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1394(name, align);
seqs.push_back(newSeq1394);
name = "GQY1XT001A41BE";
align = "T-T--T-T--GA-A-A-C-T-G-T--TG-A-A-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CA-G-G-G-A----G---C-----A-AA----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1395(name, align);
seqs.push_back(newSeq1395);
name = "GQY1XT001EYW01";
align = "T-C--T-T--GG-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-CG-G-G-G-C-A--C---G----AC-A-----G-T-G-C-T-T-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1396(name, align);
seqs.push_back(newSeq1396);
name = "GQY1XT001EY2DY";
align = "A-T--T-G--GA-A-A-C-T-G-T--CG-C-G-C--T-C-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1397(name, align);
seqs.push_back(newSeq1397);
name = "GQY1XT001EXARN";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--C---C----GA-C-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1398(name, align);
seqs.push_back(newSeq1398);
name = "GQY1XT001EX4SQ";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1399(name, align);
seqs.push_back(newSeq1399);
name = "GQY1XT001EWW6P";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1400(name, align);
seqs.push_back(newSeq1400);
name = "GQY1XT001EWMHC";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-T--T-------CTA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1401(name, align);
seqs.push_back(newSeq1401);
name = "GQY1XT001EVYE7";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AG-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1402(name, align);
seqs.push_back(newSeq1402);
name = "GQY1XT001EVK6W";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GTGG-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1403(name, align);
seqs.push_back(newSeq1403);
name = "GQY1XT001EVDLH";
align = "C-GT-T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CAGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1404(name, align);
seqs.push_back(newSeq1404);
name = "GQY1XT001EUNUL";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T--G-G-G-A-G--G---T----TT-CC----G-C-C-T-C-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1405(name, align);
seqs.push_back(newSeq1405);
name = "GQY1XT001EUAHK";
align = "T-T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1406(name, align);
seqs.push_back(newSeq1406);
name = "GQY1XT001ETWIV";
align = "A-T--T-T--GA-A-A-C-T-G-T--AG-T-T-C--T-TAG-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-C-G------------ATA-TAC---------G-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1407(name, align);
seqs.push_back(newSeq1407);
name = "GQY1XT001ETHDG";
align = "T-C--T-G--GA-A-A-C-T-A-T--GT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1408(name, align);
seqs.push_back(newSeq1408);
name = "GQY1XT001ET3LN";
align = "T-T--T-T--GA-A-A-C-T-G-T--TT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--A---C----AG-A-----G-T-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1409(name, align);
seqs.push_back(newSeq1409);
name = "GQY1XT001ET2GC";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1410(name, align);
seqs.push_back(newSeq1410);
name = "GQY1XT001ESW3T";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1411(name, align);
seqs.push_back(newSeq1411);
name = "GQY1XT001ES5NN";
align = "T-C--T-T--GG-A-A-C-C-G-C--AT-G-G-C--T-G-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-T-G--C---C----AA-A-----G-G-C-T-C-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1412(name, align);
seqs.push_back(newSeq1412);
name = "GQY1XT001EPGP5";
align = "A-T--T-G--GA-A-A-C-T-G-T--AA-A-T-C--T-T-G-A-G-T-G-C-CG-GA-G-A---GGT-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1413(name, align);
seqs.push_back(newSeq1413);
name = "GQY1XT001EPEVX";
align = "T-T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1414(name, align);
seqs.push_back(newSeq1414);
name = "GQY1XT001EO96Y";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-T-CG-GA---G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AC-A-----G---C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1415(name, align);
seqs.push_back(newSeq1415);
name = "GQY1XT001ENU0Z";
align = "T-T--T-T--GG-A-A-C-T-G-C--CC-A-G-C--T-A-G-A-G-T-A-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-A-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-A-G------C----GA-TA----G---C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1416(name, align);
seqs.push_back(newSeq1416);
name = "GQY1XT001EN3AH";
align = "T-T--T-G--GA-A-A-C-T-T-T--TT-T-G-C--T-G-G-A-G-T-A-C-CG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1417(name, align);
seqs.push_back(newSeq1417);
name = "GQY1XT001EM72G";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1418(name, align);
seqs.push_back(newSeq1418);
name = "GQY1XT001ELD3K";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-A-AC-C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1419(name, align);
seqs.push_back(newSeq1419);
name = "GQY1XT001ELBY4";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1420(name, align);
seqs.push_back(newSeq1420);
name = "GQY1XT001EL950";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1421(name, align);
seqs.push_back(newSeq1421);
name = "GQY1XT001EL0JX";
align = "C-T--C-T--GA-T-A-C-T-G-T--CG-G-G-C--T-A-G-A-G-T-T-T-AG-TT-G-C-G-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-TCCGGG-G-G-GA-----------ATG-GCC---------C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1422(name, align);
seqs.push_back(newSeq1422);
name = "GQY1XT001EK28K";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CG-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1423(name, align);
seqs.push_back(newSeq1423);
name = "GQY1XT001EJ1PO";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAGTTGG-----G-G-G-C-T-G-G-G-T-G-C-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1424(name, align);
seqs.push_back(newSeq1424);
name = "GQY1XT001EIXO1";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-A-C-A-ACGGTGAA";
Sequence newSeq1425(name, align);
seqs.push_back(newSeq1425);
name = "GQY1XT001EITFI";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-C-G------------ATA-TAC---------G-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1426(name, align);
seqs.push_back(newSeq1426);
name = "GQY1XT001EIQRA";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-GC-GG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-CG-G-G-G-C----A---C----AT-AA----G-T-G-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-C-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1427(name, align);
seqs.push_back(newSeq1427);
name = "GQY1XT001EI0LV";
align = "T-T--T-T--GG-A-A-C-T-G-C--GT-G-T-C--T-T-G-A-G-T-G-A-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C---A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AT-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-A-G-G---------TATT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1428(name, align);
seqs.push_back(newSeq1428);
name = "GQY1XT001EGXAQ";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1429(name, align);
seqs.push_back(newSeq1429);
name = "GQY1XT001EF612";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-T----T---C----AA-GA------A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1430(name, align);
seqs.push_back(newSeq1430);
name = "GQY1XT001EF5T3";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1431(name, align);
seqs.push_back(newSeq1431);
name = "GQY1XT001EDEJO";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1432(name, align);
seqs.push_back(newSeq1432);
name = "GQY1XT001EDD2Q";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1433(name, align);
seqs.push_back(newSeq1433);
name = "GQY1XT001EDCRZ";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCAG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1434(name, align);
seqs.push_back(newSeq1434);
name = "GQY1XT001ED2KQ";
align = "C-GT-T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-GTA-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-TGG-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1435(name, align);
seqs.push_back(newSeq1435);
name = "GQY1XT001ECP6K";
align = "A-T--T-T--GG-A-A-C-T-G-T--AT-A-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AT-G-----G-C-C-C-C-T-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1436(name, align);
seqs.push_back(newSeq1436);
name = "GQY1XT001ECKQ8";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1437(name, align);
seqs.push_back(newSeq1437);
name = "GQY1XT001EBZGK";
align = "A-T--T-T--GA-A-A-C-T---G--TT-T-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA--C-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1438(name, align);
seqs.push_back(newSeq1438);
name = "GQY1XT001EBMY4";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1439(name, align);
seqs.push_back(newSeq1439);
name = "GQY1XT001EBJEN";
align = "T-T--T-T--GA-A-A-C-T-G-T--GT-T-G-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CA-G-G-G-A----G---C-----A-AA----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1440(name, align);
seqs.push_back(newSeq1440);
name = "GQY1XT001EAR1W";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1441(name, align);
seqs.push_back(newSeq1441);
name = "GQY1XT001EAKA8";
align = "T-T--T-G--GG-A-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1442(name, align);
seqs.push_back(newSeq1442);
name = "GQY1XT001EAB4X";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1443(name, align);
seqs.push_back(newSeq1443);
name = "GQY1XT001E6HLG";
align = "ATT--T-T--GA-A-A-C-T-G-T--TG-G-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-G--AC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1444(name, align);
seqs.push_back(newSeq1444);
name = "GQY1XT001E5SDM";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACAGTGAA";
Sequence newSeq1445(name, align);
seqs.push_back(newSeq1445);
name = "GQY1XT001E5SA2";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--C---T----AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T---GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1446(name, align);
seqs.push_back(newSeq1446);
name = "GQY1XT001E46CM";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A--------GA-AT------G-ATCCC-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1447(name, align);
seqs.push_back(newSeq1447);
name = "GQY1XT001E20HL";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1448(name, align);
seqs.push_back(newSeq1448);
name = "GQY1XT001E1M0P";
align = "C-G----T--GA-A-A-C-T-G-G--CG-G---C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-C--C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1449(name, align);
seqs.push_back(newSeq1449);
name = "GQY1XT001E15F4";
align = "C-G--T-T--GA-A-A-C-T-G-A--C--G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1450(name, align);
seqs.push_back(newSeq1450);
name = "GQY1XT001E0UJM";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1451(name, align);
seqs.push_back(newSeq1451);
name = "GQY1XT001DZNGQ";
align = "T-T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1452(name, align);
seqs.push_back(newSeq1452);
name = "GQY1XT001DZEW1";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CA-G-G-G-G----G---C-----G-AA----G-C-C-C-T-T-T-G-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1453(name, align);
seqs.push_back(newSeq1453);
name = "GQY1XT001DZ8GV";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-T-A-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AG-A-TC-A-T-A-CA-G-A-AC-A-CC-GA-T-T-GC-GAA-GG-CAG-C-TT-A--CCAA-AC-TA-C-G-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AT--AA-C-T-G-G-TT-G-T-C--G-G-C-G------------ATA-AAA---------T-G-T-C-G-G-T-G-A-C--TA--A-G-C-G-AA-A-G-C-G-A-TAA-G-TTA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1454(name, align);
seqs.push_back(newSeq1454);
name = "GQY1XT001DZ0KY";
align = "C-G----T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1455(name, align);
seqs.push_back(newSeq1455);
name = "GQY1XT001DY0CK";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-A-A-C--T-A-G-A-G-T-G-C-GG-GA-G---G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--GT--C----AA-G-----G-C-T-C-T-G-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1456(name, align);
seqs.push_back(newSeq1456);
name = "GQY1XT001DWHYF";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1457(name, align);
seqs.push_back(newSeq1457);
name = "GQY1XT001DWDBA";
align = "C-G--T-T--GA-A-A-C-T-G----GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTAGA";
Sequence newSeq1458(name, align);
seqs.push_back(newSeq1458);
name = "GQY1XT001DVNA6";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AG-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-GG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1459(name, align);
seqs.push_back(newSeq1459);
name = "GQY1XT001DVCOB";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1460(name, align);
seqs.push_back(newSeq1460);
name = "GQY1XT001DV35L";
align = "T-T--T-T--GA-A-A-C-T-G-A--GT-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1461(name, align);
seqs.push_back(newSeq1461);
name = "GQY1XT001DUECS";
align = "TCT--G-G--GA-A-A-C-T-A-T--GT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AGCG-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1462(name, align);
seqs.push_back(newSeq1462);
name = "GQY1XT001DU444";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-A-----G-A-A-C-C-TCC-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1463(name, align);
seqs.push_back(newSeq1463);
name = "GQY1XT001DU3CY";
align = "A-T--T-T--GG-A-A-C-T-G-T--GC-T-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G--A---C----TG-A-----C-C-C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1464(name, align);
seqs.push_back(newSeq1464);
name = "GQY1XT001DSCKH";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---C---ATG-G-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1465(name, align);
seqs.push_back(newSeq1465);
name = "GQY1XT001DS64R";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1466(name, align);
seqs.push_back(newSeq1466);
name = "GQY1XT001DRX66";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TG-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-C--GG--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1467(name, align);
seqs.push_back(newSeq1467);
name = "GQY1XT001DRTLT";
align = "C-A--G-A--GA-A-A-C-C-G-T--AT-A-A-C--T-A-G-A-G-T-A-T-GG-TA-G-A-G-G-C-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-A-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A-----------GG-AA--------T-T-C-C-C-G-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-CAC-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1468(name, align);
seqs.push_back(newSeq1468);
name = "GQY1XT001DRDE3";
align = "A-T--T-G--GG-A-A-C-T-G-G--CG-C-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-A--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-G-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-C-C--C---C----AT-T-----G-G-G-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1469(name, align);
seqs.push_back(newSeq1469);
name = "GQY1XT001DR8SK";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--CGA------GT-GA------G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1470(name, align);
seqs.push_back(newSeq1470);
name = "GQY1XT001DQXNX";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-G-G-G--T---T----AACA-----G-A-C-C-C-C-C-G-G-T-G-C-C--GA--A-G-C-C-AA-C-G-C-A-T-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1471(name, align);
seqs.push_back(newSeq1471);
name = "GQY1XT001DQGHU";
align = "T-C--T-G--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G-AGGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TC-G-G-C-A-ACGGTGAA";
Sequence newSeq1472(name, align);
seqs.push_back(newSeq1472);
name = "GQY1XT001DPRCM";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1473(name, align);
seqs.push_back(newSeq1473);
name = "GQY1XT001DNTMI";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-T-A-ACT--GACA-CTG-A-GG--T-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G-T--C---G----CA-A-----G---A-C-T-T-C-G-G-T-G-C-C--GT--A-G-T-T-AA-C-G-C-A-T-TAA-G-TGC-TCC-GCC-T-G-GGG-AG-TA--CG-CA-C-G-C-A-AGTGTGAA";
Sequence newSeq1474(name, align);
seqs.push_back(newSeq1474);
name = "GQY1XT001DNKEL";
align = "T-C--T-G--GA-A-A-C-T-G-T--AG-A-G-C--T-G-G-A-G-T-G-C--G-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-C-G-G-T--A---C----GA-A-----G-T-A-C-T-G-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1475(name, align);
seqs.push_back(newSeq1475);
name = "GQY1XT001DMLLT";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-G-T--A---C----AG-A-----A-G-TAC-C-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1476(name, align);
seqs.push_back(newSeq1476);
name = "GQY1XT001DLWAK";
align = "C-G--T-T--GA-A-A-C-T-G-G--GGAG-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1477(name, align);
seqs.push_back(newSeq1477);
name = "GQY1XT001DL86Q";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1478(name, align);
seqs.push_back(newSeq1478);
name = "GQY1XT001DKH2H";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-G-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1479(name, align);
seqs.push_back(newSeq1479);
name = "GQY1XT001DJZXU";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1480(name, align);
seqs.push_back(newSeq1480);
name = "GQY1XT001DJTQD";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1481(name, align);
seqs.push_back(newSeq1481);
name = "GQY1XT001DJSTQ";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1482(name, align);
seqs.push_back(newSeq1482);
name = "GQY1XT001DJGVS";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TC-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1483(name, align);
seqs.push_back(newSeq1483);
name = "GQY1XT001DIT11";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1484(name, align);
seqs.push_back(newSeq1484);
name = "GQY1XT001DI0XA";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AG-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1485(name, align);
seqs.push_back(newSeq1485);
name = "GQY1XT001DHLN2";
align = "C-C--T-G--TG-A-A-C-T-G-G--GG-G-A-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-GA-A-A-ACT--GACG-CTG-A-GG--T-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G-C--C--------GC-AA------G-G-C-T-T-C-G-G-T-G-C-C--GG--A-G-T-T-AA-C-G-C-A-A-TAA-G-TGC-TCC-GCC-T-G-GGG-AG-TA--CG-CA-C-G-C-A-AGTGTGAA";
Sequence newSeq1486(name, align);
seqs.push_back(newSeq1486);
name = "GQY1XT001DGULU";
align = "C-C--T-G--CG-A-A-C-T-G-G--GA-T-G-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-A-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G--------CC-AAG-----GCC-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1487(name, align);
seqs.push_back(newSeq1487);
name = "GQY1XT001DFWED";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G---T--G-A-G-G-G--G---C----CA-A-----G-C-C-C-C-C-T-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1488(name, align);
seqs.push_back(newSeq1488);
name = "GQY1XT001DFKHN";
align = "C-G--T-T--G--A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-TGG--CGA------AT-GA------G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1489(name, align);
seqs.push_back(newSeq1489);
name = "GQY1XT001DF84J";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG--AA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1490(name, align);
seqs.push_back(newSeq1490);
name = "GQY1XT001DF1JP";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1491(name, align);
seqs.push_back(newSeq1491);
name = "GQY1XT001DDZ64";
align = "T-C--T-G--GA-A-A-C-T-G-C--GG-C-G-C--T-G-G-A-G-T-A-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AGA-G-C-G-TGGG-G-AGGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-CG-G-G-G-G-AC-G---G----AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1492(name, align);
seqs.push_back(newSeq1492);
name = "GQY1XT001DDYWL";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-G--AG-C-AG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1493(name, align);
seqs.push_back(newSeq1493);
name = "GQY1XT001DDUAP";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--C---T----AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1494(name, align);
seqs.push_back(newSeq1494);
name = "GQY1XT001DCOLP";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-G-G-GT-G-T-C--G-G-G-GCA--C---A----TA-AG----T-G-G-C-C---C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-C-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1495(name, align);
seqs.push_back(newSeq1495);
name = "GQY1XT001DCECZ";
align = "C-GT-T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------AT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1496(name, align);
seqs.push_back(newSeq1496);
name = "GQY1XT001DCDRA";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-TGCC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CGG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1497(name, align);
seqs.push_back(newSeq1497);
name = "GQY1XT001DC9ED";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-GAAA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1498(name, align);
seqs.push_back(newSeq1498);
name = "GQY1XT001DC57H";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------TT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CA-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1499(name, align);
seqs.push_back(newSeq1499);
name = "GQY1XT001DC2D4";
align = "C-G--T-T--GA-A-A-C-T-G-G---G-A-G-C--C-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1500(name, align);
seqs.push_back(newSeq1500);
name = "GQY1XT001DBXHE";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1501(name, align);
seqs.push_back(newSeq1501);
name = "GQY1XT001DBI9W";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1502(name, align);
seqs.push_back(newSeq1502);
name = "GQY1XT001DAGYA";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1503(name, align);
seqs.push_back(newSeq1503);
name = "GQY1XT001D99ZR";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-G-G-G-G-G--C--------TA-GA------G-C-C-CTT-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1504(name, align);
seqs.push_back(newSeq1504);
name = "GQY1XT001D91DA";
align = "CAT--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGCA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1505(name, align);
seqs.push_back(newSeq1505);
name = "GQY1XT001D8IRX";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GATA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGGTTGAA";
Sequence newSeq1506(name, align);
seqs.push_back(newSeq1506);
name = "GQY1XT001D8D82";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1507(name, align);
seqs.push_back(newSeq1507);
name = "GQY1XT001D71UW";
align = "A-T--T-T--GA-A-A-C-T-G-T--GT-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A----------GCA-AA-GC-----T-T-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1508(name, align);
seqs.push_back(newSeq1508);
name = "GQY1XT001D6ZO3";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--TAG-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--C-------TTC-GGC-----T-C---T-G-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1509(name, align);
seqs.push_back(newSeq1509);
name = "GQY1XT001D6G48";
align = "A-T--T-T--GA-A-A-C-T---G--TT-T-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1510(name, align);
seqs.push_back(newSeq1510);
name = "GQY1XT001D6CXP";
align = "C-G--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1511(name, align);
seqs.push_back(newSeq1511);
name = "GQY1XT001D6BVE";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1512(name, align);
seqs.push_back(newSeq1512);
name = "GQY1XT001D685S";
align = "C-GT-T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1513(name, align);
seqs.push_back(newSeq1513);
name = "GQY1XT001D65FP";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-AC-C---C----AA-G-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1514(name, align);
seqs.push_back(newSeq1514);
name = "GQY1XT001D5NPT";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-C-G-G-A--GT--C----AA-G-----G-C-T-C-T-G-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1515(name, align);
seqs.push_back(newSeq1515);
name = "GQY1XT001D4OGY";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1516(name, align);
seqs.push_back(newSeq1516);
name = "GQY1XT001D44LT";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1517(name, align);
seqs.push_back(newSeq1517);
name = "GQY1XT001D41V5";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1518(name, align);
seqs.push_back(newSeq1518);
name = "GQY1XT001D3GTN";
align = "T-T--T-G--GA-A-A-C-T-G-G--CG-G-A-C--T-A-G-A-G-T-G-C-GG-GA-G---G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1519(name, align);
seqs.push_back(newSeq1519);
name = "GQY1XT001D3FCE";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1520(name, align);
seqs.push_back(newSeq1520);
name = "GQY1XT001D35QL";
align = "A-T--T-T--GA-A-A-C-T-G-T---T-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTAG-AC-AG-C-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1521(name, align);
seqs.push_back(newSeq1521);
name = "GQY1XT001D2XVX";
align = "T-T--T-G--GG-A-A-C-T-G-T--TT-T-G-C--T-G-G-A-G-T-A-T-GG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CA-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-C-A-G-GT-G-T-C--G-G-G-T-G--T---CG---AA-G-----G-A-C-G-G-C-C-G-G-T-G-C-C--GC--A-G-C-G-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1522(name, align);
seqs.push_back(newSeq1522);
name = "GQY1XT001D29U4";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1523(name, align);
seqs.push_back(newSeq1523);
name = "GQY1XT001D20M4";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATT-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-T--T-------CTA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1524(name, align);
seqs.push_back(newSeq1524);
name = "GQY1XT001D1UIA";
align = "C-GT-T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1525(name, align);
seqs.push_back(newSeq1525);
name = "GQY1XT001D1RMM";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1526(name, align);
seqs.push_back(newSeq1526);
name = "GQY1XT001D190O";
align = "C-A--C-T--GA-T-A-C-T-G-T--TA-G-A-C--T-T-G-A-G-T-A-T-GG-AA-G-A-G-G-A-G--AA-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-T-TC-T--CTGG-GC-CA-A-G-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-T--A-G-T-A-G----------TTTCGA-TG-----C-T-A-C-T-A-G-T-G-C-C--GG--A-G-T-A-AA-C-A-C-A-A-TAA-G-TAT-CCC-GCC-T-G-GGG-AG-TA--CG-GT-C-G-C-A-AGACTGAA";
Sequence newSeq1527(name, align);
seqs.push_back(newSeq1527);
name = "GQY1XT001D1555";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-AGT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1528(name, align);
seqs.push_back(newSeq1528);
name = "GQY1XT001D0VK0";
align = "A-T--T-G--G--A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-C-T-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---CG---AC-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-GCC-T-G-GGGAGG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1529(name, align);
seqs.push_back(newSeq1529);
name = "GQY1XT001D0SW9";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G---GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--CGA------GT-GA------G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1530(name, align);
seqs.push_back(newSeq1530);
name = "GQY1XT001D0KKO";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1531(name, align);
seqs.push_back(newSeq1531);
name = "GQY1XT001D059N";
align = "A-G----T--GA-A-A-C-T-G-G--CT-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-C-G------------ATA-TAC---------A-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1532(name, align);
seqs.push_back(newSeq1532);
name = "GQY1XT001CZDP6";
align = "T-C--T-G--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1533(name, align);
seqs.push_back(newSeq1533);
name = "GQY1XT001CZD5D";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-CA-C-G-C-A-AGTGTGAA";
Sequence newSeq1534(name, align);
seqs.push_back(newSeq1534);
name = "GQY1XT001CZ6YY";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1535(name, align);
seqs.push_back(newSeq1535);
name = "GQY1XT001CYV83";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----CCC-T-C-C-G---T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1536(name, align);
seqs.push_back(newSeq1536);
name = "GQY1XT001CYM11";
align = "T-T--T-G--GA-A-A-C-T-T-T--TT-T-G-C--T-G-G-A-G-T-A-C-CG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-T--CTGG-AC-TG-A-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A--G--------GA-A-------T-T-C---C-C-G-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-CAC-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1537(name, align);
seqs.push_back(newSeq1537);
name = "GQY1XT001CXU0W";
align = "T-C--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-T-G-A-G-T-G-C-AG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-CG-G-G-G-C-C--C---T----AA-G-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1538(name, align);
seqs.push_back(newSeq1538);
name = "GQY1XT001CXAOY";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TC-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1539(name, align);
seqs.push_back(newSeq1539);
name = "GQY1XT001CX782";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-C-G-G-A--G---T----CA-AG----G-C-T-C-A-G-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1540(name, align);
seqs.push_back(newSeq1540);
name = "GQY1XT001CWR6V";
align = "G-T--T-T--GA-A-A-C-T-G-T--TC-T-T-C--T-T-G-A-G-T-G-A-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1541(name, align);
seqs.push_back(newSeq1541);
name = "GQY1XT001CWIZ7";
align = "G-T--T-C--AA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AA--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1542(name, align);
seqs.push_back(newSeq1542);
name = "GQY1XT001CW6Y0";
align = "T-C--T-T--GG-A-A-C-T-G-C--GC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-G-ACT--GACG-TTG-A-GG--C-C-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AG-A-----GAC-T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1543(name, align);
seqs.push_back(newSeq1543);
name = "GQY1XT001CVXRA";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1544(name, align);
seqs.push_back(newSeq1544);
name = "GQY1XT001CV6D0";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-CT-T-T-G-A-G-T-G-A-GC-GA-G-A-AGG-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1545(name, align);
seqs.push_back(newSeq1545);
name = "GQY1XT001CUJ97";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1546(name, align);
seqs.push_back(newSeq1546);
name = "GQY1XT001CUE16";
align = "T-T--T-T--GA-A-A-C-T-G-T--TG-A-A-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1547(name, align);
seqs.push_back(newSeq1547);
name = "GQY1XT001CU7PP";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1548(name, align);
seqs.push_back(newSeq1548);
name = "GQY1XT001CU6OX";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TG-A--CTGG-AC-GG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1549(name, align);
seqs.push_back(newSeq1549);
name = "GQY1XT001CSFEZ";
align = "T-T--T-G--GG-A-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1550(name, align);
seqs.push_back(newSeq1550);
name = "GQY1XT001CRSPD";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C----T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-------G-G-G-G-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1551(name, align);
seqs.push_back(newSeq1551);
name = "GQY1XT001CRPGT";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1552(name, align);
seqs.push_back(newSeq1552);
name = "GQY1XT001CRDDY";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-G-T--C-C-G---G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1553(name, align);
seqs.push_back(newSeq1553);
name = "GQY1XT001CPIDA";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-T-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-TGG-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-A-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1554(name, align);
seqs.push_back(newSeq1554);
name = "GQY1XT001COYQ7";
align = "A-T--T-G--GA-A-A-C-T-G-T--CG-G-A-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G---G-T--G---G----CA-AA----G-C-C-A-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1555(name, align);
seqs.push_back(newSeq1555);
name = "GQY1XT001COVAB";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--C---T----AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1556(name, align);
seqs.push_back(newSeq1556);
name = "GQY1XT001CO8VV";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-GTG-G------------ACAAAGTC--------C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1557(name, align);
seqs.push_back(newSeq1557);
name = "GQY1XT001CO0K0";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1558(name, align);
seqs.push_back(newSeq1558);
name = "GQY1XT001CNVA3";
align = "T-T--T-T--GA-A-A-C-T-G-T--AG-G-G-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATTCC-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TTC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq1559(name, align);
seqs.push_back(newSeq1559);
name = "GQY1XT001CNJGA";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G---G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GT--A-G-C-A-AA-C-G-C-A-G-TAACG-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1560(name, align);
seqs.push_back(newSeq1560);
name = "GQY1XT001CMX16";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C-----A-GG----G-C-C-C-C-C-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1561(name, align);
seqs.push_back(newSeq1561);
name = "GQY1XT001CMV43";
align = "T-T--T-T--GA-A-A-C-T-G-T--GT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-T-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-A-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1562(name, align);
seqs.push_back(newSeq1562);
name = "GQY1XT001CMRMZ";
align = "T-C--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---T----AA-A-----GAC-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1563(name, align);
seqs.push_back(newSeq1563);
name = "GQY1XT001CML6P";
align = "T-T--T-T--GA-A-A-C-T-G-A--GT-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1564(name, align);
seqs.push_back(newSeq1564);
name = "GQY1XT001CLRD6";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1565(name, align);
seqs.push_back(newSeq1565);
name = "GQY1XT001CKIUP";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1566(name, align);
seqs.push_back(newSeq1566);
name = "GQY1XT001CKACU";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G---G--G---C----AC-A-----G-C-C---C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1567(name, align);
seqs.push_back(newSeq1567);
name = "GQY1XT001CIO6Z";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1568(name, align);
seqs.push_back(newSeq1568);
name = "GQY1XT001CINOS";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-ACTG-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1569(name, align);
seqs.push_back(newSeq1569);
name = "GQY1XT001CIG4J";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1570(name, align);
seqs.push_back(newSeq1570);
name = "GQY1XT001CI3UJ";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T--------T-T-G--C-------GA--TAT-----A-C-G-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1571(name, align);
seqs.push_back(newSeq1571);
name = "GQY1XT001CHXQQ";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-A-----G-A-A-C-C-TCC-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1572(name, align);
seqs.push_back(newSeq1572);
name = "GQY1XT001CH8ZD";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-T-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AG-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1573(name, align);
seqs.push_back(newSeq1573);
name = "GQY1XT001CGZI2";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-T-G--C---C----AA-A-----G-G-C-T-C-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1574(name, align);
seqs.push_back(newSeq1574);
name = "GQY1XT001CGMGM";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1575(name, align);
seqs.push_back(newSeq1575);
name = "GQY1XT001CFTZL";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-G-G--G-------GAT-TGA-----C-C-C-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1576(name, align);
seqs.push_back(newSeq1576);
name = "GQY1XT001CEU3H";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-T-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AG-G-----G-C-C-C-C-C-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1577(name, align);
seqs.push_back(newSeq1577);
name = "GQY1XT001CES55";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1578(name, align);
seqs.push_back(newSeq1578);
name = "GQY1XT001CENGR";
align = "C-G----T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAA-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1579(name, align);
seqs.push_back(newSeq1579);
name = "GQY1XT001CEHFU";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--T-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---T----AA-AG----A-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1580(name, align);
seqs.push_back(newSeq1580);
name = "GQY1XT001CE091";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1581(name, align);
seqs.push_back(newSeq1581);
name = "GQY1XT001CDWT4";
align = "C-GT-T-T-GAA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1582(name, align);
seqs.push_back(newSeq1582);
name = "GQY1XT001CDMZ4";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1583(name, align);
seqs.push_back(newSeq1583);
name = "GQY1XT001CDA2V";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-GTCCGG-T-C-C-GA-----------ATG-AGG---------A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1584(name, align);
seqs.push_back(newSeq1584);
name = "GQY1XT001CCF82";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--CGA------AT-GA------G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1585(name, align);
seqs.push_back(newSeq1585);
name = "GQY1XT001CBCVJ";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T--G-G-G-A-G--G---T----TT-CC----G-C-C-T-C-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1586(name, align);
seqs.push_back(newSeq1586);
name = "GQY1XT001CAKVS";
align = "T-T--T-G--GG-A-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CA-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGCA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-T-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1587(name, align);
seqs.push_back(newSeq1587);
name = "GQY1XT001CA3UA";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1588(name, align);
seqs.push_back(newSeq1588);
name = "GQY1XT001C9V0H";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1589(name, align);
seqs.push_back(newSeq1589);
name = "GQY1XT001C8RQZ";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-CG-G-G-G-G----T---C----AT-AA----G-A-C-T-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1590(name, align);
seqs.push_back(newSeq1590);
name = "GQY1XT001C80S1";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1591(name, align);
seqs.push_back(newSeq1591);
name = "GQY1XT001C7PAI";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-----G-G--G-------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1592(name, align);
seqs.push_back(newSeq1592);
name = "GQY1XT001C61J8";
align = "C-G--T-T--GA-A-A-C-TGG-G--AG-C-C-T--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CGG-----G-A-C-T-G-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1593(name, align);
seqs.push_back(newSeq1593);
name = "GQY1XT001C5P4N";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-A-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-G--A-G-G-G-G--G---C----CA-A-----G-C-C-C-C-C-T-G-G-T-G-C-C--GA--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGGTTGAA";
Sequence newSeq1594(name, align);
seqs.push_back(newSeq1594);
name = "GQY1XT001C5MQ7";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C----T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-T-GG-A-ATG-C-G-T-G-GT-GT-A-G-TGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1595(name, align);
seqs.push_back(newSeq1595);
name = "GQY1XT001C4S0G";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--C--------TT-CG------G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1596(name, align);
seqs.push_back(newSeq1596);
name = "GQY1XT001C2WHP";
align = "T-T--T-G--G--A-A-C-T-G-T--TC-A-A-C--T-T-G-A-G-T-G-C-AG-AA-G-G-G-G-A-G--AG-T-GG-A-ATT-C-C-A-T-GT-GT-A-G-C-GT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-T--A-G-G-C-C--C---T----AT-CC----G-G-G-G-C-T-T-A-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1597(name, align);
seqs.push_back(newSeq1597);
name = "GQY1XT001C2KSO";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1598(name, align);
seqs.push_back(newSeq1598);
name = "GQY1XT001C23JD";
align = "C-GT-T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1599(name, align);
seqs.push_back(newSeq1599);
name = "GQY1XT001C1L1B";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G---T--G-G-G-G-G--G-------TCT-GAC-----C-C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1600(name, align);
seqs.push_back(newSeq1600);
name = "GQY1XT001C1CJH";
align = "T-T--T-T--GG-A-A-C-T-G-C--GT-G-T-C--T-T-G-A-G-T-G-A-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-C-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AT-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-A-G-G---------TATT-GA-CC-----C-C-T-T-C-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1601(name, align);
seqs.push_back(newSeq1601);
name = "GQY1XT001C1A4H";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-A-C-CG-GA-G-A-G-G-T-C--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1602(name, align);
seqs.push_back(newSeq1602);
name = "GQY1XT001C18EI";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-GAG-G-T--A--------TT-GA------C-C-C-CTT-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1603(name, align);
seqs.push_back(newSeq1603);
name = "GQY1XT001C0EIP";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1604(name, align);
seqs.push_back(newSeq1604);
name = "GQY1XT001C054B";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1605(name, align);
seqs.push_back(newSeq1605);
name = "GQY1XT001C02H7";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--T-T-CG-AAA-G-C-G-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-C--GG--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1606(name, align);
seqs.push_back(newSeq1606);
name = "GQY1XT001C01OE";
align = "A-T--T-T--GA-A-A-C-T-G-T--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1607(name, align);
seqs.push_back(newSeq1607);
name = "GQY1XT001BZL9H";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AG-A-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-A--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---C---ATG-G-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1608(name, align);
seqs.push_back(newSeq1608);
name = "GQY1XT001BYOHC";
align = "A-T--T-T--GA-A-A-C-T-G-T--TG-A-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1609(name, align);
seqs.push_back(newSeq1609);
name = "GQY1XT001BY7Q5";
align = "A-T--T-G--GG-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GACC------C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1610(name, align);
seqs.push_back(newSeq1610);
name = "GQY1XT001BY4XC";
align = "A-T--C-A--G--A-A-C-T-G-T--TG-A-A-C--T-T-G-A-G-T-G-C-AG--A-G-A-G-G-A-G--AG-T-GG-A-ACT---C-A-T-GT-GT-A-G-CGGC-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TC-C--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-GT-G-T-T--G-G-G-A-G--G---T----TT-CC----G-C-C-T-C-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1611(name, align);
seqs.push_back(newSeq1611);
name = "GQY1XT001BY2VC";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-ACGG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1612(name, align);
seqs.push_back(newSeq1612);
name = "GQY1XT001BWH5Q";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--CGA------GT-GA------G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1613(name, align);
seqs.push_back(newSeq1613);
name = "GQY1XT001BW5LP";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1614(name, align);
seqs.push_back(newSeq1614);
name = "GQY1XT001BW0GJ";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--TGCC-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1615(name, align);
seqs.push_back(newSeq1615);
name = "GQY1XT001BVJKI";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---C----AA--A----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1616(name, align);
seqs.push_back(newSeq1616);
name = "GQY1XT001BVJ8N";
align = "A-T--T-T--GA-A-A-C-T-G-T--TG-G-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GACC------C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1617(name, align);
seqs.push_back(newSeq1617);
name = "GQY1XT001BVATR";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1618(name, align);
seqs.push_back(newSeq1618);
name = "GQY1XT001BV86B";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C----T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATG-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1619(name, align);
seqs.push_back(newSeq1619);
name = "GQY1XT001BUYF3";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAGCC-TT-C--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1620(name, align);
seqs.push_back(newSeq1620);
name = "GQY1XT001BUUF4";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-G-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CA-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1621(name, align);
seqs.push_back(newSeq1621);
name = "GQY1XT001BTLTU";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATTCC-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1622(name, align);
seqs.push_back(newSeq1622);
name = "GQY1XT001BT9DZ";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1623(name, align);
seqs.push_back(newSeq1623);
name = "GQY1XT001BSGSM";
align = "T-T--T-T--GG-A-A-C-T-G-T--CA-G-G-C--T-G-G-A-G-T-G-C-AG-GA---G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-G-ACT--GACG-TTG-A-GG--C-C-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGG-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-T-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1624(name, align);
seqs.push_back(newSeq1624);
name = "GQY1XT001BRS3S";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1625(name, align);
seqs.push_back(newSeq1625);
name = "GQY1XT001BRN8Y";
align = "T-T--T-T--GA-A-A-C-T-G-C--AG-A-G-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TC-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------TCT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGCTGAA";
Sequence newSeq1626(name, align);
seqs.push_back(newSeq1626);
name = "GQY1XT001BRIHM";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-GCG-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1627(name, align);
seqs.push_back(newSeq1627);
name = "GQY1XT001BRBY0";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-C-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G----A---C----CG-AC----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1628(name, align);
seqs.push_back(newSeq1628);
name = "GQY1XT001BRB2B";
align = "T-T--T-T--GG-A-A-C-T-G-C--CC-A-G-C--T-A-G-A-G-T-A-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-A-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1629(name, align);
seqs.push_back(newSeq1629);
name = "GQY1XT001BR3TH";
align = "C-T--C-T--GA-T-A-C-T-G-T--CG-G-G-C--T-A-G-A-G-T-T-T-AG-TT-G-C-G-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-TCC--G-GCCCG------------ATT-GGG---------G-GCT-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1630(name, align);
seqs.push_back(newSeq1630);
name = "GQY1XT001BPB9Y";
align = "T-T--T-G--GA-A-A-C-T-G-C--CA-T-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-TCG--G-G-G-G-T--T---C----AA-G-----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1631(name, align);
seqs.push_back(newSeq1631);
name = "GQY1XT001BP0GH";
align = "A-T--T-T--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-CG-G-G-G-G----T---T----CA-AG----A-A-C-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1632(name, align);
seqs.push_back(newSeq1632);
name = "GQY1XT001BOZ60";
align = "T-C--T-G--GA-A-A-C-T-G-T--CC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----AA--A----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACCGT-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1633(name, align);
seqs.push_back(newSeq1633);
name = "GQY1XT001BOTKM";
align = "C-G----T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-A-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1634(name, align);
seqs.push_back(newSeq1634);
name = "GQY1XT001BOCH0";
align = "G-T--T-C--AA-A-A-C-T-G-T--TT-T-T-C--T-T-G-A-G-T-G-G-AG-TA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AA--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-T--AGC---AAACA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A----------CCG-AC-GG-----T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1635(name, align);
seqs.push_back(newSeq1635);
name = "GQY1XT001BO5AY";
align = "C-GT-T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-T--T-------CTA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1636(name, align);
seqs.push_back(newSeq1636);
name = "GQY1XT001BO26H";
align = "C-T--C-T--GA-T-A-C-T-G-T--CG-G-G-C--T-A-G-A-G-T-T-T-AG-TT-G-C-G-G-T-A--GG-C-GG-A-ATG-T-A-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AG-A-TC-A-T-A-CA-G-A-AC-A-CC-GA-T-T-GC-GAA-GG-CAG-C-TT-A--CCAA-AC-TA-C-G-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AT--AA-C-T-G-G-TT-G-T-C--G-G-C-G------------ATA-AAA---------T-G-T-C-G-G-T-G-A-C--TA--A-G-C-G-AA-A-G-C-G-A-TAA-G-TTA-TCC-ACC-T-G-GGG-GG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1637(name, align);
seqs.push_back(newSeq1637);
name = "GQY1XT001BO0VB";
align = "T-T--T-G--GA-A-A-C-T-G-T--AC-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-T-G--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AG-A-----GAC-T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1638(name, align);
seqs.push_back(newSeq1638);
name = "GQY1XT001BMANE";
align = "C-G--T-T--GA-A-A-C-G-G-G--AG---C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAA-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1639(name, align);
seqs.push_back(newSeq1639);
name = "GQY1XT001BJW91";
align = "C-G--T-T--GA-A-A-C-T-G-G---G-A-G-C--C-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1640(name, align);
seqs.push_back(newSeq1640);
name = "GQY1XT001BJ5VY";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1641(name, align);
seqs.push_back(newSeq1641);
name = "GQY1XT001BIQ0Y";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1642(name, align);
seqs.push_back(newSeq1642);
name = "GQY1XT001BI1VW";
align = "A----T-T--GA-A-A-C-T-G-T--GT-T-T-C--T-T-G-A-G-T-A-C-TG-GA-G-A-G-G-C-A--GA-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--G-G-G-G-G----------ACT-GA-CC-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1643(name, align);
seqs.push_back(newSeq1643);
name = "GQY1XT001BI0RV";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1644(name, align);
seqs.push_back(newSeq1644);
name = "GQY1XT001BHY85";
align = "A-T--T-T--GA-A-A-C-T---G--TT-C-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1645(name, align);
seqs.push_back(newSeq1645);
name = "GQY1XT001BHU11";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----TAGA-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1646(name, align);
seqs.push_back(newSeq1646);
name = "GQY1XT001BHQEM";
align = "T-C--T-G--GA-A-A-C-T-G-TA-AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----AC-A-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1647(name, align);
seqs.push_back(newSeq1647);
name = "GQY1XT001BHK64";
align = "C-G--T-T--GA-A-A-C-T-G-G---G-G-C-C--T-T-G-A-G-T-G---GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1648(name, align);
seqs.push_back(newSeq1648);
name = "GQY1XT001BH4GI";
align = "A-T--T-T--GA-A-A-C-T-G-T--AT-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1649(name, align);
seqs.push_back(newSeq1649);
name = "GQY1XT001BGQGA";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1650(name, align);
seqs.push_back(newSeq1650);
name = "GQY1XT001BG448";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1651(name, align);
seqs.push_back(newSeq1651);
name = "GQY1XT001BFPNU";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAAGG-CGG-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GTGG-T-C--CGGGG-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1652(name, align);
seqs.push_back(newSeq1652);
name = "GQY1XT001BEKGR";
align = "C-G--T-T-GAA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GTGG-T-C--C-G-G-G-G--G-------GAA-TGG-----C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1653(name, align);
seqs.push_back(newSeq1653);
name = "GQY1XT001BCOC6";
align = "A-T--C-G--GA-A-A-C-C-G-G--GC-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-C--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-GAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TG-T--CTGG-TC-TG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-TCG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-C--GG--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1654(name, align);
seqs.push_back(newSeq1654);
name = "GQY1XT001BC1WQ";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-GTT-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1655(name, align);
seqs.push_back(newSeq1655);
name = "GQY1XT001BB3UG";
align = "T-T--T-G--GG-A-A-C-T-G-T--AC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1656(name, align);
seqs.push_back(newSeq1656);
name = "GQY1XT001B8ZUW";
align = "A-T--T-T--GA-A-A-C-T-G-T--TG-G-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G-AGGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1657(name, align);
seqs.push_back(newSeq1657);
name = "GQY1XT001B899B";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTG-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGA-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1658(name, align);
seqs.push_back(newSeq1658);
name = "GQY1XT001B874Y";
align = "A-T--T-T--GA-A-A-C-T-G-T--AT-T-T-C--T-T-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AT-C-GG-A-ATT-C-C-G-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-C-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-G--CTGG-AC-AG-T-A-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T----G-G-G-G-G----------ACT-GA--C-----C-C-C-T-C-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGAATGAA";
Sequence newSeq1659(name, align);
seqs.push_back(newSeq1659);
name = "GQY1XT001B81VY";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--T-T-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-GT-G-T-T--G-G-A-G-G--G---T----TT-CC----G-C-C-C-T-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-CAT-TCC-GCC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1660(name, align);
seqs.push_back(newSeq1660);
name = "GQY1XT001B7U5I";
align = "A-T--T-G--GG-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-C-G----G---G----CA-AA----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1661(name, align);
seqs.push_back(newSeq1661);
name = "GQY1XT001B7CX2";
align = "A-T--T-T--GA-A-A-C-T-G-T--TG-G-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-T-CT-G--CTGG-AC-AG-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1662(name, align);
seqs.push_back(newSeq1662);
name = "GQY1XT001B6Y9C";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AA-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1663(name, align);
seqs.push_back(newSeq1663);
name = "GQY1XT001B6PJY";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTT-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TA-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1664(name, align);
seqs.push_back(newSeq1664);
name = "GQY1XT001B5Y52";
align = "T-C--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-GTG-G-G--T-------ATG-GA------C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1665(name, align);
seqs.push_back(newSeq1665);
name = "GQY1XT001B5VPJ";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1666(name, align);
seqs.push_back(newSeq1666);
name = "GQY1XT001B5S1X";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-C--C---CT---AA-G-----G-G-G-C-T-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1667(name, align);
seqs.push_back(newSeq1667);
name = "GQY1XT001B5GOX";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1668(name, align);
seqs.push_back(newSeq1668);
name = "GQY1XT001B4XAQ";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-T-G-C--T-G-G-A-G-T-G-C-CG-GA---G-G-G---C--AG-G-CG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G---G-G--G---C----AG-G-----G-C-C-C-C-C-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1669(name, align);
seqs.push_back(newSeq1669);
name = "GQY1XT001B4D1T";
align = "C-G--T-T--GA-A-A-C-T-G-A--TT-G-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1670(name, align);
seqs.push_back(newSeq1670);
name = "GQY1XT001B4056";
align = "A-T--T-G--GA-A-A-C-T-G-T--CG-C-G-C--T-C-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-A-AAA--TG-C-GT-AG--AT-A-TT-A-G-A-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-G--CTGG-GC-CA-A-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-GT-G-T-C------G-G-G--A--------A--A-----------C-----C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq1671(name, align);
seqs.push_back(newSeq1671);
name = "GQY1XT001B3J69";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TT-A--CCAA-AC-TA-C-G-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAG-TGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1672(name, align);
seqs.push_back(newSeq1672);
name = "GQY1XT001B2Z07";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-GTCCGG-T-C-C-G-----------ATTG-GGG---------A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1673(name, align);
seqs.push_back(newSeq1673);
name = "GQY1XT001B2UVD";
align = "C-G----T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1674(name, align);
seqs.push_back(newSeq1674);
name = "GQY1XT001B264Y";
align = "A-T--T-G--GG-A-A-C-T-G-C--CC-T-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1675(name, align);
seqs.push_back(newSeq1675);
name = "GQY1XT001B0B7S";
align = "A-T--T-G--GA-A-A-C-T-G-T--CG-G-A-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-C-G-G--G---C----AA-A-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1676(name, align);
seqs.push_back(newSeq1676);
name = "GQY1XT001B02KN";
align = "A-T--T-G--GA-A-A-C-T-G-C--CA-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G---G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-C-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C-----A-GG----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1677(name, align);
seqs.push_back(newSeq1677);
name = "GQY1XT001AZEJX";
align = "T-T--T-T--GG-A-A-C-T-G-T--CA-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----TA-GA----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1678(name, align);
seqs.push_back(newSeq1678);
name = "GQY1XT001AZ91Q";
align = "T-T--T-G--GA-A-A-C-T-G-T--TA-A-G-C--T-A-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1679(name, align);
seqs.push_back(newSeq1679);
name = "GQY1XT001AXWID";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1680(name, align);
seqs.push_back(newSeq1680);
name = "GQY1XT001AW4XW";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-CT-T-G-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-GA--TG-C-C-A-G-CT-G-T-C--C-G-G-G-C--C-------GAA-TGG-----G-G-C-C-T-G-G-G-T-G-G-C--AA--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-CCC-ACC-T-G-GGG-AG-TA--CG-TC-G-G-C-A-ACGGTGAA";
Sequence newSeq1681(name, align);
seqs.push_back(newSeq1681);
name = "GQY1XT001AV5RM";
align = "T-T--T-G--GA-A-A-C-T-G-C--GA-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1682(name, align);
seqs.push_back(newSeq1682);
name = "GQY1XT001AUZKM";
align = "C-G--T-T--GA-A-A-C-T-G-G---C-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1683(name, align);
seqs.push_back(newSeq1683);
name = "GQY1XT001AUA36";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CT-TC-C-T-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1684(name, align);
seqs.push_back(newSeq1684);
name = "GQY1XT001AU7GQ";
align = "T-T--T-G--GA-A-A-C-T-G-C--GA-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----TAGA-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1685(name, align);
seqs.push_back(newSeq1685);
name = "GQY1XT001AU0ZO";
align = "A-T--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-GCAAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1686(name, align);
seqs.push_back(newSeq1686);
name = "GQY1XT001AU0YX";
align = "A-C--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GC-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GGA-GG-CGG-C-TT-A--CTGG-AC-GG-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-C-G-G--G---C----AG-G-----G-C-C-C-G-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1687(name, align);
seqs.push_back(newSeq1687);
name = "GQY1XT001ATICR";
align = "T-C--T-G--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-A-C-TG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G---G-A--G---C----AA-A-----G-C-T---T-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-CAT-TCC-ACC-T---GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1688(name, align);
seqs.push_back(newSeq1688);
name = "GQY1XT001ATCH2";
align = "T-C--T-G--GA-A-A-C-T-G-T--AA-A-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-CGG-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G---G-G--G---T----AA-G-----G-C-C-C-C-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GAG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1689(name, align);
seqs.push_back(newSeq1689);
name = "GQY1XT001AT098";
align = "C-G--T-T--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1690(name, align);
seqs.push_back(newSeq1690);
name = "GQY1XT001ASHNW";
align = "C-G--T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G---T--C-C-G-G-G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1691(name, align);
seqs.push_back(newSeq1691);
name = "GQY1XT001AQAE2";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----TA-GA----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1692(name, align);
seqs.push_back(newSeq1692);
name = "GQY1XT001APT2N";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1693(name, align);
seqs.push_back(newSeq1693);
name = "GQY1XT001APR6R";
align = "A-T--T-T--GA-A-A-C-G-T-G--CC-AGG-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-AACC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-C-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-T-GG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--C---C----GA-C-----G-G-T-C-T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1694(name, align);
seqs.push_back(newSeq1694);
name = "GQY1XT001APLM5";
align = "G-T--T-T--GA-A-A-C-T-G-T--GA-G-G-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-T-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-G-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-A--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G----------ACT-GA-CC-----C-C-A-T-C-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1695(name, align);
seqs.push_back(newSeq1695);
name = "GQY1XT001AP3ZY";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-T-C--CGA------AT-GA------G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1696(name, align);
seqs.push_back(newSeq1696);
name = "GQY1XT001AOT7K";
align = "T-T--T-T--GA-A-A-C-T-G-T--TG-A-A-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-TAA-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGGAGG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1697(name, align);
seqs.push_back(newSeq1697);
name = "GQY1XT001AOB8V";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-TCGG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C----TAGA-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1698(name, align);
seqs.push_back(newSeq1698);
name = "GQY1XT001AO39T";
align = "C-G--T-T--GA-A-A-C-T-A-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--CGA------TT-GG------G-G-G-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1699(name, align);
seqs.push_back(newSeq1699);
name = "GQY1XT001ANM2O";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A--------GA-AT------G-ATCCC-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1700(name, align);
seqs.push_back(newSeq1700);
name = "GQY1XT001ANEPB";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1701(name, align);
seqs.push_back(newSeq1701);
name = "GQY1XT001AN52Q";
align = "T-T--T-G--GA-A-A-C-T-G-C--CG-G-G-C--T-A-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-A-ACT--GACG-TTG-A-GG--C-T-CG-AAG-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---CT---AG-A-----G-C-C-C-T-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C--AAGGTTGAA";
Sequence newSeq1702(name, align);
seqs.push_back(newSeq1702);
name = "GQY1XT001AMT3B";
align = "C-A--T-T-GAA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C---T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-G--CCGG-CT-TC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--CG-C-T-A-G-GT-G-T-C--CGGGG-G-G--A--------AT-GG------C-C-C-C-T-G-G-G-T-G-C-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CGC-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1703(name, align);
seqs.push_back(newSeq1703);
name = "GQY1XT001AMFIX";
align = "A-C--T-G--AG-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-CG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GG-C-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-C-A-G-GT-G-T-C--G-G-G-G-G--A---C---ATA-A-----G-T-T-T-C-C-C-G-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-C-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1704(name, align);
seqs.push_back(newSeq1704);
name = "GQY1XT001ALORM";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--C-------GAGTGGA-----G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1705(name, align);
seqs.push_back(newSeq1705);
name = "GQY1XT001ALJR9";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C--------TA-CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1706(name, align);
seqs.push_back(newSeq1706);
name = "GQY1XT001AL7YW";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-C-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1707(name, align);
seqs.push_back(newSeq1707);
name = "GQY1XT001AKDWB";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-C-C--T-T-G-A-G-T-G-C-GC-GA-G-A-A-G-T-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C---G----AT-TG----G-G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1708(name, align);
seqs.push_back(newSeq1708);
name = "GQY1XT001AJW7Z";
align = "C-G--T-T--GA-A-A-C-T-G-G--GG-G-C-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-A-A--GG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-C-CC-GA-T-T-GC-GAA-GG-CAG-C-CT-T--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-T-G-CGGG-G--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CG-C-A-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1709(name, align);
seqs.push_back(newSeq1709);
name = "GQY1XT001AJMTR";
align = "T-T--T-G--GA-A-A-C-T-G-C--GA-G-G-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AG--TG-C-T-A-G-GT-G-T-C--G-G-G-G----G---C----AA-A-----G-C-C-C-C-T-C-G-G-T-G-C-C--GC--C-G-C-T-AA-C-G-C-A-A-TAA-G-CAC-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C--AAGAATGAA";
Sequence newSeq1710(name, align);
seqs.push_back(newSeq1710);
name = "GQY1XT001AJCQ5";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1711(name, align);
seqs.push_back(newSeq1711);
name = "GQY1XT001AJ4TJ";
align = "T-T--T-G--GA-A-A-CTT-T-T--TT-T-G-C--T-G-G-A-G-T-A-C-CG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--A---C----AA-A-----G-T-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-C-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1712(name, align);
seqs.push_back(newSeq1712);
name = "GQY1XT001AI9J5";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CG-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-G-C--C-------GAT-TGA-----G-G-C-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1713(name, align);
seqs.push_back(newSeq1713);
name = "GQY1XT001AGTZA";
align = "A-T--T-G--GA-A-A-C-T-G-G--GA-G-A-C--T-T-G-A-G-T-G-C-AG-AA-G-A-G-G-A-G--AG-T-GG-A-ACT-C-C-A-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-T-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-AG-CGG-C-TC-T--CTGG-TC-TG-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-A-TGGG-T--AGC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-T-G-CCG-T-AAAC-G-A-TG-AG--TG-C-T-A-A-GT-G-T-T--G-G-G-A-G--G---T----TT-CC----G-C-C-T-C-T-C-A-G-T-G-C-T--GC--A-G-C-T-AA-C-G-C-A-T-TAA-G-CAC-TCC-GCC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1714(name, align);
seqs.push_back(newSeq1714);
name = "GQY1XT001AFNJT";
align = "T-T--T-T--GA-A-A-C-T-G-T--GT-T-G-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----A--AA----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1715(name, align);
seqs.push_back(newSeq1715);
name = "GQY1XT001AFCLT";
align = "T-T--T-T--GA-A-A-C-T-G-A--GT-A-G-C--T-A-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-GG----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1716(name, align);
seqs.push_back(newSeq1716);
name = "GQY1XT001A9Q52";
align = "T-T--T-T--GA-A-A-C-T-G-T--AT-G-A-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----A--AA----G-C-T-T-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1717(name, align);
seqs.push_back(newSeq1717);
name = "GQY1XT001A9KYL";
align = "T-C--T-G--GG-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-C-CG-GA---G-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-G--G---C----AG-G-----G-C-C-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1718(name, align);
seqs.push_back(newSeq1718);
name = "GQY1XT001A9094";
align = "T-C--T-G--GA-A-A-C-T-G-C--GG-C-G-C--T-G-G-A-G-T-A-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AGA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-C--G-G-G-G-A--C---G----AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1719(name, align);
seqs.push_back(newSeq1719);
name = "GQY1XT001A8IDN";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-C-A-G-GT-G-T-CG-G-T-G-G----G---T----AT-GG----A-C-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1720(name, align);
seqs.push_back(newSeq1720);
name = "GQY1XT001A8AXM";
align = "C----T-T--GA-A-A-C-T-G-G---T-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-ATAAG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TGT-TCC-ACC-T-G-GGGAGG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1721(name, align);
seqs.push_back(newSeq1721);
name = "GQY1XT001A7E5Q";
align = "T-T--T-T--GA-A-A-C-T-G-C--CG-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--GC--C----AA-G-----G-C-C-C-T-C-C-G-G-T-G-C-C--GG--C-G-C-A-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1722(name, align);
seqs.push_back(newSeq1722);
name = "GQY1XT001A6E93";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-A-G-C--T-C-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-T-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1723(name, align);
seqs.push_back(newSeq1723);
name = "GQY1XT001A6BRC";
align = "G-C--C-C--CG-A-A-C-T-G-T--GA-G-T-C--T-C-G-A-G-T-G-T-GG-TA-G-G-G-G-A-A--GG-C-GG-A-ATT-C-C-C-G-GT-GT-A-G-CGGT-G-GAA--TG-C-GC-AG--AT-A-TC-G-G-G-AA-G-A-AC-A-CC-GA-T-G-GC-GAA-GG-CAG-C-CT-T--CTGG-GC-CA-T-C-ACT--GACG-CTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-TA-GG-ATTAG-ATA-CCCT-AGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-GT-G-T------C-G-G-G-----------A---A------------A-C-C-G-G-T-G-C-T--GA--A-G-T-T-AA-C-A-C-A-T-TAA-G-TAT-TCC-ACC-T-G-AGT-AG-TA--CG-GT-C-G-C-A-AGGCTGAA";
Sequence newSeq1724(name, align);
seqs.push_back(newSeq1724);
name = "GQY1XT001A5J2H";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AG--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----TA-C-----G-G-A-CGC-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1725(name, align);
seqs.push_back(newSeq1725);
name = "GQY1XT001A59OZ";
align = "T-C--T-G--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-A-C-TG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-GT-CG-A-T-ACT--GACA-TTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCC-T-AAAC-G-A-TG-AG--TA-C-T-A-A-GT-G-T-T--G-G-T-G-A--G---------A-A---------T-C-A-------G-T-G-C-T--GA--A-G-T-T-AA-C-G-C-A-T-TAA-G-TAC-TCC-GCC-T-G-AGT-AG-TA--CG-TA-C-G-C-A-AGTATGAA";
Sequence newSeq1726(name, align);
seqs.push_back(newSeq1726);
name = "GQY1XT001A4Q0L";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-A-G-C--T-T-G-A-T-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-AAT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--A-G-G-G-A--G---C----AA-A-----G-C-T-C-T-T-T-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1727(name, align);
seqs.push_back(newSeq1727);
name = "GQY1XT001A3WVS";
align = "T-T--T-T--GG-A-A-C-T-G-C--CC-A-G-C--T-A-G-A-G-T-A-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-A-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-T--G-G-G-A-G--C---G----AT-A-----G-C-C---T-C-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1728(name, align);
seqs.push_back(newSeq1728);
name = "GQY1XT001A3WQR";
align = "A-G--T-T--GA-A-A-C-T-G-G--CA-G-T-C--T-T-G-A-G-T-A-C-AG-TA-G-A-G-G-T-G--GG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-C-G------------ATA-TAC---------A-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGGG";
Sequence newSeq1729(name, align);
seqs.push_back(newSeq1729);
name = "GQY1XT001A3TQ3";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGA-----G-G-G-T-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1730(name, align);
seqs.push_back(newSeq1730);
name = "GQY1XT001A2QK9";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--CA-C-T-A-A-CT-G-T-C--C-G-G-C-C--C-------GAT-TGG-----G-G-G-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1731(name, align);
seqs.push_back(newSeq1731);
name = "GQY1XT001A1SOP";
align = "CAT--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1732(name, align);
seqs.push_back(newSeq1732);
name = "GQY1XT001A1ONR";
align = "T-T--T-T--GA-A-A-C-T-G-T--TG-A-A-C--T-A-G-A-T-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---T----CA-A-----G-A-A-C-C-TCC-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TGA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1733(name, align);
seqs.push_back(newSeq1733);
name = "GQY1XT001A1A4Q";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AG-A-TC-A-T-A-CA-G-A-AC-A-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CT-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-T-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-T--C-G-G-G-G--A-------GAA-TGA-----T-C-C-C-T-G-A-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1734(name, align);
seqs.push_back(newSeq1734);
name = "GQY1XT001A12RU";
align = "T-T--T-G--GA-A-A-C-T-G-T--GC-T-G-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--G---C---AGA-G-----G-C-C-C-T-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGTTGAA";
Sequence newSeq1735(name, align);
seqs.push_back(newSeq1735);
name = "GQY1XT001EVHT3";
align = "A-T--T-T--GA-A-A-C-T-G-T--TG-G-T-C--T-T-G-A-G-T-A-T-CG-GA-G-A-G-G-C-A--GG-C-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-GA-C-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GC--A-G-C-T-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1736(name, align);
seqs.push_back(newSeq1736);
name = "GQY1XT001BC1OQ";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-G-C-C--T-C-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-G-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-TT-G-T-G--T-G-C-C-C--CGA------GT-GA------G-G-G-G-T-G-C-G-T-G-A-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1737(name, align);
seqs.push_back(newSeq1737);
name = "GQY1XT001CV3PG";
align = "C-G--T-T--GA-A-A-C-T-G-G--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G-T-T--C-------TA--CG------G-G-A-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1738(name, align);
seqs.push_back(newSeq1738);
name = "GQY1XT001CKP7A";
align = "C-G--T-T--GA-A-A-C-T-G-G--TT-T-T-C--T-T-G-A-G-T-G-A-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-GG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-A-CT-G-T-C--C-G-G-T-G--C-------GAG-TGA-----G-C-G-C-T-G-G-G-C-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1739(name, align);
seqs.push_back(newSeq1739);
name = "GQY1XT001A4XF1";
align = "C-G--T-T--GA-A-A-C-T-G-G--TG-T-C-C--T-A-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-A-ACT--GACG-CTC-A-TG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TA-C-T-A-A-CT-G-T-C--C-G-G-T-C--C-------GAT-TGG-----G-G-A-C-T-G-G-G-T-G-G-T--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1740(name, align);
seqs.push_back(newSeq1740);
name = "GQY1XT001CBEPN";
align = "C-G--T-T--GA-A-A-C-T-G-A--CG-T-T-C--T-T-G-A-G-T-G-G-GC-GA-G-A-A-G-T-A--TG-C-GG-A-ATG-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-AT-AG--AT-A-TC-A-C-G-CA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-AT-A--CCGG-CG-CC-C-T-ACT--GACG-CTG-A-AG--C-A-CG-AAA-G-C-G-TGGG-T--ATC-G-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CAG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-CT-G-T-C--C-G-G---G----------GCT-TCG-----G-C-T-C-T-G-G-G-T-G-G-C--AC--A-G-C-G-AA-A-G-C-G-T-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1741(name, align);
seqs.push_back(newSeq1741);
name = "GQY1XT001CVFWB";
align = "T-C--T-G--GA-A-A-C-T-G-C--GT-C-G-C--T-G-G-A-G-T-A-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-CG-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AGA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TG-C-T-A-G-GT-G-T-C--G-G-G-G-G--A---CG---AC-A-----G-T-G-C-C-C-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1742(name, align);
seqs.push_back(newSeq1742);
name = "GQY1XT001CA4CP";
align = "A-T--T-G--GA-A-A-C-T-G-T--AT-A-T-C--T-A-G-A-G-T-G-T-CG-GA-G-A-G-G-C-A--AG-T-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-G--CTGG-AC-GA-T-G-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AC--TA-C-T-A-G-GT-G-T-C--G-G-G-A-G--G---C----AA-A-----G-C-C-T-T-T-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-A-TAA-G-TAG-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1743(name, align);
seqs.push_back(newSeq1743);
name = "GQY1XT001BYO88";
align = "T-C--T-T--GG-A-A-C-T-G-C--GC-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-G-ACT--GACG-TTG-A-GG--C-C-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C----AG-A-----G-A-C-TGC-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1744(name, align);
seqs.push_back(newSeq1744);
name = "GQY1XT001BQZ93";
align = "T-C--T-G--GA-A-A-C-T-G-C--GT-C-G-C--T-G-G-A-G-T-A-C-GG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-G-G-A--G---C----AA-A-----G-C-T-T-C-T-C-G-G-T-G-C-C--GC--C-G-C-A-AA-C-G-C-A-A-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1745(name, align);
seqs.push_back(newSeq1745);
name = "GQY1XT001BJD55";
align = "T-T--T-G--GA-A-A-C-T-G-T--GT-A-A-C--T-G-G-A-G-T-G-C-TG-GA-G-A-G-G-T-A--AG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AG-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-C-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-AG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CGG-T-AAAC-G-A-TG-AA--TG-C-T-A-G-GT-G-T-T--G-G-T-G-G--G---C----AG-A-----G-C-C-C-A-T-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-CAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1746(name, align);
seqs.push_back(newSeq1746);
name = "GQY1XT001B5TIJ";
align = "A-A--C-T--AA-A-A-C-T-G-A--AT-T-T-C--T-T-G-A-G-T-G-C-GG-GA-G-A-G-G-A-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGA-C-TT-T--CTGG-AC-CG-T-A-ACT--GACG-TTG-A-GG--C-A-CG-AAA-G-T-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CTG-T-AAAC-G-A-TG-GA--TA-C-T-A-G-GT-G-T-A--G-G-G-A-A--T-------ATT-AA------G-T-T-T-T-C-T-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-A-TAA-G-TAT-CCC-ACC-T-G-GGG-AG-TA--CG-AC-C-G-C-A-AGGTTGAA";
Sequence newSeq1747(name, align);
seqs.push_back(newSeq1747);
name = "GQY1XT001AVQRK";
align = "T-T--T-G--GA-A-A-C-T-G-T--AT-G-A-C--T-G-G-A-G-T-G-C-AG-GA-G-A-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-TG-T-A-ACT--GACG-TTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--CA-C-T-A-G-GT-G-T-C--G-G-T-G-G--G---T----AT-G-----GAC-C-C-A-T-C-G-G-T-G-C-C--GC--A-G-C-A-AA-C-G-C-A-G-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1748(name, align);
seqs.push_back(newSeq1748);
name = "GQY1XT001AV8ZM";
align = "A-T--T-T--GA-A-A-C-T---G--TT-T-C-C--T-T-G-A-G-T-G-T-CG-GA-G-A-G-G-T-A--AT-C-GG-A-ATT-C-C-T-T-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TA-A-G-G-AA-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-A-TT-A--CTGG-AC-GA-T-A-ACT--GACG-GTG-A-GG--C-G-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CTG-T-AAAC-G-A-TC-GA--TA-C-T-A-G-GT-G-T-G--C-G-G-G-G----------ACT-GA-CC-----C-C-C-T-G-C-G-T-G-C-C--GG--A-G-T-T-AA-C-A-C-A-A-TAA-G-TAT-CGC-ACC-T-G-GGG-AG-TA--CG-AT-C-G-C-A-AGGTTGAA";
Sequence newSeq1749(name, align);
seqs.push_back(newSeq1749);
name = "GQY1XT001EROXS";
align = "T-T--T-T--GG-A-A-C-T-G-T--CA-G-G-C--T-G-G-A-G-T-G-C-AG-GA-G-G-G-G-C-A--GG-C-GG-A-ATT-C-C-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TC-A-G-G-AG-G-A-AC-A-CC-GG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-AC-TG-C-G-ACT--GACG-TTG-A-GG--C-C-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-C--G-G-G-G-A--G---C---AGA-G-----A-C-T-G-C-C-C-G-G-T-G-C-C--GC--A-G-C-C-AA-C-G-C-A-T-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-TC-C-G-C-A-AGGATGAA";
Sequence newSeq1750(name, align);
seqs.push_back(newSeq1750);
name = "GQY1XT001EJWHQ";
align = "C-A--T-T--GA-A-A-C-T-G-G--CG-A-T-C--T-T-G-A-G-T-G-G-AA-GA-G-A-A-G-T-A--TG-C-GG-A-ATT-C-G-T-G-GT-GT-A-G-CGGT-G-AAA--TG-C-TT-AG--AT-A-TC-A-C-G-AA-G-A-AC-T-CC-GA-T-T-GC-GAA-GG-CAG-C-TC-A--CTGG-AC-TG-C-A-ACT--GACA-CTG-A-TG--C-T-CG-AAA-G-T-G-TGGG-T--ATC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-A-CAG-T-AAAC-G-A-TG-AA--TA-C-T-C-G-CT-G-T-T--T-G-C-G------------ATA-TAC---------G-G-T-A-A-G-C-G-G-C--CA--A-G-C-G-AA-A-G-C-A-T-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-CC-G-G-C-A-ACGGTGAA";
Sequence newSeq1751(name, align);
seqs.push_back(newSeq1751);
name = "GQY1XT001EJN8I";
align = "T-T--T-T--GA-A-A-C-T-G-T--GC-G-G-C--T-A-G-A-G-T-G-T-CG-GA-G-G-G-G-T-A--AG-T-GG-A-ATT-C-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-TT-A--CTGG-AC-GA-T-G-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AA--TA-C-T-A-G-GT-G-T-C--G-G-G-G-G--T---C----AT-AA----G-A-C-T-T-C-C-G-G-T-G-C-C--GT--C-G-C-A-AA-C-G-C-A-G-TAA-G-TAT-TCC-ACC-T-G-GGG-AG-TA--CG-TT-C-G-C-A-AGAATGAA";
Sequence newSeq1752(name, align);
seqs.push_back(newSeq1752);
name = "GQY1XT001EJGNG";
align = "G-T--T-C--AA-A-A-C-T-G-C--AG-G-T-C--T-T-G-A-G-T-G-A-AG-TA-G-A-G-G-C-A--GG-C-GG-A-ATTCC-C-T-A-GT-GT-A-G-CGGT-G-AAA--TG-C-GT-AG--AT-A-TT-A-G-G-AG-G-A-AC-A-CC-AG-T-G-GC-GAA-GG-CGG-C-CT-G--CTGG-GC-TT-T-A-ACT--GACG-CTG-A-GG--C-T-CG-AAA-G-C-G-TGGG-G--AGC-A-AA-CA-GG-ATTAG-ATA-CCCT-GGTA-GT-C-CA-C-G-CCG-T-AAAC-G-A-TG-AT--TA-C-T-A-G-GT-G-T-G--G-G-G-A-G----------A-T-CA-AA-----C-T-T-T-C-C-G-T-G-C-C--GG--A-G-T-A-AA-C-A-C-A-A-TAA-G-TAA-TCC-ACC-T-G-GGG-AG-TA--CG-GC-C-G-C-A-AGGTTGAA";
Sequence newSeq1753(name, align);
seqs.push_back(newSeq1753);
name = "GQY1XT001EFJ4B";
align = "A-T--T-T--GA-A-A-C-T-G-C--CA-G-G-C--T-A-G-A-G-