
//
//  fastqdataset.cpp
//  Mothur
//
//  Created by Sarah Westcott on 3/31/16.
//  Copyright (c) 2016 Schloss Lab. All rights reserved.
//

#include "fastqdataset.h"

/***********************************************************************/
TestFastqDataSet::TestFastqDataSet() {  m = MothurOut::getInstance();  }
/***********************************************************************/
vector<string> TestFastqDataSet::getSubsetFRFastq(int numSeqs) {
    
    fillForwardFastq();
    fillReverseFastq();
    ofstream out, out2;
    m->openOutputFile("tempForward.txt", out); m->openOutputFile("tempReverse.txt", out2);
    for (int i = 0; i < numSeqs; i++) {
        ffastqReads[i].printFastq(out);
        rfastqReads[i].printFastq(out2);
    }
    
    vector<string> filenames; filenames.push_back("tempForward.txt"); filenames.push_back("tempReverse.txt");
    
    return filenames;
}
/***********************************************************************/
void TestFastqDataSet::fillForwardFastq() {
	vector<int> scores;
    ffastqReads.clear();
	FastqRead read1; read1.setName("M00967_44_000000000-A3K85_1_1101_16426_1716");
	read1.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGACTCTCAAGTCAGCGGTCAAATCGCGGGGCTCAACCCCGTTCCGCCGTTGAAACTGGGAGCCTTGAGTGCGCGAGAAGTAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCCTACCGGCGCGCAACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(34);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(33);	scores.push_back(15);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(24);	scores.push_back(25);	scores.push_back(33);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(13);	scores.push_back(33);	scores.push_back(33);	scores.push_back(26);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(13);	scores.push_back(34);	scores.push_back(37);	read1.setScores(scores);
	ffastqReads.push_back(read1);
	FastqRead read2; read2.setName("M00967_44_000000000-A3K85_1_1101_13261_1978");
	read2.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTTATGTAAGTCTGAAGTGAAAGCCCGGGGCCCAACCCCGGGACTGCTTTGGAAACTGTGTAACTAGAGTACAGGAGGGGCAGGCGGAATTCCTGGTGTAGCGGTGAAATGCGTAGATATCAGGAGGAACACCGGCGGCGAAGGCGGCCTGCTGGCCTGAAACTGACGTTGAGGCTCGAAAGCGTGGGGAGGCAACA");
	scores.clear();		scores.push_back(32);	scores.push_back(16);	scores.push_back(29);	scores.push_back(16);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(31);	scores.push_back(30);	scores.push_back(15);	scores.push_back(36);	scores.push_back(15);	scores.push_back(32);	scores.push_back(15);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(36);	scores.push_back(15);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(35);	scores.push_back(16);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(14);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(32);	scores.push_back(14);	scores.push_back(30);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(14);	scores.push_back(14);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(35);	scores.push_back(17);	scores.push_back(17);	scores.push_back(31);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(39);	scores.push_back(36);	scores.push_back(16);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(31);	scores.push_back(36);	scores.push_back(34);	scores.push_back(14);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(32);	scores.push_back(14);	scores.push_back(33);	scores.push_back(34);	scores.push_back(30);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(27);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(16);	scores.push_back(27);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(16);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(30);	scores.push_back(30);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(34);	scores.push_back(34);	scores.push_back(12);	scores.push_back(31);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(33);	scores.push_back(34);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(15);	scores.push_back(33);	scores.push_back(12);	scores.push_back(24);	scores.push_back(24);	scores.push_back(32);	scores.push_back(24);	scores.push_back(15);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(32);	scores.push_back(33);	scores.push_back(38);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(36);	scores.push_back(30);	scores.push_back(24);	scores.push_back(24);	scores.push_back(32);	scores.push_back(24);	scores.push_back(12);	scores.push_back(32);	scores.push_back(26);	scores.push_back(31);	scores.push_back(12);	scores.push_back(31);	scores.push_back(31);	scores.push_back(26);	scores.push_back(29);	scores.push_back(31);	scores.push_back(31);	scores.push_back(12);	scores.push_back(32);	scores.push_back(32);	scores.push_back(30);	scores.push_back(31);	scores.push_back(31);	scores.push_back(28);	scores.push_back(12);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(24);	scores.push_back(24);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(32);	scores.push_back(12);	scores.push_back(32);	scores.push_back(12);	scores.push_back(24);	scores.push_back(14);	scores.push_back(33);	scores.push_back(12);	scores.push_back(32);	scores.push_back(12);	scores.push_back(24);	scores.push_back(12);	scores.push_back(24);	scores.push_back(32);	scores.push_back(30);	scores.push_back(25);	scores.push_back(24);	scores.push_back(12);	scores.push_back(12);	scores.push_back(28);	scores.push_back(31);	scores.push_back(31);	scores.push_back(12);	scores.push_back(31);	scores.push_back(24);	scores.push_back(12);	scores.push_back(24);	scores.push_back(12);	scores.push_back(24);	scores.push_back(12);	read2.setScores(scores);
	ffastqReads.push_back(read2);
	FastqRead read3; read3.setName("M00967_44_000000000-A3K85_1_1101_13914_2140");
	read3.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGCGCCAAGTCTGGAGTGAAATGCCGCAGCTTAACTGCGGAACTGCTTTGGAAACTGGCGGACTAGAGTGCGGGAGGGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCGGTGGCGAAGGCGGCTTACTGGACCGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(31);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	read3.setScores(scores);
	ffastqReads.push_back(read3);
	FastqRead read4; read4.setName("M00967_44_000000000-A3K85_1_1101_14317_2429");
	read4.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGTCCGTTAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTCGAGCCGTTGAAACTGGCAGACTTGAGTTGGCGAGAAGTACGCGGAATGCGCGGTGTAGCGGTGAAATGCATAGATATCGCGCAGAACTCCGATTGCGAAGGCAGCGTACCGGCGCCAGACTGACGCTGAGGCACGAAAGTGCGGGGATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(34);	scores.push_back(31);	scores.push_back(33);	scores.push_back(32);	scores.push_back(33);	scores.push_back(34);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(31);	scores.push_back(35);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(29);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(30);	scores.push_back(30);	scores.push_back(37);	scores.push_back(35);	scores.push_back(33);	scores.push_back(32);	scores.push_back(29);	scores.push_back(37);	read4.setScores(scores);
	ffastqReads.push_back(read4);
	FastqRead read5; read5.setName("M00967_44_000000000-A3K85_1_1101_16984_2484");
	read5.setSeq("TACGTAGGGAGCAAGCGTTGTCCGGAATTACTGGGTGTAAAGGGAGCGTAGGCGGGGATGCAAGTTGGGTGTCAAAACTACCGGCTCAACCGATAGTCGCACTCAAAACTGCAGCTCTTGAGTGAAGTAGAGGCAGGCGGGATTCCTAGTGTAGCGGTGGAATGCGGTGATATTAGGAGGGACACCAGTGGGGAAGGGGGCCCGCTGGGGTTTTACTTAAGCTTAGGCTCGCAAGGGGGGGGGGCCAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(29);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(19);	scores.push_back(38);	scores.push_back(38);	scores.push_back(27);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(30);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(15);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(15);	scores.push_back(14);	scores.push_back(15);	scores.push_back(28);	scores.push_back(35);	scores.push_back(35);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(35);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(15);	scores.push_back(28);	scores.push_back(34);	scores.push_back(15);	scores.push_back(38);	scores.push_back(39);	scores.push_back(30);	scores.push_back(36);	scores.push_back(35);	scores.push_back(34);	scores.push_back(13);	scores.push_back(26);	scores.push_back(33);	scores.push_back(12);	scores.push_back(32);	scores.push_back(13);	scores.push_back(33);	scores.push_back(15);	scores.push_back(34);	scores.push_back(15);	scores.push_back(26);	scores.push_back(15);	scores.push_back(15);	scores.push_back(34);	scores.push_back(33);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(25);	scores.push_back(31);	scores.push_back(13);	scores.push_back(24);	scores.push_back(13);	scores.push_back(24);	scores.push_back(26);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(13);	scores.push_back(12);	scores.push_back(13);	scores.push_back(12);	scores.push_back(13);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(26);	scores.push_back(15);	scores.push_back(15);	scores.push_back(24);	scores.push_back(15);	scores.push_back(14);	scores.push_back(26);	scores.push_back(12);	scores.push_back(24);	scores.push_back(13);	scores.push_back(26);	scores.push_back(13);	scores.push_back(24);	scores.push_back(13);	scores.push_back(13);	scores.push_back(15);	scores.push_back(24);	scores.push_back(25);	scores.push_back(13);	scores.push_back(24);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(13);	scores.push_back(13);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(32);	scores.push_back(12);	scores.push_back(13);	scores.push_back(24);	scores.push_back(13);	scores.push_back(32);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(24);	scores.push_back(15);	scores.push_back(15);	scores.push_back(13);	scores.push_back(24);	scores.push_back(12);	scores.push_back(24);	scores.push_back(24);	scores.push_back(26);	scores.push_back(13);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(33);	scores.push_back(34);	scores.push_back(12);	scores.push_back(28);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(32);	scores.push_back(32);	scores.push_back(13);	scores.push_back(25);	read5.setScores(scores);
	ffastqReads.push_back(read5);
	FastqRead read6; read6.setName("M00967_44_000000000-A3K85_1_1101_19404_2607");
	read6.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGCAGAGCAAGTCTGAAGTGAAAGCCCGCGGCCCAACTGCGGGACTGCTTTGGAAACTGCCCGGCTAGAGTGCTGGAGAGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(24);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(35);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(13);	read6.setScores(scores);
	ffastqReads.push_back(read6);
	FastqRead read7; read7.setName("M00967_44_000000000-A3K85_1_1101_20204_2681");
	read7.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGCCTGCCAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTACAGCCGTTGAAACTGCCGGGCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCAAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read7.setScores(scores);
	ffastqReads.push_back(read7);
	FastqRead read8; read8.setName("M00967_44_000000000-A3K85_1_1101_9845_2818");
	read8.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(32);	scores.push_back(33);	scores.push_back(32);	scores.push_back(32);	scores.push_back(31);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(32);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(30);	scores.push_back(32);	scores.push_back(32);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(34);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(33);	scores.push_back(39);	scores.push_back(37);	scores.push_back(35);	scores.push_back(34);	scores.push_back(39);	scores.push_back(34);	scores.push_back(14);	scores.push_back(34);	scores.push_back(38);	scores.push_back(30);	scores.push_back(37);	scores.push_back(35);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(33);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(16);	scores.push_back(31);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(32);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(30);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(33);	scores.push_back(36);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(36);	scores.push_back(33);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(25);	scores.push_back(24);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(12);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(24);	scores.push_back(26);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(14);	scores.push_back(37);	scores.push_back(32);	scores.push_back(36);	scores.push_back(14);	scores.push_back(32);	scores.push_back(28);	scores.push_back(37);	read8.setScores(scores);
	ffastqReads.push_back(read8);
	FastqRead read9; read9.setName("M00967_44_000000000-A3K85_1_1101_19657_2857");
	read9.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTTGTGCAAGTCTGAAGTGAAAGCCCGCGGCTCAACTGCGGAACGGCTTTGGAAACTGTGTAACTGGAGTGCTGGAGAGGTAAGCGGAATTCCTGGTGTAGCGGTGAAATGCGTAGAGATCAGGAGGAACACCGGCGGCGAAGGCGGCTTACTGGACAGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(36);	scores.push_back(32);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(35);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(35);	scores.push_back(38);	scores.push_back(30);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(13);	scores.push_back(26);	scores.push_back(31);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(26);	scores.push_back(28);	scores.push_back(32);	scores.push_back(30);	scores.push_back(33);	scores.push_back(26);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(24);	scores.push_back(32);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(33);	scores.push_back(13);	scores.push_back(24);	scores.push_back(13);	scores.push_back(25);	scores.push_back(32);	scores.push_back(32);	scores.push_back(13);	scores.push_back(29);	scores.push_back(13);	scores.push_back(25);	scores.push_back(33);	scores.push_back(37);	scores.push_back(13);	scores.push_back(13);	read9.setScores(scores);
	ffastqReads.push_back(read9);
	FastqRead read10; read10.setName("M00967_44_000000000-A3K85_1_1101_12105_3062");
	read10.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCGGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGAAGCTGAGGCACGAAAGGGTGGGGATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(17);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(36);	scores.push_back(33);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(15);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(32);	scores.push_back(38);	scores.push_back(31);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(38);	scores.push_back(39);	scores.push_back(27);	scores.push_back(35);	scores.push_back(35);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(30);	scores.push_back(12);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(13);	scores.push_back(32);	scores.push_back(34);	scores.push_back(39);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(12);	scores.push_back(24);	scores.push_back(12);	scores.push_back(13);	scores.push_back(26);	scores.push_back(15);	scores.push_back(26);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(32);	scores.push_back(35);	scores.push_back(12);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(32);	scores.push_back(24);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(13);	scores.push_back(12);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(14);	scores.push_back(24);	scores.push_back(14);	scores.push_back(24);	scores.push_back(24);	scores.push_back(14);	scores.push_back(24);	scores.push_back(33);	scores.push_back(32);	scores.push_back(13);	scores.push_back(29);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(24);	scores.push_back(14);	scores.push_back(37);	scores.push_back(13);	scores.push_back(31);	scores.push_back(35);	scores.push_back(35);	scores.push_back(36);	scores.push_back(14);	scores.push_back(32);	scores.push_back(31);	scores.push_back(35);	scores.push_back(26);	scores.push_back(32);	scores.push_back(13);	scores.push_back(32);	scores.push_back(35);	scores.push_back(13);	scores.push_back(26);	scores.push_back(33);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(26);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(12);	scores.push_back(12);	scores.push_back(31);	scores.push_back(12);	scores.push_back(12);	scores.push_back(13);	scores.push_back(14);	scores.push_back(14);	scores.push_back(26);	scores.push_back(24);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(24);	scores.push_back(36);	scores.push_back(30);	scores.push_back(13);	scores.push_back(24);	scores.push_back(35);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(32);	scores.push_back(13);	scores.push_back(26);	scores.push_back(13);	scores.push_back(13);	scores.push_back(24);	scores.push_back(33);	scores.push_back(12);	scores.push_back(24);	scores.push_back(26);	scores.push_back(13);	scores.push_back(13);	scores.push_back(25);	scores.push_back(37);	scores.push_back(13);	scores.push_back(12);	scores.push_back(26);	read10.setScores(scores);
	ffastqReads.push_back(read10);
	FastqRead read11; read11.setName("M00967_44_000000000-A3K85_1_1101_18891_3237");
	read11.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGCCAAGTCAGCGGTAAAAAAGCGGTGCTCAACGCCGTCGAGCCGTTGAAACTGGCGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read11.setScores(scores);
	ffastqReads.push_back(read11);
	FastqRead read12; read12.setName("M00967_44_000000000-A3K85_1_1101_14107_3251");
	read12.setSeq("TACGTAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCGGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGCGTGGGCATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(35);	scores.push_back(36);	scores.push_back(36);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(33);	scores.push_back(30);	scores.push_back(27);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read12.setScores(scores);
	ffastqReads.push_back(read12);
	FastqRead read13; read13.setName("M00967_44_000000000-A3K85_1_1101_17862_3303");
	read13.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGCCAAGTCAGCGGTAAAAAAGCGGTGCTCAACGCCGTCGAGCCGGTGAAACTGGCGTTCTTGAGTGGGCGGGAAGTATGCGGAATGCGTGGGGTAGCGGTGAAATGCATAGATATCACGCCGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGCGGGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(14);	scores.push_back(30);	scores.push_back(14);	scores.push_back(29);	scores.push_back(14);	scores.push_back(27);	scores.push_back(14);	scores.push_back(37);	scores.push_back(17);	scores.push_back(17);	scores.push_back(37);	scores.push_back(17);	scores.push_back(14);	scores.push_back(14);	scores.push_back(33);	scores.push_back(14);	scores.push_back(14);	scores.push_back(27);	scores.push_back(14);	scores.push_back(14);	scores.push_back(27);	scores.push_back(13);	scores.push_back(32);	scores.push_back(27);	scores.push_back(12);	scores.push_back(29);	scores.push_back(12);	scores.push_back(13);	scores.push_back(27);	scores.push_back(38);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(27);	scores.push_back(13);	scores.push_back(12);	scores.push_back(13);	scores.push_back(26);	scores.push_back(13);	scores.push_back(34);	scores.push_back(38);	scores.push_back(15);	scores.push_back(26);	scores.push_back(15);	scores.push_back(15);	scores.push_back(25);	scores.push_back(34);	scores.push_back(38);	scores.push_back(13);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(13);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(24);	scores.push_back(33);	scores.push_back(24);	scores.push_back(34);	scores.push_back(13);	scores.push_back(15);	scores.push_back(15);	scores.push_back(13);	scores.push_back(24);	scores.push_back(26);	scores.push_back(34);	scores.push_back(12);	scores.push_back(12);	scores.push_back(13);	scores.push_back(13);	scores.push_back(13);	scores.push_back(15);	scores.push_back(12);	scores.push_back(26);	scores.push_back(13);	scores.push_back(12);	scores.push_back(13);	scores.push_back(26);	scores.push_back(37);	scores.push_back(24);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(24);	scores.push_back(15);	scores.push_back(24);	scores.push_back(13);	scores.push_back(13);	scores.push_back(12);	scores.push_back(24);	scores.push_back(26);	scores.push_back(12);	scores.push_back(24);	scores.push_back(15);	scores.push_back(33);	scores.push_back(13);	scores.push_back(12);	scores.push_back(13);	scores.push_back(26);	scores.push_back(13);	scores.push_back(15);	scores.push_back(26);	scores.push_back(12);	scores.push_back(31);	scores.push_back(12);	scores.push_back(24);	scores.push_back(13);	scores.push_back(25);	scores.push_back(13);	scores.push_back(32);	scores.push_back(32);	scores.push_back(15);	scores.push_back(25);	scores.push_back(15);	scores.push_back(33);	scores.push_back(30);	scores.push_back(33);	scores.push_back(34);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(33);	scores.push_back(12);	scores.push_back(24);	scores.push_back(13);	scores.push_back(24);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(13);	scores.push_back(13);	scores.push_back(25);	scores.push_back(13);	scores.push_back(13);	scores.push_back(24);	scores.push_back(36);	scores.push_back(30);	scores.push_back(30);	scores.push_back(13);	scores.push_back(25);	scores.push_back(13);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(14);	scores.push_back(35);	scores.push_back(12);	scores.push_back(25);	scores.push_back(31);	scores.push_back(35);	scores.push_back(12);	scores.push_back(13);	scores.push_back(15);	scores.push_back(15);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(13);	scores.push_back(24);	scores.push_back(24);	read13.setScores(scores);
	ffastqReads.push_back(read13);
	FastqRead read14; read14.setName("M00967_44_000000000-A3K85_1_1101_16892_3727");
	read14.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGCCAAGTCAGCGGTAAAAAAGCGGTGCTCAACGCCGTCGAGCCGTTGAAACTGGCGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(33);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	read14.setScores(scores);
	ffastqReads.push_back(read14);
	FastqRead read15; read15.setName("M00967_44_000000000-A3K85_1_1101_19976_3934");
	read15.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGCCAGACAAGTCAGAAGTGAAAGCCCAGGGCTCAACCCTGGGACTGCTTTTGAAACTGCCGGGCTGGAGTGCAGGAGAGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(33);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(18);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(15);	scores.push_back(38);	scores.push_back(37);	scores.push_back(34);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(35);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(14);	scores.push_back(14);	scores.push_back(29);	scores.push_back(36);	scores.push_back(35);	scores.push_back(27);	scores.push_back(16);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(35);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(35);	scores.push_back(30);	scores.push_back(36);	scores.push_back(39);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(35);	scores.push_back(25);	scores.push_back(24);	scores.push_back(24);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(34);	scores.push_back(15);	scores.push_back(34);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(30);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(36);	scores.push_back(13);	scores.push_back(32);	scores.push_back(28);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(14);	scores.push_back(24);	scores.push_back(13);	scores.push_back(32);	scores.push_back(35);	scores.push_back(26);	scores.push_back(12);	scores.push_back(24);	scores.push_back(25);	scores.push_back(13);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read15.setScores(scores);
	ffastqReads.push_back(read15);
	FastqRead read16; read16.setName("M00967_44_000000000-A3K85_1_1101_8238_3938");
	read16.setSeq("TACGGAGGATCCGAGCATTATCCGGAGTGACTGGGTGTAAAGAGTTGCGTAGGTGGCATAGTAAGTAGCTAGTGAAATCTGGTGGCTCAACCATTCAGACTATTAGCTAAACTGCTAAGCTCGAGACCGTTAGGGGTAACTGGAATTTCTAGTGTAGGAGTGAAATCCGTAGATATTAGAAGGAACACCGATAGCGTAGGCAGGTTACTGGGACGGTTCTGACACTAAGGCACGAAAGCGTAGGGAGCAAA");
	scores.clear();		scores.push_back(32);	scores.push_back(32);	scores.push_back(16);	scores.push_back(16);	scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(16);	scores.push_back(32);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(38);	scores.push_back(37);	scores.push_back(34);	scores.push_back(15);	scores.push_back(15);	scores.push_back(33);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(18);	scores.push_back(36);	scores.push_back(34);	scores.push_back(34);	scores.push_back(36);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(33);	scores.push_back(39);	scores.push_back(34);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(16);	scores.push_back(33);	scores.push_back(32);	scores.push_back(34);	scores.push_back(38);	scores.push_back(32);	scores.push_back(34);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(31);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(16);	scores.push_back(38);	scores.push_back(17);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(16);	scores.push_back(16);	scores.push_back(33);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(30);	scores.push_back(33);	scores.push_back(37);	scores.push_back(17);	scores.push_back(38);	scores.push_back(33);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(16);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(35);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(34);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(27);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(15);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(16);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(32);	scores.push_back(34);	scores.push_back(31);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(31);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(13);	scores.push_back(34);	scores.push_back(37);	scores.push_back(31);	scores.push_back(38);	scores.push_back(34);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(14);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(30);	scores.push_back(31);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read16.setScores(scores);
	ffastqReads.push_back(read16);
	FastqRead read17; read17.setName("M00967_44_000000000-A3K85_1_1101_15081_3972");
	read17.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCGGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read17.setScores(scores);
	ffastqReads.push_back(read17);
	FastqRead read18; read18.setName("M00967_44_000000000-A3K85_1_1101_22821_4157");
	read18.setSeq("TACGTAGGTGGCAAGCGTTGTCCGGAATTACTGGGTGTAAAGGGAGCGTAGGCGGGAAAGCAAGTTGAATGTTTAAGGTACGGGCTCAACCTGTACAAGCGTTCAAAACTGTTTTTCTTGAGTGGAGTAGAGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAAATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGGCTTTAACTGACGCTGAGGCTCGAAAGCGTGGGTAGCAAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(24);	scores.push_back(28);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read18.setScores(scores);
	ffastqReads.push_back(read18);
	FastqRead read19; read19.setName("M00967_44_000000000-A3K85_1_1101_17852_4185");
	read19.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGCGCCAAGTCTGGAGTGAAATGCCGCAGCTTAACTGCGGAACTGCTTTGGAAACTGGCGGACTAGAGTGCGGGAGGGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCGGTGGCGAAGGCGGCTTACTGGACCGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(24);	read19.setScores(scores);
	ffastqReads.push_back(read19);
	FastqRead read20; read20.setName("M00967_44_000000000-A3K85_1_1101_18480_4201");
	read20.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(31);	scores.push_back(28);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(12);	scores.push_back(37);	read20.setScores(scores);
	ffastqReads.push_back(read20);
	FastqRead read21; read21.setName("M00967_44_000000000-A3K85_1_1101_23838_4345");
	read21.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCGAAGGCAGCTCACTGGACTGCAACTGACACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(20);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(36);	scores.push_back(35);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(34);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(30);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(13);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(14);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(14);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(13);	read21.setScores(scores);
	ffastqReads.push_back(read21);
	FastqRead read22; read22.setName("M00967_44_000000000-A3K85_1_1101_18767_4363");
	read22.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTACTGGGTGTAAAGGGTGCGTAGGCGGGCAGTTAAGTCAGCGGTCAAAAGCCGGGGCTCAACCCATGCCTGCCATTGAAAAAAGTGGTCTCCAGGGGACGGGTAGTGTGAAGAATACTTGGTGGAGCGGGGGAAAACACAGAAGATATGGAGAACTACGATTGCGGCGGAGGCATACCGGCGCCACGATTCTGATGAGGCGGCAAAACGGGGGGGTCGAAAAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(34);	scores.push_back(39);	scores.push_back(20);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(17);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(16);	scores.push_back(32);	scores.push_back(33);	scores.push_back(36);	scores.push_back(32);	scores.push_back(36);	scores.push_back(18);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(34);	scores.push_back(14);	scores.push_back(29);	scores.push_back(18);	scores.push_back(19);	scores.push_back(19);	scores.push_back(33);	scores.push_back(19);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(14);	scores.push_back(29);	scores.push_back(30);	scores.push_back(14);	scores.push_back(30);	scores.push_back(37);	scores.push_back(39);	scores.push_back(18);	scores.push_back(18);	scores.push_back(15);	scores.push_back(15);	scores.push_back(29);	scores.push_back(33);	scores.push_back(30);	scores.push_back(35);	scores.push_back(14);	scores.push_back(14);	scores.push_back(30);	scores.push_back(27);	scores.push_back(37);	scores.push_back(17);	scores.push_back(30);	scores.push_back(35);	scores.push_back(14);	scores.push_back(30);	scores.push_back(27);	scores.push_back(30);	scores.push_back(16);	scores.push_back(16);	scores.push_back(16);	scores.push_back(30);	scores.push_back(27);	scores.push_back(16);	scores.push_back(30);	scores.push_back(38);	scores.push_back(16);	scores.push_back(16);	scores.push_back(16);	scores.push_back(27);	scores.push_back(16);	scores.push_back(15);	scores.push_back(12);	scores.push_back(13);	scores.push_back(16);	scores.push_back(28);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(14);	scores.push_back(14);	scores.push_back(13);	scores.push_back(12);	scores.push_back(13);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(36);	scores.push_back(15);	scores.push_back(14);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(14);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(26);	scores.push_back(15);	scores.push_back(15);	scores.push_back(26);	scores.push_back(13);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(14);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(13);	scores.push_back(25);	scores.push_back(13);	scores.push_back(14);	scores.push_back(13);	scores.push_back(13);	scores.push_back(13);	scores.push_back(25);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(24);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(13);	scores.push_back(14);	scores.push_back(24);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(26);	scores.push_back(13);	scores.push_back(24);	scores.push_back(13);	scores.push_back(13);	scores.push_back(13);	scores.push_back(14);	scores.push_back(13);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(24);	scores.push_back(30);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(13);	scores.push_back(12);	scores.push_back(12);	scores.push_back(25);	scores.push_back(12);	scores.push_back(12);	scores.push_back(13);	scores.push_back(13);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(13);	scores.push_back(14);	scores.push_back(14);	scores.push_back(25);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(13);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(13);	scores.push_back(13);	scores.push_back(13);	scores.push_back(12);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(25);	scores.push_back(13);	scores.push_back(12);	scores.push_back(12);	scores.push_back(24);	scores.push_back(24);	scores.push_back(25);	scores.push_back(14);	read22.setScores(scores);
	ffastqReads.push_back(read22);
	FastqRead read23; read23.setName("M00967_44_000000000-A3K85_1_1101_23688_4365");
	read23.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGGATGCCAAGTCAGCGGTCAAATTTCGGGGCTCAACCCCGACCTGCCGTTGAAACTGGTGTCCTAGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(34);	scores.push_back(37);	scores.push_back(24);	scores.push_back(28);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(34);	scores.push_back(37);	scores.push_back(32);	scores.push_back(33);	scores.push_back(26);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read23.setScores(scores);
	ffastqReads.push_back(read23);
	FastqRead read24; read24.setName("M00967_44_000000000-A3K85_1_1101_11722_4402");
	read24.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGACTCTCAAGTCAGCGGTCAAATCGCGGGGCTCAACCCCGTTCCGCCGTTGAAACTGGGAGCCTTGAGTGCGCGAGAAGTAGGCGGAATGCGTGGTGTAGCGGTGAAATGCCTAGATATCACGCAGAACTCCGATTGCGAAGGCAGCCTACCGGCGCGCAAATGACGCTCATGCACGAAAGCGTGGGGATCGAAAAG");
	scores.clear();		scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(30);	scores.push_back(32);	scores.push_back(32);	scores.push_back(35);	scores.push_back(30);	scores.push_back(16);	scores.push_back(34);	scores.push_back(37);	scores.push_back(32);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(14);	scores.push_back(32);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(32);	scores.push_back(14);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(36);	scores.push_back(38);	scores.push_back(15);	scores.push_back(38);	scores.push_back(16);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(34);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(30);	scores.push_back(32);	scores.push_back(14);	scores.push_back(14);	scores.push_back(33);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(14);	scores.push_back(27);	scores.push_back(27);	scores.push_back(37);	scores.push_back(15);	scores.push_back(27);	scores.push_back(34);	scores.push_back(13);	scores.push_back(34);	scores.push_back(12);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(13);	scores.push_back(38);	scores.push_back(39);	scores.push_back(15);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(13);	scores.push_back(13);	scores.push_back(13);	scores.push_back(13);	scores.push_back(25);	scores.push_back(34);	scores.push_back(14);	scores.push_back(26);	scores.push_back(15);	scores.push_back(26);	scores.push_back(34);	scores.push_back(34);	scores.push_back(12);	scores.push_back(25);	scores.push_back(32);	scores.push_back(38);	scores.push_back(12);	scores.push_back(30);	scores.push_back(34);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(31);	scores.push_back(32);	scores.push_back(12);	scores.push_back(31);	scores.push_back(24);	scores.push_back(14);	scores.push_back(33);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(24);	scores.push_back(12);	scores.push_back(14);	scores.push_back(24);	scores.push_back(24);	scores.push_back(12);	scores.push_back(31);	scores.push_back(24);	scores.push_back(31);	scores.push_back(12);	scores.push_back(33);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(24);	scores.push_back(14);	scores.push_back(24);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(26);	scores.push_back(14);	scores.push_back(32);	scores.push_back(12);	scores.push_back(31);	scores.push_back(12);	scores.push_back(12);	scores.push_back(37);	scores.push_back(12);	scores.push_back(24);	scores.push_back(14);	scores.push_back(26);	scores.push_back(12);	scores.push_back(31);	scores.push_back(12);	scores.push_back(32);	scores.push_back(36);	scores.push_back(14);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(24);	scores.push_back(24);	scores.push_back(32);	scores.push_back(12);	scores.push_back(32);	scores.push_back(37);	scores.push_back(14);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(31);	scores.push_back(12);	scores.push_back(31);	scores.push_back(31);	scores.push_back(30);	scores.push_back(26);	scores.push_back(12);	scores.push_back(24);	scores.push_back(12);	scores.push_back(14);	scores.push_back(24);	scores.push_back(26);	scores.push_back(14);	scores.push_back(25);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(25);	scores.push_back(14);	scores.push_back(33);	scores.push_back(14);	scores.push_back(24);	scores.push_back(14);	scores.push_back(12);	scores.push_back(24);	scores.push_back(24);	scores.push_back(32);	scores.push_back(12);	scores.push_back(24);	scores.push_back(12);	scores.push_back(24);	scores.push_back(12);	scores.push_back(26);	scores.push_back(31);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(24);	scores.push_back(32);	scores.push_back(37);	scores.push_back(12);	scores.push_back(24);	scores.push_back(14);	read24.setScores(scores);
	ffastqReads.push_back(read24);
	FastqRead read25; read25.setName("M00967_44_000000000-A3K85_1_1101_17907_4466");
	read25.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGTTTGTCAAGTCAGCGGTAAAAATTCCGGGCTCAACCCGGTCCCGCCGTTGAAACTGGCGAACTCGAGAGGGAGAGAAGTAGGCGGAATGCGCAGTGTAGCGGTGAAATGCATAGATATTGCGCAGAACTCCGATTGCGAAGGCAGCCTACCGGCTCCTATCTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(33);	scores.push_back(32);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(32);	scores.push_back(35);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read25.setScores(scores);
	ffastqReads.push_back(read25);
	FastqRead read26; read26.setName("M00967_44_000000000-A3K85_1_1101_24292_4560");
	read26.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCGGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(34);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(31);	scores.push_back(12);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read26.setScores(scores);
	ffastqReads.push_back(read26);
	FastqRead read27; read27.setName("M00967_44_000000000-A3K85_1_1101_10051_4697");
	read27.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTCCTGCAAGCCAGATGTGAAAGCCCGGGGCTCAACCCCGGGACTGCATTTGGAACTGTAAGGCTAGAGTGTCGGAGAGGCAGGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCCTGCTGGACGATGACTGACGTTGAGGCTCGGAAGCGTGGGGAGCCAACA");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(12);	scores.push_back(32);	scores.push_back(13);	scores.push_back(34);	scores.push_back(26);	scores.push_back(38);	scores.push_back(15);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(24);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(13);	scores.push_back(35);	scores.push_back(13);	scores.push_back(34);	scores.push_back(37);	scores.push_back(15);	scores.push_back(24);	scores.push_back(33);	scores.push_back(35);	scores.push_back(32);	scores.push_back(32);	scores.push_back(33);	scores.push_back(32);	scores.push_back(15);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(36);	scores.push_back(36);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(32);	scores.push_back(12);	scores.push_back(25);	scores.push_back(25);	scores.push_back(12);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(31);	scores.push_back(12);	scores.push_back(31);	scores.push_back(24);	scores.push_back(13);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(13);	scores.push_back(13);	scores.push_back(14);	scores.push_back(14);	scores.push_back(24);	scores.push_back(14);	scores.push_back(25);	scores.push_back(24);	scores.push_back(25);	scores.push_back(13);	scores.push_back(26);	scores.push_back(32);	scores.push_back(32);	scores.push_back(14);	scores.push_back(37);	scores.push_back(13);	scores.push_back(13);	scores.push_back(25);	scores.push_back(25);	scores.push_back(12);	scores.push_back(26);	scores.push_back(32);	scores.push_back(35);	scores.push_back(13);	scores.push_back(24);	scores.push_back(13);	scores.push_back(26);	scores.push_back(29);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(33);	scores.push_back(24);	scores.push_back(13);	scores.push_back(26);	scores.push_back(13);	scores.push_back(32);	scores.push_back(13);	read27.setScores(scores);
	ffastqReads.push_back(read27);
	FastqRead read28; read28.setName("M00967_44_000000000-A3K85_1_1101_23618_4708");
	read28.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGACTTGCAAGTCTGATGTGAAAATCCGGGGCCCAACCCCGGAACTGCATTGGAAACTGTATATCTAGAGTGTCGGAGAGGCAAGTGGAATTCCTGGTGTAGCGGTGAAATGCGTAGATATCAGGAGGAACACCAGTGGCAAAGGCGGCTTGCTGGACGATGACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(12);	scores.push_back(13);	scores.push_back(31);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read28.setScores(scores);
	ffastqReads.push_back(read28);
	FastqRead read29; read29.setName("M00967_44_000000000-A3K85_1_1101_16905_4868");
	read29.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGCGCCAAGTCTGGAGTGAAATGCCGCAGCTTAACTGCGGAACTGCTTTGGAAACTGGCGAACTAGAGTGCGGGAGGGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCGGTGGCGAAGGCGGCTTACTGGACCGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(33);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(32);	scores.push_back(36);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(30);	scores.push_back(36);	scores.push_back(14);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(35);	scores.push_back(37);	scores.push_back(39);	scores.push_back(18);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(25);	scores.push_back(25);	scores.push_back(34);	scores.push_back(38);	scores.push_back(26);	scores.push_back(31);	scores.push_back(34);	scores.push_back(30);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(28);	scores.push_back(34);	scores.push_back(31);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(14);	scores.push_back(31);	scores.push_back(13);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(13);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(25);	scores.push_back(31);	scores.push_back(26);	scores.push_back(33);	scores.push_back(32);	scores.push_back(24);	scores.push_back(33);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(33);	scores.push_back(37);	scores.push_back(32);	scores.push_back(30);	scores.push_back(33);	scores.push_back(30);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(13);	read29.setScores(scores);
	ffastqReads.push_back(read29);
	FastqRead read30; read30.setName("M00967_44_000000000-A3K85_1_1101_8858_5007");
	read30.setSeq("TACGTAGGGGGCAAGCGTTATCCGGAATTACTGGGTGTAAAGGGAGCGTAGACGGTGATGCAAGTCTGGAGTGAAAGGCGGGGGCCCAACCCCCGGACTGCTCTGGAAACTGTGTAACTTGAGTGCAGGAGAGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCGGTGGCGAAGGCGGCTTACTGGACCGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(33);	scores.push_back(32);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(34);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(35);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(35);	scores.push_back(35);	scores.push_back(36);	scores.push_back(35);	scores.push_back(13);	scores.push_back(13);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(13);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	read30.setScores(scores);
	ffastqReads.push_back(read30);
	FastqRead read31; read31.setName("M00967_44_000000000-A3K85_1_1101_8790_5160");
	read31.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGCCAAGTCAGCGGTAAAAAAGCGGTGCTCAACGACGTCGAGCCGTTGAAACTGGCGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGCCTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(32);	scores.push_back(32);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(34);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(18);	scores.push_back(31);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(31);	scores.push_back(36);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(17);	scores.push_back(17);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(37);	scores.push_back(34);	scores.push_back(13);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(32);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(32);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(33);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(30);	scores.push_back(12);	scores.push_back(31);	scores.push_back(28);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(31);	scores.push_back(35);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(24);	scores.push_back(32);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read31.setScores(scores);
	ffastqReads.push_back(read31);
	FastqRead read32; read32.setName("M00967_44_000000000-A3K85_1_1101_24227_5213");
	read32.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTTTTAAGTCAGCGGTAAAAATTCGGGGCTCAACCCCGTCCGGCCGTTGAAACTGGGGGCCTTGAGTGGGCGAGAAGAAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCCTTCCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(36);	scores.push_back(16);	scores.push_back(18);	scores.push_back(18);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(18);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(14);	scores.push_back(34);	scores.push_back(38);	scores.push_back(14);	scores.push_back(29);	scores.push_back(31);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(39);	scores.push_back(39);	scores.push_back(32);	scores.push_back(35);	scores.push_back(12);	scores.push_back(25);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(32);	scores.push_back(38);	scores.push_back(38);	scores.push_back(14);	scores.push_back(24);	scores.push_back(14);	scores.push_back(26);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(26);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(26);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(14);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(32);	scores.push_back(35);	scores.push_back(35);	scores.push_back(32);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(24);	scores.push_back(31);	scores.push_back(24);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(36);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(13);	scores.push_back(32);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(25);	scores.push_back(33);	scores.push_back(33);	scores.push_back(34);	scores.push_back(31);	scores.push_back(35);	scores.push_back(32);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	read32.setScores(scores);
	ffastqReads.push_back(read32);
	FastqRead read33; read33.setName("M00967_44_000000000-A3K85_1_1101_20401_5218");
	read33.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCGAAGGCAGCTCACTGGACTGCAACTGACACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read33.setScores(scores);
	ffastqReads.push_back(read33);
	FastqRead read34; read34.setName("M00967_44_000000000-A3K85_1_1101_20650_5286");
	read34.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGTCCGTTAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTCGAGCCGTTGAAACTGGCAGACTTGAGTTGGCGAGAAGGACGCGGAATGCGCGGTGTAGCGGTGAAATGCATAGATATCGCGCAGAACTCCGATTGCGAAGGCAGCGTACCGGCGCCAGACTGACGCTGAGGGACGAAAGCGTGGGGATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(30);	scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(30);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(20);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(32);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(16);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(15);	scores.push_back(36);	scores.push_back(14);	scores.push_back(29);	scores.push_back(30);	scores.push_back(33);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(31);	scores.push_back(31);	scores.push_back(19);	scores.push_back(37);	scores.push_back(18);	scores.push_back(30);	scores.push_back(36);	scores.push_back(36);	scores.push_back(30);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(18);	scores.push_back(30);	scores.push_back(19);	scores.push_back(14);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(31);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(35);	scores.push_back(14);	scores.push_back(14);	scores.push_back(30);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(29);	scores.push_back(12);	scores.push_back(13);	scores.push_back(29);	scores.push_back(36);	scores.push_back(39);	scores.push_back(16);	scores.push_back(38);	scores.push_back(27);	scores.push_back(16);	scores.push_back(15);	scores.push_back(34);	scores.push_back(13);	scores.push_back(38);	scores.push_back(13);	scores.push_back(13);	scores.push_back(13);	scores.push_back(14);	scores.push_back(28);	scores.push_back(38);	scores.push_back(15);	scores.push_back(27);	scores.push_back(15);	scores.push_back(28);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(25);	scores.push_back(25);	scores.push_back(25);	scores.push_back(13);	scores.push_back(34);	scores.push_back(13);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(12);	scores.push_back(24);	scores.push_back(31);	scores.push_back(12);	scores.push_back(31);	scores.push_back(13);	scores.push_back(26);	scores.push_back(15);	scores.push_back(13);	scores.push_back(32);	scores.push_back(29);	scores.push_back(33);	scores.push_back(13);	scores.push_back(12);	scores.push_back(13);	scores.push_back(24);	scores.push_back(33);	scores.push_back(14);	scores.push_back(26);	scores.push_back(33);	scores.push_back(13);	scores.push_back(12);	scores.push_back(13);	scores.push_back(26);	scores.push_back(37);	scores.push_back(14);	scores.push_back(24);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(33);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(24);	scores.push_back(31);	scores.push_back(33);	scores.push_back(29);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(14);	scores.push_back(26);	scores.push_back(13);	scores.push_back(12);	scores.push_back(13);	scores.push_back(25);	scores.push_back(32);	scores.push_back(14);	scores.push_back(24);	scores.push_back(12);	scores.push_back(31);	scores.push_back(12);	scores.push_back(32);	scores.push_back(13);	scores.push_back(13);	scores.push_back(32);	scores.push_back(13);	scores.push_back(12);	scores.push_back(13);	scores.push_back(13);	scores.push_back(12);	scores.push_back(26);	scores.push_back(24);	scores.push_back(33);	scores.push_back(12);	scores.push_back(24);	scores.push_back(33);	scores.push_back(12);	scores.push_back(24);	scores.push_back(29);	scores.push_back(13);	scores.push_back(24);	scores.push_back(14);	scores.push_back(24);	scores.push_back(14);	scores.push_back(14);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(13);	scores.push_back(13);	scores.push_back(24);	scores.push_back(36);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(35);	scores.push_back(13);	scores.push_back(14);	scores.push_back(13);	scores.push_back(13);	scores.push_back(24);	scores.push_back(24);	scores.push_back(33);	scores.push_back(33);	scores.push_back(13);	scores.push_back(13);	scores.push_back(24);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(13);	scores.push_back(12);	scores.push_back(24);	read34.setScores(scores);
	ffastqReads.push_back(read34);
	FastqRead read35; read35.setName("M00967_44_000000000-A3K85_1_1101_24147_5290");
	read35.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCGGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(20);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(33);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(32);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(25);	scores.push_back(28);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(14);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(13);	scores.push_back(24);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	read35.setScores(scores);
	ffastqReads.push_back(read35);
	FastqRead read36; read36.setName("M00967_44_000000000-A3K85_1_1101_21922_5302");
	read36.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGCCAAGTCAGCGGTAAAAATGCGGTGCTCAACGCCGTCGAGCCGTTGAAACTGGCGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(29);	scores.push_back(37);	read36.setScores(scores);
	ffastqReads.push_back(read36);
	FastqRead read37; read37.setName("M00967_44_000000000-A3K85_1_1101_16472_5337");
	read37.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGTCCGTTAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTCGAGCCGTTGAAACTGGCAGACTTGAGTTGGCGAGAAGTACGCGGAATGCGCGGTGTAGCGGTGAAATGCATAGATATCGCGCAGAACTCCGATTGCGAAGGCAGCGTACCGGCGCCAGACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read37.setScores(scores);
	ffastqReads.push_back(read37);
	FastqRead read38; read38.setName("M00967_44_000000000-A3K85_1_1101_10378_5559");
	read38.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGCGCCAAGTCTGGAGTGAAATGCCGCAGCTTAACTGCGGAACTGCTTTGGAAACTGGCGGACTAGAGTGCGGGAGGGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCGGTGGCGAAGGCGGCTTACTGGACCGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(35);	scores.push_back(12);	scores.push_back(32);	scores.push_back(37);	scores.push_back(36);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read38.setScores(scores);
	ffastqReads.push_back(read38);
	FastqRead read39; read39.setName("M00967_44_000000000-A3K85_1_1101_22557_5955");
	read39.setSeq("TACGTAGGGGGCAAGCGTTATCCGGAATCACTGGGTGTAAAGGGAGCGTAGACGGCTGAGCAAGCCTGAAGTGAAAGGCCAGGGCCCAACCCCTGGACTGCTTTGGGAACTGTGGGGCTGGAGTGCAGGAGAGGTAAGTGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(17);	scores.push_back(37);	scores.push_back(18);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(16);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(16);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(16);	scores.push_back(37);	scores.push_back(16);	scores.push_back(14);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(14);	scores.push_back(14);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(30);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(17);	scores.push_back(17);	scores.push_back(14);	scores.push_back(29);	scores.push_back(36);	scores.push_back(38);	scores.push_back(14);	scores.push_back(34);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(16);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(27);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(24);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(13);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(31);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(13);	read39.setScores(scores);
	ffastqReads.push_back(read39);
	FastqRead read40; read40.setName("M00967_44_000000000-A3K85_1_1101_17938_6085");
	read40.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGCCTGCCAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTACAGCCGTTGAAACTGCCGGGCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGTGCGGGGATCAAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	read40.setScores(scores);
	ffastqReads.push_back(read40);
	FastqRead read41; read41.setName("M00967_44_000000000-A3K85_1_1101_17246_6091");
	read41.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(15);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read41.setScores(scores);
	ffastqReads.push_back(read41);
	FastqRead read42; read42.setName("M00967_44_000000000-A3K85_1_1101_10742_6111");
	read42.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTAAAACTGGCAGCCTTAAGTACAGTAGAGGTGGGCGGAATTCGGGGGGAAGCGGGGAAATGCTTAGATATCCCCAAGAACTCCGATTGCGAGGGCAGCTCCCGGGACGGCAACTGACACGGATGCCCAAAAGGGTGGGAATCAAACA");
	scores.clear();		scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(35);	scores.push_back(30);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(14);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(14);	scores.push_back(36);	scores.push_back(38);	scores.push_back(16);	scores.push_back(33);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(37);	scores.push_back(15);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(17);	scores.push_back(38);	scores.push_back(38);	scores.push_back(14);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(16);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(16);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(14);	scores.push_back(29);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(29);	scores.push_back(16);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(29);	scores.push_back(17);	scores.push_back(33);	scores.push_back(33);	scores.push_back(16);	scores.push_back(16);	scores.push_back(16);	scores.push_back(33);	scores.push_back(38);	scores.push_back(14);	scores.push_back(15);	scores.push_back(30);	scores.push_back(14);	scores.push_back(14);	scores.push_back(33);	scores.push_back(27);	scores.push_back(16);	scores.push_back(16);	scores.push_back(16);	scores.push_back(17);	scores.push_back(29);	scores.push_back(31);	scores.push_back(17);	scores.push_back(17);	scores.push_back(31);	scores.push_back(17);	scores.push_back(16);	scores.push_back(17);	scores.push_back(31);	scores.push_back(31);	scores.push_back(16);	scores.push_back(30);	scores.push_back(37);	scores.push_back(27);	scores.push_back(14);	scores.push_back(32);	scores.push_back(12);	scores.push_back(27);	scores.push_back(12);	scores.push_back(13);	scores.push_back(15);	scores.push_back(27);	scores.push_back(13);	scores.push_back(13);	scores.push_back(27);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(24);	scores.push_back(26);	scores.push_back(12);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(25);	scores.push_back(14);	scores.push_back(14);	scores.push_back(25);	scores.push_back(24);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(24);	scores.push_back(12);	scores.push_back(25);	scores.push_back(12);	scores.push_back(12);	scores.push_back(24);	scores.push_back(14);	scores.push_back(26);	scores.push_back(14);	scores.push_back(26);	scores.push_back(14);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(24);	scores.push_back(12);	scores.push_back(14);	scores.push_back(24);	scores.push_back(31);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(25);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(32);	scores.push_back(12);	scores.push_back(24);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(24);	scores.push_back(14);	scores.push_back(14);	scores.push_back(24);	scores.push_back(24);	scores.push_back(33);	scores.push_back(24);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(14);	scores.push_back(24);	scores.push_back(14);	scores.push_back(24);	scores.push_back(12);	scores.push_back(12);	scores.push_back(24);	scores.push_back(12);	scores.push_back(24);	scores.push_back(12);	scores.push_back(26);	scores.push_back(31);	scores.push_back(30);	scores.push_back(12);	scores.push_back(14);	scores.push_back(12);	scores.push_back(14);	scores.push_back(26);	scores.push_back(33);	scores.push_back(24);	scores.push_back(24);	scores.push_back(12);	read42.setScores(scores);
	ffastqReads.push_back(read42);
	FastqRead read43; read43.setName("M00967_44_000000000-A3K85_1_1101_24587_6131");
	read43.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTTGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(20);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(35);	scores.push_back(34);	scores.push_back(38);	scores.push_back(35);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(35);	scores.push_back(32);	scores.push_back(30);	scores.push_back(24);	scores.push_back(14);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read43.setScores(scores);
	ffastqReads.push_back(read43);
	FastqRead read44; read44.setName("M00967_44_000000000-A3K85_1_1101_10973_6275");
	read44.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGCCTGCCAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTACAGCCGTTGAAACTGCCGGGCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCAAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read44.setScores(scores);
	ffastqReads.push_back(read44);
	FastqRead read45; read45.setName("M00967_44_000000000-A3K85_1_1101_13172_6283");
	read45.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(30);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read45.setScores(scores);
	ffastqReads.push_back(read45);
	FastqRead read46; read46.setName("M00967_44_000000000-A3K85_1_1101_10990_6283");
	read46.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGCCTGCCAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTACAGCCGTTGAAACTGCCGGGCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCAAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(31);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(39);	scores.push_back(38);	scores.push_back(30);	scores.push_back(30);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(24);	scores.push_back(14);	scores.push_back(31);	scores.push_back(35);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(35);	scores.push_back(36);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read46.setScores(scores);
	ffastqReads.push_back(read46);
	FastqRead read47; read47.setName("M00967_44_000000000-A3K85_1_1101_18756_6332");
	read47.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATAACACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(15);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(28);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(24);	scores.push_back(13);	scores.push_back(15);	scores.push_back(25);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(13);	scores.push_back(15);	scores.push_back(15);	scores.push_back(25);	scores.push_back(25);	scores.push_back(32);	scores.push_back(14);	scores.push_back(13);	scores.push_back(12);	scores.push_back(26);	read47.setScores(scores);
	ffastqReads.push_back(read47);
	FastqRead read48; read48.setName("M00967_44_000000000-A3K85_1_1101_23297_6573");
	read48.setSeq("TACGTAGGTGGCAAGCGTTGTCCGGATTTACTGGGTGTAAAGGGCGTGCAGCCGGAGAGACAAGTCAGATGTGAAATCCACGGGCTCAACCCGTGAACTGCATTTGAAACTGTTTCCCTTGAGTGTCGGAGAGGTCATCGGAATTCCTTGTGTAGCGGTGAAATGCGTAGATATAAGGAAGAACACCAGTGGCGAAGGCGGATGACTGGACGATAACTGACGGTGAGGCGCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(13);	read48.setScores(scores);
	ffastqReads.push_back(read48);
	FastqRead read49; read49.setName("M00967_44_000000000-A3K85_1_1101_17839_6735");
	read49.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCAGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	read49.setScores(scores);
	ffastqReads.push_back(read49);
	FastqRead read50; read50.setName("M00967_44_000000000-A3K85_1_1101_22930_6755");
	read50.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTTGTGCAAGTCTGAAGTGAAAGCCCGCGGCTCAACTGCGGAACGGCTTTGGAAACTGTGTAACTGGAGTGCTGGAGAGGTAAGCGGAATTCCTGGTGTAGCGGTGAAATGCGTAGAGATCAGGAGGAACACCGGCGGCGAAGGCGGCTTACTGGACAGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(30);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(14);	scores.push_back(33);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(34);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(32);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(13);	scores.push_back(25);	scores.push_back(38);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(30);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(32);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(13);	scores.push_back(32);	scores.push_back(37);	scores.push_back(12);	scores.push_back(12);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(24);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(13);	scores.push_back(32);	scores.push_back(37);	scores.push_back(33);	scores.push_back(24);	scores.push_back(13);	read50.setScores(scores);
	ffastqReads.push_back(read50);
	FastqRead read51; read51.setName("M00967_44_000000000-A3K85_1_1101_10511_6811");
	read51.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(13);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(14);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read51.setScores(scores);
	ffastqReads.push_back(read51);
	FastqRead read52; read52.setName("M00967_44_000000000-A3K85_1_1101_21910_6926");
	read52.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read52.setScores(scores);
	ffastqReads.push_back(read52);
	FastqRead read53; read53.setName("M00967_44_000000000-A3K85_1_1101_6027_7033");
	read53.setSeq("TACGGAGGATGCGAACGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGTCAAGTCAGCGGTAAAATTGTGGAGCTCAACTCCATCGAGCCGTTGAAACTGACGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAAGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(34);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(13);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read53.setScores(scores);
	ffastqReads.push_back(read53);
	FastqRead read54; read54.setName("M00967_44_000000000-A3K85_1_1101_21920_7059");
	read54.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGCGCCAAGTCTGGAGTGAAATGCCGCAGCTTAACTGCGGAACTGCTTTGGAAACTGGCGAACTAGAGTGCGGGAGGGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCGGTGGCGAAGGCGGCTTACTGGACCGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read54.setScores(scores);
	ffastqReads.push_back(read54);
	FastqRead read55; read55.setName("M00967_44_000000000-A3K85_1_1101_21937_7124");
	read55.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGTCCGTTAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTCGAGCCGTTGAAACTGGCAGACTTGAGTTGGCGAGAAGTACGCGGAATGCGCGGTGTAGCGGTGAAATGCATAGATATCGCGCAGAACTCCGATTGCGAAGGCAGCGTACCGGCGCCAGACTGACGCTGAGGCACGCAAGCGTGGGGATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(26);	scores.push_back(31);	scores.push_back(29);	scores.push_back(36);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(13);	scores.push_back(13);	scores.push_back(36);	scores.push_back(35);	scores.push_back(13);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	read55.setScores(scores);
	ffastqReads.push_back(read55);
	FastqRead read56; read56.setName("M00967_44_000000000-A3K85_1_1101_14128_7160");
	read56.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(18);	scores.push_back(38);	scores.push_back(32);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(36);	scores.push_back(35);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(31);	scores.push_back(35);	scores.push_back(35);	scores.push_back(14);	scores.push_back(27);	scores.push_back(38);	scores.push_back(39);	scores.push_back(35);	scores.push_back(17);	scores.push_back(35);	scores.push_back(38);	scores.push_back(30);	scores.push_back(27);	scores.push_back(27);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(31);	scores.push_back(32);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(30);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(37);	scores.push_back(38);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(30);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(36);	scores.push_back(13);	scores.push_back(25);	scores.push_back(32);	scores.push_back(13);	scores.push_back(37);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(25);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(13);	scores.push_back(13);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(13);	scores.push_back(26);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(13);	scores.push_back(26);	scores.push_back(25);	read56.setScores(scores);
	ffastqReads.push_back(read56);
	FastqRead read57; read57.setName("M00967_44_000000000-A3K85_1_1101_4815_7242");
	read57.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGCCTGCCAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTACAGCCGTTGAAACTGCCGGGCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCAAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(24);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(26);	scores.push_back(26);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	read57.setScores(scores);
	ffastqReads.push_back(read57);
	FastqRead read58; read58.setName("M00967_44_000000000-A3K85_1_1101_12541_7269");
	read58.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCATTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(18);	scores.push_back(29);	scores.push_back(29);	scores.push_back(32);	scores.push_back(17);	scores.push_back(32);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(38);	scores.push_back(32);	scores.push_back(30);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(17);	scores.push_back(32);	scores.push_back(36);	scores.push_back(36);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(20);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(35);	scores.push_back(36);	scores.push_back(18);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(30);	scores.push_back(38);	scores.push_back(34);	scores.push_back(35);	scores.push_back(30);	scores.push_back(36);	scores.push_back(36);	scores.push_back(30);	scores.push_back(15);	scores.push_back(36);	scores.push_back(36);	scores.push_back(31);	scores.push_back(30);	scores.push_back(36);	scores.push_back(35);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(18);	scores.push_back(30);	scores.push_back(37);	scores.push_back(18);	scores.push_back(14);	scores.push_back(30);	scores.push_back(14);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(32);	scores.push_back(39);	scores.push_back(35);	scores.push_back(31);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(33);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(16);	scores.push_back(37);	scores.push_back(30);	scores.push_back(27);	scores.push_back(14);	scores.push_back(27);	scores.push_back(31);	scores.push_back(12);	scores.push_back(27);	scores.push_back(15);	scores.push_back(35);	scores.push_back(35);	scores.push_back(38);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(31);	scores.push_back(32);	scores.push_back(15);	scores.push_back(15);	scores.push_back(27);	scores.push_back(27);	scores.push_back(32);	scores.push_back(12);	scores.push_back(26);	scores.push_back(36);	scores.push_back(34);	scores.push_back(25);	scores.push_back(15);	scores.push_back(34);	scores.push_back(30);	scores.push_back(12);	scores.push_back(26);	scores.push_back(34);	scores.push_back(37);	scores.push_back(15);	scores.push_back(34);	scores.push_back(15);	scores.push_back(24);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(33);	scores.push_back(31);	scores.push_back(33);	scores.push_back(14);	scores.push_back(37);	scores.push_back(15);	scores.push_back(26);	scores.push_back(33);	scores.push_back(32);	scores.push_back(31);	scores.push_back(24);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(13);	scores.push_back(12);	scores.push_back(12);	scores.push_back(24);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(27);	scores.push_back(33);	scores.push_back(33);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(33);	scores.push_back(14);	scores.push_back(25);	scores.push_back(33);	scores.push_back(36);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(24);	scores.push_back(37);	scores.push_back(33);	scores.push_back(14);	scores.push_back(32);	scores.push_back(30);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	read58.setScores(scores);
	ffastqReads.push_back(read58);
	FastqRead read59; read59.setName("M00967_44_000000000-A3K85_1_1101_9919_7301");
	read59.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGCCAAGTCAGCGGTAAAAAAGCGGTGCTCAACGCCGTCGAGCCGTTGAAACTGGCGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(13);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(36);	scores.push_back(37);	scores.push_back(36);	scores.push_back(12);	scores.push_back(37);	read59.setScores(scores);
	ffastqReads.push_back(read59);
	FastqRead read60; read60.setName("M00967_44_000000000-A3K85_1_1101_5214_7309");
	read60.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCGGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCCTACCGGCGCGCAACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(34);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(18);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(32);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(32);	scores.push_back(38);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(27);	scores.push_back(31);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(31);	scores.push_back(26);	scores.push_back(13);	scores.push_back(31);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(35);	scores.push_back(30);	scores.push_back(37);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(14);	scores.push_back(37);	scores.push_back(13);	scores.push_back(31);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(33);	scores.push_back(13);	scores.push_back(31);	scores.push_back(12);	scores.push_back(12);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(26);	scores.push_back(32);	scores.push_back(37);	scores.push_back(32);	scores.push_back(14);	scores.push_back(13);	scores.push_back(26);	scores.push_back(13);	scores.push_back(31);	scores.push_back(12);	scores.push_back(13);	scores.push_back(25);	scores.push_back(25);	scores.push_back(33);	scores.push_back(32);	scores.push_back(32);	scores.push_back(14);	scores.push_back(13);	scores.push_back(12);	scores.push_back(25);	read60.setScores(scores);
	ffastqReads.push_back(read60);
	FastqRead read61; read61.setName("M00967_44_000000000-A3K85_1_1101_10336_7408");
	read61.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGATGCAAGTCTGAAGTGAAAGGCGGGGGCTCAACCCCCGGACTGCTTTGGAAACTGTATGACTGGAGTGCAGGAGAGGTAAGTGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(27);	scores.push_back(36);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(27);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read61.setScores(scores);
	ffastqReads.push_back(read61);
	FastqRead read62; read62.setName("M00967_44_000000000-A3K85_1_1101_4870_7443");
	read62.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGATGCAAGTCTGAAGTGAAAGGCGGGGGCTCAACCCCCGGACTGCTTTGGAAACTGTATGACTGGAGTGCAGGAGAGGTAAGTGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(32);	scores.push_back(32);	scores.push_back(18);	scores.push_back(29);	scores.push_back(29);	scores.push_back(34);	scores.push_back(37);	scores.push_back(32);	scores.push_back(30);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(20);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(33);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(35);	scores.push_back(36);	scores.push_back(32);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(16);	scores.push_back(37);	scores.push_back(36);	scores.push_back(35);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(31);	scores.push_back(36);	scores.push_back(38);	scores.push_back(34);	scores.push_back(31);	scores.push_back(34);	scores.push_back(31);	scores.push_back(14);	scores.push_back(30);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(34);	scores.push_back(36);	scores.push_back(38);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(34);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(37);	scores.push_back(31);	scores.push_back(33);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(33);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(32);	scores.push_back(37);	scores.push_back(24);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(12);	scores.push_back(28);	scores.push_back(29);	scores.push_back(35);	scores.push_back(36);	scores.push_back(26);	scores.push_back(33);	scores.push_back(30);	scores.push_back(33);	scores.push_back(29);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(14);	scores.push_back(36);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(24);	scores.push_back(13);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(24);	scores.push_back(13);	scores.push_back(24);	scores.push_back(12);	scores.push_back(13);	scores.push_back(25);	scores.push_back(25);	scores.push_back(14);	scores.push_back(24);	scores.push_back(24);	scores.push_back(24);	scores.push_back(12);	scores.push_back(29);	scores.push_back(12);	scores.push_back(13);	scores.push_back(24);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(33);	scores.push_back(32);	scores.push_back(13);	read62.setScores(scores);
	ffastqReads.push_back(read62);
	FastqRead read63; read63.setName("M00967_44_000000000-A3K85_1_1101_15991_7498");
	read63.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read63.setScores(scores);
	ffastqReads.push_back(read63);
	FastqRead read64; read64.setName("M00967_44_000000000-A3K85_1_1101_10419_7547");
	read64.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTTTTAAGTCAGCGGTAAAAATTCGGGGCTCAACCCCGTCCGGCCGTTGAAACTGGGGGCCTTGAGTGGGCGAGAAGAAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCCTTCCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(12);	scores.push_back(12);	scores.push_back(33);	scores.push_back(26);	scores.push_back(12);	scores.push_back(26);	scores.push_back(32);	scores.push_back(35);	scores.push_back(13);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read64.setScores(scores);
	ffastqReads.push_back(read64);
	FastqRead read65; read65.setName("M00967_44_000000000-A3K85_1_1101_22469_7553");
	read65.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGCAGCGCAAGTCTGGAGTGAAATGCCGGGGCCCAACCCCGGAACTGCTTTGGAAACTGTGCAGCTCGAGTGCAGGAGAGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATACGGAGGAACACCAGTGGCGAAGGCGGATTGCTGGACAGTAACTGACGCTGAGGCGCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(32);	scores.push_back(33);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(31);	scores.push_back(33);	scores.push_back(36);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(32);	read65.setScores(scores);
	ffastqReads.push_back(read65);
	FastqRead read66; read66.setName("M00967_44_000000000-A3K85_1_1101_10312_7727");
	read66.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTTTTAAGTCAGCGGTAAAAATTCGGGGCTCAACCCCGTCCGGCCGTTGAAACTGGGGGCCTTGAGTGGGCGAGAAGAAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCCTTCCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(35);	scores.push_back(31);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(26);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(33);	scores.push_back(33);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(24);	scores.push_back(35);	scores.push_back(35);	scores.push_back(26);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(15);	scores.push_back(26);	scores.push_back(33);	scores.push_back(15);	scores.push_back(25);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(32);	scores.push_back(36);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(31);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(24);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	read66.setScores(scores);
	ffastqReads.push_back(read66);
	FastqRead read67; read67.setName("M00967_44_000000000-A3K85_1_1101_11399_7830");
	read67.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGCCTGCCAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTACAGCCGTTGAAACTGCCGGGCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCAAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read67.setScores(scores);
	ffastqReads.push_back(read67);
	FastqRead read68; read68.setName("M00967_44_000000000-A3K85_1_1101_17905_7831");
	read68.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCGAAGGCAGCTCACTGGACTGCAACTGACACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(28);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(16);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	read68.setScores(scores);
	ffastqReads.push_back(read68);
	FastqRead read69; read69.setName("M00967_44_000000000-A3K85_1_1101_20714_8004");
	read69.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGCGCCAAGTCTGGAGTGAAATGCCGCAGCTTAACTGCGGAACTGCTTTGGAAACTGGCGAACTAGAGTGCGGGAGGGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCGGTGGCGAAGGCGGCTTACTGGACCGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(32);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(33);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(26);	scores.push_back(29);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(33);	scores.push_back(32);	scores.push_back(32);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(31);	scores.push_back(35);	scores.push_back(13);	scores.push_back(37);	scores.push_back(24);	scores.push_back(24);	scores.push_back(13);	read69.setScores(scores);
	ffastqReads.push_back(read69);
	FastqRead read70; read70.setName("M00967_44_000000000-A3K85_1_1101_26645_8005");
	read70.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCGAAGGCAGCTCACTGGACTGCAACTGACACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(32);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(17);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(36);	scores.push_back(27);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(35);	scores.push_back(13);	scores.push_back(13);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(30);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(25);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(13);	read70.setScores(scores);
	ffastqReads.push_back(read70);
	FastqRead read71; read71.setName("M00967_44_000000000-A3K85_1_1101_26632_8017");
	read71.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGGCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCGAAGGCAGCTCACTGGACTGCAACTGACACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(30);	scores.push_back(32);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(30);	scores.push_back(37);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(34);	scores.push_back(20);	scores.push_back(33);	scores.push_back(36);	scores.push_back(36);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(18);	scores.push_back(33);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(19);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(14);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(17);	scores.push_back(30);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(31);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(15);	scores.push_back(34);	scores.push_back(27);	scores.push_back(36);	scores.push_back(34);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(30);	scores.push_back(34);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(15);	scores.push_back(15);	scores.push_back(37);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(35);	scores.push_back(13);	scores.push_back(24);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(14);	scores.push_back(26);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(24);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(29);	scores.push_back(13);	scores.push_back(32);	scores.push_back(13);	scores.push_back(14);	scores.push_back(33);	scores.push_back(14);	scores.push_back(24);	scores.push_back(13);	scores.push_back(32);	scores.push_back(13);	scores.push_back(25);	scores.push_back(26);	scores.push_back(14);	scores.push_back(33);	scores.push_back(24);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	read71.setScores(scores);
	ffastqReads.push_back(read71);
	FastqRead read72; read72.setName("M00967_44_000000000-A3K85_1_1101_22157_8061");
	read72.setSeq("TACGTATGGTGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGCAGGCGGTACGGCAAGTCTGATGTGAAAGCCCAGGGCTCAACCCTGGTACTGCATTGGAAACTGCCGGACTAGAGTGTCGGAGGGGTAAGTGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACGATGACTGACGCTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(34);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(13);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(33);	scores.push_back(24);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read72.setScores(scores);
	ffastqReads.push_back(read72);
	FastqRead read73; read73.setName("M00967_44_000000000-A3K85_1_1101_13719_8076");
	read73.setSeq("TACGTAGGTGGCAAGCGTTATCCGGAATTATTGGGCGTAAAGAGCGCGCAGGTGGTTAATTAAGTCTGATGTGAAAGCCCACGGCTTAACCGTGGAGGGTCATTGGAAACTGGTTGACTTGAGTGCAGAAGAGGGAAGTGGAATTCCATGTGTAGCGGTGAAATGCGTAGAGATATGGAGGAACACCAGTGGCGAAGGCGGCTTCCTGGTCTGCAACTGACACTGAGGCGCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(35);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(31);	scores.push_back(13);	scores.push_back(32);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(34);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(35);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read73.setScores(scores);
	ffastqReads.push_back(read73);
	FastqRead read74; read74.setName("M00967_44_000000000-A3K85_1_1101_15650_8190");
	read74.setSeq("TACAGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGGATGCCAAGTCAGCGGTCAAATTTCGGGGCTCAACCCCGACCTGCCGTTGAAACTGGTGTCCTAGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(35);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(16);	scores.push_back(37);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(34);	scores.push_back(27);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(24);	scores.push_back(14);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(31);	scores.push_back(29);	scores.push_back(28);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(32);	scores.push_back(34);	scores.push_back(26);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(32);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(36);	scores.push_back(35);	scores.push_back(32);	scores.push_back(35);	scores.push_back(12);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(33);	scores.push_back(13);	scores.push_back(29);	scores.push_back(37);	read74.setScores(scores);
	ffastqReads.push_back(read74);
	FastqRead read75; read75.setName("M00967_44_000000000-A3K85_1_1101_12248_8236");
	read75.setSeq("TACGTAGGATCCGAGCATTATCCGGAGTGACTGGGTGTAAAGAGTTGCGTAGGTGGCATAGTAAGTAGCTAGTGAAATCTGGTGGCTCAACCATTCAGACTATTAGCTAAACTGCTAAGCTCGAGACCGTTAGGGGTAACTGGAATTTCTAGTGTAGGAGTGAAATCCGTAGATATTAGAAGGAACACCGATAGCGTAGGCAGGTTACTGGGACGGTTCTGACACTAAGGCACGAAAGCGTAGGGAGCAAA");
	scores.clear();		scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(30);	scores.push_back(29);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(20);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(31);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	read75.setScores(scores);
	ffastqReads.push_back(read75);
	FastqRead read76; read76.setName("M00967_44_000000000-A3K85_1_1101_18646_8324");
	read76.setSeq("TACGTAGGTGGCAAGCGTTATCCGGAATTATTGGGCGTAAAGAGCGCGCAGGTGGTTAATTAAGTCTGATGTGAAAGCCCACGGCTTAACCGTGGAGGGTCATTGGAAACTGGTTGACTTGAGTGCAGAAGAGGGAAGTGGAATTCCATGTGTAGCGGTGAAATGCGTAGAGATATGGAGGAACACCAGTGGCGAAGGCGGCTTCCTGGTCTGCAACTGACACTGAGGCGCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(30);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read76.setScores(scores);
	ffastqReads.push_back(read76);
	FastqRead read77; read77.setName("M00967_44_000000000-A3K85_1_1101_10827_8327");
	read77.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCGGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(25);	read77.setScores(scores);
	ffastqReads.push_back(read77);
	FastqRead read78; read78.setName("M00967_44_000000000-A3K85_1_1101_13846_8328");
	read78.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGGATGCCAAGTCAGCGGTCAAATTTCGGGGCTCAACCCCGACCTGCCGTTGAAACTGGTGTCCTAGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCAACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(30);	scores.push_back(25);	scores.push_back(35);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read78.setScores(scores);
	ffastqReads.push_back(read78);
	FastqRead read79; read79.setName("M00967_44_000000000-A3K85_1_1101_19501_8358");
	read79.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTCCTGCAAGCCAGATGTGAAAGCCCGGGGCTCAACCCCGGGACTGCATTTGGAACTGTAAGGCTAGAGTGTCGGAGAGGCAGGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCCTGCTGGACGATGACTGACGTTGAGGCTCGAAAGCGGGGGGGGCAAAAA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(31);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(25);	scores.push_back(15);	scores.push_back(34);	scores.push_back(33);	scores.push_back(15);	scores.push_back(25);	scores.push_back(30);	scores.push_back(35);	scores.push_back(13);	scores.push_back(24);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(33);	scores.push_back(36);	scores.push_back(15);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(25);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(26);	scores.push_back(35);	scores.push_back(28);	scores.push_back(35);	scores.push_back(30);	scores.push_back(33);	scores.push_back(33);	scores.push_back(26);	scores.push_back(33);	scores.push_back(13);	scores.push_back(32);	scores.push_back(25);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(32);	scores.push_back(13);	scores.push_back(25);	scores.push_back(28);	scores.push_back(32);	scores.push_back(36);	scores.push_back(15);	scores.push_back(25);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(30);	scores.push_back(25);	scores.push_back(36);	scores.push_back(36);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(13);	scores.push_back(25);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(26);	scores.push_back(13);	scores.push_back(14);	scores.push_back(25);	scores.push_back(12);	scores.push_back(25);	scores.push_back(31);	scores.push_back(31);	scores.push_back(37);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(32);	scores.push_back(14);	scores.push_back(13);	read79.setScores(scores);
	ffastqReads.push_back(read79);
	FastqRead read80; read80.setName("M00967_44_000000000-A3K85_1_1101_4368_8424");
	read80.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(16);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(30);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(35);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(17);	scores.push_back(30);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(16);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(35);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(32);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(34);	scores.push_back(15);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(32);	scores.push_back(30);	scores.push_back(30);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(15);	scores.push_back(15);	scores.push_back(24);	scores.push_back(15);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(15);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(12);	scores.push_back(12);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(15);	scores.push_back(33);	scores.push_back(36);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(25);	scores.push_back(25);	scores.push_back(15);	scores.push_back(32);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(13);	scores.push_back(12);	scores.push_back(26);	read80.setScores(scores);
	ffastqReads.push_back(read80);
	FastqRead read81; read81.setName("M00967_44_000000000-A3K85_1_1101_12165_8481");
	read81.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGTGCGGGGATCAAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(29);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read81.setScores(scores);
	ffastqReads.push_back(read81);
	FastqRead read82; read82.setName("M00967_44_000000000-A3K85_1_1101_19660_8492");
	read82.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read82.setScores(scores);
	ffastqReads.push_back(read82);
	FastqRead read83; read83.setName("M00967_44_000000000-A3K85_1_1101_12259_8527");
	read83.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGACTCTCAAGTCAGCGGTCAAATCGCGGGGCTCAACCCCGTTCCGCCGTTGAAACTGGGAGCCTTGAGTGCGCGAGAAGTAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCCTACCGGCGCGCAACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(33);	scores.push_back(37);	read83.setScores(scores);
	ffastqReads.push_back(read83);
	FastqRead read84; read84.setName("M00967_44_000000000-A3K85_1_1101_21543_8616");
	read84.setSeq("TACGTAGGTGGCAAGCGTTGTCCGGATTTACTGGGTGTAAAGGGCGTGTAGCCGGGCTGACAAGTCAGATGTGAAATCCGGGGGCTCAACCCCCGAACTGCATTTGAAACTGTTGGTCTTGAGTATCGGAGAGGCAGGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCCTGCTGGACGACAACTGACGGGGAGGCGCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(25);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(35);	scores.push_back(35);	scores.push_back(38);	scores.push_back(32);	scores.push_back(15);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(13);	scores.push_back(33);	scores.push_back(33);	scores.push_back(35);	scores.push_back(24);	scores.push_back(13);	scores.push_back(27);	scores.push_back(33);	scores.push_back(37);	scores.push_back(36);	scores.push_back(35);	scores.push_back(26);	scores.push_back(35);	scores.push_back(28);	scores.push_back(35);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(28);	scores.push_back(35);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(28);	scores.push_back(29);	scores.push_back(35);	scores.push_back(13);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(12);	scores.push_back(27);	scores.push_back(31);	scores.push_back(29);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(34);	scores.push_back(26);	scores.push_back(12);	scores.push_back(35);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(13);	scores.push_back(27);	scores.push_back(32);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read84.setScores(scores);
	ffastqReads.push_back(read84);
	FastqRead read85; read85.setName("M00967_44_000000000-A3K85_1_1101_14268_8617");
	read85.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGTCAAGTCAGCGGTAAAATTGTGGAGCTCAACTCCATCGAGCCGTTGAAACTGACGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAAGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read85.setScores(scores);
	ffastqReads.push_back(read85);
	FastqRead read86; read86.setName("M00967_44_000000000-A3K85_1_1101_7231_8621");
	read86.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGCGATGCAAGTCTGAAGTGAAAGCCCGGGGCTCAACCCCGGGACTGCTTTGGAAACTGTATGGCTGGAGTGCTGGAGAGGCAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAAGAACACCAGTGGCGAAGGCGGCTTGCTGGACAGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(32);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(16);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(31);	scores.push_back(36);	scores.push_back(36);	scores.push_back(30);	scores.push_back(36);	scores.push_back(14);	scores.push_back(14);	scores.push_back(36);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(19);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(35);	scores.push_back(18);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(30);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(37);	scores.push_back(33);	scores.push_back(16);	scores.push_back(30);	scores.push_back(15);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(33);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(32);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(14);	scores.push_back(34);	scores.push_back(38);	scores.push_back(32);	scores.push_back(36);	scores.push_back(39);	scores.push_back(13);	scores.push_back(34);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(24);	scores.push_back(24);	scores.push_back(31);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(24);	scores.push_back(26);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read86.setScores(scores);
	ffastqReads.push_back(read86);
	FastqRead read87; read87.setName("M00967_44_000000000-A3K85_1_1101_19754_8653");
	read87.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGATCGTTAAGTCAGTGGTCAAATTGAGGGGCTCAACCCCTTCCCGCCATTGAAACTGGCGATCTTGAGTGGAAGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATGCCGGCTTCCTACTGACGCTGAAGCACGAAAGCGTGGGGATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read87.setScores(scores);
	ffastqReads.push_back(read87);
	FastqRead read88; read88.setName("M00967_44_000000000-A3K85_1_1101_13364_8671");
	read88.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCAAACA");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(17);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read88.setScores(scores);
	ffastqReads.push_back(read88);
	FastqRead read89; read89.setName("M00967_44_000000000-A3K85_1_1101_11138_8749");
	read89.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCGAAGGCAGCTCACTGGACTGCAACTGACACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(20);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(29);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(27);	scores.push_back(36);	scores.push_back(34);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(36);	scores.push_back(35);	scores.push_back(26);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(33);	scores.push_back(38);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(25);	scores.push_back(15);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	read89.setScores(scores);
	ffastqReads.push_back(read89);
	FastqRead read90; read90.setName("M00967_44_000000000-A3K85_1_1101_21574_8754");
	read90.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGTCAAGTCAGCGGTAAAATTGTGGAGCTCAACTCCATCGAGCCGTTGAAACTGACGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAAGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read90.setScores(scores);
	ffastqReads.push_back(read90);
	FastqRead read91; read91.setName("M00967_44_000000000-A3K85_1_1101_15243_8862");
	read91.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCGGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(34);	scores.push_back(37);	read91.setScores(scores);
	ffastqReads.push_back(read91);
	FastqRead read92; read92.setName("M00967_44_000000000-A3K85_1_1101_6881_8899");
	read92.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGCGCCAAGTCTGGAGTGAAATGCCGCAGCTTAACTGCGGAACTGCTTTGGAAACTGGCGGACTAGAGTGCGGGAGGGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCGGTGGCGAAGGCGGCTTACTGGACCGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(32);	scores.push_back(17);	scores.push_back(35);	scores.push_back(33);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read92.setScores(scores);
	ffastqReads.push_back(read92);
	FastqRead read93; read93.setName("M00967_44_000000000-A3K85_1_1101_5965_8984");
	read93.setSeq("TACGGAGGGGGCAAGCGTTATCCGGAATTACTGGGTGTAAAGGGAGCGTAGACGGTGATGCAAGTCTGGAGTGAAAGGCGGGGGCCCAACCCCCGGACTGCTCTGGAAACTGTGTAACTTGAGTGCAGGAGAGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(32);	scores.push_back(33);	scores.push_back(32);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(30);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(14);	scores.push_back(32);	scores.push_back(26);	scores.push_back(32);	scores.push_back(28);	scores.push_back(35);	scores.push_back(37);	scores.push_back(13);	scores.push_back(33);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(13);	read93.setScores(scores);
	ffastqReads.push_back(read93);
	FastqRead read94; read94.setName("M00967_44_000000000-A3K85_1_1101_12421_8991");
	read94.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGCCTGCCAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTACAGCCGTTGAAACTGCCGGGCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCAAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(36);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read94.setScores(scores);
	ffastqReads.push_back(read94);
	FastqRead read95; read95.setName("M00967_44_000000000-A3K85_1_1101_16416_9000");
	read95.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCGAAGGCAGCTCACTGGACTGCAACTGACACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(33);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(36);	scores.push_back(27);	scores.push_back(36);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read95.setScores(scores);
	ffastqReads.push_back(read95);
	FastqRead read96; read96.setName("M00967_44_000000000-A3K85_1_1101_5471_9031");
	read96.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCGAAGGCAGCTCACTGGACTGCAACTGACACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(31);	scores.push_back(32);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(33);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(14);	scores.push_back(32);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(14);	scores.push_back(26);	scores.push_back(24);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(13);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(13);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	read96.setScores(scores);
	ffastqReads.push_back(read96);
	FastqRead read97; read97.setName("M00967_44_000000000-A3K85_1_1101_20723_9042");
	read97.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGATGCAAGTCTGAAGTGAAAGGCGGGGGCTCAACCCCCGGACTGCTTTGGAAACTGTATGACTGGAGTGCAGGAGAGGTAAGTGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(36);	scores.push_back(35);	scores.push_back(36);	scores.push_back(36);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(12);	scores.push_back(27);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	read97.setScores(scores);
	ffastqReads.push_back(read97);
	FastqRead read98; read98.setName("M00967_44_000000000-A3K85_1_1101_13579_9062");
	read98.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGCGCCAAGTCTGGAGTGAAATGCCGCAGCTTAACTGCGGAACTGCTTTGGAAACTGGCGAACTAGAGTGCGGGAGGGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCGGTGGCGAAGGCGGCTTACTGGACCGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(25);	read98.setScores(scores);
	ffastqReads.push_back(read98);
	FastqRead read99; read99.setName("M00967_44_000000000-A3K85_1_1101_8534_9075");
	read99.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGACTCTCAAGTCAGCGGTCAAATCGCGGGGCTCAACCCCGTTCCGCCGTTGAAACTGGGAGCCTTGAGTGCGCGAGAAGTAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCCTACCGGCGCGCAACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read99.setScores(scores);
	ffastqReads.push_back(read99);
	FastqRead read100; read100.setName("M00967_44_000000000-A3K85_1_1101_24265_9168");
	read100.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGCGCCAAGTCTGGAGTGAAATGCCGCAGCTTAACTGCGGAACTGCTTTGGAAACTGGCGGACTAGAGTGCGGGAGGGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCGGTGGCGAAGGCGGCTTACTGGACCGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(35);	scores.push_back(13);	scores.push_back(32);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	read100.setScores(scores);
	ffastqReads.push_back(read100);
	FastqRead read101; read101.setName("M00967_44_000000000-A3K85_1_1101_24708_9299");
	read101.setSeq("TACGTAGGTGGCAAGCGTTATCCGGATTTATTGGGCGTAAAGAGCGCGCAGGTGGTTAATTAAGTCTGATGTGAAAGCCCACGGCTTAACCGTGGAGGGTCATTGGAAACTGGTTGACTTGAGTGCAGAAGAGGGAAGTGGAATTCCATGTGTAGCGGTGAAATGCGTAGAGATATGGAGGAACACCAGTGGCGAAGGCGGCTTCCTGGTCTGCAACTGACACTGAGGCGCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(17);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read101.setScores(scores);
	ffastqReads.push_back(read101);
	FastqRead read102; read102.setName("M00967_44_000000000-A3K85_1_1101_12689_9330");
	read102.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGATGCAAGTCTGAAGTGAAAGGCGGGGGCTCAACCCCCGGACTGCTTTGGAAACTGTATGACTGGAGTGCAGGAGAGGTAAGTGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTCTCTGGTCTGCAACTGACGCTGAGGCTCGAAAGCATGGGTAGCGAACG");
	scores.clear();		scores.push_back(33);	scores.push_back(32);	scores.push_back(33);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(13);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(15);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(15);	scores.push_back(31);	scores.push_back(12);	scores.push_back(28);	scores.push_back(32);	scores.push_back(12);	read102.setScores(scores);
	ffastqReads.push_back(read102);
	FastqRead read103; read103.setName("M00967_44_000000000-A3K85_1_1101_27735_9353");
	read103.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGATGCAAGTCTGAAGTGAAAGGCGGGGGCTCAACCCCCGGACTGCTTTGGAAACTGTATGACTGGAGTGCAGGAGAGGTAAGTGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(34);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(24);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(14);	scores.push_back(32);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(32);	read103.setScores(scores);
	ffastqReads.push_back(read103);
	FastqRead read104; read104.setName("M00967_44_000000000-A3K85_1_1101_19351_9374");
	read104.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGACAGTTAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCCCGCCGTTGAAACTGATTGTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCAACTGACGCTGAAGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read104.setScores(scores);
	ffastqReads.push_back(read104);
	FastqRead read105; read105.setName("M00967_44_000000000-A3K85_1_1101_13561_9427");
	read105.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGGGTGGGGATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(30);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(35);	scores.push_back(39);	scores.push_back(37);	scores.push_back(18);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(30);	scores.push_back(27);	scores.push_back(36);	scores.push_back(32);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(17);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(35);	scores.push_back(16);	scores.push_back(28);	scores.push_back(30);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(35);	scores.push_back(30);	scores.push_back(12);	scores.push_back(34);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(30);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(35);	scores.push_back(30);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(38);	scores.push_back(27);	scores.push_back(12);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(15);	scores.push_back(27);	scores.push_back(15);	scores.push_back(25);	scores.push_back(15);	scores.push_back(27);	scores.push_back(27);	scores.push_back(34);	scores.push_back(13);	scores.push_back(25);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(13);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(28);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(13);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(15);	scores.push_back(33);	scores.push_back(30);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(13);	scores.push_back(13);	scores.push_back(27);	scores.push_back(13);	scores.push_back(29);	scores.push_back(35);	scores.push_back(12);	scores.push_back(13);	scores.push_back(33);	scores.push_back(36);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(30);	scores.push_back(12);	scores.push_back(27);	read105.setScores(scores);
	ffastqReads.push_back(read105);
	FastqRead read106; read106.setName("M00967_44_000000000-A3K85_1_1101_8736_9452");
	read106.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGGATGCCAAGTCAGCGGTCAAATTTCGGGGCTCAACCCCGACCTGCCGTCGAAACTGGTGTCCTAGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCAACTGACGCTCCTGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(31);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(18);	scores.push_back(30);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(17);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(14);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(31);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(33);	scores.push_back(39);	scores.push_back(33);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(28);	scores.push_back(37);	scores.push_back(26);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(13);	scores.push_back(24);	scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(14);	scores.push_back(33);	scores.push_back(26);	scores.push_back(32);	scores.push_back(24);	scores.push_back(32);	scores.push_back(13);	scores.push_back(14);	scores.push_back(14);	scores.push_back(33);	scores.push_back(14);	scores.push_back(33);	scores.push_back(32);	scores.push_back(13);	scores.push_back(25);	scores.push_back(35);	scores.push_back(13);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(13);	scores.push_back(24);	scores.push_back(32);	scores.push_back(24);	scores.push_back(33);	read106.setScores(scores);
	ffastqReads.push_back(read106);
	FastqRead read107; read107.setName("M00967_44_000000000-A3K85_1_1101_20139_9693");
	read107.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCGGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read107.setScores(scores);
	ffastqReads.push_back(read107);
	FastqRead read108; read108.setName("M00967_44_000000000-A3K85_1_1101_14330_9726");
	read108.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGGATGCCAAGTCAGCGGTCAAATTTCGGGGCTCAACCCCGACCTGCCGTTGAAACTGGTGTCCTAGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(35);	scores.push_back(35);	scores.push_back(30);	scores.push_back(35);	scores.push_back(34);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	read108.setScores(scores);
	ffastqReads.push_back(read108);
	FastqRead read109; read109.setName("M00967_44_000000000-A3K85_1_1101_10994_9747");
	read109.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGGATGCCAAGTCAGCGGTCAAATTTCGGGGCTCAACCCCGACCTGCCGTTGAAACTGGTGTCCTAGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCAACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(31);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(14);	scores.push_back(30);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(28);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(30);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(13);	scores.push_back(24);	scores.push_back(34);	scores.push_back(33);	scores.push_back(13);	scores.push_back(25);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(13);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read109.setScores(scores);
	ffastqReads.push_back(read109);
	FastqRead read110; read110.setName("M00967_44_000000000-A3K85_1_1101_3255_9762");
	read110.setSeq("TACGTAGGGGGCGAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTTCTGCAAGTCTGAAGTGAAAGCCCGTGGCTTAACCGCGGAACGGCTTTGGAAACTGTGGAACTGGAGTGCTGGAGAGGCAAGCGGAATTCCACTTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTGCTGGACAGAAACTGACGTTGAGGCTCGAAATCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(29);	scores.push_back(32);	scores.push_back(33);	scores.push_back(18);	scores.push_back(18);	scores.push_back(19);	scores.push_back(19);	scores.push_back(29);	scores.push_back(29);	scores.push_back(17);	scores.push_back(35);	scores.push_back(17);	scores.push_back(36);	scores.push_back(36);	scores.push_back(17);	scores.push_back(32);	scores.push_back(32);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(20);	scores.push_back(37);	scores.push_back(38);	scores.push_back(18);	scores.push_back(36);	scores.push_back(16);	scores.push_back(33);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(14);	scores.push_back(33);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(18);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(18);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(14);	scores.push_back(33);	scores.push_back(27);	scores.push_back(27);	scores.push_back(34);	scores.push_back(14);	scores.push_back(34);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(30);	scores.push_back(31);	scores.push_back(39);	scores.push_back(37);	scores.push_back(34);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(27);	scores.push_back(38);	scores.push_back(27);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(13);	scores.push_back(14);	scores.push_back(13);	scores.push_back(27);	scores.push_back(35);	scores.push_back(39);	scores.push_back(33);	scores.push_back(34);	scores.push_back(13);	scores.push_back(34);	scores.push_back(35);	scores.push_back(13);	scores.push_back(26);	scores.push_back(36);	scores.push_back(34);	scores.push_back(13);	scores.push_back(13);	scores.push_back(13);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(24);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(24);	scores.push_back(15);	scores.push_back(26);	scores.push_back(30);	scores.push_back(12);	scores.push_back(13);	scores.push_back(25);	scores.push_back(24);	scores.push_back(34);	scores.push_back(33);	scores.push_back(33);	scores.push_back(15);	scores.push_back(24);	scores.push_back(26);	scores.push_back(24);	scores.push_back(24);	scores.push_back(12);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(24);	scores.push_back(37);	scores.push_back(14);	scores.push_back(32);	scores.push_back(24);	scores.push_back(12);	scores.push_back(28);	scores.push_back(33);	scores.push_back(30);	scores.push_back(30);	scores.push_back(12);	scores.push_back(29);	scores.push_back(12);	scores.push_back(29);	scores.push_back(26);	scores.push_back(12);	scores.push_back(24);	scores.push_back(24);	scores.push_back(33);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(14);	scores.push_back(24);	scores.push_back(26);	scores.push_back(33);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(33);	scores.push_back(26);	scores.push_back(32);	scores.push_back(13);	scores.push_back(13);	scores.push_back(24);	scores.push_back(14);	scores.push_back(25);	scores.push_back(32);	scores.push_back(13);	scores.push_back(24);	scores.push_back(24);	scores.push_back(31);	scores.push_back(37);	scores.push_back(32);	scores.push_back(13);	scores.push_back(24);	scores.push_back(13);	scores.push_back(24);	scores.push_back(13);	scores.push_back(24);	scores.push_back(12);	scores.push_back(24);	scores.push_back(13);	scores.push_back(12);	scores.push_back(13);	scores.push_back(26);	scores.push_back(33);	scores.push_back(14);	scores.push_back(13);	scores.push_back(13);	read110.setScores(scores);
	ffastqReads.push_back(read110);
	FastqRead read111; read111.setName("M00967_44_000000000-A3K85_1_1101_21004_9829");
	read111.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGATGCAAGTCTGAAGTGAAAGGCGGGGGCTCAACCCCCGGACTGCTTTGGAAACTGTATGACTGGAGTGCAGGAGAGGTAAGTGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(31);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read111.setScores(scores);
	ffastqReads.push_back(read111);
	FastqRead read112; read112.setName("M00967_44_000000000-A3K85_1_1101_27704_9939");
	read112.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGATCGTTAAGTCAGTGGTCAAATTGAGGGGCTCAACCCCTTCCCGCCATTGAAACTGGCGATCTTGAGTGGAAGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATGCCGGCTTCCTACTGACGCTGAAGCACGAAAGCGTGGGGATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read112.setScores(scores);
	ffastqReads.push_back(read112);
	FastqRead read113; read113.setName("M00967_44_000000000-A3K85_1_1101_21801_9940");
	read113.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGTCAAGTCAGCGGTAAAATTGTGGAGCTCAACTCCATCGAGCCGTTGAAACTGACGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAAGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(24);	scores.push_back(35);	scores.push_back(37);	scores.push_back(32);	scores.push_back(24);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(25);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(36);	scores.push_back(14);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	read113.setScores(scores);
	ffastqReads.push_back(read113);
	FastqRead read114; read114.setName("M00967_44_000000000-A3K85_1_1101_14593_9947");
	read114.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGCGCGGCAAGTCTGAAGTGAAAGGCAGGGGCTTAACCCCTGAACTGCTTTGGAAACTGCCATGCTAGAGTGCTGGAGAGGTAAGTGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACAGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(27);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read114.setScores(scores);
	ffastqReads.push_back(read114);
	FastqRead read115; read115.setName("M00967_44_000000000-A3K85_1_1101_21550_10040");
	read115.setSeq("TACGTAGGGGGCAAGCGTTGTCCGGAATGACTGGGCGTAAAGGGAGTGTAGGCGGCTCATCAAGTTAGATGTGAAATCCCGCGGCTTAACCGCGGAACTGCATCTAAAACTGGTAAGCTGGAGTGCAGGAGAGGTGAGTGGAATTCCTAGTGTAGCGGTGGAATGCGTAGATATTAGGAGGAACACCAGAGGCGAAGGCGACTCACTGGACTGTAACTGACGCTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(30);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(30);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read115.setScores(scores);
	ffastqReads.push_back(read115);
	FastqRead read116; read116.setName("M00967_44_000000000-A3K85_1_1101_21278_10112");
	read116.setSeq("TACGGAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGGGCGCAGACGGCAGCGCAAGCCAGGAGTGAAAGCCCGGGGCCCAACCCCGGGACTGCTCTTGGAACTGCGCGGCTGGAGTGCAGGAGGGGCAGGCGGAATTCCTGGTGTAGCGGTGAAATGCGTAGATATCAGGAGGAACACCGGTGGCGAAGGCGGCCTGCTGGACTGCGACTGACGTTGAGGCCCGAAAGCGTGGGGGGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(13);	scores.push_back(24);	scores.push_back(24);	scores.push_back(31);	scores.push_back(30);	scores.push_back(15);	scores.push_back(24);	scores.push_back(33);	scores.push_back(15);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(26);	scores.push_back(31);	scores.push_back(33);	scores.push_back(32);	scores.push_back(13);	scores.push_back(28);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(26);	scores.push_back(28);	scores.push_back(35);	scores.push_back(15);	scores.push_back(33);	scores.push_back(13);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(12);	scores.push_back(31);	scores.push_back(32);	scores.push_back(35);	scores.push_back(14);	scores.push_back(32);	scores.push_back(13);	scores.push_back(32);	scores.push_back(29);	scores.push_back(35);	scores.push_back(26);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(36);	scores.push_back(37);	scores.push_back(32);	scores.push_back(13);	read116.setScores(scores);
	ffastqReads.push_back(read116);
	FastqRead read117; read117.setName("M00967_44_000000000-A3K85_1_1101_19330_10126");
	read117.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTTTTAAGTCAGCGGTAAAAATTCGGGGCTCAACCCCGTCCGGCCGTTGAAACTGGGGGCCTTGAGTGGGCGAGAAGAAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCCTTCCGGCGCCCTACTGACGCTGAGGCACGAAAGTGTGGGTATCAAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(16);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(25);	scores.push_back(15);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(24);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	read117.setScores(scores);
	ffastqReads.push_back(read117);
	FastqRead read118; read118.setName("M00967_44_000000000-A3K85_1_1101_9255_10164");
	read118.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTTTTAAGTCAGCGGTAAAAATTCGGGGCTCAACCCCGTCCGGCCGTTGAAACTGGGGGCCTTGAGTGGGCGAGAAGAAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCCTTCCGGCGCCCTACTGACGCTCAGGCACGAAAGCGCGGGGATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(16);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(29);	scores.push_back(36);	scores.push_back(37);	scores.push_back(16);	scores.push_back(37);	scores.push_back(18);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(14);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(18);	scores.push_back(15);	scores.push_back(18);	scores.push_back(33);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(14);	scores.push_back(35);	scores.push_back(14);	scores.push_back(27);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(13);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(35);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(27);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(34);	scores.push_back(12);	scores.push_back(25);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(27);	scores.push_back(32);	scores.push_back(14);	scores.push_back(27);	scores.push_back(37);	scores.push_back(30);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(13);	scores.push_back(35);	scores.push_back(37);	scores.push_back(14);	scores.push_back(24);	scores.push_back(12);	scores.push_back(31);	scores.push_back(33);	scores.push_back(37);	scores.push_back(12);	scores.push_back(34);	scores.push_back(32);	scores.push_back(32);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(27);	read118.setScores(scores);
	ffastqReads.push_back(read118);
	FastqRead read119; read119.setName("M00967_44_000000000-A3K85_1_1101_4387_10169");
	read119.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTTTTAAGTCAGCGGTAAAAATTCGGGGCTCAACCCCGTCCGGCCGTTGAAACTGGGGGCCTTGAGTGGGCGAGAAGAAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCCTTCCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(32);	scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(35);	scores.push_back(31);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(30);	scores.push_back(13);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	read119.setScores(scores);
	ffastqReads.push_back(read119);
	FastqRead read120; read120.setName("M00967_44_000000000-A3K85_1_1101_6605_10173");
	read120.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGCCAAGTCAGCGGTAAAAAAGCGGTGCTCAACGCCGTCGAGCCGTTGAAACTGGCGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACCG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(34);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(14);	scores.push_back(36);	scores.push_back(34);	scores.push_back(36);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(36);	scores.push_back(30);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(14);	scores.push_back(37);	scores.push_back(35);	scores.push_back(31);	scores.push_back(27);	scores.push_back(33);	scores.push_back(35);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(32);	scores.push_back(27);	scores.push_back(27);	scores.push_back(34);	scores.push_back(31);	scores.push_back(31);	scores.push_back(31);	scores.push_back(34);	scores.push_back(38);	scores.push_back(30);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(13);	scores.push_back(38);	scores.push_back(39);	scores.push_back(15);	scores.push_back(15);	scores.push_back(28);	scores.push_back(34);	scores.push_back(27);	scores.push_back(34);	scores.push_back(34);	scores.push_back(31);	scores.push_back(32);	scores.push_back(25);	scores.push_back(34);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(15);	scores.push_back(38);	scores.push_back(36);	scores.push_back(32);	scores.push_back(13);	scores.push_back(34);	scores.push_back(38);	scores.push_back(32);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(24);	scores.push_back(24);	scores.push_back(34);	scores.push_back(32);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(24);	scores.push_back(24);	scores.push_back(24);	scores.push_back(12);	scores.push_back(35);	scores.push_back(24);	scores.push_back(12);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(14);	scores.push_back(24);	scores.push_back(14);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(14);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(12);	scores.push_back(31);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(13);	scores.push_back(26);	scores.push_back(33);	scores.push_back(28);	scores.push_back(24);	scores.push_back(24);	scores.push_back(13);	scores.push_back(32);	scores.push_back(13);	scores.push_back(13);	scores.push_back(24);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(31);	scores.push_back(35);	scores.push_back(37);	scores.push_back(12);	scores.push_back(35);	scores.push_back(37);	scores.push_back(13);	scores.push_back(24);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(13);	scores.push_back(32);	scores.push_back(13);	scores.push_back(32);	scores.push_back(13);	scores.push_back(37);	scores.push_back(36);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(24);	scores.push_back(26);	scores.push_back(32);	scores.push_back(35);	scores.push_back(13);	scores.push_back(33);	scores.push_back(13);	scores.push_back(25);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(25);	scores.push_back(24);	scores.push_back(14);	scores.push_back(33);	scores.push_back(24);	scores.push_back(36);	scores.push_back(37);	scores.push_back(13);	scores.push_back(12);	scores.push_back(24);	read120.setScores(scores);
	ffastqReads.push_back(read120);
	FastqRead read121; read121.setName("M00967_44_000000000-A3K85_1_1101_6954_10206");
	read121.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGCCTGCCAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTTCCTCCGTTGAAACTGGGAGCCTTGAGTGCGCGAGAAGTAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCCTACCGGCGCGCAACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(31);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(28);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(13);	scores.push_back(35);	scores.push_back(28);	scores.push_back(34);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read121.setScores(scores);
	ffastqReads.push_back(read121);
	FastqRead read122; read122.setName("M00967_44_000000000-A3K85_1_1101_7527_10303");
	read122.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGTCAAGTCAGCGGTAAAATTGTGGAGCTCAACTCCATCGAGCCGTTGAAACTGACGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAAGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read122.setScores(scores);
	ffastqReads.push_back(read122);
	FastqRead read123; read123.setName("M00967_44_000000000-A3K85_1_1101_24337_10344");
	read123.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCGAAGGCAGCTCACTGGACTGCAACTGACACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(31);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	read123.setScores(scores);
	ffastqReads.push_back(read123);
	FastqRead read124; read124.setName("M00967_44_000000000-A3K85_1_1101_22387_10347");
	read124.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCTAAGGCAGCTCACTGGACTGCAACTGACACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(33);	scores.push_back(33);	scores.push_back(25);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(24);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(13);	read124.setScores(scores);
	ffastqReads.push_back(read124);
	FastqRead read125; read125.setName("M00967_44_000000000-A3K85_1_1101_18889_10362");
	read125.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGTCAAGTCAGCGGTAAAATTGTGGAGCTCAACTCCATCGAGCCGTTGAAACTGACGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAAGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read125.setScores(scores);
	ffastqReads.push_back(read125);
	FastqRead read126; read126.setName("M00967_44_000000000-A3K85_1_1101_18780_10395");
	read126.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGACTCTCAAGTCAGCGGTCAAATCGCGGGGCTCAACCCCGTTCCGCCGTTGAAACTGGGAGCCTTGAGTGCGCGAGAAGTAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCCTACCGGCGCGCAACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read126.setScores(scores);
	ffastqReads.push_back(read126);
	FastqRead read127; read127.setName("M00967_44_000000000-A3K85_1_1101_16939_10517");
	read127.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGTCCGTTAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTCGAGCCGTTGAAACTGGCAGACTTGAGTTGGCGAGAAGTACGCGGAATGCGCGGTGTAGCGGTGAAATGCATAGATATCGCGCAGAACTCCGATTGCGAAGGCAGCGTACCGGCGCCAGACTGACGCTGAGGCACGAAAGCGTGGGGATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(36);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read127.setScores(scores);
	ffastqReads.push_back(read127);
	FastqRead read128; read128.setName("M00967_44_000000000-A3K85_1_1101_26512_10524");
	read128.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGTCAAGTCAGCGGTAAAATTGTGGAGCTCAACTCCATCGAGCCGTTGAAACTGACGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAAGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read128.setScores(scores);
	ffastqReads.push_back(read128);
	FastqRead read129; read129.setName("M00967_44_000000000-A3K85_1_1101_26835_10541");
	read129.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTTTTAAGTCAGCGGTAAAAATTCGGGGCTCAACCCCGTCCGGCCGTTGAAACTGGGGGCCTTGAGTGGGCGAGAAGAAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCCTTCCGGCGCCCTACTGACGCTGAGGCACGAAAGGGCGGGGATCAAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(32);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(26);	scores.push_back(33);	scores.push_back(37);	scores.push_back(28);	scores.push_back(26);	scores.push_back(37);	scores.push_back(32);	scores.push_back(15);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(13);	scores.push_back(13);	scores.push_back(32);	scores.push_back(32);	scores.push_back(13);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(29);	scores.push_back(26);	scores.push_back(28);	scores.push_back(33);	scores.push_back(35);	scores.push_back(36);	scores.push_back(24);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read129.setScores(scores);
	ffastqReads.push_back(read129);
	FastqRead read130; read130.setName("M00967_44_000000000-A3K85_1_1101_25040_10597");
	read130.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCGAAGGCAGCTCACTGGACTGCAACTGACACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(31);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(33);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(19);	scores.push_back(37);	scores.push_back(38);	scores.push_back(33);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(31);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(27);	scores.push_back(31);	scores.push_back(31);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(36);	scores.push_back(27);	scores.push_back(34);	scores.push_back(32);	scores.push_back(38);	scores.push_back(32);	scores.push_back(27);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(34);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(30);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(15);	scores.push_back(15);	scores.push_back(13);	scores.push_back(12);	scores.push_back(36);	scores.push_back(13);	scores.push_back(13);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(13);	scores.push_back(14);	scores.push_back(24);	scores.push_back(26);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(24);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(29);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(26);	scores.push_back(14);	scores.push_back(14);	scores.push_back(26);	scores.push_back(24);	scores.push_back(30);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read130.setScores(scores);
	ffastqReads.push_back(read130);
	FastqRead read131; read131.setName("M00967_44_000000000-A3K85_1_1101_22851_10787");
	read131.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGACTCTCAAGTCAGCGGTCAAATCGCGGGGCTCAACCCCGTTCCGCCGTTGAAACTGGGAGCCTTGAGTGCGCGAGAAGTAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCCTACCGGCGCGCAACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read131.setScores(scores);
	ffastqReads.push_back(read131);
	FastqRead read132; read132.setName("M00967_44_000000000-A3K85_1_1101_16735_10948");
	read132.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGCAGCGCAAGTCTGGAGTGAAATGCCGGGGCCCAACCCCGGAACTGCTTTGGAAACTGTGCAGCTCGAGTGCAGGAGAGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(12);	scores.push_back(26);	scores.push_back(25);	scores.push_back(35);	scores.push_back(14);	scores.push_back(35);	scores.push_back(24);	scores.push_back(32);	scores.push_back(28);	scores.push_back(33);	scores.push_back(37);	scores.push_back(13);	scores.push_back(31);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(13);	read132.setScores(scores);
	ffastqReads.push_back(read132);
	FastqRead read133; read133.setName("M00967_44_000000000-A3K85_1_1101_22481_10976");
	read133.setSeq("TACGTAGGTGGCAAGCGTTGTCCGGATTTATTGGGCGTAAAGCGAGTGCAGGCGGTTCAATAAGTCTGATGTGAAAGCCTTCGGCTCAACCGGAGAATTGCATCAGAAACTGTTGAACTTGAGTGCAGAAGAGGAGAGTGGAACTCCATGTGTAGCGGTGGAATGCGTAGATATTTGGAAGAACACCAGTGGCGAAGGCGGCTCTCTGGTCTGCAACTGACGCTGAGGCTCGAAAGCATGGGGAGCGAACA");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(38);	scores.push_back(37);	scores.push_back(33);	scores.push_back(39);	scores.push_back(39);	scores.push_back(18);	scores.push_back(36);	scores.push_back(39);	scores.push_back(18);	scores.push_back(38);	scores.push_back(36);	scores.push_back(34);	scores.push_back(37);	scores.push_back(36);	scores.push_back(16);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(30);	scores.push_back(37);	scores.push_back(14);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(18);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(17);	scores.push_back(18);	scores.push_back(37);	scores.push_back(17);	scores.push_back(35);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(29);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(32);	scores.push_back(36);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(28);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(16);	scores.push_back(27);	scores.push_back(29);	scores.push_back(16);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(32);	scores.push_back(36);	scores.push_back(34);	scores.push_back(13);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(35);	scores.push_back(36);	scores.push_back(13);	scores.push_back(13);	scores.push_back(12);	scores.push_back(34);	scores.push_back(15);	scores.push_back(34);	scores.push_back(33);	scores.push_back(15);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(15);	scores.push_back(26);	scores.push_back(25);	scores.push_back(25);	scores.push_back(34);	scores.push_back(34);	scores.push_back(39);	scores.push_back(37);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(30);	scores.push_back(35);	scores.push_back(12);	scores.push_back(35);	scores.push_back(12);	scores.push_back(13);	scores.push_back(32);	scores.push_back(33);	scores.push_back(38);	scores.push_back(12);	scores.push_back(12);	scores.push_back(24);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(32);	scores.push_back(13);	scores.push_back(32);	scores.push_back(37);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(35);	scores.push_back(13);	scores.push_back(24);	scores.push_back(15);	scores.push_back(15);	scores.push_back(24);	scores.push_back(37);	scores.push_back(36);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(32);	scores.push_back(28);	scores.push_back(12);	scores.push_back(31);	scores.push_back(24);	scores.push_back(12);	read133.setScores(scores);
	ffastqReads.push_back(read133);
	FastqRead read134; read134.setName("M00967_44_000000000-A3K85_1_1101_18225_10999");
	read134.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGTTTGTCAAGTCAGCGGTAAAAATTCCGGGCTCAACCCGGTCCCGCCGTTGAAACTGGCGAACTCGAGAGGGAGAGAAGTAGGCGGAATGCGCAGTGTAGCGGTGAAATGCATAGATATTGCGCAGAACTCCGATTGCGAAGGCAGCCTACCGGCTCCTGTCTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(24);	scores.push_back(37);	read134.setScores(scores);
	ffastqReads.push_back(read134);
	FastqRead read135; read135.setName("M00967_44_000000000-A3K85_1_1101_13511_11032");
	read135.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCGGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(36);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(27);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(27);	scores.push_back(32);	scores.push_back(32);	scores.push_back(25);	scores.push_back(34);	scores.push_back(30);	scores.push_back(13);	scores.push_back(34);	scores.push_back(13);	scores.push_back(13);	scores.push_back(34);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(30);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(15);	scores.push_back(30);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(29);	scores.push_back(37);	scores.push_back(35);	scores.push_back(34);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(24);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(13);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(13);	scores.push_back(13);	scores.push_back(32);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(32);	scores.push_back(24);	scores.push_back(31);	scores.push_back(34);	scores.push_back(28);	scores.push_back(32);	scores.push_back(13);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(13);	scores.push_back(32);	scores.push_back(30);	scores.push_back(36);	scores.push_back(36);	scores.push_back(13);	scores.push_back(13);	scores.push_back(32);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	read135.setScores(scores);
	ffastqReads.push_back(read135);
	FastqRead read136; read136.setName("M00967_44_000000000-A3K85_1_1101_27264_11056");
	read136.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGACAGTTAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCCCGCCGTTGAAACTGATTGTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCAACTGACGCTGAAGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read136.setScores(scores);
	ffastqReads.push_back(read136);
	FastqRead read137; read137.setName("M00967_44_000000000-A3K85_1_1101_17213_11062");
	read137.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGCCAAGTCAGCGGTAAAAAAGCGGTGCTCAACGCCGTCGAGCCGTTGAAACTGGCGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(30);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(36);	scores.push_back(13);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read137.setScores(scores);
	ffastqReads.push_back(read137);
	FastqRead read138; read138.setName("M00967_44_000000000-A3K85_1_1101_18943_11082");
	read138.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGCTGTGCAAGTCTGAAGTGAAAGCCCAGGGCTCAACCCTGGGACTGCTTTGGAAACTGTGGAGCTAGAGTGCTGGAGAGGTAAGTGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACAGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	read138.setScores(scores);
	ffastqReads.push_back(read138);
	FastqRead read139; read139.setName("M00967_44_000000000-A3K85_1_1101_17868_11113");
	read139.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGCCTGCCAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTACAGCCGTTGAAACTGCCGGGCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGTGCGGGGATCAAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(15);	scores.push_back(24);	scores.push_back(32);	scores.push_back(37);	read139.setScores(scores);
	ffastqReads.push_back(read139);
	FastqRead read140; read140.setName("M00967_44_000000000-A3K85_1_1101_21158_11161");
	read140.setSeq("TACGGAGGATGCAAGCGTTAATCGGAATTACTGGGCGTAAAGCGCACGCAGGCGGTTTGTTAAGTCAGATGTGAAATCCCCGGGCTCAACCTGGGAACTGCATCTGATACTGGCAAGCTTGAGTCTCGTAGAGGGGGGTAGAATTCCAGGTGTAGCGGTGAAATGCGTAGAGATCTGGAGGAATACCGGTGGCGAAGGCGGCCCCCTGGACGAAGACTGACGCTCAGGTGCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(28);	scores.push_back(35);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(24);	scores.push_back(31);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(15);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(31);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(13);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(15);	scores.push_back(31);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(35);	scores.push_back(33);	scores.push_back(35);	scores.push_back(27);	scores.push_back(13);	scores.push_back(31);	scores.push_back(33);	scores.push_back(37);	scores.push_back(13);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(13);	read140.setScores(scores);
	ffastqReads.push_back(read140);
	FastqRead read141; read141.setName("M00967_44_000000000-A3K85_1_1101_14735_11235");
	read141.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTTTTAAGTCAGCGGTAAAAATTCGGGGCTCAACCCCGTCCGGCCGTTGAAACTGGGGGCCTTGAGTGGGCGAGAAGAAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCCTTCCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCGAACAG");
	scores.clear();		scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(18);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(38);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(33);	scores.push_back(30);	scores.push_back(24);	scores.push_back(35);	scores.push_back(33);	scores.push_back(31);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(13);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(25);	scores.push_back(32);	scores.push_back(35);	scores.push_back(29);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(32);	scores.push_back(24);	scores.push_back(24);	scores.push_back(32);	scores.push_back(32);	scores.push_back(32);	scores.push_back(13);	scores.push_back(32);	scores.push_back(13);	scores.push_back(24);	scores.push_back(25);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(14);	scores.push_back(31);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read141.setScores(scores);
	ffastqReads.push_back(read141);
	FastqRead read142; read142.setName("M00967_44_000000000-A3K85_1_1101_16074_11244");
	read142.setSeq("TACGGAGGATCCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCGAAGGCAGCTCACTGGAATGCAACTGAAACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(20);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(25);	scores.push_back(36);	scores.push_back(32);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(26);	scores.push_back(33);	scores.push_back(24);	scores.push_back(36);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(14);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(24);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(25);	scores.push_back(33);	scores.push_back(15);	scores.push_back(26);	scores.push_back(24);	scores.push_back(26);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(24);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(24);	scores.push_back(32);	scores.push_back(28);	scores.push_back(33);	scores.push_back(24);	scores.push_back(35);	scores.push_back(15);	scores.push_back(24);	scores.push_back(24);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(15);	scores.push_back(33);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(13);	read142.setScores(scores);
	ffastqReads.push_back(read142);
	FastqRead read143; read143.setName("M00967_44_000000000-A3K85_1_1101_7593_11252");
	read143.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGATGCAAGTCTGAAGTGAAAGGCGGGGGCTCAACCCCCGGACTGCTTTGGAAACTGTATGACTGGAGTGCAGGAGAGGTAAGTGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(15);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read143.setScores(scores);
	ffastqReads.push_back(read143);
	FastqRead read144; read144.setName("M00967_44_000000000-A3K85_1_1101_12857_11252");
	read144.setSeq("TACGTAGGTGGCAAGCGTTGTCCGGATTTACTGGGTGTAAAGGGCGTGCAGCCGGAGAGACAAGTCAGATGTGAAATCCACGGGCTCAACCCGTGAACTGCATTTGAAACTGTTTCCCTTGAGTGTCGGAGAGGTCATCGGAATTCCTTGTGTAGCGGTGAAATGCGTAGATATAAGGAAGAACACCAGTGGCGAAGGCGGATGACTGGACGATAACTGACGGTGAGGCGCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(32);	scores.push_back(32);	scores.push_back(33);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(20);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(32);	scores.push_back(37);	scores.push_back(36);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(17);	scores.push_back(32);	scores.push_back(32);	scores.push_back(36);	scores.push_back(16);	scores.push_back(32);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(15);	scores.push_back(36);	scores.push_back(30);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(33);	scores.push_back(18);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(35);	scores.push_back(36);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(35);	scores.push_back(36);	scores.push_back(32);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(32);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(26);	scores.push_back(37);	scores.push_back(24);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(13);	scores.push_back(13);	scores.push_back(32);	scores.push_back(14);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(32);	scores.push_back(26);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(26);	scores.push_back(32);	scores.push_back(14);	scores.push_back(32);	scores.push_back(35);	scores.push_back(32);	scores.push_back(33);	scores.push_back(12);	scores.push_back(28);	scores.push_back(13);	scores.push_back(31);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read144.setScores(scores);
	ffastqReads.push_back(read144);
	FastqRead read145; read145.setName("M00967_44_000000000-A3K85_1_1101_15147_11308");
	read145.setSeq("TACGTAGGTGGCAAGCGTTATCCGGATTTATTGGGTGTAAAGGGCGTGTAGGCGGGAATGCAAGTCAGATGTGAAAACTATGGGCTCAACCCATAGCCTGCATTTGAAACTGTATTTCTTGAGTGCTGGAGAGGCAATCGGAATTCCGTGTGTAGCGGTGAAATGCGTAGATATACGGAGGAACACCAGTGGCGAAGGCGGATTGCTGGACAGTAACTGACGCTGAGGCGCGAAAGCGTGGGGAGCAAAAA");
	scores.clear();		scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(17);	scores.push_back(36);	scores.push_back(17);	scores.push_back(32);	scores.push_back(36);	scores.push_back(35);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(34);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(18);	scores.push_back(35);	scores.push_back(35);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(14);	scores.push_back(37);	scores.push_back(33);	scores.push_back(34);	scores.push_back(18);	scores.push_back(33);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(15);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(18);	scores.push_back(18);	scores.push_back(38);	scores.push_back(39);	scores.push_back(18);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(35);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(14);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(16);	scores.push_back(28);	scores.push_back(36);	scores.push_back(35);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(13);	scores.push_back(36);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(25);	scores.push_back(34);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(30);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(36);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(12);	scores.push_back(32);	scores.push_back(37);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(24);	scores.push_back(13);	scores.push_back(15);	scores.push_back(13);	scores.push_back(15);	scores.push_back(15);	scores.push_back(15);	scores.push_back(26);	scores.push_back(25);	scores.push_back(33);	scores.push_back(15);	scores.push_back(15);	scores.push_back(26);	scores.push_back(13);	scores.push_back(26);	scores.push_back(35);	scores.push_back(30);	scores.push_back(25);	scores.push_back(36);	scores.push_back(24);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(25);	scores.push_back(31);	scores.push_back(32);	scores.push_back(24);	scores.push_back(26);	scores.push_back(24);	scores.push_back(24);	scores.push_back(32);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(13);	scores.push_back(25);	scores.push_back(25);	scores.push_back(32);	scores.push_back(33);	scores.push_back(33);	scores.push_back(24);	scores.push_back(24);	read145.setScores(scores);
	ffastqReads.push_back(read145);
	FastqRead read146; read146.setName("M00967_44_000000000-A3K85_1_1101_18698_11342");
	read146.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGGTGGCAGGGCAAGTCAGATGTGAAAACCCGGGGCTCAACCCCGGGAGTGCATTTGAAACTGTCCAGCTGGAGTGCAGGAGAGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCATAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACACTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(13);	scores.push_back(24);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(13);	scores.push_back(32);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	read146.setScores(scores);
	ffastqReads.push_back(read146);
	FastqRead read147; read147.setName("M00967_44_000000000-A3K85_1_1101_16136_11420");
	read147.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGCCTGCCAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTACAGCCGTTGAAACTGCCGGGCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGTGCGGGGATCAAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read147.setScores(scores);
	ffastqReads.push_back(read147);
	FastqRead read148; read148.setName("M00967_44_000000000-A3K85_1_1101_13333_11429");
	read148.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTCCTGCAAGCCAGATGTGAAAGCCCGGGGCTCAACCCCGGGACTGCATTTGGAACTGTAAGGCTAGAGTGTCGGAGAGGCAGGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCCTGCTGGACGATGACTGACGTTGAGGCTCGAAAGCGTGGGGGGCCAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(36);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(31);	scores.push_back(34);	scores.push_back(12);	scores.push_back(25);	scores.push_back(25);	scores.push_back(38);	scores.push_back(15);	scores.push_back(38);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(33);	scores.push_back(31);	scores.push_back(30);	scores.push_back(13);	scores.push_back(12);	scores.push_back(25);	scores.push_back(34);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(26);	scores.push_back(26);	scores.push_back(30);	scores.push_back(13);	scores.push_back(37);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(15);	scores.push_back(33);	scores.push_back(35);	scores.push_back(13);	scores.push_back(25);	scores.push_back(13);	scores.push_back(33);	scores.push_back(14);	scores.push_back(26);	scores.push_back(13);	scores.push_back(24);	scores.push_back(15);	scores.push_back(33);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(28);	scores.push_back(31);	scores.push_back(33);	scores.push_back(37);	scores.push_back(13);	scores.push_back(28);	scores.push_back(35);	scores.push_back(12);	scores.push_back(34);	scores.push_back(13);	scores.push_back(26);	scores.push_back(13);	scores.push_back(15);	scores.push_back(15);	scores.push_back(37);	scores.push_back(13);	scores.push_back(13);	scores.push_back(24);	scores.push_back(28);	scores.push_back(13);	scores.push_back(13);	scores.push_back(25);	scores.push_back(15);	scores.push_back(15);	scores.push_back(33);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(24);	scores.push_back(13);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(25);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(33);	scores.push_back(13);	scores.push_back(13);	scores.push_back(31);	scores.push_back(34);	scores.push_back(37);	scores.push_back(12);	scores.push_back(26);	scores.push_back(12);	scores.push_back(12);	scores.push_back(26);	scores.push_back(32);	scores.push_back(13);	scores.push_back(13);	read148.setScores(scores);
	ffastqReads.push_back(read148);
	FastqRead read149; read149.setName("M00967_44_000000000-A3K85_1_1101_10743_11432");
	read149.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGCCTGCCAAGTCAGCGGTAAAATTGCGGGGCTCAACCCCGTACAGCCGTTGAAACTGCCGGGCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCAAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(26);	scores.push_back(35);	scores.push_back(34);	scores.push_back(31);	scores.push_back(32);	scores.push_back(13);	scores.push_back(24);	scores.push_back(25);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read149.setScores(scores);
	ffastqReads.push_back(read149);
	FastqRead read150; read150.setName("M00967_44_000000000-A3K85_1_1101_28944_11444");
	read150.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(18);	scores.push_back(32);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read150.setScores(scores);
	ffastqReads.push_back(read150);
	FastqRead read151; read151.setName("M00967_44_000000000-A3K85_1_1101_20676_11509");
	read151.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGCGGGGCAAGTCTGGAGTGAAAGGCCGGGGCCCAACCCCGGGACCGCTCTGGAAACTGCCCGGCTGGAGTGCGGGAGAGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGCGGCGAAGGCGGCTTACTGGACCGTGACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(13);	scores.push_back(30);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(13);	read151.setScores(scores);
	ffastqReads.push_back(read151);
	FastqRead read152; read152.setName("M00967_44_000000000-A3K85_1_1101_17571_11522");
	read152.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGTGTTTAAAGGGTGCGTAGGCGGGCTTTTAAGTCAGCGGTAAAAATTCGGGGCTCAACCCCGTCCGGCCGTTGAAACTGGGGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCAACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	read152.setScores(scores);
	ffastqReads.push_back(read152);
	FastqRead read153; read153.setName("M00967_44_000000000-A3K85_1_1101_14976_11522");
	read153.setSeq("TACGTAGGGGGCAAGCGTTATCCGGAATTACTGGGTGTAAAGGGAGCGTAGACGGTGATGCAAGTCTGGAGTGAAAGGCGGGGGCCCAACCCCCGGACTGCTCTGGAAACTGTGTAACTTGAGTGCAGGAGAGGTAAGCGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(13);	scores.push_back(36);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(12);	scores.push_back(26);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(13);	scores.push_back(31);	scores.push_back(13);	scores.push_back(24);	scores.push_back(14);	scores.push_back(33);	scores.push_back(32);	scores.push_back(13);	read153.setScores(scores);
	ffastqReads.push_back(read153);
	FastqRead read154; read154.setName("M00967_44_000000000-A3K85_1_1101_17702_11563");
	read154.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTTTTAAGTCAGCGGTAAAAATTCGGGGCTCAACCCCGTCCGGCCGTTGAAACTGGGGGCCTTGAGTGGGCGAGAAGAAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCCTTCCGGCGCCCTACTGACGCTGAGGCACGAAAGTGCGGGGATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(14);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(34);	scores.push_back(18);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(18);	scores.push_back(37);	scores.push_back(18);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(27);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(15);	scores.push_back(33);	scores.push_back(28);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(37);	scores.push_back(35);	scores.push_back(30);	scores.push_back(32);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(26);	scores.push_back(35);	scores.push_back(36);	scores.push_back(13);	scores.push_back(27);	scores.push_back(25);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read154.setScores(scores);
	ffastqReads.push_back(read154);
	FastqRead read155; read155.setName("M00967_44_000000000-A3K85_1_1101_9426_11659");
	read155.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGGATGCCAAGTCAGCGGTCAAATTTCGGGGCTCAACCCCGACCTGCCGTTGAAACTGGTGTCCTAGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCAACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(35);	scores.push_back(27);	scores.push_back(34);	scores.push_back(34);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(37);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(25);	scores.push_back(15);	scores.push_back(26);	scores.push_back(32);	scores.push_back(36);	scores.push_back(14);	scores.push_back(25);	scores.push_back(12);	scores.push_back(37);	read155.setScores(scores);
	ffastqReads.push_back(read155);
	FastqRead read156; read156.setName("M00967_44_000000000-A3K85_1_1101_20183_11662");
	read156.setSeq("TACGTAGGTGGCAAGCGTTGTCCGGATTTATTGGGCGTAAAGCGAGCGCAGGCGGTTGCTTAGGTCTGATGTGAAAGCCTTCGGCTTAACCGAAGAAGTGCATCGGAAACCGGGCGACTTGAGTGCAGAAGAGGACAGTGGAACTCCATGTGTAGCGGGGGAATGCGTAGATATATGGAAGAACACCAGTGGCGAAGGCGGCTGTCTGGTCTGCAACTGACGCTGAGGCTCGAAAGCATGGGTAGGGAACA");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(20);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(36);	scores.push_back(35);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(33);	scores.push_back(36);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(18);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(14);	scores.push_back(36);	scores.push_back(35);	scores.push_back(30);	scores.push_back(38);	scores.push_back(37);	scores.push_back(17);	scores.push_back(33);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(30);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(35);	scores.push_back(12);	scores.push_back(31);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(12);	scores.push_back(26);	scores.push_back(31);	scores.push_back(12);	scores.push_back(32);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(32);	scores.push_back(14);	scores.push_back(24);	scores.push_back(33);	scores.push_back(36);	scores.push_back(33);	scores.push_back(35);	scores.push_back(32);	scores.push_back(28);	scores.push_back(35);	scores.push_back(13);	scores.push_back(31);	scores.push_back(34);	scores.push_back(32);	scores.push_back(32);	scores.push_back(35);	scores.push_back(13);	scores.push_back(25);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(14);	scores.push_back(25);	scores.push_back(33);	scores.push_back(37);	scores.push_back(14);	scores.push_back(33);	scores.push_back(33);	scores.push_back(24);	scores.push_back(32);	scores.push_back(35);	scores.push_back(13);	scores.push_back(25);	scores.push_back(13);	scores.push_back(32);	scores.push_back(36);	scores.push_back(30);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(12);	scores.push_back(37);	scores.push_back(35);	scores.push_back(32);	scores.push_back(14);	scores.push_back(14);	scores.push_back(25);	scores.push_back(24);	scores.push_back(32);	scores.push_back(36);	scores.push_back(14);	scores.push_back(14);	scores.push_back(24);	scores.push_back(13);	scores.push_back(13);	scores.push_back(25);	scores.push_back(26);	scores.push_back(32);	scores.push_back(14);	read156.setScores(scores);
	ffastqReads.push_back(read156);
	FastqRead read157; read157.setName("M00967_44_000000000-A3K85_1_1101_6200_11675");
	read157.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGACTCTCAAGTCAGCGGTCAAATCGCGGGGCTCAACCCCGTTCCGCCGTTGAAACTGGGAGCCTTGAGTGCGCGAGAAGTAGGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCCTACCGGCGCGCAACTGACGCTCATGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(33);	scores.push_back(32);	scores.push_back(32);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(34);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(36);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(34);	scores.push_back(26);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(28);	scores.push_back(37);	read157.setScores(scores);
	ffastqReads.push_back(read157);
	FastqRead read158; read158.setName("M00967_44_000000000-A3K85_1_1101_23383_11740");
	read158.setSeq("TACGTAGGGGGCAAGCGTTATCCGGATTTACTGGGTGTAAAGGGAGCGTAGACGGTGATGCAAGTCTGAAGTGAAAGGCGGGGGCTCAACCCCCGGACTGCTTTGGAAACTGTATGACTGGAGTGCAGGAGAGGTAAGTGGAATTCCTAGTGTAGCGGTGAAATGCGTAGATATTAGGAGGAACACCAGTGGCGAAGGCGGCTTACTGGACTGTAACTGACGTTGAGGCTCGAAAGCGTGGGGAGCAAACA");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(36);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(33);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	read158.setScores(scores);
	ffastqReads.push_back(read158);
	FastqRead read159; read159.setName("M00967_44_000000000-A3K85_1_1101_6853_11772");
	read159.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGTTTGTCAAGTCAGCGGTAAAAATTCCGGGCTCAACCCGGTCCCGCCGTTGAAACTGGCGAACTCGAGAGGGAGAGAAGTAGGCGGAATGCGCAGTGTAGCGGTGAAATGCATAGATATTGCGCAGAACTCCGATTGCGAAGGCAGCCTACCGGCTCCTATCTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(36);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(26);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read159.setScores(scores);
	ffastqReads.push_back(read159);
	FastqRead read160; read160.setName("M00967_44_000000000-A3K85_1_1101_22387_11869");
	read160.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGAGCGTAGGTGGATTGTTAAGTCAGTTGTGAAAGTTTGCGGCTCAACCGTAAAATTGCAGTTGAAACTGGCAGTCTTGAGTACAGTAGAGGTGGGCGGAATTCGTGGTGTAGCGGTGAAATGCTTAGATATCACGAAGAACTCCGATTGCGAAGGCAGCTCACTGGACTGCAACTGACACTGATGCTCGAAAGTGTGGGTATCAAACA");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(36);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	read160.setScores(scores);
	ffastqReads.push_back(read160);
	FastqRead read161; read161.setName("M00967_44_000000000-A3K85_1_1101_19628_11889");
	read161.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACCCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGTGCGGGGATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(33);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(31);	scores.push_back(14);	scores.push_back(16);	scores.push_back(30);	scores.push_back(18);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(18);	scores.push_back(38);	scores.push_back(14);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(30);	scores.push_back(31);	scores.push_back(30);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(33);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(33);	scores.push_back(15);	scores.push_back(27);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(12);	scores.push_back(27);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(35);	scores.push_back(32);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(34);	scores.push_back(37);	read161.setScores(scores);
	ffastqReads.push_back(read161);
	FastqRead read162; read162.setName("M00967_44_000000000-A3K85_1_1101_27999_11894");
	read162.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(31);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(34);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(36);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(33);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(32);	scores.push_back(35);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read162.setScores(scores);
	ffastqReads.push_back(read162);
	FastqRead read163; read163.setName("M00967_44_000000000-A3K85_1_1101_13005_11931");
	read163.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGCAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(30);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	read163.setScores(scores);
	ffastqReads.push_back(read163);
	FastqRead read164; read164.setName("M00967_44_000000000-A3K85_1_1101_6379_11957");
	read164.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGATGCCAAGTCAGCGGTAAAAATGCGGGGCTCAACGCCGTCGAGCCGTTGAAACTGGCGTTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCTACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(36);	scores.push_back(14);	scores.push_back(36);	scores.push_back(38);	scores.push_back(33);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(36);	scores.push_back(38);	scores.push_back(38);	scores.push_back(30);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(35);	scores.push_back(39);	scores.push_back(33);	scores.push_back(36);	scores.push_back(38);	scores.push_back(36);	scores.push_back(14);	scores.push_back(29);	scores.push_back(34);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(30);	scores.push_back(14);	scores.push_back(27);	scores.push_back(31);	scores.push_back(27);	scores.push_back(31);	scores.push_back(27);	scores.push_back(31);	scores.push_back(12);	scores.push_back(27);	scores.push_back(32);	scores.push_back(30);	scores.push_back(13);	scores.push_back(34);	scores.push_back(13);	scores.push_back(13);	scores.push_back(38);	scores.push_back(39);	scores.push_back(15);	scores.push_back(26);	scores.push_back(15);	scores.push_back(38);	scores.push_back(34);	scores.push_back(25);	scores.push_back(13);	scores.push_back(12);	scores.push_back(25);	scores.push_back(34);	scores.push_back(38);	scores.push_back(15);	scores.push_back(26);	scores.push_back(25);	scores.push_back(15);	scores.push_back(26);	scores.push_back(13);	scores.push_back(13);	scores.push_back(36);	scores.push_back(37);	scores.push_back(30);	scores.push_back(30);	scores.push_back(24);	scores.push_back(36);	scores.push_back(37);	scores.push_back(33);	scores.push_back(34);	scores.push_back(24);	scores.push_back(37);	scores.push_back(15);	scores.push_back(25);	scores.push_back(33);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(15);	scores.push_back(24);	scores.push_back(35);	scores.push_back(24);	scores.push_back(32);	scores.push_back(33);	scores.push_back(13);	scores.push_back(26);	scores.push_back(13);	scores.push_back(15);	scores.push_back(24);	scores.push_back(15);	scores.push_back(12);	scores.push_back(31);	scores.push_back(13);	scores.push_back(24);	scores.push_back(13);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(24);	scores.push_back(24);	scores.push_back(15);	scores.push_back(25);	scores.push_back(33);	scores.push_back(15);	scores.push_back(24);	scores.push_back(24);	scores.push_back(15);	scores.push_back(13);	scores.push_back(13);	scores.push_back(31);	scores.push_back(31);	scores.push_back(28);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(29);	scores.push_back(13);	scores.push_back(35);	scores.push_back(13);	scores.push_back(24);	scores.push_back(32);	scores.push_back(24);	scores.push_back(35);	scores.push_back(31);	scores.push_back(35);	scores.push_back(13);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(32);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(35);	scores.push_back(12);	scores.push_back(12);	scores.push_back(33);	scores.push_back(37);	scores.push_back(33);	scores.push_back(28);	scores.push_back(37);	scores.push_back(30);	scores.push_back(33);	scores.push_back(37);	scores.push_back(24);	scores.push_back(37);	scores.push_back(32);	scores.push_back(25);	scores.push_back(32);	scores.push_back(13);	scores.push_back(13);	scores.push_back(26);	scores.push_back(32);	scores.push_back(13);	scores.push_back(32);	scores.push_back(37);	scores.push_back(30);	scores.push_back(13);	scores.push_back(26);	scores.push_back(32);	scores.push_back(24);	scores.push_back(14);	scores.push_back(26);	scores.push_back(32);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(25);	scores.push_back(15);	scores.push_back(15);	scores.push_back(25);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	read164.setScores(scores);
	ffastqReads.push_back(read164);
	FastqRead read165; read165.setName("M00967_44_000000000-A3K85_1_1101_7746_12226");
	read165.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCGGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(35);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read165.setScores(scores);
	ffastqReads.push_back(read165);
	FastqRead read166; read166.setName("M00967_44_000000000-A3K85_1_1101_8486_12249");
	read166.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGGAGGCGGAAGATCAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCGAGCCGTTGAAACTGGTTTTCTTGAGTGAGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCTCAACTGACGCTCATGCACGAAAGTGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(36);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	read166.setScores(scores);
	ffastqReads.push_back(read166);
	FastqRead read167; read167.setName("M00967_44_000000000-A3K85_1_1101_12335_12280");
	read167.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGACAGTTAAGTCAGCGGTAAAATTGAGAGGCTCAACCTCTTCCCGCCGTTGAAACTGATTGTCTTGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCAACTGACGCTGAAGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(37);	scores.push_back(39);	scores.push_back(36);	scores.push_back(35);	scores.push_back(16);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(33);	scores.push_back(37);	scores.push_back(37);	scores.push_back(32);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(30);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(13);	scores.push_back(24);	scores.push_back(26);	read167.setScores(scores);
	ffastqReads.push_back(read167);
	FastqRead read168; read168.setName("M00967_44_000000000-A3K85_1_1101_6614_12305");
	read168.setSeq("TACGGAGGATGCGAGCGTTATCCGGATTTATTGGGTTTAAAGGGTGCGTAGGCGGGCTGTTAAGTCAGCGGTCAAATGTCGGGGCTCAACCCCGGCCTGCCGTTGAAACTGGCGGCCTCGAGTGGGCGAGAAGTATGCGGAATGCGTGGTGTAGCGGTGAAATGCATAGATATCACGCAGAACTCCGATTGCGAAGGCAGCATACCGGCGCCCGACTGACGCTGAGGCACGAAAGCGTGGGTATCGAACAG");
	scores.clear();		scores.push_back(34);	scores.push_back(34);	scores.push_back(34);	scores.push_back(35);	scores.push_back(34);	scores.push_back(35);	scores.push_back(35);	scores.push_back(35);	scores.push_back(34);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(39);	scores.push_back(39);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(38);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(39);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(37);	scores.push_back(35);	scores.push_back(37);	scores.pus