#ifndef MUDLET_T2DMAP_H
#define MUDLET_T2DMAP_H

/***************************************************************************
 *   Copyright (C) 2008-2012 by Heiko Koehn - KoehnHeiko@googlemail.com    *
 *   Copyright (C) 2014 by Ahmed Charles - acharles@outlook.com            *
 *   Copyright (C) 2016 by Stephen Lyons - slysven@virginmedia.com         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "pre_guard.h"
#include <QColor>
#include <QPixmap>
#include <QTreeWidget>
#include <QWidget>
#include "post_guard.h"

class Host;
class TMap;

class QCheckBox;
class QComboBox;
class QListWidgetItem;
class QPushButton;
class QTreeWidgetItem;


class T2DMap : public QWidget
{
    Q_OBJECT

public:

    explicit T2DMap( QWidget *parent = 0 );
    void     paintMap();
    void     setMapZoom( int zoom );
    QColor   getColor( int id );
    QColor   _getColor( int id );
    void     init();
    void     exportAreaImage( int );
    void     paintEvent( QPaintEvent * );
    void     mousePressEvent(QMouseEvent * );
    void     mouseDoubleClickEvent ( QMouseEvent * event );
    bool     event(QEvent * event );
    void     wheelEvent ( QWheelEvent * );
    void     mouseMoveEvent( QMouseEvent * event );
    void     mouseReleaseEvent(QMouseEvent * e );
    bool     getCenterSelection();
    // Was getTopLeft() which returned an index into mMultiSelectionList but that
    // has been been changed to mMultiSelectionSet which cannot be accessed via
    // an index in the same way - this function now sets
    // mMultiSelectionHighlightRoomId and returns a (bool) on success or failure
    // to do so.
    void     setRoomSize( double );
    void     setExitSize( double );
    void     createLabel( QRectF labelRect );

    TMap *   mpMap;
    Host *   mpHost;
    int      xzoom;
    int      yzoom;
    int      _rx;
    int      _ry;
    QPoint   mPHighlight;
    bool     mPick;
    int      mTarget;
    //int      mRoomSelection;
    bool     mStartSpeedWalk;
    QMap<int, QPoint> mAreaExitList;
    QMap<QString, QStringList> mUserActions; //string list: 0 is event name, 1 is menu it is under if it is
    QMap<QString, QStringList> mUserMenus; //unique name, List:parent name ("" if null), display name
    QPoint   mMoveTarget;
    bool     mRoomBeingMoved;
    QPoint   mPHighlightMove;
    float    mTX;
    float    mTY;
    int      mChosenRoomColor;
    float    xspan;
    float    yspan;
    bool     mMultiSelection;  // Flag that the "drag to select rectangle"
                               // (mMultiRect) is active and is being *resized*
                               // by dragging
    QRectF   mMultiRect;
    bool     mPopupMenu;
    QSet<int> mMultiSelectionSet; // was mMultiSelectList
    QPoint   mOldMousePos;
    bool     mNewMoveAction;
    QRectF   mMapInfoRect;
    int      mFontHeight;
    bool     mShowRoomID;
    QMap<int,QPixmap> mPixMap;
//    QMap<int, QPixmap > mGridPix;
    int      gzoom;
    double   rSize;
    double   eSize;
    int      mRID;
    int      mAID;
    int      mOx;
    int      mOy;
    int      mOz;
    bool     mShiftMode;
    bool     mShowInfo;
    QComboBox * arealist_combobox;
    QDialog * mpCustomLinesDialog;
    int  mCustomLinesRoomFrom;
    int  mCustomLinesRoomTo;
    QString mCustomLinesRoomExit;
    QComboBox * mpCurrentLineStyle;
    QString mCurrentLineStyle;
    QPushButton * mpCurrentLineColor;
    QColor mCurrentLineColor;
    QCheckBox * mpCurrentLineArrow;
    bool mCurrentLineArrow;
    bool mShowGrid;
    QPointF mLastMouseClick;
    bool mBubbleMode;
    bool mMapperUseAntiAlias;
    bool mLabelHilite;
    bool mMoveLabel;
    int mCustomLineSelectedRoom;
    QString mCustomLineSelectedExit;
    int mCustomLineSelectedPoint;
    QTreeWidget mMultiSelectionListWidget;
    bool mSizeLabel;
    bool gridMapSizeChange;
    bool isCenterViewCall;
    QString mHelpMsg;

signals:

public slots:

    void slot_roomSelectionChanged();
    void slot_deleteCustomExitLine();
    void slot_moveLabel();
    void slot_deleteLabel();
    void slot_editLabel();
    void slot_setPlayerLocation();
    void slot_createLabel();
    void slot_customLineColor();
    void shiftZup();
    void shiftZdown();
    void slot_switchArea(QString);
    void toggleShiftMode();
    void shiftUp();
    void shiftDown();
    void shiftLeft();
    void shiftRight();
    void slot_setCharacter();
    void slot_setImage();
    void slot_movePosition();
    void slot_defineNewColor();
    void slot_selectRoomColor(QListWidgetItem * pI );
    void slot_moveRoom();
    void slot_deleteRoom();
    void slot_changeColor();
    void slot_spread();
    void slot_shrink();
    void slot_setExits();
    void slot_setUserData();
    void slot_lockRoom();
    void slot_unlockRoom();
    void slot_setRoomWeight();
    void slot_setArea();
    void slot_setCustomLine();
    void slot_setCustomLine2();
    void slot_userAction(QString);
    void slot_setCustomLine2B(QTreeWidgetItem*, int);
    void slot_undoCustomLineLastPoint();
    void slot_doneCustomLine();
    void slot_customLineProperties();
    void slot_customLineAddPoint();
    void slot_customLineRemovePoint();

private:
    void resizeMultiSelectionWidget();


    bool mDialogLock;
    int  mMultiSelectionHighlightRoomId;
                                // When more than zero rooms are selected this
                                // is either the first (only) room in the set
                                // or if getCenterSelectionId() is used the
                                // room that is selected - this is so that it
                                // can be painted in yellow rather than orange
                                // when more than one room is selected to
                                // indicate the particular room that will be
                                // modified or be the center of those
                                // modifications. {for slot_spread(),
                                // slot_shrink(), slot_setUserData() - if ever
                                // implimented, slot_setExits(),
                                // slot_movePosition(), etc.}

    bool  mIsSelectionSorting;
    bool  mIsSelectionSortByNames;
    bool  mIsSelectionUsingNames;
                                // Used to keep track of if sorting the multiple
                                // room listing/selection widget, and by what,
                                // as we now show room names (if present) as well.

};

#endif // MUDLET_T2DMAP_H
