const char * ngscript[] = {""
,"catch {lappend auto_path $env(NETGENDIR) }\n"
,"catch {lappend auto_path $env(NETGENDIR)/../lib }\n"
,"if {[catch {Ng_GetCommandLineParameter batchmode} result ]} {\n"
,"load libgui[info sharedlibextension] gui\n"
,"}\n"
,"set batchmode [Ng_GetCommandLineParameter batchmode]\n"
,"if {$batchmode==\"undefined\"} {\n"
,"if {[catch {package require tkdnd } result ]} {\n"
,"}\n"
,"}\n"
,"set userlevel 3\n"
,"if { [Ng_GetCommandLineParameter expert]==\"defined\" } {\n"
,"set userlevel 3\n"
,"}\n"
,"set progname \"NETGEN\"\n"
,"set ngdir \"\"\n"
,"if { [lsearch [array names env] NETGENDIR] != -1 } {\n"
,"set ngdir $env(NETGENDIR)\n"
,"}\n"
,"if { [string length $ngdir] == 0 } {\n"
,"set ngdir \".\"\n"
,"}\n"
,"set nguserdir \"\"\n"
,"if { [lsearch [array names env] NETGEN_USER_DIR] != -1 } {\n"
,"set nguserdir $env(NETGEN_USER_DIR)\n"
,"}\n"
,"if { [string length $nguserdir] == 0 } {\n"
,"set nguserdir \".\"\n"
,"}\n"
,"set batchmode [Ng_GetCommandLineParameter batchmode]\n"
,"set solvemode 0\n"
,"if { [Ng_GetCommandLineParameter solve] != \"undefined\" || \\\n"
,"[Ng_GetCommandLineParameter recent] == \"defined\" } {\n"
,"set solvemode defined\n"
,"}\n"
,"set shellmode [Ng_GetCommandLineParameter shellmode]\n"
,"if { $shellmode == \"defined\" } {\n"
,"set batchmode \"defined\"\n"
,"}\n"
,"if { $batchmode != \"defined\" } {\n"
,"catch {\n"
,"wm withdraw .\n"
,"wm title . $progname\n"
,"wm geometry . =850x600\n"
,"wm minsize . 400 300\n"
,"}\n"
,"}\n"
,"set drawmode rotate\n"
,"set selectvisual geometry\n"
,"set dirname .\n"
,"set loadgeomtypevar \"All Geometry types\"\n"
,"set basefilename filename\n"
,"set meshoptions.fineness 3\n"
,"set meshoptions.firststep ag\n"
,"set meshoptions.laststep ov\n"
,"set options.memory 0\n"
,"set options.localh 1\n"
,"set options.delaunay 1\n"
,"set options.checkoverlap 1\n"
,"set options.checkoverlappingboundary 0\n"
,"set options.checkchartboundary 1\n"
,"set options.startinsurface 0\n"
,"set options.blockfill 1\n"
,"set options.debugmode 0\n"
,"set options.dooptimize 1\n"
,"set options.parthread 1\n"
,"set options.elsizeweight 0.2\n"
,"set options.secondorder 0\n"
,"set options.elementorder 1\n"
,"set options.quad 0\n"
,"set options.try_hexes 0\n"
,"set options.inverttets 0\n"
,"set options.inverttrigs 0\n"
,"set options.autozrefine 0\n"
,"set options.meshsize 1000\n"
,"set options.minmeshsize 0\n"
,"set options.curvaturesafety 2\n"
,"set options.segmentsperedge 2\n"
,"set options.meshsizefilename \"\"\n"
,"set options.badellimit 175\n"
,"set options.optsteps2d 3\n"
,"set options.optsteps3d 5\n"
,"set options.opterrpow 2\n"
,"set options.grading 0.5\n"
,"set options.printmsg 2\n"
,"set debug.slowchecks 0\n"
,"set debug.debugoutput 0\n"
,"set debug.haltexistingline 0\n"
,"set debug.haltoverlap 0\n"
,"set debug.haltsuccess 0\n"
,"set debug.haltnosuccess 0\n"
,"set debug.haltlargequalclass 0\n"
,"set debug.haltsegment 0\n"
,"set debug.haltnode 0\n"
,"set debug.haltface 0\n"
,"set debug.haltfacenr 0\n"
,"set debug.haltsegmentp1 0\n"
,"set debug.haltsegmentp2 0\n"
,"set geooptions.drawcsg 1\n"
,"set geooptions.detail 0.001\n"
,"set geooptions.accuracy 1e-6\n"
,"set geooptions.facets 20\n"
,"set geooptions.minx -1000\n"
,"set geooptions.miny -1000\n"
,"set geooptions.minz -1000\n"
,"set geooptions.maxx 1000\n"
,"set geooptions.maxy 1000\n"
,"set geooptions.maxz 1000\n"
,"set viewqualityplot 0\n"
,"set memuseplot 0\n"
,"set viewrotatebutton 0\n"
,"set showsensitivehelp 0\n"
,"set showhelpline 0\n"
,"set viewoptions.specpointvlen 0.3\n"
,"set viewoptions.light.amb 0.3\n"
,"set viewoptions.light.diff 0.7\n"
,"set viewoptions.light.spec 1\n"
,"set viewoptions.light.locviewer 0\n"
,"set viewoptions.mat.shininess 50\n"
,"set viewoptions.mat.transp 0.3\n"
,"set viewoptions.colormeshsize 0\n"
,"set viewoptions.whitebackground 1\n"
,"set viewoptions.drawcoordinatecross 1\n"
,"set viewoptions.drawcolorbar 1\n"
,"set viewoptions.drawnetgenlogo 1\n"
,"set viewoptions.stereo 0\n"
,"set viewoptions.shrink 1\n"
,"set viewoptions.drawfilledtrigs 1\n"
,"set viewoptions.drawedges 0\n"
,"set viewoptions.drawbadels 0\n"
,"set viewoptions.centerpoint 0\n"
,"set viewoptions.drawelement 0\n"
,"set viewoptions.drawoutline 1\n"
,"set viewoptions.drawtets 0\n"
,"set viewoptions.drawtetsdomain 0\n"
,"set viewoptions.drawprisms 0\n"
,"set viewoptions.drawpyramids 0\n"
,"set viewoptions.drawhexes 0\n"
,"set viewoptions.drawidentified 0\n"
,"set viewoptions.drawpointnumbers 0\n"
,"set viewoptions.drawedgenumbers 0\n"
,"set viewoptions.drawfacenumbers 0\n"
,"set viewoptions.drawelementnumbers 0\n"
,"set viewoptions.drawdomainsurf 0\n"
,"set viewoptions.drawededges 1\n"
,"set viewoptions.drawedpoints 1\n"
,"set viewoptions.drawedpointnrs 0\n"
,"set viewoptions.drawedtangents 0\n"
,"set viewoptions.drawededgenrs 0\n"
,"set viewoptions.drawmetispartition 0\n"
,"set viewoptions.drawcurveproj 0\n"
,"set viewoptions.drawcurveprojedge 1\n"
,"set viewoptions.clipping.nx 0\n"
,"set viewoptions.clipping.ny 1\n"
,"set viewoptions.clipping.nz 0\n"
,"set viewoptions.clipping.dist 0\n"
,"set viewoptions.clipping.dist2 0\n"
,"set viewoptions.clipping.enable 0\n"
,"set viewoptions.clipping.onlydomain 0\n"
,"set viewoptions.clipping.notdomain 0\n"
,"set viewoptions.usecentercoords 0\n"
,"set viewoptions.centerx 0\n"
,"set viewoptions.centery 0\n"
,"set viewoptions.centerz 0\n"
,"set viewoptions.drawspecpoint 0\n"
,"set viewoptions.specpointx 0\n"
,"set viewoptions.specpointy 0\n"
,"set viewoptions.specpointz 0\n"
,"set stloptions.showtrias 0\n"
,"set stloptions.showfilledtrias 1\n"
,"set stloptions.showedges 1\n"
,"set stloptions.showmarktrias 0\n"
,"set stloptions.showactivechart 0\n"
,"set stloptions.yangle 30\n"
,"set stloptions.contyangle 20\n"
,"set stloptions.edgecornerangle 60\n"
,"set stloptions.chartangle 15\n"
,"set stloptions.outerchartangle 70\n"
,"set stloptions.usesearchtree 0\n"
,"set stloptions.chartnumber 1\n"
,"set stloptions.charttrignumber 1\n"
,"set stloptions.chartnumberoffset 0\n"
,"set stloptions.atlasminh 0.1\n"
,"set stloptions.resthsurfcurvfac 2\n"
,"set stloptions.resthsurfcurvenable 0\n"
,"set stloptions.resthatlasfac 2\n"
,"set stloptions.resthatlasenable 1\n"
,"set stloptions.resthchartdistfac 1.2\n"
,"set stloptions.resthchartdistenable 1\n"
,"set stloptions.resthlinelengthfac 0.5\n"
,"set stloptions.resthlinelengthenable 1\n"
,"set stloptions.resthcloseedgefac 1\n"
,"set stloptions.resthcloseedgeenable 1\n"
,"set stloptions.resthminedgelen 0.01\n"
,"set stloptions.resthminedgelenenable 1\n"
,"set stloptions.resthedgeanglefac 1\n"
,"set stloptions.resthedgeangleenable 0\n"
,"set stloptions.resthsurfmeshcurvfac 1\n"
,"set stloptions.resthsurfmeshcurvenable 0\n"
,"set stloptions.recalchopt 1\n"
,"set stldoctor.drawmeshededges 1\n"
,"set stldoctor.geom_tol_fact 0.000001\n"
,"set stldoctor.useexternaledges 0\n"
,"set stldoctor.showfaces 0\n"
,"set stldoctor.conecheck 1\n"
,"set stldoctor.spiralcheck 1\n"
,"set stldoctor.selecttrig 0\n"
,"set stldoctor.selectmode 1\n"
,"set stldoctor.longlinefact 0\n"
,"set stldoctor.showexcluded 1\n"
,"set stldoctor.edgeselectmode 0\n"
,"set stldoctor.nodeofseltrig 1\n"
,"set stldoctor.showtouchedtrigchart 0\n"
,"set stldoctor.showedgecornerpoints 0\n"
,"set stldoctor.showmarkedtrigs 1\n"
,"set stldoctor.dirtytrigfact 0.01\n"
,"set stldoctor.smoothangle 90\n"
,"set stldoctor.selectwithmouse 1\n"
,"set stldoctor.showvicinity 0\n"
,"set stldoctor.vicinity 50\n"
,"set stldoctor.smoothnormalsweight 0.2\n"
,"set occoptions.showvolumenr 0\n"
,"set occoptions.showsurfaces 1\n"
,"set occoptions.showedges 1\n"
,"set occoptions.showsolidnr 0\n"
,"set occoptions.showsolidnr2 0\n"
,"set occoptions.visproblemfaces 0\n"
,"set occoptions.zoomtohighlightedentity 0\n"
,"set occoptions.deflection 1\n"
,"set occoptions.tolerance 1e-3\n"
,"set occoptions.fixsmalledges 1\n"
,"set occoptions.fixspotstripfaces 1\n"
,"set occoptions.sewfaces 1\n"
,"set occoptions.makesolids 1\n"
,"set occoptions.splitpartitions 0\n"
,"set meshdoctor.active 0\n"
,"set meshdoctor.markedgedist 1\n"
,"set status_np 0\n"
,"set status_ne 0\n"
,"set status_nse 0\n"
,"set status_working \" \"\n"
,"set status_task \" \"\n"
,"set status_percent 0\n"
,"set status_filename 0\n"
,"set status_tetqualclasses \"10 20 30 40 10 20 30 40 10 20 30 40 10 20 30 40 10 20 30 40\"\n"
,"set exportfiletype \"Neutral Format\"\n"
,"set preproc.facenr 0\n"
,"set preproc.selectmode query\n"
,"set preproc.numtrig 0\n"
,"set mem_moveable 0\n"
,"set multithread_pause 0\n"
,"set multithread_testmode 0\n"
,"set multithread_redraw 0\n"
,"set multithread_drawing 0\n"
,"set multithread_terminate 0\n"
,"set multithread_running 0\n"
,"set level 0\n"
,"set tablesforoutput {}\n"
,"set optlist {\n"
,"options.localh\n"
,"options.delaunay\n"
,"options.checkoverlap\n"
,"options.startinsurface\n"
,"options.blockfill\n"
,"options.dooptimize\n"
,"options.elsizeweight\n"
,"options.meshsize\n"
,"options.minmeshsize\n"
,"options.curvaturesafety\n"
,"options.optsteps2d\n"
,"options.optsteps3d\n"
,"options.secondorder\n"
,"}\n"
,"set visoptions.usetexture 1\n"
,"set visoptions.invcolor 0\n"
,"set visoptions.imaginary 0\n"
,"set visoptions.lineartexture 0\n"
,"set visoptions.numtexturecols 16\n"
,"set visoptions.showclipsolution 1\n"
,"set visoptions.showsurfacesolution 0\n"
,"set visoptions.drawfieldlines 0\n"
,"set visoptions.drawpointcurves 1\n"
,"set visoptions.numfieldlines 100\n"
,"set visoptions.fieldlinesrandomstart 0\n"
,"set visoptions.fieldlinesstartarea box\n"
,"set visoptions.fieldlinesstartareap1x 1\n"
,"set visoptions.fieldlinesstartareap1y 1\n"
,"set visoptions.fieldlinesstartareap1z 1\n"
,"set visoptions.fieldlinesstartareap2x 0\n"
,"set visoptions.fieldlinesstartareap2y 0\n"
,"set visoptions.fieldlinesstartareap2z 0\n"
,"set visoptions.fieldlinesstartface -1\n"
,"set visoptions.fieldlinesfilename none\n"
,"set visoptions.fieldlinestolerance 0.0005\n"
,"set visoptions.fieldlinesrktype crungekutta\n"
,"set visoptions.fieldlineslength 0.5\n"
,"set visoptions.fieldlinesmaxpoints 500\n"
,"set visoptions.fieldlinesthickness 0.0015\n"
,"set visoptions.fieldlinesvecfunction none\n"
,"set visoptions.fieldlinesphase 0\n"
,"set visoptions.fieldlinesonlyonephase 1\n"
,"set visoptions.lineplotfile empty\n"
,"set visoptions.lineplotsource file\n"
,"set visoptions.lineplotusingx 0\n"
,"set visoptions.lineplotusingy 1\n"
,"set visoptions.lineplotautoscale 1\n"
,"set visoptions.lineplotxmin 0\n"
,"set visoptions.lineplotxmax 1\n"
,"set visoptions.lineplotymin 0\n"
,"set visoptions.lineplotymax 1\n"
,"set visoptions.lineplotcurrentnum -1\n"
,"set visoptions.lineplotinfos \"\"\n"
,"set visoptions.lineplotselected none\n"
,"set visoptions.lineplotselector \"\"\n"
,"set visoptions.lineplotcolor red\n"
,"set visoptions.lineplotsizex 500\n"
,"set visoptions.lineplotsizey 400\n"
,"set visoptions.lineplotselectedeval 0\n"
,"set visoptions.lineplotdatadescr \"column1 column2 column3\"\n"
,"set visoptions.lineplotxcoordselector \"\"\n"
,"set visoptions.lineplotycoordselector \"\"\n"
,"set visoptions.evaluatefilenames none\n"
,"set visoptions.evaluatefiledescriptions none\n"
,"set visoptions.clipsolution none\n"
,"set visoptions.scalfunction none\n"
,"set visoptions.vecfunction none\n"
,"set visoptions.evaluate abs\n"
,"set visoptions.gridsize 20\n"
,"set visoptions.xoffset 0\n"
,"set visoptions.yoffset 0\n"
,"set visoptions.autoscale 1\n"
,"set visoptions.redrawperiodic 0\n"
,"set visoptions.logscale 0\n"
,"set visoptions.mminval 0\n"
,"set visoptions.mmaxval 1\n"
,"set visoptions.isolines 0\n"
,"set visoptions.isosurf 0\n"
,"set visoptions.subdivisions 1\n"
,"set visoptions.numiso 10\n"
,"set visoptions.autoredraw 0\n"
,"set visoptions.autoredrawtime 2\n"
,"set visoptions.simulationtime 0\n"
,"set visoptions.multidimcomponent 0\n"
,"set visoptions.deformation 0\n"
,"set visoptions.scaledeform1 1\n"
,"set visoptions.scaledeform2 1\n"
,"set parallel_netgen 0\n"
,"set optfilename [file join $nguserdir ng.opt]\n"
,"set inifilename [file join $nguserdir ng.ini]\n"
,"set meshinifilename [file join $nguserdir ngmesh.ini]\n"
,"global env\n"
,"if { [llength [array names env NG_OPT]] == 1 } {\n"
,"if { [string length $env(NG_OPT)] > 0 } {\n"
,"set optfilename $env(NG_OPT)\n"
,"}\n"
,"}\n"
,"if { [file exists $optfilename] == 1 } {\n"
,"set datei [open $optfilename r]\n"
,"while { [gets $datei line] >= 0 } {\n"
,"set [lindex $line 0] [lindex $line 1]\n"
,"}\n"
,"close $datei\n"
,"} {\n"
,"puts \"optfile $optfilename does not exist - using default values\"\n"
,"}\n"
,"proc saveoptions { } {\n"
,"uplevel 1  {\n"
,"set file $optfilename\n"
,"if {$file != \"\"} {\n"
,"set datei [open $file w]\n"
,"puts $datei \"dirname  ${dirname}\"\n"
,"puts $datei \"loadgeomtypevar  \\\"${loadgeomtypevar}\\\"\"\n"
,"puts $datei \"exportfiletype  \\\"${exportfiletype}\\\"\"\n"
,"puts $datei \"meshoptions.fineness  ${meshoptions.fineness}\"\n"
,"puts $datei \"meshoptions.firststep ${meshoptions.firststep}\"\n"
,"puts $datei \"meshoptions.laststep  ${meshoptions.laststep}\"\n"
,"puts $datei \"options.localh  ${options.localh}\"\n"
,"puts $datei \"options.delaunay  ${options.delaunay}\"\n"
,"puts $datei \"options.checkoverlap  ${options.checkoverlap}\"\n"
,"puts $datei \"options.checkchartboundary  ${options.checkchartboundary}\"\n"
,"puts $datei \"options.startinsurface  ${options.startinsurface}\"\n"
,"puts $datei \"options.blockfill  ${options.blockfill}\"\n"
,"puts $datei \"options.debugmode  ${options.debugmode}\"\n"
,"puts $datei \"options.dooptimize ${options.dooptimize}\"\n"
,"puts $datei \"options.parthread  ${options.parthread}\"\n"
,"puts $datei \"options.elsizeweight  ${options.elsizeweight}\"\n"
,"puts $datei \"options.secondorder  ${options.secondorder}\"\n"
,"puts $datei \"options.elementorder  ${options.elementorder}\"\n"
,"puts $datei \"options.quad  ${options.quad}\"\n"
,"puts $datei \"options.try_hexes  ${options.try_hexes}\"\n"
,"puts $datei \"options.inverttets  ${options.inverttets}\"\n"
,"puts $datei \"options.inverttrigs  ${options.inverttrigs}\"\n"
,"puts $datei \"options.autozrefine ${options.autozrefine}\"\n"
,"puts $datei \"options.meshsize  ${options.meshsize}\"\n"
,"puts $datei \"options.minmeshsize  ${options.minmeshsize}\"\n"
,"puts $datei \"options.curvaturesafety  ${options.curvaturesafety}\"\n"
,"puts $datei \"options.segmentsperedge  ${options.segmentsperedge}\"\n"
,"puts $datei \"options.meshsizefilename  ${options.meshsizefilename}\"\n"
,"puts $datei \"options.badellimit  ${options.badellimit}\"\n"
,"puts $datei \"options.optsteps2d  ${options.optsteps2d}\"\n"
,"puts $datei \"options.optsteps3d  ${options.optsteps3d}\"\n"
,"puts $datei \"options.opterrpow  ${options.opterrpow}\"\n"
,"puts $datei \"options.grading  ${options.grading}\"\n"
,"puts $datei \"options.printmsg  ${options.printmsg}\"\n"
,"puts $datei \"geooptions.drawcsg  ${geooptions.drawcsg}\"\n"
,"puts $datei \"geooptions.detail  ${geooptions.detail}\"\n"
,"puts $datei \"geooptions.accuracy  ${geooptions.accuracy}\"\n"
,"puts $datei \"geooptions.facets  ${geooptions.facets}\"\n"
,"puts $datei \"geooptions.minx  ${geooptions.minx}\"\n"
,"puts $datei \"geooptions.miny  ${geooptions.miny}\"\n"
,"puts $datei \"geooptions.minz  ${geooptions.minz}\"\n"
,"puts $datei \"geooptions.maxx  ${geooptions.maxx}\"\n"
,"puts $datei \"geooptions.maxy  ${geooptions.maxy}\"\n"
,"puts $datei \"geooptions.maxz  ${geooptions.maxz}\"\n"
,"puts $datei \"viewoptions.specpointvlen  ${viewoptions.specpointvlen}\"\n"
,"puts $datei \"viewoptions.light.amb  ${viewoptions.light.amb}\"\n"
,"puts $datei \"viewoptions.light.diff ${viewoptions.light.diff}\"\n"
,"puts $datei \"viewoptions.light.spec ${viewoptions.light.spec}\"\n"
,"puts $datei \"viewoptions.light.locviewer ${viewoptions.light.locviewer}\"\n"
,"puts $datei \"viewoptions.mat.shininess  ${viewoptions.mat.shininess}\"\n"
,"puts $datei \"viewoptions.mat.transp  ${viewoptions.mat.transp}\"\n"
,"puts $datei \"viewoptions.colormeshsize ${viewoptions.colormeshsize}\"\n"
,"puts $datei \"viewoptions.whitebackground  ${viewoptions.whitebackground}\"\n"
,"puts $datei \"viewoptions.drawcolorbar  ${viewoptions.drawcolorbar}\"\n"
,"puts $datei \"viewoptions.drawcoordinatecross  ${viewoptions.drawcoordinatecross}\"\n"
,"puts $datei \"viewoptions.drawnetgenlogo  ${viewoptions.drawnetgenlogo}\"\n"
,"puts $datei \"viewoptions.stereo  ${viewoptions.stereo}\"\n"
,"puts $datei \"viewoptions.drawfilledtrigs  ${viewoptions.drawfilledtrigs}\"\n"
,"puts $datei \"viewoptions.drawedges  ${viewoptions.drawedges}\"\n"
,"puts $datei \"viewoptions.drawbadels  ${viewoptions.drawbadels}\"\n"
,"puts $datei \"viewoptions.centerpoint  ${viewoptions.centerpoint}\"\n"
,"puts $datei \"viewoptions.drawelement  ${viewoptions.drawelement}\"\n"
,"puts $datei \"viewoptions.drawoutline  ${viewoptions.drawoutline}\"\n"
,"puts $datei \"viewoptions.drawtets  ${viewoptions.drawtets}\"\n"
,"puts $datei \"viewoptions.drawprisms  ${viewoptions.drawprisms}\"\n"
,"puts $datei \"viewoptions.drawpyramids  ${viewoptions.drawpyramids}\"\n"
,"puts $datei \"viewoptions.drawhexes  ${viewoptions.drawhexes}\"\n"
,"puts $datei \"viewoptions.drawidentified  ${viewoptions.drawidentified}\"\n"
,"puts $datei \"viewoptions.drawpointnumbers  ${viewoptions.drawpointnumbers}\"\n"
,"puts $datei \"viewoptions.drawededges  ${viewoptions.drawededges}\"\n"
,"puts $datei \"viewoptions.drawedpoints  ${viewoptions.drawedpoints}\"\n"
,"puts $datei \"viewoptions.drawedpointnrs  ${viewoptions.drawedpointnrs}\"\n"
,"puts $datei \"viewoptions.drawedtangents  ${viewoptions.drawedtangents}\"\n"
,"puts $datei \"viewoptions.shrink  ${viewoptions.shrink}\"\n"
,"puts $datei \"stloptions.showtrias  ${stloptions.showtrias}\"\n"
,"puts $datei \"stloptions.showfilledtrias  ${stloptions.showfilledtrias}\"\n"
,"puts $datei \"stloptions.showedges  ${stloptions.showedges}\"\n"
,"puts $datei \"stloptions.showmarktrias  ${stloptions.showmarktrias}\"\n"
,"puts $datei \"stloptions.showactivechart  ${stloptions.showactivechart}\"\n"
,"puts $datei \"stloptions.yangle  ${stloptions.yangle}\"\n"
,"puts $datei \"stloptions.contyangle  ${stloptions.contyangle}\"\n"
,"puts $datei \"stloptions.edgecornerangle  ${stloptions.edgecornerangle}\"\n"
,"puts $datei \"stloptions.chartangle  ${stloptions.chartangle}\"\n"
,"puts $datei \"stloptions.outerchartangle  ${stloptions.outerchartangle}\"\n"
,"puts $datei \"stloptions.usesearchtree  ${stloptions.usesearchtree}\"\n"
,"puts $datei \"stloptions.chartnumber  ${stloptions.chartnumber}\"\n"
,"puts $datei \"stloptions.charttrignumber  ${stloptions.charttrignumber}\"\n"
,"puts $datei \"stloptions.chartnumberoffset  ${stloptions.chartnumberoffset}\"\n"
,"puts $datei \"stloptions.atlasminh  ${stloptions.atlasminh}\"\n"
,"puts $datei \"stloptions.resthsurfcurvfac  ${stloptions.resthsurfcurvfac}\"\n"
,"puts $datei \"stloptions.resthsurfcurvenable  ${stloptions.resthsurfcurvenable}\"\n"
,"puts $datei \"stloptions.resthatlasfac  ${stloptions.resthatlasfac}\"\n"
,"puts $datei \"stloptions.resthatlasenable  ${stloptions.resthatlasenable}\"\n"
,"puts $datei \"stloptions.resthchartdistfac  ${stloptions.resthchartdistfac}\"\n"
,"puts $datei \"stloptions.resthchartdistenable  ${stloptions.resthchartdistenable}\"\n"
,"puts $datei \"stloptions.resthlinelengthfac  ${stloptions.resthlinelengthfac}\"\n"
,"puts $datei \"stloptions.resthlinelengthenable  ${stloptions.resthlinelengthenable}\"\n"
,"puts $datei \"stloptions.resthminedgelen ${stloptions.resthminedgelen}\"\n"
,"puts $datei \"stloptions.resthminedgelenenable ${stloptions.resthminedgelenenable}\"\n"
,"puts $datei \"stloptions.resthcloseedgefac  ${stloptions.resthcloseedgefac}\"\n"
,"puts $datei \"stloptions.resthcloseedgeenable  ${stloptions.resthcloseedgeenable}\"\n"
,"puts $datei \"stloptions.resthedgeanglefac  ${stloptions.resthedgeanglefac}\"\n"
,"puts $datei \"stloptions.resthedgeangleenable  ${stloptions.resthedgeangleenable}\"\n"
,"puts $datei \"stloptions.resthsurfmeshcurvfac  ${stloptions.resthsurfmeshcurvfac}\"\n"
,"puts $datei \"stloptions.resthsurfmeshcurvenable  ${stloptions.resthsurfmeshcurvenable}\"\n"
,"puts $datei \"stloptions.recalchopt  ${stloptions.recalchopt}\"\n"
,"puts $datei \"visoptions.subdivisions ${visoptions.subdivisions}\"\n"
,"puts $datei \"visoptions.autoredraw ${visoptions.autoredraw}\"\n"
,"puts $datei \"visoptions.autoredrawtime ${visoptions.autoredrawtime}\"\n"
,"if { [info exists trafooptions.solver] == 1 } {\n"
,"puts $datei \"trafooptions.solver ${trafooptions.solver}\"\n"
,"puts $datei \"trafooptions.levels ${trafooptions.levels}\"\n"
,"puts $datei \"trafooptions.linits ${trafooptions.linits}\"\n"
,"puts $datei \"trafooptions.nonlinits ${trafooptions.nonlinits}\"\n"
,"puts $datei \"trafooptions.stabcurrent ${trafooptions.stabcurrent}\"\n"
,"puts $datei \"trafooptions.checkcond ${trafooptions.checkcond}\"\n"
,"puts $datei \"trafooptions.maxdirect ${trafooptions.maxdirect}\"\n"
,"puts $datei \"trafooptions.secondorder ${trafooptions.secondorder}\"\n"
,"puts $datei \"trafooptions.homogenizedcore ${trafooptions.homogenizedcore}\"\n"
,"puts $datei \"trafooptions.ordercore ${trafooptions.ordercore}\"\n"
,"puts $datei \"trafooptions.simplecurrents ${trafooptions.simplecurrents}\"\n"
,"puts $datei \"trafooptions.assemblecomplexmatrix ${trafooptions.assemblecomplexmatrix}\"\n"
,"puts $datei \"trafooptions.meshcasing  ${trafooptions.meshcasing}\"\n"
,"puts $datei \"trafooptions.meshcore    ${trafooptions.meshcore}\"\n"
,"puts $datei \"trafooptions.meshclumps  ${trafooptions.meshclumps}\"\n"
,"puts $datei \"trafooptions.meshshields ${trafooptions.meshshields}\"\n"
,"puts $datei \"trafooptions.meshcoils   ${trafooptions.meshcoils}\"\n"
,"puts $datei \"trafooptions.bcmdirectory  ${trafooptions.bcmdirectory}\"\n"
,"puts $datei \"trafooptions.lossdensityfile  ${trafooptions.lossdensityfile}\"\n"
,"}\n"
,"if { [info exists smalltrafomodell.tankheight] == 1 } {\n"
,"puts $datei \"smalltrafomodell.tankheight ${smalltrafomodell.tankheight}\"\n"
,"puts $datei \"smalltrafomodell.tankwidth ${smalltrafomodell.tankwidth}\"\n"
,"puts $datei \"smalltrafomodell.tanklength ${smalltrafomodell.tanklength}\"\n"
,"puts $datei \"smalltrafomodell.corewidth ${smalltrafomodell.corewidth}\"\n"
,"puts $datei \"smalltrafomodell.windowheight ${smalltrafomodell.windowheight}\"\n"
,"puts $datei \"smalltrafomodell.limbdistance ${smalltrafomodell.limbdistance}\"\n"
,"puts $datei \"smalltrafomodell.xposcore ${smalltrafomodell.xposcore}\"\n"
,"puts $datei \"smalltrafomodell.yposcore ${smalltrafomodell.yposcore}\"\n"
,"puts $datei \"smalltrafomodell.zposcore ${smalltrafomodell.zposcore}\"\n"
,"puts $datei \"smalltrafomodell.leakagefluxguidethickness ${smalltrafomodell.leakagefluxguidethickness}\"\n"
,"puts $datei \"smalltrafomodell.leakagefluxguidewidth ${smalltrafomodell.leakagefluxguidewidth}\"\n"
,"puts $datei \"smalltrafomodell.leakagefluxguidezposition ${smalltrafomodell.leakagefluxguidezposition}\"\n"
,"puts $datei \"smalltrafomodell.limbcoil.1 ${smalltrafomodell.limbcoil.1}\"\n"
,"puts $datei \"smalltrafomodell.ricoil.1 ${smalltrafomodell.ricoil.1}\"\n"
,"puts $datei \"smalltrafomodell.rocoil.1 ${smalltrafomodell.rocoil.1}\"\n"
,"puts $datei \"smalltrafomodell.zposcoil.1 ${smalltrafomodell.zposcoil.1}\"\n"
,"puts $datei \"smalltrafomodell.heightcoil.1 ${smalltrafomodell.heightcoil.1}\"\n"
,"puts $datei \"smalltrafomodell.currentcoil.1 ${smalltrafomodell.currentcoil.1}\"\n"
,"puts $datei \"smalltrafomodell.nturnscoil.1 ${smalltrafomodell.nturnscoil.1}\"\n"
,"puts $datei \"smalltrafomodell.limbcoil.2 ${smalltrafomodell.limbcoil.2}\"\n"
,"puts $datei \"smalltrafomodell.ricoil.2 ${smalltrafomodell.ricoil.2}\"\n"
,"puts $datei \"smalltrafomodell.rocoil.2 ${smalltrafomodell.rocoil.2}\"\n"
,"puts $datei \"smalltrafomodell.zposcoil.2 ${smalltrafomodell.zposcoil.2}\"\n"
,"puts $datei \"smalltrafomodell.heightcoil.2 ${smalltrafomodell.heightcoil.2}\"\n"
,"puts $datei \"smalltrafomodell.currentcoil.2 ${smalltrafomodell.currentcoil.2}\"\n"
,"puts $datei \"smalltrafomodell.nturnscoil.2 ${smalltrafomodell.nturnscoil.2}\"\n"
,"puts $datei \"smalltrafomodell.limbcoil.3 ${smalltrafomodell.limbcoil.3}\"\n"
,"puts $datei \"smalltrafomodell.ricoil.3 ${smalltrafomodell.ricoil.3}\"\n"
,"puts $datei \"smalltrafomodell.rocoil.3 ${smalltrafomodell.rocoil.3}\"\n"
,"puts $datei \"smalltrafomodell.zposcoil.3 ${smalltrafomodell.zposcoil.3}\"\n"
,"puts $datei \"smalltrafomodell.heightcoil.3 ${smalltrafomodell.heightcoil.3}\"\n"
,"puts $datei \"smalltrafomodell.currentcoil.3 ${smalltrafomodell.currentcoil.3}\"\n"
,"puts $datei \"smalltrafomodell.nturnscoil.3 ${smalltrafomodell.nturnscoil.3}\"\n"
,"puts $datei \"smalltrafomodell.limbcoil.4 ${smalltrafomodell.limbcoil.4}\"\n"
,"puts $datei \"smalltrafomodell.ricoil.4 ${smalltrafomodell.ricoil.4}\"\n"
,"puts $datei \"smalltrafomodell.rocoil.4 ${smalltrafomodell.rocoil.4}\"\n"
,"puts $datei \"smalltrafomodell.zposcoil.4 ${smalltrafomodell.zposcoil.4}\"\n"
,"puts $datei \"smalltrafomodell.heightcoil.4 ${smalltrafomodell.heightcoil.4}\"\n"
,"puts $datei \"smalltrafomodell.currentcoil.4 ${smalltrafomodell.currentcoil.4}\"\n"
,"puts $datei \"smalltrafomodell.nturnscoil.4 ${smalltrafomodell.nturnscoil.4}\"\n"
,"puts $datei \"smalltrafomodell.limbcoil.5 ${smalltrafomodell.limbcoil.5}\"\n"
,"puts $datei \"smalltrafomodell.ricoil.5 ${smalltrafomodell.ricoil.5}\"\n"
,"puts $datei \"smalltrafomodell.rocoil.5 ${smalltrafomodell.rocoil.5}\"\n"
,"puts $datei \"smalltrafomodell.zposcoil.5 ${smalltrafomodell.zposcoil.5}\"\n"
,"puts $datei \"smalltrafomodell.heightcoil.5 ${smalltrafomodell.heightcoil.5}\"\n"
,"puts $datei \"smalltrafomodell.currentcoil.5 ${smalltrafomodell.currentcoil.5}\"\n"
,"puts $datei \"smalltrafomodell.nturnscoil.5 ${smalltrafomodell.nturnscoil.5}\"\n"
,"puts $datei \"smalltrafomodell.limbcoil.6 ${smalltrafomodell.limbcoil.6}\"\n"
,"puts $datei \"smalltrafomodell.ricoil.6 ${smalltrafomodell.ricoil.6}\"\n"
,"puts $datei \"smalltrafomodell.rocoil.6 ${smalltrafomodell.rocoil.6}\"\n"
,"puts $datei \"smalltrafomodell.zposcoil.6 ${smalltrafomodell.zposcoil.6}\"\n"
,"puts $datei \"smalltrafomodell.heightcoil.6 ${smalltrafomodell.heightcoil.6}\"\n"
,"puts $datei \"smalltrafomodell.currentcoil.6 ${smalltrafomodell.currentcoil.6}\"\n"
,"puts $datei \"smalltrafomodell.nturnscoil.6 ${smalltrafomodell.nturnscoil.6}\"\n"
,"puts $datei \"smalltrafomodell.limbtest.1 ${smalltrafomodell.limbtest.1}\"\n"
,"puts $datei \"smalltrafomodell.heighttest.1 ${smalltrafomodell.heighttest.1}\"\n"
,"puts $datei \"smalltrafomodell.widthtest.1 ${smalltrafomodell.widthtest.1}\"\n"
,"puts $datei \"smalltrafomodell.rtest.1 ${smalltrafomodell.rtest.1}\"\n"
,"puts $datei \"smalltrafomodell.zpostest.1 ${smalltrafomodell.zpostest.1}\"\n"
,"puts $datei \"smalltrafomodell.edgeradiustest.1 ${smalltrafomodell.edgeradiustest.1}\"\n"
,"puts $datei \"smalltrafomodell.finetest.1 ${smalltrafomodell.finetest.1}\"\n"
,"puts $datei \"smalltrafomodell.conductivetest.1 ${smalltrafomodell.conductivetest.1}\"\n"
,"puts $datei \"smalltrafomodell.limbtest.2 ${smalltrafomodell.limbtest.2}\"\n"
,"puts $datei \"smalltrafomodell.heighttest.2 ${smalltrafomodell.heighttest.2}\"\n"
,"puts $datei \"smalltrafomodell.widthtest.2 ${smalltrafomodell.widthtest.2}\"\n"
,"puts $datei \"smalltrafomodell.rtest.2 ${smalltrafomodell.rtest.2}\"\n"
,"puts $datei \"smalltrafomodell.zpostest.2 ${smalltrafomodell.zpostest.2}\"\n"
,"puts $datei \"smalltrafomodell.edgeradiustest.2 ${smalltrafomodell.edgeradiustest.2}\"\n"
,"puts $datei \"smalltrafomodell.finetest.2 ${smalltrafomodell.finetest.2}\"\n"
,"puts $datei \"smalltrafomodell.conductivetest.2 ${smalltrafomodell.conductivetest.2}\"\n"
,"puts $datei \"smalltrafomodell.limbtest.3 ${smalltrafomodell.limbtest.3}\"\n"
,"puts $datei \"smalltrafomodell.heighttest.3 ${smalltrafomodell.heighttest.3}\"\n"
,"puts $datei \"smalltrafomodell.widthtest.3 ${smalltrafomodell.widthtest.3}\"\n"
,"puts $datei \"smalltrafomodell.rtest.3 ${smalltrafomodell.rtest.3}\"\n"
,"puts $datei \"smalltrafomodell.zpostest.3 ${smalltrafomodell.zpostest.3}\"\n"
,"puts $datei \"smalltrafomodell.edgeradiustest.3 ${smalltrafomodell.edgeradiustest.3}\"\n"
,"puts $datei \"smalltrafomodell.finetest.3 ${smalltrafomodell.finetest.3}\"\n"
,"puts $datei \"smalltrafomodell.conductivetest.3 ${smalltrafomodell.conductivetest.3}\"\n"
,"puts $datei \"smalltrafomodell.limbtest.4 ${smalltrafomodell.limbtest.4}\"\n"
,"puts $datei \"smalltrafomodell.heighttest.4 ${smalltrafomodell.heighttest.4}\"\n"
,"puts $datei \"smalltrafomodell.widthtest.4 ${smalltrafomodell.widthtest.4}\"\n"
,"puts $datei \"smalltrafomodell.rtest.4 ${smalltrafomodell.rtest.4}\"\n"
,"puts $datei \"smalltrafomodell.zpostest.4 ${smalltrafomodell.zpostest.4}\"\n"
,"puts $datei \"smalltrafomodell.edgeradiustest.4 ${smalltrafomodell.edgeradiustest.4}\"\n"
,"puts $datei \"smalltrafomodell.finetest.4 ${smalltrafomodell.finetest.4}\"\n"
,"puts $datei \"smalltrafomodell.conductivetest.4 ${smalltrafomodell.conductivetest.4}\"\n"
,"puts $datei \"smalltrafomodell.nperitest ${smalltrafomodell.nperitest}\"\n"
,"puts $datei \"smalltrafomodell.filename ${smalltrafomodell.filename}\"\n"
,"puts $datei \"smalltrafomodell.murlfguide ${smalltrafomodell.murlfguide}\"\n"
,"puts $datei \"smalltrafomodell.murtestwire ${smalltrafomodell.murtestwire}\"\n"
,"puts $datei \"smalltrafomodell.murcore ${smalltrafomodell.murcore}\"\n"
,"puts $datei \"smalltrafomodell.kappalfguide ${smalltrafomodell.kappalfguide}\"\n"
,"puts $datei \"smalltrafomodell.kappatestwire ${smalltrafomodell.kappatestwire}\"\n"
,"puts $datei \"smalltrafomodell.kappacore ${smalltrafomodell.kappacore}\"\n"
,"}\n"
,"close $datei\n"
,"}\n"
,"}\n"
,"}\n"
,"proc saveinifile { } {\n"
,"global inifilename\n"
,"if {[catch { set datei [open $inifilename w] } result ]} {\n"
,"puts \"cannot write file $inifilename\"\n"
,"} {\n"
,"for { set i [.ngmenu.file.recent index last] } { $i >= 0 } { incr i -1 } {\n"
,"puts $datei \"recentfile \\\"[.ngmenu.file.recent entrycget $i -label]\\\"\"\n"
,"}\n"
,"close $datei\n"
,"}\n"
,"}\n"
,"proc savemeshinifile { } {\n"
,"global meshinifilename\n"
,"if {[catch { set datei [open $meshinifilename w] } result ]} {\n"
,"puts \"cannot write file $meshinifilename\"\n"
,"} {\n"
,"for { set i [.ngmenu.file.recentmesh index last] } { $i >= 1 } { incr i -1 } {\n"
,"puts $datei \"recentfile \\\"[.ngmenu.file.recentmesh entrycget $i -label]\\\"\"\n"
,"}\n"
,"close $datei\n"
,"}\n"
,"}\n"
,"proc loadinifile { } {\n"
,"global inifilename\n"
,"if { [file exists $inifilename] == 1 } {\n"
,"set datei [open $inifilename r]\n"
,"while { [gets $datei line] >= 0 } {\n"
,"if {[lindex $line 0] == \"recentfile\"} {\n"
,"set filename [lindex $line 1]\n"
,"if { [file exists $filename] == 1 } {\n"
,"AddRecentFile $filename\n"
,"}\n"
,"}\n"
,"}\n"
,"close $datei\n"
,"}\n"
,"}\n"
,"proc loadmeshinifile { } {\n"
,"global meshinifilename\n"
,"if { [file exists $meshinifilename] == 1 } {\n"
,"set datei [open $meshinifilename r]\n"
,"while { [gets $datei line] >= 0 } {\n"
,"if {[lindex $line 0] == \"recentfile\"} {\n"
,"set filename [lindex $line 1]\n"
,"if { [file exists $filename] == 1 } {\n"
,"AddRecentMeshFile $filename\n"
,"}\n"
,"}\n"
,"}\n"
,"close $datei\n"
,"}\n"
,"}\n"
,"set cmdindex {}\n"
,"set hlpindex {}\n"
,"set secindex {}\n"
,"proc setgranularity { gran } {\n"
,"if {$gran == 6} { return }\n"
,"set gran [expr $gran - 1]\n"
,"global options.curvaturesafety\n"
,"set surfcurvlist { 1 1.5 2 3 5 }\n"
,"set options.curvaturesafety [lindex $surfcurvlist $gran]\n"
,"global options.segmentsperedge\n"
,"set spelist { 0.3 0.5 1 2 3 }\n"
,"set options.segmentsperedge [lindex $spelist $gran]\n"
,"global stloptions.resthsurfcurvfac\n"
,"set surfcurvfaclist { 0.25 0.5 1 1.5 3 }\n"
,"set stloptions.resthsurfcurvfac [lindex $surfcurvfaclist $gran]\n"
,"global stloptions.resthchartdistfac\n"
,"set chartdistfaclist { 0.8 1 1.5 2 5 }\n"
,"set stloptions.resthchartdistfac [lindex $chartdistfaclist $gran]\n"
,"global stloptions.resthlinelengthfac\n"
,"set linelengthfaclist { 0.2 0.35 0.5 1.5 3 }\n"
,"set stloptions.resthlinelengthfac [lindex $linelengthfaclist $gran]\n"
,"global stloptions.resthcloseedgefac\n"
,"set closeedgefaclist { 0.5 1 2 3.5 5 }\n"
,"set stloptions.resthcloseedgefac [lindex $closeedgefaclist $gran]\n"
,"global stloptions.resthminedgelen\n"
,"set minedgelenlist { 0.002 0.02 0.2 1.0 2.0 5.0 10.0 }\n"
,"set stloptions.resthminedgelen [lindex $minedgelenlist $gran]\n"
,"global stloptions.resthedgeanglefac\n"
,"set edgeanglefaclist { 0.25 0.5 1 1.5 3 }\n"
,"set stloptions.resthedgeanglefac [lindex $edgeanglefaclist $gran]\n"
,"global stloptions.resthsurfmeshcurvfac\n"
,"set surfmeshcurvlist { 1 1.5 2 3 5 }\n"
,"set stloptions.resthsurfmeshcurvfac [lindex $surfmeshcurvlist $gran]\n"
,"global options.grading\n"
,"set gradinglist { 0.7 0.5 0.3 0.2 0.1 }\n"
,"set options.grading [lindex $gradinglist $gran]\n"
,"}\n"
,"if { $batchmode != \"defined\" } {\n"
,"catch {\n"
,"if { $tcl_platform(os) eq \"Linux\" && [tk scaling] > 1.5 } {\n"
,"font create ngFont -family Helvetica\n"
,"option add *font ngFont\n"
,"ttk::style configure \".\" -font ngFont\n"
,"}\n"
,"menu .ngmenu -tearoff 0  -relief raised -bd 2\n"
,". configure -menu .ngmenu\n"
,".ngmenu add cascade -label \"File\" -menu .ngmenu.file -underline 0\n"
,".ngmenu add cascade -label \"Geometry\" -menu .ngmenu.geometry -underline 0\n"
,".ngmenu add cascade -label \"Mesh\" -menu .ngmenu.mesh -underline 0\n"
,".ngmenu add cascade -label \"View\" -menu .ngmenu.view -underline 0\n"
,".ngmenu add cascade -label \"Refinement\" -menu .ngmenu.meshsize -underline 5\n"
,"if { $userlevel == 3} {\n"
,".ngmenu add cascade -label \"Special\" -menu .ngmenu.special -underline 3\n"
,"}\n"
,".ngmenu add cascade -label \"Help\" -menu .ngmenu.help -underline 0\n"
,"menu .ngmenu.file\n"
,".ngmenu.file add command -label \"Load Geometry...\" -accelerator \"<l><g>\" \\\n"
,"-command {\n"
,"set types {\n"
,"{\"All Geometry types\"   { .stl .stlb .step .stp .geo .in2d .igs .iges .brep .sat} }\n"
,"{\"IGES Geometry\"	{.igs .iges} }\n"
,"{\"BREP OpenCascade Geometry\"    {.brep} }\n"
,"{\"STL Geometry\"        {.stl} }\n"
,"{\"Binary STL Geometry\"    {.stlb} }\n"
,"{\"STEP Geometry\"    {.step .stp} }\n"
,"{\"Geometry file\"       {.geo} }\n"
,"{\"2D Geometry\"   {.in2d } }\n"
,"}\n"
,"set ACISavailable [Ng_ACISCommand isACISavailable]\n"
,"if {$ACISavailable == \"yes\" } {\n"
,"lappend types {\"ACIS Geometry\" {.sat} }\n"
,"}\n"
,"if {[catch {\n"
,"set file [tk_getOpenFile -filetypes $types -initialdir $dirname -typevariable loadgeomtypevar]\n"
,"}]} {\n"
,"set file [tk_getOpenFile -filetypes $types -initialdir $dirname]\n"
,"}\n"
,"if {$file != \"\"} {\n"
,"AddRecentFile $file\n"
,"Ng_LoadGeometry $file\n"
,"Ng_ParseGeometry\n"
,"set selectvisual geometry\n"
,"Ng_SetVisParameters\n"
,"redraw\n"
,"wm title . [concat \"$progname - \" $file]\n"
,"set dirname [file dirname $file]\n"
,"set basefilename [file tail [file rootname $file]]\n"
,"if { $hasocc == \"yes\" } {\n"
,"rebuildoccdialog\n"
,"}\n"
,"}\n"
,"}\n"
,".ngmenu.file add command -label \"Save Geometry...\" \\\n"
,"-command {\n"
,"set occgeometryloaded [Ng_OCCCommand isoccgeometryloaded]\n"
,"puts $occgeometryloaded\n"
,"if {$occgeometryloaded == 1 } {\n"
,"set types {\n"
,"{\"IGES Geometry file\"   {.igs} }\n"
,"{\"STEP Geometry file\"   {.stp} }\n"
,"{\"STL Geometry file\"   {.stl} }\n"
,"{\"STL BIN Geometry file\"   {.stlb} }\n"
,"}\n"
,"} {\n"
,"set types {\n"
,"{\"STL Geometry file\"   {.stl} }\n"
,"{\"STL BIN Geometry file\"   {.stlb} }\n"
,"}\n"
,"}\n"
,"set ACISavailable [Ng_ACISCommand isACISavailable]\n"
,"puts $ACISavailable\n"
,"if {$ACISavailable == \"yes\" } {\n"
,"lappend types {\"ACIS Geometry\" {.sat} }\n"
,"}\n"
,"set file [tk_getSaveFile -filetypes $types -initialdir $dirname -initialfile $basefilename ]\n"
,"if {$file != \"\"} {\n"
,"Ng_SaveGeometry $file\n"
,"}\n"
,"}\n"
,".ngmenu.file add cascade -label \"Recent Files\" -menu .ngmenu.file.recent\n"
,"menu .ngmenu.file.recent -tearoff 0\n"
,"proc AddRecentFile { filename } {\n"
,"global progname\n"
,"global dirname\n"
,"catch { [.ngmenu.file.recent delete $filename] }\n"
,".ngmenu.file.recent insert 0 command -label $filename \\\n"
,"-command \"AddRecentFile {$filename};\n"
,"Ng_LoadGeometry {$filename};\n"
,"Ng_ParseGeometry;\n"
,"set selectvisual geometry;\n"
,"Ng_SetVisParameters;\n"
,"redraw;\n"
,"wm title . [concat \\\" $progname - $filename \\\"];\n"
,"set dirname {[file dirname $filename]};\n"
,"set basefilename {[file tail [file rootname $filename]]};\n"
,"rebuildoccdialog;\"\n"
,"if { [.ngmenu.file.recent index last] >= 6 } {\n"
,".ngmenu.file.recent delete last }\n"
,"saveinifile;\n"
,"}\n"
,"loadinifile;\n"
,".ngmenu.file add separator\n"
,".ngmenu.file add command -label \"Load Mesh...\" -accelerator \"<l><m>\" \\\n"
,"-command {\n"
,"set types {\n"
,"{\"Mesh file\"   {.vol .vol.gz}	} }\n"
,"set file [tk_getOpenFile -filetypes $types -defaultextension \".vol\"]\n"
,"if {$file != \"\"} {\n"
,"AddRecentMeshFile $file;\n"
,"Ng_LoadMesh $file;\n"
,"set selectvisual mesh\n"
,"Ng_SetVisParameters\n"
,"redraw\n"
,"Ng_ReadStatus;\n"
,"wm title . [concat \"$progname - \" $file]\n"
,"set dirname [file dirname $file]\n"
,"set basefilename [file tail [file rootname $file]]\n"
,"}\n"
,"}\n"
,".ngmenu.file add cascade -label \"Recent Meshes\" -menu .ngmenu.file.recentmesh\n"
,"menu .ngmenu.file.recentmesh\n"
,"proc AddRecentMeshFile { filename } {\n"
,"global progname\n"
,"global dirname\n"
,"catch { [.ngmenu.file.recentmesh delete $filename] }\n"
,".ngmenu.file.recentmesh insert 0 command -label $filename \\\n"
,"-command \"AddRecentMeshFile {$filename};\n"
,"Ng_LoadMesh {$filename};\n"
,"set selectvisual mesh;\n"
,"Ng_SetVisParameters;\n"
,"redraw;\n"
,"wm title . [concat \\\" $progname - $filename \\\"];\n"
,"set dirname {[file dirname $filename]};\n"
,"set basefilename {[file tail [file rootname $filename]]};\n"
,"rebuildoccdialog;\"\n"
,"if { [.ngmenu.file.recentmesh index last] >= 6 } {\n"
,".ngmenu.file.recentmesh delete last }\n"
,"savemeshinifile;\n"
,"}\n"
,"loadmeshinifile;\n"
,".ngmenu.file add command -label \"Save Mesh...\" -accelerator \"<s><m>\" \\\n"
,"-command {\n"
,"set types {\n"
,"{\"Mesh file\"   {.vol .vol.gz}	} }\n"
,"set file [tk_getSaveFile -filetypes $types -defaultextension \".vol.gz\" -initialfile $basefilename -initialdir $dirname ]\n"
,"if {$file != \"\"} {\n"
,"Ng_SaveMesh $file }\n"
,"AddRecentMeshFile $file;\n"
,"}\n"
,".ngmenu.file add command -label \"Merge Mesh...\" \\\n"
,"-command {\n"
,"set types {\n"
,"{\"Mesh file\"   {.vol}	} }\n"
,"set file [tk_getOpenFile -filetypes $types -defaultextension \".vol\"]\n"
,"if {$file != \"\"} {\n"
,"Ng_MergeMesh $file;\n"
,"set selectvisual mesh\n"
,"Ng_SetVisParameters\n"
,"redraw\n"
,"Ng_ReadStatus;\n"
,"}\n"
,"}\n"
,".ngmenu.file add command -label \"Import Mesh...\" \\\n"
,"-command {\n"
,"set types {\n"
,"{\"Neutral format\"  {.mesh .emt} }\n"
,"{\"Surface mesh format\"  {.surf} }\n"
,"{\"Universal format\"  {.unv} }\n"
,"{\"Olaf format\"  {.emt} }\n"
,"{\"TET format\" {.tet} }\n"
,"{\"Pro/ENGINEER neutral format\" {.fnf} }\n"
,"}\n"
,"set file [tk_getOpenFile -filetypes $types ]\n"
,"if {$file != \"\"} {\n"
,"Ng_ImportMesh $file\n"
,"set selectvisual mesh\n"
,"Ng_SetVisParameters\n"
,"redraw\n"
,"Ng_ReadStatus;\n"
,"}\n"
,"}\n"
,".ngmenu.file add command -label \"Export Mesh...\" \\\n"
,"-command {\n"
,"foreach exportformat $meshexportformats {\n"
,"if { [lindex $exportformat 0] == $exportfiletype } {\n"
,"set extension [lindex $exportformat 1]\n"
,"}\n"
,"}\n"
,"if { $exportfiletype == \"Elmer Format\"} {\n"
,"set file [file nativename [tk_chooseDirectory -title \"Elmer Mesh Export - Select Directory\"]]\n"
,"} elseif { $exportfiletype == \"OpenFOAM 1.5+ Format\"} {\n"
,"set file [file nativename [tk_chooseDirectory -title \"OpenFOAM 1.5+ Mesh Export - Select Case Directory\"]]\n"
,"} elseif { $exportfiletype == \"OpenFOAM 1.5+ Compressed\"} {\n"
,"set file [file nativename [tk_chooseDirectory -title \"OpenFOAM 1.5+ Mesh Export - Select Case Directory\"]]\n"
,"} else {\n"
,"set file [tk_getSaveFile  -filetypes \"{ \\\"$exportfiletype\\\" {*}}\" ]\n"
,"}\n"
,"if {$file != \"\"} {\n"
,"Ng_ExportMesh $file $exportfiletype\n"
,"}\n"
,"}\n"
,".ngmenu.file add cascade -label \"Export Filetype\" -menu .ngmenu.file.filetype\n"
,"menu .ngmenu.file.filetype\n"
,".ngmenu.file add separator\n"
,".ngmenu.file add command -label \"Save Solution...\" \\\n"
,"-command {\n"
,"set types {\n"
,"{\"Solution File\"  {.sol} }\n"
,"{\"VTK File\"  {.vtk} }\n"
,"}\n"
,"set file [tk_getSaveFile -filetypes $types ]\n"
,"if {$file != \"\"} {\n"
,"Ng_SaveSolution $file\n"
,"}\n"
,"}\n"
,".ngmenu.file add command -label \"Import Solution...\" \\\n"
,"-command {\n"
,"set types { {\"Solution File\"  {.sol} } }\n"
,"set file [tk_getOpenFile -filetypes $types -defaultextension \".sol\"  ]\n"
,"if {$file != \"\"} {\n"
,"Ng_ImportSolution $file\n"
,"set selectvisual solution\n"
,"Ng_SetVisParameters\n"
,"redraw\n"
,"}\n"
,"}\n"
,"set demostarttime [clock clicks -millisecond]\n"
,"set stopdemo 0\n"
,"proc demoredraw { } {\n"
,"global demostarttime\n"
,"global stopdemo\n"
,"set curtime [clock clicks -millisecond]\n"
,"set result [ Ng_DemoSetTime [expr $curtime - $demostarttime] ]\n"
,"redraw\n"
,"global videoactive\n"
,"if { $videoactive == 1 } {\n"
,"puts \"addframe\"\n"
,"Ng_VideoClip .ndraw addframe\n"
,"}\n"
,"if { $result == 0 && $stopdemo == 0 } {\n"
,"after 1 { demoredraw }\n"
,"}\n"
,"}\n"
,".ngmenu.file add command -label \"Show Demo...\" \\\n"
,"-command {\n"
,"set types { {\"Demo File\"  {.dem} } }\n"
,"set file [tk_getOpenFile -filetypes $types -defaultextension \".dem\"  ]\n"
,"if {$file != \"\"} {\n"
,"Ng_ShowDemo $file\n"
,"set demostarttime [clock clicks -millisecond]\n"
,"set stopdemo 0\n"
,"demoredraw\n"
,"}\n"
,"}\n"
,".ngmenu.file add separator\n"
,".ngmenu.file add command -label \"Snapshot...\" \\\n"
,"-command {\n"
,"set types {\n"
,"{\"JPG file\" {.jpg} }\n"
,"{\"GIF file\" {.gif} }\n"
,"{\"PPM file\" {.ppm} }\n"
,"}\n"
,"set file [tk_getSaveFile -filetypes $types]\n"
,"if {$file != \"\"} {\n"
,"Ng_SnapShot .ndraw $file }\n"
,"}\n"
,".ngmenu.file add cascade -label \"Video clip\" -menu .ngmenu.file.video\n"
,"menu .ngmenu.file.video\n"
,"set videoactive 0\n"
,".ngmenu.file.video add command -label \"start...\" \\\n"
,"-command {\n"
,"set types {\n"
,"{\"MPG file\" {.mpg} }\n"
,"}\n"
,"set file [tk_getSaveFile -filetypes $types]\n"
,"if {$file != \"\"} {\n"
,"Ng_VideoClip .ndraw init $file\n"
,"global videoactive\n"
,"set videoactive 1\n"
,"}\n"
,"}\n"
,".ngmenu.file.video add command -label \"add frame...\" \\\n"
,"-command {Ng_VideoClip .ndraw addframe }\n"
,".ngmenu.file.video add command -label \"one cycle\" \\\n"
,"-command {\n"
,"set visoptions.redrawperiodic 1\n"
,"for { set j 0 } { $j < 100 } { incr j } {\n"
,"puts \"j =  $j\"\n"
,"Ng_Vis_Set time [expr (1000 * $j / 100)]\n"
,"redraw\n"
,"Ng_VideoClip .ndraw addframe\n"
,"after 200\n"
,"}\n"
,"}\n"
,".ngmenu.file.video add command -label \"finalize...\" \\\n"
,"-command {\n"
,"Ng_VideoClip .ndraw finalize\n"
,"global videoactive\n"
,"set videoactive 0\n"
,"}\n"
,".ngmenu.file add command -label \"Save Options\" \\\n"
,"-command { saveoptions }\n"
,".ngmenu.file add separator\n"
,".ngmenu.file add command -label \"Quit\" -accelerator \"<q>\" \\\n"
,"-command {\n"
,"puts \"Thank you for using $progname\";\n"
,"if { [catch { unload libngsolve[info sharedlibextension] ngsolve } result ] } {\n"
,"}\n"
,"after cancel { timer2 }\n"
,"Ng_Exit;\n"
,"destroy .\n"
,"}\n"
,"menu .ngmenu.mesh\n"
,".ngmenu.mesh add command -label \"Generate Mesh\" -accelerator \"<g><m>\" \\\n"
,"-command {\n"
,"set selectvisual mesh\n"
,"Ng_SetVisParameters\n"
,"Ng_GenerateMesh ${meshoptions.firststep} ${meshoptions.laststep}\n"
,"Ng_ReadStatus\n"
,"redraw\n"
,"}\n"
,".ngmenu.mesh add command -label \"Stop Meshing\" \\\n"
,"-command { Ng_StopMeshing }\n"
,".ngmenu.mesh add command -label \"Meshing Options...\" \\\n"
,"-command meshingoptionsdialog\n"
,".ngmenu.mesh add separator\n"
,".ngmenu.mesh add command -label \"Delete Mesh\" \\\n"
,"-command { Ng_New mesh; Ng_ReadStatus; redraw }\n"
,".ngmenu.mesh add command -label \"Delete Vol Mesh\" \\\n"
,"-command { Ng_DeleteVolMesh; Ng_ReadStatus; redraw }\n"
,".ngmenu.mesh add command -label \"Mesh Info\" \\\n"
,"-command {\n"
,"set dim [Ng_MeshInfo dim]\n"
,"set np [Ng_MeshInfo np]\n"
,"set ne [Ng_MeshInfo ne]\n"
,"set nse [Ng_MeshInfo nse]\n"
,"set nseg [Ng_MeshInfo nseg]\n"
,"set bbox [Ng_MeshInfo bbox]\n"
,"tk_messageBox -message  \"Dimension: $dim\\nPoints: $np\\nElements: $ne\\nSurface Els: $nse\\nSegments: $nseg\\nxmin [lindex $bbox 0] xmax [lindex $bbox 1]\\nymin [lindex $bbox 2] ymax [lindex $bbox 3]\\nzmin [lindex $bbox 4] zmax [lindex $bbox 5]\"\n"
,"}\n"
,".ngmenu.mesh add command -label \"Mesh Quality\" \\\n"
,"-command {\n"
,"set inplanemin 0\n"
,"set inplanemax 0\n"
,"set betplanemin 0\n"
,"set betplanemax 0\n"
,"Ng_MeshQuality inplanemin inplanemax betplanemin betplanemax\n"
,"puts \"Triangle angles : $inplanemin - $inplanemax\"\n"
,"puts \"Tet angles      : $betplanemin - $betplanemax\"\n"
,"tk_messageBox -message  \"Triangle angles : $inplanemin - $inplanemax \\n Tet angles      : $betplanemin - $betplanemax\"\n"
,"}\n"
,".ngmenu.mesh add command -label \"Check Surface Mesh\" \\\n"
,"-command { Ng_CheckSurfaceMesh }\n"
,".ngmenu.mesh add command -label \"Check Volume Mesh\" \\\n"
,"-command { Ng_CheckVolumeMesh }\n"
,".ngmenu.mesh add command -label \"Edit Boundary Conditions...\" \\\n"
,"-command { bcpropdialog }\n"
,"if { $userlevel == 3 } {\n"
,".ngmenu.mesh add command -label \"Mesh Doctor...\" \\\n"
,"-command { meshdoctordialog }\n"
,"}\n"
,".ngmenu.mesh add command -label \"METIS Mesh Partitioning...\" \\\n"
,"-command { METISdialog }\n"
,".ngmenu.mesh add separator\n"
,".ngmenu.mesh add command -label \"Analyze Geometry\" \\\n"
,"-command { Ng_GenerateMesh ag ag; Ng_ReadStatus; redraw }\n"
,".ngmenu.mesh add command -label \"Mesh Edges\" \\\n"
,"-command { Ng_GenerateMesh me me; Ng_ReadStatus; redraw }\n"
,".ngmenu.mesh add command -label \"Mesh Surface\" \\\n"
,"-command { set selectvisual mesh; Ng_SetVisParameters; \\\n"
,"Ng_GenerateMesh ms ms; Ng_ReadStatus; redraw }\n"
,".ngmenu.mesh add command -label \"Optimize Surface\" \\\n"
,"-command { Ng_GenerateMesh os os cmsmSm; redraw }\n"
,".ngmenu.mesh add cascade -label \"Surface Optim. Step\" -menu .ngmenu.mesh.surfoptstep\n"
,"menu .ngmenu.mesh.surfoptstep\n"
,".ngmenu.mesh.surfoptstep add command -label \"Mesh Smoothing\" \\\n"
,"-command { Ng_GenerateMesh os os m; redraw}\n"
,".ngmenu.mesh.surfoptstep add command -label \"Edge swapping (topologic)\" \\\n"
,"-command { Ng_GenerateMesh os os s; redraw}\n"
,".ngmenu.mesh.surfoptstep add command -label \"Edge swapping (metric)\" \\\n"
,"-command { Ng_GenerateMesh os os S; redraw}\n"
,".ngmenu.mesh.surfoptstep add command -label \"Combine points\" \\\n"
,"-command { Ng_GenerateMesh os os c; redraw}\n"
,".ngmenu.mesh add separator\n"
,".ngmenu.mesh add command -label \"Mesh Volume\" \\\n"
,"-command { Ng_GenerateMesh mv mv; Ng_ReadStatus }\n"
,".ngmenu.mesh add command -label \"Optimize Volume\" \\\n"
,"-command { Ng_GenerateMesh ov ov; Ng_ReadStatus }\n"
,".ngmenu.mesh add command -label \"Smooth Opt Volume\" \\\n"
,"-command { Ng_GenerateMesh ov ov m; Ng_ReadStatus }\n"
,".ngmenu.mesh add command -label \"Smooth Opt Volume Jacobian\" \\\n"
,"-command { Ng_GenerateMesh ov ov j; Ng_ReadStatus }\n"
,"menu .ngmenu.geometry\n"
,"menu .ngmenu.view\n"
,".ngmenu.view add command -label \"Zoom all\" \\\n"
,"-command { Ng_ZoomAll; redraw }\n"
,".ngmenu.view add command -label \"Center\" \\\n"
,"-command { Ng_Center; redraw }\n"
,".ngmenu.view add command -label \"x-y plane\" \\\n"
,"-command { Ng_StandardRotation xy; redraw }\n"
,".ngmenu.view add command -label \"y-x plane\" \\\n"
,"-command { Ng_StandardRotation yx; redraw }\n"
,".ngmenu.view add command -label \"x-z plane\" \\\n"
,"-command { Ng_StandardRotation xz; redraw }\n"
,".ngmenu.view add command -label \"z-x plane\" \\\n"
,"-command { Ng_StandardRotation zx; redraw }\n"
,".ngmenu.view add command -label \"y-z plane\" \\\n"
,"-command { Ng_StandardRotation yz; redraw }\n"
,".ngmenu.view add command -label \"z-y plane\" \\\n"
,"-command { Ng_StandardRotation zy; redraw }\n"
,".ngmenu.view add command -label \"Viewing Options...\" \\\n"
,"-command { viewingoptionsdialog; redraw }\n"
,".ngmenu.view add command -label \"Clipping Plane...\" \\\n"
,"-command { clippingdialog; redraw }\n"
,".ngmenu.view add command -label \"Solution Data...\" \\\n"
,"-command { visual_dialog; redraw }\n"
,".ngmenu.view add checkbutton -variable viewqualityplot \\\n"
,"-label \"Quality Plot\" \\\n"
,"-command { qualityviewdialog $viewqualityplot }\n"
,".ngmenu.view add checkbutton -variable memuseplot \\\n"
,"-label \"Memory Usage\" \\\n"
,"-command { memusedialog $memuseplot }\n"
,"menu .ngmenu.meshsize\n"
,".ngmenu.meshsize add command -label \"Refine uniform\" \\\n"
,"-command { Ng_Refine; Ng_HighOrder ${options.elementorder}; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize add command -label \"Second Order\" \\\n"
,"-command { Ng_SecondOrder; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize add command -label \"Validate Second Order\" \\\n"
,"-command { Ng_ValidateSecondOrder; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize add command -label \"High Order\" \\\n"
,"-command { Ng_HighOrder ${options.elementorder}; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize add separator\n"
,".ngmenu.meshsize add command -label \"Refinement Dialog...\" \\\n"
,"-command { refinementdialog }\n"
,".ngmenu.meshsize add command -label \"Load Meshsize...\" \\\n"
,"-command {\n"
,"set types {\n"
,"{\"Meshsize file\"   {.msz}	} }\n"
,"set file [tk_getOpenFile -filetypes $types]\n"
,"if {$file != \"\"} {\n"
,"Ng_LoadMeshSize $file;\n"
,"}\n"
,"}\n"
,".ngmenu.meshsize add command -label \"MS from Surf Mesh\" \\\n"
,"-command { Ng_MeshSizeFromSurfaceMesh }\n"
,"if { $userlevel == 3 } {\n"
,".ngmenu.meshsize add command -label \"Singular point ms\" \\\n"
,"-command { Ng_SingularPointMS; }\n"
,".ngmenu.meshsize add command -label \"Singular edge ms\" \\\n"
,"-command { Ng_SingularEdgeMS; }\n"
,".ngmenu.meshsize add separator\n"
,"set bisectfilename \"\";\n"
,".ngmenu.meshsize add command -label \"Bisection\" \\\n"
,"-command { Ng_ReadStatus; set oldnp 0; set newnp $status_np;\n"
,"Ng_ReadStatus;\n"
,"while { $oldnp < $newnp } {\n"
,"set level [expr $level+1]\n"
,"if { $bisectfilename == \"\"} {\n"
,"Ng_Bisect;\n"
,"} else {\n"
,"Ng_Bisect $bisectfilename;\n"
,"}\n"
,"Ng_ReadStatus;\n"
,"redraw;\n"
,"if { $bisectfilename == \"\"} {\n"
,"set oldnp $newnp;\n"
,"set newnp $status_np;\n"
,"puts \"oldnp $oldnp newnp $newnp\";\n"
,"} else {\n"
,"set oldnp $newnp;\n"
,"}\n"
,"}\n"
,"}\n"
,"}\n"
,".ngmenu.meshsize add command -label \"Load Refinement Info...\" \\\n"
,"-command {\n"
,"set types {\n"
,"{\"Refinement info\" {.refine} }}\n"
,"set bisectfilename [tk_getOpenFile -filetypes $types]\n"
,"}\n"
,".ngmenu.meshsize add command -label \"Z-Refinement\" \\\n"
,"-command { Ng_ZRefinement 2; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize add cascade -label \"hp-Refinement\" -menu .ngmenu.meshsize.hpref\n"
,"menu .ngmenu.meshsize.hpref\n"
,".ngmenu.meshsize.hpref add command -label \"1 Level\" \\\n"
,"-command { Ng_HPRefinement 1; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize.hpref add command -label \"2 Levels\" \\\n"
,"-command { Ng_HPRefinement 2; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize.hpref add command -label \"3 Levels\" \\\n"
,"-command { Ng_HPRefinement 3; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize.hpref add command -label \"4 Levels\" \\\n"
,"-command { Ng_HPRefinement 4; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize.hpref add command -label \"5 Levels\" \\\n"
,"-command { Ng_HPRefinement 5; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize.hpref add command -label \"6 Levels\" \\\n"
,"-command { Ng_HPRefinement 6; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize.hpref add command -label \"7 Levels\" \\\n"
,"-command { Ng_HPRefinement 7; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize.hpref add command -label \"8 Levels\" \\\n"
,"-command { Ng_HPRefinement 8; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize.hpref add command -label \"9 Levels\" \\\n"
,"-command { Ng_HPRefinement 9; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize.hpref add command -label \"10 Levels\" \\\n"
,"-command { Ng_HPRefinement 10; Ng_ReadStatus; redraw }\n"
,".ngmenu.meshsize add command -label \"Split to Tets\" \\\n"
,"-command { Ng_Split2Tets; Ng_ReadStatus; redraw }\n"
,"menu .ngmenu.special\n"
,".ngmenu.special add command -label \"Prismatic Boundary Layer\" \\\n"
,"-command { Ng_GenerateBoundaryLayer; redraw }\n"
,".ngmenu.special add command -label \"Insert virtual boundary layer\" \\\n"
,"-command { Ng_InsertVirtualBL; redraw }\n"
,".ngmenu.special add command -label \"Cut off and combine with other\" \\\n"
,"-command {\n"
,"set types { {\"Mesh file\"   {.vol}	} }\n"
,"set file [tk_getOpenFile -filetypes $types]\n"
,"if {$file != \"\"} {\n"
,"Ng_CutOffAndCombine $file;  }\n"
,"redraw\n"
,"}\n"
,".ngmenu.special add command -label \"Helmholtz Mesh grading\" \\\n"
,"-command { Ng_HelmholtzMesh; }\n"
,".ngmenu.special add cascade -label \"Colour-based boundary conditions\" -menu .ngmenu.special.colbndcond\n"
,"menu .ngmenu.special.colbndcond\n"
,".ngmenu.special.colbndcond add command -label \"Inspect Colours in mesh\" \\\n"
,"-command { currmeshcoloursdialog }\n"
,".ngmenu.special.colbndcond add separator\n"
,".ngmenu.special.colbndcond add command -label \"Automatic Assignment\" \\\n"
,"-command { Ng_AutoColourBcProps auto; redraw }\n"
,".ngmenu.special.colbndcond add separator\n"
,"set ocffile [file join ${ngdir} netgen.ocf];\n"
,".ngmenu.special.colbndcond add command -label \"Select Colour Profile file\" \\\n"
,"-command {\n"
,"set types { {\"Colour Profile file\"   {.ocf}   } }\n"
,"set ocffile [tk_getOpenFile -filetypes $types]\n"
,"if {$ocffile == \"\"} {\n"
,"set ocffile [file join ${ngdir} netgen.ocf]; }\n"
,"}\n"
,".ngmenu.special.colbndcond add command -label \"Profile based Assignment\" \\\n"
,"-command { Ng_AutoColourBcProps profile ${ocffile}; redraw }\n"
,"menu .ngmenu.help\n"
,".ngmenu.view add checkbutton -label \"Help Line\" -variable showhelpline \\\n"
,"-command {\n"
,"if { $showhelpline == 1} {\n"
,"pack .helpline -before .statbar -side bottom -fill x -padx 3p\n"
,"} {\n"
,"pack forget .helpline\n"
,"}\n"
,"}\n"
,".ngmenu.help add command -label \"About...\" \\\n"
,"-command {\n"
,"tk_messageBox -message \"This is NETGEN \\nmainly written by \\nJoachim Schoeberl \\nthanks to \\nRobert Gaisbauer, Johannes Gerstmayr, Philippose Rajan\"\n"
,"}\n"
,"ttk::frame .bubar\n"
,"pack .bubar -side top -fill x\n"
,"ttk::button .bubar.testb -text \"Test\" -command { Ng_SaveGeometry }\n"
,"ttk::button .bubar.surfm -text \"Generate Mesh\" -command \\\n"
,"{\n"
,".ngmenu.mesh invoke \"Generate Mesh\";\n"
,"}\n"
,"ttk::button .bubar.stopm -text \"Stop\" -command \\\n"
,"{\n"
,"set multithread_terminate 1;\n"
,"set stopdemo 1;\n"
,"}\n"
,"ttk::button .bubar.exitb -text \"Quit\" \\\n"
,"-command {\n"
,"set ans [tk_messageBox -title \"Quit Netgen?\" -message \"Do you really want to quit Netgen?\" -type yesno -default \"no\" -icon question]\n"
,"if { $ans == \"yes\" } {\n"
,".ngmenu.file invoke \"Quit\";\n"
,"}\n"
,"}\n"
,"pack  .bubar.exitb .bubar.surfm .bubar.stopm -side left\n"
,"ttk::button .bubar.zoomall -text \"Zoom All\" \\\n"
,"-command { Ng_ZoomAll; redraw }\n"
,"ttk::button .bubar.center -text \"Center\" \\\n"
,"-command { Ng_Center; redraw }\n"
,"ttk::menubutton .bubar.modesel -menu .bubar.modesel.menu -text \"\" -width 6\n"
,"menu .bubar.modesel.menu  -tearoff 0\n"
,".bubar.modesel.menu add command -label \"Rotate\" -command \"set drawmode \\\"rotate\\\" ;.bubar.modesel configure -text \\\"Rotate\\\"\"\n"
,".bubar.modesel.menu add command -label \"Move\" -command \"set drawmode \\\"move\\\" ;.bubar.modesel configure -text \\\"Move\\\"\"\n"
,".bubar.modesel.menu add command -label \"Zoom\" -command \"set drawmode \\\"zoom\\\" ;.bubar.modesel configure -text \\\"Zoom\\\"\"\n"
,".bubar.modesel.menu invoke \"Rotate\"\n"
,"set viewvals { geometry specpoints mesh solution}\n"
,"if { $userlevel == 3} {\n"
,"set viewvals { geometry mesh specpoints surfmeshing modelview solution}\n"
,"}\n"
,"set viewvallabs(cross)     \"Cross\"\n"
,"set viewvallabs(geometry)  \"Geometry\"\n"
,"set viewvallabs(mesh)      \"Mesh\"\n"
,"set viewvallabs(specpoints) \"Edges\"\n"
,"set viewvallabs(surfmeshing) \"Mesh Gen\"\n"
,"set viewvallabs(modelview)     \"Modeller\"\n"
,"set viewvallabs(solution)     \"Solution\"\n"
,"pack .bubar.center .bubar.zoomall -side right\n"
,".ngmenu.view add checkbutton -variable viewrotatebutton \\\n"
,"-label \"Enable LeftButton Selection\" \\\n"
,"-command {\n"
,"if { $viewrotatebutton } {\n"
,"pack .bubar.modesel -side right\n"
,"} {\n"
,"pack forget .bubar.modesel\n"
,"}\n"
,"}\n"
,"menu .bubar.selviewmenu\n"
,"ttk::menubutton .bubar.selview1 -menu .bubar.selviewmenu -text \"Geometry\"\n"
,"foreach viewv $viewvals {\n"
,".bubar.selviewmenu add command -label $viewvallabs($viewv) -command \\\n"
,"\".bubar.selview1 configure -text \\\"$viewvallabs($viewv)\\\" ; set selectvisual $viewv ; Ng_SetVisParameters; redraw\"\n"
,"}\n"
,"pack .bubar.selview1 -side right\n"
,"trace add variable selectvisual write selvis_monitor\n"
,"proc selvis_monitor { name args } {\n"
,"global selectvisual viewvallabs\n"
,".bubar.selviewmenu invoke $viewvallabs($selectvisual)\n"
,"}\n"
,"ttk::label .helpline -text \"None\"\n"
,"pack forget .helpline -side bottom -fill x\n"
,"ttk::frame .statbar -relief flat\n"
,"pack .statbar -side bottom -fill x\n"
,"ttk::label .statbar.ptslabel -text \"   Points: \"\n"
,"ttk::label .statbar.ptsval -textvariable status_np\n"
,"ttk::label .statbar.elslabel -text \"   Elements: \"\n"
,"ttk::label .statbar.elsval -textvariable status_ne\n"
,"ttk::label .statbar.selslabel -text \"   Surf Elements: \"\n"
,"ttk::label .statbar.selsval -textvariable status_nse\n"
,"ttk::label .statbar.task -textvariable status_task\n"
,"pack .statbar.ptslabel .statbar.ptsval -side left -ipady 3p\n"
,"pack .statbar.elslabel .statbar.elsval -side left -ipady 3p\n"
,"pack .statbar.selslabel .statbar.selsval -side left -ipady 3p\n"
,"ttk::progressbar .statbar.per -value 0 -maximum 1\n"
,"pack .statbar.per -side right\n"
,"pack .statbar.task -side right -ipady 4\n"
,"set qualbaraxis(0) 0\n"
,"set qualbar(0) 0\n"
,"set qualbarnull(0) 0\n"
,"proc timer2 { } {\n"
,"global status_np\n"
,"global status_ne\n"
,"global status_nse\n"
,"global multithread_running\n"
,"global multithread_redraw\n"
,"global status_working\n"
,"global status_task\n"
,"global status_percent\n"
,"global status_tetqualclasses\n"
,"Ng_ReadStatus\n"
,"if { $multithread_redraw == 1 } {\n"
,"set multithread_redraw 0;\n"
,"redraw;\n"
,"global videoactive\n"
,"if { $videoactive == 1 } {\n"
,"puts \"addframe\"\n"
,"Ng_VideoClip .ndraw addframe\n"
,"}\n"
,"}\n"
,"if { $multithread_redraw == 2 } {\n"
,"redraw;\n"
,"set multithread_redraw 0;\n"
,"global videoactive\n"
,"if { $videoactive == 1 } {\n"
,"puts \"addframe\"\n"
,"Ng_VideoClip .ndraw addframe\n"
,"}\n"
,"after 1 { timer2 }\n"
,"return\n"
,"}\n"
,".statbar.per configure -value [expr $status_percent/100]\n"
,"if { $multithread_running } {\n"
,"pack .statbar.per -side right -before .statbar.task -padx 6\n"
,"} {\n"
,"pack forget .statbar.per\n"
,"}\n"
,"if {[winfo exists .qualityview_dlg] == 1} {\n"
,"global qualbar\n"
,"global qualbarnull\n"
,"global qualbaraxis\n"
,"set maxval 0\n"
,"for {set i 0} {$i < 20} {incr i} {\n"
,"if {[lindex $status_tetqualclasses $i] > $maxval} {\n"
,"set maxval [lindex $status_tetqualclasses $i]\n"
,"}\n"
,"}\n"
,"set ubound 1\n"
,"while { $ubound < $maxval } {\n"
,"set ubound [expr {10 * $ubound}]\n"
,"}\n"
,"if { $ubound/5 > $maxval } {\n"
,"set ubound [expr $ubound/5]\n"
,"}\n"
,"if { $ubound/2 > $maxval } {\n"
,"set ubound [expr $ubound/2]\n"
,"}\n"
,"for {set i 1} {$i <= 5} {incr i} {\n"
,"set value [expr { $i * $ubound / 5 }]\n"
,".qualityview_dlg.c dchars $qualbaraxis($i) 0 end\n"
,".qualityview_dlg.c insert $qualbaraxis($i) end $value\n"
,"}\n"
,"for {set i 0} {$i < 20} {incr i} {\n"
,"set x1 [expr {100 + ($i*15) + 2}]\n"
,"set x2 [expr {$x1+10}]\n"
,"set nbrs [lindex $status_tetqualclasses $i]\n"
,"set y [expr (249 - (200 * $nbrs / $ubound ) )]\n"
,".qualityview_dlg.c coords $qualbar($i) $x1 250 $x2 $y\n"
,"if { $nbrs == 0 } {\n"
,".qualityview_dlg.c itemconfigure $qualbarnull($i) -text 0\n"
,"} {\n"
,".qualityview_dlg.c itemconfigure $qualbarnull($i) -text \"\"\n"
,"}\n"
,"}\n"
,"}\n"
,"if {[winfo exists .memuse_dlg] == 1} {\n"
,"global memmark\n"
,"set usemb [Ng_MemInfo usedmb]\n"
,"for {set i 0} {$i < [string length $usemb] } {incr i} {\n"
,"if { [string index $usemb $i] == 0 } {\n"
,".memuse_dlg.c coords $memmark($i)  [expr 50+$i] 68 [expr 50+$i] 70\n"
,"} {\n"
,".memuse_dlg.c coords $memmark($i)  [expr 50+$i] 50 [expr 50+$i] 70\n"
,"}\n"
,"}\n"
,"}\n"
,"after 10 { timer2 }\n"
,"}\n"
,"timer2\n"
,"proc bgerror { error } {\n"
,"global errorInfo userlevel\n"
,"if { $userlevel == 3} {\n"
,"puts \"ERROR: $error\"\n"
,"puts \"errinfo: $errorInfo\"\n"
,"}\n"
,"tk_messageBox -title \"Error Message\" -message $error -type ok\n"
,"}\n"
,"proc smh2 { menuitem } {\n"
,"if {[catch {$menuitem entrycget active -label} name]} {\n"
,"set name \"    \"\n"
,"}\n"
,"show_menu_help $name\n"
,"update idletasks\n"
,"}\n"
,"bind .ngmenu <<MenuSelect>> { smh2 %W }\n"
,"bind .ngmenu.file <<MenuSelect>> { smh2 %W }\n"
,"bind .ngmenu.geometry <<MenuSelect>> { smh2 %W }\n"
,"bind .ngmenu.mesh <<MenuSelect>> { smh2 %W }\n"
,"bind .ngmenu.view <<MenuSelect>> { smh2 %W }\n"
,"bind .ngmenu.meshsize <<MenuSelect>> { smh2 %W }\n"
,"bind .ngmenu.special <<MenuSelect>> { smh2 %W }\n"
,"bind .ngmenu.help <<MenuSelect>> { smh2 %W }\n"
,"bind . <q> { .ngmenu.file invoke \"Quit\" }\n"
,"bind . <l><g> { .ngmenu.file invoke \"Load Geometry...\" }  ;\n"
,"bind . <l><m> { .ngmenu.file invoke \"Load Mesh...\" }  ;\n"
,"bind . <s><m> { .ngmenu.file invoke \"Save Mesh...\" }  ;\n"
,"bind . <r><f> { .ngmenu.file activate \"Recent Files\" }  ;\n"
,"bind . <n><p> { newprimitivedialog }      ; \n"
,"bind . <e><p> { editprimitivedialog }\n"
,"bind . <e><s> { newsoliddialog }\n"
,"bind . <g><m> { .ngmenu.mesh invoke \"Generate Mesh\" }  ;\n"
,"}\n"
,"}\n"
,"catch {\n"
,"proc meshingoptionsdialog { } {\n"
,"set w .options_dlg\n"
,"if {[winfo exists .options_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"pack [ttk::notebook $w.nb]  -fill both -side top\n"
,"$w.nb add [ttk::frame $w.nb.general] -text \"General\" -underline 0\n"
,"$w.nb add [ttk::frame $w.nb.meshsize] -text \"Mesh Size\" -underline 0\n"
,"$w.nb add [ttk::frame $w.nb.chartopt] -text \"STL Charts\" -underline 0\n"
,"$w.nb add [ttk::frame $w.nb.optimizer] -text \"Optimizer\" -underline 0\n"
,"$w.nb add [ttk::frame $w.nb.debug] -text \"Debug\" -underline 0\n"
,"set f $w.nb.general\n"
,"ttk::frame $f.background\n"
,"pack $f.background -fill both\n"
,"set f $f.background\n"
,"ttk::labelframe $f.f2 -relief groove -borderwidth 3 -text \"General meshing options\"\n"
,"pack $f.f2  -pady 15 -fill x\n"
,"set f $f.f2\n"
,"set finevals { 1 2 3 4 5 6 }\n"
,"set finelabs(1) \"very coarse\"\n"
,"set finelabs(2) \"coarse\"\n"
,"set finelabs(3) \"moderate\"\n"
,"set finelabs(4) \"fine\"\n"
,"set finelabs(5) \"very fine\"\n"
,"set finelabs(6) \"user defined\"\n"
,"global meshoptions.fineness\n"
,"ttk::label  $f.fine2l -text \"Mesh granularity: \"\n"
,"ttk::menubutton $f.fine2c -menu $f.fine2m -text \"coarse\" -width 16\n"
,"menu $f.fine2m  -tearoff 0\n"
,"foreach finev { 1 2 3 4 5 6 } {\n"
,"$f.fine2m add command -label $finelabs($finev) \\\n"
,"-command \"set meshoptions.fineness $finev ; setgranularity $finev; $f.fine2c configure -text \\\"$finelabs($finev)\\\"\"\n"
,"}\n"
,"$f.fine2m invoke $finelabs(${meshoptions.fineness})\n"
,"grid $f.fine2l $f.fine2c -sticky nw\n"
,"set mgsteps { ag me ms os mv ov }\n"
,"set mgsteplabel(ag) \"Analyze Geometry\"\n"
,"set mgsteplabel(me) \"Mesh Edges\"\n"
,"set mgsteplabel(ms) \"Mesh Surface\"\n"
,"set mgsteplabel(os) \"Optimize Surface\"\n"
,"set mgsteplabel(mv) \"Mesh Volume\"\n"
,"set mgsteplabel(ov) \"Optimize Volume\"\n"
,"global meshoptions.firststep\n"
,"ttk::label  $f.first2l -text \"First Step: \"\n"
,"ttk::menubutton $f.first2c -menu $f.first2m  -width 16\n"
,"menu $f.first2m  -tearoff 0\n"
,"foreach i $mgsteps {\n"
,"$f.first2m add command -label $mgsteplabel($i) -command \"set meshoptions.firststep $i ; $f.first2c configure -text \\\"$mgsteplabel($i)\\\"\"\n"
,"}\n"
,"$f.first2m invoke $mgsteplabel(${meshoptions.firststep})\n"
,"grid $f.first2l $f.first2c -sticky nw\n"
,"global meshoptions.laststep\n"
,"ttk::label  $f.last2l -text \"Last Step: \"\n"
,"ttk::menubutton $f.last2c -menu $f.last2m -width 16\n"
,"menu $f.last2m  -tearoff 0\n"
,"foreach i $mgsteps {\n"
,"$f.last2m add command -label $mgsteplabel($i) -command \"set meshoptions.laststep $i ; $f.last2c configure -text \\\"$mgsteplabel($i)\\\"\"\n"
,"}\n"
,"$f.last2m invoke $mgsteplabel(${meshoptions.laststep})\n"
,"grid $f.last2l $f.last2c -sticky nw\n"
,"grid anchor $f center\n"
,"set msg(0) \"None\"\n"
,"set msg(1) \"Least\"\n"
,"set msg(2) \"Little\"\n"
,"set msg(3) \"Moderate\"\n"
,"set msg(4) \"Much\"\n"
,"set msg(5) \"Most\"\n"
,"global options.printmsg\n"
,"ttk::label  $f.msg2l -text \"Print Messages: \"\n"
,"menu $f.msg2m  -tearoff 0\n"
,"ttk::menubutton $f.msg2c -menu $f.msg2m  -width 16\n"
,"foreach step {0 1 2 3 4 5 } {\n"
,"$f.msg2m add command -label $msg($step) -command \"set options.printmsg $step ; $f.msg2c configure -text $msg($step)\"\n"
,"}\n"
,"$f.msg2m invoke ${options.printmsg}\n"
,"grid $f.msg2l $f.msg2c -sticky nw\n"
,"set f $w.nb.general\n"
,"ttk::labelframe $f.bts -borderwidth 3 -relief groove -text \"Additional meshing options\"\n"
,"pack $f.bts -fill x -pady 15\n"
,"ttk::frame $f.bts.btnframe\n"
,"ttk::checkbutton $f.bts.btnframe.parthread -text \"Parallel meshing thread\" \\\n"
,"-variable options.parthread\n"
,"ttk::checkbutton $f.bts.btnframe.second -text \"Second order elements\" \\\n"
,"-variable options.secondorder\n"
,"ttk::checkbutton $f.bts.btnframe.quad -text \"Quad dominated\" \\\n"
,"-variable options.quad -command {\n"
,"if { ${options.quad} } {\n"
,"set meshoptions.laststep os\n"
,"}\n"
,"}\n"
,"ttk::checkbutton $f.bts.btnframe.invtets -text \"Invert volume elements\" \\\n"
,"-variable options.inverttets\n"
,"ttk::checkbutton $f.bts.btnframe.invtrigs -text \"Invert surface elements\" \\\n"
,"-variable options.inverttrigs\n"
,"ttk::checkbutton $f.bts.btnframe.azref -text \"Automatic Z-refinement\" \\\n"
,"-variable options.autozrefine\n"
,"pack $f.bts.btnframe -anchor center\n"
,"pack $f.bts.btnframe.parthread $f.bts.btnframe.second $f.bts.btnframe.quad $f.bts.btnframe.invtets $f.bts.btnframe.invtrigs $f.bts.btnframe.azref -anchor w\n"
,"ttk::label $f.bts.btnframe.l -text \"Element order\"\n"
,"ttk::spinbox $f.bts.btnframe.elementorder2 -from 1 -to 20 -textvariable options.elementorder -width 2\n"
,"pack $f.bts.btnframe.elementorder2 $f.bts.btnframe.l  -anchor w -side left\n"
,"set f $w.nb.meshsize\n"
,"ttk::frame $f.f2\n"
,"pack $f.f2 -pady 10\n"
,"set f $f.f2\n"
,"ttk::frame $f.meshsize\n"
,"ttk::label $f.meshsize.l -text \"max mesh-size\"\n"
,"ttk::spinbox $f.meshsize.s -from 1e-9 -to 1e9 -textvariable options.meshsize -width 5 -validate focus -validatecommand \"my_validatespinbox %W %P 10\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"pack $f.meshsize -fill x\n"
,"pack $f.meshsize.s $f.meshsize.l -side right\n"
,"ttk::frame $f.minmeshsize\n"
,"ttk::label $f.minmeshsize.l -text \"min mesh-size\"\n"
,"ttk::spinbox $f.minmeshsize.s -from 0 -to 1e9 -textvariable options.minmeshsize -width 5 -validate focus -validatecommand \"my_validatespinbox %W %P 10\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"pack $f.minmeshsize -fill x\n"
,"pack $f.minmeshsize.s $f.minmeshsize.l -side right\n"
,"ttk::frame $f.grading\n"
,"ttk::label $f.grading.l -text \"mesh-size grading\"\n"
,"ttk::spinbox $f.grading.s -from 0.1 -to 1.0 -textvariable options.grading -width 5 -increment 0.1 -validate focus -validatecommand \"my_validatespinbox %W %P 3\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"pack $f.grading -fill x\n"
,"pack $f.grading.s $f.grading.l -side right\n"
,"set f $w.nb.meshsize\n"
,"ttk::labelframe $f.msf -text \"mesh-size file:\" -relief groove -borderwidth 3\n"
,"pack $f.msf\n"
,"ttk::entry $f.msf.ent -textvariable options.meshsizefilename -width 30\n"
,"ttk::button $f.msf.btn -text \"Browse\" -command {\n"
,"global options.meshsizefilename\n"
,"set types {\n"
,"{\"Meshsize file\"   {.msz}	} }\n"
,"set options.meshsizefilename [tk_getOpenFile -filetypes $types -initialfile ${options.meshsizefilename}]\n"
,"}\n"
,"pack $f.msf.ent -side left -expand yes -fill x -anchor s -padx 4 -pady 4\n"
,"pack $f.msf.btn -side left -anchor s -padx 4 -pady 4\n"
,"ttk::label $f.lab -text \"Additional mesh size restrictions:\"\n"
,"ttk::labelframe $f.csg -relief groove -borderwidth 3 -text \"CSG mesh-size\"\n"
,"pack $f.csg -fill x\n"
,"proc test {a} {puts $a}\n"
,"ttk::scale $f.csg.curvsc -orient horizontal -length 150 -from 0.2 -to 5 \\\n"
,"-variable options.curvaturesafety -takefocus 0 -command \"roundscale $f.csg.curvsc 1\"\n"
,"ttk::entry $f.csg.curve -textvariable options.curvaturesafety -width 3 \\\n"
,"-validatecommand \"my_validate %W [$f.csg.curvsc cget -from] [$f.csg.curvsc cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\" -validate focus\n"
,"ttk::label $f.csg.curvla -text \"Elements per curvature radius\"\n"
,"grid $f.csg.curvsc $f.csg.curve $f.csg.curvla -sticky nw -padx 4\n"
,"ttk::scale $f.csg.elensc -orient horizontal -length 150 -from 0.2 -to 5 \\\n"
,"-variable options.segmentsperedge -takefocus 0 -command \"roundscale $f.csg.elensc 1\"\n"
,"ttk::entry $f.csg.elene -textvariable options.segmentsperedge -width 3 \\\n"
,"-validatecommand \"my_validate %W [$f.csg.elensc cget -from] [$f.csg.elensc cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\" -validate focus\n"
,"ttk::label $f.csg.elenla -text \"Elements per edge\"\n"
,"grid $f.csg.elensc $f.csg.elene $f.csg.elenla -sticky nw -padx 4\n"
,"grid anchor $f.csg center\n"
,"ttk::labelframe $f.stl -relief groove -borderwidth 3 -text \"STL mesh-size\"\n"
,"pack $f.stl -fill x\n"
,"ttk::scale $f.stl.r2sc -orient horizontal -length 150 -from 0.2 -to 5 \\\n"
,"-variable stloptions.resthchartdistfac -takefocus 0 -command \"roundscale $f.stl.r2sc 1\"\n"
,"ttk::entry $f.stl.r2e -textvariable stloptions.resthchartdistfac -width 3 \\\n"
,"-validatecommand \"my_validate %W [$f.stl.r2sc cget -from] [$f.stl.r2sc cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\" -validate focus\n"
,"ttk::checkbutton $f.stl.r2bu -text \"STL - chart distance\" \\\n"
,"-variable stloptions.resthchartdistenable\n"
,"grid $f.stl.r2sc $f.stl.r2e $f.stl.r2bu -sticky nw -padx 4\n"
,"ttk::scale $f.stl.r6sc -orient horizontal -length 150 -from 0.2 -to 5 \\\n"
,"-variable stloptions.resthlinelengthfac -takefocus 0 -command \"roundscale $f.stl.r6sc 1\"\n"
,"ttk::entry $f.stl.r6e -textvariable stloptions.resthlinelengthfac -width 3 \\\n"
,"-validatecommand \"my_validate %W [$f.stl.r6sc cget -from] [$f.stl.r6sc cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\" -validate focus\n"
,"ttk::checkbutton $f.stl.r6bu -text \"STL - line length\" \\\n"
,"-variable stloptions.resthlinelengthenable\n"
,"grid $f.stl.r6sc $f.stl.r6e $f.stl.r6bu -sticky nw -padx 4\n"
,"ttk::scale $f.stl.r3sc -orient horizontal -length 150 -from 0.2 -to 8 \\\n"
,"-variable stloptions.resthcloseedgefac -takefocus 0 -command \"roundscale $f.stl.r3sc 1\"\n"
,"ttk::entry $f.stl.r3e -textvariable stloptions.resthcloseedgefac -width 3 \\\n"
,"-validatecommand \"my_validate %W [$f.stl.r3sc cget -from] [$f.stl.r3sc cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\" -validate focus\n"
,"ttk::checkbutton $f.stl.r3bu -text \"STL/IGES/STEP - close edges\" \\\n"
,"-variable stloptions.resthcloseedgeenable\n"
,"grid $f.stl.r3sc $f.stl.r3e $f.stl.r3bu -sticky nw -padx 4\n"
,"ttk::scale $f.stl.r1sc -orient horizontal -length 150 -from 0.2 -to 5 \\\n"
,"-variable stloptions.resthsurfcurvfac -takefocus 0 -command \"roundscale $f.stl.r1sc 1\"\n"
,"ttk::entry $f.stl.r1e -textvariable stloptions.resthsurfcurvfac -width 3 \\\n"
,"-validatecommand \"my_validate %W [$f.stl.r1sc cget -from] [$f.stl.r1sc cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\" -validate focus\n"
,"ttk::checkbutton $f.stl.r1bu -text \"STL - surface curvature\" \\\n"
,"-variable stloptions.resthsurfcurvenable\n"
,"grid $f.stl.r1sc $f.stl.r1e $f.stl.r1bu -sticky nw -padx 4\n"
,"ttk::scale $f.stl.r3bsc -orient horizontal -length 150 -from 0.2 -to 5 \\\n"
,"-variable stloptions.resthedgeanglefac -takefocus 0 -command \"roundscale $f.stl.r3bsc 1\"\n"
,"ttk::entry $f.stl.r3be -textvariable stloptions.resthedgeanglefac -width 3 \\\n"
,"-validatecommand \"my_validate %W [$f.stl.r3bsc cget -from] [$f.stl.r3bsc cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\" -validate focus\n"
,"ttk::checkbutton $f.stl.r3bbu -text \"STL - edge angle\" \\\n"
,"-variable stloptions.resthedgeangleenable\n"
,"grid $f.stl.r3bsc  $f.stl.r3be $f.stl.r3bbu -sticky nw -padx 4\n"
,"ttk::scale $f.stl.r5sc -orient horizontal -length 150 -from 0.2 -to 5 \\\n"
,"-variable stloptions.resthsurfmeshcurvfac -takefocus 0 -command \"roundscale $f.stl.r5sc 1\"\n"
,"ttk::entry $f.stl.r5e -textvariable stloptions.resthsurfmeshcurvfac -width 3 \\\n"
,"-validatecommand \"my_validate %W [$f.stl.r5sc cget -from] [$f.stl.r5sc cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\" -validate focus\n"
,"ttk::checkbutton $f.stl.r5bu -text \"STL - surface mesh curv\" \\\n"
,"-variable stloptions.resthsurfmeshcurvenable\n"
,"grid $f.stl.r5sc  $f.stl.r5e  $f.stl.r5bu -sticky nw -padx 4\n"
,"ttk::checkbutton $f.stl.recalch -text \"STL - Recalc mesh size for surface optimization\" \\\n"
,"-variable stloptions.recalchopt\n"
,"grid $f.stl.recalch -sticky n -columnspan 3 -column 0\n"
,"ttk::button $f.stl.calch -text \"Calc New H\" -command { redraw; Ng_STLCalcLocalH }\n"
,"grid $f.stl.calch -columnspan 3 -column 0\n"
,"grid anchor $f.stl center\n"
,"proc roundscale {w n_digits args} {\n"
,"set val [$w get]\n"
,"global [$w cget -variable]\n"
,"if {$n_digits == 0 } {\n"
,"set [$w cget -variable] [tcl::mathfunc::round $val]\n"
,"} else {\n"
,"set [$w cget -variable] [format \"%.[append n_digits \"f\"]\" $val]\n"
,"}\n"
,"}\n"
,"global last_accepted_sc\n"
,"proc my_validate {w mini maxi val n_digits} {\n"
,"global last_accepted_sc [$w cget -textvariable]\n"
,"if {[string length $val] == 0} {return 0}\n"
,"if {[string is double $val] == 1} {\n"
,"if { $n_digits == 0 } {\n"
,"set val [tcl::mathfunc::max $mini [tcl::mathfunc::min $maxi [tcl::mathfunc::round $val]]]\n"
,"} else {\n"
,"if { $n_digits < 9 } {\n"
,"set val [tcl::mathfunc::max $mini [tcl::mathfunc::min $maxi [format \"%.[append n_digits \"f\"]\" $val]]]\n"
,"}\n"
,"}\n"
,"set last_accepted_sc $val\n"
,"set [$w cget -textvariable] $val\n"
,"return 1\n"
,"} else {\n"
,"return 0\n"
,"}\n"
,"}\n"
,"proc my_invalid {w} {\n"
,"global last_accepted_sc [$w cget -textvariable]\n"
,"set [$w cget -textvariable] $last_accepted_sc\n"
,"}\n"
,"set f $w.nb.chartopt\n"
,"ttk::labelframe $f.mainframe -text \"STL angles\" -relief groove -borderwidth 3\n"
,"pack $f.mainframe -fill x -pady 15\n"
,"set f $f.mainframe\n"
,"ttk::label $f.labYangles -text \"Yellow Edges Angle ()\"\n"
,"ttk::scale $f.scale1 -orient horizontal -length 150 -from 0 -to 90 -variable stloptions.yangle -takefocus 0 -command \"roundscale $f.scale1 1\"\n"
,"ttk::entry $f.entry1 -textvariable stloptions.yangle -width 5 -validate focus -takefocus 0 -validatecommand \"my_validate %W [$f.scale1 cget -from] [$f.scale1 cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\"\n"
,"grid $f.scale1 $f.entry1 $f.labYangles -sticky nw -padx 4 -pady 6\n"
,"ttk::label $f.labEangles -text \"Edge Corner Angle ()\"\n"
,"ttk::scale $f.scale2 -orient horizontal -length 150 -from 0 -to 180 -variable stloptions.edgecornerangle -takefocus 0 -command \"roundscale $f.scale2 1\"\n"
,"ttk::entry $f.entry2 -textvariable stloptions.edgecornerangle -width 5 -validate focus -takefocus 0 -validatecommand \"my_validate %W [$f.scale2 cget -from] [$f.scale2 cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\"\n"
,"grid $f.scale2 $f.entry2 $f.labEangles -sticky nw -padx 4 -pady 6\n"
,"ttk::label $f.lab31 -text \"Chart Angle ()\"\n"
,"ttk::scale $f.scale3 -orient horizontal -length 150 -from 0 -to 180 -variable stloptions.chartangle -takefocus 0 -command \"roundscale $f.scale3 1\"\n"
,"ttk::entry $f.entry3 -textvariable stloptions.chartangle -width 5 -validate focus -takefocus 0 -validatecommand \"my_validate %W [$f.scale3 cget -from] [$f.scale3 cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\"\n"
,"grid $f.scale3 $f.entry3 $f.lab31 -sticky nw -padx 4 -pady 6\n"
,"ttk::label $f.lab41 -text \"Outer Chart Angle ()\"\n"
,"ttk::scale $f.scale4 -orient horizontal -length 150 -from 0 -to 180 -variable stloptions.outerchartangle -takefocus 0 -command \"roundscale $f.scale4 1\"\n"
,"ttk::entry $f.entry4 -textvariable stloptions.outerchartangle -width 5 -validate focus -takefocus 0 -validatecommand \"my_validate %W [$f.scale4 cget -from] [$f.scale4 cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\"\n"
,"grid $f.scale4 $f.entry4 $f.lab41 -sticky nw -padx 4 -pady 6\n"
,"grid anchor $f center\n"
,"global last_accepted_sp\n"
,"proc my_validatespinbox {w val n_digits} {\n"
,"global last_accepted_sp\n"
,"if {[string length $val] == 0} {return 0}\n"
,"if {[string is double $val] == 1} {\n"
,"if { $n_digits == 0 } {\n"
,"if { $n_digits < 9 } {\n"
,"set val [tcl::mathfunc::round $val] } else { set val [format \"%.[append n_digits \"f\"]\" $val]\n"
,"}\n"
,"}\n"
,"$w set [tcl::mathfunc::max [$w cget -from] [tcl::mathfunc::min [$w cget -to] $val]]\n"
,"set last_accepted_sp $val\n"
,"return 1\n"
,"} else {\n"
,"return 0\n"
,"}\n"
,"}\n"
,"proc my_invalidspinbox {w} {\n"
,"global last_accepted_sp\n"
,"$w set $last_accepted_sp\n"
,"}\n"
,"set f $w.nb.optimizer\n"
,"ttk::labelframe $f.optframe -text \"Optimization settings\" -relief groove -borderwidth 3\n"
,"pack $f.optframe -fill x -pady 15\n"
,"ttk::label $f.optframe.sosl -text \"Surface opt steps\"\n"
,"ttk::spinbox $f.optframe.soss -from 0 -to 99 -textvariable options.optsteps2d -width 5 -increment 1 -validate focus -validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"grid $f.optframe.sosl $f.optframe.soss -sticky nw;\n"
,"ttk::label $f.optframe.vosl -text \"Volume opt steps\"\n"
,"ttk::spinbox $f.optframe.voss -from 0 -to 99 -textvariable options.optsteps3d -width 5 -increment 1 -validate focus -validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"grid $f.optframe.vosl $f.optframe.voss -sticky nw;\n"
,"ttk::label $f.optframe.eswl -text \"Element size weight\"\n"
,"ttk::spinbox $f.optframe.esws -from 0 -to 1 -textvariable options.elsizeweight -width 5 -increment 0.1 -validate focus -validatecommand \"my_validatespinbox %W %P 1\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"grid $f.optframe.eswl $f.optframe.esws -sticky nw;\n"
,"ttk::label $f.optframe.weml -text \"Worst element measure\"\n"
,"ttk::spinbox $f.optframe.wems -from 1 -to 10 -textvariable options.opterrpow -width 5 -increment 1 -validate focus -validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"grid $f.optframe.weml $f.optframe.wems -sticky nw;\n"
,"grid anchor $f.optframe center\n"
,"proc roundscale_helper_osx {w val} {\n"
,"global [$w cget -variable] options.badellimit\n"
,"set [$w cget -variable] [tcl::mathfunc::round $val]\n"
,"set options.badellimit [expr [tcl::mathfunc::round $val]+160]\n"
,"}\n"
,"proc my_validate_helper_osx {w val} {\n"
,"if {[string length $val] == 0} {return 0}\n"
,"if {[string is double $val] == 1} {\n"
,"set scale_loc [lindex [winfo children [winfo parent $w]] [lsearch [winfo children [winfo parent $w]] *scale]]\n"
,"global [$scale_loc cget -variable] options.badellimit\n"
,"set [$scale_loc cget -variable] [tcl::mathfunc::max [$scale_loc cget -from] [tcl::mathfunc::min [$scale_loc cget -to] [expr [tcl::mathfunc::round $val]-160]]]\n"
,"set options.badellimit [tcl::mathfunc::max [expr [$scale_loc cget -from]+160] [tcl::mathfunc::min [expr [$scale_loc cget -to]+160] [tcl::mathfunc::round $val]]]\n"
,"return 1\n"
,"} else {\n"
,"return 0\n"
,"}\n"
,"}\n"
,"proc my_invalid_helper_osx {w} {\n"
,"global options.badellimit\n"
,"set scale_loc [lindex [winfo children [winfo parent $w]] [lsearch [winfo children [winfo parent $w]] *scale]]\n"
,"global [$scale_loc cget -variable]\n"
,"set [$scale_loc cget -variable] [tcl::mathfunc::round [$scale_loc get]]\n"
,"set options.badellimit [expr [tcl::mathfunc::round [$scale_loc get]]+160]\n"
,"}\n"
,"global dummy_badellimit\n"
,"set dummy_badellimit 15\n"
,"ttk::labelframe $f.optframe2 -text \"Bad elements\" -relief groove -borderwidth 3\n"
,"pack $f.optframe2 -fill x -pady 15 -ipady 5\n"
,"ttk::frame $f.optframe2.badellimit\n"
,"ttk::label $f.optframe2.lab -text \"bad element criterion\";\n"
,"ttk::scale $f.optframe2.scale -orient horizontal -length 100 -from 00 -to 20 -variable dummy_badellimit -takefocus 0 -command \"roundscale_helper_osx $f.optframe2.scale\"\n"
,"ttk::entry $f.optframe2.entry -textvariable options.badellimit -width 3 -validate focusout -takefocus 0 -validatecommand \"my_validate_helper_osx %W %P\" \\\n"
,"-invalidcommand \"my_invalid_helper_osx %W\"\n"
,"grid $f.optframe2.scale $f.optframe2.entry $f.optframe2.lab -padx 4 -sticky nw\n"
,"grid anchor $f.optframe2 center\n"
,"set f $w.nb.debug\n"
,"ttk::labelframe $f.f2 -text \"Advanced options\" -borderwidth 3 -relief groove\n"
,"pack $f.f2 -fill x -pady 15\n"
,"set f $f.f2\n"
,"ttk::checkbutton $f.localh -text \"Use Local Meshsize\" \\\n"
,"-variable options.localh\n"
,"ttk::checkbutton $f.delauney -text \"Use Delaunay\" \\\n"
,"-variable options.delaunay\n"
,"ttk::checkbutton $f.checkoverlap -text \"Check Overlapping\" \\\n"
,"-variable options.checkoverlap\n"
,"ttk::checkbutton $f.checkcb -text \"Check Chart Boundary\" \\\n"
,"-variable options.checkchartboundary\n"
,"ttk::checkbutton $f.blockfill -text \"Do Blockfilling\" \\\n"
,"-variable options.blockfill\n"
,"grid $f.localh  $f.delauney -sticky nw\n"
,"grid $f.checkoverlap $f.blockfill -sticky nw\n"
,"grid $f.checkcb -sticky nw\n"
,"grid anchor $f center\n"
,"set f $w.nb.debug\n"
,"proc enable_cb {w1 w2 w3} {\n"
,"Ng_SetDebugParameters\n"
,"if {[string match *selected* [$w1 state]] == 1 } {\n"
,"$w2 configure -state normal\n"
,"$w3 configure -state normal\n"
,"} else {\n"
,"$w2 configure -state disabled\n"
,"$w3 configure -state disabled\n"
,"}\n"
,"}\n"
,"ttk::labelframe $f.cb1 -text \"Debugging options\" -borderwidth 3 -relief groove\n"
,"pack $f.cb1 -fill x -pady 15\n"
,"ttk::checkbutton $f.cb1.slowchecks -text \"Slow checks\" \\\n"
,"-variable debug.slowchecks -command { Ng_SetDebugParameters }\n"
,"ttk::checkbutton $f.cb1.debugoutput -text \"Debugging outout\" \\\n"
,"-variable debug.debugoutput -command { Ng_SetDebugParameters }\n"
,"ttk::checkbutton $f.cb1.haltexline -text \"Halt on existing line\" \\\n"
,"-variable debug.haltexistingline  -command { Ng_SetDebugParameters }\n"
,"ttk::checkbutton $f.cb1.haltoverlap -text \"Halt on Overlap\" \\\n"
,"-variable debug.haltoverlap  -command { Ng_SetDebugParameters }\n"
,"ttk::checkbutton $f.cb1.haltsuc -text \"Halt on success\" \\\n"
,"-variable debug.haltsuccess  -command { Ng_SetDebugParameters }\n"
,"ttk::checkbutton $f.cb1.haltnosuc -text \"Halt on no success\" \\\n"
,"-variable debug.haltnosuccess  -command { Ng_SetDebugParameters }\n"
,"ttk::checkbutton $f.cb1.haltlargequal -text \"Halt on large quality class\" \\\n"
,"-variable debug.haltlargequalclass  -command { Ng_SetDebugParameters }\n"
,"ttk::checkbutton $f.cb1.haltseg -text \"Halt on Segment:\" \\\n"
,"-variable debug.haltsegment  -command \"enable_cb %W $f.cb1.segs.ent1 $f.cb1.segs.ent2\"\n"
,"ttk::checkbutton $f.cb1.haltnode -text \"Halt on Node:\" \\\n"
,"-variable debug.haltnode  -command \"enable_cb %W $f.cb1.segs.ent1 $f.cb1.segs.ent2\"\n"
,"ttk::frame $f.cb1.fr\n"
,"ttk::checkbutton $f.cb1.fr.cb -text \"Halt on Face:\" \\\n"
,"-variable debug.haltface -command \"enable_cb %W $f.cb1.fr.ent $f.cb1.fr.ent\"\n"
,"ttk::entry $f.cb1.fr.ent -textvariable debug.haltfacenr -width 3 -state disabled\n"
,"pack $f.cb1.fr.cb $f.cb1.fr.ent -side left\n"
,"ttk::frame $f.cb1.segs\n"
,"ttk::label $f.cb1.segs.lab1 -text \"P1:\"\n"
,"ttk::entry $f.cb1.segs.ent1 -width 6 \\\n"
,"-textvariable debug.haltsegmentp1  -state disabled\n"
,"ttk::label $f.cb1.segs.lab2 -text \"P2:\"\n"
,"ttk::entry $f.cb1.segs.ent2 -width 6 \\\n"
,"-textvariable debug.haltsegmentp2  -state disabled\n"
,"pack $f.cb1.segs.lab1 $f.cb1.segs.ent1 $f.cb1.segs.lab2 $f.cb1.segs.ent2 -side left\n"
,"grid $f.cb1.slowchecks $f.cb1.debugoutput -sticky nw\n"
,"grid $f.cb1.haltexline $f.cb1.haltoverlap -sticky nw\n"
,"grid $f.cb1.haltsuc $f.cb1.haltnosuc  -sticky nw\n"
,"grid $f.cb1.haltlargequal  $f.cb1.fr -sticky nw\n"
,"grid $f.cb1.haltnode -sticky nw\n"
,"grid $f.cb1.haltseg  -stick nw\n"
,"grid $f.cb1.segs -stick w -row 4 -rowspan 2 -column 1\n"
,"grid rowconfigure $f.cb1 3 -pad 8\n"
,"grid anchor $f.cb1 center\n"
,"ttk::checkbutton $f.cb1.showactivechart -text \"Show Active Meshing-Chart\" -variable stloptions.showactivechart -command { Ng_SetVisParameters; redraw }\n"
,"grid $f.cb1.showactivechart\n"
,"grid rowconfigure $f.cb1 3 -pad 8\n"
,"grid rowconfigure $f.cb1 5 -pad 8\n"
,"set f $w.nb.debug\n"
,"ttk::labelframe $f.cont -relief groove -borderwidth 3 -text \"Debugging visualization\"\n"
,"pack $f.cont -fill x -pady 15\n"
,"ttk::checkbutton $f.cont.multidrawing -text \"Draw Meshing\" -variable multithread_drawing\n"
,"ttk::checkbutton $f.cont.multitestmode -text \"Meshing Testmode\" -variable multithread_testmode\n"
,"ttk::button $f.cont.goon -text \"Go On\" -command { set multithread_pause 0 }\n"
,"grid $f.cont.multidrawing -sticky nw\n"
,"grid $f.cont.multitestmode -sticky nw\n"
,"grid $f.cont.goon -row 0 -rowspan 2 -column 1 -sticky w\n"
,"grid columnconfigure $f.cont 0 -pad 30\n"
,"grid columnconfigure $f.cont 1 -pad 20\n"
,"grid anchor $f.cont center\n"
,"global userlevel\n"
,"if { $userlevel < 3} {\n"
,"$w.nb delete insider\n"
,"$w.nb delete debug\n"
,"}\n"
,"ttk::frame $w.bu\n"
,"pack $w.bu -fill x -ipady 3\n"
,"ttk::button $w.bu.apl -text \"Apply\" -command {\n"
,"Ng_SetMeshingParameters\n"
,"Ng_SetDebugParameters\n"
,"}\n"
,"ttk::button $w.bu.ok -text \"Done\" -command {\n"
,"Ng_SetMeshingParameters\n"
,"Ng_SetDebugParameters\n"
,"wm withdraw .options_dlg\n"
,"}\n"
,"pack  $w.bu.apl $w.bu.ok -side left -expand yes\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Meshing Options\"\n"
,"focus .options_dlg\n"
,"}\n"
,"}\n"
,"meshingoptionsdialog\n"
,"wm withdraw .options_dlg\n"
,"proc viewingoptionsdialog { } {\n"
,"global userlevel\n"
,"set w .viewopts_dlg\n"
,"if {[winfo exists .viewopts_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"pack [ttk::notebook $w.nb]  -fill both -fill both -side top\n"
,"$w.nb add [ttk::frame $w.nb.general] -text \"General\" -underline 0\n"
,"$w.nb add [ttk::frame $w.nb.stl] -text \"STL\" -underline 0\n"
,"$w.nb add [ttk::frame $w.nb.occ] -text \"IGES/STEP\" -underline 0\n"
,"$w.nb add [ttk::frame $w.nb.mesh] -text \"Mesh\" -underline 0\n"
,"$w.nb add [ttk::frame $w.nb.light] -text \"Light\" -underline 0\n"
,"$w.nb add [ttk::frame $w.nb.edges] -text \"Edges\" -underline 0\n"
,"$w.nb add [ttk::frame $w.nb.misc] -text \"Misc.\" -underline 3\n"
,"set f $w.nb.general\n"
,"ttk::labelframe $f.gvop -text \"General viewing options\" -relief groove -borderwidth 3\n"
,"pack $f.gvop -fill x -pady 15\n"
,"set f $f.gvop\n"
,"ttk::checkbutton $f.backcol -text \"White Background\" \\\n"
,"-variable viewoptions.whitebackground \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.cross -text \"Draw Coordinate Cross\" \\\n"
,"-variable viewoptions.drawcoordinatecross \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.color -text \"Draw Color-bar\" \\\n"
,"-variable viewoptions.drawcolorbar \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.netgen -text \"Draw Netgen-logo\" \\\n"
,"-variable viewoptions.drawnetgenlogo \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"grid $f.backcol -sticky nw\n"
,"grid $f.cross -stick nw\n"
,"grid $f.color  -sticky nw\n"
,"grid $f.netgen -sticky nw\n"
,"menu $f.stylemenu\n"
,"ttk::menubutton $f.style -menu $f.stylemenu -width 10 -text [ttk::style theme use]\n"
,"grid $f.style -sticky nw\n"
,"grid anchor $f center\n"
,"foreach theme [ttk::themes] {\n"
,"$f.stylemenu add command -label  $theme \\\n"
,"-command \" $f.style configure -text $theme; puts $theme ; ttk::setTheme $theme\"\n"
,"}\n"
,"set f $w.nb.stl\n"
,"ttk::labelframe $f.show -relief groove -borderwidth 3 -text \"STL viewing options\"\n"
,"pack $f.show -fill x -pady 15\n"
,"ttk::checkbutton $f.show.showtrias -text \"Show STL-Triangles\" \\\n"
,"-variable stloptions.showtrias -command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.show.showfilledtrias -text \"Show Filled Triangles\" \\\n"
,"-variable stloptions.showfilledtrias -command { Ng_SetVisParameters; redraw }\n"
,"grid $f.show.showtrias $f.show.showfilledtrias -sticky nw\n"
,"ttk::checkbutton $f.show.showactivechart -text \"Show Active Meshing-Chart\" \\\n"
,"-variable stloptions.showactivechart -command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.show.showedges -text \"Show Edges\" \\\n"
,"-variable stloptions.showedges -command { Ng_SetVisParameters; redraw }\n"
,"grid $f.show.showactivechart $f.show.showedges -sticky nw\n"
,"grid anchor $f.show center\n"
,"ttk::checkbutton $f.show.showmarktrias -text \"Show Chart Triangles\" \\\n"
,"-variable stloptions.showmarktrias \\\n"
,"-command {set stldoctor.showfaces 0; Ng_STLDoctor; Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.show.showfaces -text \"Show Faces\" \\\n"
,"-variable stldoctor.showfaces \\\n"
,"-command {set stloptions.showmarktrias 0; Ng_STLDoctor; Ng_SetVisParameters; redraw}\n"
,"grid $f.show.showmarktrias $f.show.showfaces -sticky nw\n"
,"ttk::labelframe $f.fn -relief groove -borderwidth 3 -text \"Chart/Face number\"\n"
,"pack $f.fn -fill x\n"
,"ttk::label $f.fn.lab3 -text \"Chart/Face number\"\n"
,"ttk::scale $f.fn.scale3 -orient horizontal -length 150 -from 0 -to 200 \\\n"
,"-variable stloptions.chartnumber -command \"Ng_SetVisParameters; redraw;roundscale $f.fn.scale3 0\"\n"
,"ttk::entry $f.fn.ent3 -textvariable stloptions.chartnumber -width 3 -validate focus -takefocus 0 \\\n"
,"-validatecommand \"Ng_SetVisParameters; redraw;my_validate %W [$f.fn.scale3 cget -from] [$f.fn.scale3 cget -to] %P 0\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_SetVisParameters; redraw;\"\n"
,"grid $f.fn.scale3 $f.fn.ent3 $f.fn.lab3 -sticky nw -padx 4\n"
,"tk::label $f.fn.lab -text \"Chart/Face Offset:\";\n"
,"ttk::entry $f.fn.ent -width 3 \\\n"
,"-textvariable stloptions.chartnumberoffset -validate focus -takefocus 0 \\\n"
,"-validatecommand \"my_validate %W 0 1e9 %P 0\" \\\n"
,"-invalidcommand \"my_invalid %W\"\n"
,"grid $f.fn.lab -sticky ne -padx 4\n"
,"grid $f.fn.ent -sticky nw -padx 4 -row 1 -column 1\n"
,"grid anchor $f.fn center\n"
,"ttk::labelframe $f.advstl -text \"Advanced STL options\" -relief groove -borderwidth 3\n"
,"pack $f.advstl -fill x -pady 15\n"
,"ttk::checkbutton $f.advstl.bu1 -text \"Show Marked (Dirty) Triangles\" \\\n"
,"-variable stldoctor.showmarkedtrigs \\\n"
,"-command {Ng_STLDoctor; redraw}\n"
,"ttk::checkbutton $f.advstl.bu2 -text \"show edge corner points\" \\\n"
,"-variable stldoctor.showedgecornerpoints \\\n"
,"-command {Ng_STLDoctor; redraw}\n"
,"ttk::checkbutton $f.advstl.bu3 -text \"show touched triangle chart\" \\\n"
,"-variable stldoctor.showtouchedtrigchart \\\n"
,"-command {set stldoctor.showfaces 0; set stloptions.showmarktrias 1; \\\n"
,"Ng_STLDoctor; Ng_SetVisParameters; redraw}\n"
,"ttk::checkbutton $f.advstl.bu4 -text \"draw meshed edges\" \\\n"
,"-variable stldoctor.drawmeshededges \\\n"
,"-command {Ng_STLDoctor;}\n"
,"ttk::checkbutton $f.advstl.bu5 -text \"select with mouse\" \\\n"
,"-variable stldoctor.selectwithmouse\n"
,"grid $f.advstl.bu1 -stick nw\n"
,"grid $f.advstl.bu2 -sticky nw\n"
,"grid $f.advstl.bu3 -stick nw\n"
,"grid $f.advstl.bu4 -stick nw\n"
,"grid $f.advstl.bu5 -stick nw\n"
,"grid anchor $f.advstl center\n"
,"ttk::frame $f.advstl.tbn\n"
,"ttk::label $f.advstl.tbn.lab -text \"Select triangle by number\";\n"
,"ttk::entry $f.advstl.tbn.ent -width 5 \\\n"
,"-textvariable stldoctor.selecttrig\n"
,"pack $f.advstl.tbn.lab $f.advstl.tbn.ent -padx 4 -side left\n"
,"grid $f.advstl.tbn -sticky nw\n"
,"grid anchor $f.advstl center\n"
,"grid rowconfigure $f.advstl 4 -pad 8\n"
,"ttk::labelframe $f.vc -relief groove -borderwidth 3 -text \"Vicinity options\"\n"
,"pack $f.vc -fill x -pady 15\n"
,"ttk::checkbutton $f.vc.bu -text \"show vicinity\" \\\n"
,"-variable stldoctor.showvicinity \\\n"
,"-command {Ng_STLDoctor vicinity; redraw}\n"
,"ttk::label $f.vc.lab -text \"vicinity size\";\n"
,"ttk::scale $f.vc.scale -orient horizontal -length 150 -from 0 -to 200 \\\n"
,"-variable stldoctor.vicinity \\\n"
,"-takefocus 0 \\\n"
,"-command \"roundscale $f.vc.scale 0; Ng_STLDoctor vicinity; redraw\"\n"
,"ttk::entry $f.vc.ent -width 4 -textvariable stldoctor.vicinity -validate focus \\\n"
,"-takefocus 0 -validatecommand \"Ng_STLDoctor vicinity; redraw;my_validate %W [$f.vc.scale cget -from] [$f.vc.scale cget -to] %P 0\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_STLDoctor vicinity; redraw\"\n"
,"grid $f.vc.bu -stick nw -columnspan 3 -column 0\n"
,"grid $f.vc.scale $f.vc.ent $f.vc.lab -sticky nw -padx 4\n"
,"grid anchor $f.vc center\n"
,"set f $w.nb.occ\n"
,"ttk::labelframe $f.occframe -text \"IGES/STEP options\" -relief groove -borderwidth 3\n"
,"pack $f.occframe -fill x -pady 15 -ipady 8\n"
,"ttk::checkbutton $f.occframe.occshowsurfaces -text \"Show surfaces \" \\\n"
,"-variable occoptions.showsurfaces \\\n"
,"-command { Ng_SetOCCVisParameters; redraw }\n"
,"ttk::checkbutton $f.occframe.occshowedges -text \"Show edges \" \\\n"
,"-variable occoptions.showedges \\\n"
,"-command { Ng_SetOCCVisParameters; redraw }\n"
,"grid $f.occframe.occshowsurfaces $f.occframe.occshowedges -sticky nw -padx 4\n"
,"grid anchor $f.occframe center\n"
,"ttk::button $f.occframe.btn -text \"Rebuild visualization data\" \\\n"
,"-command {\n"
,"Ng_SetOCCVisParameters\n"
,"Ng_OCCCommand buildvisualizationmesh\n"
,"redraw\n"
,"}\n"
,"ttk::frame $f.occframe.vssm\n"
,"ttk::label $f.occframe.vssm.lab -text \"Visulization smoothness\"\n"
,"ttk::spinbox $f.occframe.vssm.sp -textvariable occoptions.deflection \\\n"
,"-from 0.1 -to 3 -increment 0.1 -width 4 -command { catch Ng_SetOCCVisParameters } \\\n"
,"-validate focus -validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"pack $f.occframe.vssm.lab $f.occframe.vssm.sp -side left -padx 4\n"
,"grid $f.occframe.vssm -sticky nw -columnspan 2 -column 0 -pady 8\n"
,"grid $f.occframe.btn -columnspan 2 -column 0 -sticky n\n"
,"ttk::labelframe $f.occframe1 -relief groove -borderwidth 3 -text \"ACIS visulization / construction\"\n"
,"pack $f.occframe1 -fill x -pady 15 -ipady 8\n"
,"ttk::label $f.occframe1.lab1 -text \"Show solid (0 for all)\"\n"
,"ttk::spinbox $f.occframe1.sp1 -textvariable occoptions.showsolidnr \\\n"
,"-from 0 -to 999 -increment 1 -width 4 -command { catch Ng_SetOCCVisParameters;redraw } \\\n"
,"-validate focus -validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"ttk::label $f.occframe1.lab2 -text \"Show solid 2\"\n"
,"ttk::spinbox $f.occframe1.sp2 -textvariable occoptions.showsolidnr2 \\\n"
,"-from 0 -to 999 -increment 1 -width 4 -command { catch Ng_SetOCCVisParameters;redraw } \\\n"
,"-validate focus -validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"ttk::button $f.occframe1.subtract -text \"Subtract (2 minus 1)\" \\\n"
,"-command {\n"
,"Ng_ACISCommand subtract ${occoptions.showsolidnr} ${occoptions.showsolidnr2}\n"
,"redraw\n"
,"}\n"
,"ttk::button $f.occframe1.combine -text \"Combine all\" \\\n"
,"-command {\n"
,"Ng_ACISCommand combineall\n"
,"redraw\n"
,"}\n"
,"grid $f.occframe1.lab1 -row 0 -column 0 -sticky ne\n"
,"grid $f.occframe1.sp1 -row 0 -column 1 -sticky nw\n"
,"grid $f.occframe1.lab2 -row 1 -column 0 -sticky ne\n"
,"grid $f.occframe1.sp2 -row 1 -column 1 -sticky nw\n"
,"grid $f.occframe1.combine -columnspan 2 -column 0 -sticky n\n"
,"grid anchor $f.occframe1 center\n"
,"set f $w.nb.mesh\n"
,"ttk::labelframe $f.center -relief groove -borderwidth 3 -text \"how shall i name you?\"\n"
,"pack $f.center -fill x -pady 15\n"
,"ttk::button $f.center.lab1 -text \"Set Center Point\" \\\n"
,"-command { Ng_SetVisParameters; Ng_Center; redraw }\n"
,"ttk::entry $f.center.ent1 -width 5 \\\n"
,"-textvariable viewoptions.centerpoint -validate focus \\\n"
,"-validatecommand \"my_validate %W 0 1e9 %P 0\" \\\n"
,"-invalidcommand \"my_invalid %W\"\n"
,"grid $f.center.ent1 $f.center.lab1 -padx 4 -pady 4 -sticky nw\n"
,"ttk::button $f.center.lab2 -text \"Draw Element\" \\\n"
,"-command { Ng_SetVisParameters; Ng_ZoomAll; redraw }\n"
,"ttk::entry $f.center.ent2 -width 5 \\\n"
,"-textvariable viewoptions.drawelement -validate focus \\\n"
,"-validatecommand \"my_validate %W 0 1e9 %P 0\" \\\n"
,"-invalidcommand \"my_invalid %W\"\n"
,"grid $f.center.ent2 $f.center.lab2 -padx 4 -pady 4 -sticky nw\n"
,"grid anchor $f.center center\n"
,"ttk::labelframe $f.meshframe -text \"Mesh visualization options\" -relief groove -borderwidth 3\n"
,"pack $f.meshframe -fill x -pady 15\n"
,"set f $f.meshframe\n"
,"ttk::checkbutton $f.showcolor -text \"Meshsize Visualization\" \\\n"
,"-variable viewoptions.colormeshsize \\\n"
,"-command { Ng_SetVisParameters;redraw; }\n"
,"ttk::checkbutton $f.showfilledtrigs -text \"Show filled triangles\" \\\n"
,"-variable viewoptions.drawfilledtrigs \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showedges -text \"Show edges\" \\\n"
,"-variable viewoptions.drawedges \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showoutline -text \"Show Triangle Outline\" \\\n"
,"-variable viewoptions.drawoutline \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showbadels -text \"Show bad elements\" \\\n"
,"-variable viewoptions.drawbadels \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showprisms -text \"Show prisms\" \\\n"
,"-variable viewoptions.drawprisms \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showpyramids -text \"Show pyramids\" \\\n"
,"-variable viewoptions.drawpyramids \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showhexes -text \"Show hexes\" \\\n"
,"-variable viewoptions.drawhexes \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showidentified -text \"Show identified points\" \\\n"
,"-variable viewoptions.drawidentified \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showmetispartition -text \"Show METIS Partition\" \\\n"
,"-variable viewoptions.drawmetispartition \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showpointnumbers -text \"Show Point-numbers\" \\\n"
,"-variable viewoptions.drawpointnumbers \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showedgenumbers -text \"Show Edge-numbers\" \\\n"
,"-variable viewoptions.drawedgenumbers \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showfacenumbers -text \"Show Face-numbers\" \\\n"
,"-variable viewoptions.drawfacenumbers \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showelementnumbers -text \"Show Element-numbers\" \\\n"
,"-variable viewoptions.drawelementnumbers \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::frame $f.frametets\n"
,"ttk::checkbutton $f.frametets.showtets -text \"\" \\\n"
,"-variable viewoptions.drawtets \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::label $f.frametets.label -text \"\\Show Tets\\rin domain\"\n"
,"ttk::spinbox $f.frametets.showtetsdomain -from 0 -to 500 -increment 1 -width 3 \\\n"
,"-textvariable viewoptions.drawtetsdomain -validate focus \\\n"
,"-command \"Ng_SetVisParameters; redraw;\" \\\n"
,"-validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"ttk::label $f.frametets.label1 -text \"Subdivision\"\n"
,"ttk::spinbox $f.frametets.subdiv -from 0 -to 8 -increment 1 -width 3 \\\n"
,"-textvariable visoptions.subdivisions -validate focus \\\n"
,"-command { Ng_SetVisParameters; Ng_Vis_Set parameters; Ng_SetNextTimeStamp; redraw } \\\n"
,"-validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"ttk::label $f.frametets.label2 -text \"Show surface\\rof domain\"\n"
,"ttk::spinbox $f.frametets.showdomain -from 0 -to 50 -increment 1 -width 3 \\\n"
,"-textvariable viewoptions.drawdomainsurf -validate focus \\\n"
,"-command { Ng_SetVisParameters; Ng_Vis_Set parameters; redraw } \\\n"
,"-validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"grid $f.frametets.showtets $f.frametets.label $f.frametets.showtetsdomain -sticky w\n"
,"grid x $f.frametets.label2 $f.frametets.showdomain -stick w\n"
,"grid x $f.frametets.label1 $f.frametets.subdiv -sticky w\n"
,"grid $f.showfilledtrigs $f.showoutline -sticky nw\n"
,"grid $f.showedges $f.showbadels -sticky nw\n"
,"grid $f.showpointnumbers $f.showedgenumbers -sticky nw\n"
,"grid $f.showfacenumbers $f.showelementnumbers -sticky nw\n"
,"grid $f.showmetispartition $f.showidentified -sticky nw\n"
,"grid $f.showcolor $f.showpyramids -sticky nw\n"
,"grid $f.showprisms $f.showhexes -sticky nw\n"
,"grid  $f.frametets -sticky n -columnspan 2 -column 0 -pady 8\n"
,"grid anchor $f center\n"
,"set f $w.nb.mesh\n"
,"ttk::labelframe $f.fshrink -text \"Element visualization\" -relief groove -borderwidth 3\n"
,"ttk::label $f.fshrink.lab -text \"Shrink elements\"\n"
,"ttk::scale $f.fshrink.scale -orient horizontal -length 200 -from 0 -to 1.0001 \\\n"
,"-command \"roundscale $f.fshrink.scale 2;Ng_SetVisParameters; after idle redraw\" \\\n"
,"-variable  viewoptions.shrink\n"
,"ttk::entry $f.fshrink.entry -textvariable viewoptions.shrink -width 4 -validate focus \\\n"
,"-takefocus 0 -validatecommand \"Ng_SetVisParameters; after idle redraw;my_validate %W [$f.fshrink.scale cget -from] [$f.fshrink.scale cget -to] %P 2\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_SetVisParameters; after idle redraw;\"\n"
,"pack $f.fshrink -fill x -ipady 8\n"
,"grid $f.fshrink.scale $f.fshrink.entry $f.fshrink.lab -padx 4\n"
,"grid anchor $f.fshrink center\n"
,"set f $w.nb.light\n"
,"ttk::labelframe $f.main -text \"Lighting options\" -relief groove -borderwidth 3\n"
,"pack $f.main -fill x -pady 15\n"
,"set f $f.main\n"
,"ttk::label $f.lab1 -text \"Ambient Light\"\n"
,"ttk::scale $f.scale1 -orient horizontal -length 200 -from 0 -to 1 \\\n"
,"-command \"roundscale $f.scale1 2; Ng_SetVisParameters; redraw\" \\\n"
,"-variable viewoptions.light.amb\n"
,"ttk::entry $f.ent1 -textvariable viewoptions.light.amb -validate focus -width 4 \\\n"
,"-validatecommand \" Ng_SetVisParameters; redraw;my_validate %W [$f.scale1 cget -from] [$f.scale1 cget -to] %P 2\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_SetVisParameters; redraw;\"\n"
,"ttk::label $f.lab2 -text \"Diffuse Light\"\n"
,"ttk::scale $f.scale2 -orient horizontal -length 200 -from 0 -to 1 \\\n"
,"-command \"roundscale $f.scale2 2; Ng_SetVisParameters; redraw \" \\\n"
,"-variable  viewoptions.light.diff\n"
,"ttk::entry $f.ent2 -textvariable viewoptions.light.diff -validate focus -width 4 \\\n"
,"-validatecommand \" Ng_SetVisParameters; redraw;my_validate %W [$f.scale2 cget -from] [$f.scale2 cget -to] %P 2\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_SetVisParameters; redraw;\"\n"
,"ttk::label $f.lab3 -text \"Specular Light\"\n"
,"ttk::scale $f.scale3 -orient horizontal -length 200 -from 0 -to 1 \\\n"
,"-command \"roundscale $f.scale3 2; Ng_SetVisParameters; redraw \" \\\n"
,"-variable  viewoptions.light.spec\n"
,"ttk::entry $f.ent3 -textvariable viewoptions.light.spec -validate focus -width 4 \\\n"
,"-validatecommand \" Ng_SetVisParameters; redraw;my_validate %W [$f.scale3 cget -from] [$f.scale3 cget -to] %P 2\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_SetVisParameters; redraw;\"\n"
,"grid $f.scale1 $f.ent1 $f.lab1 -sticky nw -padx 4 -pady 8\n"
,"grid $f.scale2 $f.ent2 $f.lab2 -sticky nw -padx 4 -pady 8\n"
,"grid $f.scale3 $f.ent3 $f.lab3 -sticky nw -padx 4 -pady 8\n"
,"grid anchor $f center\n"
,"set f $w.nb.light\n"
,"ttk::labelframe $f.main1 -text \"Material options\" -relief groove -borderwidth 3\n"
,"pack $f.main1 -fill x -pady 15\n"
,"set f $f.main1\n"
,"ttk::label $f.lab4 -text \"Material Shininess\"\n"
,"ttk::scale $f.scale4 -orient horizontal -length 200 -from 0 -to 128 \\\n"
,"-command \"roundscale $f.scale4 0; Ng_SetVisParameters; redraw \" \\\n"
,"-variable  viewoptions.mat.shininess\n"
,"ttk::entry $f.ent4 -textvariable viewoptions.mat.shininess -validate focus -width 4 \\\n"
,"-validatecommand \" Ng_SetVisParameters; redraw;my_validate %W [$f.scale4 cget -from] [$f.scale4 cget -to] %P 0\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_SetVisParameters; redraw;\"\n"
,"ttk::label $f.lab5 -text \"Material Transparency\"\n"
,"ttk::scale $f.scale5 -orient horizontal -length 200 -from 0 -to 1 \\\n"
,"-command \"roundscale $f.scale5 2; Ng_SetVisParameters; redraw \" \\\n"
,"-variable  viewoptions.mat.transp\n"
,"ttk::entry $f.ent5 -textvariable viewoptions.mat.transp -validate focus -width 4 \\\n"
,"-validatecommand \" Ng_SetVisParameters; redraw;my_validate %W [$f.scale5 cget -from] [$f.scale5 cget -to] %P 2\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_SetVisParameters; redraw;\"\n"
,"grid $f.scale4 $f.ent4 $f.lab4 -sticky nw -padx 4 -pady 8\n"
,"grid $f.scale5 $f.ent5 $f.lab5 -sticky nw -padx 4 -pady 8\n"
,"grid anchor $f center\n"
,"set f $w.nb.edges\n"
,"ttk::labelframe $f.main -text \"Edge viewing options\" -relief groove -borderwidth 3\n"
,"pack $f.main -fill x -pady 15\n"
,"set f $f.main\n"
,"ttk::frame $f.helper\n"
,"pack $f.helper -anchor center\n"
,"set f $f.helper\n"
,"ttk::checkbutton $f.showedges -text \"Show Edges\" \\\n"
,"-variable viewoptions.drawededges \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showpoints -text \"Show Points\" \\\n"
,"-variable viewoptions.drawedpoints \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showpointnrs -text \"Show Points Nrs\" \\\n"
,"-variable viewoptions.drawedpointnrs \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.showtang -text \"Show CP Tangents\" \\\n"
,"-variable viewoptions.drawedtangents \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.drawedgenrs -text \"Show Edge Nrs\" \\\n"
,"-variable viewoptions.drawededgenrs \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"pack $f.showedges $f.showpoints $f.showpointnrs $f.showtang $f.drawedgenrs -anchor w\n"
,"set f $w.nb.edges\n"
,"ttk::labelframe $f.main1 -text \"Center point\" -relief groove -borderwidth 3\n"
,"pack $f.main1 -fill x -pady 15\n"
,"set f $f.main1\n"
,"ttk::frame $f.center\n"
,"pack $f.center -anchor center\n"
,"ttk::button $f.center.btn -text \"Set Center Point\" \\\n"
,"-command { Ng_SetVisParameters; Ng_Center; redraw }\n"
,"ttk::entry $f.center.ent -width 5 -textvariable viewoptions.centerpoint -validate focus \\\n"
,"-validatecommand \"my_validate %W 0 1e9 %P 0\" \\\n"
,"-invalidcommand \"my_invalid %W\"\n"
,"grid $f.center.ent $f.center.btn -sticky nw -padx 4\n"
,"ttk::label $f.center.lab1 -text \"SpecPoint Veclen\"\n"
,"ttk::entry $f.center.ent1 -width 5 -textvariable viewoptions.specpointvlen -validate focus \\\n"
,"-validatecommand \"my_validate %W 0 1e9 %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W\"\n"
,"grid $f.center.ent1 $f.center.lab1 -sticky nw -padx 4\n"
,"set f $w.nb.misc\n"
,"ttk::labelframe $f.point -relief groove -borderwidth 3 -text \"Special point\"\n"
,"ttk::frame $f.point.dp\n"
,"ttk::checkbutton $f.point.dp.drawpoint -text \"Draw Point\" \\\n"
,"-variable viewoptions.drawspecpoint \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::entry $f.point.dp.px -width 8 -textvariable viewoptions.specpointx -validate focus \\\n"
,"-validatecommand \"my_validate %W -1e9 1e9 %P 10\" \\\n"
,"-invalidcommand \"my_invalid %W\"\n"
,"ttk::entry $f.point.dp.py -width 8 -textvariable viewoptions.specpointy -validate focus \\\n"
,"-validatecommand \"my_validate %W -1e9 1e9 %P 10\" \\\n"
,"-invalidcommand \"my_invalid %W\"\n"
,"ttk::entry $f.point.dp.pz -width 8 -textvariable viewoptions.specpointz -validate focus \\\n"
,"-validatecommand \"my_validate %W -1e9 1e9 %P 10\" \\\n"
,"-invalidcommand \"my_invalid %W\"\n"
,"grid $f.point.dp.drawpoint $f.point.dp.px $f.point.dp.py $f.point.dp.pz -sticky nw -padx 4;\n"
,"ttk::checkbutton $f.point.dp.center -text \"Use as Center\" \\\n"
,"-variable viewoptions.usecentercoords \\\n"
,"-command {\n"
,"if { ${viewoptions.usecentercoords} } {\n"
,"set viewoptions.centerx ${viewoptions.specpointx}\n"
,"set viewoptions.centery ${viewoptions.specpointy}\n"
,"set viewoptions.centerz ${viewoptions.specpointz}\n"
,"Ng_SetVisParameters; Ng_Center\n"
,"redraw\n"
,"} {\n"
,"Ng_SetVisParameters\n"
,"}\n"
,"}\n"
,"grid $f.point.dp.center -sticky nw -padx 4\n"
,"pack $f.point.dp\n"
,"pack $f.point -fill x -ipady 3 -pady 15\n"
,"ttk::frame $w.bu\n"
,"pack $w.bu -fill x -ipady 3\n"
,"ttk::button $w.bu.done -text \"Done\" -command {\n"
,"Ng_SetVisParameters;\n"
,"redraw\n"
,"destroy .viewopts_dlg\n"
,"}\n"
,"ttk::button $w.bu.apply -text \"Apply\" -command {\n"
,"Ng_SetVisParameters;\n"
,"redraw\n"
,"}\n"
,"pack $w.bu.apply $w.bu.done -expand yes -side left\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Viewing options\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"proc clipplanecommand { { optionalvar 0 } } {\n"
,"Ng_SetVisParameters\n"
,"after idle redraw\n"
,"}\n"
,"set clippingdialog_pop1 0\n"
,"set clippingdialog_pop2 0\n"
,"set clippingdialog_pop3 0\n"
,"set clippingdialog_pop4 0\n"
,"proc clippingdialog { } {\n"
,"global clippingdialog_pop1\n"
,"global clippingdialog_pop2\n"
,"global clippingdialog_pop3\n"
,"global clippingdialog_pop4\n"
,"set clippingdialog_pop1 1\n"
,"set clippingdialog_pop2 1\n"
,"set clippingdialog_pop3 1\n"
,"set clippingdialog_pop4 1\n"
,"set w .clipping_dlg\n"
,"if {[winfo exists .clipping_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"ttk::frame $w.background\n"
,"pack $w.background -fill x -fill y\n"
,"set w $w.background\n"
,"ttk::labelframe $w.main -text \"Visual clipping\" -relief groove -borderwidth 3\n"
,"pack $w.main -fill x -pady 15\n"
,"set w $w.main\n"
,"ttk::label $w.lab1 -text \"Normal x\"\n"
,"ttk::scale $w.scale1 -orient horizontal -length 300 -from -1 -to 1 \\\n"
,"-variable  viewoptions.clipping.nx \\\n"
,"-command \"roundscale $w.scale1 2; clipplanecommand \"\n"
,"ttk::entry $w.entry1 -width 5 -textvariable  viewoptions.clipping.nx \\\n"
,"-validate focus -validatecommand \" clipplanecommand;my_validate %W [$w.scale1 cget -from] [$w.scale1 cget -to] %P 2\" \\\n"
,"-invalidcommand \"my_invalid %W; clipplanecommand\"\n"
,"ttk::label $w.lab2 -text \"Normal y\"\n"
,"ttk::scale $w.scale2 -orient horizontal -length 300 -from -1 -to 1 \\\n"
,"-variable  viewoptions.clipping.ny \\\n"
,"-command \"roundscale $w.scale2 2; clipplanecommand \"\n"
,"ttk::entry $w.entry2 -width 5 -textvariable  viewoptions.clipping.ny \\\n"
,"-validate focus -validatecommand \" clipplanecommand;my_validate %W [$w.scale2 cget -from] [$w.scale2 cget -to] %P 2\" \\\n"
,"-invalidcommand \"my_invalid $w.entry2;clipplanecommand\"\n"
,"ttk::label $w.lab3 -text \"Normal z\"\n"
,"ttk::scale $w.scale3 -orient horizontal -length 300 -from -1 -to 1 \\\n"
,"-variable  viewoptions.clipping.nz \\\n"
,"-command \"roundscale $w.scale3 2; clipplanecommand \"\n"
,"ttk::entry $w.entry3 -width 5 -textvariable  viewoptions.clipping.nz \\\n"
,"-validate focus -validatecommand \" clipplanecommand;my_validate %W [$w.scale3 cget -from] [$w.scale3 cget -to] %P 2\" \\\n"
,"-invalidcommand \"my_invalid %W;clipplanecommand\"\n"
,"ttk::label $w.lab4 -text \"Distance\"\n"
,"ttk::scale $w.scale4 -orient horizontal -length 300 -from -1 -to 1.001 \\\n"
,"-variable  viewoptions.clipping.dist \\\n"
,"-command \"roundscale $w.scale4 3; clipplanecommand \"\n"
,"ttk::entry $w.entry4 -width 5 -textvariable  viewoptions.clipping.dist \\\n"
,"-validate focus -validatecommand \" clipplanecommand;my_validate %W [$w.scale4 cget -from] [$w.scale4 cget -to] %P 3\" \\\n"
,"-invalidcommand \"my_invalid %W;clipplanecommand\"\n"
,"proc my_Press {w x y} {\n"
,"set inc [expr {([$w get $x $y] <= [$w get]) ? -1 : 1}]\n"
,"ttk::Repeatedly ttk::scale::Increment $w [expr 0.001*$inc]\n"
,"}\n"
,"bind $w.scale4 <ButtonPress-1> { if { [string match *slider [%W identify %x %y]] == 0 } { my_Press %W %x %y;break } }\n"
,"bind $w.scale4 <ButtonRelease-1> {ttk::scale::Release %W %x %y}\n"
,"ttk::label $w.lab5 -text \"Additional\\rDistance\"\n"
,"ttk::scale $w.scale5 -orient horizontal -length 300 -from -1 -to 1.001 \\\n"
,"-variable  viewoptions.clipping.dist2 \\\n"
,"-command \"roundscale $w.scale5 3; clipplanecommand \"\n"
,"ttk::entry $w.entry5 -width 5 -textvariable  viewoptions.clipping.dist2 \\\n"
,"-validate focus -validatecommand \" clipplanecommand;my_validate %W [$w.scale5 cget -from] [$w.scale5 cget -to] %P 3\" \\\n"
,"-invalidcommand \"my_invalid %W;clipplanecommand\"\n"
,"bind $w.scale5 <ButtonPress-1> { if { [string match *slider [%W identify %x %y]] == 0 } { my_Press %W %x %y;break } }\n"
,"bind $w.scale5 <ButtonRelease-1> {ttk::scale::Release %W %x %y}\n"
,"ttk::label $w.clipdomainlabel -text \"Clip only domain\"\n"
,"ttk::spinbox $w.clipdomainspinb -from 0 -to 500 -increment 1 -width 3 \\\n"
,"-textvariable viewoptions.clipping.onlydomain -validate focus \\\n"
,"-command {clipplanecommand;} \\\n"
,"-validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"ttk::label $w.donotclipdomainlabel -text \"Do not clip domain\"\n"
,"ttk::spinbox $w.donotclipdomainspinb -from 0 -to 500 -increment 1 -width 3 \\\n"
,"-textvariable viewoptions.clipping.notdomain -validate focus \\\n"
,"-command \"clipplanecommand\" \\\n"
,"-validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\"\n"
,"grid $w.scale1 $w.entry1 $w.lab1 -sticky nw -padx 4 -pady 14\n"
,"grid $w.scale2 $w.entry2 $w.lab2 -sticky nw -padx 4 -pady 14\n"
,"grid $w.scale3 $w.entry3 $w.lab3 -sticky nw -padx 4 -pady 14\n"
,"grid $w.scale4 $w.entry4 $w.lab4 -sticky nw -padx 4 -pady 14\n"
,"grid $w.scale5 $w.entry5 $w.lab5 -sticky w -padx 4 -pady 14\n"
,"grid $w.clipdomainlabel -sticky ne -padx 4 -pady 14\n"
,"grid $w.clipdomainspinb -sticky nw -padx 4 -pady 14 -column 1 -row 5\n"
,"grid $w.donotclipdomainlabel -sticky ne -padx 4 -pady 14\n"
,"grid $w.donotclipdomainspinb -sticky nw -padx 4 -pady 14 -column 1 -row 6\n"
,"grid anchor $w center\n"
,"set w .clipping_dlg.background.main\n"
,"ttk::checkbutton $w.cb1 -text \"Enable clipping\" \\\n"
,"-variable viewoptions.clipping.enable \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"grid  $w.cb1 -columnspan 2 -sticky ne\n"
,"ttk::frame $w.bu\n"
,"grid $w.bu;\n"
,"ttk::button $w.cancle -text \"Done\" -command \"destroy .clipping_dlg\"\n"
,"grid $w.cancle -columnspan 3 -pady 16\n"
,"set w .clipping_dlg\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Clipping Plane\"\n"
,"focus $w\n"
,"clipplanecommand\n"
,"}\n"
,"}\n"
,"proc refinementdialog { } {\n"
,"set w .refinement_dlg\n"
,"if {[winfo exists .refinement_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"global localh\n"
,"set localh 1\n"
,"ttk::frame $w.meshsize\n"
,"ttk::label $w.meshsize.l1 -text \"max mesh-size: \"\n"
,"ttk::spinbox $w.meshsize.sp1 -from 1e-6 -to 1e6 -textvariable options.meshsize -validate focus -validatecommand \"my_validatespinbox %W %P 4\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -width 6 -increment 0.1\n"
,"ttk::frame $w.meshsizeloc\n"
,"ttk::label $w.meshsizeloc.l1 -text \"local mesh-size: \"\n"
,"ttk::spinbox $w.meshsizeloc.sp1 -from 1e-6 -to 1e6 -textvariable localh -validate focus -validatecommand \"my_validatespinbox %W %P 4\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -width 6 -increment 0.1\n"
,"pack $w.meshsize\n"
,"pack $w.meshsizeloc\n"
,"grid $w.meshsize.l1 $w.meshsize.sp1\n"
,"grid $w.meshsizeloc.l1 $w.meshsizeloc.sp1\n"
,"ttk::button $w.restface -text \"Restrict H at face\"  \\\n"
,"-command {\n"
,".refinement_dlg.meshsize invoke\n"
,".refinement_dlg.loch invoke\n"
,"Ng_RestrictH face $localh\n"
,"}\n"
,"ttk::button $w.restedge -text \"Restrict H at edge\"  \\\n"
,"-command {\n"
,".refinement_dlg.meshsize invoke\n"
,".refinement_dlg.loch invoke\n"
,"Ng_RestrictH edge $localh\n"
,"}\n"
,"ttk::button $w.restelement -text \"Restrict H at element\"  \\\n"
,"-command {\n"
,".refinement_dlg.meshsize invoke\n"
,".refinement_dlg.loch invoke\n"
,"Ng_RestrictH element $localh\n"
,"}\n"
,"ttk::button $w.restpoint -text \"Restrict H at point\"  \\\n"
,"-command {\n"
,".refinement_dlg.meshsize invoke\n"
,".refinement_dlg.loch invoke\n"
,"Ng_RestrictH point $localh\n"
,"}\n"
,"pack $w.restface $w.restedge $w.restelement $w.restpoint\n"
,"ttk::button $w.anisoedge -text \"Declare Anisotropic edge\"  \\\n"
,"-command {\n"
,"Ng_Anisotropy edge\n"
,"}\n"
,"pack $w.anisoedge\n"
,"frame $w.bu\n"
,"pack $w.bu -fill x -ipady 3\n"
,"ttk::button $w.bu.cancle -text \"Done\" -command \"destroy .refinement_dlg\"\n"
,"ttk::button $w.bu.refine -text \"Refine\"  \\\n"
,"-command {\n"
,"set oldnp 0; set newnp $status_np;\n"
,"while { $oldnp < $newnp } {\n"
,"set level [expr $level+1]\n"
,"Ng_Bisect;\n"
,"Ng_HighOrder ${options.elementorder}\n"
,"Ng_ReadStatus;\n"
,"redraw;\n"
,"set oldnp $newnp\n"
,"set newnp $status_np\n"
,"puts \"oldnp $oldnp newnp $newnp\"\n"
,"}\n"
,"}\n"
,"ttk::button $w.bu.zrefine -text \"Z-Refine\"  \\\n"
,"-command { Ng_ZRefinement; Ng_ReadStatus; redraw; }\n"
,"pack $w.bu.zrefine $w.bu.refine $w.bu.cancle  -expand yes -side left\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Select Refinement\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"proc bcpropdialog { } {\n"
,"set w .bcprop_dlg\n"
,"if {[winfo exists .bcprop_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"} {\n"
,"toplevel $w\n"
,"ttk::frame $w.face  -borderwidth 3\n"
,"pack $w.face -fill x\n"
,"ttk::label $w.face.lab -text \"face index:\"\n"
,"ttk::label $w.face.ent -text 1\n"
,"ttk::button $w.face.next -text \"next\" -command {\n"
,"set w .bcprop_dlg;\n"
,"set facenr [$w.face.ent cget -text]\n"
,"if {$facenr == [Ng_BCProp getnfd]} {\n"
,"set facenr 1\n"
,"} {\n"
,"set facenr [expr $facenr + 1]\n"
,"}\n"
,"$w.face.ent configure -text $facenr\n"
,"Ng_BCProp setactive $facenr\n"
,"set bcnr [Ng_BCProp getbc $facenr]\n"
,"$w.bc.ent delete 0 end\n"
,"$w.bc.ent insert 0 $bcnr\n"
,"redraw\n"
,"}\n"
,"ttk::button $w.face.prev -text \"prev\" -command {\n"
,"set w .bcprop_dlg;\n"
,"set facenr [$w.face.ent cget -text]\n"
,"if {$facenr == 1} {\n"
,"set facenr [Ng_BCProp getnfd]\n"
,"} {\n"
,"set facenr [expr $facenr - 1]\n"
,"}\n"
,"$w.face.ent configure -text $facenr\n"
,"Ng_BCProp setactive $facenr\n"
,"set bcnr [Ng_BCProp getbc $facenr]\n"
,"$w.bc.ent delete 0 end\n"
,"$w.bc.ent insert 0 $bcnr\n"
,"redraw\n"
,"}\n"
,"pack $w.face.lab $w.face.ent $w.face.prev $w.face.next  -side left\n"
,"ttk::frame $w.bc  -borderwidth 3\n"
,"pack $w.bc -fill x\n"
,"ttk::label $w.bc.lab -text \"bc property:\"\n"
,"entry $w.bc.ent -width 5 -relief sunken\n"
,"ttk::button $w.bc.but -text \"change\" -command {\n"
,"set w .bcprop_dlg;\n"
,"Ng_BCProp setbc [$w.face.ent cget -text] [$w.bc.ent get];\n"
,"}\n"
,"ttk::button $w.bc.but2 -text \"all\" -command {\n"
,"set w .bcprop_dlg;\n"
,"Ng_BCProp setall [$w.bc.ent get];\n"
,"}\n"
,"pack $w.bc.lab $w.bc.ent $w.bc.but $w.bc.but2 -side left  -expand yes\n"
,"ttk::frame $w.bcname  -borderwidth 3\n"
,"pack $w.bcname -fill x\n"
,"ttk::label $w.bcname.lab -text \"bc name:\"\n"
,"ttk::label $w.bcname.ent -text \"-\"\n"
,"pack $w.bcname.lab $w.bcname.ent -side left  -expand yes\n"
,"ttk::frame $w.bu\n"
,"pack $w.bu -fill x -ipady 3\n"
,"ttk::button $w.bu.close -text \"Close\" -command { destroy .bcprop_dlg }\n"
,"pack $w.bu.close  -expand yes -side left\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Boundary Conditions\"\n"
,"}\n"
,"focus $w\n"
,"set facenr [Ng_BCProp getactive]\n"
,"$w.face.ent configure -text $facenr\n"
,"set bcnr [Ng_BCProp getbc $facenr]\n"
,"$w.bc.ent delete 0 end\n"
,"$w.bc.ent insert 0 $bcnr\n"
,"set bcname [Ng_BCProp getbcname $facenr]\n"
,"$w.bcname.ent configure -text $bcname\n"
,"}\n"
,"proc currmeshcoloursdialog { } {\n"
,"set w .currmeshcolours_dlg\n"
,"if {[winfo exists .currmeshcolours_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"global facecolslist\n"
,"frame $w.facecols -borderwidth 3\n"
,"listbox $w.facecols.list -yscroll \"$w.facecols.scroll set\" -selectmode single -setgrid 1 -width 32 -height 12\n"
,"scrollbar $w.facecols.scroll -command \"$w.facecols.list yview\"\n"
,"pack $w.facecols.scroll -side right -fill y\n"
,"pack $w.facecols.list -side left -expand yes -fill both\n"
,"Ng_CurrentFaceColours getcolours facecolslist\n"
,"set i 1\n"
,"foreach el $facecolslist {\n"
,"set hel [format \"%d: (%.4f %.4f %.4f)\" $i [ lindex $el 0 ] [ lindex $el 1 ] [ lindex $el 2 ]]\n"
,"incr i\n"
,"$w.facecols.list insert end $hel }\n"
,"frame $w.bu1 -borderwidth 3\n"
,"ttk::button $w.bu1.showonly -text \"show only\" -command {\n"
,"Ng_CurrentFaceColours showonly [.currmeshcolours_dlg.facecols.list curselection]\n"
,"redraw\n"
,"}\n"
,"ttk::button $w.bu1.hideonly -text \"hide only\" -command {\n"
,"Ng_CurrentFaceColours hideonly [.currmeshcolours_dlg.facecols.list curselection]\n"
,"redraw\n"
,"}\n"
,"ttk::button $w.bu1.showalso -text \"show\" -command {\n"
,"Ng_CurrentFaceColours showalso [.currmeshcolours_dlg.facecols.list curselection]\n"
,"redraw\n"
,"}\n"
,"ttk::button $w.bu1.hidealso -text \"hide\" -command {\n"
,"Ng_CurrentFaceColours hidealso [.currmeshcolours_dlg.facecols.list curselection]\n"
,"redraw\n"
,"}\n"
,"pack $w.bu1.showonly $w.bu1.hideonly $w.bu1.showalso $w.bu1.hidealso -expand yes -fill x -padx 2 -pady 2 -side left\n"
,"frame $w.bu2\n"
,"ttk::button $w.bu2.showall -text \"show all\" -command {\n"
,"Ng_CurrentFaceColours showall\n"
,"redraw\n"
,"}\n"
,"ttk::button $w.bu2.hideall -text \"hide all\" -command {\n"
,"Ng_CurrentFaceColours hideall\n"
,"redraw\n"
,"}\n"
,"pack $w.bu2.showall $w.bu2.hideall -expand yes -fill x -padx 2 -pady 2 -side left\n"
,"frame $w.bu3\n"
,"ttk::button $w.bu3.close -text \"close\" -command {\n"
,"destroy .currmeshcolours_dlg\n"
,"}\n"
,"pack $w.bu3.close -expand yes -fill x -pady 3 -side right\n"
,"pack $w.facecols -side top -expand yes -fill x -fill y\n"
,"pack $w.bu3 -side bottom\n"
,"pack $w.bu2 -side bottom\n"
,"pack $w.bu1 -expand yes -fill x -side left\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Inspect Mesh Colours\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"proc surfacemeshsizedialog { } {\n"
,"set w .surfacemeshsize_dlg\n"
,"if {[winfo exists .surfacemeshsize_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"} {\n"
,"toplevel $w\n"
,"frame $w.face  -borderwidth 3\n"
,"pack $w.face -fill x -padx 5\n"
,"ttk::label $w.face.lab -text \"face index:\"\n"
,"ttk::label $w.face.ent -text 1\n"
,"ttk::button $w.face.next -text \"next\" -command {\n"
,"set w .surfacemeshsize_dlg;\n"
,"set facenr [$w.face.ent cget -text]\n"
,"if {$facenr == [Ng_SurfaceMeshSize getnfd]} {\n"
,"set facenr 1\n"
,"} {\n"
,"set facenr [expr $facenr + 1]\n"
,"}\n"
,"$w.face.ent configure -text $facenr\n"
,"Ng_SurfaceMeshSize setactive $facenr\n"
,"set surfms [Ng_SurfaceMeshSize getsurfms $facenr]\n"
,"$w.sms.ent delete 0 end\n"
,"$w.sms.ent insert 0 $surfms\n"
,"redraw\n"
,"}\n"
,"ttk::button $w.face.prev -text \"prev\" -command {\n"
,"set w .surfacemeshsize_dlg;\n"
,"set facenr [$w.face.ent cget -text]\n"
,"if {$facenr == 1} {\n"
,"set facenr [Ng_SurfaceMeshSize getnfd]\n"
,"} {\n"
,"set facenr [expr $facenr - 1]\n"
,"}\n"
,"$w.face.ent configure -text $facenr\n"
,"Ng_SurfaceMeshSize setactive $facenr\n"
,"set surfms [Ng_SurfaceMeshSize getsurfms $facenr]\n"
,"$w.sms.ent delete 0 end\n"
,"$w.sms.ent insert 0 $surfms\n"
,"redraw\n"
,"}\n"
,"pack $w.face.lab $w.face.ent $w.face.prev $w.face.next  -side left\n"
,"frame $w.sms  -borderwidth 3\n"
,"pack $w.sms -fill x\n"
,"ttk::label $w.sms.lab -text \"max mesh size:\"\n"
,"entry $w.sms.ent -width 8 -relief sunken\n"
,"ttk::button $w.sms.but -text \"change\" -command {\n"
,"set w .surfacemeshsize_dlg;\n"
,"Ng_SurfaceMeshSize setsurfms [$w.face.ent cget -text] [$w.sms.ent get];\n"
,"}\n"
,"ttk::button $w.sms.but2 -text \"all\" -command {\n"
,"set w .surfacemeshsize_dlg;\n"
,"Ng_SurfaceMeshSize setall [$w.sms.ent get];\n"
,"}\n"
,"pack $w.sms.lab $w.sms.ent $w.sms.but $w.sms.but2 -side left -padx 5 -expand yes\n"
,"frame $w.bu\n"
,"pack $w.bu -fill x -ipady 3\n"
,"ttk::button $w.bu.close -text \"Close\" -command { destroy .surfacemeshsize_dlg }\n"
,"pack $w.bu.close  -expand yes -side left\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Edit Surface Mesh Size\"\n"
,"}\n"
,"focus $w\n"
,"set facenr [Ng_SurfaceMeshSize getactive]\n"
,"$w.face.ent configure -text $facenr\n"
,"set surfms [Ng_SurfaceMeshSize getsurfms $facenr]\n"
,"$w.sms.ent delete 0 end\n"
,"$w.sms.ent insert 0 $surfms\n"
,"}\n"
,"proc METISdialog { } {\n"
,"set w .metis_dlg\n"
,"set w.parts 64\n"
,"if {[winfo exists .metis_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"} {\n"
,"toplevel $w\n"
,"frame $w.a -borderwidth 0\n"
,"frame $w.b -borderwidth 0\n"
,"pack $w.a $w.b\n"
,"ttk::label $w.a.lab -text \"Number of partitions:\"\n"
,"entry $w.a.ent -textvariable w.parts -width 4 -relief sunken\n"
,"ttk::button $w.b.start -text \"Start METIS\" -command {\n"
,"Ng_Metis ${w.parts}\n"
,"redraw\n"
,"}\n"
,"ttk::button $w.b.cancel -text \"Cancel\" -command { destroy .metis_dlg }\n"
,"pack $w.a.lab $w.a.ent -side left  -expand yes\n"
,"pack $w.b.start $w.b.cancel -side left\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"METIS Partitioning\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"proc stloptionsdialog { } {\n"
,"set w .stlopts_dlg\n"
,"if {[winfo exists .stlopts_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"pack [ttk::notebook $w.nb]  -fill both -fill both -side top\n"
,"frame $w.bu\n"
,"pack $w.bu -fill x -ipady 3\n"
,"ttk::button $w.bu.apply -text \"Apply\" -command { redraw; Ng_GenerateMesh 1 2}\n"
,"ttk::button $w.bu.cancle -text \"Done\" -command { destroy .stlopts_dlg }\n"
,"pack $w.bu.cancle  $w.bu.apply  -side left -expand yes\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"STL Options\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"proc stldoctordialog { } {\n"
,"Ng_STLDoctor 0 0\n"
,"set wd .stldoctor_dlg\n"
,"if {[winfo exists .stldoctor_dlg] == 1} {\n"
,"wm withdraw $wd\n"
,"wm deiconify $wd\n"
,"focus $wd\n"
,"} {\n"
,"toplevel $wd\n"
,"pack [ttk::notebook $wd.nb] -fill both -fill both -side top\n"
,"$wd.nb add [ttk::frame $wd.nb.general] -text \"General\" -underline 0\n"
,"$wd.nb add [ttk::frame $wd.nb.topology] -text \"Edit Topology\" -underline 5\n"
,"$wd.nb add [ttk::frame $wd.nb.edges] -text \"Edit Edges\" -underline 5\n"
,"$wd.nb add [ttk::frame $wd.nb.normals] -text \"Edit Normals\" -underline 5\n"
,"$wd.nb add [ttk::frame $wd.nb.advanced] -text \"Advanced\" -underline 0\n"
,"set f $wd.nb.general\n"
,"ttk::frame $f.selectframe -borderwidth 0\n"
,"ttk::checkbutton $f.selectframe.showtrias -text \"Show STL-Triangles\" \\\n"
,"-variable stloptions.showtrias -command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $f.selectframe.showfilledtrias -text \"Show Filled Triangles\" \\\n"
,"-variable stloptions.showfilledtrias -command { Ng_SetVisParameters; redraw }\n"
,"set selmodevals { 0 1 2 3 4 }\n"
,"set selmodelabs(0) \"triangle\"\n"
,"set selmodelabs(1) \"edge\"\n"
,"set selmodelabs(2) \"point\"\n"
,"set selmodelabs(3) \"line\"\n"
,"set selmodelabs(4) \"line cluster\"\n"
,"global stldoctor.selectmode\n"
,"ttk::label  $f.selectframe.dblcsellab -text \"Double Click selects : \"\n"
,"ttk::menubutton $f.selectframe.dblcselbut -menu $f.selectframe.dblcselmen -text \"triangle\" -width 16\n"
,"menu $f.selectframe.dblcselmen  -tearoff 0\n"
,"foreach selmode { 0 1 2 3 4 } {\n"
,"$f.selectframe.dblcselmen add command -label $selmodelabs($selmode) \\\n"
,"-command \"set stldoctor.selectmode $selmode ; Ng_STLDoctor ; $f.selectframe.dblcselbut configure -text \\\"$selmodelabs($selmode)\\\"\"\n"
,"}\n"
,"$f.selectframe.dblcselmen invoke $selmodelabs(${stldoctor.selectmode})\n"
,"pack $f.selectframe\n"
,"grid $f.selectframe.showtrias -sticky nw\n"
,"grid $f.selectframe.showfilledtrias -sticky nw\n"
,"grid $f.selectframe.dblcsellab $f.selectframe.dblcselbut -sticky nw\n"
,"ttk::frame $f.sm\n"
,"pack $f.sm -fill x\n"
,"ttk::checkbutton $f.sm.bu -text \"select with mouse\" \\\n"
,"-variable stldoctor.selectwithmouse\n"
,"pack $f.sm.bu\n"
,"ttk::frame $f.st -relief groove -borderwidth 3\n"
,"pack $f.st -fill x\n"
,"ttk::label $f.st.lab -text \"Select triangle by number\";\n"
,"ttk::entry $f.st.ent -width 5 \\\n"
,"-textvariable stldoctor.selecttrig\n"
,"pack $f.st.ent $f.st.lab -side left -expand yes\n"
,"ttk::frame $f.vc -relief groove -borderwidth 3\n"
,"pack $f.vc -fill x\n"
,"ttk::checkbutton $f.vc.bu -text \"show vicinity\" \\\n"
,"-variable stldoctor.showvicinity \\\n"
,"-command {Ng_STLDoctor vicinity; redraw}\n"
,"ttk::label $f.vc.lab -text \"vicinity size\";\n"
,"ttk::frame $f.vc.sc\n"
,"ttk::scale $f.vc.sc.scale -orient horizontal -length 200 -from 0 -to 200 \\\n"
,"-variable stldoctor.vicinity -takefocus 0 -command \"Ng_STLDoctor vicinity; redraw; roundscale $f.vc.sc.scale 0\"\n"
,"ttk::entry $f.vc.sc.entry -textvariable stldoctor.vicinity -width 3 \\\n"
,"-validatecommand \"Ng_STLDoctor vicinity; redraw; my_validate %W [$f.vc.sc.scale cget -from] [$f.vc.sc.scale cget -to] %P 0\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_STLDoctor vicinity; redraw;\" -validate focus\n"
,"ttk::label $f.vc.sc.lab -text \"vicinity size\"\n"
,"grid $f.vc.sc.scale $f.vc.sc.entry $f.vc.sc.lab -sticky nw -padx 4\n"
,"pack $f.vc.bu $f.vc.lab $f.vc.sc -expand yes\n"
,"ttk::frame $f.ge -relief groove -borderwidth 0\n"
,"pack $f.ge -expand yes\n"
,"ttk::button $f.ge.neighbourangles -text \"calc neighbourangles\" -command {Ng_STLDoctor neighbourangles}\n"
,"ttk::button $f.ge.showcoords -text \"show coords of touched triangle\" -command {Ng_STLDoctor showcoords}\n"
,"ttk::button $f.ge.moveptm -text \"move point to middle of trianglepoints\" -command {Ng_STLDoctor movepointtomiddle; redraw}\n"
,"ttk::button $f.ge.destroy0trigs -text \"destroy 0-volume triangles\" -command {Ng_STLDoctor destroy0trigs}\n"
,"grid $f.ge.neighbourangles -sticky nw -padx 4 -pady 4\n"
,"grid $f.ge.showcoords -sticky nw -padx 4 -pady 4\n"
,"grid $f.ge.moveptm -sticky nw -padx 4 -pady 4\n"
,"grid $f.ge.destroy0trigs -sticky nw -padx 4 -pady 4\n"
,"ttk::button $f.ge.cancle -text \"Done\" -command {destroy .stldoctor_dlg }\n"
,"grid $f.ge.cancle  -sticky nw\n"
,"set f $wd.nb.topology\n"
,"ttk::frame $f.oc -relief groove -borderwidth 3\n"
,"pack $f.oc -pady 3 -ipady 3 -fill y -fill x\n"
,"ttk::frame $f.oc.oc1 -borderwidth 0\n"
,"pack $f.oc.oc1\n"
,"ttk::button $f.oc.oc1.bu -text \"invert orientation \\n of selected trig\" -command {Ng_STLDoctor invertselectedtrig; redraw }\n"
,"ttk::button $f.oc.oc1.bu2 -text \"orient after \\n selected trig\" -command {Ng_STLDoctor orientafterselectedtrig; redraw }\n"
,"ttk::button $f.oc.oc1.toperr -text \"mark inconsistent triangles\" -command {Ng_STLDoctor marktoperrortrigs; redraw }\n"
,"ttk::button $f.oc.oc1.deltrig -text \"delete selected triangle\" -command {Ng_STLDoctor deleteselectedtrig; redraw }\n"
,"ttk::button $f.oc.oc1.geosmooth -text \"geometric smoothing\" -command {Ng_STLDoctor smoothgeometry; redraw }\n"
,"grid $f.oc.oc1.bu x $f.oc.oc1.bu2 -sticky nw -padx 4 -pady 4\n"
,"grid $f.oc.oc1.toperr - x -sticky nw -padx 4 -pady 4\n"
,"grid $f.oc.oc1.deltrig - x -sticky nw -padx 4 -pady 4\n"
,"grid $f.oc.oc1.geosmooth - x -sticky nw -padx 4 -pady 4\n"
,"set f $wd.nb.edges\n"
,"ttk::frame $f.be -relief groove -borderwidth 3\n"
,"pack $f.be -fill x\n"
,"ttk::frame $f.be.frame\n"
,"pack $f.be.frame -ipady 4 -pady 4\n"
,"ttk::label $f.be.frame.lab -text \"build edges with yellow angle:\";\n"
,"ttk::scale $f.be.frame.scale -orient horizontal -length 200 -from 0 -to 200 \\\n"
,"-variable stloptions.yangle -takefocus 0 -command \"roundscale $f.be.frame.scale 1; Ng_SetSTLParameters; Ng_STLDoctor buildedges; redraw\"\n"
,"ttk::entry $f.be.frame.entry -textvariable stloptions.yangle -width 5 \\\n"
,"-validatecommand \"Ng_SetSTLParameters; Ng_STLDoctor buildedges; redraw;my_validate %W [$f.be.frame.scale cget -from] [$f.be.frame.scale cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_SetSTLParameters; Ng_STLDoctor buildedges; redraw\" -validate focus\n"
,"grid $f.be.frame.lab - -sticky nw -padx 4\n"
,"grid $f.be.frame.scale $f.be.frame.entry -sticky nw -padx 4\n"
,"ttk::label $f.be.frame.lab2 -text \"continue edges with yellow angle:\";\n"
,"ttk::scale $f.be.frame.scale2 -orient horizontal -length 200 -from 0 -to 100 \\\n"
,"-variable stloptions.contyangle -takefocus 0 -command \"roundscale $f.be.frame.scale2 1; Ng_SetSTLParameters; Ng_STLDoctor buildedges; redraw\"\n"
,"ttk::entry $f.be.frame.entry2 -textvariable stloptions.contyangle -width 5 \\\n"
,"-validatecommand \"Ng_SetSTLParameters; Ng_STLDoctor buildedges; redraw;my_validate %W [$f.be.frame.scale2 cget -from] [$f.be.frame.scale2 cget -to] %P 1\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_SetSTLParameters; Ng_STLDoctor buildedges; redraw\" -validate focus\n"
,"grid $f.be.frame.lab2 - -sticky nw -padx 4\n"
,"grid $f.be.frame.scale2 $f.be.frame.entry2 -sticky nw -padx 4\n"
,"ttk::button $f.be.frame.buildedges -text \"Build Edges\" -command {Ng_STLDoctor buildedges; redraw}\n"
,"grid $f.be.frame.buildedges - -sticky n -padx 4 -pady 4\n"
,"ttk::frame $f.se -relief groove -borderwidth 3\n"
,"pack $f.se -fill x\n"
,"ttk::checkbutton $f.se.bu -text \"show excluded\" \\\n"
,"-variable stldoctor.showexcluded \\\n"
,"-command {Ng_STLDoctor; redraw}\n"
,"pack $f.se.bu\n"
,"set edgeselmodevals { 0 1 2 3 4 }\n"
,"set edgeselmodelabs(0) \"no change\"\n"
,"set edgeselmodelabs(1) \"undefined\"\n"
,"set edgeselmodelabs(2) \"confirmed\"\n"
,"set edgeselmodelabs(3) \"candidate\"\n"
,"set edgeselmodelabs(4) \"excluded\"\n"
,"global stldoctor.edgeselectmode\n"
,"ttk::frame $f.scaleframe -relief groove -borderwidth 0\n"
,"pack $f.scaleframe -ipadx 4 -pady 4 -expand yes\n"
,"ttk::label  $f.scaleframe.dblcedgelab -text \"Double Click sets edge :\"\n"
,"ttk::menubutton $f.scaleframe.dblcledgebut -menu $f.scaleframe.dblcledgem -text \"coarse\" -width 16\n"
,"menu $f.scaleframe.dblcledgem  -tearoff 0\n"
,"foreach selectmode { 0 1 2 3 4 } {\n"
,"$f.scaleframe.dblcledgem add command -label $edgeselmodelabs($selectmode) \\\n"
,"-command \"set stldoctor.edgeselectmode $selectmode ; $f.scaleframe.dblcledgebut configure -text \\\"$edgeselmodelabs($selectmode)\\\"\"\n"
,"}\n"
,"$f.scaleframe.dblcledgem invoke $edgeselmodelabs(${stldoctor.edgeselectmode})\n"
,"grid $f.scaleframe.dblcedgelab $f.scaleframe.dblcledgebut -sticky n -ipadx 4\n"
,"ttk::frame $f.edg -relief groove -borderwidth 3\n"
,"pack $f.edg -fill x -ipadx 4 -ipady 4\n"
,"ttk::frame $f.edg.f0\n"
,"pack $f.edg.f0\n"
,"ttk::button $f.edg.f0.confirmedge -text \"confirm\" -command {Ng_STLDoctor confirmedge; redraw}\n"
,"ttk::button $f.edg.f0.candidateedge -text \"candidate\" -command {Ng_STLDoctor candidateedge; redraw}\n"
,"ttk::button $f.edg.f0.excludeedge -text \"exclude\" -command {Ng_STLDoctor excludeedge; redraw}\n"
,"ttk::button $f.edg.f0.undefinededge -text \"undefined\" -command {Ng_STLDoctor undefinededge; redraw}\n"
,"pack $f.edg.f0.confirmedge $f.edg.f0.candidateedge $f.edg.f0.excludeedge $f.edg.f0.undefinededge  -side left\n"
,"ttk::frame $f.edg.fa\n"
,"pack $f.edg.fa\n"
,"ttk::button $f.edg.fa.setallundefined -text \"all undefined\" -command {Ng_STLDoctor setallundefinededges; redraw}\n"
,"ttk::button $f.edg.fa.erasecandidates -text \"candidates to undefined\" -command {Ng_STLDoctor erasecandidateedges; redraw}\n"
,"pack $f.edg.fa.setallundefined $f.edg.fa.erasecandidates -side left\n"
,"ttk::frame $f.edg.fb\n"
,"pack $f.edg.fb\n"
,"ttk::button $f.edg.fb.confirmcandidates -text \"candidates to confirmed\" -command {Ng_STLDoctor confirmcandidateedges; redraw}\n"
,"ttk::button $f.edg.fb.confirmedtocandidates -text \"confirmed to candidates\" -command {Ng_STLDoctor confirmedtocandidateedges; redraw}\n"
,"pack $f.edg.fb.confirmcandidates $f.edg.fb.confirmedtocandidates -side left\n"
,"ttk::frame $f.edg.f1\n"
,"ttk::frame $f.edg.f2\n"
,"ttk::frame $f.edg.f3\n"
,"ttk::frame $f.edg.f4\n"
,"pack $f.edg.f1 $f.edg.f2 $f.edg.f3 $f.edg.f4\n"
,"ttk::button $f.edg.f1.exportedges -text \"export edges\" -command {Ng_STLDoctor exportedges}\n"
,"ttk::button $f.edg.f1.importedges -text \"import edges\" -command {Ng_STLDoctor importedges; redraw}\n"
,"ttk::button $f.edg.f1.saveedgedata -text \"save edgedata\" \\\n"
,"-command {\n"
,"set types {\n"
,"{\"Netgen Edgedata\"   {.ned} }\n"
,"}\n"
,"set file [tk_getSaveFile -filetypes $types -defaultextension \".ned\"]\n"
,"if {$file != \"\"} {\n"
,"Ng_STLDoctor saveedgedata $file\n"
,"}\n"
,"}\n"
,"ttk::button $f.edg.f1.loadedgedata -text \"load edgedata\" \\\n"
,"-command {\n"
,"set types {\n"
,"{\"Netgen Edgedata\"  {.ned} }\n"
,"}\n"
,"set file [tk_getOpenFile -filetypes $types -defaultextension \".ned\"]\n"
,"if {$file != \"\"} {\n"
,"Ng_STLDoctor loadedgedata $file\n"
,"puts \"loading done\"\n"
,"redraw\n"
,"}\n"
,"}\n"
,"ttk::button $f.edg.f1.importAVLedges -text \"import AVL edges\" \\\n"
,"-command {\n"
,"set types {{\"Edge file\"  {.edg }}}\n"
,"set file [tk_getOpenFile -filetypes $types -defaultextension \".edg\"]\n"
,"if {$file != \"\"} {\n"
,"Ng_STLDoctor importexternaledges $file;\n"
,"}\n"
,"}\n"
,"pack $f.edg.f1.importAVLedges $f.edg.f1.loadedgedata $f.edg.f1.saveedgedata -side left\n"
,"ttk::frame $f.edg2 -relief groove -borderwidth 3\n"
,"pack $f.edg2 -fill x\n"
,"ttk::label $f.edg2.lab -text \"length (%):\"\n"
,"scale $f.edg2.sc -orient horizontal -length 200 -from 0 -to 100 \\\n"
,"-resolution 0.5 \\\n"
,"-variable stldoctor.longlinefact\n"
,"ttk::button $f.edg2.undoedge -text \"undo last edge change\" -command {Ng_STLDoctor undoedgechange; redraw}\n"
,"pack $f.edg2.undoedge -expand yes\n"
,"set f $wd.nb.normals\n"
,"ttk::frame $f.dt -relief groove -borderwidth 3\n"
,"pack $f.dt -fill x\n"
,"ttk::label $f.dt.lab -text \"dirty triangle factor\";\n"
,"ttk::entry $f.dt.ent -width 5 \\\n"
,"-textvariable stldoctor.dirtytrigfact -validatecommand \"Ng_SetSTLParameters;my_validate %W -1e9 1e9 %P 3\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_SetSTLParameters\" -validate focus\n"
,"pack $f.dt.ent $f.dt.lab -side left -expand yes -pady 8\n"
,"ttk::frame $f.srt -relief groove -borderwidth 3\n"
,"pack $f.srt -fill x\n"
,"ttk::button $f.srt.bu -text \"smooth reverted triangles geometric\" -command {Ng_STLDoctor smoothrevertedtrigs; redraw }\n"
,"ttk::entry $f.srt.ent -width 5 \\\n"
,"-textvariable stldoctor.smoothangle -validatecommand \"Ng_SetSTLParameters;my_validate %W -1e9 1e9 %P 2\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_SetSTLParameters\" -validate focus\n"
,"pack $f.srt.ent $f.srt.bu -side left  -expand yes -pady 8\n"
,"ttk::frame $f.bdt -relief groove -borderwidth 3\n"
,"pack $f.bdt -fill x\n"
,"ttk::button $f.bdt.bu -text \"mark dirty triangles\" -command {Ng_STLDoctor markdirtytrigs; redraw }\n"
,"ttk::button $f.bdt.bu2 -text \"smooth dirty triangles normal\" -command {Ng_STLDoctor smoothdirtytrigs; redraw }\n"
,"pack $f.bdt.bu $f.bdt.bu2 -side left  -expand yes -pady 8\n"
,"ttk::frame $f.sno -relief groove -borderwidth 3\n"
,"pack $f.sno -fill x\n"
,"ttk::frame $f.sno.snoframe -borderwidth 0\n"
,"ttk::button $f.sno.smoothnormals -text \"smooth normals\" -command { Ng_STLDoctor smoothnormals; redraw}\n"
,"ttk::scale $f.sno.snoframe.scale -orient horizontal -length 100 -from 0.0 -to 0.8 \\\n"
,"-variable stldoctor.smoothnormalsweight -takefocus 0 -command \"roundscale $f.sno.snoframe.scale 2;Ng_SetSTLParameters\"\n"
,"ttk::entry $f.sno.snoframe.entry -textvariable stldoctor.smoothnormalsweight -width 4 \\\n"
,"-validatecommand \"Ng_SetSTLParameters;my_validate %W [$f.sno.snoframe.scale cget -from] [$f.sno.snoframe.scale cget -to] %P 2\" \\\n"
,"-invalidcommand \"my_invalid %W;Ng_SetSTLParameters\" -validate focus\n"
,"ttk::label $f.sno.snoframe.labrough -text \"rough\"\n"
,"ttk::label $f.sno.snoframe.labsmooth -text \"smooth\"\n"
,"grid $f.sno.snoframe.labrough $f.sno.snoframe.scale $f.sno.snoframe.labsmooth $f.sno.snoframe.entry -sticky nw -padx 4\n"
,"pack $f.sno.snoframe $f.sno.smoothnormals -side left -padx 5 -pady 8\n"
,"ttk::frame $f.no -relief groove -borderwidth 3\n"
,"pack $f.no -fill x\n"
,"ttk::button $f.no.marknonsmoothnormals -text \"mark non-smooth triangles\" -command {Ng_STLDoctor marknonsmoothnormals; redraw}\n"
,"ttk::button $f.no.calcnormals -text \"calculate normals from geometry\" -command {Ng_STLDoctor calcnormals; redraw}\n"
,"pack $f.no.marknonsmoothnormals $f.no.calcnormals -expand yes -pady 8\n"
,"set f $wd.nb.advanced\n"
,"ttk::frame $f.sc\n"
,"pack $f.sc -fill x\n"
,"ttk::checkbutton $f.sc.bu -text \"spiral check\" \\\n"
,"-variable stldoctor.spiralcheck \\\n"
,"-command {Ng_STLDoctor;}\n"
,"ttk::checkbutton $f.sc.bu2 -text \"cone check\" \\\n"
,"-variable stldoctor.conecheck \\\n"
,"-command {Ng_STLDoctor;}\n"
,"pack $f.sc.bu $f.sc.bu2\n"
,"ttk::spinbox $f.gtol -from 1 -to 20 -textvariable stldoctor.geom_tol_fact -width 8\n"
,"pack $f.gtol\n"
,"ttk::button $f.adap -text \"Apply\" -command {\n"
,".stldoctor_dlg.nb.advanced.gtol invoke\n"
,"Ng_STLDoctor;\n"
,"}\n"
,"pack $f.adap -expand yes\n"
,"wm withdraw $wd\n"
,"wm geom $wd +100+100\n"
,"wm deiconify $wd\n"
,"wm title $wd \"STL Doctor\"\n"
,"focus $wd\n"
,"}\n"
,"}\n"
,"proc meshdoctordialog { } {\n"
,"set w .meshdoc_dlg\n"
,"global meshdoctor.active\n"
,"if {[winfo exists .meshdoc_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"set meshdoctor.active 1\n"
,"Ng_MeshDoctor;\n"
,"ttk::frame $w.vis -relief groove -borderwidth 3\n"
,"pack $w.vis\n"
,"ttk::checkbutton $w.vis.showfilledtrigs -text \"Show filled triangles\" \\\n"
,"-variable viewoptions.drawfilledtrigs \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $w.vis.showedges -text \"Show edges\" \\\n"
,"-variable viewoptions.drawedges \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"ttk::checkbutton $w.vis.showoutline -text \"Show Triangle Outline\" \\\n"
,"-variable viewoptions.drawoutline \\\n"
,"-command { Ng_SetVisParameters; redraw }\n"
,"pack $w.vis.showfilledtrigs  $w.vis.showoutline $w.vis.showedges\n"
,"ttk::frame $w.markedgedist\n"
,"ttk::label $w.markedgedist.l -text \"Mark edge dist: \"\n"
,"ttk::spinbox $w.markedgedist.s -from 0 -to 999 -width 5 -increment 1 -validate focus -validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -command {Ng_MeshDoctor markedgedist ${meshdoc.markedgedist};redraw} -textvariable meshdoc.markedgedist\n"
,"pack $w.markedgedist.l $w.markedgedist.s -side left\n"
,"pack $w.markedgedist\n"
,"ttk::button $w.deledge -text \"Delete marked segments\" -command {\n"
,"Ng_MeshDoctor deletemarkedsegments\n"
,"redraw\n"
,"}\n"
,"pack $w.deledge\n"
,"ttk::button $w.close -text \"Close\" -command {\n"
,"set meshdoctor.active 0;\n"
,"Ng_MeshDoctor;\n"
,"destroy .meshdoc_dlg\n"
,"}\n"
,"pack $w.close -expand yes\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Mesh Doctor\"\n"
,"}\n"
,"}\n"
,"proc qualityviewdialog { show } {\n"
,"set w .qualityview_dlg\n"
,"if {[winfo exists .qualityview_dlg] == 1} {\n"
,"if { $show == 1 } {\n"
,"wm withdraw .qualityview_dlg\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"wm withdraw $w\n"
,"}\n"
,"} {\n"
,"toplevel $w\n"
,"set c $w.c\n"
,"canvas $c -relief raised -width 450 -height 300\n"
,"pack $w.c -side top -fill x\n"
,"set plotFont {Helvetica 12}\n"
,"set smallFont {Helvetica 12}\n"
,"$c create line 100 250 400 250 -width 2\n"
,"$c create line 100 250 100 50 -width 2\n"
,"for {set i 0} {$i <= 10} {incr i} {\n"
,"set x [expr {100 + ($i*30)}]\n"
,"$c create line $x 250 $x 245 -width 2\n"
,"if { [expr {$i % 2}] == 0 } {\n"
,"$c create text $x 254 -text [format %1.1f [expr 0.1*$i]] -anchor n -font $plotFont\n"
,"}\n"
,"}\n"
,"global qualbar\n"
,"global qualbarnull\n"
,"global qualbaraxis\n"
,"for {set i 0} {$i <= 5} {incr i} {\n"
,"set y [expr {250 - ($i*40)}]\n"
,"$c create line 100 $y 105 $y -width 2\n"
,"set qualbaraxis($i) \\\n"
,"[$c create text 96 $y -text [expr $i*50].0 -anchor e -font $plotFont]\n"
,"}\n"
,"for {set i 0} {$i < 20} {incr i} {\n"
,"set x1 [expr {100 + ($i*15) + 2}]\n"
,"set x2 [expr {$x1+10}]\n"
,"set y [expr {250 - 10 * $i}]\n"
,"set qualbar($i) [$c create rectangle $x1 250 $x2 245 -fill blue]\n"
,"set qualbarnull($i) [$c create text [expr {($x1+$x2)/2}] 245 -text 0 -anchor s -font $smallFont -fill blue]\n"
,"}\n"
,"frame $w.bu\n"
,"pack $w.bu\n"
,"ttk::button $w.close -text \"Close\" \\\n"
,"-command {\n"
,"wm withdraw .qualityview_dlg\n"
,"set viewqualityplot 0\n"
,"}\n"
,"pack $w.close\n"
,"if { $show == 1 } {\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Mesh Quality\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"}\n"
,"proc memusedialog { show } {\n"
,"set w .memuse_dlg\n"
,"if {[winfo exists .memuse_dlg] == 1} {\n"
,"if { $show == 1 } {\n"
,"wm withdraw .memuse_dlg\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"wm withdraw $w\n"
,"}\n"
,"} {\n"
,"toplevel $w\n"
,"set c $w.c\n"
,"canvas $c -relief raised -width 600 -height 300\n"
,"pack $w.c -side top -fill x\n"
,"set plotFont {Helvetica 18}\n"
,"set smallFont {Helvetica 12}\n"
,"global memmark\n"
,"for {set i 0} {$i < 512} { incr i } {\n"
,"set memmark($i) [$c create line [expr 50+$i] 50 [expr 50+$i] 70 -fill blue]\n"
,"}\n"
,"set plotFont {Helvetica 18}\n"
,"set smallFont {Helvetica 12}\n"
,"$c create text 50 90 -text \"0 GB\" -anchor n -font $plotFont\n"
,"$c create text 178 90 -text \"1 GB\" -anchor n -font $plotFont\n"
,"$c create text 306 90 -text \"2 GB\" -anchor n -font $plotFont\n"
,"$c create text 434 90 -text \"3 GB\" -anchor n -font $plotFont\n"
,"$c create text 562 90 -text \"4 GB\" -anchor n -font $plotFont\n"
,"ttk::frame $w.bu\n"
,"pack $w.bu\n"
,"ttk::button $w.close -text \"Close\" \\\n"
,"-command {\n"
,"wm withdraw .memuse_dlg\n"
,"set memuseplot 0\n"
,"}\n"
,"pack $w.close\n"
,"if { $show == 1 } {\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Memory Usage\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"}\n"
,"proc STLinfodialog { show } {\n"
,"set w .STLinfo_dlg\n"
,"if {[winfo exists .STLinfo_dlg] == 1} {\n"
,"if { $show == 1 } {\n"
,"wm withdraw .STLinfo_dlg\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"wm withdraw $w\n"
,"}\n"
,"} {\n"
,"toplevel $w\n"
,"set c $w.c\n"
,"canvas $c -relief raised -width 450 -height 300\n"
,"pack $w.c -side top -fill x\n"
,"set plotFont {Helvetica 18}\n"
,"set smallFont {Helvetica 12}\n"
,"$c create line 100 250 400 250 -width 2\n"
,"$c create line 100 250 100 50 -width 2\n"
,"ttk::frame $w.bu\n"
,"pack $w.bu\n"
,"ttk::button $w.close -text \"Close\" \\\n"
,"-command {\n"
,"wm withdraw .STLinfo_dlg\n"
,"}\n"
,"pack $w.close\n"
,"if { $show == 1 } {\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"STL Geometry Info\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"}\n"
,"proc logwindow { } {\n"
,"set w .logwindow\n"
,"if {[winfo exists .logwindow] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"text $w.edit -yscroll \"$w.scrolly set\" -setgrid 1 -height 12\n"
,"scrollbar $w.scrolly -command \"$w.edit yview\"\n"
,"pack $w.edit -side left -fill both -expand 1\n"
,"pack $w.scrolly -side left -fill both -expand 0\n"
,".logwindow.edit insert end \"Netgen Log Window\\n\"\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Netgen Log\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"proc printtable { tablevar } {\n"
,"set w newtcltable\n"
,"while {[winfo exists .$w] == 1} {set w 1$w}\n"
,"set w .$w\n"
,"toplevel $w\n"
,"for {set i 0} {$i < [lindex $tablevar 2]} { incr i } {\n"
,"frame $w.col$i\n"
,"for {set j 0} {$j < [lindex $tablevar 1]} { incr j } {\n"
,"frame $w.col$i.row$j\n"
,"message $w.col$i.row$j.txt -aspect 10000000 -text [lindex $tablevar [expr 3+[lindex $tablevar 2]*$j+$i]]\n"
,"pack $w.col$i.row$j.txt\n"
,"pack $w.col$i.row$j -side top\n"
,"}\n"
,"pack $w.col$i -side left\n"
,"}\n"
,"wm withdraw $w\n"
,"wm geom $w +200+100; wm deiconify $w\n"
,"wm title $w [lindex $tablevar 0]\n"
,"focus $w\n"
,"}\n"
,"set latestwarning 0\n"
,"proc printwarning { textvar } {\n"
,"global latestwarning\n"
,"set latestwarning $textvar\n"
,"set w warning\n"
,"while {[winfo exists .$w] == 1} {set w 1$w}\n"
,"set w .$w\n"
,"toplevel $w\n"
,"message $w.mes -aspect 2000 -text \"WARNING:\\n$textvar\"\n"
,"ttk::button $w.done -text \"Done\" -command \"destroy $w\"\n"
,"pack $w.mes\n"
,"pack $w.done\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"wm title $w \"Warning\"\n"
,"focus $w\n"
,"}\n"
,"proc printlatestwarning { } {\n"
,"global latestwarning\n"
,"if {$latestwarning != 0} {printwarning $latestwarning}\n"
,"}\n"
,"}\n"
,"catch {\n"
,"set oldmousex 0\n"
,"set oldmousey 0\n"
,"set toglversion [Ng_GetToglVersion]\n"
,"puts \"togl-version : $toglversion\"\n"
,"set toglok 0\n"
,"if { [Ng_GetToglVersion] == 2 } {\n"
,"if {[catch {togl .ndraw -width 400 -height 300  -rgba true -double true -depth true -privatecmap false -stereo false -indirect false  -create init  -display draw -reshape reshape }] } {\n"
,"puts \"no OpenGL\"\n"
,"} {\n"
,"set toglok 1\n"
,"}\n"
,"} {\n"
,"if {[catch {togl .ndraw -width 400 -height 300  -rgba true -double true -depth true -privatecmap false -stereo false -indirect false  }] } {\n"
,"puts \"no OpenGL\"\n"
,"} {\n"
,"set toglok 1\n"
,"}\n"
,"}\n"
,"if { $toglok == 1} {\n"
,"pack .ndraw -expand true -fill both -padx 10 -pady 10\n"
,"catch { tkdnd::drop_target register .ndraw DND_Files }\n"
,"bind .ndraw <Button-1> {\n"
,"set oldmousex %x; set oldmousey %y;\n"
,"}\n"
,"bind .ndraw <Button-2> {\n"
,"set oldmousex %x; set oldmousey %y;\n"
,"}\n"
,"bind .ndraw <Button-3> {\n"
,"set oldmousex %x; set oldmousey %y;\n"
,"}\n"
,"bind .ndraw <B1-Motion> {\n"
,"Ng_MouseMove $oldmousex $oldmousey %x %y $drawmode\n"
,".ndraw render\n"
,"set oldmousex %x; set oldmousey %y;\n"
,"}\n"
,"bind .ndraw <Double-1> {\n"
,"Ng_MouseDblClick %x %y\n"
,".ndraw render\n"
,"if { [winfo exists .bcprop_dlg] } { bcpropdialog }\n"
,"if { [winfo exists .surfacemeshsize_dlg] } { surfacemeshsizedialog }\n"
,"if { [winfo exists .fieldlines_dlg] } { fieldlinesdialog }\n"
,"}\n"
,"bind .ndraw <B2-Motion> {\n"
,"Ng_MouseMove $oldmousex $oldmousey %x %y move\n"
,".ndraw render\n"
,"set oldmousex %x; set oldmousey %y;\n"
,"}\n"
,"bind .ndraw <B3-Motion> {\n"
,"if { $tcl_platform(os) == \"Darwin\" } {\n"
,"Ng_MouseMove $oldmousex $oldmousey %x %y move\n"
,"} {\n"
,"Ng_MouseMove $oldmousex $oldmousey %x %y zoom\n"
,"}\n"
,".ndraw render\n"
,"set oldmousex %x; set oldmousey %y;\n"
,"}\n"
,"}\n"
,"proc popupcheckredraw { vari { x 0 } } {\n"
,"upvar $vari varname\n"
,"if { $varname == 1 } {\n"
,"set varname 0\n"
,"} {\n"
,"Ng_Vis_Set parameters\n"
,"redraw\n"
,"}\n"
,"}\n"
,"proc popupcheckredraw2 { vari boolvar { x 0 } } {\n"
,"upvar $vari varname\n"
,"if { $varname == 1 } {\n"
,"set varname 0\n"
,"} {\n"
,"Ng_SetVisParameters\n"
,"Ng_Vis_Set parameters\n"
,"if { $boolvar == 1 } { redraw }\n"
,"Ng_SetVisParameters\n"
,"}\n"
,"}\n"
,"proc popupcheckredraw3 { vari { x 0 } } {\n"
,"upvar $vari varname\n"
,"if { $varname == 1 } {\n"
,"set varname 0\n"
,"} {\n"
,"Ng_Vis_Set parameters\n"
,"}\n"
,"}\n"
,"proc redraw { {x 0} } {\n"
,"if {[winfo exists .ndraw]} { .ndraw render }\n"
,"}\n"
,"bind . <Left> { Ng_MouseMove 0 0 -10 0 rotate; redraw }\n"
,"bind . <Right> { Ng_MouseMove 0 0 10 0 rotate; redraw }\n"
,"bind . <Up> { Ng_MouseMove 0 0 0 -10 rotate; redraw }\n"
,"bind . <Down> { Ng_MouseMove 0 0 0 10 rotate; redraw }\n"
,"bind . <Shift-Left> { Ng_MouseMove 0 0 -10 0 move; redraw }\n"
,"bind . <Shift-Right> { Ng_MouseMove 0 0 10 0 move; redraw }\n"
,"bind . <Shift-Up> { Ng_MouseMove 0 0 0 -10 move; redraw }\n"
,"bind . <Shift-Down> { Ng_MouseMove 0 0 0 10 move; redraw }\n"
,"bind . <Control-Up> { Ng_MouseMove 0 0 0 -10 zoom; redraw }\n"
,"bind . <Control-Down> { Ng_MouseMove 0 0 0 10 zoom; redraw }\n"
,"bind . <Button-4> \\\n"
,"{event generate [focus -displayof %W] <MouseWheel> -delta  120}\n"
,"bind . <Button-5> \\\n"
,"{event generate [focus -displayof %W] <MouseWheel> -delta -120}\n"
,"bind . <MouseWheel> { Ng_MouseMove 0 0 0 [expr {%D/-5}] zoom; redraw }\n"
,"bind .ndraw <<Drop:DND_Files>> {\n"
,"set filename [join %D \" \"]\n"
,"set index [string last . $filename]\n"
,"set type [string range $filename $index+1 end]\n"
,"set ispde [string match -nocase $type \"pde\"]\n"
,"set isgeo [expr max([string match -nocase $type \"geo\"],[string match -nocase $type \"in2d\"])]\n"
,"set ismesh [expr max([string match -nocase $type \"vol\"],[string match -nocase $type \"vol.gz\"])]\n"
,"set ispy [string match -nocase $type \"py\"]\n"
,"if {$ispde == 1} {\n"
,"AddRecentNGSFile $filename;\n"
,"NGS_LoadPDE  $filename;\n"
,"SetNumProcHelpMenu\n"
,"set selectvisual mesh;\n"
,"Ng_SetVisParameters\n"
,"}\n"
,"if {$ispy == 1} {\n"
,"AddRecentPYNGSFile $filename;\n"
,"NGS_LoadPy  $filename;\n"
,"}\n"
,"if {$isgeo == 1} {\n"
,"AddRecentFile $filename;\n"
,"Ng_LoadGeometry $filename;\n"
,"Ng_ParseGeometry\n"
,"set selectvisual geometry\n"
,"Ng_SetVisParameters\n"
,"redraw\n"
,"wm title . [concat \"$progname - \" $filename]\n"
,"set dirname [file dirname $filename]\n"
,"set basefilename [file tail [file rootname $filename]]\n"
,"}\n"
,"if {$ismesh == 1} {\n"
,"AddRecentMeshFile $filename;\n"
,"Ng_LoadMesh $filename;\n"
,"set selectvisual mesh\n"
,"Ng_SetVisParameters\n"
,"redraw\n"
,"Ng_ReadStatus;\n"
,"wm title . [concat \"$progname - \" %D]\n"
,"set dirname [file dirname %D]\n"
,"set basefilename [file tail [file rootname %D]]\n"
,"}\n"
,"return %A\n"
,"}\n"
,"}\n"
,"catch { .ngmenu.geometry add command -label \"Scan CSG Geometry\" -command { Ng_ParseGeometry }\n"
,".ngmenu.geometry add command -label \"CSG Options...\" -command geometryoptionsdialog\n"
,".ngmenu.geometry add command -label \"CSG Properties...\" \\\n"
,"-command topleveldialog2\n"
,"proc geometryoptionsdialog { } {\n"
,"set w .geometry_dlg\n"
,"if {[winfo exists .geometry_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"global geooptions\n"
,"Ng_GeometryOptions get\n"
,"checkbutton $w.drawcsg -text \"Draw Geometry\" \\\n"
,"-variable geooptions.drawcsg\n"
,"pack $w.drawcsg\n"
,"frame $w.fac\n"
,"pack $w.fac -pady 5\n"
,"ttk::label $w.fac.lab -text \"Facets:\";\n"
,"entry $w.fac.ent -width 8 -relief sunken \\\n"
,"-textvariable geooptions.facets\n"
,"pack $w.fac.lab $w.fac.ent  -side left\n"
,"frame $w.det\n"
,"pack $w.det -pady 5\n"
,"ttk::label $w.det.lab -text \"Detail:\";\n"
,"entry $w.det.ent -width 8 -relief sunken \\\n"
,"-textvariable geooptions.detail\n"
,"pack $w.det.lab $w.det.ent  -side left\n"
,"frame $w.cox\n"
,"pack $w.cox -pady 5\n"
,"ttk::label $w.cox.lab -text \"min/max x:\";\n"
,"entry $w.cox.ent1 -width 8 -relief sunken \\\n"
,"-textvariable geooptions.minx\n"
,"entry $w.cox.ent2 -width 8 -relief sunken \\\n"
,"-textvariable geooptions.maxx\n"
,"pack $w.cox.lab $w.cox.ent1 \\\n"
,"$w.cox.ent2  -side left\n"
,"frame $w.coy\n"
,"pack $w.coy -pady 5\n"
,"ttk::label $w.coy.lab -text \"min/max y:\";\n"
,"entry $w.coy.ent1 -width 8 -relief sunken \\\n"
,"-textvariable geooptions.miny\n"
,"entry $w.coy.ent2 -width 8 -relief sunken \\\n"
,"-textvariable geooptions.maxy\n"
,"pack $w.coy.lab $w.coy.ent1 \\\n"
,"$w.coy.ent2  -side left\n"
,"frame $w.coz\n"
,"pack $w.coz -pady 5\n"
,"ttk::label $w.coz.lab -text \"min/max z:\";\n"
,"entry $w.coz.ent1 -width 8 -relief sunken \\\n"
,"-textvariable geooptions.minz\n"
,"entry $w.coz.ent2 -width 8 -relief sunken \\\n"
,"-textvariable geooptions.maxz\n"
,"pack $w.coz.lab $w.coz.ent1 \\\n"
,"$w.coz.ent2  -side left\n"
,"frame $w.bu\n"
,"pack $w.bu -fill x -ipady 3\n"
,"ttk::button $w.bu.app -text \"Apply\" -command {\n"
,"Ng_GeometryOptions set\n"
,"}\n"
,"ttk::button $w.bu.ok -text \"Done\" -command {\n"
,"Ng_GeometryOptions set\n"
,"destroy .geometry_dlg\n"
,"}\n"
,"pack  $w.bu.app $w.bu.ok -side left -expand yes\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Geometry options\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"proc editprimitivedialog2 { name } {\n"
,"global w classname\n"
,"set w .ep_dlg\n"
,"toplevel .$w\n"
,"Ng_GetPrimitiveData $name classname valuelist\n"
,"ttk::label $w.lab1 -text \"Primitive Name:  $name\";\n"
,"ttk::label $w.lab2 -text \"Primitive Class: $classname\";\n"
,"pack $w.lab1 $w.lab2 -fill x -pady 1m -padx 5m\n"
,"frame $w.specific -relief groove\n"
,"global spec\n"
,"set spec(sphere) { cx cy cz rad }\n"
,"set spec(cylinder) { ax ay az bx by bz rad }\n"
,"set spec(plane) { px py pz nx ny nz }\n"
,"set spec(cone) { ax ay az bx by bz ra rb }\n"
,"set spec(brick) { p1x p1y p1z p2x p2y p2z p3x p3y p3z p4x p4y p4z }\n"
,"set cnt 0\n"
,"foreach field $spec($classname) {\n"
,"frame $w.specific.f$cnt\n"
,"pack $w.specific.f$cnt -side top -anchor ne\n"
,"ttk::label $w.specific.f$cnt.lab -text \"$field\"\n"
,"entry $w.specific.f$cnt.ent -textvariable dataval($cnt) \\\n"
,"-width 6 -relief sunken\n"
,"pack $w.specific.f$cnt.ent $w.specific.f$cnt.lab -side right\n"
,"$w.specific.f$cnt.ent delete 0 end\n"
,"$w.specific.f$cnt.ent insert 0 [lindex $valuelist $cnt]\n"
,"set cnt [expr $cnt + 1]\n"
,"}\n"
,"pack $w.specific\n"
,"ttk::button $w.cancel -text \"cancel\" -command {\n"
,"destroy $w\n"
,"}\n"
,"ttk::button $w.ok -text \"ok\" -command {\n"
,"set valuelist \"\"\n"
,"set cnt 0\n"
,"foreach field $spec($classname) {\n"
,"lappend valuelist $dataval($cnt)\n"
,"set cnt [expr $cnt + 1]\n"
,"}\n"
,"Ng_SetPrimitiveData $name $valuelist\n"
,"destroy $w\n"
,"}\n"
,"pack  $w.cancel $w.ok -side left -expand yes\n"
,"bind $w <Return> { $w.ok  invoke}\n"
,"bind $w <Escape> { $w.cancel  invoke}\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"focus $w.specific.f0.ent\n"
,"}\n"
,"proc editprimitivedialog { } {\n"
,"global w\n"
,"set w .ep_dlg\n"
,"toplevel $w\n"
,"frame $w.frame -borderwidth 5m\n"
,"pack $w.frame -side top -expand yes -fill y\n"
,"listbox $w.frame.list -yscroll \"$w.frame.scroll set\" -setgrid 1 -height 12\n"
,"scrollbar $w.frame.scroll -command \"$w.frame.list yview\"\n"
,"pack $w.frame.scroll -side right -fill y\n"
,"pack $w.frame.list -side left -expand 1 -fill both\n"
,"Ng_GetPrimitiveList primlist\n"
,"foreach el $primlist {\n"
,"$w.frame.list insert end $el }\n"
,"ttk::button $w.cancel -text \"cancel\" -command { destroy $w }\n"
,"ttk::button $w.ok -text \"ok\" -command {\n"
,"set name [.ep_dlg.frame.list get active]\n"
,"puts \"name=($name)\"\n"
,"destroy $w\n"
,"if { $name != \"\" } { editprimitivedialog2 $name }\n"
,"}\n"
,"bind $w <Escape> { $w.cancel invoke }\n"
,"bind $w <Return> { $w.ok invoke }\n"
,"pack  $w.cancel $w.ok -side left -expand yes\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"focus $w.frame.list\n"
,"}\n"
,"proc newprimitivedialog { } {\n"
,"global w name\n"
,"set w .ap_dlg\n"
,"toplevel $w\n"
,"set name \"\"\n"
,"frame $w.f1\n"
,"pack $w.f1 -pady 2m\n"
,"ttk::label $w.f1.lab -text \"Primitive Name: \";\n"
,"entry $w.f1.ent -width 5 -relief sunken \\\n"
,"-textvariable name\n"
,"pack $w.f1.lab $w.f1.ent -side left\n"
,"frame $w.frame -borderwidth .5c\n"
,"pack $w.frame -side top -expand yes -fill y\n"
,"listbox $w.frame.list -yscroll \"$w.frame.scroll set\" -setgrid 1 -height 8\n"
,"scrollbar $w.frame.scroll -command \"$w.frame.list yview\"\n"
,"pack $w.frame.scroll -side right -fill y\n"
,"pack $w.frame.list -side left -expand 1 -fill both\n"
,"$w.frame.list insert 0 sphere cylinder plane cone brick\n"
,"$w.frame.list activate 0\n"
,"ttk::button $w.ok -text \"ok\" -command {\n"
,"Ng_CreatePrimitive [$w.frame.list get active]  $name\n"
,"destroy $w\n"
,"editprimitivedialog2 $name\n"
,"}\n"
,"ttk::button $w.cancel -text \"cancel\" -command {\n"
,"destroy $w\n"
,"}\n"
,"pack  $w.cancel $w.ok -side left -expand yes -pady 2m\n"
,"bind $w <Escape> { $w.cancel invoke }\n"
,"bind $w <Return> { $w.ok invoke }\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"focus $w.f1.ent\n"
,"}\n"
,"proc newsoliddialog { } {\n"
,"global w name val sollist\n"
,"set w .ns_dlg\n"
,"toplevel $w\n"
,"set name \"\"\n"
,"frame $w.f1\n"
,"ttk::label $w.f1.lab -text \"Solid Name: \";\n"
,"entry $w.f1.ent -width 5 -relief sunken \\\n"
,"-textvariable name\n"
,"$w.f1.ent delete 0 end\n"
,"ttk::button $w.f1.getsel -text \"Get Selected\" -command {\n"
,"$w.f1.ent delete 0 end\n"
,"$w.f1.ent insert 0 [$w.f3.list get active]\n"
,"$w.bu.get invoke\n"
,"}\n"
,"pack $w.f1.getsel -side bottom\n"
,"pack $w.f1.ent $w.f1.lab -side right\n"
,"frame $w.f3 -borderwidth .5c\n"
,"listbox $w.f3.list -yscroll \"$w.f3.scroll set\" -setgrid 1 -height 12\n"
,"scrollbar $w.f3.scroll -command \"$w.f3.list yview\"\n"
,"pack $w.f3.scroll -side right -fill y\n"
,"pack $w.f3.list -side left -expand 1 -fill both\n"
,"Ng_GetSolidList sollist\n"
,"foreach el $sollist {\n"
,"$w.f3.list insert end $el }\n"
,"frame $w.f2\n"
,"ttk::label $w.f2.lab -text \"Solid Description: \";\n"
,"pack $w.f2.lab\n"
,"entry $w.f2.ent -width 100 -relief sunken \\\n"
,"-textvariable val  -xscrollcommand \"$w.f2.scr set\"\n"
,"scrollbar $w.f2.scr -relief sunken -orient horiz -command \\\n"
,"\"$w.f2.ent xview\"\n"
,"$w.f2.ent delete 0 end\n"
,"pack $w.f2.ent $w.f2.scr -fill x\n"
,"frame $w.bu\n"
,"ttk::button $w.bu.close -text \"close\" -command {\n"
,"destroy $w\n"
,"}\n"
,"ttk::button $w.bu.get -text \"get data\" -command {\n"
,"Ng_GetSolidData $name val\n"
,"}\n"
,"ttk::button $w.bu.set -text \"set data\" -command {\n"
,"Ng_SetSolidData $name $val\n"
,"}\n"
,"pack $w.bu.get $w.bu.set $w.bu.close -side left\n"
,"pack $w.bu -pady 5 -side bottom                     ;\n"
,"pack $w.f2 -pady 5 -side bottom                     ;\n"
,"pack $w.f1 -pady 5 -side left                       ;\n"
,"pack $w.f3 -side left -expand yes -fill y           ;\n"
,"bind $w <Escape> { $w.bu.close invoke }\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"}\n"
,"proc toplevelproperties { w solname surfname } {\n"
,"global properties\n"
,"Ng_TopLevel getprop $solname $surfname properties\n"
,"set w .tlprop_dlg\n"
,"if {[winfo exists $w] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"ttk::label $w.lab1 -text \"Red\"\n"
,"scale $w.scale1 -orient horizontal -length 300 -from 0 -to 1 \\\n"
,"-resolution 0.01  -tickinterval 0.2 \\\n"
,"-command { Ng_TopLevel setprop $solname $surfname properties; redraw } -variable  properties(red)\n"
,"ttk::label $w.lab2 -text \"Green\"\n"
,"scale $w.scale2 -orient horizontal -length 300 -from 0 -to 1 \\\n"
,"-resolution 0.01  -tickinterval 0.2 \\\n"
,"-command { Ng_TopLevel setprop $solname $surfname properties; redraw } -variable  properties(green)\n"
,"ttk::label $w.lab3 -text \"Blue\"\n"
,"scale $w.scale3 -orient horizontal -length 300 -from 0 -to 1 \\\n"
,"-resolution 0.01  -tickinterval 0.2 \\\n"
,"-command { Ng_TopLevel setprop $solname $surfname properties; redraw } -variable  properties(blue)\n"
,"pack $w.lab1 $w.scale1 $w.lab2 $w.scale2 $w.lab3 $w.scale3\n"
,"checkbutton $w.cb4 -text \"Visible\" \\\n"
,"-command { Ng_TopLevel setprop $solname $surfname properties; redraw } \\\n"
,"-variable properties(visible)\n"
,"checkbutton $w.cb5 -text \"Transparent\" \\\n"
,"-command { Ng_TopLevel setprop $solname $surfname properties; redraw } \\\n"
,"-variable properties(transp)\n"
,"pack  $w.cb4 $w.cb5\n"
,"frame $w.bu\n"
,"pack $w.bu -fill x\n"
,"ttk::button $w.bu.ok -text \"Ok\" -command \"destroy .tlprop_dlg\"\n"
,"pack $w.bu.ok  -expand yes\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"}\n"
,"wm title $w \"Properties $solname $surfname\"\n"
,"}\n"
,"proc topleveldialog { } {\n"
,"global w name val sollist\n"
,"set w .tl_dlg\n"
,"toplevel $w\n"
,"frame $w.sol -borderwidth .5c\n"
,"listbox $w.sol.list -yscroll \"$w.sol.scroll set\" -setgrid 1 -height 12\n"
,"scrollbar $w.sol.scroll -command \"$w.sol.list yview\"\n"
,"pack $w.sol.scroll -side right -fill y\n"
,"pack $w.sol.list -side left -expand 1 -fill both\n"
,"Ng_GetSolidList sollist\n"
,"foreach el $sollist {\n"
,"$w.sol.list insert end $el }\n"
,"Ng_GetPrimitiveList sollist\n"
,"foreach el $sollist {\n"
,"$w.sol.list insert end $el }\n"
,"frame $w.sul -borderwidth .5c\n"
,"listbox $w.sul.list -yscroll \"$w.sul.scroll set\" -setgrid 1 -height 12\n"
,"scrollbar $w.sul.scroll -command \"$w.sul.list yview\"\n"
,"pack $w.sul.scroll -side right -fill y\n"
,"pack $w.sul.list -side left -expand 1 -fill both\n"
,"Ng_GetSurfaceList sollist\n"
,"foreach el $sollist {\n"
,"$w.sul.list insert end $el }\n"
,"frame $w.topl -borderwidth .5c\n"
,"listbox $w.topl.list -yscroll \"$w.topl.scroll set\" -setgrid 1 -height 12 \\\n"
,"-command { puts hi }\n"
,"scrollbar $w.topl.scroll -command \"$w.topl.list yview\"\n"
,"pack $w.topl.scroll -side right -fill y\n"
,"pack $w.topl.list -side left -expand 1 -fill both\n"
,"Ng_TopLevel getlist sollist\n"
,"puts $sollist\n"
,"foreach el $sollist {\n"
,"set hel \"[ lindex $el 0 ]\"\n"
,"if { [ llength $el ] == 2 } {\n"
,"set hel \"[ lindex $el 1 ] on [ lindex $el 0 ]\"\n"
,"}\n"
,"$w.topl.list insert end $hel\n"
,"}\n"
,"frame $w.bu\n"
,"ttk::button $w.bu.close -text \"close\" -command {\n"
,"destroy $w\n"
,"}\n"
,"ttk::button $w.bu.addsol -text \"Add Solid\" -command {\n"
,"set solname [$w.sol.list get active]\n"
,"Ng_TopLevel set $solname \"\"\n"
,"Ng_ParseGeometry\n"
,"$w.topl.list insert end $solname\n"
,"}\n"
,"ttk::button $w.bu.addsurf -text \"Add Surface\" -command {\n"
,"set solname [$w.sol.list get active]\n"
,"set surfname [$w.sul.list get active]\n"
,"Ng_TopLevel set $solname $surfname\n"
,"Ng_ParseGeometry\n"
,"puts \"$solname on $surfname\"\n"
,"$w.topl.list insert end \"$surfname on $solname\"\n"
,"}\n"
,"ttk::button $w.bu.remsol -text \"Remove\" -command {\n"
,"set solname [$w.topl.list get active]\n"
,"set surfname \"\"\n"
,"if { [llength $solname] == 3 } {\n"
,"set surfname [lindex $solname 0]\n"
,"set solname [lindex $solname 2]\n"
,"}\n"
,"Ng_TopLevel remove $solname $surfname\n"
,"Ng_ParseGeometry\n"
,"$w.topl.list delete active\n"
,"}\n"
,"ttk::button $w.bu.prop -text \"Properties\" -command {\n"
,"set solname [$w.topl.list get active]\n"
,"set surfname \"\"\n"
,"if { [llength $solname] == 3 } {\n"
,"set surfname [lindex $solname 0]\n"
,"set solname [lindex $solname 2]\n"
,"}\n"
,"toplevelproperties tlp $solname $surfname\n"
,"}\n"
,"pack  $w.bu.close $w.bu.addsol $w.bu.addsurf $w.bu.remsol $w.bu.prop  -side left\n"
,"pack $w.bu -side bottom\n"
,"pack $w.sol -side left -expand yes -fill y           ;\n"
,"pack $w.sul -side left -expand yes -fill y           ;\n"
,"pack $w.topl -side left -expand yes -fill y           ;\n"
,"bind $w <Escape> { $w.bu.close invoke }\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"}\n"
,"proc topleveldialog2 { } {\n"
,"set w .tl2_dlg\n"
,"if {[winfo exists .tl2_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"global name val sollist\n"
,"frame $w.topl -borderwidth .5c\n"
,"listbox $w.topl.list -yscroll \"$w.topl.scroll set\" -setgrid 1 -height 12\n"
,"scrollbar $w.topl.scroll -command \"$w.topl.list yview\"\n"
,"pack $w.topl.scroll -side right -fill y\n"
,"pack $w.topl.list -side left -expand 1 -fill both\n"
,"Ng_TopLevel getlist sollist\n"
,"puts $sollist\n"
,"set i 1\n"
,"foreach el $sollist {\n"
,"set hel \"$i: [ lindex $el 0 ]\"\n"
,"if { [ llength $el ] == 2 } {\n"
,"set hel \"$i: [ lindex $el 1 ] on [ lindex $el 0 ]\"\n"
,"}\n"
,"incr i\n"
,"$w.topl.list insert end $hel }\n"
,"frame $w.bu\n"
,"ttk::button $w.bu.close -text \"close\" -command {\n"
,"destroy .tl2_dlg\n"
,"}\n"
,"ttk::button $w.bu.prop -text \"Properties\" -command {\n"
,"set solname [.tl2_dlg.topl.list get active]\n"
,"set surfname \"\"\n"
,"if { [llength $solname] == 2 } {\n"
,"set solname [lindex $solname 1]\n"
,"}\n"
,"if { [llength $solname] == 4 } {\n"
,"set surfname [lindex $solname 1]\n"
,"set solname [lindex $solname 3]\n"
,"}\n"
,"toplevelproperties tlp $solname $surfname\n"
,"}\n"
,"pack $w.bu.close $w.bu.prop  -side left\n"
,"pack $w.bu -side bottom\n"
,"pack $w.topl -side left -expand yes -fill y           ;\n"
,"bind .tl2_dlg.topl.list <Double-1> {\n"
,"set solname [.tl2_dlg.topl.list get  @%x,%y]\n"
,"set surfname \"\"\n"
,"if { [llength $solname] == 2 } {\n"
,"set solname [lindex $solname 1]\n"
,"}\n"
,"if { [llength $solname] == 4 } {\n"
,"set surfname [lindex $solname 1]\n"
,"set solname [lindex $solname 3]\n"
,"}\n"
,"toplevelproperties tlp $solname $surfname\n"
,"}\n"
,"bind .tl2_dlg <Escape> { .tl2_dlg.bu.close invoke }\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Top-Level Options\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"}\n"
,"catch { \n"
,".ngmenu.geometry add separator\n"
,".ngmenu.geometry add command -label \"STL Doctor...\" \\\n"
,"-command { stldoctordialog; }\n"
,".ngmenu.geometry add command -label \"STL Info\" \\\n"
,"-command {\n"
,"set notriangles 0\n"
,"set minx 0\n"
,"set maxx 0\n"
,"set miny 0\n"
,"set maxy 0\n"
,"set minz 0\n"
,"set maxz 0\n"
,"set trigscons 0\n"
,"Ng_STLInfo notriangles minx maxx miny maxy minz maxz trigscons\n"
,"set msgtext \"NO STL-Triangles : $notriangles\\nGeometry:\\nX = $minx - $maxx\\nY = $miny - $maxy\\nZ = $minz - $maxz\\nConsistency Check = $trigscons\\n\"\n"
,"set msgtext \"$msgtext Status: [Ng_STLInfo status]\"\n"
,"tk_messageBox -title \"STL Info\" -message  $msgtext -type ok\n"
,"}\n"
,"}\n"
,"set hasocc no\n"
,"catch { if { [catch { load liboccvis[info sharedlibextension] Ng_OCC } result ] } {\n"
,"}\n"
,"if { [catch { Ng_OCCCommand isoccgeometryloaded }] } {\n"
,"proc rebuildoccdialog { } { }\n"
,"} {\n"
,"puts \"OCC module loaded\"\n"
,"set hasocc yes\n"
,".ngmenu.geometry add separator\n"
,".ngmenu.geometry add command -label \"IGES/STEP Topology Explorer/Doctor...\" \\\n"
,"-command { occdialog; }\n"
,".ngmenu.geometry add command -label \"Edit Face Mesh Size...\" \\\n"
,"-command { surfacemeshsizedialog }\n"
,"set entities [ ]\n"
,"proc occdialogbuildtree {} {\n"
,"global entities\n"
,"set w .occ_dlg\n"
,"set entities [Ng_GetOCCData getentities]\n"
,"set nrentities [expr [llength $entities]]\n"
,"if {$nrentities != 0} {\n"
,"$w.tree insert {Topology} end -id \"CompSolids\" -text \"Composite Solids\"\n"
,"$w.tree insert {Topology} end -id \"FreeSolids\" -text \"Free Solids\"\n"
,"$w.tree insert {Topology} end -id \"FreeShells\" -text \"Free Shells\"\n"
,"$w.tree insert {Topology} end -id \"FreeFaces\" -text \"Free Faces\"\n"
,"$w.tree insert {Topology} end -id \"FreeWires\" -text \"Free Wires\"\n"
,"$w.tree insert {Topology} end -id \"FreeEdges\" -text \"Free Edges\"\n"
,"$w.tree insert {Topology} end -id \"FreeVertices\" -text \"Free Vertices\"\n"
,"$w.tree item \"Topology\" -open true\n"
,"set i [expr 0]\n"
,"while {$i < $nrentities} {\n"
,"set entity [lindex $entities [expr $i]]\n"
,"incr i 1\n"
,"set entityname [lindex $entities [expr $i]]\n"
,"set myroot [string range $entity 0 [string last / $entity]-1]\n"
,"$w.tree insert $myroot end -id $entity -text $entityname -value 1\n"
,"incr i 1\n"
,"}\n"
,"set i [expr 0]\n"
,"while {$i < $nrentities} {\n"
,"set entity [lindex $entities [expr $i]]\n"
,"$w.tree item $entity -open false\n"
,"incr i 2\n"
,"}\n"
,"set faces [Ng_OCCCommand getunmeshedfaceinfo]\n"
,"set nrfaces [expr [llength $faces]]\n"
,"if {$nrfaces >= 2} {\n"
,"$w.tree insert {} -id ErrorFaces -text \"Faces with surface meshing error\"\n"
,"$w.tree item ErrorFaces -open true\n"
,"set i [expr 0]\n"
,"while {$i < $nrfaces} {\n"
,"set entity [lindex $faces [expr $i]]\n"
,"set myroot [string range $entity 0 [string last / $entity]-1]\n"
,"if { [string length $myroot] == 0 } {\n"
,"set myroot ErrorFaces\n"
,"}\n"
,"incr i 1\n"
,"set entityname [lindex $faces [expr $i]]\n"
,"$w.tree insert {myroot} end -id $entity -text $entityname -value 0\n"
,"incr i 1\n"
,"}\n"
,"}\n"
,"set faces [Ng_OCCCommand getnotdrawablefaces]\n"
,"set nrfaces [expr [llength $faces]]\n"
,"if {$nrfaces >= 2} {\n"
,"$w.tree insert {} -id NotDrawableFaces -text \"Faces impossible to visualize\"\n"
,"$w.tree item NotDrawableFaces -open true\n"
,"set i [expr 0]\n"
,"while {$i < $nrfaces} {\n"
,"set entity [lindex $faces [expr $i]]\n"
,"set myroot [string range $entity 0 [string last / $entity]-1]\n"
,"if { [string length $myroot ] == 0 } {\n"
,"set myroot NotDrawableFaces\n"
,"}\n"
,"incr i 1\n"
,"set entityname [lindex $faces [expr $i]]\n"
,"$w.tree insert $myroot end -id $entity -text $entityname -value 0\n"
,"incr i 1\n"
,"}\n"
,"}\n"
,"puts \"done\"\n"
,"}\n"
,"}\n"
,"proc rebuildoccdialog {} {\n"
,"if {[winfo exists .occ_dlg] == 1} {\n"
,".occ_dlg.tree delete [.occ_dlg.tree children Topology]\n"
,"occdialogbuildtree\n"
,"}\n"
,"}\n"
,"proc checkoccloaded { } {\n"
,"set isoccgeometryloaded [Ng_OCCCommand isoccgeometryloaded]\n"
,"if {$isoccgeometryloaded == 0} {\n"
,"puts \"no IGES/STEP geometry loaded\"\n"
,"destroy .occ_dlg\n"
,"}\n"
,"}\n"
,"proc selectentity { entityname } {\n"
,"global entities\n"
,"set nrentities [expr [llength $entities]]\n"
,"set i [expr 0]\n"
,"while {$i < $nrentities} {\n"
,"set entitylength []\n"
,"set entity2 [lindex $entities [expr $i]]\n"
,"incr i 1\n"
,"set entityname2 [lindex $entities [expr $i]]\n"
,"incr i 1\n"
,"set entityname2 [string range $entityname2 0 [expr [string length $entityname]-1]]\n"
,"if {$entityname == $entityname2} {\n"
,".occ_dlg.tree see $entity2\n"
,".occ_dlg.tree selection set $entity2\n"
,"}\n"
,"}\n"
,"}\n"
,"proc occdialog { } {\n"
,"uplevel 1 {\n"
,"global entities\n"
,"set selectvisual geometry\n"
,"Ng_SetVisParameters\n"
,"redraw\n"
,"set w .occ_dlg\n"
,"if {[winfo exists .occ_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"ttk::treeview $w.tree\n"
,"$w.tree insert {} end -id \"Topology\" -text \"Topology\"\n"
,"pack $w.tree -fill both -expand yes\n"
,"occdialogbuildtree\n"
,"bind $w.tree <Double-1> {\n"
,"set entityname [.occ_dlg.tree item [.occ_dlg.tree selection] -text ]\n"
,"set rootname \"\"\n"
,"if {[.occ_dlg.tree item [.occ_dlg.tree selection] -value] == 1 } {\n"
,"set rootname \"Topology\"\n"
,"}\n"
,"set spacepos [string first \" \" $entityname]\n"
,"set entitytype [string range $entityname 0 [expr $spacepos-1]]\n"
,"set helpstring [string range $entityname [expr $spacepos+1] [expr [string length $entityname]-1]]\n"
,"set spacepos2 [string first \" \" $helpstring]\n"
,"set entitynumber [string range $helpstring 0 [expr $spacepos2-1]]\n"
,"if {$rootname == \"Topology\"} {\n"
,"Ng_OCCCommand highlightentity $entitytype $entitynumber\n"
,"set selectvisual geometry\n"
,"redraw\n"
,"} {\n"
,"set brackpos [string first \" (\" $entityname]\n"
,"if {$brackpos != -1} {\n"
,"set entityname [string range $entityname 0 $brackpos]\n"
,"}\n"
,"selectentity $entityname\n"
,"}\n"
,"}\n"
,"ttk::button $w.cl -text \"Close\" -command {\n"
,"destroy .occ_dlg\n"
,"}\n"
,"ttk::button $w.show -text \"Show\" -command {\n"
,"set entityname [.occ_dlg.tree item [.occ_dlg.tree selection] -text ]\n"
,"set spacepos [string first \" \" $entityname]\n"
,"set entitytype [string range $entityname 0 [expr $spacepos-1]]\n"
,"set helpstring [string range $entityname [expr $spacepos+1] [expr [string length $entityname]-1]]\n"
,"set spacepos2 [string first \" \" $helpstring]\n"
,"set entitynumber [string range $helpstring 0 [expr $spacepos2-1]]\n"
,"Ng_OCCCommand show $entitytype $entitynumber\n"
,"set selectvisual geometry\n"
,"redraw\n"
,"}\n"
,"ttk::button $w.hide -text \"Hide\" -command {\n"
,"set entityname [.occ_dlg.tree item [.occ_dlg.tree selection] -text ]\n"
,"set spacepos [string first \" \" $entityname]\n"
,"set entitytype [string range $entityname 0 [expr $spacepos-1]]\n"
,"set helpstring [string range $entityname [expr $spacepos+1] [expr [string length $entityname]-1]]\n"
,"set spacepos2 [string first \" \" $helpstring]\n"
,"set entitynumber [string range $helpstring 0 [expr $spacepos2-1]]\n"
,"Ng_OCCCommand hide $entitytype $entitynumber\n"
,"set selectvisual geometry\n"
,"redraw\n"
,"}\n"
,"ttk::button $w.swaporientation -text \"Swap orientation\" -command {\n"
,"set entityname [.occ_dlg.tree item [.occ_dlg.tree selection] -text ]\n"
,"set spacepos [string first \" \" $entityname]\n"
,"set entitytype [string range $entityname 0 [expr $spacepos-1]]\n"
,"set helpstring [string range $entityname [expr $spacepos+1] [expr [string length $entityname]-1]]\n"
,"set spacepos2 [string first \" \" $helpstring]\n"
,"set entitynumber [string range $helpstring 0 [expr $spacepos2-1]]\n"
,"Ng_OCCCommand swaporientation $entitytype $entitynumber\n"
,"set selectvisual geometry\n"
,"redraw\n"
,".occ_dlg.tree delete [.occ_dlg.tree children Topology]\n"
,"occdialogbuildtree\n"
,"}\n"
,"ttk::button $w.marksingular -text \"Mark/Unmark as singular\" -command {\n"
,"set entityname [.occ_dlg.tree item [.occ_dlg.tree selection] -text ]\n"
,"set spacepos [string first \" \" $entityname]\n"
,"if { $spacepos != 0 } {\n"
,"set entitytype [string range $entityname 0 [expr $spacepos-1]]\n"
,"set helpstring [string range $entityname [expr $spacepos+1] [expr [string length $entityname]-1]]\n"
,"set spacepos2 [string first \" \" $helpstring]\n"
,"if { $spacepos2 != 0 } {\n"
,"set entitynumber [string range $helpstring 0 [expr $spacepos2-1]]\n"
,"puts $entitytype\n"
,"puts $entitynumber\n"
,"global ismarkedsingular\n"
,"Ng_OCCCommand marksingular $entitytype $entitynumber\n"
,"if { $ismarkedsingular == 0 } {\n"
,".occ_dlg.tree tag remove \"Color\" [.occ_dlg.tree selection]\n"
,"} {\n"
,".occ_dlg.tree tag add \"Color\" [.occ_dlg.tree selection]\n"
,".occ_dlg.tree tag configure \"Color\" -foreground \"red\"\n"
,".occ_dlg.tree tag configure \"Color\" -background \"blue\"\n"
,"}\n"
,"}\n"
,"}\n"
,"}\n"
,"ttk::checkbutton $w.zoomtohighlightedentity -text \"Zoom to highlighted entity\" \\\n"
,"-variable occoptions.zoomtohighlightedentity \\\n"
,"-command {\n"
,"Ng_SetOCCVisParameters\n"
,"if { ${occoptions.zoomtohighlightedentity} == 1} {\n"
,"set selectvisual geometry\n"
,"Ng_OCCCommand redrawstatus 1\n"
,"redraw\n"
,"} {\n"
,"Ng_OCCCommand redrawstatus 0\n"
,"}\n"
,"}\n"
,"ttk::frame $w.healing -relief groove -borderwidth 3\n"
,"ttk::button $w.healing.checkentities -text \"Analyze geometry\" -command {\n"
,"set irregent [Ng_OCCCommand findsmallentities]\n"
,"set w .occ_dlg\n"
,"set nritems [expr [llength $irregent]]\n"
,"set i [expr 0]\n"
,"if {$nritems > 0 } {\n"
,"if { [.occ_dlg.tree exists ProblematicEntities] == 1 } {\n"
,"$w.tree delete ProblematicEntities\n"
,"}\n"
,"$w.tree insert {} end -id ProblematicEntities -text \"Problematic Entities\"\n"
,"}\n"
,"while {$i < $nritems} {\n"
,"set entity [lindex $irregent [expr $i]]\n"
,"incr i 1\n"
,"set entityname [lindex $irregent [expr $i]]\n"
,"set myroot [string range $entity 0 [string last / $entity]-1]\n"
,"if { [string length $myroot] == 0 } {\n"
,"set myroot ProblematicEntities\n"
,"}\n"
,"$w.tree insert $myroot end -id $entity -text $entityname\n"
,"incr i 1\n"
,"}\n"
,"$w.tree item ProblematicEntities -open true\n"
,"}\n"
,"ttk::frame $w.healing.tolerance\n"
,"ttk::label $w.healing.tolerance.label -text \"Healing tolerance: \"\n"
,"ttk::spinbox $w.healing.tolerance.sp -textvariable occoptions.tolerance -width 6 -increment 0.01 -validate focus -validatecommand \"my_validatespinbox %W %P 12\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -from -1e-9 -to 1e6\n"
,"grid $w.healing.tolerance.label $w.healing.tolerance.sp\n"
,"ttk::checkbutton $w.healing.fixsmalledges -text \"Fix small edges\" \\\n"
,"-variable occoptions.fixsmalledges\n"
,"ttk::checkbutton $w.healing.fixspotstripfaces -text \"Fix spot/strip faces\" \\\n"
,"-variable occoptions.fixspotstripfaces\n"
,"ttk::checkbutton $w.healing.sewfaces -text \"Sew faces\" \\\n"
,"-variable occoptions.sewfaces\n"
,"ttk::checkbutton $w.healing.makesolids -text \"Make solids\" \\\n"
,"-variable occoptions.makesolids\n"
,"ttk::checkbutton $w.healing.splitpartitions -text \"Split partitions\" \\\n"
,"-variable occoptions.splitpartitions\n"
,"ttk::button $w.healing.heal -text \"Heal geometry\" -command {\n"
,"Ng_OCCCommand shapehealing\n"
,"redraw\n"
,".occ_dlg.tree delete [.occ_dlg.tree children Topology]\n"
,"occdialogbuildtree\n"
,"}\n"
,"pack $w.healing.checkentities\n"
,"pack $w.healing.tolerance $w.healing.fixsmalledges \\\n"
,"$w.healing.fixspotstripfaces $w.healing.sewfaces \\\n"
,"$w.healing.makesolids $w.healing.splitpartitions -anchor w\n"
,"pack $w.healing.heal\n"
,"pack $w.show $w.hide\n"
,"pack $w.zoomtohighlightedentity -anchor w\n"
,"pack $w.swaporientation\n"
,"pack $w.marksingular\n"
,"pack $w.healing -fill x\n"
,"pack $w.cl\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"IGES/STEP Topology Explorer/Doctor\"\n"
,"focus .occ_dlg\n"
,"}\n"
,"}\n"
,"}\n"
,"} }\n"
,"if { [Ng_ACISCommand isACISavailable] == \"yes\" } {\n"
,".ngmenu.geometry add command -label \"ACIS Topology Explorer...\" \\\n"
,"-command { acisdialog; }\n"
,".ngmenu.geometry add command -label \"ACIS combine all\" \\\n"
,"-command { Ng_ACISCommand combineall }\n"
,".ngmenu.geometry add command -label \"ACIS Create CT\" \\\n"
,"-command { Ng_ACISCommand createct }\n"
,"}\n"
,"catch { proc print_commandline_help { } {\n"
,"puts \"Usage: ng { options }\"\n"
,"puts \"-geofile=filename      Input geometry file (alternative:  ng filename)\"\n"
,"puts \"-meshfile=filename     Output mesh file\"\n"
,"puts \"-verycoarse, -coarse, -moderate, -fine, -veryfine\"\n"
,"puts \"                       Automatic mesh-size selection\"\n"
,"puts \"-meshsizefile=filename Load mesh-size file with local mesh sizes\"\n"
,"puts \"-meshfiletype={\\\"Neutral Format\\\", ...}\"\n"
,"puts \"                       Filetype of output file, default is netgen file\"\n"
,"puts \"-batchmode             Run Netgen in batchmode\"\n"
,"puts \"-inputmeshfile=filename\"\n"
,"puts \"                       Input mesh file (batchmode only)\"\n"
,"puts \"-mergefile=filename    Merge with mesh file (batchmode only)\"\n"
,"puts \"-refinementfile=filename\"\n"
,"puts \"                       Use refinementinfo from file (batchmode only)\"\n"
,"puts \"-serversocket=\\\n"
,"puts \"-V                     Print additional information\"\n"
,"puts \"-testout=filename      file for test output\"\n"
,"if { [catch { NGS_GetData } ] == 0 } {\n"
,"puts \"\\nNGSolve parameters:\"\n"
,"puts \"-pdefile=filename      Load pde input file\"\n"
,"puts \"-solve                 Solve pde once\"\n"
,"puts \"-solve=n               Solve pde by n adaptive refinement steps\"\n"
,"puts \"-recent                Load and solve most recently loaded pde\"\n"
,"}\n"
,"}\n"
,"proc set_menu_help { entry helpmsg } {\n"
,"global menuhelps\n"
,"set menuhelps($entry) $helpmsg\n"
,"}\n"
,"proc show_menu_help { entry } {\n"
,"global menuhelps\n"
,"if {[catch {set helptext $menuhelps($entry)}]} {\n"
,"set helptext \"no help available   \"\n"
,"}\n"
,".helpline configure -text $helptext\n"
,"if {[winfo exists .senshelp_dlg]==1} {\n"
,".senshelp_dlg.text delete 1.0 end\n"
,".senshelp_dlg.text insert end \"Menu item: $entry\\n\\n\"\n"
,".senshelp_dlg.text insert end $helptext\n"
,"}\n"
,"}\n"
,"proc set_control_help { control helpmsg } {\n"
,"bind $control <Enter> \"show_control_help {$helpmsg}\"\n"
,"bind $control <Leave> \"show_control_help {None}\"\n"
,".balloon bind  $control -balloonmsg $helpmsg -statusmsg $helpmsg\n"
,"}\n"
,"proc show_control_help { helpmsg } {\n"
,".helpline configure -text $helpmsg\n"
,"if {[winfo exists .senshelp_dlg]==1} {\n"
,".senshelp_dlg.text delete 1.0 end\n"
,".senshelp_dlg.text insert end $helpmsg\n"
,"}\n"
,"}\n"
,"proc sensitivehelpdialog { show } {\n"
,"set w .senshelp_dlg\n"
,"if {[winfo exists .senshelp_dlg] == 1} {\n"
,"if { $show == 1 } {\n"
,"wm withdraw .senshelp_dlg\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"wm withdraw $w\n"
,"}\n"
,"} {\n"
,"toplevel $w\n"
,"global senshelptext\n"
,"text $w.text -yscrollcommand \"$w.scroll set\" -setgrid true \\\n"
,"-width 40 -height 10  -wrap word\n"
,"scrollbar $w.scroll -command \"$w.text yview\"\n"
,"pack $w.scroll -side right -fill y\n"
,"pack $w.text -expand yes -fill both\n"
,"ttk::frame $w.bu\n"
,"pack $w.bu\n"
,"ttk::button $w.close -text \"Close\" \\\n"
,"-command {\n"
,"wm withdraw .senshelp_dlg\n"
,"set showsensitivehelp 0\n"
,"}\n"
,"pack $w.close\n"
,"if { $show == 1 } {\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Help\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"}\n"
,"set_menu_help \"File\"  \"In File menu you can load and store geometries, meshes etc.\"\n"
,"set_menu_help \"New Geometry\"  \"Deletes current geometry\"\n"
,"set_menu_help \"Load Geometry\"  \"Loads Geometry file in one of the formats STL (ASCII or binary), Constructive Solid Geometry (.geo) or 2D geometry. Please have a look into Netgen User's manuel for more details.\"\n"
,"set_menu_help \"Save Geometry\" \"Saves STL Geometry in in either ASCII or binary STL format.\"\n"
,"set_menu_help \"Load Mesh\" \"Loads surface and volume mesh in Netgen internal format.\"\n"
,"set_menu_help \"Save Mesh\" \"Saves surface and volume mesh in Netgen internal format.\"\n"
,"set_menu_help \"Write EPS File\" \"Dumps OpenGL rendering to EPS File.\"\n"
,"set_menu_help \"Save Options\" \"Saves current options in file \\\"ng.opt\\\". These options will be loaded again when starting ng in the same directory.\"\n"
,"set_menu_help \"Export Mesh\" \"Exports mesh in format defined by Export Filetype.\"\n"
,"set_menu_help \"Export Filetype\" \"Selects file format for exporting mesh. Please have a look into the Netgen User's manual for more information.\"\n"
,"set_menu_help \"Import Mesh\" \"Imports surface or volume mesh in exchange format.\"\n"
,"set_menu_help \"Quit\" \"Quits Netgen\"\n"
,"set_menu_help \"Geometry\" \"Preparing geometries, visualiztion of geometries.\"\n"
,"set_menu_help \"Scan CSG Geometry\" \"Generates surface triangulation for rendering\"\n"
,"set_menu_help \"CSG Options\" \"Sets Options for CSG visualization (bounding box, detail size, number of facets).\"\n"
,"set_menu_help \"CSG Properties\" \"Defines appearance of current CSG geometry (color, visibility, transparency)\"\n"
,"set_menu_help \"STL Doctor\" \"Calls STL Doctor for preprocessing STL geometry files.\"\n"
,"set_menu_help \"STL Info\" \"Retrieves information about current STL geometry.\"\n"
,"set_menu_help \"Mesh\" \"Menu for mesh generation\"\n"
,"set_menu_help \"Generate Mesh\" \"Generates mesh from geometry, same as Button \\\"Generate Mesh\\\"\"\n"
,"set_menu_help \"Stop Meshing\" \"Terminates meshgeneration. It may take a while until meshing terminates, please be patient.\"\n"
,"set_menu_help \"Meshing Options\" \"Set options for mesh generation.\"\n"
,"set_menu_help \"Delete Mesh\" \"Deletes mesh. Not necessary before generation of new mesh.\"\n"
,"set_menu_help \"Delete Vol Mesh\" \"Deletes only volume mesh.\"\n"
,"set_menu_help \"Mesh Quality\" \"Computs element shape measures. Triangle angles are inner angles of all triangles (faces of tetrahedra). Tet angles are angles between faces of tetrahedra.\"\n"
,"set_menu_help \"Check Surface Mesh\" \"Checks consistency and overlap of surface mesh. Marks overlapping elements as bad elements, please enable visualization of bad elements in View->Mesh.\"\n"
,"set_menu_help \"Check Volume Mesh\" \"Checks conformity of volume mesh.\"\n"
,"set_menu_help \"Edit Boundary Conditions\" \"Open dialog for setting boundary condition numbers for individual faces.\"\n"
,"set_menu_help \"Analyze Geometry\" \"Perform only first step in mesh generation. Action depends on geometry type, e.g. generates charts for STL mesh, find vertices in CSG geometries.\"\n"
,"set_menu_help \"Mesh Edges\" \"Meshes edges\"\n"
,"set_menu_help \"Mesh Surface\" \"Generates surface mesh. Includes already surface optimization for some geometry types.\"\n"
,"set_menu_help \"Optimize Surface\" \"Optimizes surface mesh.\"\n"
,"set_menu_help \"Surface Optim. Step\" \"Performs a specific surface optimiztion step. Mesh smoothing moves nodes. edge swapping swaps the diagonal of a quadrilateral built by two triangles, criterion either by number of nodes, or anlges. Combine points eliminates triangles by combining points (in the center of gravity).\"\n"
,"set_menu_help \"Mesh Volume\" \"Performs volume meshing. Algorithm is a combination of Delaunay and Rule-based Advancing Front\"\n"
,"set_menu_help \"Optimize Volume\" \"Performs additional volume optimization steps\"\n"
,"set_menu_help \"Smooth Opt Volume\" \"Performs optimization steps by smoothing iterations\"\n"
,"set_menu_help \"Smooth Opt Volume Jacobian\" \"Volume optimization by smoothing iterations. Criterion is optimization of Jacobi determinants. This optimization step is also available for 10-node tetrahedra.\"\n"
,"set_menu_help \"View\" \"Sets viewing options\"\n"
,"set_menu_help \"Zoom all\" \"Zooms scene to show whole object\"\n"
,"set_menu_help \"Center\" \"Defines center of rotation\"\n"
,"set_menu_help \"Viewing Options\" \"Sets viewing options for geometry, mesh, lighting\"\n"
,"set_menu_help \"Clipping Plane\" \"Introduces clipping plane. The clipping plane is defined by the normal vector, and a scaled offset. Clipping of performed by OpenGl rendering\"\n"
,"set_menu_help \"Quality Plot\" \"Shows the element quality distribution histogram. Measure is volume scaled by edge-length to the third. Optimal elements have measure 1.\"\n"
,"set_menu_help \"Sensitive Help\" \"Shows this help window\"\n"
,"set_menu_help \"Mesh-size\" \"Manipulations of existing mesh\"\n"
,"set_menu_help \"Refine uniform\" \"Refines mesh by splitting elements into eight childs (algorithm of J. Bey)\"\n"
,"set_menu_help \"Second Order\" \"Converts 4 node elements to 10 node elements. Edge-midpoitns are projected to the geometry.\"\n"
,"set_menu_help \"Refinement Dialog\" \"Controls local mesh refinement\"\n"
,"set_menu_help \"Load Meshsize\" \"Loads mesh-size file for local mesh refinement.\"\n"
,"set_menu_help \"MS from Surf Mesh\" \"Defines mesh-size by the surface mesh.\"\n"
,"set f .options_dlg.nb.nbframe.general\n"
,"set_control_help $f.fine \"Controls relative mesh size.\\nThis control affects other mesh-size controls in common\"\n"
,"set_control_help $f.first \"First step in mesh generation. Usually, meshing starts from \\\"analyze geometry\\\". If the surface mesh is already available \\\"First step\\\" should be set to \\\"mesh volume\\\"\"\n"
,"set_control_help $f.last \"Last step in mesh generation. If only the surface mesh is required, please set \\\"Last Step\\\" to \\\"Optimize Surface\\\"\"\n"
,"set_control_help .bubar.surfm \"Start mesh generation\"\n"
,"set_control_help .bubar.stopm \"Stop mesh generation\"\n"
,"proc help_item { helptext } {p\n"
,"puts $helptext\n"
,"}\n"
,"proc show_help { } {\n"
,"set w .help\n"
,"if {[winfo exists .help] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconif $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"frame $w.buttons\n"
,"pack $w.buttons -side bottom -fill x -pady 2m\n"
,"button $w.buttons.done -text Done -command \"destroy $w\"\n"
,"pack $w.buttons.done  -side left -expand 1\n"
,"text $w.text -yscrollcommand \"$w.scroll set\" -setgrid true \\\n"
,"-width 60 -height 24 -wrap word\n"
,"scrollbar $w.scroll -command \"$w.text yview\"\n"
,"pack $w.scroll -side right -fill y\n"
,"pack $w.text -expand yes -fill both\n"
,"}\n"
,"$w.text configure -state normal\n"
,"$w.text delete 1.0 end\n"
,"}\n"
,"set bold \"-background \n"
,"set normal \"-background {} -relief flat\"\n"
,"proc help_main { } {\n"
,"show_help;\n"
,"set w .help\n"
,"global bold\n"
,"global normal\n"
,"$w.text insert 0.0 \\\n"
,"{NETGEN Help}\n"
,"$w.text insert end \\n\\n\n"
,"$w.text insert end \\\n"
,"{1. General} d1\n"
,"$w.text insert end \\n\\n\n"
,"$w.text insert end \\\n"
,"{2. Menu items } d2\n"
,"$w.text insert end \\n\\n\n"
,"foreach tag {d1 d2} {\n"
,"$w.text tag bind $tag <Any-Enter> \"$w.text tag configure $tag $bold\"\n"
,"$w.text tag bind $tag <Any-Leave> \"$w.text tag configure $tag $normal\"\n"
,"}\n"
,"$w.text tag bind d1 <1> { puts \"general\"; help_general }\n"
,"$w.text tag bind d2 <1> { help_menus }\n"
,"$w.text configure -state disabled\n"
,"}\n"
,"proc help_general { } {\n"
,"show_help;\n"
,"set w .help\n"
,"global bold\n"
,"global normal\n"
,"puts \"general called\"\n"
,"$w.text insert 0.0 \\\n"
,"{NETGEN is an automatic three dimensional tetrahedral mesh generation system. It accepts input from constructive solid geometry (CSG) or boundary representation (BRep) from STEP or STL file format. NETGEN contains modules for mesh optimization and hierarchical mesh refinement.}\n"
,"$w.text configure -state disabled\n"
,"}\n"
,"proc help_menus { } {\n"
,"show_help;\n"
,"set w .help\n"
,"global bold\n"
,"global normal\n"
,"$w.text insert 0.0 \\\n"
,"{The NETGEN Menu items are}\n"
,"$w.text insert end \\n\\n\n"
,"$w.text insert end \\\n"
,"{1. File} d1\n"
,"$w.text insert end \\n\\n\n"
,"$w.text insert end \\\n"
,"{2. Geometry } d2\n"
,"$w.text insert end \\n\\n\n"
,"$w.text insert end \\\n"
,"{3. Mesh } d3\n"
,"$w.text insert end \\n\\n\n"
,"$w.text insert end \\\n"
,"{4. View } d4\n"
,"$w.text insert end \\n\\n\n"
,"$w.text insert end \\\n"
,"{5. Mesh-size } d5\n"
,"$w.text insert end \\n\\n\n"
,"$w.text insert end \\\n"
,"{6. STL } d6\n"
,"foreach tag {d1 d2 d3 d4 d5 d6} {\n"
,"$w.text tag bind $tag <Any-Enter> \"$w.text tag configure $tag $bold\"\n"
,"$w.text tag bind $tag <Any-Leave> \"$w.text tag configure $tag $normal\"\n"
,"}\n"
,"$w.text tag bind d1 <1> {puts \"File menu\"}\n"
,"$w.text tag bind d2 <1> {puts \"Geometry menu\"}\n"
,"$w.text tag bind d3 <1> {puts \"Mesh menu\"}\n"
,"$w.text tag bind d4 <1> {puts \"View menu\"}\n"
,"$w.text tag bind d5 <1> {puts \"Mesh-size menu\"}\n"
,"$w.text tag bind d6 <1> {puts \"STL menu\"}\n"
,"$w.text configure -state disabled\n"
,"}\n"
,"}\n"
,"catch { Ng_Vis_Set parameters\n"
,"set viscnt 0\n"
,"proc snapshottimer { } {\n"
,"after 2000 { snapshottimer }\n"
,"global viscnt\n"
,"set viscnt [expr $viscnt+1]\n"
,"set s1 0000$viscnt\n"
,"set cnt [string range $s1 [expr [string length $s1]-4] end]\n"
,"set filename \"p$cnt.jpg\"\n"
,"}\n"
,"snapshottimer\n"
,"proc redrawtimer { } {\n"
,"global visoptions.autoredraw\n"
,"global visoptions.autoredrawtime\n"
,"set delay [expr int(${visoptions.autoredrawtime}*1000)]\n"
,"if { ${visoptions.autoredraw} == 1 } { redraw; }\n"
,"after $delay { redrawtimer }\n"
,"}\n"
,"redrawtimer\n"
,"set perstarttime [clock clicks -millisecond]\n"
,"proc redrawperiodic { } {\n"
,"global visoptions.redrawperiodic\n"
,"global perstarttime\n"
,"set curtime [clock clicks -millisecond]\n"
,"Ng_Vis_Set time [expr ($curtime - $perstarttime) / 5]\n"
,"redraw\n"
,"if { ${visoptions.redrawperiodic} == 1 } { after 30 { redrawperiodic } };\n"
,"}\n"
,"proc addplotline { identifier datax datay plotinfo {color black}} {\n"
,"set c $identifier.c\n"
,"set xstart [lindex $plotinfo 0]\n"
,"set ystart [lindex $plotinfo 1]\n"
,"set xmin [lindex $plotinfo 2]\n"
,"set ymin [lindex $plotinfo 3]\n"
,"set unitx [lindex $plotinfo 4]\n"
,"set unity [lindex $plotinfo 5]\n"
,"set latestx [expr ([lindex $datax 0]-$xmin)*$unitx + $xstart]\n"
,"set latesty [expr ([lindex $datay 0]-$ymin)*$unity + $ystart]\n"
,"for {set i 1} {$i < [llength $datax]} {incr i} {\n"
,"set xpos [expr ([lindex $datax $i]-$xmin)*$unitx + $xstart]\n"
,"set ypos [expr ([lindex $datay $i]-$ymin)*$unity + $ystart]\n"
,"$c create line $latestx $latesty $xpos $ypos -width 1 -fill $color\n"
,"set latestx $xpos\n"
,"set latesty $ypos\n"
,"}\n"
,"}\n"
,"proc createlineplot { width height identifier title xmin xmax ymin ymax plotinfo} {\n"
,"set thiswidth $width\n"
,"set thisheight $height\n"
,"if { $thiswidth < 275 } { set thiswidth 275 }\n"
,"if { $thisheight < 225 } { seth thisheight 225 }\n"
,"set w $identifier\n"
,"if {[winfo exists $w] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"set c $w.c\n"
,"canvas $c -relief raised -width $thiswidth -height $thisheight\n"
,"pack $w.c -side top -fill x\n"
,"set titleFont {Helvetica 18}\n"
,"set smallFont {Helvetica 12}\n"
,"set xstart 100\n"
,"set xend [expr $thiswidth-75]\n"
,"set ystart [expr $thisheight-75]\n"
,"set yend 75\n"
,"$c create line $xstart $ystart $xstart $yend -width 2\n"
,"$c create line $xstart $ystart $xend $ystart -width 2\n"
,"set unitx [expr double($xend-$xstart)/($xmax-$xmin)]\n"
,"set unity [expr double($yend-$ystart)/($ymax-$ymin)]\n"
,"for {set i 0} {$i <= 1} {set i [expr $i+0.2]} {\n"
,"$c create line [expr $xstart+$i*($xend-$xstart)] [expr $ystart] [expr $xstart+$i*($xend-$xstart)] [expr $ystart+5] -width 2\n"
,"$c create text [expr $xstart+$i*($xend-$xstart)] [expr $ystart+7] -anchor n -font $smallFont \\\n"
,"-text [format \"%.3g\" [expr $xmin+$i*($xmax-$xmin)]]\n"
,"$c create line [expr $xstart] [expr $ystart+$i*($yend-$ystart)] [expr $xstart-7] [expr $ystart+$i*($yend-$ystart)] -width 2\n"
,"$c create text [expr $xstart-9] [expr $ystart+$i*($yend-$ystart)] -anchor e -font $smallFont \\\n"
,"-text [format \"%.3g\" [expr $ymin+$i*($ymax-$ymin)]]\n"
,"}\n"
,"upvar $plotinfo ploti\n"
,"set ploti \"$xstart $ystart $xmin $ymin $unitx $unity\"\n"
,"button $w.close -text \"Close\" -command \"destroy $w\"\n"
,"pack $w.close\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w $title\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"proc getlineplotdata { datax datay xmini xmaxi ymini ymaxi} {\n"
,"upvar $datax datx\n"
,"upvar $datay daty\n"
,"upvar $xmini xmin\n"
,"upvar $xmaxi xmax\n"
,"upvar $ymini ymin\n"
,"upvar $ymaxi ymax\n"
,"global visoptions.lineplotusingx\n"
,"global visoptions.lineplotusingy\n"
,"global visoptions.lineplotsource\n"
,"global visoptions.lineplotfile\n"
,"set datx \"\"\n"
,"set daty \"\"\n"
,"set xmin 1e20\n"
,"set xmax -1e20\n"
,"set ymin 1e20\n"
,"set ymax -1e20\n"
,"if {${visoptions.lineplotsource} == \"file\"} {\n"
,"set fileId [open ${visoptions.lineplotfile} r]\n"
,"set line \"\"\n"
,"while {[gets $fileId line] >= 0} {\n"
,"if { [string index [lindex $line 0] 0] != \"\\\n"
,"if { ${visoptions.lineplotusingx} < [llength $line] } {\n"
,"lappend datx [lindex $line ${visoptions.lineplotusingx}]\n"
,"if { [lindex $datx end] < $xmin } {set xmin [lindex $datx end]}\n"
,"if { [lindex $datx end] > $xmax } {set xmax [lindex $datx end]}\n"
,"} {\n"
,"lappend datx 0\n"
,"}\n"
,"if { ${visoptions.lineplotusingy} < [llength $line] } {\n"
,"lappend daty [lindex $line ${visoptions.lineplotusingy}]\n"
,"if { [lindex $daty end] < $ymin } {set ymin [lindex $daty end]}\n"
,"if { [lindex $daty end] > $ymax } {set ymax [lindex $daty end]}\n"
,"} {\n"
,"lappend daty 0\n"
,"}\n"
,"}\n"
,"}\n"
,"close $fileId\n"
,"}\n"
,"}\n"
,"proc lineplotdialog { } {\n"
,"set w .lineplot_dlg\n"
,"if {[winfo exists .lineplot_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"ttk::frame $w.filesettings -relief  groove -borderwidth 3\n"
,"ttk::frame $w.filesettings.title\n"
,"ttk::radiobutton $w.filesettings.title.choose -variable visoptions.lineplotsource \\\n"
,"-value file -text \"Data from File\"\n"
,"pack $w.filesettings.title.choose -side left\n"
,"pack $w.filesettings.title\n"
,"global visoptions.lineplotselectedeval\n"
,"global visoptions.lineplotfile\n"
,"global visoptions.evaluatefilenames\n"
,"global visoptions.evaluatefiledescriptions\n"
,"set evdata [NGS_GetData evaluatefiles]\n"
,"set visoptions.evaluatefilenames none\n"
,"set visoptions.evaluatefiledescriptions none\n"
,"for {set i 0} {[expr $i+1] < [llength $evdata]} {incr i 2} {\n"
,"lappend visoptions.evaluatefilenames [lindex $evdata $i]\n"
,"lappend visoptions.evaluatefiledescriptions [lindex $evdata [expr $i+1]]\n"
,"}\n"
,"ttk::frame $w.filesettings.latestevals\n"
,"ttk::label  $w.filesettings.latestevals.lab -text \"Use Evaluate Results: \"\n"
,"ttk::menubutton $w.filesettings.latestevals.but -menu $w.filesettings.latestevals.menu -text \"coarse\" -width 40\n"
,"menu $w.filesettings.latestevals.menu -tearoff 0\n"
,"for {set i 0} {$i < [llength ${visoptions.evaluatefilenames}]} {incr i} {\n"
,"$w.filesettings.latestevals.menu add command -label $i\\\n"
,"-command \"set visoptions.lineplotselectedeval $i ; $w.filesettings.latestevals.but configure -text \\\"[lindex ${visoptions.evaluatefiledescriptions} $i] ([lindex ${visoptions.evaluatefilenames} $i])\\\"\"\n"
,"}\n"
,"$w.filesettings.latestevals.menu invoke ${visoptions.lineplotselectedeval}\n"
,"grid $w.filesettings.latestevals.lab $w.filesettings.latestevals.but -sticky nw\n"
,"pack $w.filesettings.latestevals\n"
,"ttk::frame $w.filesettings.sfn\n"
,"ttk::button $w.filesettings.sfn.bb -text \"Browse\" \\\n"
,"-command { set visoptions.lineplotfile [tk_getOpenFile] }\n"
,"ttk::entry $w.filesettings.sfn.fn -width 50 \\\n"
,"-textvariable visoptions.lineplotfile\n"
,"pack $w.filesettings.sfn.bb $w.filesettings.sfn.fn -side left\n"
,"pack $w.filesettings.sfn\n"
,"ttk::button $w.filesettings.refresh -text \"Refresh\" -command {\n"
,"if { ${visoptions.lineplotselectedeval} != 0} {\n"
,"set visoptions.lineplotfile [lindex ${visoptions.evaluatefilenames} ${visoptions.lineplotselectedeval}]\n"
,"}\n"
,"set saveusingx ${visoptions.lineplotusingx}\n"
,"set saveusingy ${visoptions.lineplotusingy}\n"
,"for { set i 0 } { $i < [llength ${visoptions.lineplotdatadescr}] } { incr i } {\n"
,"${visoptions.lineplotxcoordselector} delete $i\n"
,"}\n"
,"for { set i 0 } { $i < [llength ${visoptions.lineplotdatadescr}] } { incr i } {\n"
,"${visoptions.lineplotycoordselector} delete $i\n"
,"}\n"
,"set fileId [open ${visoptions.lineplotfile} r]\n"
,"set line \"\"\n"
,"gets $fileId line\n"
,"close $fileId\n"
,"if { [lindex $line 0] == \"\\\n"
,"set visoptions.lineplotdatadescr [lrange $line 1 end]\n"
,"} {\n"
,"set visoptions.lineplotdatadescr \"\"\n"
,"for { set i 0 } { $i < [llength $line] } { incr i } {\n"
,"lappend visoptions.lineplotdatadescr \"data[expr $i+1]\"\n"
,"}\n"
,"}\n"
,"for { set i 0 } { $i < [llength ${visoptions.lineplotdatadescr}] } { incr i } {\n"
,"${visoptions.lineplotxcoordselector} add command $i -label [lindex ${visoptions.lineplotdatadescr} $i]\n"
,"}\n"
,"for { set i 0 } { $i < [llength ${visoptions.lineplotdatadescr}] } { incr i } {\n"
,"${visoptions.lineplotycoordselector} add command $i -label [lindex ${visoptions.lineplotdatadescr} $i]\n"
,"}\n"
,"if { $saveusingx < [llength ${visoptions.lineplotdatadescr}] } {\n"
,"set visoptions.lineplotusingx $saveusingx\n"
,"} {\n"
,"set visoptions.lineplotusingx 0\n"
,"}\n"
,"if { $saveusingy < [llength ${visoptions.lineplotdatadescr}] } {\n"
,"set visoptions.lineplotusingy $saveusingy\n"
,"} {\n"
,"set visoptions.lineplotusingy 1\n"
,"}\n"
,"}\n"
,"pack $w.filesettings.refresh\n"
,"ttk::frame $w.filesettings.using\n"
,"global visoptions.lineplotdatadescr\n"
,"ttk::frame $w.filesettings.using.xco\n"
,"ttk::label  $w.filesettings.using.xco.lab -text \"X-Coord:\"\n"
,"ttk::menubutton $w.filesettings.using.xco.but -menu $w.filesettings.using.xco.menu -text \"\" -width 15\n"
,"menu $w.filesettings.using.xco.menu -tearoff 0\n"
,"for {set i 0} {$i < [llength ${visoptions.lineplotdatadescr}]} {incr i} {\n"
,"$w.filesettings.using.xco.menu add command -label [lindex ${visoptions.lineplotdatadescr} $i]\\\n"
,"-command \"set visoptions.lineplotusingx $i ; $w.filesettings.using.xco.but configure -text \\\"[lindex ${visoptions.lineplotdatadescr} $i]\\\"\"\n"
,"}\n"
,"$w.filesettings.using.xco.menu invoke [lindex ${visoptions.lineplotdatadescr} 0]\n"
,"grid $w.filesettings.using.xco.lab $w.filesettings.using.xco.but -sticky nw\n"
,"ttk::frame $w.filesettings.using.yco\n"
,"ttk::label  $w.filesettings.using.yco.lab -text \"Y-Coord:\"\n"
,"ttk::menubutton $w.filesettings.using.yco.but -menu $w.filesettings.using.yco.menu -text \"\" -width 15\n"
,"menu $w.filesettings.using.yco.menu -tearoff 0\n"
,"for {set i 0} {$i < [llength ${visoptions.lineplotdatadescr}]} {incr i} {\n"
,"$w.filesettings.using.yco.menu add command -label [lindex ${visoptions.lineplotdatadescr} $i]\\\n"
,"-command \"set visoptions.lineplotusingy $i ; $w.filesettings.using.yco.but configure -text \\\"[lindex ${visoptions.lineplotdatadescr} $i]\\\"\"\n"
,"}\n"
,"$w.filesettings.using.yco.menu invoke [lindex ${visoptions.lineplotdatadescr} 0]\n"
,"grid $w.filesettings.using.yco.lab $w.filesettings.using.yco.but -sticky nw\n"
,"global visoptions.lineplotxcoordselector\n"
,"global visoptions.lineplotycoordselector\n"
,"set visoptions.lineplotxcoordselector $w.filesettings.using.xco\n"
,"set visoptions.lineplotycoordselector $w.filesettings.using.yco\n"
,"pack $w.filesettings.using.xco $w.filesettings.using.yco -side left\n"
,"pack $w.filesettings.using\n"
,"pack $w.filesettings -fill x -ipady 3\n"
,"ttk::frame $w.settings -relief  groove -borderwidth 3\n"
,"ttk::label $w.settings.title -text \"\\nSettings\\n\"\n"
,"pack $w.settings.title\n"
,"ttk::frame $w.settings.minmax\n"
,"ttk::checkbutton $w.settings.minmax.autoscale -text \"Autoscale\" -variable visoptions.lineplotautoscale\n"
,"ttk::frame $w.settings.minmax.xmin\n"
,"ttk::label $w.settings.minmax.xmin.label -text \"Min. x: \"\n"
,"ttk::spinbox $w.settings.minmax.xmin.sp -textvariable visoptions.lineplotxmin -width 6 -increment 0.1 -validate focus -validatecommand \"my_validatespinbox %W %P 3\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -from -1e9 -to 1e9\n"
,"ttk::frame $w.settings.minmax.xmax\n"
,"ttk::label $w.settings.minmax.xmax.label -text \"Max. x: \"\n"
,"ttk::spinbox $w.settings.minmax.xmax.sp -textvariable visoptions.lineplotxmax -width 6 -increment 0.1 -validate focus -validatecommand \"my_validatespinbox %W %P 3\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -from -1e9 -to 1e9\n"
,"ttk::frame $w.settings.minmax.ymin\n"
,"ttk::label $w.settings.minmax.ymin.label -text \"Min. y: \"\n"
,"ttk::spinbox $w.settings.minmax.ymin.sp -textvariable visoptions.lineplotymin -width 6 -increment 0.1 -validate focus -validatecommand \"my_validatespinbox %W %P 3\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -from -1e9 -to 1e9\n"
,"ttk::frame $w.settings.minmax.ymax\n"
,"ttk::label $w.settings.minmax.ymax.label -text \"Max. y: \"\n"
,"ttk::spinbox $w.settings.minmax.ymax.sp -textvariable visoptions.lineplotymax -width 6 -increment 0.1 -validate focus -validatecommand \"my_validatespinbox %W %P 3\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -from -1e9 -to 1e9\n"
,"pack $w.settings.minmax.xmin.label $w.settings.minmax.xmin.sp\n"
,"pack $w.settings.minmax.xmax.label $w.settings.minmax.xmax.sp\n"
,"pack $w.settings.minmax.ymin.label $w.settings.minmax.ymin.sp\n"
,"pack $w.settings.minmax.ymax.label $w.settings.minmax.ymax.sp\n"
,"pack $w.settings.minmax.autoscale $w.settings.minmax.xmin $w.settings.minmax.xmax \\\n"
,"$w.settings.minmax.ymin $w.settings.minmax.ymax -side left\n"
,"pack $w.settings.minmax\n"
,"ttk::label $w.settings.empty1 -text \"\"\n"
,"pack $w.settings.empty1\n"
,"ttk::frame $w.settings.plotsize\n"
,"ttk::frame $w.settings.plotsize.xsize\n"
,"ttk::label $w.settings.plotsize.xsize.label -text \"Plotsize  x: \"\n"
,"ttk::spinbox $w.settings.plotsize.xsize.sp -textvariable visoptions.lineplotsizex -width 6 -increment 1 -validate focus -validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -from -1e9 -to 1e9\n"
,"pack $w.settings.plotsize.xsize.label $w.settings.plotsize.xsize.sp\n"
,"ttk::frame $w.settings.plotsize.ysize\n"
,"ttk::label $w.settings.plotsize.ysize.label -text \"Plotsize  y: \"\n"
,"ttk::spinbox $w.settings.plotsize.ysize.sp -textvariable visoptions.lineplotsizey -width 6 -increment 1 -validate focus -validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -from -1e9 -to 1e9\n"
,"pack $w.settings.plotsize.ysize.label $w.settings.plotsize.ysize.sp\n"
,"pack $w.settings.plotsize.xsize $w.settings.plotsize.ysize -side left\n"
,"pack $w.settings.plotsize\n"
,"ttk::label $w.settings.empty2 -text \"\"\n"
,"pack $w.settings.empty2\n"
,"ttk::frame $w.settings.color\n"
,"ttk::label  $w.settings.color.lab -text \"Linecolor: \"\n"
,"ttk::menubutton $w.settings.color.but -menu $w.settings.color.menu -text \"\" -width 15\n"
,"menu $w.settings.color.menu -tearoff 0\n"
,"foreach step { red black blue green yellow } {\n"
,"$w.settings.color.menu add command -label $step -command \"set visoptions.lineplotcolor $step; $w.settings.color.but configure -text \\\"$step\\\"\"\n"
,"}\n"
,"$w.settings.color.menu invoke \"red\"\n"
,"grid $w.settings.color.lab $w.settings.color.but -sticky nw\n"
,"pack $w.settings.color\n"
,"pack $w.settings -fill x\n"
,"set datax \"\"\n"
,"set datay \"\"\n"
,"set xmin 0\n"
,"set xmax 0\n"
,"set ymin 0\n"
,"set ymax 0\n"
,"ttk::frame $w.plots -relief  groove -borderwidth 3\n"
,"ttk::frame $w.plots.selplot\n"
,"ttk::label  $w.plots.selplot.lab -text \"Linecolor: \"\n"
,"ttk::menubutton $w.plots.selplot.but -menu $w.plots.selplot.menu -text \"\" -width 15\n"
,"menu $w.plots.selplot.menu -tearoff 0\n"
,"$w.plots.selplot.menu add command -label \"None\" -command \"set visoptions.lineplotselected \\\"None\\\"; $w.plots.selplot.but configure -text \\\"None\\\"\"\n"
,"grid $w.plots.selplot.lab $w.plots.selplot.but -sticky nw\n"
,"$w.plots.selplot.menu invoke \"None\"\n"
,"global visoptions.lineplotselector\n"
,"set visoptions.lineplotselector $w.plots.selplot.menu\n"
,"ttk::button $w.plots.new -text \"Generate New Plot\" -command {\n"
,"if { ${visoptions.lineplotselectedeval} != 0} {\n"
,"set visoptions.lineplotfile [lindex ${visoptions.evaluatefilenames} ${visoptions.lineplotselectedeval}]\n"
,"}\n"
,"getlineplotdata datax datay xmin xmax ymin ymax\n"
,"puts stdout \"xmin $xmin xmax $xmax ymin $ymin ymax $ymax\"\n"
,"global visoptions.lineplotautoscale\n"
,"if {! ${visoptions.lineplotautoscale}} {\n"
,"puts \"using set min/max values\"\n"
,"set xmin ${visoptions.lineplotxmin}\n"
,"set xmax ${visoptions.lineplotxmax}\n"
,"set ymin ${visoptions.lineplotymin}\n"
,"set ymax ${visoptions.lineplotymax}\n"
,"}\n"
,"incr visoptions.lineplotcurrentnum\n"
,"set ident .newplot${visoptions.lineplotcurrentnum}\n"
,"set plotinfo \"\"\n"
,"createlineplot ${visoptions.lineplotsizex} ${visoptions.lineplotsizey} \\\n"
,"$ident \"Lineplot ${visoptions.lineplotcurrentnum}\" \\\n"
,"$xmin $xmax $ymin $ymax plotinfo\n"
,"lappend visoptions.lineplotinfos $plotinfo\n"
,"${visoptions.lineplotselector} add command ${visoptions.lineplotcurrentnum} -label \"Lineplot ${visoptions.lineplotcurrentnum}\"\n"
,"addplotline $ident $datax $datay $plotinfo ${visoptions.lineplotcolor}\n"
,"}\n"
,"ttk::button $w.plots.addto -text \"Add to Selected Plot\" -command {\n"
,"if { ${visoptions.lineplotselectedeval} != 0} {\n"
,"set visoptions.lineplotfile [lindex ${visoptions.evaluatefilenames} ${visoptions.lineplotselectedeval}]\n"
,"}\n"
,"if { ${visoptions.lineplotselected} != \"none\" } {\n"
,"getlineplotdata datax datay xmin xmax ymin ymax\n"
,"set ident .newplot${visoptions.lineplotselected}\n"
,"set plotinfo [lindex ${visoptions.lineplotinfos} ${visoptions.lineplotselected}]\n"
,"addplotline $ident $datax $datay $plotinfo ${visoptions.lineplotcolor}\n"
,"}\n"
,"}\n"
,"pack $w.plots.new $w.plots.addto $w.plots.selplot\n"
,"pack $w.plots -fill x -ipady 3\n"
,"ttk::button $w.close -text \"Close\" -command \"destroy $w\"\n"
,"pack $w.close\n"
,"wm withdraw $w\n"
,"wm geom $w +200+100\n"
,"wm deiconify $w\n"
,"wm title $w \"2D Lineplots\"\n"
,"focus $w\n"
,"}\n"
,"}\n"
,"set fieldlinesdialog_pop1 0\n"
,"proc fieldlinesdialog { } {\n"
,"set w .fieldlines_dlg\n"
,"global fieldlinesdialog_pop1\n"
,"set fieldlinesdialog_pop1 1\n"
,"if {[winfo exists .fieldlines_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"pack [ttk::notebook $w.nb]  -fill both -side top -ipadx 6 -ipady 6\n"
,"$w.nb add [ttk::frame $w.nb.draw] -text \"Draw\" -underline 0\n"
,"$w.nb add [ttk::frame $w.nb.settings] -text \"Settings\" -underline 0\n"
,"set f $w.nb.draw\n"
,"ttk::labelframe $f.general -text \"General settings\" -relief groove -borderwidth 3\n"
,"ttk::checkbutton $f.general.enable -text \"Enable Fieldlines\" \\\n"
,"-variable visoptions.drawfieldlines \\\n"
,"-command {\n"
,"Ng_Vis_Set parameters;\n"
,"redraw\n"
,"}\n"
,"ttk::label $f.general.numl -text \"num:\"\n"
,"ttk::spinbox $f.general.num -from 0 -to 100 -increment 1 \\\n"
,"-textvariable visoptions.numfieldlines -width 4\n"
,"grid $f.general.enable -sticky nw -padx 4 -pady 2\n"
,"grid x $f.general.numl $f.general.num -rowspan 3 -sticky w -padx 4 -row 0 -pady 2\n"
,"grid anchor $f.general center\n"
,"pack $f.general -pady 15 -fill x -ipady 3\n"
,"ttk::label $f.labe0 -text \" \"\n"
,"pack $f.labe0\n"
,"ttk::checkbutton $f.general.randomstart -text \"Field dependent density    \" \\\n"
,"-variable visoptions.fieldlinesrandomstart \\\n"
,"-command { Ng_Vis_Set parameters; redraw}\n"
,"ttk::checkbutton $f.general.redrawperiodic -text \"Animate periodic\" \\\n"
,"-variable visoptions.redrawperiodic \\\n"
,"-command {\n"
,"redrawperiodic\n"
,"Ng_Vis_Set parameters;\n"
,"redraw\n"
,"}\n"
,"grid $f.general.randomstart -sticky nw -padx 4 -row 1\n"
,"grid $f.general.redrawperiodic -sticky nw -padx 4 -row 2\n"
,"ttk::label $f.lab0 -text \" \"\n"
,"pack $f.lab0\n"
,"ttk::frame $f.vecfun\n"
,"ttk::label  $f.vecfun.lab -text \"Vector Function: \"\n"
,"ttk::menubutton $f.vecfun.but -menu $f.vecfun.menu -text \"\" -width 12\n"
,"menu $f.vecfun.menu -tearoff 0\n"
,"for { set i 1 } { $i <= [Ng_Vis_Field getnfieldnames] } { incr i } {\n"
,"set fname [Ng_Vis_Field getfieldname $i]\n"
,"set fcomp [Ng_Vis_Field getfieldcomponents $i]\n"
,"set iscomplex [Ng_Vis_Field iscomplex $i]\n"
,"set sdim [Ng_Vis_Field getdimension]\n"
,"if { $iscomplex == 1 } { set fcomp [expr $fcomp / 2] }\n"
,"if { ($fcomp == $sdim) || ($fcomp == 3) } {\n"
,"$f.vecfun.menu add command -label $fname -command \"set visoptions.fieldlinesvecfunction $fname;Ng_Vis_Set parameters; redraw;$f.vecfun.but configure -text \\\"$fname\\\" \" 	    }\n"
,"}\n"
,"grid $f.vecfun.lab $f.vecfun.but -sticky nw\n"
,"pack $f.vecfun\n"
,"ttk::label $f.lab00 -text \" \"\n"
,"pack $f.lab00\n"
,"ttk::frame $f.phasesettings\n"
,"ttk::checkbutton $f.phasesettings.onephase -text \"Fix Phase\" -variable visoptions.fieldlinesonlyonephase\n"
,"ttk::frame $f.phasesettings.phase\n"
,"ttk::label $f.phasesettings.phase.lab -text \"phi\"\n"
,"ttk::scale $f.phasesettings.phase.sc -orient horizontal -length 100 -from 0 -to 360 -variable visoptions.fieldlinesphase \\\n"
,"-command \"roundscale $f.phasesettings.phase.sc 0; popupcheckredraw3 fieldlinesdialog_pop1\"\n"
,"ttk::entry $f.phasesettings.phase.ent -width 4 -textvariable visoptions.fieldlinesphase -validate focus -takefocus 0 \\\n"
,"-validatecommand \"popupcheckredraw3 fieldlinesdialog_pop1;my_validate %W 0 1 %P 0\" \\\n"
,"-invalidcommand \"my_invalid %W;popupcheckredraw3 fieldlinesdialog_pop1\"\n"
,"grid $f.phasesettings.phase.lab $f.phasesettings.phase.sc $f.phasesettings.phase.ent -sticky nw -ipadx 4\n"
,"pack $f.phasesettings.onephase $f.phasesettings.phase -side left\n"
,"pack $f.phasesettings\n"
,"ttk::label $f.lab1 -text \" \"\n"
,"pack $f.lab1\n"
,"ttk::frame $f.boxsettings -relief groove -borderwidth 3\n"
,"ttk::frame $f.boxsettings.title\n"
,"ttk::radiobutton $f.boxsettings.title.choose -variable visoptions.fieldlinesstartarea \\\n"
,"-value box -text \"Startpoints in Box\"\n"
,"pack $f.boxsettings.title.choose -side left\n"
,"pack $f.boxsettings.title\n"
,"ttk::frame $f.boxsettings.points\n"
,"ttk::label $f.boxsettings.points.lab2 -text \"Pmin\";\n"
,"ttk::entry $f.boxsettings.points.ent1x -width 8 \\\n"
,"-textvariable visoptions.fieldlinesstartareap1x\n"
,"ttk::entry $f.boxsettings.points.ent1y -width 8 \\\n"
,"-textvariable visoptions.fieldlinesstartareap1y\n"
,"ttk::entry $f.boxsettings.points.ent1z -width 8 \\\n"
,"-textvariable visoptions.fieldlinesstartareap1z\n"
,"ttk::label $f.boxsettings.points.lab3 -text \"   Pmax\";\n"
,"ttk::entry $f.boxsettings.points.ent2x -width 8 \\\n"
,"-textvariable visoptions.fieldlinesstartareap2x\n"
,"ttk::entry $f.boxsettings.points.ent2y -width 8 \\\n"
,"-textvariable visoptions.fieldlinesstartareap2y\n"
,"ttk::entry $f.boxsettings.points.ent2z -width 8 \\\n"
,"-textvariable visoptions.fieldlinesstartareap2z\n"
,"pack $f.boxsettings.points\n"
,"pack $f.boxsettings.points.lab2 $f.boxsettings.points.ent1x $f.boxsettings.points.ent1y $f.boxsettings.points.ent1z -side left\n"
,"pack $f.boxsettings.points.lab3 $f.boxsettings.points.ent2x $f.boxsettings.points.ent2y $f.boxsettings.points.ent2z -side left\n"
,"ttk::button $f.boxsettings.settobb -text \"Bounding Box\" -command {\n"
,"set bbox [Ng_MeshInfo bbox]\n"
,"set visoptions.fieldlinesstartareap1x [lindex $bbox 0]\n"
,"set visoptions.fieldlinesstartareap2x [lindex $bbox 1]\n"
,"set visoptions.fieldlinesstartareap1y [lindex $bbox 2]\n"
,"set visoptions.fieldlinesstartareap2y [lindex $bbox 3]\n"
,"set visoptions.fieldlinesstartareap1z [lindex $bbox 4]\n"
,"set visoptions.fieldlinesstartareap2z [lindex $bbox 5]\n"
,"}\n"
,"pack $f.boxsettings.settobb\n"
,"pack $f.boxsettings -fill x -ipady 3\n"
,"ttk::frame $f.facesettings -relief groove -borderwidth 3\n"
,"ttk::frame $f.facesettings.title\n"
,"ttk::radiobutton $f.facesettings.title.choose -variable visoptions.fieldlinesstartarea \\\n"
,"-value face -text \"Startpoints on Face\"\n"
,"pack $f.facesettings.title.choose -side left\n"
,"pack $f.facesettings.title\n"
,"ttk::frame $f.facesettings.index\n"
,"ttk::label $f.facesettings.index.lab -text \"face index:\"\n"
,"ttk::label $f.facesettings.index.ent -text 1;\n"
,"pack $f.facesettings.index.lab $f.facesettings.index.ent -side left\n"
,"pack $f.facesettings.index\n"
,"pack $f.facesettings -fill x -ipady 3\n"
,"global visoptions.fieldlinesfilename\n"
,"ttk::frame $f.filesettings -relief  groove -borderwidth 3\n"
,"ttk::frame $f.filesettings.title\n"
,"ttk::radiobutton $f.filesettings.title.choose -variable visoptions.fieldlinesstartarea \\\n"
,"-value file -text \"Startpoints from File\"\n"
,"pack $f.filesettings.title.choose -side left\n"
,"pack $f.filesettings.title\n"
,"ttk::frame $f.filesettings.sfn\n"
,"ttk::button $f.filesettings.sfn.bb -text \"Browse\" \\\n"
,"-command {\n"
,"set types {\n"
,"{ \"Netgen Fieldlines\" {.nef} }\n"
,"}\n"
,"set visoptions.fieldlinesfilename [tk_getOpenFile -filetypes $types -defaultextension \".nef\"]\n"
,"}\n"
,"ttk::entry $f.filesettings.sfn.fn -width 50 \\\n"
,"-textvariable visoptions.fieldlinesfilename\n"
,"pack $f.filesettings.sfn.bb $f.filesettings.sfn.fn -side left\n"
,"pack $f.filesettings.sfn\n"
,"pack $f.filesettings -fill x -ipady 3\n"
,"set g $w.nb.settings\n"
,"ttk::frame $g.linesettings -relief groove -borderwidth 3\n"
,"ttk::label $g.linesettings.title -text \"\\nLine Settings\\n\"\n"
,"ttk::frame $g.linesettings.length\n"
,"ttk::label $g.linesettings.length.lab -text \"rel. Length: \"\n"
,"ttk::spinbox $g.linesettings.length.sp -textvariable visoptions.fieldlineslength -width 6 -increment 0.1 -validate focus -validatecommand \"my_validatespinbox %W %P 5\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -from 0.00001 -to 10000\n"
,"grid $g.linesettings.length.lab $g.linesettings.length.sp -sticky nw\n"
,"ttk::frame $g.linesettings.maxpoints\n"
,"ttk::label $g.linesettings.maxpoints.lab -text \"max. Points: \"\n"
,"ttk::spinbox $g.linesettings.maxpoints.sp -textvariable visoptions.fieldlinesmaxpoints -width 6 -increment 1 -validate focus -validatecommand \"my_validatespinbox %W %P 0\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -from 0 -to 10000\n"
,"grid $g.linesettings.maxpoints.lab $g.linesettings.maxpoints.sp -sticky nw\n"
,"ttk::frame $g.linesettings.thick\n"
,"ttk::label $g.linesettings.thick.lab -text \"rel. Thickness: \"\n"
,"ttk::spinbox $g.linesettings.thick.sp -textvariable visoptions.fieldlinesthickness -width 6 -increment 0.001 -validate focus -validatecommand \"my_validatespinbox %W %P 6\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -from 1e-10 -to 0.5\n"
,"grid $g.linesettings.thick.lab $g.linesettings.thick.sp -stick nw\n"
,"pack $g.linesettings.title $g.linesettings.length $g.linesettings.maxpoints $g.linesettings.thick\n"
,"pack $g.linesettings -fill x -ipady 3\n"
,"global visoptions.fieldlinestolerance\n"
,"ttk::frame $g.odesettings -relief groove -borderwidth 3\n"
,"ttk::label $g.odesettings.title -text \"\\nODE Settings\\n\"\n"
,"ttk::frame $g.odesettings.tol\n"
,"ttk::label $g.odesettings.tol.lab -text \"rel. Thickness: \"\n"
,"ttk::spinbox $g.odesettings.tol.sp -textvariable visoptions.fieldlinestolerance -width 6 -increment 0.01 -validate focus -validatecommand \"my_validatespinbox %W %P 5\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -from 0.00001 -to 1\n"
,"grid $g.odesettings.tol.lab $g.odesettings.tol.sp -stick nw\n"
,"ttk::frame $g.odesettings.rktype\n"
,"ttk::label  $g.odesettings.rktype.lab -text \"RK-Type \"\n"
,"ttk::menubutton $g.odesettings.rktype.but -menu $g.odesettings.rktype.menu -text \"\" -width 25\n"
,"menu $g.odesettings.rktype.menu -tearoff 0\n"
,"$g.odesettings.rktype.menu add command -label \"Euler, order 1\" -command \"set visoptions.fieldlinesrktype \\\"euler\\\" ;Ng_Vis_Set parameters; redraw;$g.odesettings.rktype.but configure -text \\\"Euler,order 1\\\" \"\n"
,"$g.odesettings.rktype.menu add command -label \"Euler-Cauchy, order 2\" -command \"set visoptions.fieldlinesrktype \\\"eulercauchy\\\" ;Ng_Vis_Set parameters; redraw;$g.odesettings.rktype.but configure -text \\\"Euler-Cauchy,order 2\\\" \"\n"
,"$g.odesettings.rktype.menu add command -label \"Simpson, order 3\" -command \"set visoptions.fieldlinesrktype \\\"simpson\\\" ;Ng_Vis_Set parameters; redraw;$g.odesettings.rktype.but configure -text \\\"Simpson,order 3\\\"\"\n"
,"$g.odesettings.rktype.menu add command -label \"classical Runge-Kutta, order 4\" -command \"set visoptions.fieldlinesrktype \\\"crungekutta\\\" ;Ng_Vis_Set parameters; redraw; $g.odesettings.rktype.but configure -text \\\"classical Runge-Kutta,order 4\\\"\"\n"
,"$g.odesettings.rktype.menu invoke \"classical Runge-Kutta, order 4\"\n"
,"grid $g.odesettings.rktype.lab $g.odesettings.rktype.but -sticky nw\n"
,"pack $g.odesettings.title $g.odesettings.tol $g.odesettings.rktype\n"
,"pack $g.odesettings -fill x -ipady 3\n"
,"ttk::frame $w.bu\n"
,"pack $w.bu -fill x -ipady 3\n"
,"ttk::button $w.bu.calc -text \"Build Fieldlines\" -command {\n"
,"if { ${visoptions.fieldlinesvecfunction} == \"none\" } {\n"
,"bgerror \"Please select the vector function first!\"\n"
,"} {\n"
,"set visoptions.drawfieldlines 1\n"
,"Ng_Vis_Set parameters\n"
,"Ng_BuildFieldLines\n"
,"redraw\n"
,"}\n"
,"}\n"
,"ttk::button $w.bu.help -text \"Help\" -command {\n"
,"if {[winfo exists .fieldlines_help] == 1} {\n"
,"wm withdraw .fieldlines_help\n"
,"wm deiconify .fieldlines_help\n"
,"focus .fieldlines_help\n"
,"} {\n"
,"toplevel .fieldlines_help\n"
,"set f [frame .fieldlines_help.ht]\n"
,"ttk::scrollbar $f.vsb -orient vertical -command [list $f.t yview]\n"
,"text $f.t -yscrollcommand [list $f.vsb set]\n"
,"grid $f.t -row 0 -column 0 -sticky nsew\n"
,"grid $f.vsb -row 0 -column 1 -sticky nsew\n"
,"grid columnconfigure $f 0 -weight 1\n"
,"grid rowconfigure $f 0 -weight 1\n"
,"set text $f.t\n"
,"$text configure -setgrid true -wrap word\n"
,"$text tag configure bold -font *-*-bold-*-*-*-*\n"
,"$text insert end \\\n"
,"\"Draw menu\\n \\n\" bold\n"
,"$text insert end \\\n"
,"\"Enable Fieldlines\\n    To turn on and off the calculated fieldlines. (Has to be turned on to start the calculation)\\n\"\n"
,"$text insert end \\\n"
,"\"Num\\n    Number of fieldlines to calculate. (May not be used exactly.)\"\n"
,"$text insert end \\\n"
,"\"Field dependent density\\n    There will be more fieldline startpoints where the field is stronger\\n\\n\"\n"
,"$text insert end \\\n"
,"\"Animate periodic\\n    (for quasistationary fields) The fieldlines of the different phase angles are animated.\\n    ATTENTION: \\\"Fix Phase\\\" has to be turned off\\n\\n\"\n"
,"$text insert end \\\n"
,"\"Vector Function\\n    The function fixing the direction of the lines\\n\\n\"\n"
,"$text insert end \\\n"
,"\"Fix Phase\\n    (for quasistationary fields) Only calculate and draw fieldlines for one special phase angle.\\n\\n\"\n"
,"$text insert end \\\n"
,"\"Startpoints in Box\\n    Set the startpoints inside the box \\[Pmin1,Pmax1\\] x \\[Pmin2,Pmax2\\] x \\[Pmin3,Pmax3\\]\\n\"\n"
,"$text insert end \\\n"
,"\"    With the button \\\"Bounding Box\\\" the whole bounding box of the geometry is selected.\\n\\n\"\n"
,"$text insert end \\\n"
,"\"Startpoints on Face\\n    All startpoints will be set on one face. This face is selected by double-clicking with the mouse.\\n\\n\"\n"
,"$text insert end \\\n"
,"\"Startpoints from File\\n    The startpoint information will be read from the selected file.\\n    The entries in the file can be as follows:\\n\"\n"
,"$text insert end \\\n"
,"\"        point <x> <y> <z>\\n            set a (potential) startpoint\\n\"\n"
,"$text insert end \\\n"
,"\"        line <x1> <y1> <z1> <x2> <y2> <z2> <n>\\n            set n (potential) startpoints on the line from (x1,y1,z1) to (x2,y2,z2)\\n\"\n"
,"$text insert end \\\n"
,"\"        box <x1> <y1> <z1> <x2> <y2> <z2> <n>\\n            set n (potential) startpoints inside the box \\[x1,x2\\] x \\[y1,y2\\] x \\[z1,z2\\]\\n\"\n"
,"$text insert end \\\n"
,"\"    ATTENTION: These are potential startpoints.\\n               The total number of startpoints will be bounded by the \\\"Num\\\"-parameter.\\n \\n \\n \\n\"\n"
,"$text insert end \\\n"
,"\"Settings Menu\\n \\n\" bold\n"
,"$text insert end \\\n"
,"\"rel. Length\\n    The maximal length of a fieldline relative to the diameter of the geometry.\\n\\n\"\n"
,"$text insert end \\\n"
,"\"max. Points\\n    The maximum number of Runge-Kutta steps.\\n\\n\"\n"
,"$text insert end \\\n"
,"\"rel. Thickness\\n    The thickness of the fieldlines relative to the diameter of the geometry.\\n\\n\"\n"
,"$text insert end \\\n"
,"\"rel. Tolerance\\n    The tolerance for the step-length control of the Runge-Kutta method.\\n\\n\"\n"
,"$text insert end \\\n"
,"\"RK-Type\\n    Which Runge-Kutta scheme to use\\n \\n \\n \\n\"\n"
,"$text insert end \\\n"
,"\"Button \\\"Build Fieldlines\\\"\\n\" bold\n"
,"$text insert end \\\n"
,"\"    Build the fieldlines.\"\n"
,"$text configure -state disabled\n"
,"pack .fieldlines_help.ht -expand yes -fill both\n"
,"wm withdraw .fieldlines_help\n"
,"wm geom .fieldlines_help +300+200\n"
,"wm deiconify .fieldlines_help\n"
,"wm title .fieldlines_help \"Fieldlines Help\"\n"
,"focus .fieldlines_help\n"
,"}\n"
,"}\n"
,"ttk::button $w.bu.cancel -text \"Done\" -command \"destroy $w\"\n"
,"grid $w.bu.calc $w.bu.help $w.bu.cancel -sticky nw -padx 4\n"
,"grid anchor $w.bu center\n"
,"wm withdraw $w\n"
,"wm geom $w +200+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Fieldlines\"\n"
,"focus $w\n"
,"}\n"
,"global visoptions.fieldlinesstartface\n"
,"set f $w.nb.draw\n"
,"set visoptions.fieldlinesstartface [Ng_BCProp getactive]\n"
,"$f.facesettings.index.ent configure -text ${visoptions.fieldlinesstartface}\n"
,"}\n"
,"set visual_dialog_pop1 0\n"
,"set visual_dialog_pop2 0\n"
,"set visual_dialog_pop3 0\n"
,"set visual_dialog_pop4 0\n"
,"set visual_dialog_pop5 0\n"
,"set visual_dialog_pop6 0\n"
,"set visual_dialog_pop7 0\n"
,"proc visual_dialog { } {\n"
,"set w .visoptions_dlg\n"
,"global visual_dialog_pop1\n"
,"global visual_dialog_pop2\n"
,"global visual_dialog_pop3\n"
,"global visual_dialog_pop4\n"
,"global visual_dialog_pop5\n"
,"global visual_dialog_pop6\n"
,"global visual_dialog_pop7\n"
,"set visual_dialog_pop1 1\n"
,"set visual_dialog_pop2 1\n"
,"set visual_dialog_pop3 1\n"
,"set visual_dialog_pop4 1\n"
,"set visual_dialog_pop5 1\n"
,"set visual_dialog_pop6 1\n"
,"set visual_dialog_pop7 1\n"
,"if {[winfo exists .visoptions_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"ttk::frame $w.main\n"
,"pack $w.main -fill x\n"
,"set w $w.main\n"
,"ttk::frame $w.upperfr ;\n"
,"pack $w.upperfr -fill x;\n"
,"ttk::labelframe $w.upperfr.size -text \"Grid\" -relief groove -borderwidth 3\n"
,"ttk::entry $w.upperfr.size.ent -width 3 -textvariable visoptions.gridsize -validate focus -takefocus 0 -validatecommand \"popupcheckredraw visual_dialog_pop2;my_validate %W 0 200 %P 0\" \\\n"
,"-invalidcommand \"my_invalid %W;popupcheckredraw visual_dialog_pop2\"\n"
,"ttk::scale $w.upperfr.size.sc -orient horizontal -length 100 -from 1 -to 200 -variable visoptions.gridsize\\\n"
,"-command \"roundscale $w.upperfr.size.sc 0;popupcheckredraw visual_dialog_pop2\"\n"
,"ttk::labelframe $w.upperfr.offsets -text \"x / y offsets\" -relief groove -borderwidth 3\n"
,"ttk::label $w.upperfr.offsets.xlab -text \"x\"\n"
,"ttk::label $w.upperfr.offsets.ylab -text \"y\"\n"
,"ttk::scale $w.upperfr.offsets.xoffset -orient horizontal -length 100 -from 0 -to 1 -variable visoptions.xoffset \\\n"
,"-command \"roundscale $w.upperfr.offsets.xoffset 2; popupcheckredraw visual_dialog_pop3\"\n"
,"ttk::scale $w.upperfr.offsets.yoffset -orient horizontal -length 100 -from 0 -to 1 -variable visoptions.yoffset \\\n"
,"-command \"roundscale $w.upperfr.offsets.yoffset 2; popupcheckredraw visual_dialog_pop4\"\n"
,"ttk::entry $w.upperfr.offsets.entx -width 4 -textvariable visoptions.xoffset -validate focus -takefocus 0 \\\n"
,"-validatecommand \"popupcheckredraw visual_dialog_pop3;my_validate %W 0 1 %P 2\" \\\n"
,"-invalidcommand \"my_invalid %W;popupcheckredraw visual_dialog_pop3\"\n"
,"ttk::entry $w.upperfr.offsets.enty -width 4 -textvariable visoptions.yoffset -validate focus -takefocus 0 \\\n"
,"-validatecommand \"popupcheckredraw visual_dialog_pop4;my_validate %W 0 1 %P 2\" \\\n"
,"-invalidcommand \"my_invalid %W;popupcheckredraw visual_dialog_pop4\"\n"
,"pack $w.upperfr.size.sc $w.upperfr.size.ent -padx 4  -pady 12 -side left\n"
,"grid $w.upperfr.offsets.xoffset $w.upperfr.offsets.entx $w.upperfr.offsets.xlab -sticky nw -padx 4\n"
,"grid $w.upperfr.offsets.yoffset $w.upperfr.offsets.enty $w.upperfr.offsets.ylab -sticky nw -padx 4\n"
,"grid $w.upperfr.size $w.upperfr.offsets -sticky nw -pady 7 -padx 10\n"
,"grid anchor $w.upperfr center\n"
,"ttk::labelframe $w.deform -relief groove -borderwidth 3 -text \"Deformation settings\"\n"
,"ttk::checkbutton $w.deform.cb -text \"Deformation\" \\\n"
,"-variable visoptions.deformation \\\n"
,"-command { Ng_Vis_Set parameters; redraw }\n"
,"ttk::label $w.deform.l -text \"Scale: \"\n"
,"ttk::spinbox $w.deform.sc1 -from 0 -to 1e99 -textvariable visoptions.scaledeform1 -width 5 \\\n"
,"-command { Ng_Vis_Set parameters; redraw } \\\n"
,"-validate focusout -validatecommand { Ng_Vis_Set parameters; redraw; string is double %P } \\\n"
,"-invalidcommand { puts \"invalid value, %P %s\"; set visoptions.scaledeform1 1; }\n"
,"ttk::scale $w.deform.sc2 -orient horizontal -length 100 -from 0 -to 1 \\\n"
,"-variable  visoptions.scaledeform2 \\\n"
,"-command { popupcheckredraw visual_dialog_pop5 }\n"
,"pack $w.deform -fill x -ipady 2 -pady 4 -ipady 3\n"
,"grid $w.deform.cb $w.deform.l $w.deform.sc1 $w.deform.sc2 -sticky nw -padx 4;\n"
,"grid anchor $w.deform center\n"
,"grid columnconfigure $w.deform 0 -pad 20\n"
,"grid columnconfigure $w.deform 2 -pad 20\n"
,"ttk::labelframe $w.as -relief groove -borderwidth 3 -text \"Scaling options\"\n"
,"ttk::checkbutton $w.as.autoscale -text \"Autoscale\" \\\n"
,"-variable visoptions.autoscale \\\n"
,"-command { Ng_Vis_Set parameters; redraw }\n"
,"ttk::label $w.as.lmin -text \"Min-value\"\n"
,"ttk::spinbox $w.as.smin -textvariable visoptions.mminval -width 5 -validate focus \\\n"
,"-validatecommand \"my_validatespinbox %W %P 10\" \\\n"
,"-command \"Ng_Vis_Set parameters; redraw;\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W\" -from -1e10 -to 1e10 -increment 0.001\n"
,"ttk::label $w.as.lmax -text \"Max-value\"\n"
,"ttk::spinbox $w.as.smax -textvariable visoptions.mmaxval -width 5 -validate focus \\\n"
,"-validatecommand \"Ng_Vis_Set parameters; redraw;my_validatespinbox %W %P 10\" \\\n"
,"-command \"Ng_Vis_Set parameters; redraw;\" \\\n"
,"-invalidcommand \"my_invalidspinbox %W;Ng_Vis_Set parameters; redraw\" -from -1e10 -to 1e10 -increment 0.001\n"
,"pack $w.as -fill x -pady 5 -ipady 3\n"
,"grid $w.as.autoscale $w.as.lmin $w.as.smin $w.as.lmax $w.as.smax -sticky nw -padx 4\n"
,"grid columnconfigure $w.as 0 -pad 20\n"
,"grid columnconfigure $w.as 2 -pad 20\n"
,"grid anchor $w.as center\n"
,"ttk::frame $w.iso; \n"
,"pack $w.iso -anchor center;\n"
,"ttk::labelframe $w.iso.cb -relief groove -borderwidth 3 -text \"Iso lines / surfaces\"\n"
,"pack $w.iso.cb -side left -pady 7 -fill y\n"
,"ttk::checkbutton $w.iso.cb.isolines -text \"Iso-lines\" \\\n"
,"-variable visoptions.isolines \\\n"
,"-command { Ng_Vis_Set parameters; redraw }\n"
,"ttk::checkbutton $w.iso.cb.isosurf -text \"Iso-Surface\" \\\n"
,"-variable visoptions.isosurf \\\n"
,"-command { Ng_Vis_Set parameters; redraw }\n"
,"ttk::label $w.iso.cb.numisol -text \"amount\"\n"
,"ttk::scale $w.iso.cb.numiso -orient horizontal -length 100 -from 2 -to 50 \\\n"
,"-variable  visoptions.numiso \\\n"
,"-command \"roundscale $w.iso.cb.numiso 0;popupcheckredraw visual_dialog_pop6\"\n"
,"ttk::entry $w.iso.cb.entry -textvariable visoptions.numiso -width 3 \\\n"
,"-validate focus -validatecommand \"popupcheckredraw visual_dialog_pop6;\\\n"
,"my_validate %W [$w.iso.cb.numiso cget -from] [$w.iso.cb.numiso cget -to] %P 0\" \\\n"
,"-invalidcommand \"my_invalid %W;popupcheckredraw visual_dialog_pop6\"\n"
,"grid $w.iso.cb.isolines $w.iso.cb.numisol $w.iso.cb.entry -sticky nw -padx 4\n"
,"grid $w.iso.cb.isosurf  -sticky nw -padx 4\n"
,"grid $w.iso.cb.numiso  -sticky nw -padx 4 -columnspan 2 -column 1 -row 1\n"
,"ttk::labelframe $w.iso.subdiv -text \"Subdivision\" -relief groove -borderwidth 3\n"
,"ttk::radiobutton $w.iso.subdiv.zero -text \"0\" -variable visoptions.subdivisions -value 0 \\\n"
,"-command {\n"
,"Ng_Vis_Set parameters; redraw;\n"
,"}\n"
,"ttk::radiobutton $w.iso.subdiv.one -text \"1\" -variable visoptions.subdivisions -value 1 \\\n"
,"-command {\n"
,"Ng_Vis_Set parameters; redraw;\n"
,"}\n"
,"ttk::radiobutton $w.iso.subdiv.two -text \"2\" -variable visoptions.subdivisions -value 2 \\\n"
,"-command {\n"
,"Ng_Vis_Set parameters; redraw;\n"
,"}\n"
,"ttk::radiobutton $w.iso.subdiv.three -text \"3\" -variable visoptions.subdivisions -value 3 \\\n"
,"-command {\n"
,"Ng_Vis_Set parameters; redraw;\n"
,"}\n"
,"ttk::radiobutton $w.iso.subdiv.four -text \"4\" -variable visoptions.subdivisions -value 4 \\\n"
,"-command {\n"
,"Ng_Vis_Set parameters; redraw;\n"
,"}\n"
,"ttk::radiobutton $w.iso.subdiv.five -text \"5\" -variable visoptions.subdivisions -value 5 \\\n"
,"-command {\n"
,"Ng_Vis_Set parameters; redraw;\n"
,"}\n"
,"ttk::label $w.iso.subdiv.text  -text \"subdivision\"\n"
,"pack $w.iso.subdiv -side right -fill y -padx 4 -pady 7\n"
,"grid $w.iso.subdiv.zero $w.iso.subdiv.one $w.iso.subdiv.two $w.iso.subdiv.three $w.iso.subdiv.four $w.iso.subdiv.five\n"
,"grid anchor $w.iso.subdiv center\n"
,"ttk::labelframe $w.redraw -relief groove -borderwidth 3 -text \"Auto-redraw\"\n"
,"ttk::checkbutton $w.redraw.auto -text \"Auto-redraw after (sec)\" \\\n"
,"-variable visoptions.autoredraw\n"
,"ttk::spinbox $w.redraw.val -textvariable visoptions.autoredrawtime -from 0 -to 100 -width 3\n"
,"pack $w.redraw -fill x -ipady 3 -pady 7\n"
,"grid $w.redraw.auto  $w.redraw.val -sticky nw\n"
,"grid anchor $w.redraw center\n"
,"ttk::labelframe $w.lowerframe -text \"Additional viewing options\" -relief groove -borderwidth 3\n"
,"pack $w.lowerframe -fill x\n"
,"set w $w.lowerframe\n"
,"ttk::frame $w.f1\n"
,"set f [ttk::frame $w.f1.clipsol]\n"
,"pack $f -anchor e\n"
,"menu $f.m\n"
,"ttk::menubutton $f.b -menu $f.m -width 12\n"
,"ttk::label $f.l -text \"Clipping Plane Sol: \"\n"
,"global visoptions.clipsolution\n"
,"set clipsollabs(none) \"None\"\n"
,"set clipsollabs(scal) \"Scalar Function\"\n"
,"set clipsollabs(vec) \"Vector Function\"\n"
,"foreach i { none scal vec } {\n"
,"set textval $clipsollabs($i)\n"
,"$f.m add command -label \"$textval\" -command \\\n"
,"\"$f.b configure -text \\\"$textval\\\" ; set visoptions.clipsolution $i ; Ng_Vis_Set parameters ; redraw \"\n"
,"}\n"
,"pack $f.b $f.l -side right\n"
,"$f.m invoke $clipsollabs(${visoptions.clipsolution})\n"
,"set f [ttk::frame $w.f1.scalfun]\n"
,"pack $f -anchor e\n"
,"menu $f.m\n"
,"ttk::menubutton $f.b -menu $f.m -width 12\n"
,"ttk::label $f.l -text \"Scalar Function: \"\n"
,"set scalentries [list none None]\n"
,"for { set i 1 } { $i <= [Ng_Vis_Field getnfieldnames] } { incr i } {\n"
,"set fname [Ng_Vis_Field getfieldname $i]\n"
,"set fcomp [Ng_Vis_Field getfieldcomponents $i]\n"
,"if { $fcomp == 1 } {\n"
,"lappend scalentries $fname:1 $fname\n"
,"} {\n"
,"for { set j 1 } { $j <= $fcomp } { incr j } {\n"
,"lappend scalentries $fname:$j \"$fname ($j)\"\n"
,"}\n"
,"lappend scalentries $fname:0 \"func ($fname)\"\n"
,"}\n"
,"}\n"
,"global visoptions.scalfunction\n"
,"foreach { name textval } $scalentries {\n"
,"$f.m add command -label \"$textval\" -command \\\n"
,"\"$f.b configure -text \\\"$textval\\\" ; set visoptions.scalfunction $name ; Ng_Vis_Set parameters ; redraw ; \"\n"
,"}\n"
,"pack $f.b $f.l -side right\n"
,"foreach { name textval } $scalentries {\n"
,"if { ${visoptions.scalfunction} == $name } {\n"
,"$f.m invoke $textval\n"
,"}\n"
,"}\n"
,"set f [ttk::frame $w.f1.vecfun]\n"
,"pack $f -anchor e\n"
,"menu $f.m\n"
,"ttk::menubutton $f.b -menu $f.m -width 12\n"
,"ttk::label $f.l -text \"Vector Function: \"\n"
,"set vecentries [list none None]\n"
,"for { set i 1 } { $i <= [Ng_Vis_Field getnfieldnames] } { incr i } {\n"
,"set fname [Ng_Vis_Field getfieldname $i]\n"
,"set fcomp [Ng_Vis_Field getfieldcomponents $i]\n"
,"set iscomplex [Ng_Vis_Field iscomplex $i]\n"
,"set sdim [Ng_Vis_Field getdimension]\n"
,"if { $iscomplex == 1 } { set fcomp [expr $fcomp / 2] }\n"
,"if { ($fcomp == $sdim) || ($fcomp == 3) } {\n"
,"lappend vecentries $fname $fname\n"
,"}\n"
,"}\n"
,"global visoptions.vecfunction\n"
,"foreach { name textval } $vecentries {\n"
,"$f.m add command -label \"$textval\" -command \\\n"
,"\"$f.b configure -text \\\"$textval\\\" ; set visoptions.vecfunction $name ; Ng_Vis_Set parameters ; redraw ; \"\n"
,"}\n"
,"pack $f.b $f.l -side right\n"
,"foreach { name textval } $vecentries {\n"
,"if { ${visoptions.vecfunction} == $name } {\n"
,"$f.m invoke $textval\n"
,"}\n"
,"}\n"
,"set f [ttk::frame $w.f1.evaluate]\n"
,"pack $f -anchor e\n"
,"menu $f.m\n"
,"ttk::menubutton $f.b -menu $f.m -width 12\n"
,"ttk::label $f.l -text \"Evaluate: \"\n"
,"global visoptions.evaluate\n"
,"set evallabs(abs) \"| |\"\n"
,"set evallabs(abstens) \"|tensor|\"\n"
,"set evallabs(mises) \"Mises\"\n"
,"set evallabs(main) \"Main\"\n"
,"foreach i { abs abstens mises main } {\n"
,"set textval $evallabs($i)\n"
,"$f.m add command -label \"$textval\" -command \\\n"
,"\"$f.b configure -text \\\"$textval\\\" ; set visoptions.evaluate $i ; \"\n"
,"}\n"
,"pack $f.b $f.l -side right\n"
,"$f.m invoke $evallabs(${visoptions.evaluate})\n"
,"pack [ttk::frame $w.f1.multidim] -fill x\n"
,"set f [ttk::frame $w.f1.multidim.f]\n"
,"pack $f -anchor e\n"
,"ttk::label $f.l1 -text \"multidim-component: \"\n"
,"ttk::spinbox $f.sb1 -from 0 -to 1e99 -textvariable visoptions.multidimcomponent -width 3 \\\n"
,"-command { Ng_Vis_Set parameters; redraw }\n"
,"pack $f.l1 $f.sb1 -side left\n"
,"ttk::frame $w.fcb\n"
,"grid $w.f1 $w.fcb -sticky nw -padx 7 -ipady 3\n"
,"grid anchor $w center\n"
,"ttk::frame $w.fcb.cb\n"
,"pack $w.fcb.cb\n"
,"ttk::checkbutton $w.fcb.cb.showsurfsolution -text \"Draw Surface Vectors\" \\\n"
,"-variable visoptions.showsurfacesolution \\\n"
,"-command { Ng_Vis_Set parameters; redraw }\n"
,"ttk::checkbutton $w.fcb.cb.showcurves -text \"Show Curves\" \\\n"
,"-variable visoptions.drawpointcurves \\\n"
,"-command { Ng_Vis_Set parameters; redraw }\n"
,"ttk::checkbutton $w.fcb.cb.imaginary -text \"Imaginary Part\" \\\n"
,"-variable visoptions.imaginary \\\n"
,"-command { Ng_Vis_Set parameters; redraw }\n"
,"ttk::checkbutton $w.fcb.cb.logscale -text \"Log Scale\" \\\n"
,"-variable visoptions.logscale \\\n"
,"-command { Ng_Vis_Set parameters; redraw }\n"
,"ttk::checkbutton $w.fcb.cb.invcolor -text \"Inverse Color\" \\\n"
,"-variable visoptions.invcolor \\\n"
,"-command { Ng_Vis_Set parametersrange; redraw }\n"
,"ttk::frame $w.fcb.cb.texframe\n"
,"ttk::checkbutton $w.fcb.cb.texframe.usetexture -text \"Use Textures (\" \\\n"
,"-variable visoptions.usetexture \\\n"
,"-command { Ng_Vis_Set parameters; redraw }\n"
,"ttk::checkbutton $w.fcb.cb.texframe.lintexture -text \"Linear )\" \\\n"
,"-variable visoptions.lineartexture \\\n"
,"-command { Ng_Vis_Set parametersrange; redraw }\n"
,"ttk::checkbutton $w.fcb.cb.lineartexture -text \"Use Linear Texture\" \\\n"
,"-variable visoptions.lineartexture \\\n"
,"-command { Ng_Vis_Set parameters; redraw }\n"
,"scale $w.numcols -orient horizontal -length 100 -from 0 -to 50 \\\n"
,"-resolution 1   \\\n"
,"-variable  visoptions.numtexturecols \\\n"
,"-command { popupcheckredraw visual_dialog_pop1 }\n"
,"ttk::checkbutton $w.fcb.cb.showclipsolution -text \"Draw Clipping Plane Solution\" \\\n"
,"-variable visoptions.showclipsolution \\\n"
,"-command { Ng_Vis_Set parameters; redraw }\n"
,"ttk::checkbutton $w.fcb.cb.redrawperiodic -text \"Animate periodic\" \\\n"
,"-variable visoptions.redrawperiodic \\\n"
,"-command {\n"
,"redrawperiodic\n"
,"Ng_Vis_Set parameters;\n"
,"redraw\n"
,"}\n"
,"grid $w.fcb.cb.showsurfsolution -sticky nw\n"
,"grid $w.fcb.cb.showcurves -sticky nw\n"
,"grid $w.fcb.cb.imaginary -sticky nw\n"
,"grid $w.fcb.cb.logscale -sticky nw\n"
,"grid $w.fcb.cb.texframe -sticky nw\n"
,"grid $w.fcb.cb.invcolor -sticky nw\n"
,"grid $w.fcb.cb.redrawperiodic -sticky nw\n"
,"pack $w.fcb.cb.texframe.usetexture $w.fcb.cb.texframe.lintexture -side left -expand yes\n"
,"set w .visoptions_dlg.main\n"
,"ttk::frame $w.bu;\n"
,"pack $w.bu  -pady 5 -padx 4\n"
,"ttk::button $w.bu.showsol -text \"Show Solution\" -command {\n"
,"set selectvisual solution\n"
,"Ng_SetVisParameters\n"
,"redraw\n"
,"}\n"
,"ttk::button $w.bu.clipping -text \"Clipping\" -command {\n"
,"clippingdialog;\n"
,"}\n"
,"ttk::button $w.bu.fieldlines -text \"Fieldlines\" -command {\n"
,"fieldlinesdialog;\n"
,"}\n"
,"ttk::button $w.bu.lineplot -text \"2D Lineplot\" -command {\n"
,"lineplotdialog;\n"
,"}\n"
,"ttk::button $w.bu.done -text \"Close\" -command {\n"
,"destroy .visoptions_dlg\n"
,"}\n"
,"pack $w.bu.showsol $w.bu.clipping $w.bu.fieldlines $w.bu.lineplot $w.bu.done -side left -expand yes\n"
,"set w .visoptions_dlg\n"
,"wm withdraw $w\n"
,"wm geom $w +100+100\n"
,"wm deiconify $w\n"
,"wm title $w \"Visualization\"\n"
,"}\n"
,"}\n"
,"}\n"
,"catch { set sockets.serverport 0\n"
,"set sockets.serverhost \"localhost\"\n"
,"set sockets.serverlistbox 0\n"
,"set sockets.queuelistbox 0\n"
,"set sockets.currentjoblistbox 0\n"
,"set sockets.answerlistbox 0\n"
,"set sockets.myidlabel -1\n"
,"proc updateserverlist { } {\n"
,"global sockets.serverlistbox\n"
,"set retval [Ng_Socket getserverlist]\n"
,"${sockets.serverlistbox} delete 0 end\n"
,"for {set i 0} {$i < [llength $retval]} {incr i 3} {\n"
,"${sockets.serverlistbox} insert end \\\n"
,"[format \"%-16s   %6i   %6i\" [lindex $retval $i] [lindex $retval [expr $i+1]] [lindex $retval [expr $i+2]]]\n"
,"}\n"
,"}\n"
,"proc clientsocketdialog { } {\n"
,"set w .clientsock_dlg\n"
,"if {[winfo exists .clientsock_dlg] == 1} {\n"
,"wm withdraw $w\n"
,"wm deiconify $w\n"
,"focus $w\n"
,"} {\n"
,"toplevel $w\n"
,"global sockets.serverhost\n"
,"global sockets.serverport\n"
,"ttk::frame $w.general\n"
,"ttk::frame $w.host\n"
,"ttk::label $w.host.lab -text \"Serverhost: \"\n"
,"ttk::entry $w.host.name -width 30 -textvariable sockets.serverhost\n"
,"pack $w.host.lab $w.host.name -side left\n"
,"pack $w.host\n"
,"ttk::frame $w.ports\n"
,"ttk::label $w.ports.lab1 -text \"Serverport: \"\n"
,"ttk::entry $w.ports.statport -width 6 -textvariable sockets.serverport\n"
,"pack $w.ports.lab1 $w.ports.statport -side left\n"
,"pack $w.ports\n"
,"ttk::frame $w.listboxes\n"
,"ttk::frame $w.listboxes.choosesocketframe\n"
,"tixScrolledListBox $w.listboxes.choosesocketframe.choosesocket -scrollbar auto\n"
,"global sockets.serverlistbox\n"
,"set sockets.serverlistbox [$w.listboxes.choosesocketframe.choosesocket subwidget listbox]\n"
,"${sockets.serverlistbox} configure -width 35\n"
,"${sockets.serverlistbox} configure -selectmode browse\n"
,"${sockets.serverlistbox} configure -exportselection false\n"
,"ttk::button $w.addserver -text \"Add ServerSocket\" -command {\n"
,"Ng_Socket addserver ${sockets.serverport} ${sockets.serverhost}\n"
,"updateserverlist\n"
,"}\n"
,"pack $w.addserver\n"
,"ttk::label $w.linefeed -text \"\\n\"\n"
,"pack $w.linefeed\n"
,"ttk::frame $w.clientidframe\n"
,"ttk::label $w.clientidframe.lab -text \"Client ID: \";\n"
,"global sockets.myidlabel\n"
,"ttk::entry $w.clientidframe.val -width 5 -textvariable sockets.myidlabel\n"
,"ttk::button $w.clientidframe.but -text \"Set\" -command {\n"
,"set opsel [${sockets.serverlistbox} curselection]\n"
,"if {[llength $opsel] > 0} {\n"
,"set opserver [lindex $opsel 0]\n"
,"Ng_Socket setid $opserver ${sockets.myidlabel}\n"
,"updateserverlist\n"
,"}\n"
,"}\n"
,"pack $w.clientidframe.lab $w.clientidframe.val $w.clientidframe.but -side left\n"
,"pack $w.clientidframe\n"
,"ttk::label $w.listboxes.choosesocketframe.chooselab -text [format \"\\n\\n%-16s    %6s  %6s                       \" Host Socket MyID ]\n"
,"pack $w.listboxes.choosesocketframe.chooselab\n"
,"pack $w.listboxes.choosesocketframe.choosesocket\n"
,"ttk::frame $w.listboxes.choosesocketframe.serverbuttons\n"
,"ttk::button $w.listboxes.choosesocketframe.serverbuttons.save -text \"Save\" -command {\n"
,"Ng_Socket saveserverlist\n"
,"}\n"
,"global sockets.serverlist\n"
,"Ng_Socket loadserverlist\n"
,"updateserverlist\n"
,"ttk::button $w.listboxes.choosesocketframe.serverbuttons.delete -text \"Delete\" -command {\n"
,"set opsel [${sockets.serverlistbox} curselection]\n"
,"if {[llength $opsel] > 0} {\n"
,"Ng_Socket deletesocket [lindex $opsel 0]\n"
,"updateserverlist\n"
,"}\n"
,"}\n"
,"pack $w.listboxes.choosesocketframe.serverbuttons.save $w.listboxes.choosesocketframe.serverbuttons.delete -side left\n"
,"pack $w.listboxes.choosesocketframe.serverbuttons\n"
,"ttk::frame $w.listboxes.statusframe\n"
,"ttk::label $w.listboxes.statusframe.statuslabel1 -text \"\\n\\njobqueue\"\n"
,"tixScrolledListBox $w.listboxes.statusframe.queuestatus -scrollbar auto\n"
,"ttk::label $w.listboxes.statusframe.statuslabel2 -text \"\\ncurrent job\"\n"
,"tixScrolledListBox $w.listboxes.statusframe.currentjobstatus -scrollbar auto\n"
,"ttk::label $w.listboxes.statusframe.statuslabel3 -text \"\\nanswers\"\n"
,"tixScrolledListBox $w.listboxes.statusframe.answers -scrollbar auto\n"
,"global sockets.queuelistbox\n"
,"global sockets.currentjoblistbox\n"
,"global sockets.answerlistbox\n"
,"set sockets.queuelistbox [$w.listboxes.statusframe.queuestatus subwidget listbox]\n"
,"set sockets.currentjoblistbox [$w.listboxes.statusframe.currentjobstatus subwidget listbox]\n"
,"set sockets.answerlistbox [$w.listboxes.statusframe.answers subwidget listbox]\n"
,"${sockets.queuelistbox} configure -width 50\n"
,"${sockets.queuelistbox} configure -height 5\n"
,"${sockets.queuelistbox} configure -selectmode browse\n"
,"${sockets.queuelistbox} configure -exportselection false\n"
,"${sockets.currentjoblistbox} configure -width 50\n"
,"${sockets.currentjoblistbox} configure -height 1\n"
,"${sockets.currentjoblistbox} configure -selectmode browse\n"
,"${sockets.currentjoblistbox} configure -exportselection false\n"
,"${sockets.answerlistbox} configure -width 50\n"
,"${sockets.answerlistbox} configure -height 5\n"
,"${sockets.answerlistbox} configure -selectmode browse\n"
,"${sockets.answerlistbox} configure -exportselection false\n"
,"ttk::button $w.listboxes.statusframe.updatebutton -text \"Update\" -command {\n"
,"set opsel [${sockets.serverlistbox} curselection]\n"
,"if {[llength $opsel] > 0} {\n"
,"set opserver [lindex $opsel 0]\n"
,"set retval [Ng_Socket sendqueuestatus $opserver]\n"
,"${sockets.queuelistbox} delete 0 end\n"
,"if {[lindex $retval 0] > 0} {\n"
,"${sockets.queuelistbox} insert end [format \"Blocked for user %i\" [lindex $retval 0]]\n"
,"} {\n"
,"${sockets.queuelistbox} insert end \"Not blocked\"\n"
,"}\n"
,"for {set i 2} {$i < [expr 2*[lindex $retval 1]+2]} {incr i 2} {\n"
,"${sockets.queuelistbox} insert end [format \"client %i, command %s\" [lindex $retval $i] [lindex $retval [expr $i+1]]]\n"
,"}\n"
,"${sockets.answerlistbox} delete 0 end\n"
,"for {set i [expr 2*[lindex $retval 1]+3]} {$i < [llength $retval]} {incr i 2} {\n"
,"${sockets.answerlistbox} insert end [format \"client %i, command %s\" [lindex $retval $i] [lindex $retval [expr $i+1]]]\n"
,"}\n"
,"${sockets.currentjoblistbox} delete 0 end\n"
,"set retval [Ng_Socket sendjobstatus $opserver]\n"
,"if {[lindex $retval 0] != 0} {\n"
,"${sockets.currentjoblistbox} insert end [format \"client %i, command %s: %s\" [lindex $retval 0] [lindex $retval 1] [lrange $retval 2 end]]\n"
,"}\n"
,"}\n"
,"}\n"
,"pack $w.listboxes.statusframe.statuslabel1 $w.listboxes.statusframe.queuestatus \\\n"
,"$w.listboxes.statusframe.statuslabel2 $w.listboxes.statusframe.currentjobstatus \\\n"
,"$w.listboxes.statusframe.statuslabel3 $w.listboxes.statusframe.answers \\\n"
,"$w.listboxes.statusframe.updatebutton\n"
,"pack $w.listboxes.choosesocketframe $w.listboxes.statusframe -side left\n"
,"pack $w.listboxes\n"
,"ttk::label $w.lab1 -text \"\\n\"\n"
,"pack $w.lab1\n"
,"ttk::frame $w.buttons1\n"
,"ttk::frame $w.buttons2\n"
,"ttk::button $w.buttons1.getid -text \"Get ID\" -command {\n"
,"set opsel [${sockets.serverlistbox} curselection]\n"
,"if {[llength $opsel] > 0} {\n"
,"set opserver [lindex $opsel 0]\n"
,"set retval [Ng_Socket getid $opserver]\n"
,"updateserverlist\n"
,"set sockets.myidlabel $retval\n"
,"}\n"
,"}\n"
,"ttk::button $w.buttons1.killjob -text \"Kill Cur. Job\" -command {\n"
,"set opsel [${sockets.serverlistbox} curselection]\n"
,"if {[llength $opsel] > 0} {\n"
,"set opserver [lindex $opsel 0]\n"
,"Ng_Socket killcurrentjob $opserver\n"
,"}\n"
,"}\n"
,"ttk::button $w.buttons2.sendmesh -text \"Send Mesh\" -command {\n"
,"set opsel [${sockets.serverlistbox} curselection]\n"
,"if {[llength $opsel] > 0} {\n"
,"set opserver [lindex $opsel 0]\n"
,"set retval [Ng_Socket sendmesh $opserver]\n"
,"set sockets.meshsent 1\n"
,"}\n"
,"}\n"
,"ttk::button $w.buttons2.sendpde -text \"Send PDE\" -command {\n"
,"set opsel [${sockets.serverlistbox} curselection]\n"
,"if {[llength $opsel] > 0} {\n"
,"set opserver [lindex $opsel 0]\n"
,"set retval [NGS_Socket sendpdefile $opserver]\n"
,"}\n"
,"}\n"
,"ttk::button $w.buttons2.solvepde -text \"Solve PDE\" -command {\n"
,"set opsel [${sockets.serverlistbox} curselection]\n"
,"if {[llength $opsel] > 0} {\n"
,"set opserver [lindex $opsel 0]\n"
,"set retval [NGS_Socket solvepde $opserver]\n"
,"}\n"
,"}\n"
,"ttk::button $w.buttons2.writesol -text \"Write Solution\" -command {\n"
,"set opsel [${sockets.serverlistbox} curselection]\n"
,"if {[llength $opsel] > 0} {\n"
,"set opserver [lindex $opsel 0]\n"
,"set retval [NGS_Socket writesolution $opserver]\n"
,"}\n"
,"}\n"
,"ttk::button $w.buttons2.sendsol -text \"Receive Solution\" -command {\n"
,"set opsel [${sockets.serverlistbox} curselection]\n"
,"if {[llength $opsel] > 0} {\n"
,"set opserver [lindex $opsel 0]\n"
,"set retval [NGS_Socket sendsolution $opserver]\n"
,"}\n"
,"}\n"
,"ttk::button $w.buttons1.blockserver -text \"Block Server\" -command {\n"
,"set opsel [${sockets.serverlistbox} curselection]\n"
,"if {[llength $opsel] > 0} {\n"
,"set opserver [lindex $opsel 0]\n"
,"set retval [Ng_Socket blockserver $opserver]\n"
,"}\n"
,"}\n"
,"ttk::button $w.buttons1.unblockserver -text \"UnBlock Server\" -command {\n"
,"set opsel [${sockets.serverlistbox} curselection]\n"
,"if {[llength $opsel] > 0} {\n"
,"set opserver [lindex $opsel 0]\n"
,"set retval [Ng_Socket unblockserver $opserver]\n"
,"}\n"
,"}\n"
,"pack $w.buttons1.getid $w.buttons1.blockserver $w.buttons1.unblockserver $w.buttons1.killjob -side left\n"
,"pack $w.buttons2.sendmesh $w.buttons2.sendpde $w.buttons2.solvepde $w.buttons2.writesol $w.buttons2.sendsol -side left\n"
,"pack $w.buttons1 $w.buttons2\n"
,"wm withdraw $w\n"
,"wm geom $w +200+200\n"
,"wm deiconify $w\n"
,"wm title $w \"Client Socket\"\n"
,"focus .options_dlg\n"
,"}\n"
,"}\n"
,"}\n"
,"catch { source ${ngdir}/acis.tcl }\n"
,"set zugstange 0\n"
,"catch { source ${ngdir}/trafo/menu.tcl }\n"
,"setgranularity ${meshoptions.fineness}\n"
,"Ng_SetMeshingParameters\n"
,"Ng_SetVisParameters\n"
,"Ng_SetDebugParameters\n"
,"Ng_STLDoctor\n"
,"Ng_GeometryOptions set\n"
,"if { $hasocc == \"yes\" } {\n"
,"Ng_SetOCCVisParameters\n"
,"}\n"
,"if { $batchmode != \"defined\" } {\n"
,"catch {\n"
,"wm protocol . WM_DELETE_WINDOW { .ngmenu.file invoke \"Quit\" }\n"
,"wm deiconify .\n"
,"}\n"
,"}\n"
,"set trafoapp 0\n"
,"catch { source ${ngdir}/trafoapp/trafoapp.tcl }\n"
,"set geofilename [Ng_GetCommandLineParameter geofile]\n"
,"if { $geofilename != \"undefined\" &&\n"
,"[info exists trafo] == 0 && $zugstange == 0} {\n"
,"if { [ catch { Ng_LoadGeometry $geofilename } errstring] == 0 } {\n"
,"if { $batchmode != \"defined\" } {\n"
,"AddRecentFile $geofilename\n"
,"}\n"
,"Ng_ParseGeometry\n"
,"if { $batchmode != \"defined\" } {\n"
,"set selectvisual geometry\n"
,"Ng_SetVisParameters\n"
,"redraw\n"
,"wm title . [concat \"$progname - \" $geofilename]\n"
,"}\n"
,"set dirname [file dirname $geofilename]\n"
,"set basefilename [file tail [file rootname $geofilename]]\n"
,"} {\n"
,"puts \"Problem with input file:\"\n"
,"puts \"$errstring\"\n"
,"}\n"
,"}\n"
,"set cnt 0\n"
,"foreach { gran } { verycoarse coarse moderate fine veryfine } {\n"
,"set cnt [expr $cnt + 1]\n"
,"if { [Ng_GetCommandLineParameter $gran] == \"defined\" } {\n"
,"set meshoptions.fineness $cnt\n"
,"setgranularity ${meshoptions.fineness}\n"
,"}\n"
,"}\n"
,"set meshfilename [Ng_GetCommandLineParameter meshfile]\n"
,"if { $meshfilename == \"undefined\" } {\n"
,"set meshfilename out.mesh\n"
,"}\n"
,"set meshfiletype [Ng_GetCommandLineParameter meshfiletype]\n"
,"if { $meshfiletype == \"undefined\" } {\n"
,"set meshfiletype netgen\n"
,"}\n"
,"set inputmeshfilename [Ng_GetCommandLineParameter inputmeshfile]\n"
,"set mergemeshfilename [Ng_GetCommandLineParameter mergefile]\n"
,"set meshsizefilename [Ng_GetCommandLineParameter meshsizefile]\n"
,"if { $meshsizefilename != \"undefined\" } {\n"
,"set options.meshsizefilename $meshsizefilename\n"
,"}\n"
,"set refinementfilename [Ng_GetCommandLineParameter refinementfile]\n"
,"if { $batchmode == \"defined\" && $solvemode != \"defined\"} {\n"
,"set options.parthread 0\n"
,"if { $shellmode == \"undefined\" } {\n"
,"set selectvisual mesh\n"
,"Ng_SetVisParameters\n"
,"set meshsize [Ng_GetCommandLineParameter meshsize]\n"
,"if {$meshsize != \"undefined\"} { set options.meshsize $meshsize }\n"
,"if { $inputmeshfilename == \"undefined\" } {\n"
,"Ng_GenerateMesh ${meshoptions.firststep} ${meshoptions.laststep}\n"
,"} else {\n"
,"Ng_LoadMesh $inputmeshfilename\n"
,"if { $mergemeshfilename != \"undefined\" } {\n"
,"Ng_MergeMesh $mergemeshfilename\n"
,"}\n"
,"}\n"
,"if { $refinementfilename != \"undefined\" } {\n"
,"Ng_Bisect $refinementfilename\n"
,"}\n"
,"if { $meshfiletype == \"netgen\" } {\n"
,"Ng_SaveMesh $meshfilename\n"
,"} else {\n"
,"if { [catch { Ng_ExportMesh $meshfilename $meshfiletype } ] == 1 } {\n"
,"puts \"Unknown file format $meshfiletype\"\n"
,"}\n"
,"}\n"
,"Ng_Exit;\n"
,"exit\n"
,"} else {\n"
,"set code [catch { \n"
,"proc dotest {} {\n"
,"source ngtest.tcl\n"
,"}\n"
,"proc Ng_RunShell {} {\n"
,"puts \"Wellcome to NG Shell mode\"\n"
,"set line 1\n"
,"while { 1 } {\n"
,"puts -nonewline \"$line: \"\n"
,"flush stdout\n"
,"set cmdline [gets stdin]\n"
,"if { [catch $cmdline errcode] } {\n"
,"puts \"$errcode\"\n"
,"}\n"
,"incr line 1\n"
,"}\n"
,"}\n"
,"proc Ng_PrintCmdIndex { } {\n"
,"global cmdindex\n"
,"foreach { lst } $cmdindex {\n"
,"puts $lst\n"
,"}\n"
,"}\n"
,"proc Ng_PrintHlpIndex { } {\n"
,"global hlpindex\n"
,"global secindex\n"
,"foreach {sec} $secindex {\n"
,"puts \"\\n  * $sec:\"\n"
,"foreach {lst} $hlpindex {\n"
,"if {$sec == [lindex $lst 1]} {\n"
,"puts \"    * [lindex $lst 2]: [lindex $lst 3]\"\n"
,"}\n"
,"}\n"
,"}\n"
,"}\n"
,"proc Ng_RegisterCmd { cmd section syntax {help \"\"} } {\n"
,"global hlpindex\n"
,"global cmdindex\n"
,"global secindex\n"
,"puts \"register command $cmd\"\n"
,"if { [lsearch $cmdindex cmd] != -1 } {\n"
,"puts \"command '$cmd' already defined\"\n"
,"} else {\n"
,"lappend cmdindex $cmd\n"
,"lappend hlpindex [list $cmd $section $syntax $help]\n"
,"if {[lsearch $secindex $section]==-1} {\n"
,"lappend secindex $section\n"
,"}\n"
,"}\n"
,"}\n"
,"Ng_RegisterCmd \"exit\" \"general\" \"exit\" \"exit Netgen shell mode\"\n"
,"proc nghelp { {sec \"\"} } {\n"
,"global secindex\n"
,"global hlpindex\n"
,"global cmdindex\n"
,"if { $sec == \"\" } {\n"
,"Ng_PrintHlpIndex\n"
,"puts \"\\n  type help 'section'\\n\"\n"
,"return\n"
,"}\n"
,"if { [lsearch $secindex $sec] != -1} {\n"
,"foreach {lst} $hlpindex {\n"
,"if {[lindex $lst 1] == $sec } {\n"
,"puts \"  * [lindex $lst 2]: [lindex $lst 3]\"\n"
,"}\n"
,"}\n"
,"return\n"
,"}\n"
,"set ind [lsearch $cmdindex $sec]\n"
,"if {$ind != -1} {\n"
,"set lst [lindex $hlpindex $ind]\n"
,"puts \"  * [lindex $lst 2]: [lindex $lst 3]\"\n"
,"return\n"
,"}\n"
,"puts \"  unknown section or command $sec\"\n"
,"}\n"
,"set ngtimer 0\n"
,"proc nggettimer {} {\n"
,"return [clock clicks -milliseconds]\n"
,"}\n"
,"proc ngtic {} {\n"
,"set ::ngtimer [nggettimer]\n"
,"}\n"
,"proc ngtoc { {logfile stdout} } {\n"
,"set end [nggettimer]\n"
,"set tim [expr ($end - $::ngtimer)/1000.0]\n"
,"puts $logfile \"$tim s\"\n"
,"}\n"
,"proc ngloadgeometry { fname } {\n"
,"if { ![file exists $fname] } {\n"
,"puts \"error: file $fname does not exist\"\n"
,"} else {\n"
,"set err [catch {Ng_LoadGeometry $fname}]\n"
,"if {$err != 0} {\n"
,"puts \"error: loading geometry failed\"\n"
,"}\n"
,"}\n"
,"}\n"
,"Ng_RegisterCmd \"ngloadgeometry\" \"netgen\" \"ngloadgeometry <file>\" \"load geometry file\"\n"
,"proc ngparsegeometry {} {\n"
,"set err [catch {Ng_ParseGeometry}]\n"
,"if {$err} {\n"
,"puts \"error: parsing geometry failed\"\n"
,"}\n"
,"}\n"
,"Ng_RegisterCmd \"ngparsegeometry\" \"netgen\" \"ngparsegeometry\" \"parse geometry\"\n"
,"proc nggeneratemesh {} {\n"
,"set err [catch {Ng_GenerateMesh}]\n"
,"if {$err} {\n"
,"puts \"error:  mesh generation failed\"\n"
,"}\n"
,"}\n"
,"Ng_RegisterCmd \"nggeneratemesh\" \"netgen\" \"nggeneratemesh\" \"generate mesh\"\n"
,"proc ngsavemesh { fname } {\n"
,"if { [file exists $fname]} {\n"
,"puts \"warning: existing file $fname overwritten\"\n"
,"} else {\n"
,"set err [catch {Ng_SaveMesh $fname}]\n"
,"if {$err != 0} {\n"
,"puts \"error: saving mesh failed\"\n"
,"}\n"
,"}\n"
,"}\n"
,"Ng_RegisterCmd \"ngsavemesh\" \"netgen\" \"ngsavemesh <file>\" \"save mesh to file\"\n"
,"proc ngset { opt {val 0} } {\n"
,"if {$opt == \"meshsize\"} {\n"
,"set ::options.meshsize $val\n"
,"Ng_SetMeshingParameters\n"
,"} elseif {$opt == \"printmsg\"} {\n"
,"set ::options.printmsg $val\n"
,"Ng_SetMeshingParameters\n"
,"} else {\n"
,"puts \"error: unknown option $opt\";\n"
,"}\n"
,"}\n"
,"Ng_RegisterCmd \"ngset\" \"netgen\" \"ngset <option> <val>\" \"set option to val\"\n"
,"proc nganalyzegeometry {} {\n"
,"Ng_GenerateMesh ag ag\n"
,"Ng_ReadStatus\n"
,"}\n"
,"proc ngmeshedges {} {\n"
,"Ng_GenerateMesh me me\n"
,"Ng_ReadStatus\n"
,"}\n"
,"proc ngmeshsurface { } {\n"
,"Ng_GenerateMesh ms ms\n"
,"Ng_ReadStatus\n"
,"}\n"
,"proc ngoptimizesurface { {step all} } {\n"
,"if {$step == \"all\"} {\n"
,"Ng_GenerateMesh os os cmsmSm\n"
,"} elseif {$step == \"meshsmoothing\"} {\n"
,"Ng_GenerateMesh os os m\n"
,"} elseif {$step == \"topologicedgeswapping\" } {\n"
,"Ng_GenerateMesh os os s\n"
,"} elseif {$step == \"metricedgeswapping\"} {\n"
,"Ng_GenerateMesh os os S\n"
,"} elseif {$step == \"combinepoints\"} {\n"
,"Ng_GenerateMesh os os c\n"
,"} else {\n"
,"puts \"error: unknown option in ngoptimizesurface\"\n"
,"return\n"
,"}\n"
,"Ng_ReadStatus\n"
,"}\n"
,"proc ngmeshvolume { } {\n"
,"Ng_GenerateMesh mv mv\n"
,"Ng_ReadStatus\n"
,"}\n"
,"proc ngoptimizevolume {{step \"\"} } {\n"
,"if {$step == \"\"} {\n"
,"Ng_GenerateMesh ov ov\n"
,"} elseif {$step == \"smooth\"} {\n"
,"Ng_GenerateMesh ov ov m\n"
,"} elseif {$step == \"smoothjacobian\"} {\n"
,"Ng_GenerateMesh ov ov j\n"
,"} else {\n"
,"puts \"error: unknown step $step in ngoptimizevolume\"\n"
,"return\n"
,"}\n"
,"Ng_ReadStatus\n"
,"}\n"
,"proc ngsloadpde {fname} {\n"
,"if { ![file exists $fname] } {\n"
,"puts \"warning: pdefile $fname does not exist\"\n"
,"} else {\n"
,"puts \"load pde $fname\"\n"
,"NGS_LoadPDE $fname\n"
,"}\n"
,"}\n"
,"proc ngssolvepde {} {\n"
,"NGS_SolvePDE\n"
,"}\n"
,"catch {source \"${::ngdir}/ngtesting.tcl\"} errcode\n"
,"} errcode]\n"
,"if {$code} {\n"
,"puts \"error: $errcode\"\n"
,"}\n"
,"set code [ catch {Ng_RunShell} errcode]\n"
,"if {$code} {\n"
,"puts \"error: $errcode\"\n"
,"}\n"
,"Ng_Exit;\n"
,"exit\n"
,"}\n"
,"}\n"
,"set stereo [Ng_GetCommandLineParameter stereo]\n"
,"if { $stereo == \"defined\" } {\n"
,"set viewoptions.stereo 1\n"
,"puts \"use stereo mode\"\n"
,"Ng_SetVisParameters;\n"
,"redraw\n"
,"}\n"
,"set ngsolve_loaded 0\n"
,"catch {\n"
,"source ${ngdir}/ngsolve.tcl;\n"
,"set ngsolve_loaded 1\n"
,"}\n"
,"set pathlist [split $::env(PATH) \\ [expr {$::tcl_platform(platform) == \"windows\" ? \";\" : \":\"}]]\n"
,"foreach dir $pathlist {\n"
,"if { $ngsolve_loaded != 1 } {\n"
,"catch {\n"
,"source ${dir}/ngsolve.tcl\n"
,"set ngsolve_loaded 1\n"
,"}\n"
,"}\n"
,"}\n"
,"set scriptfilename [Ng_GetCommandLineParameter script]\n"
,"if { $scriptfilename != \"undefined\" } {\n"
,"if { [catch { source $scriptfilename } errstring] == 1 } {\n"
,"puts \"Error in input: $errstring\"\n"
,"}\n"
,"}\n"
,"if { [Ng_GetCommandLineParameter help]==\"defined\" } {\n"
,"if { $zugstange == 1 } {\n"
,"print_zug_commandline_help\n"
,"exit;\n"
,"} {\n"
,"if { $trafoapp == 1 } {\n"
,"print_trafo_commandline_help;\n"
,"} {\n"
,"print_commandline_help;\n"
,"Ng_Exit;\n"
,"exit\n"
,"}\n"
,"}\n"
,"}\n"
,"if { [file exists startup.tcl] } {\n"
,"source startup.tcl }\n"
,"catch { source ${ngdir}/demoapp.tcl }\n"
,"catch { source ${ngdir}/dropsexp.tcl }\n"
, nullptr
};
