#!bin/bash
export PATH="$PATH:/home/sachsenb/OpenMS/openms-build-tmp/bin"

#python share/OpenMS/examples/simulation/FASTAProteinAbundanceSampling.py openms-build-tmp/test.fasta openms-build-tmp/test1.fasta

# create experimental design file
echo "Fraction_Group	Fraction	Spectra_Filepath	Label	Sample
1	1	run1.mzML	1	1
2	1	run2.mzML	1	2
3	1	run3.mzML	1	3
4	1	run4.mzML	1	4
5	1	run5.mzML	1	5
6	1	run6.mzML	1	6

Sample	MSstats_Condition	MSstats_BioReplicate
1	1	1
2	1	2
3	1	3
4	2	4
5	2	5
6	2	6
" > experimental_design.tsv

# simulate data

# replicates of three, two conditions. two differential proteins with all peptides shared, one constant protein with no peptides shared
declare -a sample_abundances_prot1=("1e3" "2e3" "3e3" "4e6" "5e6" "6e6")
declare -a sample_abundances_prot2=("1e4" "2e4" "3e4" "4e7" "5e7" "6e7")

for i in $(seq 1 6);
do
# create fasta with protein intensities
echo ">P02769|ALBU_BOVIN Serum albumin - Bos taurus (Bovine).[# intensity=${sample_abundances_prot1[$i-1]} #]
MKWVTFISLLLLFSSAYSRGVFRRDTHKSEIAHRFKDLGEEHFKGLVLIAFSQYLQQCPFDEHVKLVNELTEFAKTCVAD
ESHAGCEKSLHTLFGDELCKVASLRETYGDMADCCEKQEPERNECFLSHKDDSPDLPKLKPDPNTLCDEFKADEKKFWGK
YLYEIARRHPYFYAPELLYYANKYNGVFQECCQAEDKGACLLPKIETMREKVLASSARQRLRCASIQKFGERALKAWSVA
RLSQKFPKAEFVEVTKLVTDLTKVHKECCHGDLLECADDRADLAKYICDNQDTISSKLKECCDKPLLEKSHCIAEVEKDA
IPENLPPLTADFAEDKDVCKNYQEAKDAFLGSFLYEYSRRHPEYAVSVLLRLAKEYEATLEECCAKDDPHACYSTVFDKL
KHLVDEPQNLIKQNCDQFEKLGEYGFQNALIVRYTRKVPQVSTPTLVEVSRSLGKVGTRCCTKPESERMPCTEDYLSLIL
NRLCVLHEKTPVSEKVTKCCTESLVNRRPCFSALTPDETYVPKAFDEKLFTFHADICTLPDTEKQIKKQTALVELLKHKP
KATEEQLKTVMENFVAFVDKCCAADDKEACFAVEGPKLVVSTQTALA
>Q02769|ALBU_BOVIN Serum albumin - Bos taurus (Bovine) copy of P02769.[# intensity=${sample_abundances_prot2[$i-1]} #]
MKWVTFISLLLLFSSAYSRGVFRRDTHKSEIAHRFKDLGEEHFKGLVLIAFSQYLQQCPFDEHVKLVNELTEFAKTCVAD
ESHAGCEKSLHTLFGDELCKVASLRETYGDMADCCEKQEPERNECFLSHKDDSPDLPKLKPDPNTLCDEFKADEKKFWGK
YLYEIARRHPYFYAPELLYYANKYNGVFQECCQAEDKGACLLPKIETMREKVLASSARQRLRCASIQKFGERALKAWSVA
RLSQKFPKAEFVEVTKLVTDLTKVHKECCHGDLLECADDRADLAKYICDNQDTISSKLKECCDKPLLEKSHCIAEVEKDA
IPENLPPLTADFAEDKDVCKNYQEAKDAFLGSFLYEYSRRHPEYAVSVLLRLAKEYEATLEECCAKDDPHACYSTVFDKL
KHLVDEPQNLIKQNCDQFEKLGEYGFQNALIVRYTRKVPQVSTPTLVEVSRSLGKVGTRCCTKPESERMPCTEDYLSLIL
NRLCVLHEKTPVSEKVTKCCTESLVNRRPCFSALTPDETYVPKAFDEKLFTFHADICTLPDTEKQIKKQTALVELLKHKP
KATEEQLKTVMENFVAFVDKCCAADDKEACFAVEGPKLVVSTQTALA
>sp|P03436|HEMA_I68A6 Hemagglutinin OS=Influenza A virus (strain A/Northern Territory/60/1968 H3N2) OX=384505 GN=HA PE=1 SV=1. [# intensity=10 #]
MKTIIALSYIFCLALGQDLPGNDNNTATLCLGHHAVPNGTLVKTITDDQIEVTNATELVQ
SSSTGKICNNPHRILDGIDCTLIDALLGDPHCDVFQNETWDLFVERSKAFSNCYPYDVPD
YASLRSLVASSGTLEFITEGFTWTGVTQNGGSNACKRGPDSGFFSRLNWLTKSGSTYPVL
NVTMPNNDNFDKLYIWGVHHPSTNQEQTSLYVQASGRVTVSTRRSQQTIIPNIGSRPWVR
GQSSRISIYWTIVKPGDVLVINSNGNLIAPRGYFKMRTGKSSIMRSDAPIDTCISECITP
NGSIPNDKPFQNVNKITYGACPKYVKQNTLKLATGMRNVPEKQTRGLFGAIAGFIENGWE
GMIDGWYGFRHQNSEGTGQAADLKSTQAAIDQINGKLNRVIEKTNEKFHQIEKEFSEVEG
RIQDLEKYVEDTKIDLWSYNAELLVALENQHTIDLTDSEMNKLFEKTRRQLRENAEDMGN
GCFKIYHKCDNACIESIRNGTYDHDVYRDEALNNRFQIKGVELKSGYKDWILWISFAISC
FLLCVVLLGFIMWACQRGNIRCNICI
" > BSA.fasta

MSSimulator -in BSA.fasta -out run${i}.mzML -out_id run${i}.idXML -out_fm run${i}.featureXML -algorithm:MSSim:RawTandemSignal:status "precursor"
PeptideIndexer -in run${i}.idXML -fasta BSA.fasta -out run${i}.idXML -missing_decoy_action "warn"
sed -i 's/score_type=""/score_type="Posterior Probability"/g' run${i}.idXML
done

ProteomicsLFQ -in run1.mzML run2.mzML run3.mzML \
run4.mzML run5.mzML run6.mzML \
-ids run1.idXML run2.idXML run3.idXML \
run4.idXML run5.idXML run6.idXML \
-design experimental_design.tsv \
-Alignment:max_rt_shift 0 \
-fasta BSA.fasta \
-targeted_only true \
-transfer_ids "false" \
-mass_recalibration "false" \
-out_cxml BSA.consensusXML \
-proteinFDR 1.0 \
-out_msstats BSA.csv \
-out BSA.mzTab -threads 4 -debug 667 

