// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type AssociateNetworkAclRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* networkAclId ID  */
    NetworkAclId string `json:"networkAclId"`

    /* networkAcl要绑定的子网ID列表, subnet已被其他networkAcl绑定时，自动解绑  */
    SubnetIds []string `json:"subnetIds"`
}

/*
 * param regionId: Region ID (Required)
 * param networkAclId: networkAclId ID (Required)
 * param subnetIds: networkAcl要绑定的子网ID列表, subnet已被其他networkAcl绑定时，自动解绑 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewAssociateNetworkAclRequest(
    regionId string,
    networkAclId string,
    subnetIds []string,
) *AssociateNetworkAclRequest {

	return &AssociateNetworkAclRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/networkAcls/{networkAclId}:associateNetworkAcl",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        NetworkAclId: networkAclId,
        SubnetIds: subnetIds,
	}
}

/*
 * param regionId: Region ID (Required)
 * param networkAclId: networkAclId ID (Required)
 * param subnetIds: networkAcl要绑定的子网ID列表, subnet已被其他networkAcl绑定时，自动解绑 (Required)
 */
func NewAssociateNetworkAclRequestWithAllParams(
    regionId string,
    networkAclId string,
    subnetIds []string,
) *AssociateNetworkAclRequest {

    return &AssociateNetworkAclRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/networkAcls/{networkAclId}:associateNetworkAcl",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        NetworkAclId: networkAclId,
        SubnetIds: subnetIds,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewAssociateNetworkAclRequestWithoutParam() *AssociateNetworkAclRequest {

    return &AssociateNetworkAclRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/networkAcls/{networkAclId}:associateNetworkAcl",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *AssociateNetworkAclRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param networkAclId: networkAclId ID(Required) */
func (r *AssociateNetworkAclRequest) SetNetworkAclId(networkAclId string) {
    r.NetworkAclId = networkAclId
}

/* param subnetIds: networkAcl要绑定的子网ID列表, subnet已被其他networkAcl绑定时，自动解绑(Required) */
func (r *AssociateNetworkAclRequest) SetSubnetIds(subnetIds []string) {
    r.SubnetIds = subnetIds
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r AssociateNetworkAclRequest) GetRegionId() string {
    return r.RegionId
}

type AssociateNetworkAclResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result AssociateNetworkAclResult `json:"result"`
}

type AssociateNetworkAclResult struct {
}