/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.fmrc.FmrcDefinition;
import ucar.nc2.dt.fmrc.ForecastModelRunInventory;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationOuterDimension;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.URLnaming;

public class AggregationFmrc
extends AggregationOuterDimension {
    private static String definitionDir;
    protected static Set<NetcdfDataset.Enhance> fmrcEnhanceMode;
    private FmrcDefinition fmrcDefinition;
    private boolean debug = false;

    public static void setDefinitionDirectory(File defDir) {
        definitionDir = defDir.getPath() + '/';
    }

    public AggregationFmrc(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, Aggregation.Type.forecastModelRunCollection, recheckS);
    }

    protected AggregationFmrc(NetcdfDataset ncd, String dimName, Aggregation.Type type, String recheckS) {
        super(ncd, dimName, type, recheckS);
    }

    public void setInventoryDefinition(String invDef) {
        String path = URLnaming.resolveFile(definitionDir, invDef);
        this.fmrcDefinition = new FmrcDefinition();
        try {
            boolean ok = this.fmrcDefinition.readDefinitionXML(path);
            if (!ok) {
                logger.warn("FmrcDefinition file not found= " + path);
                this.fmrcDefinition = null;
            } else {
                this.spiObject = this.fmrcDefinition;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.fmrcDefinition = null;
        }
    }

    protected void makeDatasets(CancelTask cancelTask) throws IOException {
        super.makeDatasets(cancelTask);
        for (Aggregation.Dataset ds : this.datasets) {
            ds.enhance = fmrcEnhanceMode;
        }
    }

    public void getDetailInfo(Formatter f) {
        super.getDetailInfo(f);
        if (this.fmrcDefinition != null) {
            f.format("  fmrcDefinition=%s%n", this.fmrcDefinition);
        }
    }

    protected void buildNetcdfDataset(CancelTask cancelTask) throws IOException {
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        NetcdfFile typicalFile = typicalDataset.acquireFile(cancelTask);
        NetcdfDataset typicalDS = NetcdfDataset.wrap(typicalFile, null);
        GridDataset typicalGds = new GridDataset(typicalDS);
        this.buildNetcdfDataset(typicalDataset, typicalFile, typicalGds, cancelTask);
    }

    protected void buildNetcdfDataset(Aggregation.Dataset typicalDataset, NetcdfFile typicalFile, ucar.nc2.dt.GridDataset typicalGds, CancelTask cancelTask) throws IOException {
        this.buildCoords(cancelTask);
        DatasetConstructor.transferDataset(typicalGds.getNetcdfFile(), this.ncDataset, null);
        Group root = this.ncDataset.getRootGroup();
        root.addAttribute(new Attribute("Conventions", "CF-1.0, _Coordinates"));
        root.addAttribute(new Attribute("cdm_data_type", FeatureType.GRID.toString()));
        root.remove(root.findAttribute("_CoordinateModelRunDate"));
        root.remove(root.findAttribute("location"));
        String dimName = this.getDimensionName();
        int nruns = this.getTotalCoords();
        Dimension aggDim = new Dimension(dimName, nruns);
        this.ncDataset.removeDimension(null, dimName);
        this.ncDataset.addDimension(null, aggDim);
        this.promoteGlobalAttributes((AggregationOuterDimension.DatasetOuterDimension)typicalDataset);
        DataType coordType = DataType.STRING;
        VariableDS runtimeCoordVar = new VariableDS(this.ncDataset, null, null, dimName, coordType, dimName, null, null);
        runtimeCoordVar.addAttribute(new Attribute("long_name", "Run time for ForecastModelRunCollection"));
        runtimeCoordVar.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        runtimeCoordVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RunTime.toString()));
        this.ncDataset.removeVariable(null, runtimeCoordVar.getShortName());
        this.ncDataset.addVariable(null, runtimeCoordVar);
        if (this.debug) {
            System.out.println("FmrcAggregation: added runtimeCoordVar " + runtimeCoordVar.getName());
        }
        ArrayObject.D1 runData = (ArrayObject.D1)Array.factory(DataType.STRING, new int[]{nruns});
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        for (int j = 0; j < nestedDatasets.size(); ++j) {
            AggregationOuterDimension.DatasetOuterDimension dataset = (AggregationOuterDimension.DatasetOuterDimension)nestedDatasets.get(j);
            runData.set(j, dataset.getCoordValueString());
        }
        runtimeCoordVar.setCachedData(runData, true);
        if (this.fmrcDefinition != null) {
            this.makeTimeCoordinateWithDefinition(typicalGds, cancelTask);
        } else {
            this.makeTimeCoordinate(typicalGds, cancelTask);
        }
        for (GridDatatype grid : typicalGds.getGrids()) {
            VariableDS v = grid.getVariable();
            if (v instanceof CoordinateAxis && !this.aggVarNames.contains(v.getName()) || grid.getTimeDimension() == null) continue;
            String dims = dimName + " " + v.getDimensionsString();
            Group newGroup = DatasetConstructor.findGroup(this.ncDataset, v.getParentGroup());
            VariableDS vagg = new VariableDS(this.ncDataset, newGroup, null, v.getShortName(), v.getDataType(), dims, null, null);
            vagg.setProxyReader(this);
            DatasetConstructor.transferVariableAttributes(v, vagg);
            vagg.addAttribute(new Attribute("_CoordinateAxes", dimName + " " + grid.getCoordinateSystem().getName()));
            vagg.addAttribute(new Attribute("coordinates", dimName + " " + grid.getCoordinateSystem().getName()));
            newGroup.removeVariable(v.getShortName());
            newGroup.addVariable(vagg);
            this.aggVars.add(vagg);
            if (!this.debug) continue;
            System.out.println("FmrcAggregation: added grid " + v.getName());
        }
        this.ncDataset.finish();
        this.setDatasetAcquireProxy(typicalDataset, this.ncDataset);
        this.ncDataset.enhance();
        if (typicalFile != null) {
            typicalDataset.close(typicalFile);
        }
    }

    protected void rebuildDataset() throws IOException {
        this.buildCoords(null);
        int nruns = this.getTotalCoords();
        String dimName = this.getDimensionName();
        Dimension aggDim = this.ncDataset.findDimension(dimName);
        aggDim.setLength(nruns);
        VariableDS runtimeCoord = (VariableDS)this.ncDataset.findVariable(dimName);
        runtimeCoord.resetDimensions();
        ArrayObject.D1 runData = (ArrayObject.D1)Array.factory(DataType.STRING, new int[]{nruns});
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        for (int j = 0; j < nestedDatasets.size(); ++j) {
            AggregationOuterDimension.DatasetOuterDimension dataset = (AggregationOuterDimension.DatasetOuterDimension)nestedDatasets.get(j);
            runData.set(j, dataset.getCoordValueString());
        }
        runtimeCoord.setCachedData(runData, true);
        if (this.fmrcDefinition != null) {
            List<FmrcDefinition.RunSeq> runSeq = this.fmrcDefinition.getRunSequences();
            for (FmrcDefinition.RunSeq seq : runSeq) {
                String timeDimName = seq.getName();
                int max_times = 0;
                List<Aggregation.Dataset> nestedDatasets2 = this.getDatasets();
                for (Aggregation.Dataset dataset : nestedDatasets2) {
                    AggregationOuterDimension.DatasetOuterDimension dod = (AggregationOuterDimension.DatasetOuterDimension)dataset;
                    ForecastModelRunInventory.TimeCoord timeCoord = seq.findTimeCoordByRuntime(dod.getCoordValueDate());
                    double[] offsets = timeCoord.getOffsetHours();
                    max_times = Math.max(max_times, offsets.length);
                }
                Dimension timeDim = this.ncDataset.findDimension(timeDimName);
                timeDim.setLength(max_times);
                AggregationOuterDimension.DatasetOuterDimension firstDataset = (AggregationOuterDimension.DatasetOuterDimension)nestedDatasets2.get(0);
                Date baseDate = firstDataset.getCoordValueDate();
                String units = "hours since " + this.dateFormatter.toDateTimeStringISO(baseDate);
                VariableDS timeCoord = (VariableDS)this.ncDataset.findVariable(timeDimName);
                timeCoord.resetDimensions();
                timeCoord.addAttribute(new Attribute("units", units));
                timeCoord.setUnitsString(units);
                Array coordValues = this.calcTimeCoordinateFromDef(nruns, max_times, seq);
                timeCoord.setCachedData(coordValues, true);
            }
        }
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        Aggregation.DatasetProxyReader typicalDatasetProxy = new Aggregation.DatasetProxyReader(typicalDataset);
        ArrayList<CoordinateAxis> timeAxes = new ArrayList<CoordinateAxis>();
        List<Variable> vars = this.ncDataset.getVariables();
        for (Variable v : vars) {
            if (v instanceof CoordinateAxis) {
                CoordinateAxis axis = (CoordinateAxis)v;
                if (axis.getAxisType() == AxisType.Time) {
                    timeAxes.add(axis);
                }
                if (this.fmrcDefinition != null) continue;
            }
            if (v.getRank() > 0 && v.getDimension(0).getName().equals(dimName) && v != runtimeCoord) {
                v.resetDimensions();
                v.setCachedData(null, false);
                continue;
            }
            VariableDS ve = (VariableDS)v;
            ProxyReader proxy = ve.getProxyReader();
            if (!(proxy instanceof Aggregation.DatasetProxyReader)) continue;
            ve.setProxyReader(typicalDatasetProxy);
        }
        if (this.fmrcDefinition == null) {
            for (CoordinateAxis timeAxis : timeAxes) {
                if (!this.timeUnitsChange) continue;
                this.readTimeCoordinates(timeAxis, null);
            }
        }
    }

    protected void makeTimeCoordinateWithDefinition(ucar.nc2.dt.GridDataset gds, CancelTask cancelTask) throws IOException {
        List<FmrcDefinition.RunSeq> runSeq = this.fmrcDefinition.getRunSequences();
        for (FmrcDefinition.RunSeq seq : runSeq) {
            String timeDimName = seq.getName();
            boolean isRagged = false;
            int max_times = 0;
            List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
            for (Aggregation.Dataset dataset : nestedDatasets) {
                AggregationOuterDimension.DatasetOuterDimension dod = (AggregationOuterDimension.DatasetOuterDimension)dataset;
                ForecastModelRunInventory.TimeCoord timeCoord = seq.findTimeCoordByRuntime(dod.getCoordValueDate());
                double[] offsets = timeCoord.getOffsetHours();
                if ((max_times = Math.max(max_times, offsets.length)) == offsets.length) continue;
                isRagged = true;
            }
            Dimension timeDim = new Dimension(timeDimName, max_times);
            this.ncDataset.removeDimension(null, timeDimName);
            this.ncDataset.addDimension(null, timeDim);
            AggregationOuterDimension.DatasetOuterDimension firstDataset = (AggregationOuterDimension.DatasetOuterDimension)nestedDatasets.get(0);
            Date baseDate = firstDataset.getCoordValueDate();
            String desc = "Coordinate variable for " + timeDimName + " dimension";
            String units = "hours since " + this.dateFormatter.toDateTimeStringISO(baseDate);
            String dims = this.getDimensionName() + " " + timeDimName;
            VariableDS newV = new VariableDS(this.ncDataset, null, null, timeDimName, DataType.DOUBLE, dims, units, desc);
            Variable oldV = this.ncDataset.getRootGroup().findVariable(timeDimName);
            Group aggGroup = null;
            if (null != oldV) {
                aggGroup = DatasetConstructor.findGroup(this.ncDataset, oldV.getParentGroup());
                aggGroup.removeVariable(timeDimName);
            }
            this.ncDataset.addVariable(aggGroup, newV);
            newV.addAttribute(new Attribute("units", units));
            newV.addAttribute(new Attribute("long_name", desc));
            newV.addAttribute(new Attribute("standard_name", "time"));
            newV.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
            if (isRagged) {
                newV.addAttribute(new Attribute("missing_value", Double.NaN));
            }
            int nruns = this.getTotalCoords();
            Array coordValues = this.calcTimeCoordinateFromDef(nruns, max_times, seq);
            newV.setCachedData(coordValues, true);
        }
        this.ncDataset.finish();
    }

    protected void makeTimeCoordinate(ucar.nc2.dt.GridDataset gds, CancelTask cancelTask) throws IOException {
        HashSet<CoordinateAxis1DTime> timeAxes = new HashSet<CoordinateAxis1DTime>();
        for (GridDatatype gridDatatype : gds.getGrids()) {
            GridCoordSystem gcc = gridDatatype.getCoordinateSystem();
            CoordinateAxis1DTime timeAxis = gcc.getTimeAxis1D();
            if (null == timeAxis) continue;
            timeAxes.add(timeAxis);
        }
        for (CoordinateAxis1D coordinateAxis1D : timeAxes) {
            Group newGroup = DatasetConstructor.findGroup(this.ncDataset, coordinateAxis1D.getParentGroup());
            DataType dtype = coordinateAxis1D.getDataType() == DataType.STRING ? DataType.STRING : DataType.DOUBLE;
            String dims = this.dimName + " " + coordinateAxis1D.getDimensionsString();
            VariableDS vagg = new VariableDS(this.ncDataset, newGroup, null, coordinateAxis1D.getShortName(), dtype, dims, null, null);
            DatasetConstructor.transferVariableAttributes(coordinateAxis1D, vagg);
            Attribute att = vagg.findAttribute("_CoordinateAliasForDimension");
            if (att != null) {
                vagg.remove(att);
            }
            newGroup.removeVariable(coordinateAxis1D.getShortName());
            newGroup.addVariable(vagg);
            if (!this.timeUnitsChange) {
                vagg.setProxyReader(this);
            } else {
                this.readTimeCoordinates(vagg, cancelTask);
            }
            if (this.debug) {
                System.out.println("FmrcAggregation: promoted timeCoord " + coordinateAxis1D.getName());
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }

    public Array read(Variable mainv, CancelTask cancelTask) throws IOException {
        DataType dtype;
        if (debugConvert && mainv instanceof VariableDS && (dtype = ((VariableDS)mainv).getOriginalDataType()) != null && dtype != mainv.getDataType()) {
            System.out.printf("Original type = %s mainv type= %s%n", new Object[]{dtype, mainv.getDataType()});
        }
        dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Object spObj = mainv.getSPobject();
        if (spObj != null && spObj instanceof AggregationOuterDimension.CacheVar) {
            AggregationOuterDimension.CacheVar pv = (AggregationOuterDimension.CacheVar)spObj;
            try {
                Array cacheArray = pv.read(mainv.getShapeAsSection(), cancelTask);
                return MAMath.convert(cacheArray, dtype);
            }
            catch (InvalidRangeException e) {
                logger.error("readAgg " + this.getLocation(), e);
                throw new IllegalArgumentException("readAgg " + this.getLocation(), e);
            }
        }
        List<Range> ranges = mainv.getRanges();
        List<Range> innerSection = ranges.subList(1, ranges.size());
        long fullSize = new Section(innerSection).computeSize();
        Array allData = Array.factory(dtype, mainv.getShape());
        int destPos = 0;
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        for (Aggregation.Dataset vnested : nestedDatasets) {
            Array varData = vnested.read(mainv, cancelTask);
            varData = MAMath.convert(varData, dtype);
            Array.arraycopy(varData, 0, allData, destPos, (int)varData.getSize());
            destPos = (int)((long)destPos + fullSize);
            if (fullSize != varData.getSize()) {
                logger.info("FMRC Ragged Time " + fullSize + " != " + varData.getSize() + " dataset " + vnested.getId() + " for variable " + mainv.getNameAndDimensions());
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return null;
        }
        return allData;
    }

    public Array read(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        List<Aggregation.Dataset> nestedDatasets;
        long size;
        DataType dtype;
        if (debugConvert && mainv instanceof VariableDS && (dtype = ((VariableDS)mainv).getOriginalDataType()) != null && dtype != mainv.getDataType()) {
            System.out.printf("Original type = %s mainv type= %s%n", new Object[]{dtype, mainv.getDataType()});
        }
        if ((size = section.computeSize()) == mainv.getSize()) {
            return this.read(mainv, cancelTask);
        }
        DataType dtype2 = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Object spObj = mainv.getSPobject();
        if (spObj != null && spObj instanceof AggregationOuterDimension.CacheVar) {
            AggregationOuterDimension.CacheVar pv = (AggregationOuterDimension.CacheVar)spObj;
            try {
                Array cacheArray = pv.read(section, cancelTask);
                return MAMath.convert(cacheArray, dtype2);
            }
            catch (InvalidRangeException e) {
                logger.error("readAgg " + this.getLocation(), e);
                throw new IllegalArgumentException("readAgg " + this.getLocation(), e);
            }
        }
        Array sectionData = Array.factory(dtype2, section.getShape());
        int destPos = 0;
        List<Range> ranges = section.getRanges();
        Range joinRange = section.getRange(0);
        List<Range> innerSection = ranges.subList(1, ranges.size());
        long fullSize = new Section(innerSection).computeSize();
        if (this.debug) {
            System.out.println("   agg wants range=" + mainv.getName() + "(" + joinRange + ")");
        }
        if ((nestedDatasets = this.getDatasets()) == null || nestedDatasets.size() == 0) {
            System.out.printf("HEY!!!", new Object[0]);
        }
        for (Aggregation.Dataset nested : nestedDatasets) {
            AggregationOuterDimension.DatasetOuterDimension dod = (AggregationOuterDimension.DatasetOuterDimension)nested;
            if (!dod.isNeeded(joinRange)) continue;
            Array varData = nested.read(mainv, cancelTask, innerSection);
            varData = MAMath.convert(varData, dtype2);
            Array.arraycopy(varData, 0, sectionData, destPos, (int)varData.getSize());
            destPos = (int)((long)destPos + fullSize);
            if (fullSize != varData.getSize()) {
                System.out.println("FMRC RAGGED HERE " + fullSize + " != " + varData.getSize());
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return null;
        }
        return sectionData;
    }

    private Array calcTimeCoordinateFromDef(int nruns, int max_times, FmrcDefinition.RunSeq seq) {
        ArrayDouble.D2 coordValues = (ArrayDouble.D2)Array.factory(DataType.DOUBLE, new int[]{nruns, max_times});
        Date baseDate = null;
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        for (int j = 0; j < nestedDatasets.size(); ++j) {
            int k;
            AggregationOuterDimension.DatasetOuterDimension dataset = (AggregationOuterDimension.DatasetOuterDimension)nestedDatasets.get(j);
            Date runTime = dataset.getCoordValueDate();
            if (baseDate == null) {
                baseDate = runTime;
            }
            double run_offset = ForecastModelRunInventory.getOffsetInHours(baseDate, runTime);
            ForecastModelRunInventory.TimeCoord timeCoord = seq.findTimeCoordByRuntime(runTime);
            double[] offsets = timeCoord.getOffsetHours();
            for (k = 0; k < offsets.length; ++k) {
                coordValues.set(j, k, offsets[k] + run_offset);
            }
            for (k = offsets.length; k < max_times; ++k) {
                coordValues.set(j, k, Double.NaN);
            }
        }
        return coordValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readTimeCoordinates(VariableDS timeAxis, CancelTask cancelTask) throws IOException {
        DateUnit du;
        Date[] dates;
        ArrayList<Date[]> dateList = new ArrayList<Date[]>();
        int maxTimes = 0;
        String units = null;
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        for (int i = 0; i < nestedDatasets.size(); ++i) {
            Object var15_20;
            NetcdfDataset ncd;
            Aggregation.Dataset dataset;
            block15: {
                block14: {
                    dataset = nestedDatasets.get(i);
                    ncd = null;
                    try {
                        NetcdfFile ncfile = dataset.acquireFile(cancelTask);
                        ncd = NetcdfDataset.wrap(ncfile, NetcdfDataset.getDefaultEnhanceMode());
                        VariableDS v = (VariableDS)ncd.findVariable(timeAxis.getName());
                        if (v == null) {
                            logger.warn("readTimeCoordinates: variable = " + timeAxis.getName() + " not found in file " + dataset.getLocation());
                            var15_20 = null;
                            break block14;
                        }
                        CoordinateAxis1DTime timeCoordVar = CoordinateAxis1DTime.factory(this.ncDataset, v, null);
                        dates = timeCoordVar.getTimeDates();
                        maxTimes = Math.max(maxTimes, dates.length);
                        dateList.add(dates);
                        if (i == 0) {
                            units = v.getUnitsString();
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        var15_20 = null;
                        dataset.close(ncd);
                        throw throwable;
                    }
                }
                dataset.close(ncd);
                return;
            }
            var15_20 = null;
            dataset.close(ncd);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        int[] shape = timeAxis.getShape();
        int ntimes = shape[1];
        if (ntimes != maxTimes) {
            shape[1] = maxTimes;
            Dimension d = timeAxis.getDimension(1);
            d.setLength(maxTimes);
            timeAxis.resetDimensions();
        }
        Array timeCoordVals = Array.factory(timeAxis.getDataType(), shape);
        Index ima = timeCoordVals.getIndex();
        timeAxis.setCachedData(timeCoordVals, false);
        if (timeAxis.getDataType() == DataType.STRING) {
            for (int i = 0; i < dateList.size(); ++i) {
                Date[] dates2 = (Date[])dateList.get(i);
                for (int j = 0; j < dates2.length; ++j) {
                    Date date = dates2[j];
                    timeCoordVals.setObject(ima.set(i, j), (Object)this.dateFormatter.toDateTimeStringISO(date));
                }
            }
            return;
        }
        try {
            du = new DateUnit(units);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        timeAxis.addAttribute(new Attribute("units", units));
        for (int i = 0; i < dateList.size(); ++i) {
            int j;
            dates = (Date[])dateList.get(i);
            for (j = 0; j < dates.length; ++j) {
                Date date = dates[j];
                double val = du.makeValue(date);
                timeCoordVals.setDouble(ima.set(i, j), val);
            }
            for (j = dates.length; j < maxTimes; ++j) {
                timeCoordVals.setDouble(ima.set(i, j), Double.NaN);
            }
        }
    }

    public void detail(Formatter f) {
        super.detail(f);
        f.format(" fmrcDefinition = %s%n", this.fmrcDefinition);
    }

    public static void main(String[] arg) throws IOException {
        String defaultFilename = "C:/data/rap/fmrc.xml";
        String filename = arg.length > 0 ? arg[0] : defaultFilename;
        GridDataset gds = GridDataset.open(filename);
        GridDatatype gg = gds.findGridDatatype("T");
        GridCoordSystem gsys = gg.getCoordinateSystem();
        CoordinateAxis1DTime rtaxis = gsys.getRunTimeAxis();
        CoordinateAxis taxis2D = gsys.getTimeAxis();
        Array data = taxis2D.read();
        NCdump.printArray(data, "2D time array", System.out, null);
        System.out.println("Run Time, Valid Times");
        Date[] runtimes = rtaxis.getTimeDates();
        for (int i = 0; i < runtimes.length; ++i) {
            System.out.println("\n" + runtimes[i]);
            CoordinateAxis1DTime taxis = gsys.getTimeAxisForRun(i);
            Date[] times = taxis.getTimeDates();
            for (int j = 0; j < times.length; ++j) {
                System.out.println("   " + times[j]);
            }
        }
    }

    static {
        fmrcEnhanceMode = NetcdfDataset.getDefaultEnhanceMode();
    }
}

