/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;

public class NcStreamReader {
    private static final boolean debug = false;
    private NcStreamProto.Header proto;

    public NetcdfFile readStream(InputStream is, NetcdfFile ncfile) throws IOException {
        assert (this.readAndTest(is, NcStream.MAGIC_START));
        assert (this.readAndTest(is, NcStream.MAGIC_HEADER));
        int msize = NcStream.readVInt(is);
        byte[] m = new byte[msize];
        NcStream.readFully(is, m);
        this.proto = NcStreamProto.Header.parseFrom(m);
        ncfile = this.proto2nc(this.proto, ncfile);
        while (is.available() > 0) {
            this.readData(is, ncfile);
        }
        return ncfile;
    }

    public DataResult readData(InputStream is, NetcdfFile ncfile) throws IOException {
        assert (this.readAndTest(is, NcStream.MAGIC_DATA));
        int psize = NcStream.readVInt(is);
        byte[] dp = new byte[psize];
        NcStream.readFully(is, dp);
        NcStreamProto.Data dproto = NcStreamProto.Data.parseFrom(dp);
        int dsize = NcStream.readVInt(is);
        DataType dataType = NcStream.decodeDataType(dproto.getDataType());
        Section section = NcStream.decodeSection(dproto.getSection());
        if (dataType == DataType.STRING) {
            Array data = Array.factory(dataType, section.getShape());
            IndexIterator ii = data.getIndexIterator();
            while (ii.hasNext()) {
                int slen = NcStream.readVInt(is);
                byte[] sb = new byte[slen];
                NcStream.readFully(is, sb);
                ii.setObjectNext(new String(sb, "UTF-8"));
            }
            return new DataResult(dproto.getVarName(), section, data);
        }
        if (dataType == DataType.OPAQUE) {
            Array data = Array.factory(dataType, section.getShape());
            IndexIterator ii = data.getIndexIterator();
            while (ii.hasNext()) {
                int slen = NcStream.readVInt(is);
                byte[] sb = new byte[slen];
                NcStream.readFully(is, sb);
                ii.setObjectNext(ByteBuffer.wrap(sb));
            }
            return new DataResult(dproto.getVarName(), section, data);
        }
        byte[] datab = new byte[dsize];
        NcStream.readFully(is, datab);
        ByteBuffer dataBB = ByteBuffer.wrap(datab);
        if (dataType == DataType.STRUCTURE) {
            Structure s = (Structure)ncfile.findVariable(dproto.getVarName());
            StructureMembers members = s.makeStructureMembers();
            ArrayStructureBB data = new ArrayStructureBB(members, section.getShape(), ByteBuffer.wrap(datab), 0);
            ArrayStructureBB.setOffsets(members);
            return new DataResult(dproto.getVarName(), section, data);
        }
        Array data = Array.factory(dataType, section.getShape(), dataBB);
        return new DataResult(dproto.getVarName(), section, data);
    }

    private boolean readAndTest(InputStream is, byte[] test) throws IOException {
        byte[] b = new byte[test.length];
        NcStream.readFully(is, b);
        if (b.length != test.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == test[i]) continue;
            return false;
        }
        return true;
    }

    public NetcdfFile proto2nc(NcStreamProto.Header proto, NetcdfFile ncfile) throws InvalidProtocolBufferException {
        if (ncfile == null) {
            ncfile = new NetcdfFileStream();
        }
        ncfile.setLocation(proto.getLocation());
        if (proto.hasId()) {
            ncfile.setId(proto.getId());
        }
        if (proto.hasTitle()) {
            ncfile.setTitle(proto.getTitle());
        }
        NcStreamProto.Group root = proto.getRoot();
        this.readGroup(root, ncfile, ncfile.getRootGroup());
        ncfile.finish();
        return ncfile;
    }

    private void readGroup(NcStreamProto.Group proto, NetcdfFile ncfile, Group g) throws InvalidProtocolBufferException {
        for (NcStreamProto.Dimension dim : proto.getDimsList()) {
            g.addDimension(NcStream.decodeDim(dim));
        }
        for (NcStreamProto.Attribute att : proto.getAttsList()) {
            g.addAttribute(NcStream.decodeAtt(att));
        }
        for (NcStreamProto.Variable var : proto.getVarsList()) {
            g.addVariable(NcStream.decodeVar(ncfile, g, null, var));
        }
        for (NcStreamProto.Structure s : proto.getStructsList()) {
            g.addVariable(NcStream.decodeStructure(ncfile, g, null, s));
        }
        for (NcStreamProto.Group gp : proto.getGroupsList()) {
            this.readGroup(gp, ncfile, g);
        }
    }

    private class NetcdfFileStream
    extends NetcdfFile {
        private NetcdfFileStream() {
        }
    }

    class DataResult {
        String varName;
        Section section;
        Array data;

        DataResult(String varName, Section section, Array data) {
            this.varName = varName;
            this.section = section;
            this.data = data;
        }
    }
}

