// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   ./tools/json_schema_compiler/compiler.py.

/** @fileoverview Interface for settingsPrivate that can be overriden. */

assertNotReached('Interface file for Closure Compiler should not be executed.');

/** @interface */
function SettingsPrivate() {}

SettingsPrivate.prototype = {
  /**
   * Sets a settings value.
   * @param {string} name The name of the pref.
   * @param {*} value The new value of the pref.
   * @param {string} pageId The user metrics identifier or null.
   * @param {function(boolean):void} callback The callback for whether the pref
   *     was set or not.
   * @see https://developer.chrome.com/extensions/settingsPrivate#method-setPref
   */
  setPref: assertNotReached,

  /**
   * Gets an array of all the prefs.
   * @param {function(!Array<!chrome.settingsPrivate.PrefObject>):void} callback
   * @see https://developer.chrome.com/extensions/settingsPrivate#method-getAllPrefs
   */
  getAllPrefs: assertNotReached,

  /**
   * Gets the value of a specific pref.
   * @param {string} name
   * @param {function(!chrome.settingsPrivate.PrefObject):void} callback
   * @see https://developer.chrome.com/extensions/settingsPrivate#method-getPref
   */
  getPref: assertNotReached,

  /**
   * Gets the page zoom factor as an integer percentage.
   * @param {function(number):void} callback
   * @see https://developer.chrome.com/extensions/settingsPrivate#method-getDefaultZoomPercent
   */
  getDefaultZoomPercent: assertNotReached,

  /**
   * Sets the page zoom factor from a zoom percentage.
   * @param {number} percent
   * @param {function(boolean):void=} callback
   * @see https://developer.chrome.com/extensions/settingsPrivate#method-setDefaultZoomPercent
   */
  setDefaultZoomPercent: assertNotReached,

  /**
   * <p>Fired when a set of prefs has changed.</p><p>|prefs| The prefs that
   * changed.</p>
   * @type {!ChromeEvent}
   * @see https://developer.chrome.com/extensions/settingsPrivate#event-onPrefsChanged
   */
  onPrefsChanged: new ChromeEvent(),
};
