% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bytes.R
\name{bench_bytes}
\alias{bench_bytes}
\alias{as_bench_bytes}
\title{Human readable memory sizes}
\usage{
as_bench_bytes(x)

bench_bytes(x)
}
\arguments{
\item{x}{A numeric or character vector. Character representations can use
shorthand sizes (see examples).}
}
\description{
Construct, manipulate and display vectors of byte sizes. These are numeric
vectors, so you can compare them numerically, but they can also be compared
to human readable values such as '10MB'.
}
\details{
These memory sizes are always assumed to be base 1024, rather than 1000.
}
\examples{
bench_bytes("1")
bench_bytes("1K")
bench_bytes("1Kb")
bench_bytes("1KiB")
bench_bytes("1MB")

bench_bytes("1KB") < "1MB"

sum(bench_bytes(c("1MB", "5MB", "500KB")))
}
