#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"."}
TOP_SRCDIR=${TOP_SRCDIR-"../.."}
DATADIR=${TOP_SRCDIR}/nfem/data
BINDIR="../../nfem/bin"
SBINDIR="../../nfem/sbin"
NPROC_MAX=${NPROC_MAX-"7"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

status=0

#export RHEOPATH=$DATADIR
# --------------------------------------------------------
# using direct surface mesh
# --------------------------------------------------------
run "./helmholtz_s_sphere $DATADIR/circle-gmsh-40 2>/dev/null | RHEOPATH=$DATADIR ./helmholtz_s_sphere_error 2e-2 >/dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi

run "./helmholtz_s_sphere $DATADIR/sphere-gmsh-20 2>/dev/null | RHEOPATH=$DATADIR ./helmholtz_s_sphere_error 2e-2 >/dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi

# --------------------------------------------------------
# building surface mesh from level set (isovalue)
# --------------------------------------------------------
run "$SBINDIR/mkgeo_grid_2d -t 20 -a -2 -b 2 -c -2 -d 2 > square2-20.geo 2>/dev/null"
run "./isovalue_sphere square2-20.geo > square2-20-iso.geo 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./geo_min_aera square2-20-iso.geo >/dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./helmholtz_s_sphere square2-20-iso.geo 2>/dev/null | ./helmholtz_s_sphere_error 8e-1 >/dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi

run "$SBINDIR/mkgeo_grid_3d -T 20 -a -2 -b 2 -c -2 -d 2 -f -2 -g 2 2>/dev/null | $BINDIR/geo -upgrade -geo - > cube2-20.geo 2>/dev/null"
run "./isovalue_sphere cube2-20.geo > cube2-20-iso.geo 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./geo_min_aera cube2-20-iso.geo >/dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./helmholtz_s_sphere cube2-20-iso.geo 2>/dev/null | ./helmholtz_s_sphere_error 3e-1 >/dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi


exit $status

