/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "MkdirCmd.h"
#include "MkdirParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"
#include "svn/CommitInfo.h"
#include "util/Error.h"


MkdirCmd::MkdirCmd( MkdirParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

MkdirCmd::~MkdirCmd()
{
  delete _cb;
}

void MkdirCmd::run()
{
  sc::Error*      err;
  svn::CommitInfo info;

  _prgscb->started( _param, getCancel() );

  err = _client->mkdir( info, _param->getPathsOrUrls() );

  _param->setError( err );
  _prgscb->finished( _param );

  _cb->handleResult( _param, err );
}
