/* Generated by re2c 0.16 */
#line 1 "src/wast-lexer.cc"
/*
 * Copyright 2016 WebAssembly Community Group participants
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "src/wast-lexer.h"

#include <cassert>
#include <cstdio>

#include "config.h"

#include "src/lexer-source.h"
#include "src/wast-parser.h"

#define YYMAXFILL 29

#define INITIAL_LEXER_BUFFER_SIZE (64 * 1024)

#define ERROR(...) parser->Error(GetLocation(), __VA_ARGS__)

#define BEGIN(c) cond = (c)
#define FILL(n)              \
  do {                       \
    if (Failed(Fill((n)))) { \
      RETURN(Eof);           \
    }                        \
  } while (0)

#define MAYBE_MALFORMED_UTF8(desc)                \
  if (!(eof_ && limit_ - cursor_ <= YYMAXFILL)) { \
    ERROR("malformed utf-8%s", desc);             \
  }                                               \
  continue

#define yytext (next_pos_)
#define yyleng (cursor_ - next_pos_)

/* p must be a pointer somewhere in the lexer buffer */
#define FILE_OFFSET(p) ((p) - (buffer_) + buffer_file_offset_)
#define COLUMN(p) (FILE_OFFSET(p) - line_file_offset_ + 1)

#define COMMENT_NESTING (comment_nesting_)
#define NEWLINE                               \
  do {                                        \
    line_++;                                  \
    line_file_offset_ = FILE_OFFSET(cursor_); \
  } while (0)

#define RETURN(token) return Token(GetLocation(), TokenType::token);

#define RETURN_LITERAL(token, literal)          \
  return Token(GetLocation(), TokenType::token, \
               MakeLiteral(LiteralType::literal))

#define RETURN_TYPE(token, type) \
  return Token(GetLocation(), TokenType::token, Type::type)

#define RETURN_OPCODE0(token) \
  return Token(GetLocation(), TokenType::token, Opcode::token)

#define RETURN_OPCODE(token, opcode) \
  return Token(GetLocation(), TokenType::token, Opcode::opcode)

#define RETURN_TEXT(token) \
  return Token(GetLocation(), TokenType::token, GetText())

#define RETURN_TEXT_AT(token, at) \
  return Token(GetLocation(), TokenType::token, GetText(at))

namespace wabt {

WastLexer::WastLexer(std::unique_ptr<LexerSource> source, string_view filename)
    : source_(std::move(source)),
      filename_(filename),
      line_(1),
      comment_nesting_(0),
      buffer_file_offset_(0),
      line_file_offset_(0),
      eof_(false),
      buffer_(nullptr),
      buffer_size_(0),
      marker_(nullptr),
      next_pos_(nullptr),
      cursor_(nullptr),
      limit_(nullptr) {}

WastLexer::~WastLexer() {
  delete[] buffer_;
}

// static
std::unique_ptr<WastLexer> WastLexer::CreateFileLexer(string_view filename) {
  auto source = MakeUnique<LexerSourceFile>(filename);
  if (!source->IsOpen()) {
    return std::unique_ptr<WastLexer>();
  }
  return MakeUnique<WastLexer>(std::move(source), filename);
}

// static
std::unique_ptr<WastLexer> WastLexer::CreateBufferLexer(string_view filename,
                                                        const void* data,
                                                        size_t size) {
  return MakeUnique<WastLexer>(MakeUnique<LexerSourceBuffer>(data, size),
                               filename);
}

Location WastLexer::GetLocation() {
  return Location(filename_, line_, COLUMN(next_pos_), COLUMN(cursor_));
}

Literal WastLexer::MakeLiteral(LiteralType type) {
  return Literal(type, GetText());
}

std::string WastLexer::GetText(size_t offset) {
  return std::string(yytext + offset, yyleng - offset);
}

Result WastLexer::Fill(size_t need) {
  if (eof_) {
    return Result::Error;
  }
  size_t free = next_pos_ - buffer_;
  assert(static_cast<size_t>(cursor_ - buffer_) >= free);
  // Our buffer is too small, need to realloc.
  if (free < need) {
    char* old_buffer = buffer_;
    size_t old_buffer_size = buffer_size_;
    size_t new_buffer_size =
        old_buffer_size ? old_buffer_size * 2 : INITIAL_LEXER_BUFFER_SIZE;
    // Make sure there is enough space for the bytes requested (need) and an
    // additional YYMAXFILL bytes which is needed for the re2c lexer
    // implementation when the eof is reached.
    while ((new_buffer_size - old_buffer_size) + free < need + YYMAXFILL)
      new_buffer_size *= 2;

    char* new_buffer = new char[new_buffer_size];
    if (limit_ > next_pos_) {
      memmove(new_buffer, next_pos_, limit_ - next_pos_);
    }
    buffer_ = new_buffer;
    buffer_size_ = new_buffer_size;
    next_pos_ = new_buffer + (next_pos_ - old_buffer) - free;
    marker_ = new_buffer + (marker_ - old_buffer) - free;
    cursor_ = new_buffer + (cursor_ - old_buffer) - free;
    limit_ = new_buffer + (limit_ - old_buffer) - free;
    buffer_file_offset_ += free;
    free += new_buffer_size - old_buffer_size;
    delete[] old_buffer;
  } else {
    // Shift everything down to make more room in the buffer.
    if (limit_ > next_pos_) {
      memmove(buffer_, next_pos_, limit_ - next_pos_);
    }
    next_pos_ -= free;
    marker_ -= free;
    cursor_ -= free;
    limit_ -= free;
    buffer_file_offset_ += free;
  }
  // Read the new data into the buffer.
  limit_ += source_->Fill(limit_, free);

  // If at the end of file, need to fill YYMAXFILL more characters with "fake
  // characters", that are not a lexeme nor a lexeme suffix. see
  // http://re2c.org/examples/example_03.html.
  if (limit_ < buffer_ + buffer_size_ - YYMAXFILL) {
    eof_ = true;
    // Fill with 0xff, since that is an invalid utf-8 byte.
    memset(limit_, 0xff, YYMAXFILL);
    limit_ += YYMAXFILL;
  }
  return Result::Ok;
}

Token WastLexer::GetToken(WastParser* parser) {
#line 193 "src/prebuilt/wast-lexer-gen.cc"

enum YYCONDTYPE {
	YYCOND_i,
	YYCOND_BAD_TEXT,
	YYCOND_LINE_COMMENT,
	YYCOND_BLOCK_COMMENT,
};

#line 190 "src/wast-lexer.cc"
  YYCONDTYPE cond = YYCOND_i;  // i is the initial state.

  for (;;) {
    next_pos_ = cursor_;
    
#line 208 "src/prebuilt/wast-lexer-gen.cc"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	if (cond < 2) {
		if (cond < 1) {
			goto YYCOND_i;
		} else {
			goto YYCOND_BAD_TEXT;
		}
	} else {
		if (cond < 3) {
			goto YYCOND_LINE_COMMENT;
		} else {
			goto YYCOND_BLOCK_COMMENT;
		}
	}
/* *********************************** */
YYCOND_BAD_TEXT:
	if ((limit_ - cursor_) < 5) FILL(5);
	yych = *cursor_;
	if (yych <= 0x7F) {
		if (yych <= '!') {
			if (yych == '\n') goto yy5;
			if (yych >= ' ') goto yy7;
		} else {
			if (yych <= '"') goto yy9;
			if (yych == '\\') goto yy11;
			goto yy7;
		}
	} else {
		if (yych <= 0xEF) {
			if (yych <= 0xC1) goto yy12;
			if (yych <= 0xDF) goto yy14;
			if (yych <= 0xE0) goto yy15;
			goto yy16;
		} else {
			if (yych <= 0xF0) goto yy17;
			if (yych <= 0xF3) goto yy18;
			if (yych <= 0xF4) goto yy19;
			goto yy12;
		}
	}
	++cursor_;
yy4:
#line 252 "src/wast-lexer.cc"
	{ ERROR("illegal character in string");
                                  continue; }
#line 256 "src/prebuilt/wast-lexer-gen.cc"
yy5:
	++cursor_;
	BEGIN(YYCOND_i);
#line 245 "src/wast-lexer.cc"
	{ ERROR("newline in string");
                                  NEWLINE;
                                  continue; }
#line 264 "src/prebuilt/wast-lexer-gen.cc"
yy7:
	++cursor_;
#line 244 "src/wast-lexer.cc"
	{ continue; }
#line 269 "src/prebuilt/wast-lexer-gen.cc"
yy9:
	++cursor_;
	BEGIN(YYCOND_i);
#line 251 "src/wast-lexer.cc"
	{ RETURN_TEXT(Text); }
#line 275 "src/prebuilt/wast-lexer-gen.cc"
yy11:
	yyaccept = 0;
	yych = *(marker_ = ++cursor_);
	if (yych <= 'f') {
		if (yych <= '/') {
			if (yych <= '!') {
				if (yych == '\n') goto yy4;
				goto yy20;
			} else {
				if (yych <= '"') goto yy7;
				if (yych == '\'') goto yy7;
				goto yy20;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= '9') goto yy22;
				if (yych <= '@') goto yy20;
				goto yy22;
			} else {
				if (yych == '\\') goto yy7;
				if (yych <= '`') goto yy20;
				goto yy22;
			}
		}
	} else {
		if (yych <= 0x7F) {
			if (yych <= 'q') {
				if (yych == 'n') goto yy7;
				goto yy20;
			} else {
				if (yych == 's') goto yy20;
				if (yych <= 't') goto yy7;
				goto yy20;
			}
		} else {
			if (yych <= 0xEF) {
				if (yych <= 0xC1) goto yy4;
				if (yych <= 0xDF) goto yy23;
				if (yych <= 0xE0) goto yy25;
				goto yy26;
			} else {
				if (yych <= 0xF0) goto yy27;
				if (yych <= 0xF3) goto yy28;
				if (yych <= 0xF4) goto yy29;
				goto yy4;
			}
		}
	}
yy12:
	++cursor_;
yy13:
#line 254 "src/wast-lexer.cc"
	{ MAYBE_MALFORMED_UTF8(" in string"); }
#line 329 "src/prebuilt/wast-lexer-gen.cc"
yy14:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy13;
	if (yych <= 0xBF) goto yy7;
	goto yy13;
yy15:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x9F) goto yy13;
	if (yych <= 0xBF) goto yy30;
	goto yy13;
yy16:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy13;
	if (yych <= 0xBF) goto yy30;
	goto yy13;
yy17:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x8F) goto yy13;
	if (yych <= 0xBF) goto yy31;
	goto yy13;
yy18:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy13;
	if (yych <= 0xBF) goto yy31;
	goto yy13;
yy19:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy13;
	if (yych <= 0x8F) goto yy31;
	goto yy13;
yy20:
	++cursor_;
yy21:
#line 248 "src/wast-lexer.cc"
	{ ERROR("bad escape \"%.*s\"",
                                        static_cast<int>(yyleng), yytext);
                                  continue; }
#line 372 "src/prebuilt/wast-lexer-gen.cc"
yy22:
	yych = *++cursor_;
	if (yych <= '@') {
		if (yych <= '/') goto yy21;
		if (yych <= '9') goto yy7;
		goto yy21;
	} else {
		if (yych <= 'F') goto yy7;
		if (yych <= '`') goto yy21;
		if (yych <= 'f') goto yy7;
		goto yy21;
	}
yy23:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy24;
	if (yych <= 0xBF) goto yy20;
yy24:
	cursor_ = marker_;
	if (yyaccept == 0) {
		goto yy4;
	} else {
		goto yy13;
	}
yy25:
	yych = *++cursor_;
	if (yych <= 0x9F) goto yy24;
	if (yych <= 0xBF) goto yy23;
	goto yy24;
yy26:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy24;
	if (yych <= 0xBF) goto yy23;
	goto yy24;
yy27:
	yych = *++cursor_;
	if (yych <= 0x8F) goto yy24;
	if (yych <= 0xBF) goto yy26;
	goto yy24;
yy28:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy24;
	if (yych <= 0xBF) goto yy26;
	goto yy24;
yy29:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy24;
	if (yych <= 0x8F) goto yy26;
	goto yy24;
yy30:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy24;
	if (yych <= 0xBF) goto yy7;
	goto yy24;
yy31:
	++cursor_;
	if ((yych = *cursor_) <= 0x7F) goto yy24;
	if (yych <= 0xBF) goto yy30;
	goto yy24;
/* *********************************** */
YYCOND_BLOCK_COMMENT:
	if ((limit_ - cursor_) < 4) FILL(4);
	yych = *cursor_;
	if (yych <= 0x7F) {
		if (yych <= '\'') {
			if (yych == '\n') goto yy36;
		} else {
			if (yych <= '(') goto yy38;
			if (yych == ';') goto yy39;
		}
	} else {
		if (yych <= 0xEF) {
			if (yych <= 0xC1) goto yy40;
			if (yych <= 0xDF) goto yy42;
			if (yych <= 0xE0) goto yy43;
			goto yy44;
		} else {
			if (yych <= 0xF0) goto yy45;
			if (yych <= 0xF3) goto yy46;
			if (yych <= 0xF4) goto yy47;
			goto yy40;
		}
	}
yy34:
	++cursor_;
yy35:
#line 758 "src/wast-lexer.cc"
	{ continue; }
#line 460 "src/prebuilt/wast-lexer-gen.cc"
yy36:
	++cursor_;
#line 757 "src/wast-lexer.cc"
	{ NEWLINE; continue; }
#line 465 "src/prebuilt/wast-lexer-gen.cc"
yy38:
	yych = *++cursor_;
	if (yych == ';') goto yy48;
	goto yy35;
yy39:
	yych = *++cursor_;
	if (yych == ')') goto yy50;
	goto yy35;
yy40:
	++cursor_;
yy41:
#line 759 "src/wast-lexer.cc"
	{ MAYBE_MALFORMED_UTF8(" in block comment"); }
#line 479 "src/prebuilt/wast-lexer-gen.cc"
yy42:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy41;
	if (yych <= 0xBF) goto yy34;
	goto yy41;
yy43:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x9F) goto yy41;
	if (yych <= 0xBF) goto yy52;
	goto yy41;
yy44:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy41;
	if (yych <= 0xBF) goto yy52;
	goto yy41;
yy45:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x8F) goto yy41;
	if (yych <= 0xBF) goto yy54;
	goto yy41;
yy46:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy41;
	if (yych <= 0xBF) goto yy54;
	goto yy41;
yy47:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy41;
	if (yych <= 0x8F) goto yy54;
	goto yy41;
yy48:
	++cursor_;
#line 752 "src/wast-lexer.cc"
	{ COMMENT_NESTING++; continue; }
#line 514 "src/prebuilt/wast-lexer-gen.cc"
yy50:
	++cursor_;
#line 753 "src/wast-lexer.cc"
	{ if (--COMMENT_NESTING == 0) {
                                    BEGIN(YYCOND_i);
                                  }
                                  continue; }
#line 522 "src/prebuilt/wast-lexer-gen.cc"
yy52:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy53;
	if (yych <= 0xBF) goto yy34;
yy53:
	cursor_ = marker_;
	goto yy41;
yy54:
	++cursor_;
	if ((yych = *cursor_) <= 0x7F) goto yy53;
	if (yych <= 0xBF) goto yy52;
	goto yy53;
/* *********************************** */
YYCOND_LINE_COMMENT:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		if ((limit_ - cursor_) < 2) FILL(2);
		yych = *cursor_;
		if (yybm[0+yych] & 128) {
			goto yy57;
		}
		if (yych <= 0xE0) {
			if (yych <= '\n') goto yy60;
			if (yych <= 0xC1) goto yy62;
			if (yych <= 0xDF) goto yy64;
			goto yy65;
		} else {
			if (yych <= 0xF0) {
				if (yych <= 0xEF) goto yy66;
				goto yy67;
			} else {
				if (yych <= 0xF3) goto yy68;
				if (yych <= 0xF4) goto yy69;
				goto yy62;
			}
		}
yy57:
		yyaccept = 0;
		marker_ = ++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yybm[0+yych] & 128) {
			goto yy57;
		}
		if (yych <= 0xEF) {
			if (yych <= 0xC1) goto yy59;
			if (yych <= 0xDF) goto yy70;
			if (yych <= 0xE0) goto yy72;
			goto yy73;
		} else {
			if (yych <= 0xF0) goto yy74;
			if (yych <= 0xF3) goto yy75;
			if (yych <= 0xF4) goto yy76;
		}
yy59:
#line 750 "src/wast-lexer.cc"
		{ continue; }
#line 613 "src/prebuilt/wast-lexer-gen.cc"
yy60:
		++cursor_;
		BEGIN(YYCOND_i);
#line 749 "src/wast-lexer.cc"
		{ NEWLINE; continue; }
#line 619 "src/prebuilt/wast-lexer-gen.cc"
yy62:
		++cursor_;
yy63:
#line 764 "src/wast-lexer.cc"
		{ MAYBE_MALFORMED_UTF8(""); }
#line 625 "src/prebuilt/wast-lexer-gen.cc"
yy64:
		yych = *++cursor_;
		if (yych <= 0x7F) goto yy63;
		if (yych <= 0xBF) goto yy57;
		goto yy63;
yy65:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x9F) goto yy63;
		if (yych <= 0xBF) goto yy70;
		goto yy63;
yy66:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy63;
		if (yych <= 0xBF) goto yy70;
		goto yy63;
yy67:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x8F) goto yy63;
		if (yych <= 0xBF) goto yy73;
		goto yy63;
yy68:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy63;
		if (yych <= 0xBF) goto yy73;
		goto yy63;
yy69:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy63;
		if (yych <= 0x8F) goto yy73;
		goto yy63;
yy70:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy71;
		if (yych <= 0xBF) goto yy57;
yy71:
		cursor_ = marker_;
		if (yyaccept == 0) {
			goto yy59;
		} else {
			goto yy63;
		}
yy72:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x9F) goto yy71;
		if (yych <= 0xBF) goto yy70;
		goto yy71;
yy73:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy71;
		if (yych <= 0xBF) goto yy70;
		goto yy71;
yy74:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x8F) goto yy71;
		if (yych <= 0xBF) goto yy73;
		goto yy71;
yy75:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy71;
		if (yych <= 0xBF) goto yy73;
		goto yy71;
yy76:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy71;
		if (yych <= 0x8F) goto yy73;
		goto yy71;
	}
/* *********************************** */
YYCOND_i:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   4,   0,   0,   0,   4,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 36, 104,   0, 104, 104, 104, 104, 104, 
			 32,  32, 104, 104,  40, 104, 104, 104, 
			248, 248, 248, 248, 248, 248, 248, 248, 
			248, 248, 104,  32, 104, 104, 104, 104, 
			104, 232, 232, 232, 232, 232, 232, 104, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104, 104,  40,  72,  40, 104, 104, 
			104, 232, 232, 232, 232, 232, 232, 104, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104, 104,  40, 104,  40, 104,  32, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		if ((limit_ - cursor_) < 29) FILL(29);
		yych = *cursor_;
		if (yybm[0+yych] & 4) {
			goto yy81;
		}
		if (yych <= 'e') {
			if (yych <= '+') {
				if (yych <= '#') {
					if (yych <= 0x1F) {
						if (yych <= 0x08) goto yy79;
						if (yych <= '\n') goto yy84;
					} else {
						if (yych == '"') goto yy89;
						goto yy86;
					}
				} else {
					if (yych <= '(') {
						if (yych <= '$') goto yy91;
						if (yych <= '\'') goto yy86;
						goto yy92;
					} else {
						if (yych <= ')') goto yy94;
						if (yych <= '*') goto yy86;
						goto yy96;
					}
				}
			} else {
				if (yych <= ':') {
					if (yych <= '/') {
						if (yych == '-') goto yy96;
						goto yy86;
					} else {
						if (yych <= '0') goto yy97;
						if (yych <= '9') goto yy99;
						goto yy86;
					}
				} else {
					if (yych <= 'a') {
						if (yych <= ';') goto yy101;
						if (yych <= '`') goto yy86;
						goto yy102;
					} else {
						if (yych <= 'b') goto yy103;
						if (yych <= 'c') goto yy104;
						if (yych <= 'd') goto yy105;
						goto yy106;
					}
				}
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'l') {
					if (yych <= 'h') {
						if (yych <= 'f') goto yy107;
						if (yych <= 'g') goto yy108;
						goto yy86;
					} else {
						if (yych <= 'i') goto yy109;
						if (yych <= 'k') goto yy86;
						goto yy110;
					}
				} else {
					if (yych <= 'o') {
						if (yych <= 'm') goto yy111;
						if (yych <= 'n') goto yy112;
						goto yy113;
					} else {
						if (yych <= 'p') goto yy114;
						if (yych <= 'q') goto yy115;
						if (yych <= 'r') goto yy116;
						goto yy117;
					}
				}
			} else {
				if (yych <= 0xC1) {
					if (yych <= 'v') {
						if (yych <= 't') goto yy118;
						if (yych <= 'u') goto yy119;
						goto yy120;
					} else {
						if (yych <= '~') goto yy86;
						if (yych >= 0x80) goto yy121;
					}
				} else {
					if (yych <= 0xEF) {
						if (yych <= 0xDF) goto yy123;
						if (yych <= 0xE0) goto yy124;
						goto yy125;
					} else {
						if (yych <= 0xF0) goto yy126;
						if (yych <= 0xF3) goto yy127;
						if (yych <= 0xF4) goto yy128;
						goto yy121;
					}
				}
			}
		}
yy79:
		++cursor_;
yy80:
#line 763 "src/wast-lexer.cc"
		{ ERROR("unexpected char"); continue; }
#line 849 "src/prebuilt/wast-lexer-gen.cc"
yy81:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yybm[0+yych] & 4) {
			goto yy81;
		}
#line 761 "src/wast-lexer.cc"
		{ continue; }
#line 859 "src/prebuilt/wast-lexer-gen.cc"
yy84:
		++cursor_;
#line 760 "src/wast-lexer.cc"
		{ NEWLINE; continue; }
#line 864 "src/prebuilt/wast-lexer-gen.cc"
yy86:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
yy87:
		if (yybm[0+yych] & 8) {
			goto yy86;
		}
yy88:
#line 762 "src/wast-lexer.cc"
		{ RETURN_TEXT(Reserved); }
#line 876 "src/prebuilt/wast-lexer-gen.cc"
yy89:
		yyaccept = 0;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x1F) goto yy90;
		if (yych <= 0x7F) goto yy130;
		if (yych <= 0xC1) goto yy90;
		if (yych <= 0xF4) goto yy130;
yy90:
		BEGIN(YYCOND_BAD_TEXT);
#line 243 "src/wast-lexer.cc"
		{ continue; }
#line 888 "src/prebuilt/wast-lexer-gen.cc"
yy91:
		yych = *++cursor_;
		if (yych <= '\'') {
			if (yych == '!') goto yy142;
			if (yych <= '"') goto yy88;
			goto yy142;
		} else {
			if (yych <= ':') {
				if (yych <= ')') goto yy88;
				goto yy142;
			} else {
				if (yych <= ';') goto yy88;
				if (yych <= '~') goto yy142;
				goto yy88;
			}
		}
yy92:
		++cursor_;
		if ((yych = *cursor_) == ';') goto yy144;
#line 234 "src/wast-lexer.cc"
		{ RETURN(Lpar); }
#line 910 "src/prebuilt/wast-lexer-gen.cc"
yy94:
		++cursor_;
#line 235 "src/wast-lexer.cc"
		{ RETURN(Rpar); }
#line 915 "src/prebuilt/wast-lexer-gen.cc"
yy96:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych <= '/') goto yy87;
			if (yych <= '0') goto yy146;
			if (yych <= '9') goto yy148;
			goto yy87;
		} else {
			if (yych <= 'i') goto yy150;
			if (yych == 'n') goto yy151;
			goto yy87;
		}
yy97:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 16) {
			goto yy99;
		}
		if (yych <= ';') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych >= '#') goto yy86;
			} else {
				if (yych <= '-') {
					if (yych >= '*') goto yy86;
				} else {
					if (yych <= '.') goto yy152;
					if (yych <= ':') goto yy86;
				}
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy86;
					goto yy154;
				} else {
					if (yych == '_') goto yy155;
					goto yy86;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'e') goto yy154;
					goto yy86;
				} else {
					if (yych <= 'x') goto yy156;
					if (yych <= '~') goto yy86;
				}
			}
		}
yy98:
#line 236 "src/wast-lexer.cc"
		{ RETURN_LITERAL(Nat, Int); }
#line 967 "src/prebuilt/wast-lexer-gen.cc"
yy99:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
		if (yybm[0+yych] & 16) {
			goto yy99;
		}
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych <= '"') goto yy98;
				goto yy86;
			} else {
				if (yych <= ')') goto yy98;
				if (yych == '.') goto yy152;
				goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') goto yy98;
				if (yych == 'E') goto yy154;
				goto yy86;
			} else {
				if (yych <= 'd') {
					if (yych <= '_') goto yy155;
					goto yy86;
				} else {
					if (yych <= 'e') goto yy154;
					if (yych <= '~') goto yy86;
					goto yy98;
				}
			}
		}
yy101:
		yych = *++cursor_;
		if (yych == ';') goto yy157;
		goto yy80;
yy102:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'l') goto yy159;
			if (yych <= 'm') goto yy87;
			goto yy160;
		} else {
			if (yych <= 'r') goto yy87;
			if (yych <= 's') goto yy161;
			if (yych <= 't') goto yy162;
			goto yy87;
		}
yy103:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'i') goto yy163;
			goto yy87;
		} else {
			if (yych <= 'l') goto yy164;
			if (yych == 'r') goto yy165;
			goto yy87;
		}
yy104:
		yych = *++cursor_;
		if (yych == 'a') goto yy167;
		if (yych == 'u') goto yy168;
		goto yy87;
yy105:
		yych = *++cursor_;
		if (yych == 'a') goto yy169;
		if (yych == 'r') goto yy170;
		goto yy87;
yy106:
		yych = *++cursor_;
		if (yych <= 'm') {
			if (yych == 'l') goto yy171;
			goto yy87;
		} else {
			if (yych <= 'n') goto yy172;
			if (yych == 'x') goto yy173;
			goto yy87;
		}
yy107:
		yych = *++cursor_;
		if (yych <= '5') {
			if (yych == '3') goto yy174;
			goto yy87;
		} else {
			if (yych <= '6') goto yy175;
			if (yych == 'u') goto yy176;
			goto yy87;
		}
yy108:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'e') goto yy177;
			goto yy87;
		} else {
			if (yych <= 'l') goto yy178;
			if (yych == 'r') goto yy179;
			goto yy87;
		}
yy109:
		yych = *++cursor_;
		if (yych <= '7') {
			if (yych <= '2') {
				if (yych == '1') goto yy180;
				goto yy87;
			} else {
				if (yych <= '3') goto yy181;
				if (yych == '6') goto yy182;
				goto yy87;
			}
		} else {
			if (yych <= 'f') {
				if (yych <= '8') goto yy183;
				if (yych <= 'e') goto yy87;
				goto yy184;
			} else {
				if (yych <= 'l') goto yy87;
				if (yych <= 'm') goto yy186;
				if (yych <= 'n') goto yy187;
				goto yy87;
			}
		}
yy110:
		yych = *++cursor_;
		if (yych == 'o') goto yy188;
		goto yy87;
yy111:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy189;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy190;
			if (yych == 'u') goto yy191;
			goto yy87;
		}
yy112:
		yych = *++cursor_;
		if (yych == 'a') goto yy192;
		if (yych == 'o') goto yy193;
		goto yy87;
yy113:
		yych = *++cursor_;
		if (yych == 'f') goto yy194;
		goto yy87;
yy114:
		yych = *++cursor_;
		if (yych == 'a') goto yy195;
		goto yy87;
yy115:
		yych = *++cursor_;
		if (yych == 'u') goto yy196;
		goto yy87;
yy116:
		yych = *++cursor_;
		if (yych == 'e') goto yy197;
		goto yy87;
yy117:
		yych = *++cursor_;
		if (yych <= 'g') {
			if (yych == 'e') goto yy198;
			goto yy87;
		} else {
			if (yych <= 'h') goto yy199;
			if (yych == 't') goto yy200;
			goto yy87;
		}
yy118:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy201;
		case 'e':	goto yy202;
		case 'h':	goto yy203;
		case 'r':	goto yy204;
		case 'y':	goto yy205;
		default:	goto yy87;
		}
yy119:
		yych = *++cursor_;
		if (yych == 'n') goto yy206;
		goto yy87;
yy120:
		yych = *++cursor_;
		if (yych == '1') goto yy207;
		if (yych == '8') goto yy208;
		goto yy87;
yy121:
		++cursor_;
yy122:
#line 764 "src/wast-lexer.cc"
		{ MAYBE_MALFORMED_UTF8(""); }
#line 1159 "src/prebuilt/wast-lexer-gen.cc"
yy123:
		yych = *++cursor_;
		if (yych <= 0x7F) goto yy122;
		if (yych <= 0xBF) goto yy79;
		goto yy122;
yy124:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x9F) goto yy122;
		if (yych <= 0xBF) goto yy209;
		goto yy122;
yy125:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy122;
		if (yych <= 0xBF) goto yy209;
		goto yy122;
yy126:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x8F) goto yy122;
		if (yych <= 0xBF) goto yy210;
		goto yy122;
yy127:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy122;
		if (yych <= 0xBF) goto yy210;
		goto yy122;
yy128:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy122;
		if (yych <= 0x8F) goto yy210;
		goto yy122;
yy129:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
yy130:
		if (yybm[0+yych] & 32) {
			goto yy129;
		}
		if (yych <= 0xDF) {
			if (yych <= '"') {
				if (yych >= ' ') goto yy132;
			} else {
				if (yych <= '\\') goto yy134;
				if (yych >= 0xC2) goto yy135;
			}
		} else {
			if (yych <= 0xF0) {
				if (yych <= 0xE0) goto yy136;
				if (yych <= 0xEF) goto yy137;
				goto yy138;
			} else {
				if (yych <= 0xF3) goto yy139;
				if (yych <= 0xF4) goto yy140;
			}
		}
yy131:
		cursor_ = marker_;
		if (yyaccept == 0) {
			goto yy90;
		} else {
			goto yy122;
		}
yy132:
		++cursor_;
#line 242 "src/wast-lexer.cc"
		{ RETURN_TEXT(Text); }
#line 1231 "src/prebuilt/wast-lexer-gen.cc"
yy134:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '[') {
			if (yych <= '\'') {
				if (yych == '"') goto yy129;
				if (yych <= '&') goto yy131;
				goto yy129;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy131;
					goto yy211;
				} else {
					if (yych <= '@') goto yy131;
					if (yych <= 'F') goto yy211;
					goto yy131;
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') {
					if (yych <= '\\') goto yy129;
					goto yy131;
				} else {
					if (yych <= 'f') goto yy211;
					if (yych <= 'm') goto yy131;
					goto yy129;
				}
			} else {
				if (yych <= 'r') {
					if (yych <= 'q') goto yy131;
					goto yy129;
				} else {
					if (yych == 't') goto yy129;
					goto yy131;
				}
			}
		}
yy135:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy131;
		if (yych <= 0xBF) goto yy129;
		goto yy131;
yy136:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x9F) goto yy131;
		if (yych <= 0xBF) goto yy135;
		goto yy131;
yy137:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy131;
		if (yych <= 0xBF) goto yy135;
		goto yy131;
yy138:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x8F) goto yy131;
		if (yych <= 0xBF) goto yy137;
		goto yy131;
yy139:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy131;
		if (yych <= 0xBF) goto yy137;
		goto yy131;
yy140:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy131;
		if (yych <= 0x8F) goto yy137;
		goto yy131;
yy141:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
yy142:
		if (yybm[0+yych] & 64) {
			goto yy141;
		}
		if (yych <= ')') goto yy143;
		if (yych <= ',') goto yy86;
		if (yych <= ';') goto yy143;
		if (yych <= '}') goto yy86;
yy143:
#line 745 "src/wast-lexer.cc"
		{ RETURN_TEXT(Var); }
#line 1328 "src/prebuilt/wast-lexer-gen.cc"
yy144:
		++cursor_;
		BEGIN(YYCOND_BLOCK_COMMENT);
#line 751 "src/wast-lexer.cc"
		{ COMMENT_NESTING = 1; continue; }
#line 1334 "src/prebuilt/wast-lexer-gen.cc"
yy146:
		++cursor_;
		if ((yych = *cursor_) <= ':') {
			if (yych <= ')') {
				if (yych <= '!') {
					if (yych >= '!') goto yy86;
				} else {
					if (yych <= '"') goto yy147;
					if (yych <= '\'') goto yy86;
				}
			} else {
				if (yych <= '.') {
					if (yych <= '-') goto yy86;
					goto yy152;
				} else {
					if (yych <= '/') goto yy86;
					if (yych <= '9') goto yy148;
					goto yy86;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'D') {
					if (yych >= '<') goto yy86;
				} else {
					if (yych <= 'E') goto yy154;
					if (yych <= '^') goto yy86;
					goto yy212;
				}
			} else {
				if (yych <= 'w') {
					if (yych == 'e') goto yy154;
					goto yy86;
				} else {
					if (yych <= 'x') goto yy213;
					if (yych <= '~') goto yy86;
				}
			}
		}
yy147:
#line 237 "src/wast-lexer.cc"
		{ RETURN_LITERAL(Int, Int); }
#line 1377 "src/prebuilt/wast-lexer-gen.cc"
yy148:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych <= '"') goto yy147;
				goto yy86;
			} else {
				if (yych <= '-') {
					if (yych <= ')') goto yy147;
					goto yy86;
				} else {
					if (yych <= '.') goto yy152;
					if (yych <= '/') goto yy86;
					goto yy148;
				}
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') {
					if (yych <= ':') goto yy86;
					goto yy147;
				} else {
					if (yych == 'E') goto yy154;
					goto yy86;
				}
			} else {
				if (yych <= 'd') {
					if (yych <= '_') goto yy212;
					goto yy86;
				} else {
					if (yych <= 'e') goto yy154;
					if (yych <= '~') goto yy86;
					goto yy147;
				}
			}
		}
yy150:
		yych = *++cursor_;
		if (yych == 'n') goto yy214;
		goto yy87;
yy151:
		yych = *++cursor_;
		if (yych == 'a') goto yy192;
		goto yy87;
yy152:
		++cursor_;
		if ((yych = *cursor_) <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy153;
				if (yych <= '/') goto yy86;
				goto yy215;
			}
		} else {
			if (yych <= 'E') {
				if (yych == ';') goto yy153;
				if (yych <= 'D') goto yy86;
				goto yy154;
			} else {
				if (yych == 'e') goto yy154;
				if (yych <= '~') goto yy86;
			}
		}
yy153:
#line 238 "src/wast-lexer.cc"
		{ RETURN_LITERAL(Float, Float); }
#line 1449 "src/prebuilt/wast-lexer-gen.cc"
yy154:
		yych = *++cursor_;
		if (yych <= ',') {
			if (yych == '+') goto yy217;
			goto yy87;
		} else {
			if (yych <= '-') goto yy217;
			if (yych <= '/') goto yy87;
			if (yych <= '9') goto yy218;
			goto yy87;
		}
yy155:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yybm[0+yych] & 16) {
			goto yy99;
		}
		if (yych <= '\'') {
			if (yych == '!') goto yy86;
			if (yych <= '"') goto yy88;
			goto yy86;
		} else {
			if (yych <= ':') {
				if (yych <= ')') goto yy88;
				goto yy86;
			} else {
				if (yych <= ';') goto yy88;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy156:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yybm[0+yych] & 128) {
			goto yy220;
		}
		if (yych <= '\'') {
			if (yych == '!') goto yy86;
			if (yych <= '"') goto yy88;
			goto yy86;
		} else {
			if (yych <= ':') {
				if (yych <= ')') goto yy88;
				goto yy86;
			} else {
				if (yych <= ';') goto yy88;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy157:
		++cursor_;
		BEGIN(YYCOND_LINE_COMMENT);
#line 748 "src/wast-lexer.cc"
		{ continue; }
#line 1508 "src/prebuilt/wast-lexer-gen.cc"
yy159:
		yych = *++cursor_;
		if (yych == 'i') goto yy222;
		goto yy87;
yy160:
		yych = *++cursor_;
		if (yych == 'y') goto yy223;
		goto yy87;
yy161:
		yych = *++cursor_;
		if (yych == 's') goto yy224;
		goto yy87;
yy162:
		yych = *++cursor_;
		if (yych == 'o') goto yy225;
		goto yy87;
yy163:
		yych = *++cursor_;
		if (yych == 'n') goto yy226;
		goto yy87;
yy164:
		yych = *++cursor_;
		if (yych == 'o') goto yy227;
		goto yy87;
yy165:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy166;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy228;
				if (yych <= '~') goto yy86;
			}
		}
yy166:
#line 268 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Br); }
#line 1553 "src/prebuilt/wast-lexer-gen.cc"
yy167:
		yych = *++cursor_;
		if (yych == 'l') goto yy229;
		if (yych == 't') goto yy230;
		goto yy87;
yy168:
		yych = *++cursor_;
		if (yych == 'r') goto yy231;
		goto yy87;
yy169:
		yych = *++cursor_;
		if (yych == 't') goto yy232;
		goto yy87;
yy170:
		yych = *++cursor_;
		if (yych == 'o') goto yy233;
		goto yy87;
yy171:
		yych = *++cursor_;
		if (yych == 'e') goto yy234;
		if (yych == 's') goto yy235;
		goto yy87;
yy172:
		yych = *++cursor_;
		if (yych == 'd') goto yy236;
		goto yy87;
yy173:
		yych = *++cursor_;
		if (yych == 'c') goto yy238;
		if (yych == 'p') goto yy239;
		goto yy87;
yy174:
		yych = *++cursor_;
		if (yych == '2') goto yy240;
		goto yy87;
yy175:
		yych = *++cursor_;
		if (yych == '4') goto yy242;
		goto yy87;
yy176:
		yych = *++cursor_;
		if (yych == 'n') goto yy244;
		goto yy87;
yy177:
		yych = *++cursor_;
		if (yych == 't') goto yy245;
		goto yy87;
yy178:
		yych = *++cursor_;
		if (yych == 'o') goto yy247;
		goto yy87;
yy179:
		yych = *++cursor_;
		if (yych == 'o') goto yy248;
		goto yy87;
yy180:
		yych = *++cursor_;
		if (yych == '6') goto yy249;
		goto yy87;
yy181:
		yych = *++cursor_;
		if (yych == '2') goto yy250;
		goto yy87;
yy182:
		yych = *++cursor_;
		if (yych == '4') goto yy252;
		goto yy87;
yy183:
		yych = *++cursor_;
		if (yych == 'x') goto yy254;
		goto yy87;
yy184:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy185;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy255;
				if (yych <= '~') goto yy86;
			}
		}
yy185:
#line 264 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(If); }
#line 1645 "src/prebuilt/wast-lexer-gen.cc"
yy186:
		yych = *++cursor_;
		if (yych == 'p') goto yy256;
		goto yy87;
yy187:
		yych = *++cursor_;
		if (yych == 'f') goto yy257;
		if (yych == 'v') goto yy259;
		goto yy87;
yy188:
		yych = *++cursor_;
		if (yych == 'c') goto yy260;
		if (yych == 'o') goto yy261;
		goto yy87;
yy189:
		yych = *++cursor_;
		if (yych == 'm') goto yy262;
		goto yy87;
yy190:
		yych = *++cursor_;
		if (yych == 'd') goto yy263;
		goto yy87;
yy191:
		yych = *++cursor_;
		if (yych == 't') goto yy264;
		goto yy87;
yy192:
		yych = *++cursor_;
		if (yych == 'n') goto yy266;
		goto yy87;
yy193:
		yych = *++cursor_;
		if (yych == 'p') goto yy268;
		goto yy87;
yy194:
		yych = *++cursor_;
		if (yych == 'f') goto yy270;
		goto yy87;
yy195:
		yych = *++cursor_;
		if (yych <= 'q') goto yy87;
		if (yych <= 'r') goto yy271;
		if (yych <= 's') goto yy272;
		goto yy87;
yy196:
		yych = *++cursor_;
		if (yych == 'o') goto yy273;
		goto yy87;
yy197:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'g') goto yy274;
			goto yy87;
		} else {
			if (yych <= 's') goto yy275;
			if (yych <= 't') goto yy276;
			goto yy87;
		}
yy198:
		yych = *++cursor_;
		if (yych == 'l') goto yy277;
		if (yych == 't') goto yy278;
		goto yy87;
yy199:
		yych = *++cursor_;
		if (yych == 'a') goto yy279;
		goto yy87;
yy200:
		yych = *++cursor_;
		if (yych == 'a') goto yy280;
		goto yy87;
yy201:
		yych = *++cursor_;
		if (yych == 'b') goto yy281;
		goto yy87;
yy202:
		yych = *++cursor_;
		if (yych == 'e') goto yy282;
		goto yy87;
yy203:
		yych = *++cursor_;
		if (yych == 'e') goto yy283;
		if (yych == 'r') goto yy284;
		goto yy87;
yy204:
		yych = *++cursor_;
		if (yych == 'y') goto yy285;
		goto yy87;
yy205:
		yych = *++cursor_;
		if (yych == 'p') goto yy287;
		goto yy87;
yy206:
		yych = *++cursor_;
		if (yych == 'r') goto yy288;
		goto yy87;
yy207:
		yych = *++cursor_;
		if (yych == '2') goto yy289;
		goto yy87;
yy208:
		yych = *++cursor_;
		if (yych == 'x') goto yy290;
		goto yy87;
yy209:
		yych = *++cursor_;
		if (yych <= 0x7F) goto yy131;
		if (yych <= 0xBF) goto yy79;
		goto yy131;
yy210:
		yych = *++cursor_;
		if (yych <= 0x7F) goto yy131;
		if (yych <= 0xBF) goto yy209;
		goto yy131;
yy211:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '@') {
			if (yych <= '/') goto yy131;
			if (yych <= '9') goto yy129;
			goto yy131;
		} else {
			if (yych <= 'F') goto yy129;
			if (yych <= '`') goto yy131;
			if (yych <= 'f') goto yy129;
			goto yy131;
		}
yy212:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy88;
				goto yy86;
			} else {
				if (yych <= '"') goto yy88;
				if (yych <= '\'') goto yy86;
				goto yy88;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy148;
				goto yy86;
			} else {
				if (yych <= ';') goto yy88;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy213:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy88;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy88;
				if (yych <= '/') goto yy86;
				goto yy291;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy88;
				if (yych <= '@') goto yy86;
				goto yy291;
			} else {
				if (yych <= '`') goto yy86;
				if (yych <= 'f') goto yy291;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy214:
		yych = *++cursor_;
		if (yych == 'f') goto yy257;
		goto yy87;
yy215:
		++cursor_;
		if ((limit_ - cursor_) < 2) FILL(2);
		yych = *cursor_;
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych <= '"') goto yy153;
				goto yy86;
			} else {
				if (yych <= ')') goto yy153;
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy215;
				goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') goto yy153;
				if (yych == 'E') goto yy154;
				goto yy86;
			} else {
				if (yych <= 'd') {
					if (yych <= '_') goto yy293;
					goto yy86;
				} else {
					if (yych <= 'e') goto yy154;
					if (yych <= '~') goto yy86;
					goto yy153;
				}
			}
		}
yy217:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy88;
				goto yy86;
			} else {
				if (yych <= '"') goto yy88;
				if (yych <= '\'') goto yy86;
				goto yy88;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy86;
				if (yych >= ':') goto yy86;
			} else {
				if (yych <= ';') goto yy88;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy218:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy153;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy153;
				goto yy86;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '9') goto yy218;
				if (yych <= ':') goto yy86;
				goto yy153;
			} else {
				if (yych == '_') goto yy217;
				if (yych <= '~') goto yy86;
				goto yy153;
			}
		}
yy220:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
		if (yybm[0+yych] & 128) {
			goto yy220;
		}
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych <= '"') goto yy98;
				goto yy86;
			} else {
				if (yych <= ')') goto yy98;
				if (yych == '.') goto yy294;
				goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') goto yy98;
				if (yych == 'P') goto yy296;
				goto yy86;
			} else {
				if (yych <= 'o') {
					if (yych <= '_') goto yy156;
					goto yy86;
				} else {
					if (yych <= 'p') goto yy296;
					if (yych <= '~') goto yy86;
					goto yy98;
				}
			}
		}
yy222:
		yych = *++cursor_;
		if (yych == 'g') goto yy297;
		goto yy87;
yy223:
		yych = *++cursor_;
		if (yych == 'f') goto yy298;
		goto yy87;
yy224:
		yych = *++cursor_;
		if (yych == 'e') goto yy299;
		goto yy87;
yy225:
		yych = *++cursor_;
		if (yych == 'm') goto yy300;
		goto yy87;
yy226:
		yych = *++cursor_;
		if (yych == 'a') goto yy301;
		goto yy87;
yy227:
		yych = *++cursor_;
		if (yych == 'c') goto yy302;
		goto yy87;
yy228:
		yych = *++cursor_;
		if (yych == 'i') goto yy303;
		if (yych == 't') goto yy304;
		goto yy87;
yy229:
		yych = *++cursor_;
		if (yych == 'l') goto yy305;
		goto yy87;
yy230:
		yych = *++cursor_;
		if (yych == 'c') goto yy307;
		goto yy87;
yy231:
		yych = *++cursor_;
		if (yych == 'r') goto yy308;
		goto yy87;
yy232:
		yych = *++cursor_;
		if (yych == 'a') goto yy309;
		goto yy87;
yy233:
		yych = *++cursor_;
		if (yych == 'p') goto yy311;
		goto yy87;
yy234:
		yych = *++cursor_;
		if (yych == 'm') goto yy313;
		goto yy87;
yy235:
		yych = *++cursor_;
		if (yych == 'e') goto yy315;
		goto yy87;
yy236:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 274 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(End); }
#line 2003 "src/prebuilt/wast-lexer-gen.cc"
yy238:
		yych = *++cursor_;
		if (yych == 'e') goto yy317;
		goto yy87;
yy239:
		yych = *++cursor_;
		if (yych == 'o') goto yy318;
		goto yy87;
yy240:
		++cursor_;
		if ((yych = *cursor_) <= '-') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '.') goto yy319;
				if (yych <= ':') goto yy86;
			} else {
				if (yych == 'x') goto yy320;
				if (yych <= '~') goto yy86;
			}
		}
#line 257 "src/wast-lexer.cc"
		{ RETURN_TYPE(ValueType, F32); }
#line 2032 "src/prebuilt/wast-lexer-gen.cc"
yy242:
		++cursor_;
		if ((yych = *cursor_) <= '-') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '.') goto yy321;
				if (yych <= ':') goto yy86;
			} else {
				if (yych == 'x') goto yy322;
				if (yych <= '~') goto yy86;
			}
		}
#line 258 "src/wast-lexer.cc"
		{ RETURN_TYPE(ValueType, F64); }
#line 2053 "src/prebuilt/wast-lexer-gen.cc"
yy244:
		yych = *++cursor_;
		if (yych == 'c') goto yy323;
		goto yy87;
yy245:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy246;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy325;
				if (yych <= '~') goto yy86;
			}
		}
yy246:
#line 731 "src/wast-lexer.cc"
		{ RETURN(Get); }
#line 2078 "src/prebuilt/wast-lexer-gen.cc"
yy247:
		yych = *++cursor_;
		if (yych == 'b') goto yy326;
		goto yy87;
yy248:
		yych = *++cursor_;
		if (yych == 'w') goto yy327;
		goto yy87;
yy249:
		yych = *++cursor_;
		if (yych == 'x') goto yy328;
		goto yy87;
yy250:
		++cursor_;
		if ((yych = *cursor_) <= '-') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '.') goto yy329;
				if (yych <= ':') goto yy86;
			} else {
				if (yych == 'x') goto yy330;
				if (yych <= '~') goto yy86;
			}
		}
#line 255 "src/wast-lexer.cc"
		{ RETURN_TYPE(ValueType, I32); }
#line 2111 "src/prebuilt/wast-lexer-gen.cc"
yy252:
		++cursor_;
		if ((yych = *cursor_) <= '-') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '.') goto yy331;
				if (yych <= ':') goto yy86;
			} else {
				if (yych == 'x') goto yy332;
				if (yych <= '~') goto yy86;
			}
		}
#line 256 "src/wast-lexer.cc"
		{ RETURN_TYPE(ValueType, I64); }
#line 2132 "src/prebuilt/wast-lexer-gen.cc"
yy254:
		yych = *++cursor_;
		if (yych == '1') goto yy333;
		goto yy87;
yy255:
		yych = *++cursor_;
		if (yych == 'e') goto yy334;
		goto yy87;
yy256:
		yych = *++cursor_;
		if (yych == 'o') goto yy335;
		goto yy87;
yy257:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 240 "src/wast-lexer.cc"
		{ RETURN_LITERAL(Float, Infinity); }
#line 2152 "src/prebuilt/wast-lexer-gen.cc"
yy259:
		yych = *++cursor_;
		if (yych == 'o') goto yy336;
		goto yy87;
yy260:
		yych = *++cursor_;
		if (yych == 'a') goto yy337;
		goto yy87;
yy261:
		yych = *++cursor_;
		if (yych == 'p') goto yy338;
		goto yy87;
yy262:
		yych = *++cursor_;
		if (yych == 'o') goto yy340;
		goto yy87;
yy263:
		yych = *++cursor_;
		if (yych == 'u') goto yy341;
		goto yy87;
yy264:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 261 "src/wast-lexer.cc"
		{ RETURN(Mut); }
#line 2180 "src/prebuilt/wast-lexer-gen.cc"
yy266:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy267;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '9') goto yy86;
				goto yy342;
			} else {
				if (yych <= ';') goto yy267;
				if (yych <= '~') goto yy86;
			}
		}
yy267:
#line 241 "src/wast-lexer.cc"
		{ RETURN_LITERAL(Float, Nan); }
#line 2202 "src/prebuilt/wast-lexer-gen.cc"
yy268:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 262 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Nop); }
#line 2210 "src/prebuilt/wast-lexer-gen.cc"
yy270:
		yych = *++cursor_;
		if (yych == 's') goto yy343;
		goto yy87;
yy271:
		yych = *++cursor_;
		if (yych == 'a') goto yy344;
		goto yy87;
yy272:
		yych = *++cursor_;
		if (yych == 's') goto yy345;
		goto yy87;
yy273:
		yych = *++cursor_;
		if (yych == 't') goto yy346;
		goto yy87;
yy274:
		yych = *++cursor_;
		if (yych == 'i') goto yy347;
		goto yy87;
yy275:
		yych = *++cursor_;
		if (yych == 'u') goto yy348;
		goto yy87;
yy276:
		yych = *++cursor_;
		if (yych == 'h') goto yy349;
		if (yych == 'u') goto yy350;
		goto yy87;
yy277:
		yych = *++cursor_;
		if (yych == 'e') goto yy351;
		goto yy87;
yy278:
		yych = *++cursor_;
		if (yych == '_') goto yy352;
		goto yy87;
yy279:
		yych = *++cursor_;
		if (yych == 'r') goto yy353;
		goto yy87;
yy280:
		yych = *++cursor_;
		if (yych == 'r') goto yy354;
		goto yy87;
yy281:
		yych = *++cursor_;
		if (yych == 'l') goto yy355;
		goto yy87;
yy282:
		yych = *++cursor_;
		if (yych == '_') goto yy356;
		goto yy87;
yy283:
		yych = *++cursor_;
		if (yych == 'n') goto yy357;
		goto yy87;
yy284:
		yych = *++cursor_;
		if (yych == 'o') goto yy359;
		goto yy87;
yy285:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 740 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Try); }
#line 2279 "src/prebuilt/wast-lexer-gen.cc"
yy287:
		yych = *++cursor_;
		if (yych == 'e') goto yy360;
		goto yy87;
yy288:
		yych = *++cursor_;
		if (yych == 'e') goto yy362;
		goto yy87;
yy289:
		yych = *++cursor_;
		if (yych == '8') goto yy363;
		goto yy87;
yy290:
		yych = *++cursor_;
		if (yych == '1') goto yy365;
		goto yy87;
yy291:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
		if (yych <= ';') {
			if (yych <= ')') {
				if (yych <= '!') {
					if (yych <= ' ') goto yy147;
					goto yy86;
				} else {
					if (yych <= '"') goto yy147;
					if (yych <= '\'') goto yy86;
					goto yy147;
				}
			} else {
				if (yych <= '/') {
					if (yych == '.') goto yy294;
					goto yy86;
				} else {
					if (yych <= '9') goto yy291;
					if (yych <= ':') goto yy86;
					goto yy147;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'O') {
					if (yych <= '@') goto yy86;
					if (yych <= 'F') goto yy291;
					goto yy86;
				} else {
					if (yych <= 'P') goto yy296;
					if (yych <= '^') goto yy86;
					goto yy213;
				}
			} else {
				if (yych <= 'o') {
					if (yych <= '`') goto yy86;
					if (yych <= 'f') goto yy291;
					goto yy86;
				} else {
					if (yych <= 'p') goto yy296;
					if (yych <= '~') goto yy86;
					goto yy147;
				}
			}
		}
yy293:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy88;
				goto yy86;
			} else {
				if (yych <= '"') goto yy88;
				if (yych <= '\'') goto yy86;
				goto yy88;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy215;
				goto yy86;
			} else {
				if (yych <= ';') goto yy88;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy294:
		++cursor_;
		if ((yych = *cursor_) <= ';') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych >= '#') goto yy86;
			} else {
				if (yych <= '/') {
					if (yych >= '*') goto yy86;
				} else {
					if (yych <= '9') goto yy366;
					if (yych <= ':') goto yy86;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'F') {
					if (yych <= '@') goto yy86;
					goto yy366;
				} else {
					if (yych == 'P') goto yy296;
					goto yy86;
				}
			} else {
				if (yych <= 'o') {
					if (yych <= 'f') goto yy366;
					goto yy86;
				} else {
					if (yych <= 'p') goto yy296;
					if (yych <= '~') goto yy86;
				}
			}
		}
yy295:
#line 239 "src/wast-lexer.cc"
		{ RETURN_LITERAL(Float, Hexfloat); }
#line 2403 "src/prebuilt/wast-lexer-gen.cc"
yy296:
		yych = *++cursor_;
		if (yych <= ',') {
			if (yych == '+') goto yy368;
			goto yy87;
		} else {
			if (yych <= '-') goto yy368;
			if (yych <= '/') goto yy87;
			if (yych <= '9') goto yy369;
			goto yy87;
		}
yy297:
		yych = *++cursor_;
		if (yych == 'n') goto yy371;
		goto yy87;
yy298:
		yych = *++cursor_;
		if (yych == 'u') goto yy372;
		goto yy87;
yy299:
		yych = *++cursor_;
		if (yych == 'r') goto yy373;
		goto yy87;
yy300:
		yych = *++cursor_;
		if (yych == 'i') goto yy374;
		goto yy87;
yy301:
		yych = *++cursor_;
		if (yych == 'r') goto yy375;
		goto yy87;
yy302:
		yych = *++cursor_;
		if (yych == 'k') goto yy376;
		goto yy87;
yy303:
		yych = *++cursor_;
		if (yych == 'f') goto yy378;
		goto yy87;
yy304:
		yych = *++cursor_;
		if (yych == 'a') goto yy380;
		goto yy87;
yy305:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy306;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy381;
				if (yych <= '~') goto yy86;
			}
		}
yy306:
#line 271 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Call); }
#line 2467 "src/prebuilt/wast-lexer-gen.cc"
yy307:
		yych = *++cursor_;
		if (yych == 'h') goto yy382;
		goto yy87;
yy308:
		yych = *++cursor_;
		if (yych == 'e') goto yy384;
		goto yy87;
yy309:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 723 "src/wast-lexer.cc"
		{ RETURN(Data); }
#line 2483 "src/prebuilt/wast-lexer-gen.cc"
yy311:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 273 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Drop); }
#line 2491 "src/prebuilt/wast-lexer-gen.cc"
yy313:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 722 "src/wast-lexer.cc"
		{ RETURN(Elem); }
#line 2499 "src/prebuilt/wast-lexer-gen.cc"
yy315:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 266 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Else); }
#line 2507 "src/prebuilt/wast-lexer-gen.cc"
yy317:
		yych = *++cursor_;
		if (yych == 'p') goto yy385;
		goto yy87;
yy318:
		yych = *++cursor_;
		if (yych == 'r') goto yy386;
		goto yy87;
yy319:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy387;
		case 'c':	goto yy388;
		case 'd':	goto yy389;
		case 'e':	goto yy390;
		case 'f':	goto yy391;
		case 'g':	goto yy392;
		case 'l':	goto yy393;
		case 'm':	goto yy394;
		case 'n':	goto yy395;
		case 'r':	goto yy396;
		case 's':	goto yy397;
		case 't':	goto yy398;
		default:	goto yy87;
		}
yy320:
		yych = *++cursor_;
		if (yych == '4') goto yy399;
		goto yy87;
yy321:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy400;
		case 'c':	goto yy401;
		case 'd':	goto yy402;
		case 'e':	goto yy403;
		case 'f':	goto yy404;
		case 'g':	goto yy405;
		case 'l':	goto yy406;
		case 'm':	goto yy407;
		case 'n':	goto yy408;
		case 'p':	goto yy409;
		case 'r':	goto yy410;
		case 's':	goto yy411;
		case 't':	goto yy412;
		default:	goto yy87;
		}
yy322:
		yych = *++cursor_;
		if (yych == '2') goto yy413;
		goto yy87;
yy323:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy324;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= 'q') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= 'r') goto yy414;
				if (yych <= '~') goto yy86;
			}
		}
yy324:
#line 711 "src/wast-lexer.cc"
		{ RETURN(Func); }
#line 2579 "src/prebuilt/wast-lexer-gen.cc"
yy325:
		yych = *++cursor_;
		if (yych == 'g') goto yy415;
		if (yych == 'l') goto yy416;
		goto yy87;
yy326:
		yych = *++cursor_;
		if (yych == 'a') goto yy417;
		goto yy87;
yy327:
		yych = *++cursor_;
		if (yych == '_') goto yy418;
		goto yy87;
yy328:
		yych = *++cursor_;
		if (yych == '8') goto yy419;
		goto yy87;
yy329:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy420;
		case 'c':	goto yy421;
		case 'd':	goto yy422;
		case 'e':	goto yy423;
		case 'g':	goto yy424;
		case 'l':	goto yy425;
		case 'm':	goto yy426;
		case 'n':	goto yy427;
		case 'o':	goto yy428;
		case 'p':	goto yy429;
		case 'r':	goto yy430;
		case 's':	goto yy431;
		case 't':	goto yy432;
		case 'w':	goto yy433;
		case 'x':	goto yy434;
		default:	goto yy87;
		}
yy330:
		yych = *++cursor_;
		if (yych == '4') goto yy435;
		goto yy87;
yy331:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy436;
		case 'c':	goto yy437;
		case 'd':	goto yy438;
		case 'e':	goto yy439;
		case 'g':	goto yy440;
		case 'l':	goto yy441;
		case 'm':	goto yy442;
		case 'n':	goto yy443;
		case 'o':	goto yy444;
		case 'p':	goto yy445;
		case 'r':	goto yy446;
		case 's':	goto yy447;
		case 't':	goto yy448;
		case 'x':	goto yy449;
		default:	goto yy87;
		}
yy332:
		yych = *++cursor_;
		if (yych == '2') goto yy450;
		goto yy87;
yy333:
		yych = *++cursor_;
		if (yych == '6') goto yy451;
		goto yy87;
yy334:
		yych = *++cursor_;
		if (yych == 'x') goto yy452;
		goto yy87;
yy335:
		yych = *++cursor_;
		if (yych == 'r') goto yy453;
		goto yy87;
yy336:
		yych = *++cursor_;
		if (yych == 'k') goto yy454;
		goto yy87;
yy337:
		yych = *++cursor_;
		if (yych == 'l') goto yy455;
		goto yy87;
yy338:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 267 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Loop); }
#line 2671 "src/prebuilt/wast-lexer-gen.cc"
yy340:
		yych = *++cursor_;
		if (yych == 'r') goto yy457;
		goto yy87;
yy341:
		yych = *++cursor_;
		if (yych == 'l') goto yy458;
		goto yy87;
yy342:
		yych = *++cursor_;
		if (yych == '0') goto yy459;
		goto yy87;
yy343:
		yych = *++cursor_;
		if (yych == 'e') goto yy460;
		goto yy87;
yy344:
		yych = *++cursor_;
		if (yych == 'm') goto yy461;
		goto yy87;
yy345:
		yych = *++cursor_;
		if (yych == 'i') goto yy463;
		goto yy87;
yy346:
		yych = *++cursor_;
		if (yych == 'e') goto yy464;
		goto yy87;
yy347:
		yych = *++cursor_;
		if (yych == 's') goto yy466;
		goto yy87;
yy348:
		yych = *++cursor_;
		if (yych == 'l') goto yy467;
		goto yy87;
yy349:
		yych = *++cursor_;
		if (yych == 'r') goto yy468;
		goto yy87;
yy350:
		yych = *++cursor_;
		if (yych == 'r') goto yy469;
		goto yy87;
yy351:
		yych = *++cursor_;
		if (yych == 'c') goto yy470;
		goto yy87;
yy352:
		yych = *++cursor_;
		if (yych == 'g') goto yy471;
		if (yych == 'l') goto yy472;
		goto yy87;
yy353:
		yych = *++cursor_;
		if (yych == 'e') goto yy473;
		goto yy87;
yy354:
		yych = *++cursor_;
		if (yych == 't') goto yy474;
		goto yy87;
yy355:
		yych = *++cursor_;
		if (yych == 'e') goto yy476;
		goto yy87;
yy356:
		yych = *++cursor_;
		if (yych == 'l') goto yy478;
		goto yy87;
yy357:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 265 "src/wast-lexer.cc"
		{ RETURN(Then); }
#line 2748 "src/prebuilt/wast-lexer-gen.cc"
yy359:
		yych = *++cursor_;
		if (yych == 'w') goto yy479;
		goto yy87;
yy360:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 710 "src/wast-lexer.cc"
		{ RETURN(Type); }
#line 2760 "src/prebuilt/wast-lexer-gen.cc"
yy362:
		yych = *++cursor_;
		if (yych == 'a') goto yy481;
		goto yy87;
yy363:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy364;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= ':') {
				if (yych == '.') goto yy482;
				goto yy86;
			} else {
				if (yych <= ';') goto yy364;
				if (yych <= '~') goto yy86;
			}
		}
yy364:
#line 259 "src/wast-lexer.cc"
		{ RETURN_TYPE(ValueType, V128); }
#line 2786 "src/prebuilt/wast-lexer-gen.cc"
yy365:
		yych = *++cursor_;
		if (yych == '6') goto yy483;
		goto yy87;
yy366:
		++cursor_;
		if ((limit_ - cursor_) < 2) FILL(2);
		yych = *cursor_;
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '!') {
					if (yych <= ' ') goto yy295;
					goto yy86;
				} else {
					if (yych <= '"') goto yy295;
					if (yych <= '\'') goto yy86;
					goto yy295;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy86;
					goto yy366;
				} else {
					if (yych == ';') goto yy295;
					goto yy86;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'O') {
					if (yych <= 'F') goto yy366;
					goto yy86;
				} else {
					if (yych <= 'P') goto yy296;
					if (yych <= '^') goto yy86;
					goto yy484;
				}
			} else {
				if (yych <= 'o') {
					if (yych <= '`') goto yy86;
					if (yych <= 'f') goto yy366;
					goto yy86;
				} else {
					if (yych <= 'p') goto yy296;
					if (yych <= '~') goto yy86;
					goto yy295;
				}
			}
		}
yy368:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy88;
				goto yy86;
			} else {
				if (yych <= '"') goto yy88;
				if (yych <= '\'') goto yy86;
				goto yy88;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy86;
				if (yych >= ':') goto yy86;
			} else {
				if (yych <= ';') goto yy88;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy369:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy295;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy295;
				goto yy86;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '9') goto yy369;
				if (yych <= ':') goto yy86;
				goto yy295;
			} else {
				if (yych == '_') goto yy368;
				if (yych <= '~') goto yy86;
				goto yy295;
			}
		}
yy371:
		yych = *++cursor_;
		if (yych == '=') goto yy485;
		goto yy87;
yy372:
		yych = *++cursor_;
		if (yych == 'n') goto yy486;
		goto yy87;
yy373:
		yych = *++cursor_;
		if (yych == 't') goto yy487;
		goto yy87;
yy374:
		yych = *++cursor_;
		if (yych == 'c') goto yy488;
		goto yy87;
yy375:
		yych = *++cursor_;
		if (yych == 'y') goto yy489;
		goto yy87;
yy376:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 263 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Block); }
#line 2910 "src/prebuilt/wast-lexer-gen.cc"
yy378:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 269 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(BrIf); }
#line 2918 "src/prebuilt/wast-lexer-gen.cc"
yy380:
		yych = *++cursor_;
		if (yych == 'b') goto yy491;
		goto yy87;
yy381:
		yych = *++cursor_;
		if (yych == 'i') goto yy492;
		goto yy87;
yy382:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 741 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Catch); }
#line 2934 "src/prebuilt/wast-lexer-gen.cc"
yy384:
		yych = *++cursor_;
		if (yych == 'n') goto yy493;
		goto yy87;
yy385:
		yych = *++cursor_;
		if (yych == 't') goto yy494;
		goto yy87;
yy386:
		yych = *++cursor_;
		if (yych == 't') goto yy496;
		goto yy87;
yy387:
		yych = *++cursor_;
		if (yych == 'b') goto yy498;
		if (yych == 'd') goto yy499;
		goto yy87;
yy388:
		yych = *++cursor_;
		if (yych == 'e') goto yy500;
		if (yych == 'o') goto yy501;
		goto yy87;
yy389:
		yych = *++cursor_;
		if (yych == 'e') goto yy502;
		if (yych == 'i') goto yy503;
		goto yy87;
yy390:
		yych = *++cursor_;
		if (yych == 'q') goto yy504;
		goto yy87;
yy391:
		yych = *++cursor_;
		if (yych == 'l') goto yy506;
		goto yy87;
yy392:
		yych = *++cursor_;
		if (yych == 'e') goto yy507;
		if (yych == 't') goto yy509;
		goto yy87;
yy393:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy511;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy513;
			if (yych == 't') goto yy514;
			goto yy87;
		}
yy394:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych == 'a') goto yy516;
			goto yy87;
		} else {
			if (yych <= 'i') goto yy517;
			if (yych == 'u') goto yy518;
			goto yy87;
		}
yy395:
		yych = *++cursor_;
		if (yych == 'e') goto yy519;
		goto yy87;
yy396:
		yych = *++cursor_;
		if (yych == 'e') goto yy521;
		goto yy87;
yy397:
		yych = *++cursor_;
		if (yych <= 's') {
			if (yych == 'q') goto yy522;
			goto yy87;
		} else {
			if (yych <= 't') goto yy523;
			if (yych <= 'u') goto yy524;
			goto yy87;
		}
yy398:
		yych = *++cursor_;
		if (yych == 'r') goto yy525;
		goto yy87;
yy399:
		yych = *++cursor_;
		if (yych == '.') goto yy526;
		goto yy87;
yy400:
		yych = *++cursor_;
		if (yych == 'b') goto yy527;
		if (yych == 'd') goto yy528;
		goto yy87;
yy401:
		yych = *++cursor_;
		if (yych == 'e') goto yy529;
		if (yych == 'o') goto yy530;
		goto yy87;
yy402:
		yych = *++cursor_;
		if (yych == 'i') goto yy531;
		goto yy87;
yy403:
		yych = *++cursor_;
		if (yych == 'q') goto yy532;
		goto yy87;
yy404:
		yych = *++cursor_;
		if (yych == 'l') goto yy534;
		goto yy87;
yy405:
		yych = *++cursor_;
		if (yych == 'e') goto yy535;
		if (yych == 't') goto yy537;
		goto yy87;
yy406:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy539;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy541;
			if (yych == 't') goto yy542;
			goto yy87;
		}
yy407:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych == 'a') goto yy544;
			goto yy87;
		} else {
			if (yych <= 'i') goto yy545;
			if (yych == 'u') goto yy546;
			goto yy87;
		}
yy408:
		yych = *++cursor_;
		if (yych == 'e') goto yy547;
		goto yy87;
yy409:
		yych = *++cursor_;
		if (yych == 'r') goto yy549;
		goto yy87;
yy410:
		yych = *++cursor_;
		if (yych == 'e') goto yy550;
		goto yy87;
yy411:
		yych = *++cursor_;
		if (yych <= 's') {
			if (yych == 'q') goto yy551;
			goto yy87;
		} else {
			if (yych <= 't') goto yy552;
			if (yych <= 'u') goto yy553;
			goto yy87;
		}
yy412:
		yych = *++cursor_;
		if (yych == 'r') goto yy554;
		goto yy87;
yy413:
		yych = *++cursor_;
		if (yych == '.') goto yy555;
		goto yy87;
yy414:
		yych = *++cursor_;
		if (yych == 'e') goto yy556;
		goto yy87;
yy415:
		yych = *++cursor_;
		if (yych == 'l') goto yy557;
		goto yy87;
yy416:
		yych = *++cursor_;
		if (yych == 'o') goto yy558;
		goto yy87;
yy417:
		yych = *++cursor_;
		if (yych == 'l') goto yy559;
		goto yy87;
yy418:
		yych = *++cursor_;
		if (yych == 'm') goto yy561;
		goto yy87;
yy419:
		yych = *++cursor_;
		if (yych == '.') goto yy562;
		goto yy87;
yy420:
		yych = *++cursor_;
		if (yych <= 'm') {
			if (yych == 'd') goto yy563;
			goto yy87;
		} else {
			if (yych <= 'n') goto yy564;
			if (yych == 't') goto yy565;
			goto yy87;
		}
yy421:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'l') goto yy566;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy567;
			if (yych == 't') goto yy568;
			goto yy87;
		}
yy422:
		yych = *++cursor_;
		if (yych == 'i') goto yy569;
		goto yy87;
yy423:
		yych = *++cursor_;
		if (yych == 'q') goto yy570;
		if (yych == 'x') goto yy572;
		goto yy87;
yy424:
		yych = *++cursor_;
		if (yych == 'e') goto yy573;
		if (yych == 't') goto yy574;
		goto yy87;
yy425:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy575;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy576;
			if (yych == 't') goto yy577;
			goto yy87;
		}
yy426:
		yych = *++cursor_;
		if (yych == 'u') goto yy578;
		goto yy87;
yy427:
		yych = *++cursor_;
		if (yych == 'e') goto yy579;
		goto yy87;
yy428:
		yych = *++cursor_;
		if (yych == 'r') goto yy581;
		goto yy87;
yy429:
		yych = *++cursor_;
		if (yych == 'o') goto yy583;
		goto yy87;
yy430:
		yych = *++cursor_;
		if (yych == 'e') goto yy584;
		if (yych == 'o') goto yy585;
		goto yy87;
yy431:
		yych = *++cursor_;
		if (yych <= 's') {
			if (yych == 'h') goto yy586;
			goto yy87;
		} else {
			if (yych <= 't') goto yy587;
			if (yych <= 'u') goto yy588;
			goto yy87;
		}
yy432:
		yych = *++cursor_;
		if (yych == 'r') goto yy589;
		goto yy87;
yy433:
		yych = *++cursor_;
		if (yych == 'r') goto yy590;
		goto yy87;
yy434:
		yych = *++cursor_;
		if (yych == 'o') goto yy591;
		goto yy87;
yy435:
		yych = *++cursor_;
		if (yych == '.') goto yy592;
		goto yy87;
yy436:
		yych = *++cursor_;
		if (yych <= 'm') {
			if (yych == 'd') goto yy593;
			goto yy87;
		} else {
			if (yych <= 'n') goto yy594;
			if (yych == 't') goto yy595;
			goto yy87;
		}
yy437:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'l') goto yy596;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy597;
			if (yych == 't') goto yy598;
			goto yy87;
		}
yy438:
		yych = *++cursor_;
		if (yych == 'i') goto yy599;
		goto yy87;
yy439:
		yych = *++cursor_;
		if (yych == 'q') goto yy600;
		if (yych == 'x') goto yy602;
		goto yy87;
yy440:
		yych = *++cursor_;
		if (yych == 'e') goto yy603;
		if (yych == 't') goto yy604;
		goto yy87;
yy441:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy605;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy606;
			if (yych == 't') goto yy607;
			goto yy87;
		}
yy442:
		yych = *++cursor_;
		if (yych == 'u') goto yy608;
		goto yy87;
yy443:
		yych = *++cursor_;
		if (yych == 'e') goto yy609;
		goto yy87;
yy444:
		yych = *++cursor_;
		if (yych == 'r') goto yy611;
		goto yy87;
yy445:
		yych = *++cursor_;
		if (yych == 'o') goto yy613;
		goto yy87;
yy446:
		yych = *++cursor_;
		if (yych == 'e') goto yy614;
		if (yych == 'o') goto yy615;
		goto yy87;
yy447:
		yych = *++cursor_;
		if (yych <= 's') {
			if (yych == 'h') goto yy616;
			goto yy87;
		} else {
			if (yych <= 't') goto yy617;
			if (yych <= 'u') goto yy618;
			goto yy87;
		}
yy448:
		yych = *++cursor_;
		if (yych == 'r') goto yy619;
		goto yy87;
yy449:
		yych = *++cursor_;
		if (yych == 'o') goto yy620;
		goto yy87;
yy450:
		yych = *++cursor_;
		if (yych == '.') goto yy621;
		goto yy87;
yy451:
		yych = *++cursor_;
		if (yych == '.') goto yy622;
		goto yy87;
yy452:
		yych = *++cursor_;
		if (yych == 'c') goto yy623;
		goto yy87;
yy453:
		yych = *++cursor_;
		if (yych == 't') goto yy624;
		goto yy87;
yy454:
		yych = *++cursor_;
		if (yych == 'e') goto yy626;
		goto yy87;
yy455:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy456;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= ':') {
				if (yych == '.') goto yy628;
				goto yy86;
			} else {
				if (yych <= ';') goto yy456;
				if (yych <= '~') goto yy86;
			}
		}
yy456:
#line 714 "src/wast-lexer.cc"
		{ RETURN(Local); }
#line 3337 "src/prebuilt/wast-lexer-gen.cc"
yy457:
		yych = *++cursor_;
		if (yych == 'y') goto yy629;
		goto yy87;
yy458:
		yych = *++cursor_;
		if (yych == 'e') goto yy631;
		goto yy87;
yy459:
		yych = *++cursor_;
		if (yych == 'x') goto yy633;
		goto yy87;
yy460:
		yych = *++cursor_;
		if (yych == 't') goto yy634;
		goto yy87;
yy461:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 712 "src/wast-lexer.cc"
		{ RETURN(Param); }
#line 3361 "src/prebuilt/wast-lexer-gen.cc"
yy463:
		yych = *++cursor_;
		if (yych == 'v') goto yy636;
		goto yy87;
yy464:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 718 "src/wast-lexer.cc"
		{ RETURN(Quote); }
#line 3373 "src/prebuilt/wast-lexer-gen.cc"
yy466:
		yych = *++cursor_;
		if (yych == 't') goto yy637;
		goto yy87;
yy467:
		yych = *++cursor_;
		if (yych == 't') goto yy638;
		goto yy87;
yy468:
		yych = *++cursor_;
		if (yych == 'o') goto yy640;
		goto yy87;
yy469:
		yych = *++cursor_;
		if (yych == 'n') goto yy641;
		goto yy87;
yy470:
		yych = *++cursor_;
		if (yych == 't') goto yy643;
		goto yy87;
yy471:
		yych = *++cursor_;
		if (yych == 'l') goto yy645;
		goto yy87;
yy472:
		yych = *++cursor_;
		if (yych == 'o') goto yy646;
		goto yy87;
yy473:
		yych = *++cursor_;
		if (yych == 'd') goto yy647;
		goto yy87;
yy474:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 721 "src/wast-lexer.cc"
		{ RETURN(Start); }
#line 3413 "src/prebuilt/wast-lexer-gen.cc"
yy476:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy477;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= ':') {
				if (yych == '.') goto yy649;
				goto yy86;
			} else {
				if (yych <= ';') goto yy477;
				if (yych <= '~') goto yy86;
			}
		}
yy477:
#line 719 "src/wast-lexer.cc"
		{ RETURN(Table); }
#line 3435 "src/prebuilt/wast-lexer-gen.cc"
yy478:
		yych = *++cursor_;
		if (yych == 'o') goto yy650;
		goto yy87;
yy479:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 742 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Throw); }
#line 3447 "src/prebuilt/wast-lexer-gen.cc"
yy481:
		yych = *++cursor_;
		if (yych == 'c') goto yy651;
		goto yy87;
yy482:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy652;
		case 'b':	goto yy653;
		case 'c':	goto yy654;
		case 'l':	goto yy655;
		case 'n':	goto yy656;
		case 'o':	goto yy657;
		case 's':	goto yy658;
		case 'x':	goto yy659;
		default:	goto yy87;
		}
yy483:
		yych = *++cursor_;
		if (yych == '.') goto yy660;
		goto yy87;
yy484:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy88;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy88;
				if (yych <= '/') goto yy86;
				goto yy366;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy88;
				if (yych <= '@') goto yy86;
				goto yy366;
			} else {
				if (yych <= '`') goto yy86;
				if (yych <= 'f') goto yy366;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy485:
		yych = *++cursor_;
		if (yych <= '/') goto yy87;
		if (yych <= '0') goto yy661;
		if (yych <= '9') goto yy663;
		goto yy87;
yy486:
		yych = *++cursor_;
		if (yych == 'c') goto yy665;
		goto yy87;
yy487:
		yych = *++cursor_;
		if (yych == '_') goto yy667;
		goto yy87;
yy488:
		yych = *++cursor_;
		if (yych == '.') goto yy668;
		goto yy87;
yy489:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 717 "src/wast-lexer.cc"
		{ RETURN(Bin); }
#line 3520 "src/prebuilt/wast-lexer-gen.cc"
yy491:
		yych = *++cursor_;
		if (yych == 'l') goto yy669;
		goto yy87;
yy492:
		yych = *++cursor_;
		if (yych == 'n') goto yy670;
		goto yy87;
yy493:
		yych = *++cursor_;
		if (yych == 't') goto yy671;
		goto yy87;
yy494:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 727 "src/wast-lexer.cc"
		{ RETURN(Except); }
#line 3540 "src/prebuilt/wast-lexer-gen.cc"
yy496:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 726 "src/wast-lexer.cc"
		{ RETURN(Export); }
#line 3548 "src/prebuilt/wast-lexer-gen.cc"
yy498:
		yych = *++cursor_;
		if (yych == 's') goto yy672;
		goto yy87;
yy499:
		yych = *++cursor_;
		if (yych == 'd') goto yy674;
		goto yy87;
yy500:
		yych = *++cursor_;
		if (yych == 'i') goto yy676;
		goto yy87;
yy501:
		yych = *++cursor_;
		if (yych == 'n') goto yy677;
		if (yych == 'p') goto yy678;
		goto yy87;
yy502:
		yych = *++cursor_;
		if (yych == 'm') goto yy679;
		goto yy87;
yy503:
		yych = *++cursor_;
		if (yych == 'v') goto yy680;
		goto yy87;
yy504:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 401 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32Eq); }
#line 3581 "src/prebuilt/wast-lexer-gen.cc"
yy506:
		yych = *++cursor_;
		if (yych == 'o') goto yy682;
		goto yy87;
yy507:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 411 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32Ge); }
#line 3593 "src/prebuilt/wast-lexer-gen.cc"
yy509:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 409 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32Gt); }
#line 3601 "src/prebuilt/wast-lexer-gen.cc"
yy511:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 407 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32Le); }
#line 3609 "src/prebuilt/wast-lexer-gen.cc"
yy513:
		yych = *++cursor_;
		if (yych == 'a') goto yy683;
		goto yy87;
yy514:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 405 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32Lt); }
#line 3621 "src/prebuilt/wast-lexer-gen.cc"
yy516:
		yych = *++cursor_;
		if (yych == 'x') goto yy684;
		goto yy87;
yy517:
		yych = *++cursor_;
		if (yych == 'n') goto yy686;
		goto yy87;
yy518:
		yych = *++cursor_;
		if (yych == 'l') goto yy688;
		goto yy87;
yy519:
		++cursor_;
		if ((yych = *cursor_) <= ':') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= 'a') {
				if (yych <= ';') goto yy520;
				if (yych <= '`') goto yy86;
				goto yy690;
			} else {
				if (yych == 'g') goto yy691;
				if (yych <= '~') goto yy86;
			}
		}
yy520:
#line 403 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32Ne); }
#line 3656 "src/prebuilt/wast-lexer-gen.cc"
yy521:
		yych = *++cursor_;
		if (yych == 'i') goto yy693;
		goto yy87;
yy522:
		yych = *++cursor_;
		if (yych == 'r') goto yy694;
		goto yy87;
yy523:
		yych = *++cursor_;
		if (yych == 'o') goto yy695;
		goto yy87;
yy524:
		yych = *++cursor_;
		if (yych == 'b') goto yy696;
		goto yy87;
yy525:
		yych = *++cursor_;
		if (yych == 'u') goto yy698;
		goto yy87;
yy526:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy699;
		case 'c':	goto yy700;
		case 'd':	goto yy701;
		case 'e':	goto yy702;
		case 'g':	goto yy703;
		case 'l':	goto yy704;
		case 'm':	goto yy705;
		case 'n':	goto yy706;
		case 'r':	goto yy707;
		case 's':	goto yy708;
		default:	goto yy87;
		}
yy527:
		yych = *++cursor_;
		if (yych == 's') goto yy709;
		goto yy87;
yy528:
		yych = *++cursor_;
		if (yych == 'd') goto yy711;
		goto yy87;
yy529:
		yych = *++cursor_;
		if (yych == 'i') goto yy713;
		goto yy87;
yy530:
		yych = *++cursor_;
		if (yych == 'n') goto yy714;
		if (yych == 'p') goto yy715;
		goto yy87;
yy531:
		yych = *++cursor_;
		if (yych == 'v') goto yy716;
		goto yy87;
yy532:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 402 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64Eq); }
#line 3720 "src/prebuilt/wast-lexer-gen.cc"
yy534:
		yych = *++cursor_;
		if (yych == 'o') goto yy718;
		goto yy87;
yy535:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 412 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64Ge); }
#line 3732 "src/prebuilt/wast-lexer-gen.cc"
yy537:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 410 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64Gt); }
#line 3740 "src/prebuilt/wast-lexer-gen.cc"
yy539:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 408 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64Le); }
#line 3748 "src/prebuilt/wast-lexer-gen.cc"
yy541:
		yych = *++cursor_;
		if (yych == 'a') goto yy719;
		goto yy87;
yy542:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 406 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64Lt); }
#line 3760 "src/prebuilt/wast-lexer-gen.cc"
yy544:
		yych = *++cursor_;
		if (yych == 'x') goto yy720;
		goto yy87;
yy545:
		yych = *++cursor_;
		if (yych == 'n') goto yy722;
		goto yy87;
yy546:
		yych = *++cursor_;
		if (yych == 'l') goto yy724;
		goto yy87;
yy547:
		++cursor_;
		if ((yych = *cursor_) <= ':') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= 'a') {
				if (yych <= ';') goto yy548;
				if (yych <= '`') goto yy86;
				goto yy726;
			} else {
				if (yych == 'g') goto yy727;
				if (yych <= '~') goto yy86;
			}
		}
yy548:
#line 404 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64Ne); }
#line 3795 "src/prebuilt/wast-lexer-gen.cc"
yy549:
		yych = *++cursor_;
		if (yych == 'o') goto yy729;
		goto yy87;
yy550:
		yych = *++cursor_;
		if (yych == 'i') goto yy730;
		goto yy87;
yy551:
		yych = *++cursor_;
		if (yych == 'r') goto yy731;
		goto yy87;
yy552:
		yych = *++cursor_;
		if (yych == 'o') goto yy732;
		goto yy87;
yy553:
		yych = *++cursor_;
		if (yych == 'b') goto yy733;
		goto yy87;
yy554:
		yych = *++cursor_;
		if (yych == 'u') goto yy735;
		goto yy87;
yy555:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy736;
		case 'c':	goto yy737;
		case 'd':	goto yy738;
		case 'e':	goto yy739;
		case 'g':	goto yy740;
		case 'l':	goto yy741;
		case 'm':	goto yy742;
		case 'n':	goto yy743;
		case 'r':	goto yy744;
		case 's':	goto yy745;
		default:	goto yy87;
		}
yy556:
		yych = *++cursor_;
		if (yych == 'f') goto yy746;
		goto yy87;
yy557:
		yych = *++cursor_;
		if (yych == 'o') goto yy748;
		goto yy87;
yy558:
		yych = *++cursor_;
		if (yych == 'c') goto yy749;
		goto yy87;
yy559:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy560;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= ':') {
				if (yych == '.') goto yy750;
				goto yy86;
			} else {
				if (yych <= ';') goto yy560;
				if (yych <= '~') goto yy86;
			}
		}
yy560:
#line 715 "src/wast-lexer.cc"
		{ RETURN(Global); }
#line 3868 "src/prebuilt/wast-lexer-gen.cc"
yy561:
		yych = *++cursor_;
		if (yych == 'e') goto yy751;
		goto yy87;
yy562:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy752;
		case 'e':	goto yy753;
		case 'g':	goto yy754;
		case 'l':	goto yy755;
		case 'm':	goto yy756;
		case 'n':	goto yy757;
		case 'r':	goto yy758;
		case 's':	goto yy759;
		default:	goto yy87;
		}
yy563:
		yych = *++cursor_;
		if (yych == 'd') goto yy760;
		goto yy87;
yy564:
		yych = *++cursor_;
		if (yych == 'd') goto yy762;
		goto yy87;
yy565:
		yych = *++cursor_;
		if (yych == 'o') goto yy764;
		goto yy87;
yy566:
		yych = *++cursor_;
		if (yych == 'z') goto yy765;
		goto yy87;
yy567:
		yych = *++cursor_;
		if (yych == 'n') goto yy767;
		goto yy87;
yy568:
		yych = *++cursor_;
		if (yych == 'z') goto yy768;
		goto yy87;
yy569:
		yych = *++cursor_;
		if (yych == 'v') goto yy770;
		goto yy87;
yy570:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy571;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= 'y') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= 'z') goto yy771;
				if (yych <= '~') goto yy86;
			}
		}
yy571:
#line 381 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32Eq); }
#line 3934 "src/prebuilt/wast-lexer-gen.cc"
yy572:
		yych = *++cursor_;
		if (yych == 't') goto yy773;
		goto yy87;
yy573:
		yych = *++cursor_;
		if (yych == '_') goto yy774;
		goto yy87;
yy574:
		yych = *++cursor_;
		if (yych == '_') goto yy775;
		goto yy87;
yy575:
		yych = *++cursor_;
		if (yych == '_') goto yy776;
		goto yy87;
yy576:
		yych = *++cursor_;
		if (yych == 'a') goto yy777;
		goto yy87;
yy577:
		yych = *++cursor_;
		if (yych == '_') goto yy778;
		goto yy87;
yy578:
		yych = *++cursor_;
		if (yych == 'l') goto yy779;
		goto yy87;
yy579:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 383 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32Ne); }
#line 3970 "src/prebuilt/wast-lexer-gen.cc"
yy581:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 353 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Or); }
#line 3978 "src/prebuilt/wast-lexer-gen.cc"
yy583:
		yych = *++cursor_;
		if (yych == 'p') goto yy781;
		goto yy87;
yy584:
		yych = *++cursor_;
		if (yych == 'i') goto yy782;
		if (yych == 'm') goto yy783;
		goto yy87;
yy585:
		yych = *++cursor_;
		if (yych == 't') goto yy784;
		goto yy87;
yy586:
		yych = *++cursor_;
		if (yych == 'l') goto yy785;
		if (yych == 'r') goto yy787;
		goto yy87;
yy587:
		yych = *++cursor_;
		if (yych == 'o') goto yy788;
		goto yy87;
yy588:
		yych = *++cursor_;
		if (yych == 'b') goto yy789;
		goto yy87;
yy589:
		yych = *++cursor_;
		if (yych == 'u') goto yy791;
		goto yy87;
yy590:
		yych = *++cursor_;
		if (yych == 'a') goto yy792;
		goto yy87;
yy591:
		yych = *++cursor_;
		if (yych == 'r') goto yy793;
		goto yy87;
yy592:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy795;
		case 'e':	goto yy796;
		case 'g':	goto yy797;
		case 'l':	goto yy798;
		case 'm':	goto yy799;
		case 'n':	goto yy800;
		case 'r':	goto yy801;
		case 's':	goto yy802;
		case 't':	goto yy803;
		default:	goto yy87;
		}
yy593:
		yych = *++cursor_;
		if (yych == 'd') goto yy804;
		goto yy87;
yy594:
		yych = *++cursor_;
		if (yych == 'd') goto yy806;
		goto yy87;
yy595:
		yych = *++cursor_;
		if (yych == 'o') goto yy808;
		goto yy87;
yy596:
		yych = *++cursor_;
		if (yych == 'z') goto yy809;
		goto yy87;
yy597:
		yych = *++cursor_;
		if (yych == 'n') goto yy811;
		goto yy87;
yy598:
		yych = *++cursor_;
		if (yych == 'z') goto yy812;
		goto yy87;
yy599:
		yych = *++cursor_;
		if (yych == 'v') goto yy814;
		goto yy87;
yy600:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy601;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= 'y') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= 'z') goto yy815;
				if (yych <= '~') goto yy86;
			}
		}
yy601:
#line 382 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64Eq); }
#line 4079 "src/prebuilt/wast-lexer-gen.cc"
yy602:
		yych = *++cursor_;
		if (yych == 't') goto yy817;
		goto yy87;
yy603:
		yych = *++cursor_;
		if (yych == '_') goto yy818;
		goto yy87;
yy604:
		yych = *++cursor_;
		if (yych == '_') goto yy819;
		goto yy87;
yy605:
		yych = *++cursor_;
		if (yych == '_') goto yy820;
		goto yy87;
yy606:
		yych = *++cursor_;
		if (yych == 'a') goto yy821;
		goto yy87;
yy607:
		yych = *++cursor_;
		if (yych == '_') goto yy822;
		goto yy87;
yy608:
		yych = *++cursor_;
		if (yych == 'l') goto yy823;
		goto yy87;
yy609:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 384 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64Ne); }
#line 4115 "src/prebuilt/wast-lexer-gen.cc"
yy611:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 354 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Or); }
#line 4123 "src/prebuilt/wast-lexer-gen.cc"
yy613:
		yych = *++cursor_;
		if (yych == 'p') goto yy825;
		goto yy87;
yy614:
		yych = *++cursor_;
		if (yych == 'i') goto yy826;
		if (yych == 'm') goto yy827;
		goto yy87;
yy615:
		yych = *++cursor_;
		if (yych == 't') goto yy828;
		goto yy87;
yy616:
		yych = *++cursor_;
		if (yych == 'l') goto yy829;
		if (yych == 'r') goto yy831;
		goto yy87;
yy617:
		yych = *++cursor_;
		if (yych == 'o') goto yy832;
		goto yy87;
yy618:
		yych = *++cursor_;
		if (yych == 'b') goto yy833;
		goto yy87;
yy619:
		yych = *++cursor_;
		if (yych == 'u') goto yy835;
		goto yy87;
yy620:
		yych = *++cursor_;
		if (yych == 'r') goto yy836;
		goto yy87;
yy621:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy838;
		case 'e':	goto yy839;
		case 'n':	goto yy840;
		case 'r':	goto yy841;
		case 's':	goto yy842;
		case 't':	goto yy843;
		default:	goto yy87;
		}
yy622:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy844;
		case 'e':	goto yy845;
		case 'g':	goto yy846;
		case 'l':	goto yy847;
		case 'm':	goto yy848;
		case 'n':	goto yy849;
		case 'r':	goto yy850;
		case 's':	goto yy851;
		default:	goto yy87;
		}
yy623:
		yych = *++cursor_;
		if (yych == 'e') goto yy852;
		goto yy87;
yy624:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 725 "src/wast-lexer.cc"
		{ RETURN(Import); }
#line 4193 "src/prebuilt/wast-lexer-gen.cc"
yy626:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 730 "src/wast-lexer.cc"
		{ RETURN(Invoke); }
#line 4201 "src/prebuilt/wast-lexer-gen.cc"
yy628:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'g') goto yy853;
			goto yy87;
		} else {
			if (yych <= 's') goto yy854;
			if (yych <= 't') goto yy855;
			goto yy87;
		}
yy629:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy630;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= ':') {
				if (yych == '.') goto yy856;
				goto yy86;
			} else {
				if (yych <= ';') goto yy630;
				if (yych <= '~') goto yy86;
			}
		}
yy630:
#line 720 "src/wast-lexer.cc"
		{ RETURN(Memory); }
#line 4233 "src/prebuilt/wast-lexer-gen.cc"
yy631:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 716 "src/wast-lexer.cc"
		{ RETURN(Module); }
#line 4241 "src/prebuilt/wast-lexer-gen.cc"
yy633:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy88;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy88;
				if (yych <= '/') goto yy86;
				goto yy857;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy88;
				if (yych <= '@') goto yy86;
				goto yy857;
			} else {
				if (yych <= '`') goto yy86;
				if (yych <= 'f') goto yy857;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy634:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy635;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '<') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '=') goto yy859;
				if (yych <= '~') goto yy86;
			}
		}
yy635:
#line 724 "src/wast-lexer.cc"
		{ RETURN(Offset); }
#line 4288 "src/prebuilt/wast-lexer-gen.cc"
yy636:
		yych = *++cursor_;
		if (yych == 'e') goto yy860;
		goto yy87;
yy637:
		yych = *++cursor_;
		if (yych == 'e') goto yy862;
		goto yy87;
yy638:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 713 "src/wast-lexer.cc"
		{ RETURN(Result); }
#line 4304 "src/prebuilt/wast-lexer-gen.cc"
yy640:
		yych = *++cursor_;
		if (yych == 'w') goto yy863;
		goto yy87;
yy641:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy642;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy865;
				if (yych <= '~') goto yy86;
			}
		}
yy642:
#line 275 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Return); }
#line 4329 "src/prebuilt/wast-lexer-gen.cc"
yy643:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 446 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Select); }
#line 4337 "src/prebuilt/wast-lexer-gen.cc"
yy645:
		yych = *++cursor_;
		if (yych == 'o') goto yy866;
		goto yy87;
yy646:
		yych = *++cursor_;
		if (yych == 'c') goto yy867;
		goto yy87;
yy647:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 746 "src/wast-lexer.cc"
		{ RETURN(Shared); }
#line 4353 "src/prebuilt/wast-lexer-gen.cc"
yy649:
		yych = *++cursor_;
		if (yych <= 'd') {
			if (yych <= 'b') goto yy87;
			if (yych <= 'c') goto yy868;
			goto yy869;
		} else {
			if (yych == 'i') goto yy870;
			goto yy87;
		}
yy650:
		yych = *++cursor_;
		if (yych == 'c') goto yy871;
		goto yy87;
yy651:
		yych = *++cursor_;
		if (yych == 'h') goto yy872;
		goto yy87;
yy652:
		yych = *++cursor_;
		if (yych == 'n') goto yy873;
		goto yy87;
yy653:
		yych = *++cursor_;
		if (yych == 'i') goto yy874;
		goto yy87;
yy654:
		yych = *++cursor_;
		if (yych == 'o') goto yy875;
		goto yy87;
yy655:
		yych = *++cursor_;
		if (yych == 'o') goto yy876;
		goto yy87;
yy656:
		yych = *++cursor_;
		if (yych == 'o') goto yy877;
		goto yy87;
yy657:
		yych = *++cursor_;
		if (yych == 'r') goto yy878;
		goto yy87;
yy658:
		yych = *++cursor_;
		if (yych == 't') goto yy880;
		goto yy87;
yy659:
		yych = *++cursor_;
		if (yych == 'o') goto yy881;
		goto yy87;
yy660:
		yych = *++cursor_;
		if (yych == 's') goto yy882;
		goto yy87;
yy661:
		++cursor_;
		if ((yych = *cursor_) <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy662;
				if (yych <= '/') goto yy86;
				goto yy663;
			}
		} else {
			if (yych <= '_') {
				if (yych == ';') goto yy662;
				if (yych <= '^') goto yy86;
				goto yy883;
			} else {
				if (yych == 'x') goto yy884;
				if (yych <= '~') goto yy86;
			}
		}
yy662:
#line 305 "src/wast-lexer.cc"
		{ RETURN_TEXT_AT(AlignEqNat, 6); }
#line 4432 "src/prebuilt/wast-lexer-gen.cc"
yy663:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy662;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy662;
				goto yy86;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '9') goto yy663;
				if (yych <= ':') goto yy86;
				goto yy662;
			} else {
				if (yych == '_') goto yy883;
				if (yych <= '~') goto yy86;
				goto yy662;
			}
		}
yy665:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 670 "src/wast-lexer.cc"
		{ RETURN(Funcref); }
#line 4464 "src/prebuilt/wast-lexer-gen.cc"
yy667:
		yych = *++cursor_;
		switch (yych) {
		case 'e':	goto yy885;
		case 'i':	goto yy886;
		case 'm':	goto yy887;
		case 'r':	goto yy888;
		case 't':	goto yy889;
		case 'u':	goto yy890;
		default:	goto yy87;
		}
yy668:
		yych = *++cursor_;
		if (yych == 'n') goto yy891;
		goto yy87;
yy669:
		yych = *++cursor_;
		if (yych == 'e') goto yy892;
		goto yy87;
yy670:
		yych = *++cursor_;
		if (yych == 'd') goto yy894;
		goto yy87;
yy671:
		yych = *++cursor_;
		if (yych == '_') goto yy895;
		goto yy87;
yy672:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 320 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Abs); }
#line 4499 "src/prebuilt/wast-lexer-gen.cc"
yy674:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 367 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Add); }
#line 4507 "src/prebuilt/wast-lexer-gen.cc"
yy676:
		yych = *++cursor_;
		if (yych == 'l') goto yy896;
		goto yy87;
yy677:
		yych = *++cursor_;
		if (yych == 's') goto yy898;
		if (yych == 'v') goto yy899;
		goto yy87;
yy678:
		yych = *++cursor_;
		if (yych == 'y') goto yy900;
		goto yy87;
yy679:
		yych = *++cursor_;
		if (yych == 'o') goto yy901;
		goto yy87;
yy680:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 373 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Div); }
#line 4532 "src/prebuilt/wast-lexer-gen.cc"
yy682:
		yych = *++cursor_;
		if (yych == 'o') goto yy902;
		goto yy87;
yy683:
		yych = *++cursor_;
		if (yych == 'd') goto yy903;
		goto yy87;
yy684:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 377 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Max); }
#line 4548 "src/prebuilt/wast-lexer-gen.cc"
yy686:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 375 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Min); }
#line 4556 "src/prebuilt/wast-lexer-gen.cc"
yy688:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 371 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Mul); }
#line 4564 "src/prebuilt/wast-lexer-gen.cc"
yy690:
		yych = *++cursor_;
		if (yych == 'r') goto yy905;
		goto yy87;
yy691:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 318 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Neg); }
#line 4576 "src/prebuilt/wast-lexer-gen.cc"
yy693:
		yych = *++cursor_;
		if (yych == 'n') goto yy906;
		goto yy87;
yy694:
		yych = *++cursor_;
		if (yych == 't') goto yy907;
		goto yy87;
yy695:
		yych = *++cursor_;
		if (yych == 'r') goto yy909;
		goto yy87;
yy696:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 369 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Sub); }
#line 4596 "src/prebuilt/wast-lexer-gen.cc"
yy698:
		yych = *++cursor_;
		if (yych == 'n') goto yy910;
		goto yy87;
yy699:
		yych = *++cursor_;
		if (yych == 'b') goto yy911;
		if (yych == 'd') goto yy912;
		goto yy87;
yy700:
		yych = *++cursor_;
		if (yych == 'o') goto yy913;
		goto yy87;
yy701:
		yych = *++cursor_;
		if (yych == 'i') goto yy914;
		goto yy87;
yy702:
		yych = *++cursor_;
		if (yych == 'q') goto yy915;
		if (yych == 'x') goto yy917;
		goto yy87;
yy703:
		yych = *++cursor_;
		if (yych == 'e') goto yy918;
		if (yych == 't') goto yy920;
		goto yy87;
yy704:
		yych = *++cursor_;
		if (yych == 'e') goto yy922;
		if (yych == 't') goto yy924;
		goto yy87;
yy705:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych == 'a') goto yy926;
			goto yy87;
		} else {
			if (yych <= 'i') goto yy927;
			if (yych == 'u') goto yy928;
			goto yy87;
		}
yy706:
		yych = *++cursor_;
		if (yych == 'e') goto yy929;
		goto yy87;
yy707:
		yych = *++cursor_;
		if (yych == 'e') goto yy931;
		goto yy87;
yy708:
		yych = *++cursor_;
		if (yych <= 'q') {
			if (yych <= 'o') goto yy87;
			if (yych <= 'p') goto yy932;
			goto yy933;
		} else {
			if (yych == 'u') goto yy934;
			goto yy87;
		}
yy709:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 321 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Abs); }
#line 4664 "src/prebuilt/wast-lexer-gen.cc"
yy711:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 368 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Add); }
#line 4672 "src/prebuilt/wast-lexer-gen.cc"
yy713:
		yych = *++cursor_;
		if (yych == 'l') goto yy935;
		goto yy87;
yy714:
		yych = *++cursor_;
		if (yych == 's') goto yy937;
		if (yych == 'v') goto yy938;
		goto yy87;
yy715:
		yych = *++cursor_;
		if (yych == 'y') goto yy939;
		goto yy87;
yy716:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 374 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Div); }
#line 4693 "src/prebuilt/wast-lexer-gen.cc"
yy718:
		yych = *++cursor_;
		if (yych == 'o') goto yy940;
		goto yy87;
yy719:
		yych = *++cursor_;
		if (yych == 'd') goto yy941;
		goto yy87;
yy720:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 378 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Max); }
#line 4709 "src/prebuilt/wast-lexer-gen.cc"
yy722:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 376 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Min); }
#line 4717 "src/prebuilt/wast-lexer-gen.cc"
yy724:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 372 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Mul); }
#line 4725 "src/prebuilt/wast-lexer-gen.cc"
yy726:
		yych = *++cursor_;
		if (yych == 'r') goto yy943;
		goto yy87;
yy727:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 319 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Neg); }
#line 4737 "src/prebuilt/wast-lexer-gen.cc"
yy729:
		yych = *++cursor_;
		if (yych == 'm') goto yy944;
		goto yy87;
yy730:
		yych = *++cursor_;
		if (yych == 'n') goto yy945;
		goto yy87;
yy731:
		yych = *++cursor_;
		if (yych == 't') goto yy946;
		goto yy87;
yy732:
		yych = *++cursor_;
		if (yych == 'r') goto yy948;
		goto yy87;
yy733:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 370 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Sub); }
#line 4761 "src/prebuilt/wast-lexer-gen.cc"
yy735:
		yych = *++cursor_;
		if (yych == 'n') goto yy949;
		goto yy87;
yy736:
		yych = *++cursor_;
		if (yych == 'b') goto yy950;
		if (yych == 'd') goto yy951;
		goto yy87;
yy737:
		yych = *++cursor_;
		if (yych == 'o') goto yy952;
		goto yy87;
yy738:
		yych = *++cursor_;
		if (yych == 'i') goto yy953;
		goto yy87;
yy739:
		yych = *++cursor_;
		if (yych == 'q') goto yy954;
		if (yych == 'x') goto yy956;
		goto yy87;
yy740:
		yych = *++cursor_;
		if (yych == 'e') goto yy957;
		if (yych == 't') goto yy959;
		goto yy87;
yy741:
		yych = *++cursor_;
		if (yych == 'e') goto yy961;
		if (yych == 't') goto yy963;
		goto yy87;
yy742:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych == 'a') goto yy965;
			goto yy87;
		} else {
			if (yych <= 'i') goto yy966;
			if (yych == 'u') goto yy967;
			goto yy87;
		}
yy743:
		yych = *++cursor_;
		if (yych == 'e') goto yy968;
		goto yy87;
yy744:
		yych = *++cursor_;
		if (yych == 'e') goto yy970;
		goto yy87;
yy745:
		yych = *++cursor_;
		if (yych <= 'q') {
			if (yych <= 'o') goto yy87;
			if (yych <= 'p') goto yy971;
			goto yy972;
		} else {
			if (yych == 'u') goto yy973;
			goto yy87;
		}
yy746:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 260 "src/wast-lexer.cc"
		{ RETURN(Funcref); }
#line 4829 "src/prebuilt/wast-lexer-gen.cc"
yy748:
		yych = *++cursor_;
		if (yych == 'b') goto yy974;
		goto yy87;
yy749:
		yych = *++cursor_;
		if (yych == 'a') goto yy975;
		goto yy87;
yy750:
		yych = *++cursor_;
		if (yych == 'g') goto yy976;
		if (yych == 's') goto yy977;
		goto yy87;
yy751:
		yych = *++cursor_;
		if (yych == 'm') goto yy978;
		goto yy87;
yy752:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'd') goto yy979;
			goto yy87;
		} else {
			if (yych <= 'l') goto yy980;
			if (yych == 'n') goto yy981;
			goto yy87;
		}
yy753:
		yych = *++cursor_;
		if (yych == 'q') goto yy982;
		if (yych == 'x') goto yy984;
		goto yy87;
yy754:
		yych = *++cursor_;
		if (yych == 'e') goto yy985;
		if (yych == 't') goto yy986;
		goto yy87;
yy755:
		yych = *++cursor_;
		if (yych == 'e') goto yy987;
		if (yych == 't') goto yy988;
		goto yy87;
yy756:
		yych = *++cursor_;
		if (yych == 'u') goto yy989;
		goto yy87;
yy757:
		yych = *++cursor_;
		if (yych == 'e') goto yy990;
		goto yy87;
yy758:
		yych = *++cursor_;
		if (yych == 'e') goto yy992;
		goto yy87;
yy759:
		yych = *++cursor_;
		if (yych <= 'o') {
			if (yych == 'h') goto yy993;
			goto yy87;
		} else {
			if (yych <= 'p') goto yy994;
			if (yych == 'u') goto yy995;
			goto yy87;
		}
yy760:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 337 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Add); }
#line 4901 "src/prebuilt/wast-lexer-gen.cc"
yy762:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 351 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32And); }
#line 4909 "src/prebuilt/wast-lexer-gen.cc"
yy764:
		yych = *++cursor_;
		if (yych == 'm') goto yy996;
		goto yy87;
yy765:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 312 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32Clz); }
#line 4921 "src/prebuilt/wast-lexer-gen.cc"
yy767:
		yych = *++cursor_;
		if (yych == 's') goto yy997;
		goto yy87;
yy768:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 314 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32Ctz); }
#line 4933 "src/prebuilt/wast-lexer-gen.cc"
yy770:
		yych = *++cursor_;
		if (yych == '_') goto yy998;
		goto yy87;
yy771:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 310 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32Eqz); }
#line 4945 "src/prebuilt/wast-lexer-gen.cc"
yy773:
		yych = *++cursor_;
		if (yych == 'e') goto yy999;
		goto yy87;
yy774:
		yych = *++cursor_;
		if (yych == 's') goto yy1000;
		if (yych == 'u') goto yy1002;
		goto yy87;
yy775:
		yych = *++cursor_;
		if (yych == 's') goto yy1004;
		if (yych == 'u') goto yy1006;
		goto yy87;
yy776:
		yych = *++cursor_;
		if (yych == 's') goto yy1008;
		if (yych == 'u') goto yy1010;
		goto yy87;
yy777:
		yych = *++cursor_;
		if (yych == 'd') goto yy1012;
		goto yy87;
yy778:
		yych = *++cursor_;
		if (yych == 's') goto yy1014;
		if (yych == 'u') goto yy1016;
		goto yy87;
yy779:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 341 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Mul); }
#line 4981 "src/prebuilt/wast-lexer-gen.cc"
yy781:
		yych = *++cursor_;
		if (yych == 'c') goto yy1018;
		goto yy87;
yy782:
		yych = *++cursor_;
		if (yych == 'n') goto yy1019;
		goto yy87;
yy783:
		yych = *++cursor_;
		if (yych == '_') goto yy1020;
		goto yy87;
yy784:
		yych = *++cursor_;
		if (yych == 'l') goto yy1021;
		if (yych == 'r') goto yy1023;
		goto yy87;
yy785:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 357 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Shl); }
#line 5006 "src/prebuilt/wast-lexer-gen.cc"
yy787:
		yych = *++cursor_;
		if (yych == '_') goto yy1025;
		goto yy87;
yy788:
		yych = *++cursor_;
		if (yych == 'r') goto yy1026;
		goto yy87;
yy789:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 339 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Sub); }
#line 5022 "src/prebuilt/wast-lexer-gen.cc"
yy791:
		yych = *++cursor_;
		if (yych == 'n') goto yy1027;
		goto yy87;
yy792:
		yych = *++cursor_;
		if (yych == 'p') goto yy1028;
		goto yy87;
yy793:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 355 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Xor); }
#line 5038 "src/prebuilt/wast-lexer-gen.cc"
yy795:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'd') goto yy1029;
			goto yy87;
		} else {
			if (yych <= 'l') goto yy1030;
			if (yych == 'n') goto yy1031;
			goto yy87;
		}
yy796:
		yych = *++cursor_;
		if (yych == 'q') goto yy1032;
		if (yych == 'x') goto yy1034;
		goto yy87;
yy797:
		yych = *++cursor_;
		if (yych == 'e') goto yy1035;
		if (yych == 't') goto yy1036;
		goto yy87;
yy798:
		yych = *++cursor_;
		if (yych == 'e') goto yy1037;
		if (yych == 't') goto yy1038;
		goto yy87;
yy799:
		yych = *++cursor_;
		if (yych == 'u') goto yy1039;
		goto yy87;
yy800:
		yych = *++cursor_;
		if (yych == 'e') goto yy1040;
		goto yy87;
yy801:
		yych = *++cursor_;
		if (yych == 'e') goto yy1042;
		goto yy87;
yy802:
		yych = *++cursor_;
		if (yych <= 'o') {
			if (yych == 'h') goto yy1043;
			goto yy87;
		} else {
			if (yych <= 'p') goto yy1044;
			if (yych == 'u') goto yy1045;
			goto yy87;
		}
yy803:
		yych = *++cursor_;
		if (yych == 'r') goto yy1046;
		goto yy87;
yy804:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 338 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Add); }
#line 5097 "src/prebuilt/wast-lexer-gen.cc"
yy806:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 352 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64And); }
#line 5105 "src/prebuilt/wast-lexer-gen.cc"
yy808:
		yych = *++cursor_;
		if (yych == 'm') goto yy1047;
		goto yy87;
yy809:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 313 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64Clz); }
#line 5117 "src/prebuilt/wast-lexer-gen.cc"
yy811:
		yych = *++cursor_;
		if (yych == 's') goto yy1048;
		goto yy87;
yy812:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 315 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64Ctz); }
#line 5129 "src/prebuilt/wast-lexer-gen.cc"
yy814:
		yych = *++cursor_;
		if (yych == '_') goto yy1049;
		goto yy87;
yy815:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 311 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64Eqz); }
#line 5141 "src/prebuilt/wast-lexer-gen.cc"
yy817:
		yych = *++cursor_;
		if (yych == 'e') goto yy1050;
		goto yy87;
yy818:
		yych = *++cursor_;
		if (yych == 's') goto yy1051;
		if (yych == 'u') goto yy1053;
		goto yy87;
yy819:
		yych = *++cursor_;
		if (yych == 's') goto yy1055;
		if (yych == 'u') goto yy1057;
		goto yy87;
yy820:
		yych = *++cursor_;
		if (yych == 's') goto yy1059;
		if (yych == 'u') goto yy1061;
		goto yy87;
yy821:
		yych = *++cursor_;
		if (yych == 'd') goto yy1063;
		goto yy87;
yy822:
		yych = *++cursor_;
		if (yych == 's') goto yy1065;
		if (yych == 'u') goto yy1067;
		goto yy87;
yy823:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 342 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Mul); }
#line 5177 "src/prebuilt/wast-lexer-gen.cc"
yy825:
		yych = *++cursor_;
		if (yych == 'c') goto yy1069;
		goto yy87;
yy826:
		yych = *++cursor_;
		if (yych == 'n') goto yy1070;
		goto yy87;
yy827:
		yych = *++cursor_;
		if (yych == '_') goto yy1071;
		goto yy87;
yy828:
		yych = *++cursor_;
		if (yych == 'l') goto yy1072;
		if (yych == 'r') goto yy1074;
		goto yy87;
yy829:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 358 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Shl); }
#line 5202 "src/prebuilt/wast-lexer-gen.cc"
yy831:
		yych = *++cursor_;
		if (yych == '_') goto yy1076;
		goto yy87;
yy832:
		yych = *++cursor_;
		if (yych == 'r') goto yy1077;
		goto yy87;
yy833:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 340 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Sub); }
#line 5218 "src/prebuilt/wast-lexer-gen.cc"
yy835:
		yych = *++cursor_;
		if (yych == 'n') goto yy1078;
		goto yy87;
yy836:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 356 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Xor); }
#line 5230 "src/prebuilt/wast-lexer-gen.cc"
yy838:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'd') goto yy1079;
			goto yy87;
		} else {
			if (yych <= 'l') goto yy1080;
			if (yych == 'n') goto yy1081;
			goto yy87;
		}
yy839:
		yych = *++cursor_;
		if (yych == 'x') goto yy1082;
		goto yy87;
yy840:
		yych = *++cursor_;
		if (yych == 'e') goto yy1083;
		goto yy87;
yy841:
		yych = *++cursor_;
		if (yych == 'e') goto yy1084;
		goto yy87;
yy842:
		yych = *++cursor_;
		if (yych <= 'o') {
			if (yych == 'h') goto yy1085;
			goto yy87;
		} else {
			if (yych <= 'p') goto yy1086;
			if (yych == 'u') goto yy1087;
			goto yy87;
		}
yy843:
		yych = *++cursor_;
		if (yych == 'r') goto yy1088;
		goto yy87;
yy844:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'd') goto yy1089;
			goto yy87;
		} else {
			if (yych <= 'l') goto yy1090;
			if (yych == 'n') goto yy1091;
			goto yy87;
		}
yy845:
		yych = *++cursor_;
		if (yych == 'q') goto yy1092;
		if (yych == 'x') goto yy1094;
		goto yy87;
yy846:
		yych = *++cursor_;
		if (yych == 'e') goto yy1095;
		if (yych == 't') goto yy1096;
		goto yy87;
yy847:
		yych = *++cursor_;
		if (yych == 'e') goto yy1097;
		if (yych == 't') goto yy1098;
		goto yy87;
yy848:
		yych = *++cursor_;
		if (yych == 'u') goto yy1099;
		goto yy87;
yy849:
		yych = *++cursor_;
		if (yych == 'e') goto yy1100;
		goto yy87;
yy850:
		yych = *++cursor_;
		if (yych == 'e') goto yy1102;
		goto yy87;
yy851:
		yych = *++cursor_;
		if (yych <= 'o') {
			if (yych == 'h') goto yy1103;
			goto yy87;
		} else {
			if (yych <= 'p') goto yy1104;
			if (yych == 'u') goto yy1105;
			goto yy87;
		}
yy852:
		yych = *++cursor_;
		if (yych == 'p') goto yy1106;
		goto yy87;
yy853:
		yych = *++cursor_;
		if (yych == 'e') goto yy1107;
		goto yy87;
yy854:
		yych = *++cursor_;
		if (yych == 'e') goto yy1108;
		goto yy87;
yy855:
		yych = *++cursor_;
		if (yych == 'e') goto yy1109;
		goto yy87;
yy856:
		yych = *++cursor_;
		switch (yych) {
		case 'c':	goto yy1110;
		case 'd':	goto yy1111;
		case 'f':	goto yy1112;
		case 'g':	goto yy1113;
		case 'i':	goto yy1114;
		case 's':	goto yy1115;
		default:	goto yy87;
		}
yy857:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych <= '"') goto yy267;
				goto yy86;
			} else {
				if (yych <= ')') goto yy267;
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy857;
				goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') goto yy267;
				if (yych <= '@') goto yy86;
				if (yych <= 'F') goto yy857;
				goto yy86;
			} else {
				if (yych <= '`') {
					if (yych <= '_') goto yy633;
					goto yy86;
				} else {
					if (yych <= 'f') goto yy857;
					if (yych <= '~') goto yy86;
					goto yy267;
				}
			}
		}
yy859:
		yych = *++cursor_;
		if (yych <= '/') goto yy87;
		if (yych <= '0') goto yy1116;
		if (yych <= '9') goto yy1118;
		goto yy87;
yy860:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 728 "src/wast-lexer.cc"
		{ RETURN(Passive); }
#line 5386 "src/prebuilt/wast-lexer-gen.cc"
yy862:
		yych = *++cursor_;
		if (yych == 'r') goto yy1120;
		goto yy87;
yy863:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 743 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Rethrow); }
#line 5398 "src/prebuilt/wast-lexer-gen.cc"
yy865:
		yych = *++cursor_;
		if (yych == 'c') goto yy1122;
		goto yy87;
yy866:
		yych = *++cursor_;
		if (yych == 'b') goto yy1123;
		goto yy87;
yy867:
		yych = *++cursor_;
		if (yych == 'a') goto yy1124;
		goto yy87;
yy868:
		yych = *++cursor_;
		if (yych == 'o') goto yy1125;
		goto yy87;
yy869:
		yych = *++cursor_;
		if (yych == 'r') goto yy1126;
		goto yy87;
yy870:
		yych = *++cursor_;
		if (yych == 'n') goto yy1127;
		goto yy87;
yy871:
		yych = *++cursor_;
		if (yych == 'a') goto yy1128;
		goto yy87;
yy872:
		yych = *++cursor_;
		if (yych == 'a') goto yy1129;
		goto yy87;
yy873:
		yych = *++cursor_;
		if (yych == 'd') goto yy1130;
		goto yy87;
yy874:
		yych = *++cursor_;
		if (yych == 't') goto yy1132;
		goto yy87;
yy875:
		yych = *++cursor_;
		if (yych == 'n') goto yy1133;
		goto yy87;
yy876:
		yych = *++cursor_;
		if (yych == 'a') goto yy1134;
		goto yy87;
yy877:
		yych = *++cursor_;
		if (yych == 't') goto yy1135;
		goto yy87;
yy878:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 586 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, V128Or); }
#line 5458 "src/prebuilt/wast-lexer-gen.cc"
yy880:
		yych = *++cursor_;
		if (yych == 'o') goto yy1137;
		goto yy87;
yy881:
		yych = *++cursor_;
		if (yych == 'r') goto yy1138;
		goto yy87;
yy882:
		yych = *++cursor_;
		if (yych == 'h') goto yy1140;
		goto yy87;
yy883:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy88;
				goto yy86;
			} else {
				if (yych <= '"') goto yy88;
				if (yych <= '\'') goto yy86;
				goto yy88;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy663;
				goto yy86;
			} else {
				if (yych <= ';') goto yy88;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy884:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy88;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy88;
				if (yych <= '/') goto yy86;
				goto yy1141;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy88;
				if (yych <= '@') goto yy86;
				goto yy1141;
			} else {
				if (yych <= '`') goto yy86;
				if (yych <= 'f') goto yy1141;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy885:
		yych = *++cursor_;
		if (yych == 'x') goto yy1143;
		goto yy87;
yy886:
		yych = *++cursor_;
		if (yych == 'n') goto yy1144;
		goto yy87;
yy887:
		yych = *++cursor_;
		if (yych == 'a') goto yy1145;
		goto yy87;
yy888:
		yych = *++cursor_;
		if (yych == 'e') goto yy1146;
		goto yy87;
yy889:
		yych = *++cursor_;
		if (yych == 'r') goto yy1147;
		goto yy87;
yy890:
		yych = *++cursor_;
		if (yych == 'n') goto yy1148;
		goto yy87;
yy891:
		yych = *++cursor_;
		if (yych == 'o') goto yy1149;
		goto yy87;
yy892:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 270 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(BrTable); }
#line 5556 "src/prebuilt/wast-lexer-gen.cc"
yy894:
		yych = *++cursor_;
		if (yych == 'i') goto yy1150;
		goto yy87;
yy895:
		yych = *++cursor_;
		if (yych == 'm') goto yy1151;
		goto yy87;
yy896:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 324 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Ceil); }
#line 5572 "src/prebuilt/wast-lexer-gen.cc"
yy898:
		yych = *++cursor_;
		if (yych == 't') goto yy1152;
		goto yy87;
yy899:
		yych = *++cursor_;
		if (yych == 'e') goto yy1154;
		goto yy87;
yy900:
		yych = *++cursor_;
		if (yych == 's') goto yy1155;
		goto yy87;
yy901:
		yych = *++cursor_;
		if (yych == 't') goto yy1156;
		goto yy87;
yy902:
		yych = *++cursor_;
		if (yych == 'r') goto yy1157;
		goto yy87;
yy903:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 283 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, F32Load); }
#line 5600 "src/prebuilt/wast-lexer-gen.cc"
yy905:
		yych = *++cursor_;
		if (yych == 'e') goto yy1159;
		goto yy87;
yy906:
		yych = *++cursor_;
		if (yych == 't') goto yy1160;
		goto yy87;
yy907:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 322 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Sqrt); }
#line 5616 "src/prebuilt/wast-lexer-gen.cc"
yy909:
		yych = *++cursor_;
		if (yych == 'e') goto yy1161;
		goto yy87;
yy910:
		yych = *++cursor_;
		if (yych == 'c') goto yy1163;
		goto yy87;
yy911:
		yych = *++cursor_;
		if (yych == 's') goto yy1165;
		goto yy87;
yy912:
		yych = *++cursor_;
		if (yych == 'd') goto yy1167;
		goto yy87;
yy913:
		yych = *++cursor_;
		if (yych == 'n') goto yy1169;
		goto yy87;
yy914:
		yych = *++cursor_;
		if (yych == 'v') goto yy1170;
		goto yy87;
yy915:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 601 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32X4Eq); }
#line 5648 "src/prebuilt/wast-lexer-gen.cc"
yy917:
		yych = *++cursor_;
		if (yych == 't') goto yy1172;
		goto yy87;
yy918:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 638 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32X4Ge); }
#line 5660 "src/prebuilt/wast-lexer-gen.cc"
yy920:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 630 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32X4Gt); }
#line 5668 "src/prebuilt/wast-lexer-gen.cc"
yy922:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 622 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32X4Le); }
#line 5676 "src/prebuilt/wast-lexer-gen.cc"
yy924:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 614 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32X4Lt); }
#line 5684 "src/prebuilt/wast-lexer-gen.cc"
yy926:
		yych = *++cursor_;
		if (yych == 'x') goto yy1173;
		goto yy87;
yy927:
		yych = *++cursor_;
		if (yych == 'n') goto yy1175;
		goto yy87;
yy928:
		yych = *++cursor_;
		if (yych == 'l') goto yy1177;
		goto yy87;
yy929:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy930;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= 'f') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= 'g') goto yy1179;
				if (yych <= '~') goto yy86;
			}
		}
yy930:
#line 606 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32X4Ne); }
#line 5717 "src/prebuilt/wast-lexer-gen.cc"
yy931:
		yych = *++cursor_;
		if (yych == 'p') goto yy1181;
		goto yy87;
yy932:
		yych = *++cursor_;
		if (yych == 'l') goto yy1182;
		goto yy87;
yy933:
		yych = *++cursor_;
		if (yych == 'r') goto yy1183;
		goto yy87;
yy934:
		yych = *++cursor_;
		if (yych == 'b') goto yy1184;
		goto yy87;
yy935:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 325 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Ceil); }
#line 5741 "src/prebuilt/wast-lexer-gen.cc"
yy937:
		yych = *++cursor_;
		if (yych == 't') goto yy1186;
		goto yy87;
yy938:
		yych = *++cursor_;
		if (yych == 'e') goto yy1188;
		goto yy87;
yy939:
		yych = *++cursor_;
		if (yych == 's') goto yy1189;
		goto yy87;
yy940:
		yych = *++cursor_;
		if (yych == 'r') goto yy1190;
		goto yy87;
yy941:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 284 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, F64Load); }
#line 5765 "src/prebuilt/wast-lexer-gen.cc"
yy943:
		yych = *++cursor_;
		if (yych == 'e') goto yy1192;
		goto yy87;
yy944:
		yych = *++cursor_;
		if (yych == 'o') goto yy1193;
		goto yy87;
yy945:
		yych = *++cursor_;
		if (yych == 't') goto yy1194;
		goto yy87;
yy946:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 323 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Sqrt); }
#line 5785 "src/prebuilt/wast-lexer-gen.cc"
yy948:
		yych = *++cursor_;
		if (yych == 'e') goto yy1195;
		goto yy87;
yy949:
		yych = *++cursor_;
		if (yych == 'c') goto yy1197;
		goto yy87;
yy950:
		yych = *++cursor_;
		if (yych == 's') goto yy1199;
		goto yy87;
yy951:
		yych = *++cursor_;
		if (yych == 'd') goto yy1201;
		goto yy87;
yy952:
		yych = *++cursor_;
		if (yych == 'n') goto yy1203;
		goto yy87;
yy953:
		yych = *++cursor_;
		if (yych == 'v') goto yy1204;
		goto yy87;
yy954:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 602 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64X2Eq); }
#line 5817 "src/prebuilt/wast-lexer-gen.cc"
yy956:
		yych = *++cursor_;
		if (yych == 't') goto yy1206;
		goto yy87;
yy957:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 639 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64X2Ge); }
#line 5829 "src/prebuilt/wast-lexer-gen.cc"
yy959:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 631 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64X2Gt); }
#line 5837 "src/prebuilt/wast-lexer-gen.cc"
yy961:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 623 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64X2Le); }
#line 5845 "src/prebuilt/wast-lexer-gen.cc"
yy963:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 615 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64X2Lt); }
#line 5853 "src/prebuilt/wast-lexer-gen.cc"
yy965:
		yych = *++cursor_;
		if (yych == 'x') goto yy1207;
		goto yy87;
yy966:
		yych = *++cursor_;
		if (yych == 'n') goto yy1209;
		goto yy87;
yy967:
		yych = *++cursor_;
		if (yych == 'l') goto yy1211;
		goto yy87;
yy968:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy969;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= 'f') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= 'g') goto yy1213;
				if (yych <= '~') goto yy86;
			}
		}
yy969:
#line 607 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64X2Ne); }
#line 5886 "src/prebuilt/wast-lexer-gen.cc"
yy970:
		yych = *++cursor_;
		if (yych == 'p') goto yy1215;
		goto yy87;
yy971:
		yych = *++cursor_;
		if (yych == 'l') goto yy1216;
		goto yy87;
yy972:
		yych = *++cursor_;
		if (yych == 'r') goto yy1217;
		goto yy87;
yy973:
		yych = *++cursor_;
		if (yych == 'b') goto yy1218;
		goto yy87;
yy974:
		yych = *++cursor_;
		if (yych == 'a') goto yy1220;
		goto yy87;
yy975:
		yych = *++cursor_;
		if (yych == 'l') goto yy1221;
		goto yy87;
yy976:
		yych = *++cursor_;
		if (yych == 'e') goto yy1223;
		goto yy87;
yy977:
		yych = *++cursor_;
		if (yych == 'e') goto yy1224;
		goto yy87;
yy978:
		yych = *++cursor_;
		if (yych == 'o') goto yy1225;
		goto yy87;
yy979:
		yych = *++cursor_;
		if (yych == 'd') goto yy1226;
		goto yy87;
yy980:
		yych = *++cursor_;
		if (yych == 'l') goto yy1228;
		goto yy87;
yy981:
		yych = *++cursor_;
		if (yych == 'y') goto yy1229;
		goto yy87;
yy982:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 599 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8Eq); }
#line 5942 "src/prebuilt/wast-lexer-gen.cc"
yy984:
		yych = *++cursor_;
		if (yych == 't') goto yy1230;
		goto yy87;
yy985:
		yych = *++cursor_;
		if (yych == '_') goto yy1231;
		goto yy87;
yy986:
		yych = *++cursor_;
		if (yych == '_') goto yy1232;
		goto yy87;
yy987:
		yych = *++cursor_;
		if (yych == '_') goto yy1233;
		goto yy87;
yy988:
		yych = *++cursor_;
		if (yych == '_') goto yy1234;
		goto yy87;
yy989:
		yych = *++cursor_;
		if (yych == 'l') goto yy1235;
		goto yy87;
yy990:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy991;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= 'f') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= 'g') goto yy1237;
				if (yych <= '~') goto yy86;
			}
		}
yy991:
#line 604 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8Ne); }
#line 5987 "src/prebuilt/wast-lexer-gen.cc"
yy992:
		yych = *++cursor_;
		if (yych == 'p') goto yy1239;
		goto yy87;
yy993:
		yych = *++cursor_;
		if (yych == 'l') goto yy1240;
		if (yych == 'r') goto yy1242;
		goto yy87;
yy994:
		yych = *++cursor_;
		if (yych == 'l') goto yy1243;
		goto yy87;
yy995:
		yych = *++cursor_;
		if (yych == 'b') goto yy1244;
		goto yy87;
yy996:
		yych = *++cursor_;
		if (yych == 'i') goto yy1246;
		goto yy87;
yy997:
		yych = *++cursor_;
		if (yych == 't') goto yy1247;
		goto yy87;
yy998:
		yych = *++cursor_;
		if (yych == 's') goto yy1249;
		if (yych == 'u') goto yy1251;
		goto yy87;
yy999:
		yych = *++cursor_;
		if (yych == 'n') goto yy1253;
		goto yy87;
yy1000:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 397 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32GeS); }
#line 6029 "src/prebuilt/wast-lexer-gen.cc"
yy1002:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 399 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32GeU); }
#line 6037 "src/prebuilt/wast-lexer-gen.cc"
yy1004:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 393 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32GtS); }
#line 6045 "src/prebuilt/wast-lexer-gen.cc"
yy1006:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 395 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32GtU); }
#line 6053 "src/prebuilt/wast-lexer-gen.cc"
yy1008:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 389 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32LeS); }
#line 6061 "src/prebuilt/wast-lexer-gen.cc"
yy1010:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 391 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32LeU); }
#line 6069 "src/prebuilt/wast-lexer-gen.cc"
yy1012:
		++cursor_;
		if ((yych = *cursor_) <= '0') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= '8') {
				if (yych <= '1') goto yy1254;
				if (yych <= '7') goto yy86;
				goto yy1255;
			} else {
				if (yych == ';') goto yy1013;
				if (yych <= '~') goto yy86;
			}
		}
yy1013:
#line 281 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I32Load); }
#line 6092 "src/prebuilt/wast-lexer-gen.cc"
yy1014:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 385 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32LtS); }
#line 6100 "src/prebuilt/wast-lexer-gen.cc"
yy1016:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 387 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32LtU); }
#line 6108 "src/prebuilt/wast-lexer-gen.cc"
yy1018:
		yych = *++cursor_;
		if (yych == 'n') goto yy1256;
		goto yy87;
yy1019:
		yych = *++cursor_;
		if (yych == 't') goto yy1257;
		goto yy87;
yy1020:
		yych = *++cursor_;
		if (yych == 's') goto yy1258;
		if (yych == 'u') goto yy1260;
		goto yy87;
yy1021:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 363 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Rotl); }
#line 6129 "src/prebuilt/wast-lexer-gen.cc"
yy1023:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 365 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Rotr); }
#line 6137 "src/prebuilt/wast-lexer-gen.cc"
yy1025:
		yych = *++cursor_;
		if (yych == 's') goto yy1262;
		if (yych == 'u') goto yy1264;
		goto yy87;
yy1026:
		yych = *++cursor_;
		if (yych == 'e') goto yy1266;
		goto yy87;
yy1027:
		yych = *++cursor_;
		if (yych == 'c') goto yy1268;
		goto yy87;
yy1028:
		yych = *++cursor_;
		if (yych == '/') goto yy1269;
		if (yych == '_') goto yy1270;
		goto yy87;
yy1029:
		yych = *++cursor_;
		if (yych == 'd') goto yy1271;
		goto yy87;
yy1030:
		yych = *++cursor_;
		if (yych == 'l') goto yy1273;
		goto yy87;
yy1031:
		yych = *++cursor_;
		if (yych == 'y') goto yy1274;
		goto yy87;
yy1032:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 600 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4Eq); }
#line 6175 "src/prebuilt/wast-lexer-gen.cc"
yy1034:
		yych = *++cursor_;
		if (yych == 't') goto yy1275;
		goto yy87;
yy1035:
		yych = *++cursor_;
		if (yych == '_') goto yy1276;
		goto yy87;
yy1036:
		yych = *++cursor_;
		if (yych == '_') goto yy1277;
		goto yy87;
yy1037:
		yych = *++cursor_;
		if (yych == '_') goto yy1278;
		goto yy87;
yy1038:
		yych = *++cursor_;
		if (yych == '_') goto yy1279;
		goto yy87;
yy1039:
		yych = *++cursor_;
		if (yych == 'l') goto yy1280;
		goto yy87;
yy1040:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy1041;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= 'f') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= 'g') goto yy1282;
				if (yych <= '~') goto yy86;
			}
		}
yy1041:
#line 605 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4Ne); }
#line 6220 "src/prebuilt/wast-lexer-gen.cc"
yy1042:
		yych = *++cursor_;
		if (yych == 'p') goto yy1284;
		goto yy87;
yy1043:
		yych = *++cursor_;
		if (yych == 'l') goto yy1285;
		if (yych == 'r') goto yy1287;
		goto yy87;
yy1044:
		yych = *++cursor_;
		if (yych == 'l') goto yy1288;
		goto yy87;
yy1045:
		yych = *++cursor_;
		if (yych == 'b') goto yy1289;
		goto yy87;
yy1046:
		yych = *++cursor_;
		if (yych == 'u') goto yy1291;
		goto yy87;
yy1047:
		yych = *++cursor_;
		if (yych == 'i') goto yy1292;
		goto yy87;
yy1048:
		yych = *++cursor_;
		if (yych == 't') goto yy1293;
		goto yy87;
yy1049:
		yych = *++cursor_;
		if (yych == 's') goto yy1295;
		if (yych == 'u') goto yy1297;
		goto yy87;
yy1050:
		yych = *++cursor_;
		if (yych == 'n') goto yy1299;
		goto yy87;
yy1051:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 398 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64GeS); }
#line 6266 "src/prebuilt/wast-lexer-gen.cc"
yy1053:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 400 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64GeU); }
#line 6274 "src/prebuilt/wast-lexer-gen.cc"
yy1055:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 394 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64GtS); }
#line 6282 "src/prebuilt/wast-lexer-gen.cc"
yy1057:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 396 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64GtU); }
#line 6290 "src/prebuilt/wast-lexer-gen.cc"
yy1059:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 390 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64LeS); }
#line 6298 "src/prebuilt/wast-lexer-gen.cc"
yy1061:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 392 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64LeU); }
#line 6306 "src/prebuilt/wast-lexer-gen.cc"
yy1063:
		++cursor_;
		if ((yych = *cursor_) <= '1') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy1064;
				if (yych <= '0') goto yy86;
				goto yy1300;
			}
		} else {
			if (yych <= '8') {
				if (yych == '3') goto yy1301;
				if (yych <= '7') goto yy86;
				goto yy1302;
			} else {
				if (yych == ';') goto yy1064;
				if (yych <= '~') goto yy86;
			}
		}
yy1064:
#line 282 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load); }
#line 6331 "src/prebuilt/wast-lexer-gen.cc"
yy1065:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 386 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64LtS); }
#line 6339 "src/prebuilt/wast-lexer-gen.cc"
yy1067:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 388 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64LtU); }
#line 6347 "src/prebuilt/wast-lexer-gen.cc"
yy1069:
		yych = *++cursor_;
		if (yych == 'n') goto yy1303;
		goto yy87;
yy1070:
		yych = *++cursor_;
		if (yych == 't') goto yy1304;
		goto yy87;
yy1071:
		yych = *++cursor_;
		if (yych == 's') goto yy1305;
		if (yych == 'u') goto yy1307;
		goto yy87;
yy1072:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 364 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Rotl); }
#line 6368 "src/prebuilt/wast-lexer-gen.cc"
yy1074:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 366 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Rotr); }
#line 6376 "src/prebuilt/wast-lexer-gen.cc"
yy1076:
		yych = *++cursor_;
		if (yych == 's') goto yy1309;
		if (yych == 'u') goto yy1311;
		goto yy87;
yy1077:
		yych = *++cursor_;
		if (yych == 'e') goto yy1313;
		goto yy87;
yy1078:
		yych = *++cursor_;
		if (yych == 'c') goto yy1315;
		goto yy87;
yy1079:
		yych = *++cursor_;
		if (yych == 'd') goto yy1316;
		goto yy87;
yy1080:
		yych = *++cursor_;
		if (yych == 'l') goto yy1318;
		goto yy87;
yy1081:
		yych = *++cursor_;
		if (yych == 'y') goto yy1319;
		goto yy87;
yy1082:
		yych = *++cursor_;
		if (yych == 't') goto yy1320;
		goto yy87;
yy1083:
		yych = *++cursor_;
		if (yych == 'g') goto yy1321;
		goto yy87;
yy1084:
		yych = *++cursor_;
		if (yych == 'p') goto yy1323;
		goto yy87;
yy1085:
		yych = *++cursor_;
		if (yych == 'l') goto yy1324;
		if (yych == 'r') goto yy1326;
		goto yy87;
yy1086:
		yych = *++cursor_;
		if (yych == 'l') goto yy1327;
		goto yy87;
yy1087:
		yych = *++cursor_;
		if (yych == 'b') goto yy1328;
		goto yy87;
yy1088:
		yych = *++cursor_;
		if (yych == 'u') goto yy1330;
		goto yy87;
yy1089:
		yych = *++cursor_;
		if (yych == 'd') goto yy1331;
		goto yy87;
yy1090:
		yych = *++cursor_;
		if (yych == 'l') goto yy1333;
		goto yy87;
yy1091:
		yych = *++cursor_;
		if (yych == 'y') goto yy1334;
		goto yy87;
yy1092:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 598 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16Eq); }
#line 6450 "src/prebuilt/wast-lexer-gen.cc"
yy1094:
		yych = *++cursor_;
		if (yych == 't') goto yy1335;
		goto yy87;
yy1095:
		yych = *++cursor_;
		if (yych == '_') goto yy1336;
		goto yy87;
yy1096:
		yych = *++cursor_;
		if (yych == '_') goto yy1337;
		goto yy87;
yy1097:
		yych = *++cursor_;
		if (yych == '_') goto yy1338;
		goto yy87;
yy1098:
		yych = *++cursor_;
		if (yych == '_') goto yy1339;
		goto yy87;
yy1099:
		yych = *++cursor_;
		if (yych == 'l') goto yy1340;
		goto yy87;
yy1100:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy1101;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= 'f') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= 'g') goto yy1342;
				if (yych <= '~') goto yy86;
			}
		}
yy1101:
#line 603 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16Ne); }
#line 6495 "src/prebuilt/wast-lexer-gen.cc"
yy1102:
		yych = *++cursor_;
		if (yych == 'p') goto yy1344;
		goto yy87;
yy1103:
		yych = *++cursor_;
		if (yych == 'l') goto yy1345;
		if (yych == 'r') goto yy1347;
		goto yy87;
yy1104:
		yych = *++cursor_;
		if (yych == 'l') goto yy1348;
		goto yy87;
yy1105:
		yych = *++cursor_;
		if (yych == 'b') goto yy1349;
		goto yy87;
yy1106:
		yych = *++cursor_;
		if (yych == 't') goto yy1351;
		goto yy87;
yy1107:
		yych = *++cursor_;
		if (yych == 't') goto yy1353;
		goto yy87;
yy1108:
		yych = *++cursor_;
		if (yych == 't') goto yy1355;
		goto yy87;
yy1109:
		yych = *++cursor_;
		if (yych == 'e') goto yy1357;
		goto yy87;
yy1110:
		yych = *++cursor_;
		if (yych == 'o') goto yy1359;
		goto yy87;
yy1111:
		yych = *++cursor_;
		if (yych == 'r') goto yy1360;
		goto yy87;
yy1112:
		yych = *++cursor_;
		if (yych == 'i') goto yy1361;
		goto yy87;
yy1113:
		yych = *++cursor_;
		if (yych == 'r') goto yy1362;
		goto yy87;
yy1114:
		yych = *++cursor_;
		if (yych == 'n') goto yy1363;
		goto yy87;
yy1115:
		yych = *++cursor_;
		if (yych == 'i') goto yy1364;
		goto yy87;
yy1116:
		++cursor_;
		if ((yych = *cursor_) <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy1117;
				if (yych <= '/') goto yy86;
				goto yy1118;
			}
		} else {
			if (yych <= '_') {
				if (yych == ';') goto yy1117;
				if (yych <= '^') goto yy86;
				goto yy1365;
			} else {
				if (yych == 'x') goto yy1366;
				if (yych <= '~') goto yy86;
			}
		}
yy1117:
#line 304 "src/wast-lexer.cc"
		{ RETURN_TEXT_AT(OffsetEqNat, 7); }
#line 6577 "src/prebuilt/wast-lexer-gen.cc"
yy1118:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy1117;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy1117;
				goto yy86;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '9') goto yy1118;
				if (yych <= ':') goto yy86;
				goto yy1117;
			} else {
				if (yych == '_') goto yy1365;
				if (yych <= '~') goto yy86;
				goto yy1117;
			}
		}
yy1120:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 729 "src/wast-lexer.cc"
		{ RETURN(Register); }
#line 6609 "src/prebuilt/wast-lexer-gen.cc"
yy1122:
		yych = *++cursor_;
		if (yych == 'a') goto yy1367;
		goto yy87;
yy1123:
		yych = *++cursor_;
		if (yych == 'a') goto yy1368;
		goto yy87;
yy1124:
		yych = *++cursor_;
		if (yych == 'l') goto yy1369;
		goto yy87;
yy1125:
		yych = *++cursor_;
		if (yych == 'p') goto yy1371;
		goto yy87;
yy1126:
		yych = *++cursor_;
		if (yych == 'o') goto yy1372;
		goto yy87;
yy1127:
		yych = *++cursor_;
		if (yych == 'i') goto yy1373;
		goto yy87;
yy1128:
		yych = *++cursor_;
		if (yych == 'l') goto yy1374;
		goto yy87;
yy1129:
		yych = *++cursor_;
		if (yych == 'b') goto yy1376;
		goto yy87;
yy1130:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 585 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, V128And); }
#line 6649 "src/prebuilt/wast-lexer-gen.cc"
yy1132:
		yych = *++cursor_;
		if (yych == 's') goto yy1377;
		goto yy87;
yy1133:
		yych = *++cursor_;
		if (yych == 's') goto yy1378;
		goto yy87;
yy1134:
		yych = *++cursor_;
		if (yych == 'd') goto yy1379;
		goto yy87;
yy1135:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 588 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, V128Not); }
#line 6669 "src/prebuilt/wast-lexer-gen.cc"
yy1137:
		yych = *++cursor_;
		if (yych == 'r') goto yy1381;
		goto yy87;
yy1138:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 587 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, V128Xor); }
#line 6681 "src/prebuilt/wast-lexer-gen.cc"
yy1140:
		yych = *++cursor_;
		if (yych == 'u') goto yy1382;
		goto yy87;
yy1141:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych <= '"') goto yy662;
				goto yy86;
			} else {
				if (yych <= ')') goto yy662;
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy1141;
				goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') goto yy662;
				if (yych <= '@') goto yy86;
				if (yych <= 'F') goto yy1141;
				goto yy86;
			} else {
				if (yych <= '`') {
					if (yych <= '_') goto yy884;
					goto yy86;
				} else {
					if (yych <= 'f') goto yy1141;
					if (yych <= '~') goto yy86;
					goto yy662;
				}
			}
		}
yy1143:
		yych = *++cursor_;
		if (yych == 'h') goto yy1383;
		goto yy87;
yy1144:
		yych = *++cursor_;
		if (yych == 'v') goto yy1384;
		goto yy87;
yy1145:
		yych = *++cursor_;
		if (yych == 'l') goto yy1385;
		goto yy87;
yy1146:
		yych = *++cursor_;
		if (yych == 't') goto yy1386;
		goto yy87;
yy1147:
		yych = *++cursor_;
		if (yych == 'a') goto yy1387;
		goto yy87;
yy1148:
		yych = *++cursor_;
		if (yych == 'l') goto yy1388;
		goto yy87;
yy1149:
		yych = *++cursor_;
		if (yych == 't') goto yy1389;
		goto yy87;
yy1150:
		yych = *++cursor_;
		if (yych == 'r') goto yy1390;
		goto yy87;
yy1151:
		yych = *++cursor_;
		if (yych == 'e') goto yy1391;
		goto yy87;
yy1152:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 308 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Const, F32Const); }
#line 6761 "src/prebuilt/wast-lexer-gen.cc"
yy1154:
		yych = *++cursor_;
		if (yych == 'r') goto yy1392;
		goto yy87;
yy1155:
		yych = *++cursor_;
		if (yych == 'i') goto yy1393;
		goto yy87;
yy1156:
		yych = *++cursor_;
		if (yych == 'e') goto yy1394;
		goto yy87;
yy1157:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 326 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Floor); }
#line 6781 "src/prebuilt/wast-lexer-gen.cc"
yy1159:
		yych = *++cursor_;
		if (yych == 's') goto yy1395;
		goto yy87;
yy1160:
		yych = *++cursor_;
		if (yych == 'e') goto yy1396;
		goto yy87;
yy1161:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 287 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, F32Store); }
#line 6797 "src/prebuilt/wast-lexer-gen.cc"
yy1163:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 328 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Trunc); }
#line 6805 "src/prebuilt/wast-lexer-gen.cc"
yy1165:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 642 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32X4Abs); }
#line 6813 "src/prebuilt/wast-lexer-gen.cc"
yy1167:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 648 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32X4Add); }
#line 6821 "src/prebuilt/wast-lexer-gen.cc"
yy1169:
		yych = *++cursor_;
		if (yych == 'v') goto yy1397;
		goto yy87;
yy1170:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 652 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32X4Div); }
#line 6833 "src/prebuilt/wast-lexer-gen.cc"
yy1172:
		yych = *++cursor_;
		if (yych == 'r') goto yy1398;
		goto yy87;
yy1173:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 646 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32X4Max); }
#line 6845 "src/prebuilt/wast-lexer-gen.cc"
yy1175:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 644 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32X4Min); }
#line 6853 "src/prebuilt/wast-lexer-gen.cc"
yy1177:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 654 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32X4Mul); }
#line 6861 "src/prebuilt/wast-lexer-gen.cc"
yy1179:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 640 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32X4Neg); }
#line 6869 "src/prebuilt/wast-lexer-gen.cc"
yy1181:
		yych = *++cursor_;
		if (yych == 'l') goto yy1399;
		goto yy87;
yy1182:
		yych = *++cursor_;
		if (yych == 'a') goto yy1400;
		goto yy87;
yy1183:
		yych = *++cursor_;
		if (yych == 't') goto yy1401;
		goto yy87;
yy1184:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 650 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32X4Sub); }
#line 6889 "src/prebuilt/wast-lexer-gen.cc"
yy1186:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 309 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Const, F64Const); }
#line 6897 "src/prebuilt/wast-lexer-gen.cc"
yy1188:
		yych = *++cursor_;
		if (yych == 'r') goto yy1403;
		goto yy87;
yy1189:
		yych = *++cursor_;
		if (yych == 'i') goto yy1404;
		goto yy87;
yy1190:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 327 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Floor); }
#line 6913 "src/prebuilt/wast-lexer-gen.cc"
yy1192:
		yych = *++cursor_;
		if (yych == 's') goto yy1405;
		goto yy87;
yy1193:
		yych = *++cursor_;
		if (yych == 't') goto yy1406;
		goto yy87;
yy1194:
		yych = *++cursor_;
		if (yych == 'e') goto yy1407;
		goto yy87;
yy1195:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 288 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, F64Store); }
#line 6933 "src/prebuilt/wast-lexer-gen.cc"
yy1197:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 329 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Trunc); }
#line 6941 "src/prebuilt/wast-lexer-gen.cc"
yy1199:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 643 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64X2Abs); }
#line 6949 "src/prebuilt/wast-lexer-gen.cc"
yy1201:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 649 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64X2Add); }
#line 6957 "src/prebuilt/wast-lexer-gen.cc"
yy1203:
		yych = *++cursor_;
		if (yych == 'v') goto yy1408;
		goto yy87;
yy1204:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 653 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64X2Div); }
#line 6969 "src/prebuilt/wast-lexer-gen.cc"
yy1206:
		yych = *++cursor_;
		if (yych == 'r') goto yy1409;
		goto yy87;
yy1207:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 647 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64X2Max); }
#line 6981 "src/prebuilt/wast-lexer-gen.cc"
yy1209:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 645 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64X2Min); }
#line 6989 "src/prebuilt/wast-lexer-gen.cc"
yy1211:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 655 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64X2Mul); }
#line 6997 "src/prebuilt/wast-lexer-gen.cc"
yy1213:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 641 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64X2Neg); }
#line 7005 "src/prebuilt/wast-lexer-gen.cc"
yy1215:
		yych = *++cursor_;
		if (yych == 'l') goto yy1410;
		goto yy87;
yy1216:
		yych = *++cursor_;
		if (yych == 'a') goto yy1411;
		goto yy87;
yy1217:
		yych = *++cursor_;
		if (yych == 't') goto yy1412;
		goto yy87;
yy1218:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 651 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64X2Sub); }
#line 7025 "src/prebuilt/wast-lexer-gen.cc"
yy1220:
		yych = *++cursor_;
		if (yych == 'l') goto yy1414;
		goto yy87;
yy1221:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 671 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(LocalGet); }
#line 7037 "src/prebuilt/wast-lexer-gen.cc"
yy1223:
		yych = *++cursor_;
		if (yych == 't') goto yy1416;
		goto yy87;
yy1224:
		yych = *++cursor_;
		if (yych == 't') goto yy1418;
		goto yy87;
yy1225:
		yych = *++cursor_;
		if (yych == 'r') goto yy1420;
		goto yy87;
yy1226:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy1227;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy1421;
				if (yych <= '~') goto yy86;
			}
		}
yy1227:
#line 551 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8Add); }
#line 7070 "src/prebuilt/wast-lexer-gen.cc"
yy1228:
		yych = *++cursor_;
		if (yych == '_') goto yy1422;
		goto yy87;
yy1229:
		yych = *++cursor_;
		if (yych == '_') goto yy1423;
		goto yy87;
yy1230:
		yych = *++cursor_;
		if (yych == 'r') goto yy1424;
		goto yy87;
yy1231:
		yych = *++cursor_;
		if (yych == 's') goto yy1425;
		if (yych == 'u') goto yy1427;
		goto yy87;
yy1232:
		yych = *++cursor_;
		if (yych == 's') goto yy1429;
		if (yych == 'u') goto yy1431;
		goto yy87;
yy1233:
		yych = *++cursor_;
		if (yych == 's') goto yy1433;
		if (yych == 'u') goto yy1435;
		goto yy87;
yy1234:
		yych = *++cursor_;
		if (yych == 's') goto yy1437;
		if (yych == 'u') goto yy1439;
		goto yy87;
yy1235:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 559 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8Mul); }
#line 7110 "src/prebuilt/wast-lexer-gen.cc"
yy1237:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 562 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I16X8Neg); }
#line 7118 "src/prebuilt/wast-lexer-gen.cc"
yy1239:
		yych = *++cursor_;
		if (yych == 'l') goto yy1441;
		goto yy87;
yy1240:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 574 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8Shl); }
#line 7130 "src/prebuilt/wast-lexer-gen.cc"
yy1242:
		yych = *++cursor_;
		if (yych == '_') goto yy1442;
		goto yy87;
yy1243:
		yych = *++cursor_;
		if (yych == 'a') goto yy1443;
		goto yy87;
yy1244:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy1245;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy1444;
				if (yych <= '~') goto yy86;
			}
		}
yy1245:
#line 555 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8Sub); }
#line 7159 "src/prebuilt/wast-lexer-gen.cc"
yy1246:
		yych = *++cursor_;
		if (yych == 'c') goto yy1445;
		goto yy87;
yy1247:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 306 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Const, I32Const); }
#line 7171 "src/prebuilt/wast-lexer-gen.cc"
yy1249:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 343 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32DivS); }
#line 7179 "src/prebuilt/wast-lexer-gen.cc"
yy1251:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 345 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32DivU); }
#line 7187 "src/prebuilt/wast-lexer-gen.cc"
yy1253:
		yych = *++cursor_;
		if (yych == 'd') goto yy1446;
		goto yy87;
yy1254:
		yych = *++cursor_;
		if (yych == '6') goto yy1447;
		goto yy87;
yy1255:
		yych = *++cursor_;
		if (yych == '_') goto yy1448;
		goto yy87;
yy1256:
		yych = *++cursor_;
		if (yych == 't') goto yy1449;
		goto yy87;
yy1257:
		yych = *++cursor_;
		if (yych == 'e') goto yy1451;
		goto yy87;
yy1258:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 347 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32RemS); }
#line 7215 "src/prebuilt/wast-lexer-gen.cc"
yy1260:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 349 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32RemU); }
#line 7223 "src/prebuilt/wast-lexer-gen.cc"
yy1262:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 359 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32ShrS); }
#line 7231 "src/prebuilt/wast-lexer-gen.cc"
yy1264:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 361 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32ShrU); }
#line 7239 "src/prebuilt/wast-lexer-gen.cc"
yy1266:
		++cursor_;
		if ((yych = *cursor_) <= '0') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= '8') {
				if (yych <= '1') goto yy1452;
				if (yych <= '7') goto yy86;
				goto yy1453;
			} else {
				if (yych == ';') goto yy1267;
				if (yych <= '~') goto yy86;
			}
		}
yy1267:
#line 285 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I32Store); }
#line 7262 "src/prebuilt/wast-lexer-gen.cc"
yy1268:
		yych = *++cursor_;
		if (yych == '_') goto yy1455;
		goto yy87;
yy1269:
		yych = *++cursor_;
		if (yych == 'i') goto yy1456;
		goto yy87;
yy1270:
		yych = *++cursor_;
		if (yych == 'i') goto yy1457;
		goto yy87;
yy1271:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 552 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32X4Add); }
#line 7282 "src/prebuilt/wast-lexer-gen.cc"
yy1273:
		yych = *++cursor_;
		if (yych == '_') goto yy1458;
		goto yy87;
yy1274:
		yych = *++cursor_;
		if (yych == '_') goto yy1459;
		goto yy87;
yy1275:
		yych = *++cursor_;
		if (yych == 'r') goto yy1460;
		goto yy87;
yy1276:
		yych = *++cursor_;
		if (yych == 's') goto yy1461;
		if (yych == 'u') goto yy1463;
		goto yy87;
yy1277:
		yych = *++cursor_;
		if (yych == 's') goto yy1465;
		if (yych == 'u') goto yy1467;
		goto yy87;
yy1278:
		yych = *++cursor_;
		if (yych == 's') goto yy1469;
		if (yych == 'u') goto yy1471;
		goto yy87;
yy1279:
		yych = *++cursor_;
		if (yych == 's') goto yy1473;
		if (yych == 'u') goto yy1475;
		goto yy87;
yy1280:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 560 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32X4Mul); }
#line 7322 "src/prebuilt/wast-lexer-gen.cc"
yy1282:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 563 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32X4Neg); }
#line 7330 "src/prebuilt/wast-lexer-gen.cc"
yy1284:
		yych = *++cursor_;
		if (yych == 'l') goto yy1477;
		goto yy87;
yy1285:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 575 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32X4Shl); }
#line 7342 "src/prebuilt/wast-lexer-gen.cc"
yy1287:
		yych = *++cursor_;
		if (yych == '_') goto yy1478;
		goto yy87;
yy1288:
		yych = *++cursor_;
		if (yych == 'a') goto yy1479;
		goto yy87;
yy1289:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 556 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32X4Sub); }
#line 7358 "src/prebuilt/wast-lexer-gen.cc"
yy1291:
		yych = *++cursor_;
		if (yych == 'n') goto yy1480;
		goto yy87;
yy1292:
		yych = *++cursor_;
		if (yych == 'c') goto yy1481;
		goto yy87;
yy1293:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 307 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Const, I64Const); }
#line 7374 "src/prebuilt/wast-lexer-gen.cc"
yy1295:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 344 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64DivS); }
#line 7382 "src/prebuilt/wast-lexer-gen.cc"
yy1297:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 346 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64DivU); }
#line 7390 "src/prebuilt/wast-lexer-gen.cc"
yy1299:
		yych = *++cursor_;
		if (yych == 'd') goto yy1482;
		goto yy87;
yy1300:
		yych = *++cursor_;
		if (yych == '6') goto yy1483;
		goto yy87;
yy1301:
		yych = *++cursor_;
		if (yych == '2') goto yy1484;
		goto yy87;
yy1302:
		yych = *++cursor_;
		if (yych == '_') goto yy1485;
		goto yy87;
yy1303:
		yych = *++cursor_;
		if (yych == 't') goto yy1486;
		goto yy87;
yy1304:
		yych = *++cursor_;
		if (yych == 'e') goto yy1488;
		goto yy87;
yy1305:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 348 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64RemS); }
#line 7422 "src/prebuilt/wast-lexer-gen.cc"
yy1307:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 350 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64RemU); }
#line 7430 "src/prebuilt/wast-lexer-gen.cc"
yy1309:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 360 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64ShrS); }
#line 7438 "src/prebuilt/wast-lexer-gen.cc"
yy1311:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 362 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64ShrU); }
#line 7446 "src/prebuilt/wast-lexer-gen.cc"
yy1313:
		++cursor_;
		if ((yych = *cursor_) <= '1') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy1314;
				if (yych <= '0') goto yy86;
				goto yy1489;
			}
		} else {
			if (yych <= '8') {
				if (yych == '3') goto yy1490;
				if (yych <= '7') goto yy86;
				goto yy1491;
			} else {
				if (yych == ';') goto yy1314;
				if (yych <= '~') goto yy86;
			}
		}
yy1314:
#line 286 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I64Store); }
#line 7471 "src/prebuilt/wast-lexer-gen.cc"
yy1315:
		yych = *++cursor_;
		if (yych == '_') goto yy1493;
		goto yy87;
yy1316:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 553 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64X2Add); }
#line 7483 "src/prebuilt/wast-lexer-gen.cc"
yy1318:
		yych = *++cursor_;
		if (yych == '_') goto yy1494;
		goto yy87;
yy1319:
		yych = *++cursor_;
		if (yych == '_') goto yy1495;
		goto yy87;
yy1320:
		yych = *++cursor_;
		if (yych == 'r') goto yy1496;
		goto yy87;
yy1321:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 564 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64X2Neg); }
#line 7503 "src/prebuilt/wast-lexer-gen.cc"
yy1323:
		yych = *++cursor_;
		if (yych == 'l') goto yy1497;
		goto yy87;
yy1324:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 576 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64X2Shl); }
#line 7515 "src/prebuilt/wast-lexer-gen.cc"
yy1326:
		yych = *++cursor_;
		if (yych == '_') goto yy1498;
		goto yy87;
yy1327:
		yych = *++cursor_;
		if (yych == 'a') goto yy1499;
		goto yy87;
yy1328:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 557 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64X2Sub); }
#line 7531 "src/prebuilt/wast-lexer-gen.cc"
yy1330:
		yych = *++cursor_;
		if (yych == 'n') goto yy1500;
		goto yy87;
yy1331:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy1332;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy1501;
				if (yych <= '~') goto yy86;
			}
		}
yy1332:
#line 550 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16Add); }
#line 7556 "src/prebuilt/wast-lexer-gen.cc"
yy1333:
		yych = *++cursor_;
		if (yych == '_') goto yy1502;
		goto yy87;
yy1334:
		yych = *++cursor_;
		if (yych == '_') goto yy1503;
		goto yy87;
yy1335:
		yych = *++cursor_;
		if (yych == 'r') goto yy1504;
		goto yy87;
yy1336:
		yych = *++cursor_;
		if (yych == 's') goto yy1505;
		if (yych == 'u') goto yy1507;
		goto yy87;
yy1337:
		yych = *++cursor_;
		if (yych == 's') goto yy1509;
		if (yych == 'u') goto yy1511;
		goto yy87;
yy1338:
		yych = *++cursor_;
		if (yych == 's') goto yy1513;
		if (yych == 'u') goto yy1515;
		goto yy87;
yy1339:
		yych = *++cursor_;
		if (yych == 's') goto yy1517;
		if (yych == 'u') goto yy1519;
		goto yy87;
yy1340:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 558 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16Mul); }
#line 7596 "src/prebuilt/wast-lexer-gen.cc"
yy1342:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 561 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I8X16Neg); }
#line 7604 "src/prebuilt/wast-lexer-gen.cc"
yy1344:
		yych = *++cursor_;
		if (yych == 'l') goto yy1521;
		goto yy87;
yy1345:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 573 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16Shl); }
#line 7616 "src/prebuilt/wast-lexer-gen.cc"
yy1347:
		yych = *++cursor_;
		if (yych == '_') goto yy1522;
		goto yy87;
yy1348:
		yych = *++cursor_;
		if (yych == 'a') goto yy1523;
		goto yy87;
yy1349:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy1350;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy1524;
				if (yych <= '~') goto yy86;
			}
		}
yy1350:
#line 554 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16Sub); }
#line 7645 "src/prebuilt/wast-lexer-gen.cc"
yy1351:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 744 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(IfExcept); }
#line 7653 "src/prebuilt/wast-lexer-gen.cc"
yy1353:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 276 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(LocalGet); }
#line 7661 "src/prebuilt/wast-lexer-gen.cc"
yy1355:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 277 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(LocalSet); }
#line 7669 "src/prebuilt/wast-lexer-gen.cc"
yy1357:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 278 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(LocalTee); }
#line 7677 "src/prebuilt/wast-lexer-gen.cc"
yy1359:
		yych = *++cursor_;
		if (yych == 'p') goto yy1525;
		goto yy87;
yy1360:
		yych = *++cursor_;
		if (yych == 'o') goto yy1526;
		goto yy87;
yy1361:
		yych = *++cursor_;
		if (yych == 'l') goto yy1527;
		goto yy87;
yy1362:
		yych = *++cursor_;
		if (yych == 'o') goto yy1528;
		goto yy87;
yy1363:
		yych = *++cursor_;
		if (yych == 'i') goto yy1529;
		goto yy87;
yy1364:
		yych = *++cursor_;
		if (yych == 'z') goto yy1530;
		goto yy87;
yy1365:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy88;
				goto yy86;
			} else {
				if (yych <= '"') goto yy88;
				if (yych <= '\'') goto yy86;
				goto yy88;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy1118;
				goto yy86;
			} else {
				if (yych <= ';') goto yy88;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy1366:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy88;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy88;
				if (yych <= '/') goto yy86;
				goto yy1531;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy88;
				if (yych <= '@') goto yy86;
				goto yy1531;
			} else {
				if (yych <= '`') goto yy86;
				if (yych <= 'f') goto yy1531;
				if (yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy1367:
		yych = *++cursor_;
		if (yych == 'l') goto yy1533;
		goto yy87;
yy1368:
		yych = *++cursor_;
		if (yych == 'l') goto yy1534;
		goto yy87;
yy1369:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 672 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(LocalSet); }
#line 7767 "src/prebuilt/wast-lexer-gen.cc"
yy1371:
		yych = *++cursor_;
		if (yych == 'y') goto yy1536;
		goto yy87;
yy1372:
		yych = *++cursor_;
		if (yych == 'p') goto yy1538;
		goto yy87;
yy1373:
		yych = *++cursor_;
		if (yych == 't') goto yy1540;
		goto yy87;
yy1374:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 673 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(LocalTee); }
#line 7787 "src/prebuilt/wast-lexer-gen.cc"
yy1376:
		yych = *++cursor_;
		if (yych == 'l') goto yy1542;
		goto yy87;
yy1377:
		yych = *++cursor_;
		if (yych == 'e') goto yy1543;
		goto yy87;
yy1378:
		yych = *++cursor_;
		if (yych == 't') goto yy1544;
		goto yy87;
yy1379:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 527 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load,  V128Load); }
#line 7807 "src/prebuilt/wast-lexer-gen.cc"
yy1381:
		yych = *++cursor_;
		if (yych == 'e') goto yy1546;
		goto yy87;
yy1382:
		yych = *++cursor_;
		if (yych == 'f') goto yy1548;
		goto yy87;
yy1383:
		yych = *++cursor_;
		if (yych == 'a') goto yy1549;
		goto yy87;
yy1384:
		yych = *++cursor_;
		if (yych == 'a') goto yy1550;
		goto yy87;
yy1385:
		yych = *++cursor_;
		if (yych == 'f') goto yy1551;
		goto yy87;
yy1386:
		yych = *++cursor_;
		if (yych == 'u') goto yy1552;
		goto yy87;
yy1387:
		yych = *++cursor_;
		if (yych == 'p') goto yy1553;
		goto yy87;
yy1388:
		yych = *++cursor_;
		if (yych == 'i') goto yy1555;
		goto yy87;
yy1389:
		yych = *++cursor_;
		if (yych == 'i') goto yy1556;
		goto yy87;
yy1390:
		yych = *++cursor_;
		if (yych == 'e') goto yy1557;
		goto yy87;
yy1391:
		yych = *++cursor_;
		if (yych == 'm') goto yy1558;
		goto yy87;
yy1392:
		yych = *++cursor_;
		if (yych == 't') goto yy1559;
		goto yy87;
yy1393:
		yych = *++cursor_;
		if (yych == 'g') goto yy1560;
		goto yy87;
yy1394:
		yych = *++cursor_;
		if (yych == '/') goto yy1561;
		if (yych == '_') goto yy1562;
		goto yy87;
yy1395:
		yych = *++cursor_;
		if (yych == 't') goto yy1563;
		goto yy87;
yy1396:
		yych = *++cursor_;
		if (yych == 'r') goto yy1565;
		goto yy87;
yy1397:
		yych = *++cursor_;
		if (yych == 'e') goto yy1566;
		goto yy87;
yy1398:
		yych = *++cursor_;
		if (yych == 'a') goto yy1567;
		goto yy87;
yy1399:
		yych = *++cursor_;
		if (yych == 'a') goto yy1568;
		goto yy87;
yy1400:
		yych = *++cursor_;
		if (yych == 't') goto yy1569;
		goto yy87;
yy1401:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 656 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32X4Sqrt); }
#line 7896 "src/prebuilt/wast-lexer-gen.cc"
yy1403:
		yych = *++cursor_;
		if (yych == 't') goto yy1571;
		goto yy87;
yy1404:
		yych = *++cursor_;
		if (yych == 'g') goto yy1572;
		goto yy87;
yy1405:
		yych = *++cursor_;
		if (yych == 't') goto yy1573;
		goto yy87;
yy1406:
		yych = *++cursor_;
		if (yych == 'e') goto yy1575;
		goto yy87;
yy1407:
		yych = *++cursor_;
		if (yych == 'r') goto yy1576;
		goto yy87;
yy1408:
		yych = *++cursor_;
		if (yych == 'e') goto yy1577;
		goto yy87;
yy1409:
		yych = *++cursor_;
		if (yych == 'a') goto yy1578;
		goto yy87;
yy1410:
		yych = *++cursor_;
		if (yych == 'a') goto yy1579;
		goto yy87;
yy1411:
		yych = *++cursor_;
		if (yych == 't') goto yy1580;
		goto yy87;
yy1412:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 657 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64X2Sqrt); }
#line 7940 "src/prebuilt/wast-lexer-gen.cc"
yy1414:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 674 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(GlobalGet); }
#line 7948 "src/prebuilt/wast-lexer-gen.cc"
yy1416:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 279 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(GlobalGet); }
#line 7956 "src/prebuilt/wast-lexer-gen.cc"
yy1418:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 280 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(GlobalSet); }
#line 7964 "src/prebuilt/wast-lexer-gen.cc"
yy1420:
		yych = *++cursor_;
		if (yych == 'y') goto yy1582;
		goto yy87;
yy1421:
		yych = *++cursor_;
		if (yych == 's') goto yy1584;
		goto yy87;
yy1422:
		yych = *++cursor_;
		if (yych == 't') goto yy1585;
		goto yy87;
yy1423:
		yych = *++cursor_;
		if (yych == 't') goto yy1586;
		goto yy87;
yy1424:
		yych = *++cursor_;
		if (yych == 'a') goto yy1587;
		goto yy87;
yy1425:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 634 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8GeS); }
#line 7992 "src/prebuilt/wast-lexer-gen.cc"
yy1427:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 635 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8GeU); }
#line 8000 "src/prebuilt/wast-lexer-gen.cc"
yy1429:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 626 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8GtS); }
#line 8008 "src/prebuilt/wast-lexer-gen.cc"
yy1431:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 627 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8GtU); }
#line 8016 "src/prebuilt/wast-lexer-gen.cc"
yy1433:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 618 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8LeS); }
#line 8024 "src/prebuilt/wast-lexer-gen.cc"
yy1435:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 619 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8LeU); }
#line 8032 "src/prebuilt/wast-lexer-gen.cc"
yy1437:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 610 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8LtS); }
#line 8040 "src/prebuilt/wast-lexer-gen.cc"
yy1439:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 611 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8LtU); }
#line 8048 "src/prebuilt/wast-lexer-gen.cc"
yy1441:
		yych = *++cursor_;
		if (yych == 'a') goto yy1588;
		goto yy87;
yy1442:
		yych = *++cursor_;
		if (yych == 's') goto yy1589;
		if (yych == 'u') goto yy1591;
		goto yy87;
yy1443:
		yych = *++cursor_;
		if (yych == 't') goto yy1593;
		goto yy87;
yy1444:
		yych = *++cursor_;
		if (yych == 's') goto yy1595;
		goto yy87;
yy1445:
		yych = *++cursor_;
		if (yych == '.') goto yy1596;
		goto yy87;
yy1446:
		yych = *++cursor_;
		if (yych == '1') goto yy1597;
		if (yych == '8') goto yy1598;
		goto yy87;
yy1447:
		yych = *++cursor_;
		if (yych == '_') goto yy1599;
		goto yy87;
yy1448:
		yych = *++cursor_;
		if (yych == 's') goto yy1600;
		if (yych == 'u') goto yy1602;
		goto yy87;
yy1449:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 316 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32Popcnt); }
#line 8091 "src/prebuilt/wast-lexer-gen.cc"
yy1451:
		yych = *++cursor_;
		if (yych == 'r') goto yy1604;
		goto yy87;
yy1452:
		yych = *++cursor_;
		if (yych == '6') goto yy1605;
		goto yy87;
yy1453:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 299 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I32Store8); }
#line 8107 "src/prebuilt/wast-lexer-gen.cc"
yy1455:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'f') goto yy1607;
			goto yy87;
		} else {
			if (yych <= 's') goto yy1608;
			if (yych == 'u') goto yy1609;
			goto yy87;
		}
yy1456:
		yych = *++cursor_;
		if (yych == '6') goto yy1610;
		goto yy87;
yy1457:
		yych = *++cursor_;
		if (yych == '6') goto yy1611;
		goto yy87;
yy1458:
		yych = *++cursor_;
		if (yych == 't') goto yy1612;
		goto yy87;
yy1459:
		yych = *++cursor_;
		if (yych == 't') goto yy1613;
		goto yy87;
yy1460:
		yych = *++cursor_;
		if (yych == 'a') goto yy1614;
		goto yy87;
yy1461:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 636 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4GeS); }
#line 8145 "src/prebuilt/wast-lexer-gen.cc"
yy1463:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 637 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4GeU); }
#line 8153 "src/prebuilt/wast-lexer-gen.cc"
yy1465:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 628 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4GtS); }
#line 8161 "src/prebuilt/wast-lexer-gen.cc"
yy1467:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 629 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4GtU); }
#line 8169 "src/prebuilt/wast-lexer-gen.cc"
yy1469:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 620 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4LeS); }
#line 8177 "src/prebuilt/wast-lexer-gen.cc"
yy1471:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 621 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4LeU); }
#line 8185 "src/prebuilt/wast-lexer-gen.cc"
yy1473:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 612 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4LtS); }
#line 8193 "src/prebuilt/wast-lexer-gen.cc"
yy1475:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 613 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4LtU); }
#line 8201 "src/prebuilt/wast-lexer-gen.cc"
yy1477:
		yych = *++cursor_;
		if (yych == 'a') goto yy1615;
		goto yy87;
yy1478:
		yych = *++cursor_;
		if (yych == 's') goto yy1616;
		if (yych == 'u') goto yy1618;
		goto yy87;
yy1479:
		yych = *++cursor_;
		if (yych == 't') goto yy1620;
		goto yy87;
yy1480:
		yych = *++cursor_;
		if (yych == 'c') goto yy1622;
		goto yy87;
yy1481:
		yych = *++cursor_;
		if (yych == '.') goto yy1623;
		goto yy87;
yy1482:
		yych = *++cursor_;
		if (yych <= '3') {
			if (yych == '1') goto yy1624;
			if (yych <= '2') goto yy87;
			goto yy1625;
		} else {
			if (yych <= '8') {
				if (yych <= '7') goto yy87;
				goto yy1626;
			} else {
				if (yych == '_') goto yy1627;
				goto yy87;
			}
		}
yy1483:
		yych = *++cursor_;
		if (yych == '_') goto yy1628;
		goto yy87;
yy1484:
		yych = *++cursor_;
		if (yych == '_') goto yy1629;
		goto yy87;
yy1485:
		yych = *++cursor_;
		if (yych == 's') goto yy1630;
		if (yych == 'u') goto yy1632;
		goto yy87;
yy1486:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 317 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64Popcnt); }
#line 8258 "src/prebuilt/wast-lexer-gen.cc"
yy1488:
		yych = *++cursor_;
		if (yych == 'r') goto yy1634;
		goto yy87;
yy1489:
		yych = *++cursor_;
		if (yych == '6') goto yy1635;
		goto yy87;
yy1490:
		yych = *++cursor_;
		if (yych == '2') goto yy1637;
		goto yy87;
yy1491:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 300 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I64Store8); }
#line 8278 "src/prebuilt/wast-lexer-gen.cc"
yy1493:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'f') goto yy1639;
			goto yy87;
		} else {
			if (yych <= 's') goto yy1640;
			if (yych == 'u') goto yy1641;
			goto yy87;
		}
yy1494:
		yych = *++cursor_;
		if (yych == 't') goto yy1642;
		goto yy87;
yy1495:
		yych = *++cursor_;
		if (yych == 't') goto yy1643;
		goto yy87;
yy1496:
		yych = *++cursor_;
		if (yych == 'a') goto yy1644;
		goto yy87;
yy1497:
		yych = *++cursor_;
		if (yych == 'a') goto yy1645;
		goto yy87;
yy1498:
		yych = *++cursor_;
		if (yych == 's') goto yy1646;
		if (yych == 'u') goto yy1648;
		goto yy87;
yy1499:
		yych = *++cursor_;
		if (yych == 't') goto yy1650;
		goto yy87;
yy1500:
		yych = *++cursor_;
		if (yych == 'c') goto yy1652;
		goto yy87;
yy1501:
		yych = *++cursor_;
		if (yych == 's') goto yy1653;
		goto yy87;
yy1502:
		yych = *++cursor_;
		if (yych == 't') goto yy1654;
		goto yy87;
yy1503:
		yych = *++cursor_;
		if (yych == 't') goto yy1655;
		goto yy87;
yy1504:
		yych = *++cursor_;
		if (yych == 'a') goto yy1656;
		goto yy87;
yy1505:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 632 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16GeS); }
#line 8341 "src/prebuilt/wast-lexer-gen.cc"
yy1507:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 633 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16GeU); }
#line 8349 "src/prebuilt/wast-lexer-gen.cc"
yy1509:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 624 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16GtS); }
#line 8357 "src/prebuilt/wast-lexer-gen.cc"
yy1511:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 625 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16GtU); }
#line 8365 "src/prebuilt/wast-lexer-gen.cc"
yy1513:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 616 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16LeS); }
#line 8373 "src/prebuilt/wast-lexer-gen.cc"
yy1515:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 617 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16LeU); }
#line 8381 "src/prebuilt/wast-lexer-gen.cc"
yy1517:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 608 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16LtS); }
#line 8389 "src/prebuilt/wast-lexer-gen.cc"
yy1519:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 609 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16LtU); }
#line 8397 "src/prebuilt/wast-lexer-gen.cc"
yy1521:
		yych = *++cursor_;
		if (yych == 'a') goto yy1657;
		goto yy87;
yy1522:
		yych = *++cursor_;
		if (yych == 's') goto yy1658;
		if (yych == 'u') goto yy1660;
		goto yy87;
yy1523:
		yych = *++cursor_;
		if (yych == 't') goto yy1662;
		goto yy87;
yy1524:
		yych = *++cursor_;
		if (yych == 's') goto yy1664;
		goto yy87;
yy1525:
		yych = *++cursor_;
		if (yych == 'y') goto yy1665;
		goto yy87;
yy1526:
		yych = *++cursor_;
		if (yych == 'p') goto yy1667;
		goto yy87;
yy1527:
		yych = *++cursor_;
		if (yych == 'l') goto yy1669;
		goto yy87;
yy1528:
		yych = *++cursor_;
		if (yych == 'w') goto yy1671;
		goto yy87;
yy1529:
		yych = *++cursor_;
		if (yych == 't') goto yy1673;
		goto yy87;
yy1530:
		yych = *++cursor_;
		if (yych == 'e') goto yy1675;
		goto yy87;
yy1531:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych <= '"') goto yy1117;
				goto yy86;
			} else {
				if (yych <= ')') goto yy1117;
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy1531;
				goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') goto yy1117;
				if (yych <= '@') goto yy86;
				if (yych <= 'F') goto yy1531;
				goto yy86;
			} else {
				if (yych <= '`') {
					if (yych <= '_') goto yy1366;
					goto yy86;
				} else {
					if (yych <= 'f') goto yy1531;
					if (yych <= '~') goto yy86;
					goto yy1117;
				}
			}
		}
yy1533:
		yych = *++cursor_;
		if (yych == 'l') goto yy1677;
		goto yy87;
yy1534:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 675 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(GlobalSet); }
#line 8482 "src/prebuilt/wast-lexer-gen.cc"
yy1536:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 458 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(TableCopy); }
#line 8490 "src/prebuilt/wast-lexer-gen.cc"
yy1538:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 457 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(TableDrop); }
#line 8498 "src/prebuilt/wast-lexer-gen.cc"
yy1540:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 456 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(TableInit); }
#line 8506 "src/prebuilt/wast-lexer-gen.cc"
yy1542:
		yych = *++cursor_;
		if (yych == 'e') goto yy1679;
		goto yy87;
yy1543:
		yych = *++cursor_;
		if (yych == 'l') goto yy1681;
		goto yy87;
yy1544:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 526 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Const, V128Const); }
#line 8522 "src/prebuilt/wast-lexer-gen.cc"
yy1546:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 528 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, V128Store); }
#line 8530 "src/prebuilt/wast-lexer-gen.cc"
yy1548:
		yych = *++cursor_;
		if (yych == 'f') goto yy1682;
		goto yy87;
yy1549:
		yych = *++cursor_;
		if (yych == 'u') goto yy1683;
		goto yy87;
yy1550:
		yych = *++cursor_;
		if (yych == 'l') goto yy1684;
		goto yy87;
yy1551:
		yych = *++cursor_;
		if (yych == 'o') goto yy1685;
		goto yy87;
yy1552:
		yych = *++cursor_;
		if (yych == 'r') goto yy1686;
		goto yy87;
yy1553:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 738 "src/wast-lexer.cc"
		{ RETURN(AssertTrap); }
#line 8558 "src/prebuilt/wast-lexer-gen.cc"
yy1555:
		yych = *++cursor_;
		if (yych == 'n') goto yy1687;
		goto yy87;
yy1556:
		yych = *++cursor_;
		if (yych == 'f') goto yy1688;
		goto yy87;
yy1557:
		yych = *++cursor_;
		if (yych == 'c') goto yy1689;
		goto yy87;
yy1558:
		yych = *++cursor_;
		if (yych == 'o') goto yy1690;
		goto yy87;
yy1559:
		yych = *++cursor_;
		if (yych == '_') goto yy1691;
		goto yy87;
yy1560:
		yych = *++cursor_;
		if (yych == 'n') goto yy1692;
		goto yy87;
yy1561:
		yych = *++cursor_;
		if (yych == 'f') goto yy1694;
		goto yy87;
yy1562:
		yych = *++cursor_;
		if (yych == 'f') goto yy1695;
		goto yy87;
yy1563:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 330 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Nearest); }
#line 8598 "src/prebuilt/wast-lexer-gen.cc"
yy1565:
		yych = *++cursor_;
		if (yych == 'p') goto yy1696;
		goto yy87;
yy1566:
		yych = *++cursor_;
		if (yych == 'r') goto yy1697;
		goto yy87;
yy1567:
		yych = *++cursor_;
		if (yych == 'c') goto yy1698;
		goto yy87;
yy1568:
		yych = *++cursor_;
		if (yych == 'c') goto yy1699;
		goto yy87;
yy1569:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 533 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32X4Splat); }
#line 8622 "src/prebuilt/wast-lexer-gen.cc"
yy1571:
		yych = *++cursor_;
		if (yych == '_') goto yy1700;
		goto yy87;
yy1572:
		yych = *++cursor_;
		if (yych == 'n') goto yy1701;
		goto yy87;
yy1573:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 331 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Nearest); }
#line 8638 "src/prebuilt/wast-lexer-gen.cc"
yy1575:
		yych = *++cursor_;
		if (yych == '/') goto yy1703;
		if (yych == '_') goto yy1704;
		goto yy87;
yy1576:
		yych = *++cursor_;
		if (yych == 'p') goto yy1705;
		goto yy87;
yy1577:
		yych = *++cursor_;
		if (yych == 'r') goto yy1706;
		goto yy87;
yy1578:
		yych = *++cursor_;
		if (yych == 'c') goto yy1707;
		goto yy87;
yy1579:
		yych = *++cursor_;
		if (yych == 'c') goto yy1708;
		goto yy87;
yy1580:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 534 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64X2Splat); }
#line 8667 "src/prebuilt/wast-lexer-gen.cc"
yy1582:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 455 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(MemoryGrow); }
#line 8675 "src/prebuilt/wast-lexer-gen.cc"
yy1584:
		yych = *++cursor_;
		if (yych == 'a') goto yy1709;
		goto yy87;
yy1585:
		yych = *++cursor_;
		if (yych == 'r') goto yy1710;
		goto yy87;
yy1586:
		yych = *++cursor_;
		if (yych == 'r') goto yy1711;
		goto yy87;
yy1587:
		yych = *++cursor_;
		if (yych == 'c') goto yy1712;
		goto yy87;
yy1588:
		yych = *++cursor_;
		if (yych == 'c') goto yy1713;
		goto yy87;
yy1589:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 579 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8ShrS); }
#line 8703 "src/prebuilt/wast-lexer-gen.cc"
yy1591:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 580 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8ShrU); }
#line 8711 "src/prebuilt/wast-lexer-gen.cc"
yy1593:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 530 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I16X8Splat); }
#line 8719 "src/prebuilt/wast-lexer-gen.cc"
yy1595:
		yych = *++cursor_;
		if (yych == 'a') goto yy1714;
		goto yy87;
yy1596:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'l') goto yy1715;
			if (yych <= 'q') goto yy87;
			goto yy1716;
		} else {
			if (yych <= 's') goto yy1717;
			if (yych == 'w') goto yy1718;
			goto yy87;
		}
yy1597:
		yych = *++cursor_;
		if (yych == '6') goto yy1719;
		goto yy87;
yy1598:
		yych = *++cursor_;
		if (yych == '_') goto yy1720;
		goto yy87;
yy1599:
		yych = *++cursor_;
		if (yych == 's') goto yy1721;
		if (yych == 'u') goto yy1723;
		goto yy87;
yy1600:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 289 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I32Load8S); }
#line 8755 "src/prebuilt/wast-lexer-gen.cc"
yy1602:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 291 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I32Load8U); }
#line 8763 "src/prebuilt/wast-lexer-gen.cc"
yy1604:
		yych = *++cursor_;
		if (yych == 'p') goto yy1725;
		goto yy87;
yy1605:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 301 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I32Store16); }
#line 8775 "src/prebuilt/wast-lexer-gen.cc"
yy1607:
		yych = *++cursor_;
		if (yych == '3') goto yy1726;
		if (yych == '6') goto yy1727;
		goto yy87;
yy1608:
		yych = *++cursor_;
		if (yych <= '9') {
			if (yych == '/') goto yy1728;
			goto yy87;
		} else {
			if (yych <= ':') goto yy1729;
			if (yych == 'a') goto yy1730;
			goto yy87;
		}
yy1609:
		yych = *++cursor_;
		if (yych == '/') goto yy1731;
		if (yych == ':') goto yy1732;
		goto yy87;
yy1610:
		yych = *++cursor_;
		if (yych == '4') goto yy1733;
		goto yy87;
yy1611:
		yych = *++cursor_;
		if (yych == '4') goto yy1735;
		goto yy87;
yy1612:
		yych = *++cursor_;
		if (yych == 'r') goto yy1737;
		goto yy87;
yy1613:
		yych = *++cursor_;
		if (yych == 'r') goto yy1738;
		goto yy87;
yy1614:
		yych = *++cursor_;
		if (yych == 'c') goto yy1739;
		goto yy87;
yy1615:
		yych = *++cursor_;
		if (yych == 'c') goto yy1740;
		goto yy87;
yy1616:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 581 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32X4ShrS); }
#line 8827 "src/prebuilt/wast-lexer-gen.cc"
yy1618:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 582 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32X4ShrU); }
#line 8835 "src/prebuilt/wast-lexer-gen.cc"
yy1620:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 531 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32X4Splat); }
#line 8843 "src/prebuilt/wast-lexer-gen.cc"
yy1622:
		yych = *++cursor_;
		if (yych == '_') goto yy1741;
		goto yy87;
yy1623:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'l') goto yy1742;
			if (yych <= 'q') goto yy87;
			goto yy1743;
		} else {
			if (yych <= 's') goto yy1744;
			if (yych == 'w') goto yy1745;
			goto yy87;
		}
yy1624:
		yych = *++cursor_;
		if (yych == '6') goto yy1746;
		goto yy87;
yy1625:
		yych = *++cursor_;
		if (yych == '2') goto yy1747;
		goto yy87;
yy1626:
		yych = *++cursor_;
		if (yych == '_') goto yy1748;
		goto yy87;
yy1627:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'i') goto yy1749;
			goto yy87;
		} else {
			if (yych <= 's') goto yy1750;
			if (yych == 'u') goto yy1751;
			goto yy87;
		}
yy1628:
		yych = *++cursor_;
		if (yych == 's') goto yy1752;
		if (yych == 'u') goto yy1754;
		goto yy87;
yy1629:
		yych = *++cursor_;
		if (yych == 's') goto yy1756;
		if (yych == 'u') goto yy1758;
		goto yy87;
yy1630:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 290 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load8S); }
#line 8898 "src/prebuilt/wast-lexer-gen.cc"
yy1632:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 292 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load8U); }
#line 8906 "src/prebuilt/wast-lexer-gen.cc"
yy1634:
		yych = *++cursor_;
		if (yych == 'p') goto yy1760;
		goto yy87;
yy1635:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 302 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I64Store16); }
#line 8918 "src/prebuilt/wast-lexer-gen.cc"
yy1637:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 303 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I64Store32); }
#line 8926 "src/prebuilt/wast-lexer-gen.cc"
yy1639:
		yych = *++cursor_;
		if (yych == '3') goto yy1761;
		if (yych == '6') goto yy1762;
		goto yy87;
yy1640:
		yych = *++cursor_;
		if (yych <= '9') {
			if (yych == '/') goto yy1763;
			goto yy87;
		} else {
			if (yych <= ':') goto yy1764;
			if (yych == 'a') goto yy1765;
			goto yy87;
		}
yy1641:
		yych = *++cursor_;
		if (yych == '/') goto yy1766;
		if (yych == ':') goto yy1767;
		goto yy87;
yy1642:
		yych = *++cursor_;
		if (yych == 'r') goto yy1768;
		goto yy87;
yy1643:
		yych = *++cursor_;
		if (yych == 'r') goto yy1769;
		goto yy87;
yy1644:
		yych = *++cursor_;
		if (yych == 'c') goto yy1770;
		goto yy87;
yy1645:
		yych = *++cursor_;
		if (yych == 'c') goto yy1771;
		goto yy87;
yy1646:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 583 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64X2ShrS); }
#line 8970 "src/prebuilt/wast-lexer-gen.cc"
yy1648:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 584 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64X2ShrU); }
#line 8978 "src/prebuilt/wast-lexer-gen.cc"
yy1650:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 532 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64X2Splat); }
#line 8986 "src/prebuilt/wast-lexer-gen.cc"
yy1652:
		yych = *++cursor_;
		if (yych == '_') goto yy1772;
		goto yy87;
yy1653:
		yych = *++cursor_;
		if (yych == 'a') goto yy1773;
		goto yy87;
yy1654:
		yych = *++cursor_;
		if (yych == 'r') goto yy1774;
		goto yy87;
yy1655:
		yych = *++cursor_;
		if (yych == 'r') goto yy1775;
		goto yy87;
yy1656:
		yych = *++cursor_;
		if (yych == 'c') goto yy1776;
		goto yy87;
yy1657:
		yych = *++cursor_;
		if (yych == 'c') goto yy1777;
		goto yy87;
yy1658:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 577 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16ShrS); }
#line 9018 "src/prebuilt/wast-lexer-gen.cc"
yy1660:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 578 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16ShrU); }
#line 9026 "src/prebuilt/wast-lexer-gen.cc"
yy1662:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 529 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I8X16Splat); }
#line 9034 "src/prebuilt/wast-lexer-gen.cc"
yy1664:
		yych = *++cursor_;
		if (yych == 'a') goto yy1778;
		goto yy87;
yy1665:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 452 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(MemoryCopy); }
#line 9046 "src/prebuilt/wast-lexer-gen.cc"
yy1667:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 451 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(MemoryDrop); }
#line 9054 "src/prebuilt/wast-lexer-gen.cc"
yy1669:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 453 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(MemoryFill); }
#line 9062 "src/prebuilt/wast-lexer-gen.cc"
yy1671:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 449 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(MemoryGrow); }
#line 9070 "src/prebuilt/wast-lexer-gen.cc"
yy1673:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 450 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(MemoryInit); }
#line 9078 "src/prebuilt/wast-lexer-gen.cc"
yy1675:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 448 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(MemorySize); }
#line 9086 "src/prebuilt/wast-lexer-gen.cc"
yy1677:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy1678;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy1779;
				if (yych <= '~') goto yy86;
			}
		}
yy1678:
#line 666 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(ReturnCall); }
#line 9107 "src/prebuilt/wast-lexer-gen.cc"
yy1679:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 447 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Unreachable); }
#line 9115 "src/prebuilt/wast-lexer-gen.cc"
yy1681:
		yych = *++cursor_;
		if (yych == 'e') goto yy1780;
		goto yy87;
yy1682:
		yych = *++cursor_;
		if (yych == 'l') goto yy1781;
		goto yy87;
yy1683:
		yych = *++cursor_;
		if (yych == 's') goto yy1782;
		goto yy87;
yy1684:
		yych = *++cursor_;
		if (yych == 'i') goto yy1783;
		goto yy87;
yy1685:
		yych = *++cursor_;
		if (yych == 'r') goto yy1784;
		goto yy87;
yy1686:
		yych = *++cursor_;
		if (yych == 'n') goto yy1785;
		goto yy87;
yy1687:
		yych = *++cursor_;
		if (yych == 'k') goto yy1787;
		goto yy87;
yy1688:
		yych = *++cursor_;
		if (yych == 'y') goto yy1788;
		goto yy87;
yy1689:
		yych = *++cursor_;
		if (yych == 't') goto yy1790;
		goto yy87;
yy1690:
		yych = *++cursor_;
		if (yych == 'r') goto yy1792;
		goto yy87;
yy1691:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'i') goto yy1793;
			goto yy87;
		} else {
			if (yych <= 's') goto yy1794;
			if (yych == 'u') goto yy1795;
			goto yy87;
		}
yy1692:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 379 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Copysign); }
#line 9173 "src/prebuilt/wast-lexer-gen.cc"
yy1694:
		yych = *++cursor_;
		if (yych == '6') goto yy1796;
		goto yy87;
yy1695:
		yych = *++cursor_;
		if (yych == '6') goto yy1797;
		goto yy87;
yy1696:
		yych = *++cursor_;
		if (yych == 'r') goto yy1798;
		goto yy87;
yy1697:
		yych = *++cursor_;
		if (yych == 't') goto yy1799;
		goto yy87;
yy1698:
		yych = *++cursor_;
		if (yych == 't') goto yy1800;
		goto yy87;
yy1699:
		yych = *++cursor_;
		if (yych == 'e') goto yy1801;
		goto yy87;
yy1700:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'i') goto yy1802;
			goto yy87;
		} else {
			if (yych <= 's') goto yy1803;
			if (yych == 'u') goto yy1804;
			goto yy87;
		}
yy1701:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 380 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Copysign); }
#line 9215 "src/prebuilt/wast-lexer-gen.cc"
yy1703:
		yych = *++cursor_;
		if (yych == 'f') goto yy1805;
		goto yy87;
yy1704:
		yych = *++cursor_;
		if (yych == 'f') goto yy1806;
		goto yy87;
yy1705:
		yych = *++cursor_;
		if (yych == 'r') goto yy1807;
		goto yy87;
yy1706:
		yych = *++cursor_;
		if (yych == 't') goto yy1808;
		goto yy87;
yy1707:
		yych = *++cursor_;
		if (yych == 't') goto yy1809;
		goto yy87;
yy1708:
		yych = *++cursor_;
		if (yych == 'e') goto yy1810;
		goto yy87;
yy1709:
		yych = *++cursor_;
		if (yych == 't') goto yy1811;
		goto yy87;
yy1710:
		yych = *++cursor_;
		if (yych == 'u') goto yy1812;
		goto yy87;
yy1711:
		yych = *++cursor_;
		if (yych == 'u') goto yy1813;
		goto yy87;
yy1712:
		yych = *++cursor_;
		if (yych == 't') goto yy1814;
		goto yy87;
yy1713:
		yych = *++cursor_;
		if (yych == 'e') goto yy1815;
		goto yy87;
yy1714:
		yych = *++cursor_;
		if (yych == 't') goto yy1816;
		goto yy87;
yy1715:
		yych = *++cursor_;
		if (yych == 'o') goto yy1817;
		goto yy87;
yy1716:
		yych = *++cursor_;
		if (yych == 'm') goto yy1818;
		goto yy87;
yy1717:
		yych = *++cursor_;
		if (yych == 't') goto yy1819;
		goto yy87;
yy1718:
		yych = *++cursor_;
		if (yych == 'a') goto yy1820;
		goto yy87;
yy1719:
		yych = *++cursor_;
		if (yych == '_') goto yy1821;
		goto yy87;
yy1720:
		yych = *++cursor_;
		if (yych == 's') goto yy1822;
		goto yy87;
yy1721:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 293 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I32Load16S); }
#line 9295 "src/prebuilt/wast-lexer-gen.cc"
yy1723:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 295 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I32Load16U); }
#line 9303 "src/prebuilt/wast-lexer-gen.cc"
yy1725:
		yych = *++cursor_;
		if (yych == 'r') goto yy1824;
		goto yy87;
yy1726:
		yych = *++cursor_;
		if (yych == '2') goto yy1825;
		goto yy87;
yy1727:
		yych = *++cursor_;
		if (yych == '4') goto yy1826;
		goto yy87;
yy1728:
		yych = *++cursor_;
		if (yych == 'f') goto yy1827;
		goto yy87;
yy1729:
		yych = *++cursor_;
		if (yych == 's') goto yy1828;
		goto yy87;
yy1730:
		yych = *++cursor_;
		if (yych == 't') goto yy1829;
		goto yy87;
yy1731:
		yych = *++cursor_;
		if (yych == 'f') goto yy1830;
		goto yy87;
yy1732:
		yych = *++cursor_;
		if (yych == 's') goto yy1831;
		goto yy87;
yy1733:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 678 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32WrapI64); }
#line 9343 "src/prebuilt/wast-lexer-gen.cc"
yy1735:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 415 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32WrapI64); }
#line 9351 "src/prebuilt/wast-lexer-gen.cc"
yy1737:
		yych = *++cursor_;
		if (yych == 'u') goto yy1832;
		goto yy87;
yy1738:
		yych = *++cursor_;
		if (yych == 'u') goto yy1833;
		goto yy87;
yy1739:
		yych = *++cursor_;
		if (yych == 't') goto yy1834;
		goto yy87;
yy1740:
		yych = *++cursor_;
		if (yych == 'e') goto yy1835;
		goto yy87;
yy1741:
		yych = *++cursor_;
		if (yych == 's') goto yy1836;
		goto yy87;
yy1742:
		yych = *++cursor_;
		if (yych == 'o') goto yy1837;
		goto yy87;
yy1743:
		yych = *++cursor_;
		if (yych == 'm') goto yy1838;
		goto yy87;
yy1744:
		yych = *++cursor_;
		if (yych == 't') goto yy1839;
		goto yy87;
yy1745:
		yych = *++cursor_;
		if (yych == 'a') goto yy1840;
		goto yy87;
yy1746:
		yych = *++cursor_;
		if (yych == '_') goto yy1841;
		goto yy87;
yy1747:
		yych = *++cursor_;
		if (yych == '_') goto yy1842;
		goto yy87;
yy1748:
		yych = *++cursor_;
		if (yych == 's') goto yy1843;
		goto yy87;
yy1749:
		yych = *++cursor_;
		if (yych == '3') goto yy1845;
		goto yy87;
yy1750:
		yych = *++cursor_;
		if (yych == '/') goto yy1846;
		goto yy87;
yy1751:
		yych = *++cursor_;
		if (yych == '/') goto yy1847;
		goto yy87;
yy1752:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 294 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load16S); }
#line 9419 "src/prebuilt/wast-lexer-gen.cc"
yy1754:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 296 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load16U); }
#line 9427 "src/prebuilt/wast-lexer-gen.cc"
yy1756:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 297 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load32S); }
#line 9435 "src/prebuilt/wast-lexer-gen.cc"
yy1758:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 298 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load32U); }
#line 9443 "src/prebuilt/wast-lexer-gen.cc"
yy1760:
		yych = *++cursor_;
		if (yych == 'r') goto yy1848;
		goto yy87;
yy1761:
		yych = *++cursor_;
		if (yych == '2') goto yy1849;
		goto yy87;
yy1762:
		yych = *++cursor_;
		if (yych == '4') goto yy1850;
		goto yy87;
yy1763:
		yych = *++cursor_;
		if (yych == 'f') goto yy1851;
		goto yy87;
yy1764:
		yych = *++cursor_;
		if (yych == 's') goto yy1852;
		goto yy87;
yy1765:
		yych = *++cursor_;
		if (yych == 't') goto yy1853;
		goto yy87;
yy1766:
		yych = *++cursor_;
		if (yych == 'f') goto yy1854;
		goto yy87;
yy1767:
		yych = *++cursor_;
		if (yych == 's') goto yy1855;
		goto yy87;
yy1768:
		yych = *++cursor_;
		if (yych == 'u') goto yy1856;
		goto yy87;
yy1769:
		yych = *++cursor_;
		if (yych == 'u') goto yy1857;
		goto yy87;
yy1770:
		yych = *++cursor_;
		if (yych == 't') goto yy1858;
		goto yy87;
yy1771:
		yych = *++cursor_;
		if (yych == 'e') goto yy1859;
		goto yy87;
yy1772:
		yych = *++cursor_;
		if (yych == 's') goto yy1860;
		goto yy87;
yy1773:
		yych = *++cursor_;
		if (yych == 't') goto yy1861;
		goto yy87;
yy1774:
		yych = *++cursor_;
		if (yych == 'u') goto yy1862;
		goto yy87;
yy1775:
		yych = *++cursor_;
		if (yych == 'u') goto yy1863;
		goto yy87;
yy1776:
		yych = *++cursor_;
		if (yych == 't') goto yy1864;
		goto yy87;
yy1777:
		yych = *++cursor_;
		if (yych == 'e') goto yy1865;
		goto yy87;
yy1778:
		yych = *++cursor_;
		if (yych == 't') goto yy1866;
		goto yy87;
yy1779:
		yych = *++cursor_;
		if (yych == 'i') goto yy1867;
		goto yy87;
yy1780:
		yych = *++cursor_;
		if (yych == 'c') goto yy1868;
		goto yy87;
yy1781:
		yych = *++cursor_;
		if (yych == 'e') goto yy1869;
		goto yy87;
yy1782:
		yych = *++cursor_;
		if (yych == 't') goto yy1871;
		goto yy87;
yy1783:
		yych = *++cursor_;
		if (yych == 'd') goto yy1872;
		goto yy87;
yy1784:
		yych = *++cursor_;
		if (yych == 'm') goto yy1874;
		goto yy87;
yy1785:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy1786;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy1875;
				if (yych <= '~') goto yy86;
			}
		}
yy1786:
#line 735 "src/wast-lexer.cc"
		{ RETURN(AssertReturn); }
#line 9564 "src/prebuilt/wast-lexer-gen.cc"
yy1787:
		yych = *++cursor_;
		if (yych == 'a') goto yy1876;
		goto yy87;
yy1788:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 462 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(AtomicNotify); }
#line 9576 "src/prebuilt/wast-lexer-gen.cc"
yy1790:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 272 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(CallIndirect); }
#line 9584 "src/prebuilt/wast-lexer-gen.cc"
yy1792:
		yych = *++cursor_;
		if (yych == 'y') goto yy1877;
		goto yy87;
yy1793:
		yych = *++cursor_;
		if (yych == '3') goto yy1879;
		if (yych == '6') goto yy1880;
		goto yy87;
yy1794:
		yych = *++cursor_;
		if (yych == '/') goto yy1881;
		goto yy87;
yy1795:
		yych = *++cursor_;
		if (yych == '/') goto yy1882;
		goto yy87;
yy1796:
		yych = *++cursor_;
		if (yych == '4') goto yy1883;
		goto yy87;
yy1797:
		yych = *++cursor_;
		if (yych == '4') goto yy1885;
		goto yy87;
yy1798:
		yych = *++cursor_;
		if (yych == 'e') goto yy1887;
		goto yy87;
yy1799:
		yych = *++cursor_;
		if (yych == '_') goto yy1888;
		goto yy87;
yy1800:
		yych = *++cursor_;
		if (yych == '_') goto yy1889;
		goto yy87;
yy1801:
		yych = *++cursor_;
		if (yych == '_') goto yy1890;
		goto yy87;
yy1802:
		yych = *++cursor_;
		if (yych == '3') goto yy1891;
		if (yych == '6') goto yy1892;
		goto yy87;
yy1803:
		yych = *++cursor_;
		if (yych == '/') goto yy1893;
		goto yy87;
yy1804:
		yych = *++cursor_;
		if (yych == '/') goto yy1894;
		goto yy87;
yy1805:
		yych = *++cursor_;
		if (yych == '3') goto yy1895;
		goto yy87;
yy1806:
		yych = *++cursor_;
		if (yych == '3') goto yy1896;
		goto yy87;
yy1807:
		yych = *++cursor_;
		if (yych == 'e') goto yy1897;
		goto yy87;
yy1808:
		yych = *++cursor_;
		if (yych == '_') goto yy1898;
		goto yy87;
yy1809:
		yych = *++cursor_;
		if (yych == '_') goto yy1899;
		goto yy87;
yy1810:
		yych = *++cursor_;
		if (yych == '_') goto yy1900;
		goto yy87;
yy1811:
		yych = *++cursor_;
		if (yych == 'u') goto yy1901;
		goto yy87;
yy1812:
		yych = *++cursor_;
		if (yych == 'e') goto yy1902;
		goto yy87;
yy1813:
		yych = *++cursor_;
		if (yych == 'e') goto yy1904;
		goto yy87;
yy1814:
		yych = *++cursor_;
		if (yych == '_') goto yy1906;
		goto yy87;
yy1815:
		yych = *++cursor_;
		if (yych == '_') goto yy1907;
		goto yy87;
yy1816:
		yych = *++cursor_;
		if (yych == 'u') goto yy1908;
		goto yy87;
yy1817:
		yych = *++cursor_;
		if (yych == 'a') goto yy1909;
		goto yy87;
yy1818:
		yych = *++cursor_;
		if (yych == 'w') goto yy1910;
		goto yy87;
yy1819:
		yych = *++cursor_;
		if (yych == 'o') goto yy1911;
		goto yy87;
yy1820:
		yych = *++cursor_;
		if (yych == 'i') goto yy1912;
		goto yy87;
yy1821:
		yych = *++cursor_;
		if (yych == 's') goto yy1913;
		goto yy87;
yy1822:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 332 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32Extend8S); }
#line 9714 "src/prebuilt/wast-lexer-gen.cc"
yy1824:
		yych = *++cursor_;
		if (yych == 'e') goto yy1915;
		goto yy87;
yy1825:
		yych = *++cursor_;
		if (yych == '_') goto yy1916;
		goto yy87;
yy1826:
		yych = *++cursor_;
		if (yych == '_') goto yy1917;
		goto yy87;
yy1827:
		yych = *++cursor_;
		if (yych == '3') goto yy1918;
		if (yych == '6') goto yy1919;
		goto yy87;
yy1828:
		yych = *++cursor_;
		if (yych == 'a') goto yy1920;
		goto yy87;
yy1829:
		yych = *++cursor_;
		if (yych == '_') goto yy1921;
		goto yy87;
yy1830:
		yych = *++cursor_;
		if (yych == '3') goto yy1922;
		if (yych == '6') goto yy1923;
		goto yy87;
yy1831:
		yych = *++cursor_;
		if (yych == 'a') goto yy1924;
		goto yy87;
yy1832:
		yych = *++cursor_;
		if (yych == 'e') goto yy1925;
		goto yy87;
yy1833:
		yych = *++cursor_;
		if (yych == 'e') goto yy1927;
		goto yy87;
yy1834:
		yych = *++cursor_;
		if (yych == '_') goto yy1929;
		goto yy87;
yy1835:
		yych = *++cursor_;
		if (yych == '_') goto yy1930;
		goto yy87;
yy1836:
		yych = *++cursor_;
		if (yych == 'a') goto yy1931;
		goto yy87;
yy1837:
		yych = *++cursor_;
		if (yych == 'a') goto yy1932;
		goto yy87;
yy1838:
		yych = *++cursor_;
		if (yych == 'w') goto yy1933;
		goto yy87;
yy1839:
		yych = *++cursor_;
		if (yych == 'o') goto yy1934;
		goto yy87;
yy1840:
		yych = *++cursor_;
		if (yych == 'i') goto yy1935;
		goto yy87;
yy1841:
		yych = *++cursor_;
		if (yych == 's') goto yy1936;
		goto yy87;
yy1842:
		yych = *++cursor_;
		if (yych == 's') goto yy1938;
		goto yy87;
yy1843:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 334 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64Extend8S); }
#line 9800 "src/prebuilt/wast-lexer-gen.cc"
yy1845:
		yych = *++cursor_;
		if (yych == '2') goto yy1940;
		goto yy87;
yy1846:
		yych = *++cursor_;
		if (yych == 'i') goto yy1941;
		goto yy87;
yy1847:
		yych = *++cursor_;
		if (yych == 'i') goto yy1942;
		goto yy87;
yy1848:
		yych = *++cursor_;
		if (yych == 'e') goto yy1943;
		goto yy87;
yy1849:
		yych = *++cursor_;
		if (yych == '_') goto yy1944;
		goto yy87;
yy1850:
		yych = *++cursor_;
		if (yych == '_') goto yy1945;
		goto yy87;
yy1851:
		yych = *++cursor_;
		if (yych == '3') goto yy1946;
		if (yych == '6') goto yy1947;
		goto yy87;
yy1852:
		yych = *++cursor_;
		if (yych == 'a') goto yy1948;
		goto yy87;
yy1853:
		yych = *++cursor_;
		if (yych == '_') goto yy1949;
		goto yy87;
yy1854:
		yych = *++cursor_;
		if (yych == '3') goto yy1950;
		if (yych == '6') goto yy1951;
		goto yy87;
yy1855:
		yych = *++cursor_;
		if (yych == 'a') goto yy1952;
		goto yy87;
yy1856:
		yych = *++cursor_;
		if (yych == 'e') goto yy1953;
		goto yy87;
yy1857:
		yych = *++cursor_;
		if (yych == 'e') goto yy1955;
		goto yy87;
yy1858:
		yych = *++cursor_;
		if (yych == '_') goto yy1957;
		goto yy87;
yy1859:
		yych = *++cursor_;
		if (yych == '_') goto yy1958;
		goto yy87;
yy1860:
		yych = *++cursor_;
		if (yych == 'a') goto yy1959;
		goto yy87;
yy1861:
		yych = *++cursor_;
		if (yych == 'u') goto yy1960;
		goto yy87;
yy1862:
		yych = *++cursor_;
		if (yych == 'e') goto yy1961;
		goto yy87;
yy1863:
		yych = *++cursor_;
		if (yych == 'e') goto yy1963;
		goto yy87;
yy1864:
		yych = *++cursor_;
		if (yych == '_') goto yy1965;
		goto yy87;
yy1865:
		yych = *++cursor_;
		if (yych == '_') goto yy1966;
		goto yy87;
yy1866:
		yych = *++cursor_;
		if (yych == 'u') goto yy1967;
		goto yy87;
yy1867:
		yych = *++cursor_;
		if (yych == 'n') goto yy1968;
		goto yy87;
yy1868:
		yych = *++cursor_;
		if (yych == 't') goto yy1969;
		goto yy87;
yy1869:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 549 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdShuffleOp, V8X16Shuffle); }
#line 9906 "src/prebuilt/wast-lexer-gen.cc"
yy1871:
		yych = *++cursor_;
		if (yych == 'i') goto yy1971;
		goto yy87;
yy1872:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 733 "src/wast-lexer.cc"
		{ RETURN(AssertInvalid); }
#line 9918 "src/prebuilt/wast-lexer-gen.cc"
yy1874:
		yych = *++cursor_;
		if (yych == 'e') goto yy1972;
		goto yy87;
yy1875:
		yych = *++cursor_;
		if (yych == 'a') goto yy1973;
		if (yych == 'c') goto yy1974;
		goto yy87;
yy1876:
		yych = *++cursor_;
		if (yych == 'b') goto yy1975;
		goto yy87;
yy1877:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 454 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(MemorySize); }
#line 9939 "src/prebuilt/wast-lexer-gen.cc"
yy1879:
		yych = *++cursor_;
		if (yych == '2') goto yy1976;
		goto yy87;
yy1880:
		yych = *++cursor_;
		if (yych == '4') goto yy1977;
		goto yy87;
yy1881:
		yych = *++cursor_;
		if (yych == 'i') goto yy1978;
		goto yy87;
yy1882:
		yych = *++cursor_;
		if (yych == 'i') goto yy1979;
		goto yy87;
yy1883:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 696 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32DemoteF64); }
#line 9963 "src/prebuilt/wast-lexer-gen.cc"
yy1885:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 441 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32DemoteF64); }
#line 9971 "src/prebuilt/wast-lexer-gen.cc"
yy1887:
		yych = *++cursor_;
		if (yych == 't') goto yy1980;
		goto yy87;
yy1888:
		yych = *++cursor_;
		if (yych == 'i') goto yy1981;
		goto yy87;
yy1889:
		yych = *++cursor_;
		if (yych == 'l') goto yy1982;
		goto yy87;
yy1890:
		yych = *++cursor_;
		if (yych == 'l') goto yy1983;
		goto yy87;
yy1891:
		yych = *++cursor_;
		if (yych == '2') goto yy1984;
		goto yy87;
yy1892:
		yych = *++cursor_;
		if (yych == '4') goto yy1985;
		goto yy87;
yy1893:
		yych = *++cursor_;
		if (yych == 'i') goto yy1986;
		goto yy87;
yy1894:
		yych = *++cursor_;
		if (yych == 'i') goto yy1987;
		goto yy87;
yy1895:
		yych = *++cursor_;
		if (yych == '2') goto yy1988;
		goto yy87;
yy1896:
		yych = *++cursor_;
		if (yych == '2') goto yy1990;
		goto yy87;
yy1897:
		yych = *++cursor_;
		if (yych == 't') goto yy1992;
		goto yy87;
yy1898:
		yych = *++cursor_;
		if (yych == 'i') goto yy1993;
		goto yy87;
yy1899:
		yych = *++cursor_;
		if (yych == 'l') goto yy1994;
		goto yy87;
yy1900:
		yych = *++cursor_;
		if (yych == 'l') goto yy1995;
		goto yy87;
yy1901:
		yych = *++cursor_;
		if (yych == 'r') goto yy1996;
		goto yy87;
yy1902:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 595 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I16X8AllTrue); }
#line 10039 "src/prebuilt/wast-lexer-gen.cc"
yy1904:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 591 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I16X8AnyTrue); }
#line 10047 "src/prebuilt/wast-lexer-gen.cc"
yy1906:
		yych = *++cursor_;
		if (yych == 'l') goto yy1997;
		goto yy87;
yy1907:
		yych = *++cursor_;
		if (yych == 'l') goto yy1998;
		goto yy87;
yy1908:
		yych = *++cursor_;
		if (yych == 'r') goto yy1999;
		goto yy87;
yy1909:
		yych = *++cursor_;
		if (yych == 'd') goto yy2000;
		goto yy87;
yy1910:
		yych = *++cursor_;
		if (yych <= '0') {
			if (yych == '.') goto yy2002;
			goto yy87;
		} else {
			if (yych <= '1') goto yy2003;
			if (yych == '8') goto yy2004;
			goto yy87;
		}
yy1911:
		yych = *++cursor_;
		if (yych == 'r') goto yy2005;
		goto yy87;
yy1912:
		yych = *++cursor_;
		if (yych == 't') goto yy2006;
		goto yy87;
yy1913:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 333 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32Extend16S); }
#line 10089 "src/prebuilt/wast-lexer-gen.cc"
yy1915:
		yych = *++cursor_;
		if (yych == 't') goto yy2008;
		goto yy87;
yy1916:
		yych = *++cursor_;
		if (yych == 's') goto yy2009;
		if (yych == 'u') goto yy2011;
		goto yy87;
yy1917:
		yych = *++cursor_;
		if (yych == 's') goto yy2013;
		if (yych == 'u') goto yy2015;
		goto yy87;
yy1918:
		yych = *++cursor_;
		if (yych == '2') goto yy2017;
		goto yy87;
yy1919:
		yych = *++cursor_;
		if (yych == '4') goto yy2019;
		goto yy87;
yy1920:
		yych = *++cursor_;
		if (yych == 't') goto yy2021;
		goto yy87;
yy1921:
		yych = *++cursor_;
		if (yych == 'f') goto yy2022;
		goto yy87;
yy1922:
		yych = *++cursor_;
		if (yych == '2') goto yy2023;
		goto yy87;
yy1923:
		yych = *++cursor_;
		if (yych == '4') goto yy2025;
		goto yy87;
yy1924:
		yych = *++cursor_;
		if (yych == 't') goto yy2027;
		goto yy87;
yy1925:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 596 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I32X4AllTrue); }
#line 10139 "src/prebuilt/wast-lexer-gen.cc"
yy1927:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 592 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I32X4AnyTrue); }
#line 10147 "src/prebuilt/wast-lexer-gen.cc"
yy1929:
		yych = *++cursor_;
		if (yych == 'l') goto yy2028;
		goto yy87;
yy1930:
		yych = *++cursor_;
		if (yych == 'l') goto yy2029;
		goto yy87;
yy1931:
		yych = *++cursor_;
		if (yych == 't') goto yy2030;
		goto yy87;
yy1932:
		yych = *++cursor_;
		if (yych == 'd') goto yy2031;
		goto yy87;
yy1933:
		yych = *++cursor_;
		switch (yych) {
		case '.':	goto yy2033;
		case '1':	goto yy2034;
		case '3':	goto yy2035;
		case '8':	goto yy2036;
		default:	goto yy87;
		}
yy1934:
		yych = *++cursor_;
		if (yych == 'r') goto yy2037;
		goto yy87;
yy1935:
		yych = *++cursor_;
		if (yych == 't') goto yy2038;
		goto yy87;
yy1936:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 335 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64Extend16S); }
#line 10188 "src/prebuilt/wast-lexer-gen.cc"
yy1938:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 336 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64Extend32S); }
#line 10196 "src/prebuilt/wast-lexer-gen.cc"
yy1940:
		yych = *++cursor_;
		if (yych == '_') goto yy2040;
		goto yy87;
yy1941:
		yych = *++cursor_;
		if (yych == '3') goto yy2041;
		goto yy87;
yy1942:
		yych = *++cursor_;
		if (yych == '3') goto yy2042;
		goto yy87;
yy1943:
		yych = *++cursor_;
		if (yych == 't') goto yy2043;
		goto yy87;
yy1944:
		yych = *++cursor_;
		if (yych == 's') goto yy2044;
		if (yych == 'u') goto yy2046;
		goto yy87;
yy1945:
		yych = *++cursor_;
		if (yych == 's') goto yy2048;
		if (yych == 'u') goto yy2050;
		goto yy87;
yy1946:
		yych = *++cursor_;
		if (yych == '2') goto yy2052;
		goto yy87;
yy1947:
		yych = *++cursor_;
		if (yych == '4') goto yy2054;
		goto yy87;
yy1948:
		yych = *++cursor_;
		if (yych == 't') goto yy2056;
		goto yy87;
yy1949:
		yych = *++cursor_;
		if (yych == 'f') goto yy2057;
		goto yy87;
yy1950:
		yych = *++cursor_;
		if (yych == '2') goto yy2058;
		goto yy87;
yy1951:
		yych = *++cursor_;
		if (yych == '4') goto yy2060;
		goto yy87;
yy1952:
		yych = *++cursor_;
		if (yych == 't') goto yy2062;
		goto yy87;
yy1953:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 597 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I64X2AllTrue); }
#line 10258 "src/prebuilt/wast-lexer-gen.cc"
yy1955:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 593 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I64X2AnyTrue); }
#line 10266 "src/prebuilt/wast-lexer-gen.cc"
yy1957:
		yych = *++cursor_;
		if (yych == 'l') goto yy2063;
		goto yy87;
yy1958:
		yych = *++cursor_;
		if (yych == 'l') goto yy2064;
		goto yy87;
yy1959:
		yych = *++cursor_;
		if (yych == 't') goto yy2065;
		goto yy87;
yy1960:
		yych = *++cursor_;
		if (yych == 'r') goto yy2066;
		goto yy87;
yy1961:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 594 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I8X16AllTrue); }
#line 10290 "src/prebuilt/wast-lexer-gen.cc"
yy1963:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 590 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I8X16AnyTrue); }
#line 10298 "src/prebuilt/wast-lexer-gen.cc"
yy1965:
		yych = *++cursor_;
		if (yych == 'l') goto yy2067;
		goto yy87;
yy1966:
		yych = *++cursor_;
		if (yych == 'l') goto yy2068;
		goto yy87;
yy1967:
		yych = *++cursor_;
		if (yych == 'r') goto yy2069;
		goto yy87;
yy1968:
		yych = *++cursor_;
		if (yych == 'd') goto yy2070;
		goto yy87;
yy1969:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 589 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Ternary, V128BitSelect); }
#line 10322 "src/prebuilt/wast-lexer-gen.cc"
yy1971:
		yych = *++cursor_;
		if (yych == 'o') goto yy2071;
		goto yy87;
yy1972:
		yych = *++cursor_;
		if (yych == 'd') goto yy2072;
		goto yy87;
yy1973:
		yych = *++cursor_;
		if (yych == 'r') goto yy2074;
		goto yy87;
yy1974:
		yych = *++cursor_;
		if (yych == 'a') goto yy2075;
		goto yy87;
yy1975:
		yych = *++cursor_;
		if (yych == 'l') goto yy2076;
		goto yy87;
yy1976:
		yych = *++cursor_;
		if (yych == '_') goto yy2077;
		goto yy87;
yy1977:
		yych = *++cursor_;
		if (yych == '_') goto yy2078;
		goto yy87;
yy1978:
		yych = *++cursor_;
		if (yych == '3') goto yy2079;
		if (yych == '6') goto yy2080;
		goto yy87;
yy1979:
		yych = *++cursor_;
		if (yych == '3') goto yy2081;
		if (yych == '6') goto yy2082;
		goto yy87;
yy1980:
		yych = *++cursor_;
		if (yych == '/') goto yy2083;
		if (yych == '_') goto yy2084;
		goto yy87;
yy1981:
		yych = *++cursor_;
		if (yych == '3') goto yy2085;
		goto yy87;
yy1982:
		yych = *++cursor_;
		if (yych == 'a') goto yy2086;
		goto yy87;
yy1983:
		yych = *++cursor_;
		if (yych == 'a') goto yy2087;
		goto yy87;
yy1984:
		yych = *++cursor_;
		if (yych == '_') goto yy2088;
		goto yy87;
yy1985:
		yych = *++cursor_;
		if (yych == '_') goto yy2089;
		goto yy87;
yy1986:
		yych = *++cursor_;
		if (yych == '3') goto yy2090;
		if (yych == '6') goto yy2091;
		goto yy87;
yy1987:
		yych = *++cursor_;
		if (yych == '3') goto yy2092;
		if (yych == '6') goto yy2093;
		goto yy87;
yy1988:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 695 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64PromoteF32); }
#line 10403 "src/prebuilt/wast-lexer-gen.cc"
yy1990:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 440 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64PromoteF32); }
#line 10411 "src/prebuilt/wast-lexer-gen.cc"
yy1992:
		yych = *++cursor_;
		if (yych == '/') goto yy2094;
		if (yych == '_') goto yy2095;
		goto yy87;
yy1993:
		yych = *++cursor_;
		if (yych == '6') goto yy2096;
		goto yy87;
yy1994:
		yych = *++cursor_;
		if (yych == 'a') goto yy2097;
		goto yy87;
yy1995:
		yych = *++cursor_;
		if (yych == 'a') goto yy2098;
		goto yy87;
yy1996:
		yych = *++cursor_;
		if (yych == 'a') goto yy2099;
		goto yy87;
yy1997:
		yych = *++cursor_;
		if (yych == 'a') goto yy2100;
		goto yy87;
yy1998:
		yych = *++cursor_;
		if (yych == 'a') goto yy2101;
		goto yy87;
yy1999:
		yych = *++cursor_;
		if (yych == 'a') goto yy2102;
		goto yy87;
yy2000:
		++cursor_;
		if ((yych = *cursor_) <= '0') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= '8') {
				if (yych <= '1') goto yy2103;
				if (yych <= '7') goto yy86;
				goto yy2104;
			} else {
				if (yych == ';') goto yy2001;
				if (yych <= '~') goto yy86;
			}
		}
yy2001:
#line 463 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I32AtomicLoad); }
#line 10467 "src/prebuilt/wast-lexer-gen.cc"
yy2002:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy2105;
		case 'c':	goto yy2106;
		case 'o':	goto yy2107;
		case 's':	goto yy2108;
		case 'x':	goto yy2109;
		default:	goto yy87;
		}
yy2003:
		yych = *++cursor_;
		if (yych == '6') goto yy2110;
		goto yy87;
yy2004:
		yych = *++cursor_;
		if (yych == '.') goto yy2111;
		goto yy87;
yy2005:
		yych = *++cursor_;
		if (yych == 'e') goto yy2112;
		goto yy87;
yy2006:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 460 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicWait, I32AtomicWait); }
#line 10497 "src/prebuilt/wast-lexer-gen.cc"
yy2008:
		yych = *++cursor_;
		if (yych == '/') goto yy2114;
		if (yych == '_') goto yy2115;
		goto yy87;
yy2009:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 416 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncF32S); }
#line 10510 "src/prebuilt/wast-lexer-gen.cc"
yy2011:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 420 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncF32U); }
#line 10518 "src/prebuilt/wast-lexer-gen.cc"
yy2013:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 418 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncF64S); }
#line 10526 "src/prebuilt/wast-lexer-gen.cc"
yy2015:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 422 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncF64U); }
#line 10534 "src/prebuilt/wast-lexer-gen.cc"
yy2017:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 679 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncF32S); }
#line 10542 "src/prebuilt/wast-lexer-gen.cc"
yy2019:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 681 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncF64S); }
#line 10550 "src/prebuilt/wast-lexer-gen.cc"
yy2021:
		yych = *++cursor_;
		if (yych == '/') goto yy2116;
		goto yy87;
yy2022:
		yych = *++cursor_;
		if (yych == '3') goto yy2117;
		if (yych == '6') goto yy2118;
		goto yy87;
yy2023:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 683 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncF32U); }
#line 10567 "src/prebuilt/wast-lexer-gen.cc"
yy2025:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 685 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncF64U); }
#line 10575 "src/prebuilt/wast-lexer-gen.cc"
yy2027:
		yych = *++cursor_;
		if (yych == '/') goto yy2119;
		goto yy87;
yy2028:
		yych = *++cursor_;
		if (yych == 'a') goto yy2120;
		goto yy87;
yy2029:
		yych = *++cursor_;
		if (yych == 'a') goto yy2121;
		goto yy87;
yy2030:
		yych = *++cursor_;
		if (yych == '_') goto yy2122;
		goto yy87;
yy2031:
		++cursor_;
		if ((yych = *cursor_) <= '1') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy2032;
				if (yych <= '0') goto yy86;
				goto yy2123;
			}
		} else {
			if (yych <= '8') {
				if (yych == '3') goto yy2124;
				if (yych <= '7') goto yy86;
				goto yy2125;
			} else {
				if (yych == ';') goto yy2032;
				if (yych <= '~') goto yy86;
			}
		}
yy2032:
#line 464 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I64AtomicLoad); }
#line 10616 "src/prebuilt/wast-lexer-gen.cc"
yy2033:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy2126;
		case 'c':	goto yy2127;
		case 'o':	goto yy2128;
		case 's':	goto yy2129;
		case 'x':	goto yy2130;
		default:	goto yy87;
		}
yy2034:
		yych = *++cursor_;
		if (yych == '6') goto yy2131;
		goto yy87;
yy2035:
		yych = *++cursor_;
		if (yych == '2') goto yy2132;
		goto yy87;
yy2036:
		yych = *++cursor_;
		if (yych == '.') goto yy2133;
		goto yy87;
yy2037:
		yych = *++cursor_;
		if (yych == 'e') goto yy2134;
		goto yy87;
yy2038:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 461 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicWait, I64AtomicWait); }
#line 10650 "src/prebuilt/wast-lexer-gen.cc"
yy2040:
		yych = *++cursor_;
		if (yych == 's') goto yy2136;
		if (yych == 'u') goto yy2138;
		goto yy87;
yy2041:
		yych = *++cursor_;
		if (yych == '2') goto yy2140;
		goto yy87;
yy2042:
		yych = *++cursor_;
		if (yych == '2') goto yy2142;
		goto yy87;
yy2043:
		yych = *++cursor_;
		if (yych == '/') goto yy2144;
		if (yych == '_') goto yy2145;
		goto yy87;
yy2044:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 417 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncF32S); }
#line 10676 "src/prebuilt/wast-lexer-gen.cc"
yy2046:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 421 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncF32U); }
#line 10684 "src/prebuilt/wast-lexer-gen.cc"
yy2048:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 419 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncF64S); }
#line 10692 "src/prebuilt/wast-lexer-gen.cc"
yy2050:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 423 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncF64U); }
#line 10700 "src/prebuilt/wast-lexer-gen.cc"
yy2052:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 680 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncF32S); }
#line 10708 "src/prebuilt/wast-lexer-gen.cc"
yy2054:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 682 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncF64S); }
#line 10716 "src/prebuilt/wast-lexer-gen.cc"
yy2056:
		yych = *++cursor_;
		if (yych == '/') goto yy2146;
		goto yy87;
yy2057:
		yych = *++cursor_;
		if (yych == '3') goto yy2147;
		if (yych == '6') goto yy2148;
		goto yy87;
yy2058:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 684 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncF32U); }
#line 10733 "src/prebuilt/wast-lexer-gen.cc"
yy2060:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 686 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncF64U); }
#line 10741 "src/prebuilt/wast-lexer-gen.cc"
yy2062:
		yych = *++cursor_;
		if (yych == '/') goto yy2149;
		goto yy87;
yy2063:
		yych = *++cursor_;
		if (yych == 'a') goto yy2150;
		goto yy87;
yy2064:
		yych = *++cursor_;
		if (yych == 'a') goto yy2151;
		goto yy87;
yy2065:
		yych = *++cursor_;
		if (yych == '_') goto yy2152;
		goto yy87;
yy2066:
		yych = *++cursor_;
		if (yych == 'a') goto yy2153;
		goto yy87;
yy2067:
		yych = *++cursor_;
		if (yych == 'a') goto yy2154;
		goto yy87;
yy2068:
		yych = *++cursor_;
		if (yych == 'a') goto yy2155;
		goto yy87;
yy2069:
		yych = *++cursor_;
		if (yych == 'a') goto yy2156;
		goto yy87;
yy2070:
		yych = *++cursor_;
		if (yych == 'i') goto yy2157;
		goto yy87;
yy2071:
		yych = *++cursor_;
		if (yych == 'n') goto yy2158;
		goto yy87;
yy2072:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 732 "src/wast-lexer.cc"
		{ RETURN(AssertMalformed); }
#line 10789 "src/prebuilt/wast-lexer-gen.cc"
yy2074:
		yych = *++cursor_;
		if (yych == 'i') goto yy2160;
		goto yy87;
yy2075:
		yych = *++cursor_;
		if (yych == 'n') goto yy2161;
		goto yy87;
yy2076:
		yych = *++cursor_;
		if (yych == 'e') goto yy2162;
		goto yy87;
yy2077:
		yych = *++cursor_;
		if (yych == 's') goto yy2164;
		if (yych == 'u') goto yy2166;
		goto yy87;
yy2078:
		yych = *++cursor_;
		if (yych == 's') goto yy2168;
		if (yych == 'u') goto yy2170;
		goto yy87;
yy2079:
		yych = *++cursor_;
		if (yych == '2') goto yy2172;
		goto yy87;
yy2080:
		yych = *++cursor_;
		if (yych == '4') goto yy2174;
		goto yy87;
yy2081:
		yych = *++cursor_;
		if (yych == '2') goto yy2176;
		goto yy87;
yy2082:
		yych = *++cursor_;
		if (yych == '4') goto yy2178;
		goto yy87;
yy2083:
		yych = *++cursor_;
		if (yych == 'i') goto yy2180;
		goto yy87;
yy2084:
		yych = *++cursor_;
		if (yych == 'i') goto yy2181;
		goto yy87;
yy2085:
		yych = *++cursor_;
		if (yych == '2') goto yy2182;
		goto yy87;
yy2086:
		yych = *++cursor_;
		if (yych == 'n') goto yy2183;
		goto yy87;
yy2087:
		yych = *++cursor_;
		if (yych == 'n') goto yy2184;
		goto yy87;
yy2088:
		yych = *++cursor_;
		if (yych == 's') goto yy2185;
		if (yych == 'u') goto yy2187;
		goto yy87;
yy2089:
		yych = *++cursor_;
		if (yych == 's') goto yy2189;
		if (yych == 'u') goto yy2191;
		goto yy87;
yy2090:
		yych = *++cursor_;
		if (yych == '2') goto yy2193;
		goto yy87;
yy2091:
		yych = *++cursor_;
		if (yych == '4') goto yy2195;
		goto yy87;
yy2092:
		yych = *++cursor_;
		if (yych == '2') goto yy2197;
		goto yy87;
yy2093:
		yych = *++cursor_;
		if (yych == '4') goto yy2199;
		goto yy87;
yy2094:
		yych = *++cursor_;
		if (yych == 'i') goto yy2201;
		goto yy87;
yy2095:
		yych = *++cursor_;
		if (yych == 'i') goto yy2202;
		goto yy87;
yy2096:
		yych = *++cursor_;
		if (yych == '4') goto yy2203;
		goto yy87;
yy2097:
		yych = *++cursor_;
		if (yych == 'n') goto yy2204;
		goto yy87;
yy2098:
		yych = *++cursor_;
		if (yych == 'n') goto yy2205;
		goto yy87;
yy2099:
		yych = *++cursor_;
		if (yych == 't') goto yy2206;
		goto yy87;
yy2100:
		yych = *++cursor_;
		if (yych == 'n') goto yy2207;
		goto yy87;
yy2101:
		yych = *++cursor_;
		if (yych == 'n') goto yy2208;
		goto yy87;
yy2102:
		yych = *++cursor_;
		if (yych == 't') goto yy2209;
		goto yy87;
yy2103:
		yych = *++cursor_;
		if (yych == '6') goto yy2210;
		goto yy87;
yy2104:
		yych = *++cursor_;
		if (yych == '_') goto yy2211;
		goto yy87;
yy2105:
		yych = *++cursor_;
		if (yych == 'd') goto yy2212;
		if (yych == 'n') goto yy2213;
		goto yy87;
yy2106:
		yych = *++cursor_;
		if (yych == 'm') goto yy2214;
		goto yy87;
yy2107:
		yych = *++cursor_;
		if (yych == 'r') goto yy2215;
		goto yy87;
yy2108:
		yych = *++cursor_;
		if (yych == 'u') goto yy2217;
		goto yy87;
yy2109:
		yych = *++cursor_;
		if (yych == 'c') goto yy2218;
		if (yych == 'o') goto yy2219;
		goto yy87;
yy2110:
		yych = *++cursor_;
		if (yych == '.') goto yy2220;
		goto yy87;
yy2111:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy2221;
		case 'c':	goto yy2222;
		case 'o':	goto yy2223;
		case 's':	goto yy2224;
		case 'x':	goto yy2225;
		default:	goto yy87;
		}
yy2112:
		++cursor_;
		if ((yych = *cursor_) <= '0') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= '8') {
				if (yych <= '1') goto yy2226;
				if (yych <= '7') goto yy86;
				goto yy2227;
			} else {
				if (yych == ';') goto yy2113;
				if (yych <= '~') goto yy86;
			}
		}
yy2113:
#line 470 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I32AtomicStore); }
#line 10976 "src/prebuilt/wast-lexer-gen.cc"
yy2114:
		yych = *++cursor_;
		if (yych == 'f') goto yy2229;
		goto yy87;
yy2115:
		yych = *++cursor_;
		if (yych == 'f') goto yy2230;
		goto yy87;
yy2116:
		yych = *++cursor_;
		if (yych == 'f') goto yy2231;
		goto yy87;
yy2117:
		yych = *++cursor_;
		if (yych == '2') goto yy2232;
		goto yy87;
yy2118:
		yych = *++cursor_;
		if (yych == '4') goto yy2233;
		goto yy87;
yy2119:
		yych = *++cursor_;
		if (yych == 'f') goto yy2234;
		goto yy87;
yy2120:
		yych = *++cursor_;
		if (yych == 'n') goto yy2235;
		goto yy87;
yy2121:
		yych = *++cursor_;
		if (yych == 'n') goto yy2236;
		goto yy87;
yy2122:
		yych = *++cursor_;
		if (yych == 'f') goto yy2237;
		goto yy87;
yy2123:
		yych = *++cursor_;
		if (yych == '6') goto yy2238;
		goto yy87;
yy2124:
		yych = *++cursor_;
		if (yych == '2') goto yy2239;
		goto yy87;
yy2125:
		yych = *++cursor_;
		if (yych == '_') goto yy2240;
		goto yy87;
yy2126:
		yych = *++cursor_;
		if (yych == 'd') goto yy2241;
		if (yych == 'n') goto yy2242;
		goto yy87;
yy2127:
		yych = *++cursor_;
		if (yych == 'm') goto yy2243;
		goto yy87;
yy2128:
		yych = *++cursor_;
		if (yych == 'r') goto yy2244;
		goto yy87;
yy2129:
		yych = *++cursor_;
		if (yych == 'u') goto yy2246;
		goto yy87;
yy2130:
		yych = *++cursor_;
		if (yych == 'c') goto yy2247;
		if (yych == 'o') goto yy2248;
		goto yy87;
yy2131:
		yych = *++cursor_;
		if (yych == '.') goto yy2249;
		goto yy87;
yy2132:
		yych = *++cursor_;
		if (yych == '.') goto yy2250;
		goto yy87;
yy2133:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy2251;
		case 'c':	goto yy2252;
		case 'o':	goto yy2253;
		case 's':	goto yy2254;
		case 'x':	goto yy2255;
		default:	goto yy87;
		}
yy2134:
		++cursor_;
		if ((yych = *cursor_) <= '1') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy2135;
				if (yych <= '0') goto yy86;
				goto yy2256;
			}
		} else {
			if (yych <= '8') {
				if (yych == '3') goto yy2257;
				if (yych <= '7') goto yy86;
				goto yy2258;
			} else {
				if (yych == ';') goto yy2135;
				if (yych <= '~') goto yy86;
			}
		}
yy2135:
#line 471 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I64AtomicStore); }
#line 11089 "src/prebuilt/wast-lexer-gen.cc"
yy2136:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 413 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64ExtendI32S); }
#line 11097 "src/prebuilt/wast-lexer-gen.cc"
yy2138:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 414 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64ExtendI32U); }
#line 11105 "src/prebuilt/wast-lexer-gen.cc"
yy2140:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 676 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64ExtendI32S); }
#line 11113 "src/prebuilt/wast-lexer-gen.cc"
yy2142:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 677 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64ExtendI32U); }
#line 11121 "src/prebuilt/wast-lexer-gen.cc"
yy2144:
		yych = *++cursor_;
		if (yych == 'f') goto yy2260;
		goto yy87;
yy2145:
		yych = *++cursor_;
		if (yych == 'f') goto yy2261;
		goto yy87;
yy2146:
		yych = *++cursor_;
		if (yych == 'f') goto yy2262;
		goto yy87;
yy2147:
		yych = *++cursor_;
		if (yych == '2') goto yy2263;
		goto yy87;
yy2148:
		yych = *++cursor_;
		if (yych == '4') goto yy2264;
		goto yy87;
yy2149:
		yych = *++cursor_;
		if (yych == 'f') goto yy2265;
		goto yy87;
yy2150:
		yych = *++cursor_;
		if (yych == 'n') goto yy2266;
		goto yy87;
yy2151:
		yych = *++cursor_;
		if (yych == 'n') goto yy2267;
		goto yy87;
yy2152:
		yych = *++cursor_;
		if (yych == 'f') goto yy2268;
		goto yy87;
yy2153:
		yych = *++cursor_;
		if (yych == 't') goto yy2269;
		goto yy87;
yy2154:
		yych = *++cursor_;
		if (yych == 'n') goto yy2270;
		goto yy87;
yy2155:
		yych = *++cursor_;
		if (yych == 'n') goto yy2271;
		goto yy87;
yy2156:
		yych = *++cursor_;
		if (yych == 't') goto yy2272;
		goto yy87;
yy2157:
		yych = *++cursor_;
		if (yych == 'r') goto yy2273;
		goto yy87;
yy2158:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 739 "src/wast-lexer.cc"
		{ RETURN(AssertExhaustion); }
#line 11185 "src/prebuilt/wast-lexer-gen.cc"
yy2160:
		yych = *++cursor_;
		if (yych == 't') goto yy2274;
		goto yy87;
yy2161:
		yych = *++cursor_;
		if (yych == 'o') goto yy2275;
		goto yy87;
yy2162:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 734 "src/wast-lexer.cc"
		{ RETURN(AssertUnlinkable); }
#line 11201 "src/prebuilt/wast-lexer-gen.cc"
yy2164:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 432 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ConvertI32S); }
#line 11209 "src/prebuilt/wast-lexer-gen.cc"
yy2166:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 436 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ConvertI32U); }
#line 11217 "src/prebuilt/wast-lexer-gen.cc"
yy2168:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 434 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ConvertI64S); }
#line 11225 "src/prebuilt/wast-lexer-gen.cc"
yy2170:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 438 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ConvertI64U); }
#line 11233 "src/prebuilt/wast-lexer-gen.cc"
yy2172:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 687 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ConvertI32S); }
#line 11241 "src/prebuilt/wast-lexer-gen.cc"
yy2174:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 689 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ConvertI64S); }
#line 11249 "src/prebuilt/wast-lexer-gen.cc"
yy2176:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 691 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ConvertI32U); }
#line 11257 "src/prebuilt/wast-lexer-gen.cc"
yy2178:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 693 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ConvertI64U); }
#line 11265 "src/prebuilt/wast-lexer-gen.cc"
yy2180:
		yych = *++cursor_;
		if (yych == '3') goto yy2276;
		goto yy87;
yy2181:
		yych = *++cursor_;
		if (yych == '3') goto yy2277;
		goto yy87;
yy2182:
		yych = *++cursor_;
		if (yych == 'x') goto yy2278;
		goto yy87;
yy2183:
		yych = *++cursor_;
		if (yych == 'e') goto yy2279;
		goto yy87;
yy2184:
		yych = *++cursor_;
		if (yych == 'e') goto yy2281;
		goto yy87;
yy2185:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 433 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ConvertI32S); }
#line 11293 "src/prebuilt/wast-lexer-gen.cc"
yy2187:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 437 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ConvertI32U); }
#line 11301 "src/prebuilt/wast-lexer-gen.cc"
yy2189:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 435 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ConvertI64S); }
#line 11309 "src/prebuilt/wast-lexer-gen.cc"
yy2191:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 439 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ConvertI64U); }
#line 11317 "src/prebuilt/wast-lexer-gen.cc"
yy2193:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 688 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ConvertI32S); }
#line 11325 "src/prebuilt/wast-lexer-gen.cc"
yy2195:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 690 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ConvertI64S); }
#line 11333 "src/prebuilt/wast-lexer-gen.cc"
yy2197:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 692 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ConvertI32U); }
#line 11341 "src/prebuilt/wast-lexer-gen.cc"
yy2199:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 694 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ConvertI64U); }
#line 11349 "src/prebuilt/wast-lexer-gen.cc"
yy2201:
		yych = *++cursor_;
		if (yych == '6') goto yy2283;
		goto yy87;
yy2202:
		yych = *++cursor_;
		if (yych == '6') goto yy2284;
		goto yy87;
yy2203:
		yych = *++cursor_;
		if (yych == 'x') goto yy2285;
		goto yy87;
yy2204:
		yych = *++cursor_;
		if (yych == 'e') goto yy2286;
		goto yy87;
yy2205:
		yych = *++cursor_;
		if (yych == 'e') goto yy2288;
		goto yy87;
yy2206:
		yych = *++cursor_;
		if (yych == 'e') goto yy2290;
		goto yy87;
yy2207:
		yych = *++cursor_;
		if (yych == 'e') goto yy2291;
		goto yy87;
yy2208:
		yych = *++cursor_;
		if (yych == 'e') goto yy2292;
		goto yy87;
yy2209:
		yych = *++cursor_;
		if (yych == 'e') goto yy2294;
		goto yy87;
yy2210:
		yych = *++cursor_;
		if (yych == '_') goto yy2295;
		goto yy87;
yy2211:
		yych = *++cursor_;
		if (yych == 'u') goto yy2296;
		goto yy87;
yy2212:
		yych = *++cursor_;
		if (yych == 'd') goto yy2298;
		goto yy87;
yy2213:
		yych = *++cursor_;
		if (yych == 'd') goto yy2300;
		goto yy87;
yy2214:
		yych = *++cursor_;
		if (yych == 'p') goto yy2302;
		goto yy87;
yy2215:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 498 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmwOr); }
#line 11413 "src/prebuilt/wast-lexer-gen.cc"
yy2217:
		yych = *++cursor_;
		if (yych == 'b') goto yy2303;
		goto yy87;
yy2218:
		yych = *++cursor_;
		if (yych == 'h') goto yy2305;
		goto yy87;
yy2219:
		yych = *++cursor_;
		if (yych == 'r') goto yy2306;
		goto yy87;
yy2220:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy2308;
		case 'c':	goto yy2309;
		case 'o':	goto yy2310;
		case 's':	goto yy2311;
		case 'x':	goto yy2312;
		default:	goto yy87;
		}
yy2221:
		yych = *++cursor_;
		if (yych == 'd') goto yy2313;
		if (yych == 'n') goto yy2314;
		goto yy87;
yy2222:
		yych = *++cursor_;
		if (yych == 'm') goto yy2315;
		goto yy87;
yy2223:
		yych = *++cursor_;
		if (yych == 'r') goto yy2316;
		goto yy87;
yy2224:
		yych = *++cursor_;
		if (yych == 'u') goto yy2317;
		goto yy87;
yy2225:
		yych = *++cursor_;
		if (yych == 'c') goto yy2318;
		if (yych == 'o') goto yy2319;
		goto yy87;
yy2226:
		yych = *++cursor_;
		if (yych == '6') goto yy2320;
		goto yy87;
yy2227:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 472 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I32AtomicStore8); }
#line 11469 "src/prebuilt/wast-lexer-gen.cc"
yy2229:
		yych = *++cursor_;
		if (yych == '3') goto yy2322;
		goto yy87;
yy2230:
		yych = *++cursor_;
		if (yych == '3') goto yy2323;
		goto yy87;
yy2231:
		yych = *++cursor_;
		if (yych == '3') goto yy2324;
		if (yych == '6') goto yy2325;
		goto yy87;
yy2232:
		yych = *++cursor_;
		if (yych == '_') goto yy2326;
		goto yy87;
yy2233:
		yych = *++cursor_;
		if (yych == '_') goto yy2327;
		goto yy87;
yy2234:
		yych = *++cursor_;
		if (yych == '3') goto yy2328;
		if (yych == '6') goto yy2329;
		goto yy87;
yy2235:
		yych = *++cursor_;
		if (yych == 'e') goto yy2330;
		goto yy87;
yy2236:
		yych = *++cursor_;
		if (yych == 'e') goto yy2332;
		goto yy87;
yy2237:
		yych = *++cursor_;
		if (yych == '3') goto yy2334;
		goto yy87;
yy2238:
		yych = *++cursor_;
		if (yych == '_') goto yy2335;
		goto yy87;
yy2239:
		yych = *++cursor_;
		if (yych == '_') goto yy2336;
		goto yy87;
yy2240:
		yych = *++cursor_;
		if (yych == 'u') goto yy2337;
		goto yy87;
yy2241:
		yych = *++cursor_;
		if (yych == 'd') goto yy2339;
		goto yy87;
yy2242:
		yych = *++cursor_;
		if (yych == 'd') goto yy2341;
		goto yy87;
yy2243:
		yych = *++cursor_;
		if (yych == 'p') goto yy2343;
		goto yy87;
yy2244:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 499 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmwOr); }
#line 11539 "src/prebuilt/wast-lexer-gen.cc"
yy2246:
		yych = *++cursor_;
		if (yych == 'b') goto yy2344;
		goto yy87;
yy2247:
		yych = *++cursor_;
		if (yych == 'h') goto yy2346;
		goto yy87;
yy2248:
		yych = *++cursor_;
		if (yych == 'r') goto yy2347;
		goto yy87;
yy2249:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy2349;
		case 'c':	goto yy2350;
		case 'o':	goto yy2351;
		case 's':	goto yy2352;
		case 'x':	goto yy2353;
		default:	goto yy87;
		}
yy2250:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy2354;
		case 'c':	goto yy2355;
		case 'o':	goto yy2356;
		case 's':	goto yy2357;
		case 'x':	goto yy2358;
		default:	goto yy87;
		}
yy2251:
		yych = *++cursor_;
		if (yych == 'd') goto yy2359;
		if (yych == 'n') goto yy2360;
		goto yy87;
yy2252:
		yych = *++cursor_;
		if (yych == 'm') goto yy2361;
		goto yy87;
yy2253:
		yych = *++cursor_;
		if (yych == 'r') goto yy2362;
		goto yy87;
yy2254:
		yych = *++cursor_;
		if (yych == 'u') goto yy2363;
		goto yy87;
yy2255:
		yych = *++cursor_;
		if (yych == 'c') goto yy2364;
		if (yych == 'o') goto yy2365;
		goto yy87;
yy2256:
		yych = *++cursor_;
		if (yych == '6') goto yy2366;
		goto yy87;
yy2257:
		yych = *++cursor_;
		if (yych == '2') goto yy2368;
		goto yy87;
yy2258:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 474 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I64AtomicStore8); }
#line 11609 "src/prebuilt/wast-lexer-gen.cc"
yy2260:
		yych = *++cursor_;
		if (yych == '6') goto yy2370;
		goto yy87;
yy2261:
		yych = *++cursor_;
		if (yych == '6') goto yy2371;
		goto yy87;
yy2262:
		yych = *++cursor_;
		if (yych == '3') goto yy2372;
		if (yych == '6') goto yy2373;
		goto yy87;
yy2263:
		yych = *++cursor_;
		if (yych == '_') goto yy2374;
		goto yy87;
yy2264:
		yych = *++cursor_;
		if (yych == '_') goto yy2375;
		goto yy87;
yy2265:
		yych = *++cursor_;
		if (yych == '3') goto yy2376;
		if (yych == '6') goto yy2377;
		goto yy87;
yy2266:
		yych = *++cursor_;
		if (yych == 'e') goto yy2378;
		goto yy87;
yy2267:
		yych = *++cursor_;
		if (yych == 'e') goto yy2380;
		goto yy87;
yy2268:
		yych = *++cursor_;
		if (yych == '6') goto yy2382;
		goto yy87;
yy2269:
		yych = *++cursor_;
		if (yych == 'e') goto yy2383;
		goto yy87;
yy2270:
		yych = *++cursor_;
		if (yych == 'e') goto yy2384;
		goto yy87;
yy2271:
		yych = *++cursor_;
		if (yych == 'e') goto yy2385;
		goto yy87;
yy2272:
		yych = *++cursor_;
		if (yych == 'e') goto yy2387;
		goto yy87;
yy2273:
		yych = *++cursor_;
		if (yych == 'e') goto yy2388;
		goto yy87;
yy2274:
		yych = *++cursor_;
		if (yych == 'h') goto yy2389;
		goto yy87;
yy2275:
		yych = *++cursor_;
		if (yych == 'n') goto yy2390;
		goto yy87;
yy2276:
		yych = *++cursor_;
		if (yych == '2') goto yy2391;
		goto yy87;
yy2277:
		yych = *++cursor_;
		if (yych == '2') goto yy2393;
		goto yy87;
yy2278:
		yych = *++cursor_;
		if (yych == '4') goto yy2395;
		goto yy87;
yy2279:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 541 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, F32X4ExtractLane); }
#line 11695 "src/prebuilt/wast-lexer-gen.cc"
yy2281:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 547 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, F32X4ReplaceLane); }
#line 11703 "src/prebuilt/wast-lexer-gen.cc"
yy2283:
		yych = *++cursor_;
		if (yych == '4') goto yy2396;
		goto yy87;
yy2284:
		yych = *++cursor_;
		if (yych == '4') goto yy2398;
		goto yy87;
yy2285:
		yych = *++cursor_;
		if (yych == '2') goto yy2400;
		goto yy87;
yy2286:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 542 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, F64X2ExtractLane); }
#line 11723 "src/prebuilt/wast-lexer-gen.cc"
yy2288:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 548 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, F64X2ReplaceLane); }
#line 11731 "src/prebuilt/wast-lexer-gen.cc"
yy2290:
		yych = *++cursor_;
		if (yych == '_') goto yy2401;
		goto yy87;
yy2291:
		yych = *++cursor_;
		if (yych == '_') goto yy2402;
		goto yy87;
yy2292:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 544 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I16X8ReplaceLane); }
#line 11747 "src/prebuilt/wast-lexer-gen.cc"
yy2294:
		yych = *++cursor_;
		if (yych == '_') goto yy2403;
		goto yy87;
yy2295:
		yych = *++cursor_;
		if (yych == 'u') goto yy2404;
		goto yy87;
yy2296:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 465 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I32AtomicLoad8U); }
#line 11763 "src/prebuilt/wast-lexer-gen.cc"
yy2298:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 477 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmwAdd); }
#line 11771 "src/prebuilt/wast-lexer-gen.cc"
yy2300:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 491 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmwAnd); }
#line 11779 "src/prebuilt/wast-lexer-gen.cc"
yy2302:
		yych = *++cursor_;
		if (yych == 'x') goto yy2406;
		goto yy87;
yy2303:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 484 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmwSub); }
#line 11791 "src/prebuilt/wast-lexer-gen.cc"
yy2305:
		yych = *++cursor_;
		if (yych == 'g') goto yy2407;
		goto yy87;
yy2306:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 505 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmwXor); }
#line 11803 "src/prebuilt/wast-lexer-gen.cc"
yy2308:
		yych = *++cursor_;
		if (yych == 'd') goto yy2409;
		if (yych == 'n') goto yy2410;
		goto yy87;
yy2309:
		yych = *++cursor_;
		if (yych == 'm') goto yy2411;
		goto yy87;
yy2310:
		yych = *++cursor_;
		if (yych == 'r') goto yy2412;
		goto yy87;
yy2311:
		yych = *++cursor_;
		if (yych == 'u') goto yy2413;
		goto yy87;
yy2312:
		yych = *++cursor_;
		if (yych == 'c') goto yy2414;
		if (yych == 'o') goto yy2415;
		goto yy87;
yy2313:
		yych = *++cursor_;
		if (yych == 'd') goto yy2416;
		goto yy87;
yy2314:
		yych = *++cursor_;
		if (yych == 'd') goto yy2417;
		goto yy87;
yy2315:
		yych = *++cursor_;
		if (yych == 'p') goto yy2418;
		goto yy87;
yy2316:
		yych = *++cursor_;
		if (yych == '_') goto yy2419;
		goto yy87;
yy2317:
		yych = *++cursor_;
		if (yych == 'b') goto yy2420;
		goto yy87;
yy2318:
		yych = *++cursor_;
		if (yych == 'h') goto yy2421;
		goto yy87;
yy2319:
		yych = *++cursor_;
		if (yych == 'r') goto yy2422;
		goto yy87;
yy2320:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 473 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I32AtomicStore16); }
#line 11861 "src/prebuilt/wast-lexer-gen.cc"
yy2322:
		yych = *++cursor_;
		if (yych == '2') goto yy2423;
		goto yy87;
yy2323:
		yych = *++cursor_;
		if (yych == '2') goto yy2425;
		goto yy87;
yy2324:
		yych = *++cursor_;
		if (yych == '2') goto yy2427;
		goto yy87;
yy2325:
		yych = *++cursor_;
		if (yych == '4') goto yy2429;
		goto yy87;
yy2326:
		yych = *++cursor_;
		if (yych == 's') goto yy2431;
		if (yych == 'u') goto yy2433;
		goto yy87;
yy2327:
		yych = *++cursor_;
		if (yych == 's') goto yy2435;
		if (yych == 'u') goto yy2437;
		goto yy87;
yy2328:
		yych = *++cursor_;
		if (yych == '2') goto yy2439;
		goto yy87;
yy2329:
		yych = *++cursor_;
		if (yych == '4') goto yy2441;
		goto yy87;
yy2330:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 539 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I32X4ExtractLane); }
#line 11903 "src/prebuilt/wast-lexer-gen.cc"
yy2332:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 545 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I32X4ReplaceLane); }
#line 11911 "src/prebuilt/wast-lexer-gen.cc"
yy2334:
		yych = *++cursor_;
		if (yych == '2') goto yy2443;
		goto yy87;
yy2335:
		yych = *++cursor_;
		if (yych == 'u') goto yy2444;
		goto yy87;
yy2336:
		yych = *++cursor_;
		if (yych == 'u') goto yy2446;
		goto yy87;
yy2337:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 467 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I64AtomicLoad8U); }
#line 11931 "src/prebuilt/wast-lexer-gen.cc"
yy2339:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 478 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmwAdd); }
#line 11939 "src/prebuilt/wast-lexer-gen.cc"
yy2341:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 492 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmwAnd); }
#line 11947 "src/prebuilt/wast-lexer-gen.cc"
yy2343:
		yych = *++cursor_;
		if (yych == 'x') goto yy2448;
		goto yy87;
yy2344:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 485 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmwSub); }
#line 11959 "src/prebuilt/wast-lexer-gen.cc"
yy2346:
		yych = *++cursor_;
		if (yych == 'g') goto yy2449;
		goto yy87;
yy2347:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 506 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmwXor); }
#line 11971 "src/prebuilt/wast-lexer-gen.cc"
yy2349:
		yych = *++cursor_;
		if (yych == 'd') goto yy2451;
		if (yych == 'n') goto yy2452;
		goto yy87;
yy2350:
		yych = *++cursor_;
		if (yych == 'm') goto yy2453;
		goto yy87;
yy2351:
		yych = *++cursor_;
		if (yych == 'r') goto yy2454;
		goto yy87;
yy2352:
		yych = *++cursor_;
		if (yych == 'u') goto yy2455;
		goto yy87;
yy2353:
		yych = *++cursor_;
		if (yych == 'c') goto yy2456;
		if (yych == 'o') goto yy2457;
		goto yy87;
yy2354:
		yych = *++cursor_;
		if (yych == 'd') goto yy2458;
		if (yych == 'n') goto yy2459;
		goto yy87;
yy2355:
		yych = *++cursor_;
		if (yych == 'm') goto yy2460;
		goto yy87;
yy2356:
		yych = *++cursor_;
		if (yych == 'r') goto yy2461;
		goto yy87;
yy2357:
		yych = *++cursor_;
		if (yych == 'u') goto yy2462;
		goto yy87;
yy2358:
		yych = *++cursor_;
		if (yych == 'c') goto yy2463;
		if (yych == 'o') goto yy2464;
		goto yy87;
yy2359:
		yych = *++cursor_;
		if (yych == 'd') goto yy2465;
		goto yy87;
yy2360:
		yych = *++cursor_;
		if (yych == 'd') goto yy2466;
		goto yy87;
yy2361:
		yych = *++cursor_;
		if (yych == 'p') goto yy2467;
		goto yy87;
yy2362:
		yych = *++cursor_;
		if (yych == '_') goto yy2468;
		goto yy87;
yy2363:
		yych = *++cursor_;
		if (yych == 'b') goto yy2469;
		goto yy87;
yy2364:
		yych = *++cursor_;
		if (yych == 'h') goto yy2470;
		goto yy87;
yy2365:
		yych = *++cursor_;
		if (yych == 'r') goto yy2471;
		goto yy87;
yy2366:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 475 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I64AtomicStore16); }
#line 12051 "src/prebuilt/wast-lexer-gen.cc"
yy2368:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 476 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I64AtomicStore32); }
#line 12059 "src/prebuilt/wast-lexer-gen.cc"
yy2370:
		yych = *++cursor_;
		if (yych == '4') goto yy2472;
		goto yy87;
yy2371:
		yych = *++cursor_;
		if (yych == '4') goto yy2474;
		goto yy87;
yy2372:
		yych = *++cursor_;
		if (yych == '2') goto yy2476;
		goto yy87;
yy2373:
		yych = *++cursor_;
		if (yych == '4') goto yy2478;
		goto yy87;
yy2374:
		yych = *++cursor_;
		if (yych == 's') goto yy2480;
		if (yych == 'u') goto yy2482;
		goto yy87;
yy2375:
		yych = *++cursor_;
		if (yych == 's') goto yy2484;
		if (yych == 'u') goto yy2486;
		goto yy87;
yy2376:
		yych = *++cursor_;
		if (yych == '2') goto yy2488;
		goto yy87;
yy2377:
		yych = *++cursor_;
		if (yych == '4') goto yy2490;
		goto yy87;
yy2378:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 540 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I64X2ExtractLane); }
#line 12101 "src/prebuilt/wast-lexer-gen.cc"
yy2380:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 546 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I64X2ReplaceLane); }
#line 12109 "src/prebuilt/wast-lexer-gen.cc"
yy2382:
		yych = *++cursor_;
		if (yych == '4') goto yy2492;
		goto yy87;
yy2383:
		yych = *++cursor_;
		if (yych == '_') goto yy2493;
		goto yy87;
yy2384:
		yych = *++cursor_;
		if (yych == '_') goto yy2494;
		goto yy87;
yy2385:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 543 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I8X16ReplaceLane); }
#line 12129 "src/prebuilt/wast-lexer-gen.cc"
yy2387:
		yych = *++cursor_;
		if (yych == '_') goto yy2495;
		goto yy87;
yy2388:
		yych = *++cursor_;
		if (yych == 'c') goto yy2496;
		goto yy87;
yy2389:
		yych = *++cursor_;
		if (yych == 'm') goto yy2497;
		goto yy87;
yy2390:
		yych = *++cursor_;
		if (yych == 'i') goto yy2498;
		goto yy87;
yy2391:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 697 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ReinterpretI32); }
#line 12153 "src/prebuilt/wast-lexer-gen.cc"
yy2393:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 442 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ReinterpretI32); }
#line 12161 "src/prebuilt/wast-lexer-gen.cc"
yy2395:
		yych = *++cursor_;
		if (yych == '_') goto yy2499;
		goto yy87;
yy2396:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 699 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ReinterpretI64); }
#line 12173 "src/prebuilt/wast-lexer-gen.cc"
yy2398:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 444 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ReinterpretI64); }
#line 12181 "src/prebuilt/wast-lexer-gen.cc"
yy2400:
		yych = *++cursor_;
		if (yych == '_') goto yy2500;
		goto yy87;
yy2401:
		yych = *++cursor_;
		if (yych == 's') goto yy2501;
		if (yych == 'u') goto yy2503;
		goto yy87;
yy2402:
		yych = *++cursor_;
		if (yych == 's') goto yy2505;
		if (yych == 'u') goto yy2507;
		goto yy87;
yy2403:
		yych = *++cursor_;
		if (yych == 's') goto yy2509;
		if (yych == 'u') goto yy2511;
		goto yy87;
yy2404:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 466 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I32AtomicLoad16U); }
#line 12208 "src/prebuilt/wast-lexer-gen.cc"
yy2406:
		yych = *++cursor_;
		if (yych == 'c') goto yy2513;
		goto yy87;
yy2407:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 512 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmwXchg); }
#line 12220 "src/prebuilt/wast-lexer-gen.cc"
yy2409:
		yych = *++cursor_;
		if (yych == 'd') goto yy2514;
		goto yy87;
yy2410:
		yych = *++cursor_;
		if (yych == 'd') goto yy2515;
		goto yy87;
yy2411:
		yych = *++cursor_;
		if (yych == 'p') goto yy2516;
		goto yy87;
yy2412:
		yych = *++cursor_;
		if (yych == '_') goto yy2517;
		goto yy87;
yy2413:
		yych = *++cursor_;
		if (yych == 'b') goto yy2518;
		goto yy87;
yy2414:
		yych = *++cursor_;
		if (yych == 'h') goto yy2519;
		goto yy87;
yy2415:
		yych = *++cursor_;
		if (yych == 'r') goto yy2520;
		goto yy87;
yy2416:
		yych = *++cursor_;
		if (yych == '_') goto yy2521;
		goto yy87;
yy2417:
		yych = *++cursor_;
		if (yych == '_') goto yy2522;
		goto yy87;
yy2418:
		yych = *++cursor_;
		if (yych == 'x') goto yy2523;
		goto yy87;
yy2419:
		yych = *++cursor_;
		if (yych == 'u') goto yy2524;
		goto yy87;
yy2420:
		yych = *++cursor_;
		if (yych == '_') goto yy2526;
		goto yy87;
yy2421:
		yych = *++cursor_;
		if (yych == 'g') goto yy2527;
		goto yy87;
yy2422:
		yych = *++cursor_;
		if (yych == '_') goto yy2528;
		goto yy87;
yy2423:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 698 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32ReinterpretF32); }
#line 12284 "src/prebuilt/wast-lexer-gen.cc"
yy2425:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 443 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32ReinterpretF32); }
#line 12292 "src/prebuilt/wast-lexer-gen.cc"
yy2427:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 701 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncSatF32S); }
#line 12300 "src/prebuilt/wast-lexer-gen.cc"
yy2429:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 703 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncSatF64S); }
#line 12308 "src/prebuilt/wast-lexer-gen.cc"
yy2431:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 424 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncSatF32S); }
#line 12316 "src/prebuilt/wast-lexer-gen.cc"
yy2433:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 428 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncSatF32U); }
#line 12324 "src/prebuilt/wast-lexer-gen.cc"
yy2435:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 426 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncSatF64S); }
#line 12332 "src/prebuilt/wast-lexer-gen.cc"
yy2437:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 430 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncSatF64U); }
#line 12340 "src/prebuilt/wast-lexer-gen.cc"
yy2439:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 705 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncSatF32U); }
#line 12348 "src/prebuilt/wast-lexer-gen.cc"
yy2441:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 707 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncSatF64U); }
#line 12356 "src/prebuilt/wast-lexer-gen.cc"
yy2443:
		yych = *++cursor_;
		if (yych == 'x') goto yy2529;
		goto yy87;
yy2444:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 468 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I64AtomicLoad16U); }
#line 12368 "src/prebuilt/wast-lexer-gen.cc"
yy2446:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 469 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I64AtomicLoad32U); }
#line 12376 "src/prebuilt/wast-lexer-gen.cc"
yy2448:
		yych = *++cursor_;
		if (yych == 'c') goto yy2530;
		goto yy87;
yy2449:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 513 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmwXchg); }
#line 12388 "src/prebuilt/wast-lexer-gen.cc"
yy2451:
		yych = *++cursor_;
		if (yych == 'd') goto yy2531;
		goto yy87;
yy2452:
		yych = *++cursor_;
		if (yych == 'd') goto yy2532;
		goto yy87;
yy2453:
		yych = *++cursor_;
		if (yych == 'p') goto yy2533;
		goto yy87;
yy2454:
		yych = *++cursor_;
		if (yych == '_') goto yy2534;
		goto yy87;
yy2455:
		yych = *++cursor_;
		if (yych == 'b') goto yy2535;
		goto yy87;
yy2456:
		yych = *++cursor_;
		if (yych == 'h') goto yy2536;
		goto yy87;
yy2457:
		yych = *++cursor_;
		if (yych == 'r') goto yy2537;
		goto yy87;
yy2458:
		yych = *++cursor_;
		if (yych == 'd') goto yy2538;
		goto yy87;
yy2459:
		yych = *++cursor_;
		if (yych == 'd') goto yy2539;
		goto yy87;
yy2460:
		yych = *++cursor_;
		if (yych == 'p') goto yy2540;
		goto yy87;
yy2461:
		yych = *++cursor_;
		if (yych == '_') goto yy2541;
		goto yy87;
yy2462:
		yych = *++cursor_;
		if (yych == 'b') goto yy2542;
		goto yy87;
yy2463:
		yych = *++cursor_;
		if (yych == 'h') goto yy2543;
		goto yy87;
yy2464:
		yych = *++cursor_;
		if (yych == 'r') goto yy2544;
		goto yy87;
yy2465:
		yych = *++cursor_;
		if (yych == '_') goto yy2545;
		goto yy87;
yy2466:
		yych = *++cursor_;
		if (yych == '_') goto yy2546;
		goto yy87;
yy2467:
		yych = *++cursor_;
		if (yych == 'x') goto yy2547;
		goto yy87;
yy2468:
		yych = *++cursor_;
		if (yych == 'u') goto yy2548;
		goto yy87;
yy2469:
		yych = *++cursor_;
		if (yych == '_') goto yy2550;
		goto yy87;
yy2470:
		yych = *++cursor_;
		if (yych == 'g') goto yy2551;
		goto yy87;
yy2471:
		yych = *++cursor_;
		if (yych == '_') goto yy2552;
		goto yy87;
yy2472:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 700 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64ReinterpretF64); }
#line 12480 "src/prebuilt/wast-lexer-gen.cc"
yy2474:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 445 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64ReinterpretF64); }
#line 12488 "src/prebuilt/wast-lexer-gen.cc"
yy2476:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 702 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncSatF32S); }
#line 12496 "src/prebuilt/wast-lexer-gen.cc"
yy2478:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 704 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncSatF64S); }
#line 12504 "src/prebuilt/wast-lexer-gen.cc"
yy2480:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 425 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncSatF32S); }
#line 12512 "src/prebuilt/wast-lexer-gen.cc"
yy2482:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 429 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncSatF32U); }
#line 12520 "src/prebuilt/wast-lexer-gen.cc"
yy2484:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 427 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncSatF64S); }
#line 12528 "src/prebuilt/wast-lexer-gen.cc"
yy2486:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 431 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncSatF64U); }
#line 12536 "src/prebuilt/wast-lexer-gen.cc"
yy2488:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 706 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncSatF32U); }
#line 12544 "src/prebuilt/wast-lexer-gen.cc"
yy2490:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 708 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncSatF64U); }
#line 12552 "src/prebuilt/wast-lexer-gen.cc"
yy2492:
		yych = *++cursor_;
		if (yych == 'x') goto yy2553;
		goto yy87;
yy2493:
		yych = *++cursor_;
		if (yych == 's') goto yy2554;
		if (yych == 'u') goto yy2556;
		goto yy87;
yy2494:
		yych = *++cursor_;
		if (yych == 's') goto yy2558;
		if (yych == 'u') goto yy2560;
		goto yy87;
yy2495:
		yych = *++cursor_;
		if (yych == 's') goto yy2562;
		if (yych == 'u') goto yy2564;
		goto yy87;
yy2496:
		yych = *++cursor_;
		if (yych == 't') goto yy2566;
		goto yy87;
yy2497:
		yych = *++cursor_;
		if (yych == 'e') goto yy2568;
		goto yy87;
yy2498:
		yych = *++cursor_;
		if (yych == 'c') goto yy2569;
		goto yy87;
yy2499:
		yych = *++cursor_;
		if (yych == 's') goto yy2570;
		if (yych == 'u') goto yy2572;
		goto yy87;
yy2500:
		yych = *++cursor_;
		if (yych == 's') goto yy2574;
		if (yych == 'u') goto yy2576;
		goto yy87;
yy2501:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 567 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8AddSaturateS); }
#line 12601 "src/prebuilt/wast-lexer-gen.cc"
yy2503:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 568 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8AddSaturateU); }
#line 12609 "src/prebuilt/wast-lexer-gen.cc"
yy2505:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 537 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I16X8ExtractLaneS); }
#line 12617 "src/prebuilt/wast-lexer-gen.cc"
yy2507:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 538 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I16X8ExtractLaneU); }
#line 12625 "src/prebuilt/wast-lexer-gen.cc"
yy2509:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 571 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8SubSaturateS); }
#line 12633 "src/prebuilt/wast-lexer-gen.cc"
yy2511:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 572 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8SubSaturateU); }
#line 12641 "src/prebuilt/wast-lexer-gen.cc"
yy2513:
		yych = *++cursor_;
		if (yych == 'h') goto yy2578;
		goto yy87;
yy2514:
		yych = *++cursor_;
		if (yych == '_') goto yy2579;
		goto yy87;
yy2515:
		yych = *++cursor_;
		if (yych == '_') goto yy2580;
		goto yy87;
yy2516:
		yych = *++cursor_;
		if (yych == 'x') goto yy2581;
		goto yy87;
yy2517:
		yych = *++cursor_;
		if (yych == 'u') goto yy2582;
		goto yy87;
yy2518:
		yych = *++cursor_;
		if (yych == '_') goto yy2584;
		goto yy87;
yy2519:
		yych = *++cursor_;
		if (yych == 'g') goto yy2585;
		goto yy87;
yy2520:
		yych = *++cursor_;
		if (yych == '_') goto yy2586;
		goto yy87;
yy2521:
		yych = *++cursor_;
		if (yych == 'u') goto yy2587;
		goto yy87;
yy2522:
		yych = *++cursor_;
		if (yych == 'u') goto yy2589;
		goto yy87;
yy2523:
		yych = *++cursor_;
		if (yych == 'c') goto yy2591;
		goto yy87;
yy2524:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 500 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw8OrU); }
#line 12693 "src/prebuilt/wast-lexer-gen.cc"
yy2526:
		yych = *++cursor_;
		if (yych == 'u') goto yy2592;
		goto yy87;
yy2527:
		yych = *++cursor_;
		if (yych == '_') goto yy2594;
		goto yy87;
yy2528:
		yych = *++cursor_;
		if (yych == 'u') goto yy2595;
		goto yy87;
yy2529:
		yych = *++cursor_;
		if (yych == '4') goto yy2597;
		goto yy87;
yy2530:
		yych = *++cursor_;
		if (yych == 'h') goto yy2598;
		goto yy87;
yy2531:
		yych = *++cursor_;
		if (yych == '_') goto yy2599;
		goto yy87;
yy2532:
		yych = *++cursor_;
		if (yych == '_') goto yy2600;
		goto yy87;
yy2533:
		yych = *++cursor_;
		if (yych == 'x') goto yy2601;
		goto yy87;
yy2534:
		yych = *++cursor_;
		if (yych == 'u') goto yy2602;
		goto yy87;
yy2535:
		yych = *++cursor_;
		if (yych == '_') goto yy2604;
		goto yy87;
yy2536:
		yych = *++cursor_;
		if (yych == 'g') goto yy2605;
		goto yy87;
yy2537:
		yych = *++cursor_;
		if (yych == '_') goto yy2606;
		goto yy87;
yy2538:
		yych = *++cursor_;
		if (yych == '_') goto yy2607;
		goto yy87;
yy2539:
		yych = *++cursor_;
		if (yych == '_') goto yy2608;
		goto yy87;
yy2540:
		yych = *++cursor_;
		if (yych == 'x') goto yy2609;
		goto yy87;
yy2541:
		yych = *++cursor_;
		if (yych == 'u') goto yy2610;
		goto yy87;
yy2542:
		yych = *++cursor_;
		if (yych == '_') goto yy2612;
		goto yy87;
yy2543:
		yych = *++cursor_;
		if (yych == 'g') goto yy2613;
		goto yy87;
yy2544:
		yych = *++cursor_;
		if (yych == '_') goto yy2614;
		goto yy87;
yy2545:
		yych = *++cursor_;
		if (yych == 'u') goto yy2615;
		goto yy87;
yy2546:
		yych = *++cursor_;
		if (yych == 'u') goto yy2617;
		goto yy87;
yy2547:
		yych = *++cursor_;
		if (yych == 'c') goto yy2619;
		goto yy87;
yy2548:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 502 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw8OrU); }
#line 12789 "src/prebuilt/wast-lexer-gen.cc"
yy2550:
		yych = *++cursor_;
		if (yych == 'u') goto yy2620;
		goto yy87;
yy2551:
		yych = *++cursor_;
		if (yych == '_') goto yy2622;
		goto yy87;
yy2552:
		yych = *++cursor_;
		if (yych == 'u') goto yy2623;
		goto yy87;
yy2553:
		yych = *++cursor_;
		if (yych == '2') goto yy2625;
		goto yy87;
yy2554:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 565 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16AddSaturateS); }
#line 12813 "src/prebuilt/wast-lexer-gen.cc"
yy2556:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 566 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16AddSaturateU); }
#line 12821 "src/prebuilt/wast-lexer-gen.cc"
yy2558:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 535 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I8X16ExtractLaneS); }
#line 12829 "src/prebuilt/wast-lexer-gen.cc"
yy2560:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 536 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I8X16ExtractLaneU); }
#line 12837 "src/prebuilt/wast-lexer-gen.cc"
yy2562:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 569 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16SubSaturateS); }
#line 12845 "src/prebuilt/wast-lexer-gen.cc"
yy2564:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 570 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16SubSaturateU); }
#line 12853 "src/prebuilt/wast-lexer-gen.cc"
yy2566:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 667 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(ReturnCallIndirect); }
#line 12861 "src/prebuilt/wast-lexer-gen.cc"
yy2568:
		yych = *++cursor_;
		if (yych == 't') goto yy2626;
		goto yy87;
yy2569:
		yych = *++cursor_;
		if (yych == 'a') goto yy2627;
		goto yy87;
yy2570:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 658 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32X4ConvertI32X4S); }
#line 12877 "src/prebuilt/wast-lexer-gen.cc"
yy2572:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 659 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32X4ConvertI32X4U); }
#line 12885 "src/prebuilt/wast-lexer-gen.cc"
yy2574:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 660 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64X2ConvertI64X2S); }
#line 12893 "src/prebuilt/wast-lexer-gen.cc"
yy2576:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 661 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64X2ConvertI64X2U); }
#line 12901 "src/prebuilt/wast-lexer-gen.cc"
yy2578:
		yych = *++cursor_;
		if (yych == 'g') goto yy2628;
		goto yy87;
yy2579:
		yych = *++cursor_;
		if (yych == 'u') goto yy2630;
		goto yy87;
yy2580:
		yych = *++cursor_;
		if (yych == 'u') goto yy2632;
		goto yy87;
yy2581:
		yych = *++cursor_;
		if (yych == 'c') goto yy2634;
		goto yy87;
yy2582:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 501 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw16OrU); }
#line 12925 "src/prebuilt/wast-lexer-gen.cc"
yy2584:
		yych = *++cursor_;
		if (yych == 'u') goto yy2635;
		goto yy87;
yy2585:
		yych = *++cursor_;
		if (yych == '_') goto yy2637;
		goto yy87;
yy2586:
		yych = *++cursor_;
		if (yych == 'u') goto yy2638;
		goto yy87;
yy2587:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 479 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw8AddU); }
#line 12945 "src/prebuilt/wast-lexer-gen.cc"
yy2589:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 493 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw8AndU); }
#line 12953 "src/prebuilt/wast-lexer-gen.cc"
yy2591:
		yych = *++cursor_;
		if (yych == 'h') goto yy2640;
		goto yy87;
yy2592:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 486 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw8SubU); }
#line 12965 "src/prebuilt/wast-lexer-gen.cc"
yy2594:
		yych = *++cursor_;
		if (yych == 'u') goto yy2641;
		goto yy87;
yy2595:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 507 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw8XorU); }
#line 12977 "src/prebuilt/wast-lexer-gen.cc"
yy2597:
		yych = *++cursor_;
		if (yych == '_') goto yy2643;
		goto yy87;
yy2598:
		yych = *++cursor_;
		if (yych == 'g') goto yy2644;
		goto yy87;
yy2599:
		yych = *++cursor_;
		if (yych == 'u') goto yy2646;
		goto yy87;
yy2600:
		yych = *++cursor_;
		if (yych == 'u') goto yy2648;
		goto yy87;
yy2601:
		yych = *++cursor_;
		if (yych == 'c') goto yy2650;
		goto yy87;
yy2602:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 503 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw16OrU); }
#line 13005 "src/prebuilt/wast-lexer-gen.cc"
yy2604:
		yych = *++cursor_;
		if (yych == 'u') goto yy2651;
		goto yy87;
yy2605:
		yych = *++cursor_;
		if (yych == '_') goto yy2653;
		goto yy87;
yy2606:
		yych = *++cursor_;
		if (yych == 'u') goto yy2654;
		goto yy87;
yy2607:
		yych = *++cursor_;
		if (yych == 'u') goto yy2656;
		goto yy87;
yy2608:
		yych = *++cursor_;
		if (yych == 'u') goto yy2658;
		goto yy87;
yy2609:
		yych = *++cursor_;
		if (yych == 'c') goto yy2660;
		goto yy87;
yy2610:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 504 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw32OrU); }
#line 13037 "src/prebuilt/wast-lexer-gen.cc"
yy2612:
		yych = *++cursor_;
		if (yych == 'u') goto yy2661;
		goto yy87;
yy2613:
		yych = *++cursor_;
		if (yych == '_') goto yy2663;
		goto yy87;
yy2614:
		yych = *++cursor_;
		if (yych == 'u') goto yy2664;
		goto yy87;
yy2615:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 481 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw8AddU); }
#line 13057 "src/prebuilt/wast-lexer-gen.cc"
yy2617:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 495 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw8AndU); }
#line 13065 "src/prebuilt/wast-lexer-gen.cc"
yy2619:
		yych = *++cursor_;
		if (yych == 'h') goto yy2666;
		goto yy87;
yy2620:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 488 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw8SubU); }
#line 13077 "src/prebuilt/wast-lexer-gen.cc"
yy2622:
		yych = *++cursor_;
		if (yych == 'u') goto yy2667;
		goto yy87;
yy2623:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 509 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw8XorU); }
#line 13089 "src/prebuilt/wast-lexer-gen.cc"
yy2625:
		yych = *++cursor_;
		if (yych == '_') goto yy2669;
		goto yy87;
yy2626:
		yych = *++cursor_;
		if (yych == 'i') goto yy2670;
		goto yy87;
yy2627:
		yych = *++cursor_;
		if (yych == 'l') goto yy2671;
		goto yy87;
yy2628:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 519 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I32AtomicRmwCmpxchg); }
#line 13109 "src/prebuilt/wast-lexer-gen.cc"
yy2630:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 480 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw16AddU); }
#line 13117 "src/prebuilt/wast-lexer-gen.cc"
yy2632:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 494 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw16AndU); }
#line 13125 "src/prebuilt/wast-lexer-gen.cc"
yy2634:
		yych = *++cursor_;
		if (yych == 'h') goto yy2672;
		goto yy87;
yy2635:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 487 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw16SubU); }
#line 13137 "src/prebuilt/wast-lexer-gen.cc"
yy2637:
		yych = *++cursor_;
		if (yych == 'u') goto yy2673;
		goto yy87;
yy2638:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 508 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw16XorU); }
#line 13149 "src/prebuilt/wast-lexer-gen.cc"
yy2640:
		yych = *++cursor_;
		if (yych == 'g') goto yy2675;
		goto yy87;
yy2641:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 514 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw8XchgU); }
#line 13161 "src/prebuilt/wast-lexer-gen.cc"
yy2643:
		yych = *++cursor_;
		if (yych == 's') goto yy2676;
		if (yych == 'u') goto yy2678;
		goto yy87;
yy2644:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 520 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I64AtomicRmwCmpxchg); }
#line 13174 "src/prebuilt/wast-lexer-gen.cc"
yy2646:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 482 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw16AddU); }
#line 13182 "src/prebuilt/wast-lexer-gen.cc"
yy2648:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 496 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw16AndU); }
#line 13190 "src/prebuilt/wast-lexer-gen.cc"
yy2650:
		yych = *++cursor_;
		if (yych == 'h') goto yy2680;
		goto yy87;
yy2651:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 489 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw16SubU); }
#line 13202 "src/prebuilt/wast-lexer-gen.cc"
yy2653:
		yych = *++cursor_;
		if (yych == 'u') goto yy2681;
		goto yy87;
yy2654:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 510 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw16XorU); }
#line 13214 "src/prebuilt/wast-lexer-gen.cc"
yy2656:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 483 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw32AddU); }
#line 13222 "src/prebuilt/wast-lexer-gen.cc"
yy2658:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 497 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw32AndU); }
#line 13230 "src/prebuilt/wast-lexer-gen.cc"
yy2660:
		yych = *++cursor_;
		if (yych == 'h') goto yy2683;
		goto yy87;
yy2661:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 490 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw32SubU); }
#line 13242 "src/prebuilt/wast-lexer-gen.cc"
yy2663:
		yych = *++cursor_;
		if (yych == 'u') goto yy2684;
		goto yy87;
yy2664:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 511 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw32XorU); }
#line 13254 "src/prebuilt/wast-lexer-gen.cc"
yy2666:
		yych = *++cursor_;
		if (yych == 'g') goto yy2686;
		goto yy87;
yy2667:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 516 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw8XchgU); }
#line 13266 "src/prebuilt/wast-lexer-gen.cc"
yy2669:
		yych = *++cursor_;
		if (yych == 's') goto yy2687;
		if (yych == 'u') goto yy2689;
		goto yy87;
yy2670:
		yych = *++cursor_;
		if (yych == 'c') goto yy2691;
		goto yy87;
yy2671:
		yych = *++cursor_;
		if (yych == '_') goto yy2692;
		goto yy87;
yy2672:
		yych = *++cursor_;
		if (yych == 'g') goto yy2693;
		goto yy87;
yy2673:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 515 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw16XchgU); }
#line 13291 "src/prebuilt/wast-lexer-gen.cc"
yy2675:
		yych = *++cursor_;
		if (yych == '_') goto yy2694;
		goto yy87;
yy2676:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 662 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32X4TruncSatF32X4S); }
#line 13303 "src/prebuilt/wast-lexer-gen.cc"
yy2678:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 663 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32X4TruncSatF32X4U); }
#line 13311 "src/prebuilt/wast-lexer-gen.cc"
yy2680:
		yych = *++cursor_;
		if (yych == 'g') goto yy2695;
		goto yy87;
yy2681:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 517 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw16XchgU); }
#line 13323 "src/prebuilt/wast-lexer-gen.cc"
yy2683:
		yych = *++cursor_;
		if (yych == 'g') goto yy2696;
		goto yy87;
yy2684:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 518 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw32XchgU); }
#line 13335 "src/prebuilt/wast-lexer-gen.cc"
yy2686:
		yych = *++cursor_;
		if (yych == '_') goto yy2697;
		goto yy87;
yy2687:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 664 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64X2TruncSatF64X2S); }
#line 13347 "src/prebuilt/wast-lexer-gen.cc"
yy2689:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 665 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64X2TruncSatF64X2U); }
#line 13355 "src/prebuilt/wast-lexer-gen.cc"
yy2691:
		yych = *++cursor_;
		if (yych == '_') goto yy2698;
		goto yy87;
yy2692:
		yych = *++cursor_;
		if (yych == 'n') goto yy2699;
		goto yy87;
yy2693:
		yych = *++cursor_;
		if (yych == '_') goto yy2700;
		goto yy87;
yy2694:
		yych = *++cursor_;
		if (yych == 'u') goto yy2701;
		goto yy87;
yy2695:
		yych = *++cursor_;
		if (yych == '_') goto yy2703;
		goto yy87;
yy2696:
		yych = *++cursor_;
		if (yych == '_') goto yy2704;
		goto yy87;
yy2697:
		yych = *++cursor_;
		if (yych == 'u') goto yy2705;
		goto yy87;
yy2698:
		yych = *++cursor_;
		if (yych == 'n') goto yy2707;
		goto yy87;
yy2699:
		yych = *++cursor_;
		if (yych == 'a') goto yy2708;
		goto yy87;
yy2700:
		yych = *++cursor_;
		if (yych == 'u') goto yy2709;
		goto yy87;
yy2701:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 521 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I32AtomicRmw8CmpxchgU); }
#line 13403 "src/prebuilt/wast-lexer-gen.cc"
yy2703:
		yych = *++cursor_;
		if (yych == 'u') goto yy2711;
		goto yy87;
yy2704:
		yych = *++cursor_;
		if (yych == 'u') goto yy2713;
		goto yy87;
yy2705:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 523 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I64AtomicRmw8CmpxchgU); }
#line 13419 "src/prebuilt/wast-lexer-gen.cc"
yy2707:
		yych = *++cursor_;
		if (yych == 'a') goto yy2715;
		goto yy87;
yy2708:
		yych = *++cursor_;
		if (yych == 'n') goto yy2716;
		goto yy87;
yy2709:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 522 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I32AtomicRmw16CmpxchgU); }
#line 13435 "src/prebuilt/wast-lexer-gen.cc"
yy2711:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 524 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I64AtomicRmw16CmpxchgU); }
#line 13443 "src/prebuilt/wast-lexer-gen.cc"
yy2713:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 525 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I64AtomicRmw32CmpxchgU); }
#line 13451 "src/prebuilt/wast-lexer-gen.cc"
yy2715:
		yych = *++cursor_;
		if (yych == 'n') goto yy2718;
		goto yy87;
yy2716:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 736 "src/wast-lexer.cc"
		{ RETURN(AssertReturnCanonicalNan); }
#line 13463 "src/prebuilt/wast-lexer-gen.cc"
yy2718:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 737 "src/wast-lexer.cc"
		{ RETURN(AssertReturnArithmeticNan); }
#line 13471 "src/prebuilt/wast-lexer-gen.cc"
	}
}
#line 765 "src/wast-lexer.cc"

  }
}

}  // namespace wabt
