
#line 1 "../../src/hb-ot-shape-complex-indic-machine.rl"
/*
 * Copyright © 2011,2012  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH
#define HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH

#include "hb-private.hh"


#line 36 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
static const unsigned char _indic_syllable_machine_trans_keys[] = {
	1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 
	7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 
	5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 
	4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 
	7u, 7u, 4u, 4u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 5u, 7u, 5u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 
	7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 1u, 16u, 13u, 13u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 1u, 31u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 5u, 14u, 8u, 14u, 
	5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 
	3u, 10u, 8u, 10u, 3u, 10u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 
	6u, 14u, 3u, 14u, 1u, 16u, 4u, 31u, 4u, 14u, 3u, 31u, 3u, 31u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 31u, 3u, 31u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 5u, 14u, 8u, 14u, 
	5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 
	3u, 10u, 8u, 10u, 3u, 10u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 
	6u, 14u, 3u, 14u, 1u, 16u, 4u, 31u, 4u, 14u, 3u, 31u, 3u, 31u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	4u, 14u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 
	4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 
	4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 5u, 14u, 8u, 14u, 5u, 10u, 
	9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 3u, 10u, 
	8u, 10u, 3u, 10u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 6u, 14u, 
	3u, 14u, 1u, 16u, 4u, 31u, 4u, 14u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	4u, 14u, 3u, 31u, 4u, 14u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 5u, 14u, 8u, 14u, 
	5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 
	3u, 10u, 8u, 10u, 3u, 10u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 
	6u, 14u, 3u, 14u, 1u, 16u, 4u, 31u, 4u, 14u, 3u, 31u, 3u, 31u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 31u, 1u, 31u, 3u, 31u, 1u, 31u, 4u, 14u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 
	5u, 10u, 3u, 31u, 3u, 31u, 1u, 16u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 8u, 14u, 
	3u, 13u, 3u, 10u, 8u, 10u, 3u, 10u, 3u, 13u, 1u, 16u, 3u, 10u, 8u, 10u, 
	5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 0
};

static const char _indic_syllable_machine_key_spans[] = {
	16, 1, 3, 3, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 16, 1, 3, 3, 
	1, 3, 3, 1, 3, 3, 1, 3, 
	3, 1, 1, 1, 1, 4, 1, 1, 
	4, 1, 1, 4, 1, 1, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	16, 1, 3, 3, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 16, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 3, 3, 
	1, 1, 1, 1, 4, 1, 1, 4, 
	1, 1, 4, 1, 1, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 3, 3, 3, 3, 1, 3, 3, 
	1, 3, 3, 1, 16, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 31, 29, 29, 28, 16, 29, 
	29, 28, 16, 29, 29, 28, 16, 29, 
	29, 28, 16, 29, 29, 28, 10, 7, 
	6, 2, 1, 2, 2, 1, 6, 11, 
	8, 3, 8, 11, 12, 12, 11, 10, 
	12, 11, 10, 12, 11, 10, 12, 11, 
	9, 12, 16, 28, 11, 29, 29, 16, 
	16, 16, 16, 16, 29, 29, 16, 16, 
	16, 16, 16, 29, 29, 16, 16, 16, 
	16, 16, 29, 29, 16, 16, 16, 16, 
	16, 29, 29, 29, 29, 28, 16, 29, 
	29, 28, 16, 29, 29, 28, 16, 29, 
	29, 28, 16, 29, 29, 28, 10, 7, 
	6, 2, 1, 2, 2, 1, 6, 11, 
	8, 3, 8, 11, 12, 12, 11, 10, 
	12, 11, 10, 12, 11, 10, 12, 11, 
	9, 12, 16, 28, 11, 29, 29, 16, 
	16, 16, 16, 16, 29, 29, 16, 16, 
	16, 16, 16, 29, 29, 16, 16, 16, 
	16, 16, 29, 29, 16, 16, 16, 16, 
	11, 16, 29, 29, 28, 16, 29, 29, 
	28, 16, 29, 29, 28, 16, 29, 29, 
	28, 16, 29, 29, 28, 10, 7, 6, 
	2, 1, 2, 2, 1, 6, 11, 8, 
	3, 8, 11, 12, 12, 11, 10, 12, 
	11, 10, 12, 11, 10, 12, 11, 9, 
	12, 16, 28, 11, 29, 29, 16, 16, 
	16, 16, 16, 29, 29, 16, 16, 16, 
	16, 16, 29, 29, 16, 16, 16, 16, 
	16, 29, 29, 16, 16, 16, 16, 16, 
	11, 29, 11, 29, 29, 28, 16, 29, 
	29, 28, 16, 29, 29, 28, 16, 29, 
	29, 28, 16, 29, 29, 28, 10, 7, 
	6, 2, 1, 2, 2, 1, 6, 11, 
	8, 3, 8, 11, 12, 12, 11, 10, 
	12, 11, 10, 12, 11, 10, 12, 11, 
	9, 12, 16, 28, 11, 29, 29, 16, 
	16, 16, 16, 16, 29, 29, 16, 16, 
	16, 16, 16, 29, 29, 16, 16, 16, 
	16, 16, 29, 29, 16, 16, 16, 16, 
	16, 29, 31, 29, 31, 11, 16, 29, 
	29, 28, 6, 2, 1, 2, 2, 1, 
	6, 29, 29, 16, 12, 11, 10, 12, 
	11, 10, 12, 11, 10, 12, 11, 7, 
	11, 8, 3, 8, 11, 16, 8, 3, 
	6, 2, 1, 2, 2, 1, 6
};

static const short _indic_syllable_machine_index_offsets[] = {
	0, 17, 19, 23, 27, 29, 33, 37, 
	39, 43, 47, 49, 53, 57, 59, 61, 
	63, 65, 70, 72, 74, 79, 81, 83, 
	88, 90, 92, 104, 116, 128, 140, 152, 
	164, 176, 188, 200, 212, 229, 231, 235, 
	239, 241, 245, 249, 251, 255, 259, 261, 
	265, 269, 271, 273, 275, 277, 282, 284, 
	286, 291, 293, 295, 300, 302, 304, 316, 
	328, 340, 352, 364, 376, 388, 400, 412, 
	424, 441, 443, 447, 451, 453, 457, 461, 
	463, 467, 471, 473, 477, 481, 483, 485, 
	487, 489, 494, 496, 498, 503, 505, 507, 
	512, 514, 516, 528, 540, 552, 564, 576, 
	588, 600, 612, 624, 641, 643, 647, 651, 
	653, 657, 661, 663, 667, 671, 673, 677, 
	681, 683, 685, 687, 689, 694, 696, 698, 
	703, 705, 707, 712, 714, 716, 728, 740, 
	752, 764, 776, 788, 800, 812, 824, 836, 
	848, 860, 864, 868, 872, 876, 878, 882, 
	886, 888, 892, 896, 898, 915, 917, 919, 
	921, 923, 928, 930, 932, 937, 939, 941, 
	946, 948, 950, 982, 1012, 1042, 1071, 1088, 
	1118, 1148, 1177, 1194, 1224, 1254, 1283, 1300, 
	1330, 1360, 1389, 1406, 1436, 1466, 1495, 1506, 
	1514, 1521, 1524, 1526, 1529, 1532, 1534, 1541, 
	1553, 1562, 1566, 1575, 1587, 1600, 1613, 1625, 
	1636, 1649, 1661, 1672, 1685, 1697, 1708, 1721, 
	1733, 1743, 1756, 1773, 1802, 1814, 1844, 1874, 
	1891, 1908, 1925, 1942, 1959, 1989, 2019, 2036, 
	2053, 2070, 2087, 2104, 2134, 2164, 2181, 2198, 
	2215, 2232, 2249, 2279, 2309, 2326, 2343, 2360, 
	2377, 2394, 2424, 2454, 2484, 2514, 2543, 2560, 
	2590, 2620, 2649, 2666, 2696, 2726, 2755, 2772, 
	2802, 2832, 2861, 2878, 2908, 2938, 2967, 2978, 
	2986, 2993, 2996, 2998, 3001, 3004, 3006, 3013, 
	3025, 3034, 3038, 3047, 3059, 3072, 3085, 3097, 
	3108, 3121, 3133, 3144, 3157, 3169, 3180, 3193, 
	3205, 3215, 3228, 3245, 3274, 3286, 3316, 3346, 
	3363, 3380, 3397, 3414, 3431, 3461, 3491, 3508, 
	3525, 3542, 3559, 3576, 3606, 3636, 3653, 3670, 
	3687, 3704, 3721, 3751, 3781, 3798, 3815, 3832, 
	3849, 3861, 3878, 3908, 3938, 3967, 3984, 4014, 
	4044, 4073, 4090, 4120, 4150, 4179, 4196, 4226, 
	4256, 4285, 4302, 4332, 4362, 4391, 4402, 4410, 
	4417, 4420, 4422, 4425, 4428, 4430, 4437, 4449, 
	4458, 4462, 4471, 4483, 4496, 4509, 4521, 4532, 
	4545, 4557, 4568, 4581, 4593, 4604, 4617, 4629, 
	4639, 4652, 4669, 4698, 4710, 4740, 4770, 4787, 
	4804, 4821, 4838, 4855, 4885, 4915, 4932, 4949, 
	4966, 4983, 5000, 5030, 5060, 5077, 5094, 5111, 
	5128, 5145, 5175, 5205, 5222, 5239, 5256, 5273, 
	5290, 5302, 5332, 5344, 5374, 5404, 5433, 5450, 
	5480, 5510, 5539, 5556, 5586, 5616, 5645, 5662, 
	5692, 5722, 5751, 5768, 5798, 5828, 5857, 5868, 
	5876, 5883, 5886, 5888, 5891, 5894, 5896, 5903, 
	5915, 5924, 5928, 5937, 5949, 5962, 5975, 5987, 
	5998, 6011, 6023, 6034, 6047, 6059, 6070, 6083, 
	6095, 6105, 6118, 6135, 6164, 6176, 6206, 6236, 
	6253, 6270, 6287, 6304, 6321, 6351, 6381, 6398, 
	6415, 6432, 6449, 6466, 6496, 6526, 6543, 6560, 
	6577, 6594, 6611, 6641, 6671, 6688, 6705, 6722, 
	6739, 6756, 6786, 6818, 6848, 6880, 6892, 6909, 
	6939, 6969, 6998, 7005, 7008, 7010, 7013, 7016, 
	7018, 7025, 7055, 7085, 7102, 7115, 7127, 7138, 
	7151, 7163, 7174, 7187, 7199, 7210, 7223, 7235, 
	7243, 7255, 7264, 7268, 7277, 7289, 7306, 7315, 
	7319, 7326, 7329, 7331, 7334, 7337, 7339
};

static const short _indic_syllable_machine_indicies[] = {
	1, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 3, 0, 4, 4, 5, 0, 6, 
	6, 5, 0, 5, 0, 7, 7, 8, 
	0, 9, 9, 8, 0, 8, 0, 10, 
	10, 11, 0, 12, 12, 11, 0, 11, 
	0, 13, 13, 14, 0, 15, 15, 14, 
	0, 14, 0, 16, 0, 17, 0, 18, 
	0, 19, 13, 13, 14, 0, 20, 0, 
	21, 0, 22, 10, 10, 11, 0, 23, 
	0, 24, 0, 25, 7, 7, 8, 0, 
	26, 0, 27, 0, 28, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 28, 0, 
	28, 4, 4, 5, 0, 0, 0, 0, 
	0, 29, 28, 0, 30, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 30, 0, 
	30, 4, 4, 5, 0, 0, 0, 0, 
	0, 31, 30, 0, 32, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 32, 0, 
	32, 4, 4, 5, 0, 0, 0, 0, 
	0, 33, 32, 0, 34, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 34, 0, 
	34, 4, 4, 5, 0, 0, 0, 0, 
	0, 35, 34, 0, 36, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 36, 0, 
	36, 4, 4, 5, 0, 0, 0, 0, 
	0, 37, 36, 0, 39, 40, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 39, 38, 41, 38, 42, 
	42, 43, 38, 44, 44, 43, 38, 43, 
	38, 45, 45, 46, 38, 47, 47, 46, 
	38, 46, 38, 48, 48, 49, 38, 50, 
	50, 49, 38, 49, 38, 51, 51, 52, 
	38, 53, 53, 52, 38, 52, 38, 54, 
	38, 55, 38, 56, 38, 57, 51, 51, 
	52, 38, 58, 38, 59, 38, 60, 48, 
	48, 49, 38, 61, 38, 62, 38, 63, 
	45, 45, 46, 38, 64, 38, 65, 38, 
	66, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 66, 38, 66, 42, 42, 43, 
	38, 38, 38, 38, 38, 67, 66, 38, 
	68, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 68, 38, 68, 42, 42, 43, 
	38, 38, 38, 38, 38, 69, 68, 38, 
	70, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 70, 38, 70, 42, 42, 43, 
	38, 38, 38, 38, 38, 71, 70, 38, 
	72, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 72, 38, 72, 42, 42, 43, 
	38, 38, 38, 38, 38, 73, 72, 38, 
	74, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 74, 38, 74, 42, 42, 43, 
	38, 38, 38, 38, 38, 75, 74, 38, 
	77, 78, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 77, 
	76, 79, 76, 80, 80, 81, 76, 83, 
	83, 81, 82, 81, 82, 84, 84, 85, 
	76, 86, 86, 85, 76, 85, 76, 87, 
	87, 88, 76, 89, 89, 88, 76, 88, 
	76, 90, 90, 91, 76, 92, 92, 91, 
	76, 91, 76, 93, 76, 94, 76, 95, 
	76, 96, 90, 90, 91, 76, 97, 76, 
	98, 76, 99, 87, 87, 88, 76, 100, 
	76, 101, 76, 102, 84, 84, 85, 76, 
	103, 76, 104, 76, 105, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 105, 76, 
	105, 80, 80, 81, 76, 76, 76, 76, 
	76, 106, 105, 76, 107, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 107, 76, 
	107, 80, 80, 81, 76, 76, 76, 76, 
	76, 108, 107, 76, 109, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 109, 76, 
	109, 80, 80, 81, 76, 76, 76, 76, 
	76, 110, 109, 76, 111, 80, 80, 81, 
	82, 82, 82, 82, 82, 82, 111, 82, 
	111, 80, 80, 81, 76, 76, 76, 76, 
	76, 112, 111, 76, 113, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 113, 76, 
	115, 116, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 115, 
	114, 117, 114, 118, 118, 119, 114, 120, 
	120, 119, 114, 119, 114, 121, 121, 122, 
	114, 123, 123, 122, 114, 122, 114, 124, 
	124, 125, 114, 126, 126, 125, 114, 125, 
	114, 127, 127, 128, 114, 129, 129, 128, 
	114, 128, 114, 130, 114, 131, 114, 132, 
	114, 133, 127, 127, 128, 114, 134, 114, 
	135, 114, 136, 124, 124, 125, 114, 137, 
	114, 138, 114, 139, 121, 121, 122, 114, 
	140, 114, 141, 114, 142, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 142, 114, 
	142, 118, 118, 119, 114, 114, 114, 114, 
	114, 143, 142, 114, 144, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 144, 114, 
	144, 118, 118, 119, 114, 114, 114, 114, 
	114, 145, 144, 114, 146, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 146, 114, 
	146, 118, 118, 119, 114, 114, 114, 114, 
	114, 147, 146, 114, 148, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 148, 114, 
	148, 118, 118, 119, 114, 114, 114, 114, 
	114, 149, 148, 114, 150, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 150, 114, 
	150, 118, 118, 119, 114, 114, 114, 114, 
	114, 151, 150, 114, 113, 80, 80, 81, 
	76, 76, 76, 76, 76, 152, 113, 76, 
	111, 80, 80, 81, 0, 0, 0, 0, 
	0, 153, 111, 0, 154, 154, 155, 0, 
	6, 6, 155, 0, 156, 156, 157, 0, 
	158, 158, 157, 0, 157, 0, 159, 159, 
	160, 0, 161, 161, 160, 0, 160, 0, 
	162, 162, 163, 0, 164, 164, 163, 0, 
	163, 0, 165, 166, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 165, 0, 167, 0, 168, 0, 169, 
	0, 170, 0, 171, 162, 162, 163, 0, 
	172, 0, 173, 0, 174, 159, 159, 160, 
	0, 175, 0, 176, 0, 177, 156, 156, 
	157, 0, 178, 0, 179, 0, 181, 182, 
	183, 184, 185, 186, 81, 187, 188, 189, 
	190, 190, 152, 191, 192, 193, 194, 195, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 196, 180, 198, 199, 
	200, 201, 5, 202, 203, 204, 197, 197, 
	37, 205, 197, 197, 206, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 207, 197, 208, 199, 209, 209, 
	5, 202, 203, 204, 197, 197, 197, 205, 
	197, 197, 206, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	207, 197, 199, 209, 209, 5, 202, 203, 
	204, 197, 197, 197, 205, 197, 197, 206, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 207, 197, 210, 
	197, 197, 197, 18, 211, 197, 202, 203, 
	204, 197, 197, 197, 212, 197, 210, 197, 
	213, 214, 215, 216, 5, 202, 203, 204, 
	197, 197, 35, 217, 197, 197, 206, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 207, 197, 218, 214, 
	219, 219, 5, 202, 203, 204, 197, 197, 
	197, 217, 197, 197, 206, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 207, 197, 214, 219, 219, 5, 
	202, 203, 204, 197, 197, 197, 217, 197, 
	197, 206, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 207, 
	197, 220, 197, 197, 197, 18, 221, 197, 
	202, 203, 204, 197, 197, 197, 212, 197, 
	220, 197, 222, 223, 224, 225, 5, 202, 
	203, 204, 197, 197, 33, 226, 197, 197, 
	206, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 207, 197, 
	227, 223, 228, 228, 5, 202, 203, 204, 
	197, 197, 197, 226, 197, 197, 206, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 207, 197, 223, 228, 
	228, 5, 202, 203, 204, 197, 197, 197, 
	226, 197, 197, 206, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 207, 197, 229, 197, 197, 197, 18, 
	230, 197, 202, 203, 204, 197, 197, 197, 
	212, 197, 229, 197, 231, 232, 233, 234, 
	5, 202, 203, 204, 197, 197, 31, 235, 
	197, 197, 206, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	207, 197, 236, 232, 237, 237, 5, 202, 
	203, 204, 197, 197, 197, 235, 197, 197, 
	206, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 207, 197, 
	232, 237, 237, 5, 202, 203, 204, 197, 
	197, 197, 235, 197, 197, 206, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 207, 197, 238, 197, 197, 
	197, 18, 239, 197, 202, 203, 204, 197, 
	197, 197, 212, 197, 238, 197, 240, 241, 
	242, 243, 5, 202, 203, 204, 197, 197, 
	29, 244, 197, 197, 206, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 207, 197, 245, 241, 246, 246, 
	5, 202, 203, 204, 197, 197, 197, 244, 
	197, 197, 206, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	207, 197, 241, 246, 246, 5, 202, 203, 
	204, 197, 197, 197, 244, 197, 197, 206, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 207, 197, 18, 
	247, 197, 202, 203, 204, 197, 197, 197, 
	212, 197, 202, 203, 204, 197, 197, 197, 
	212, 197, 248, 197, 197, 249, 203, 204, 
	197, 203, 204, 197, 250, 197, 203, 251, 
	197, 203, 252, 197, 203, 197, 248, 197, 
	197, 197, 203, 204, 197, 253, 197, 254, 
	255, 197, 202, 203, 204, 197, 197, 3, 
	197, 2, 197, 197, 197, 197, 202, 203, 
	204, 197, 202, 203, 204, 197, 253, 197, 
	197, 197, 197, 202, 203, 204, 197, 253, 
	197, 254, 197, 197, 202, 203, 204, 197, 
	197, 3, 197, 18, 197, 256, 256, 5, 
	202, 203, 204, 197, 197, 197, 212, 197, 
	257, 27, 258, 259, 8, 202, 203, 204, 
	197, 197, 197, 212, 197, 27, 258, 259, 
	8, 202, 203, 204, 197, 197, 197, 212, 
	197, 258, 258, 8, 202, 203, 204, 197, 
	197, 197, 212, 197, 260, 24, 261, 262, 
	11, 202, 203, 204, 197, 197, 197, 212, 
	197, 24, 261, 262, 11, 202, 203, 204, 
	197, 197, 197, 212, 197, 261, 261, 11, 
	202, 203, 204, 197, 197, 197, 212, 197, 
	263, 21, 264, 265, 14, 202, 203, 204, 
	197, 197, 197, 212, 197, 21, 264, 265, 
	14, 202, 203, 204, 197, 197, 197, 212, 
	197, 264, 264, 14, 202, 203, 204, 197, 
	197, 197, 212, 197, 266, 18, 197, 267, 
	197, 202, 203, 204, 197, 197, 197, 212, 
	197, 18, 197, 267, 197, 202, 203, 204, 
	197, 197, 197, 212, 197, 268, 197, 202, 
	203, 204, 197, 197, 197, 212, 197, 18, 
	197, 197, 197, 197, 202, 203, 204, 197, 
	197, 197, 212, 197, 1, 2, 197, 197, 
	18, 247, 197, 202, 203, 204, 197, 197, 
	197, 212, 197, 1, 197, 241, 246, 246, 
	5, 202, 203, 204, 197, 197, 197, 244, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	207, 197, 241, 246, 246, 5, 202, 203, 
	204, 197, 197, 197, 244, 197, 240, 241, 
	246, 246, 5, 202, 203, 204, 197, 197, 
	197, 244, 197, 197, 206, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 207, 197, 240, 241, 242, 246, 
	5, 202, 203, 204, 197, 197, 29, 244, 
	197, 197, 206, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	207, 197, 238, 197, 269, 197, 256, 256, 
	5, 202, 203, 204, 197, 197, 197, 212, 
	197, 238, 197, 238, 197, 197, 197, 197, 
	197, 197, 202, 203, 204, 197, 197, 197, 
	212, 197, 238, 197, 238, 197, 197, 197, 
	197, 270, 197, 202, 203, 204, 197, 197, 
	197, 212, 197, 238, 197, 238, 197, 269, 
	197, 197, 197, 197, 202, 203, 204, 197, 
	197, 197, 212, 197, 238, 197, 238, 2, 
	197, 197, 18, 239, 197, 202, 203, 204, 
	197, 197, 197, 212, 197, 238, 197, 231, 
	232, 237, 237, 5, 202, 203, 204, 197, 
	197, 197, 235, 197, 197, 206, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 207, 197, 231, 232, 233, 
	237, 5, 202, 203, 204, 197, 197, 31, 
	235, 197, 197, 206, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 207, 197, 229, 197, 271, 197, 256, 
	256, 5, 202, 203, 204, 197, 197, 197, 
	212, 197, 229, 197, 229, 197, 197, 197, 
	197, 197, 197, 202, 203, 204, 197, 197, 
	197, 212, 197, 229, 197, 229, 197, 197, 
	197, 197, 272, 197, 202, 203, 204, 197, 
	197, 197, 212, 197, 229, 197, 229, 197, 
	271, 197, 197, 197, 197, 202, 203, 204, 
	197, 197, 197, 212, 197, 229, 197, 229, 
	2, 197, 197, 18, 230, 197, 202, 203, 
	204, 197, 197, 197, 212, 197, 229, 197, 
	222, 223, 228, 228, 5, 202, 203, 204, 
	197, 197, 197, 226, 197, 197, 206, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 207, 197, 222, 223, 
	224, 228, 5, 202, 203, 204, 197, 197, 
	33, 226, 197, 197, 206, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 207, 197, 220, 197, 273, 197, 
	256, 256, 5, 202, 203, 204, 197, 197, 
	197, 212, 197, 220, 197, 220, 197, 197, 
	197, 197, 197, 197, 202, 203, 204, 197, 
	197, 197, 212, 197, 220, 197, 220, 197, 
	197, 197, 197, 274, 197, 202, 203, 204, 
	197, 197, 197, 212, 197, 220, 197, 220, 
	197, 273, 197, 197, 197, 197, 202, 203, 
	204, 197, 197, 197, 212, 197, 220, 197, 
	220, 2, 197, 197, 18, 221, 197, 202, 
	203, 204, 197, 197, 197, 212, 197, 220, 
	197, 213, 214, 219, 219, 5, 202, 203, 
	204, 197, 197, 197, 217, 197, 197, 206, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 207, 197, 213, 
	214, 215, 219, 5, 202, 203, 204, 197, 
	197, 35, 217, 197, 197, 206, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 207, 197, 210, 197, 275, 
	197, 256, 256, 5, 202, 203, 204, 197, 
	197, 197, 212, 197, 210, 197, 210, 197, 
	197, 197, 197, 197, 197, 202, 203, 204, 
	197, 197, 197, 212, 197, 210, 197, 210, 
	197, 197, 197, 197, 276, 197, 202, 203, 
	204, 197, 197, 197, 212, 197, 210, 197, 
	210, 197, 275, 197, 197, 197, 197, 202, 
	203, 204, 197, 197, 197, 212, 197, 210, 
	197, 210, 2, 197, 197, 18, 211, 197, 
	202, 203, 204, 197, 197, 197, 212, 197, 
	210, 197, 198, 199, 209, 209, 5, 202, 
	203, 204, 197, 197, 197, 205, 197, 197, 
	206, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 207, 197, 
	198, 199, 200, 209, 5, 202, 203, 204, 
	197, 197, 37, 205, 197, 197, 206, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 207, 197, 278, 279, 
	280, 281, 43, 282, 283, 284, 277, 277, 
	75, 285, 277, 277, 286, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 287, 277, 288, 279, 289, 281, 
	43, 282, 283, 284, 277, 277, 277, 285, 
	277, 277, 286, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	287, 277, 279, 289, 281, 43, 282, 283, 
	284, 277, 277, 277, 285, 277, 277, 286, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 287, 277, 290, 
	277, 277, 277, 56, 291, 277, 282, 283, 
	284, 277, 277, 277, 292, 277, 290, 277, 
	293, 294, 295, 296, 43, 282, 283, 284, 
	277, 277, 73, 297, 277, 277, 286, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 287, 277, 298, 294, 
	299, 299, 43, 282, 283, 284, 277, 277, 
	277, 297, 277, 277, 286, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 287, 277, 294, 299, 299, 43, 
	282, 283, 284, 277, 277, 277, 297, 277, 
	277, 286, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 287, 
	277, 300, 277, 277, 277, 56, 301, 277, 
	282, 283, 284, 277, 277, 277, 292, 277, 
	300, 277, 302, 303, 304, 305, 43, 282, 
	283, 284, 277, 277, 71, 306, 277, 277, 
	286, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 287, 277, 
	307, 303, 308, 308, 43, 282, 283, 284, 
	277, 277, 277, 306, 277, 277, 286, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 287, 277, 303, 308, 
	308, 43, 282, 283, 284, 277, 277, 277, 
	306, 277, 277, 286, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 287, 277, 309, 277, 277, 277, 56, 
	310, 277, 282, 283, 284, 277, 277, 277, 
	292, 277, 309, 277, 311, 312, 313, 314, 
	43, 282, 283, 284, 277, 277, 69, 315, 
	277, 277, 286, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	287, 277, 316, 312, 317, 317, 43, 282, 
	283, 284, 277, 277, 277, 315, 277, 277, 
	286, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 287, 277, 
	312, 317, 317, 43, 282, 283, 284, 277, 
	277, 277, 315, 277, 277, 286, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 287, 277, 318, 277, 277, 
	277, 56, 319, 277, 282, 283, 284, 277, 
	277, 277, 292, 277, 318, 277, 320, 321, 
	322, 323, 43, 282, 283, 284, 277, 277, 
	67, 324, 277, 277, 286, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 287, 277, 325, 321, 326, 326, 
	43, 282, 283, 284, 277, 277, 277, 324, 
	277, 277, 286, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	287, 277, 321, 326, 326, 43, 282, 283, 
	284, 277, 277, 277, 324, 277, 277, 286, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 287, 277, 56, 
	327, 277, 282, 283, 284, 277, 277, 277, 
	292, 277, 282, 283, 284, 277, 277, 277, 
	292, 277, 328, 277, 277, 329, 283, 284, 
	277, 283, 284, 277, 330, 277, 283, 331, 
	277, 283, 332, 277, 283, 277, 328, 277, 
	277, 277, 283, 284, 277, 333, 277, 334, 
	335, 277, 282, 283, 284, 277, 277, 41, 
	277, 40, 277, 277, 277, 277, 282, 283, 
	284, 277, 282, 283, 284, 277, 333, 277, 
	277, 277, 277, 282, 283, 284, 277, 333, 
	277, 334, 277, 277, 282, 283, 284, 277, 
	277, 41, 277, 56, 277, 336, 336, 43, 
	282, 283, 284, 277, 277, 277, 292, 277, 
	337, 65, 338, 339, 46, 282, 283, 284, 
	277, 277, 277, 292, 277, 65, 338, 339, 
	46, 282, 283, 284, 277, 277, 277, 292, 
	277, 338, 338, 46, 282, 283, 284, 277, 
	277, 277, 292, 277, 340, 62, 341, 342, 
	49, 282, 283, 284, 277, 277, 277, 292, 
	277, 62, 341, 342, 49, 282, 283, 284, 
	277, 277, 277, 292, 277, 341, 341, 49, 
	282, 283, 284, 277, 277, 277, 292, 277, 
	343, 59, 344, 345, 52, 282, 283, 284, 
	277, 277, 277, 292, 277, 59, 344, 345, 
	52, 282, 283, 284, 277, 277, 277, 292, 
	277, 344, 344, 52, 282, 283, 284, 277, 
	277, 277, 292, 277, 346, 56, 277, 347, 
	277, 282, 283, 284, 277, 277, 277, 292, 
	277, 56, 277, 347, 277, 282, 283, 284, 
	277, 277, 277, 292, 277, 348, 277, 282, 
	283, 284, 277, 277, 277, 292, 277, 56, 
	277, 277, 277, 277, 282, 283, 284, 277, 
	277, 277, 292, 277, 39, 40, 277, 277, 
	56, 327, 277, 282, 283, 284, 277, 277, 
	277, 292, 277, 39, 277, 321, 326, 326, 
	43, 282, 283, 284, 277, 277, 277, 324, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	287, 277, 321, 326, 326, 43, 282, 283, 
	284, 277, 277, 277, 324, 277, 320, 321, 
	326, 326, 43, 282, 283, 284, 277, 277, 
	277, 324, 277, 277, 286, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 287, 277, 320, 321, 322, 326, 
	43, 282, 283, 284, 277, 277, 67, 324, 
	277, 277, 286, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	287, 277, 318, 277, 349, 277, 336, 336, 
	43, 282, 283, 284, 277, 277, 277, 292, 
	277, 318, 277, 318, 277, 277, 277, 277, 
	277, 277, 282, 283, 284, 277, 277, 277, 
	292, 277, 318, 277, 318, 277, 277, 277, 
	277, 350, 277, 282, 283, 284, 277, 277, 
	277, 292, 277, 318, 277, 318, 277, 349, 
	277, 277, 277, 277, 282, 283, 284, 277, 
	277, 277, 292, 277, 318, 277, 318, 40, 
	277, 277, 56, 319, 277, 282, 283, 284, 
	277, 277, 277, 292, 277, 318, 277, 311, 
	312, 317, 317, 43, 282, 283, 284, 277, 
	277, 277, 315, 277, 277, 286, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 287, 277, 311, 312, 313, 
	317, 43, 282, 283, 284, 277, 277, 69, 
	315, 277, 277, 286, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 287, 277, 309, 277, 351, 277, 336, 
	336, 43, 282, 283, 284, 277, 277, 277, 
	292, 277, 309, 277, 309, 277, 277, 277, 
	277, 277, 277, 282, 283, 284, 277, 277, 
	277, 292, 277, 309, 277, 309, 277, 277, 
	277, 277, 352, 277, 282, 283, 284, 277, 
	277, 277, 292, 277, 309, 277, 309, 277, 
	351, 277, 277, 277, 277, 282, 283, 284, 
	277, 277, 277, 292, 277, 309, 277, 309, 
	40, 277, 277, 56, 310, 277, 282, 283, 
	284, 277, 277, 277, 292, 277, 309, 277, 
	302, 303, 308, 308, 43, 282, 283, 284, 
	277, 277, 277, 306, 277, 277, 286, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 287, 277, 302, 303, 
	304, 308, 43, 282, 283, 284, 277, 277, 
	71, 306, 277, 277, 286, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 287, 277, 300, 277, 353, 277, 
	336, 336, 43, 282, 283, 284, 277, 277, 
	277, 292, 277, 300, 277, 300, 277, 277, 
	277, 277, 277, 277, 282, 283, 284, 277, 
	277, 277, 292, 277, 300, 277, 300, 277, 
	277, 277, 277, 354, 277, 282, 283, 284, 
	277, 277, 277, 292, 277, 300, 277, 300, 
	277, 353, 277, 277, 277, 277, 282, 283, 
	284, 277, 277, 277, 292, 277, 300, 277, 
	300, 40, 277, 277, 56, 301, 277, 282, 
	283, 284, 277, 277, 277, 292, 277, 300, 
	277, 293, 294, 299, 299, 43, 282, 283, 
	284, 277, 277, 277, 297, 277, 277, 286, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 287, 277, 293, 
	294, 295, 299, 43, 282, 283, 284, 277, 
	277, 73, 297, 277, 277, 286, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 287, 277, 290, 277, 355, 
	277, 336, 336, 43, 282, 283, 284, 277, 
	277, 277, 292, 277, 290, 277, 290, 277, 
	277, 277, 277, 277, 277, 282, 283, 284, 
	277, 277, 277, 292, 277, 290, 277, 290, 
	277, 277, 277, 277, 356, 277, 282, 283, 
	284, 277, 277, 277, 292, 277, 290, 277, 
	290, 277, 355, 277, 277, 277, 277, 282, 
	283, 284, 277, 277, 277, 292, 277, 290, 
	277, 74, 42, 42, 43, 277, 277, 277, 
	277, 277, 277, 74, 277, 290, 40, 277, 
	277, 56, 291, 277, 282, 283, 284, 277, 
	277, 277, 292, 277, 290, 277, 278, 279, 
	289, 281, 43, 282, 283, 284, 277, 277, 
	277, 285, 277, 277, 286, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 287, 277, 358, 184, 359, 359, 
	81, 187, 188, 189, 357, 357, 357, 191, 
	357, 357, 194, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	196, 357, 184, 359, 359, 81, 187, 188, 
	189, 357, 357, 357, 191, 357, 357, 194, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 196, 357, 360, 
	357, 357, 357, 95, 361, 357, 187, 188, 
	189, 357, 357, 357, 362, 357, 360, 357, 
	363, 364, 365, 366, 81, 187, 188, 189, 
	357, 357, 112, 367, 357, 357, 194, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 196, 357, 368, 364, 
	369, 369, 81, 187, 188, 189, 357, 357, 
	357, 367, 357, 357, 194, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 196, 357, 364, 369, 369, 81, 
	187, 188, 189, 357, 357, 357, 367, 357, 
	357, 194, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 196, 
	357, 370, 357, 357, 357, 95, 371, 357, 
	187, 188, 189, 357, 357, 357, 362, 357, 
	370, 357, 372, 373, 374, 375, 81, 187, 
	188, 189, 357, 357, 110, 376, 357, 357, 
	194, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 196, 357, 
	377, 373, 378, 378, 81, 187, 188, 189, 
	357, 357, 357, 376, 357, 357, 194, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 196, 357, 373, 378, 
	378, 81, 187, 188, 189, 357, 357, 357, 
	376, 357, 357, 194, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 196, 357, 379, 357, 357, 357, 95, 
	380, 357, 187, 188, 189, 357, 357, 357, 
	362, 357, 379, 357, 381, 382, 383, 384, 
	81, 187, 188, 189, 357, 357, 108, 385, 
	357, 357, 194, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	196, 357, 386, 382, 387, 387, 81, 187, 
	188, 189, 357, 357, 357, 385, 357, 357, 
	194, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 196, 357, 
	382, 387, 387, 81, 187, 188, 189, 357, 
	357, 357, 385, 357, 357, 194, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 196, 357, 388, 357, 357, 
	357, 95, 389, 357, 187, 188, 189, 357, 
	357, 357, 362, 357, 388, 357, 390, 391, 
	392, 393, 81, 187, 188, 189, 357, 357, 
	106, 394, 357, 357, 194, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 196, 357, 395, 391, 396, 396, 
	81, 187, 188, 189, 357, 357, 357, 394, 
	357, 357, 194, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	196, 357, 391, 396, 396, 81, 187, 188, 
	189, 357, 357, 357, 394, 357, 357, 194, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 196, 357, 95, 
	397, 357, 187, 188, 189, 357, 357, 357, 
	362, 357, 187, 188, 189, 357, 357, 357, 
	362, 357, 398, 357, 357, 399, 188, 189, 
	357, 188, 189, 357, 400, 357, 188, 401, 
	357, 188, 402, 357, 188, 357, 398, 357, 
	357, 357, 188, 189, 357, 403, 357, 404, 
	405, 357, 187, 188, 189, 357, 357, 79, 
	357, 78, 357, 357, 357, 357, 187, 188, 
	189, 357, 187, 188, 189, 357, 403, 357, 
	357, 357, 357, 187, 188, 189, 357, 403, 
	357, 404, 357, 357, 187, 188, 189, 357, 
	357, 79, 357, 95, 357, 406, 406, 81, 
	187, 188, 189, 357, 357, 357, 362, 357, 
	407, 104, 408, 409, 85, 187, 188, 189, 
	357, 357, 357, 362, 357, 104, 408, 409, 
	85, 187, 188, 189, 357, 357, 357, 362, 
	357, 408, 408, 85, 187, 188, 189, 357, 
	357, 357, 362, 357, 410, 101, 411, 412, 
	88, 187, 188, 189, 357, 357, 357, 362, 
	357, 101, 411, 412, 88, 187, 188, 189, 
	357, 357, 357, 362, 357, 411, 411, 88, 
	187, 188, 189, 357, 357, 357, 362, 357, 
	413, 98, 414, 415, 91, 187, 188, 189, 
	357, 357, 357, 362, 357, 98, 414, 415, 
	91, 187, 188, 189, 357, 357, 357, 362, 
	357, 414, 414, 91, 187, 188, 189, 357, 
	357, 357, 362, 357, 416, 95, 357, 417, 
	357, 187, 188, 189, 357, 357, 357, 362, 
	357, 95, 357, 417, 357, 187, 188, 189, 
	357, 357, 357, 362, 357, 418, 357, 187, 
	188, 189, 357, 357, 357, 362, 357, 95, 
	357, 357, 357, 357, 187, 188, 189, 357, 
	357, 357, 362, 357, 77, 78, 357, 357, 
	95, 397, 357, 187, 188, 189, 357, 357, 
	357, 362, 357, 77, 357, 391, 396, 396, 
	81, 187, 188, 189, 357, 357, 357, 394, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	196, 357, 391, 396, 396, 81, 187, 188, 
	189, 357, 357, 357, 394, 357, 390, 391, 
	396, 396, 81, 187, 188, 189, 357, 357, 
	357, 394, 357, 357, 194, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 196, 357, 390, 391, 392, 396, 
	81, 187, 188, 189, 357, 357, 106, 394, 
	357, 357, 194, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	196, 357, 388, 357, 419, 357, 406, 406, 
	81, 187, 188, 189, 357, 357, 357, 362, 
	357, 388, 357, 388, 357, 357, 357, 357, 
	357, 357, 187, 188, 189, 357, 357, 357, 
	362, 357, 388, 357, 388, 357, 357, 357, 
	357, 420, 357, 187, 188, 189, 357, 357, 
	357, 362, 357, 388, 357, 388, 357, 419, 
	357, 357, 357, 357, 187, 188, 189, 357, 
	357, 357, 362, 357, 388, 357, 388, 78, 
	357, 357, 95, 389, 357, 187, 188, 189, 
	357, 357, 357, 362, 357, 388, 357, 381, 
	382, 387, 387, 81, 187, 188, 189, 357, 
	357, 357, 385, 357, 357, 194, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 196, 357, 381, 382, 383, 
	387, 81, 187, 188, 189, 357, 357, 108, 
	385, 357, 357, 194, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 196, 357, 379, 357, 421, 357, 406, 
	406, 81, 187, 188, 189, 357, 357, 357, 
	362, 357, 379, 357, 379, 357, 357, 357, 
	357, 357, 357, 187, 188, 189, 357, 357, 
	357, 362, 357, 379, 357, 379, 357, 357, 
	357, 357, 422, 357, 187, 188, 189, 357, 
	357, 357, 362, 357, 379, 357, 379, 357, 
	421, 357, 357, 357, 357, 187, 188, 189, 
	357, 357, 357, 362, 357, 379, 357, 379, 
	78, 357, 357, 95, 380, 357, 187, 188, 
	189, 357, 357, 357, 362, 357, 379, 357, 
	372, 373, 378, 378, 81, 187, 188, 189, 
	357, 357, 357, 376, 357, 357, 194, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 196, 357, 372, 373, 
	374, 378, 81, 187, 188, 189, 357, 357, 
	110, 376, 357, 357, 194, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 196, 357, 370, 357, 423, 357, 
	406, 406, 81, 187, 188, 189, 357, 357, 
	357, 362, 357, 370, 357, 370, 357, 357, 
	357, 357, 357, 357, 187, 188, 189, 357, 
	357, 357, 362, 357, 370, 357, 370, 357, 
	357, 357, 357, 424, 357, 187, 188, 189, 
	357, 357, 357, 362, 357, 370, 357, 370, 
	357, 423, 357, 357, 357, 357, 187, 188, 
	189, 357, 357, 357, 362, 357, 370, 357, 
	370, 78, 357, 357, 95, 371, 357, 187, 
	188, 189, 357, 357, 357, 362, 357, 370, 
	357, 363, 364, 369, 369, 81, 187, 188, 
	189, 357, 357, 357, 367, 357, 357, 194, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 196, 357, 363, 
	364, 365, 369, 81, 187, 188, 189, 357, 
	357, 112, 367, 357, 357, 194, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 196, 357, 360, 357, 425, 
	357, 406, 406, 81, 187, 188, 189, 357, 
	357, 357, 362, 357, 360, 357, 360, 357, 
	357, 357, 357, 357, 357, 187, 188, 189, 
	357, 357, 357, 362, 357, 360, 357, 360, 
	357, 357, 357, 357, 426, 357, 187, 188, 
	189, 357, 357, 357, 362, 357, 360, 357, 
	360, 357, 425, 357, 357, 357, 357, 187, 
	188, 189, 357, 357, 357, 362, 357, 360, 
	357, 360, 78, 357, 357, 95, 361, 357, 
	187, 188, 189, 357, 357, 357, 362, 357, 
	360, 357, 113, 80, 80, 81, 427, 427, 
	427, 427, 427, 152, 113, 427, 183, 184, 
	359, 359, 81, 187, 188, 189, 357, 357, 
	357, 191, 357, 357, 194, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 196, 357, 113, 80, 80, 81, 
	427, 427, 427, 427, 427, 427, 113, 427, 
	429, 430, 431, 432, 119, 433, 434, 435, 
	428, 428, 151, 436, 428, 428, 437, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 438, 428, 439, 430, 
	432, 432, 119, 433, 434, 435, 428, 428, 
	428, 436, 428, 428, 437, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 438, 428, 430, 432, 432, 119, 
	433, 434, 435, 428, 428, 428, 436, 428, 
	428, 437, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 438, 
	428, 440, 428, 428, 428, 132, 441, 428, 
	433, 434, 435, 428, 428, 428, 442, 428, 
	440, 428, 443, 444, 445, 446, 119, 433, 
	434, 435, 428, 428, 149, 447, 428, 428, 
	437, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 438, 428, 
	448, 444, 449, 449, 119, 433, 434, 435, 
	428, 428, 428, 447, 428, 428, 437, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 438, 428, 444, 449, 
	449, 119, 433, 434, 435, 428, 428, 428, 
	447, 428, 428, 437, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 438, 428, 450, 428, 428, 428, 132, 
	451, 428, 433, 434, 435, 428, 428, 428, 
	442, 428, 450, 428, 452, 453, 454, 455, 
	119, 433, 434, 435, 428, 428, 147, 456, 
	428, 428, 437, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	438, 428, 457, 453, 458, 458, 119, 433, 
	434, 435, 428, 428, 428, 456, 428, 428, 
	437, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 438, 428, 
	453, 458, 458, 119, 433, 434, 435, 428, 
	428, 428, 456, 428, 428, 437, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 438, 428, 459, 428, 428, 
	428, 132, 460, 428, 433, 434, 435, 428, 
	428, 428, 442, 428, 459, 428, 461, 462, 
	463, 464, 119, 433, 434, 435, 428, 428, 
	145, 465, 428, 428, 437, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 438, 428, 466, 462, 467, 467, 
	119, 433, 434, 435, 428, 428, 428, 465, 
	428, 428, 437, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	438, 428, 462, 467, 467, 119, 433, 434, 
	435, 428, 428, 428, 465, 428, 428, 437, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 438, 428, 468, 
	428, 428, 428, 132, 469, 428, 433, 434, 
	435, 428, 428, 428, 442, 428, 468, 428, 
	470, 471, 472, 473, 119, 433, 434, 435, 
	428, 428, 143, 474, 428, 428, 437, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 438, 428, 475, 471, 
	476, 476, 119, 433, 434, 435, 428, 428, 
	428, 474, 428, 428, 437, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 438, 428, 471, 476, 476, 119, 
	433, 434, 435, 428, 428, 428, 474, 428, 
	428, 437, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 438, 
	428, 132, 477, 428, 433, 434, 435, 428, 
	428, 428, 442, 428, 433, 434, 435, 428, 
	428, 428, 442, 428, 478, 428, 428, 479, 
	434, 435, 428, 434, 435, 428, 480, 428, 
	434, 481, 428, 434, 482, 428, 434, 428, 
	478, 428, 428, 428, 434, 435, 428, 483, 
	428, 484, 485, 428, 433, 434, 435, 428, 
	428, 117, 428, 116, 428, 428, 428, 428, 
	433, 434, 435, 428, 433, 434, 435, 428, 
	483, 428, 428, 428, 428, 433, 434, 435, 
	428, 483, 428, 484, 428, 428, 433, 434, 
	435, 428, 428, 117, 428, 132, 428, 486, 
	486, 119, 433, 434, 435, 428, 428, 428, 
	442, 428, 487, 141, 488, 489, 122, 433, 
	434, 435, 428, 428, 428, 442, 428, 141, 
	488, 489, 122, 433, 434, 435, 428, 428, 
	428, 442, 428, 488, 488, 122, 433, 434, 
	435, 428, 428, 428, 442, 428, 490, 138, 
	491, 492, 125, 433, 434, 435, 428, 428, 
	428, 442, 428, 138, 491, 492, 125, 433, 
	434, 435, 428, 428, 428, 442, 428, 491, 
	491, 125, 433, 434, 435, 428, 428, 428, 
	442, 428, 493, 135, 494, 495, 128, 433, 
	434, 435, 428, 428, 428, 442, 428, 135, 
	494, 495, 128, 433, 434, 435, 428, 428, 
	428, 442, 428, 494, 494, 128, 433, 434, 
	435, 428, 428, 428, 442, 428, 496, 132, 
	428, 497, 428, 433, 434, 435, 428, 428, 
	428, 442, 428, 132, 428, 497, 428, 433, 
	434, 435, 428, 428, 428, 442, 428, 498, 
	428, 433, 434, 435, 428, 428, 428, 442, 
	428, 132, 428, 428, 428, 428, 433, 434, 
	435, 428, 428, 428, 442, 428, 115, 116, 
	428, 428, 132, 477, 428, 433, 434, 435, 
	428, 428, 428, 442, 428, 115, 428, 471, 
	476, 476, 119, 433, 434, 435, 428, 428, 
	428, 474, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 438, 428, 471, 476, 476, 119, 
	433, 434, 435, 428, 428, 428, 474, 428, 
	470, 471, 476, 476, 119, 433, 434, 435, 
	428, 428, 428, 474, 428, 428, 437, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 438, 428, 470, 471, 
	472, 476, 119, 433, 434, 435, 428, 428, 
	143, 474, 428, 428, 437, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 438, 428, 468, 428, 499, 428, 
	486, 486, 119, 433, 434, 435, 428, 428, 
	428, 442, 428, 468, 428, 468, 428, 428, 
	428, 428, 428, 428, 433, 434, 435, 428, 
	428, 428, 442, 428, 468, 428, 468, 428, 
	428, 428, 428, 500, 428, 433, 434, 435, 
	428, 428, 428, 442, 428, 468, 428, 468, 
	428, 499, 428, 428, 428, 428, 433, 434, 
	435, 428, 428, 428, 442, 428, 468, 428, 
	468, 116, 428, 428, 132, 469, 428, 433, 
	434, 435, 428, 428, 428, 442, 428, 468, 
	428, 461, 462, 467, 467, 119, 433, 434, 
	435, 428, 428, 428, 465, 428, 428, 437, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 438, 428, 461, 
	462, 463, 467, 119, 433, 434, 435, 428, 
	428, 145, 465, 428, 428, 437, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 438, 428, 459, 428, 501, 
	428, 486, 486, 119, 433, 434, 435, 428, 
	428, 428, 442, 428, 459, 428, 459, 428, 
	428, 428, 428, 428, 428, 433, 434, 435, 
	428, 428, 428, 442, 428, 459, 428, 459, 
	428, 428, 428, 428, 502, 428, 433, 434, 
	435, 428, 428, 428, 442, 428, 459, 428, 
	459, 428, 501, 428, 428, 428, 428, 433, 
	434, 435, 428, 428, 428, 442, 428, 459, 
	428, 459, 116, 428, 428, 132, 460, 428, 
	433, 434, 435, 428, 428, 428, 442, 428, 
	459, 428, 452, 453, 458, 458, 119, 433, 
	434, 435, 428, 428, 428, 456, 428, 428, 
	437, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 438, 428, 
	452, 453, 454, 458, 119, 433, 434, 435, 
	428, 428, 147, 456, 428, 428, 437, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 438, 428, 450, 428, 
	503, 428, 486, 486, 119, 433, 434, 435, 
	428, 428, 428, 442, 428, 450, 428, 450, 
	428, 428, 428, 428, 428, 428, 433, 434, 
	435, 428, 428, 428, 442, 428, 450, 428, 
	450, 428, 428, 428, 428, 504, 428, 433, 
	434, 435, 428, 428, 428, 442, 428, 450, 
	428, 450, 428, 503, 428, 428, 428, 428, 
	433, 434, 435, 428, 428, 428, 442, 428, 
	450, 428, 450, 116, 428, 428, 132, 451, 
	428, 433, 434, 435, 428, 428, 428, 442, 
	428, 450, 428, 443, 444, 449, 449, 119, 
	433, 434, 435, 428, 428, 428, 447, 428, 
	428, 437, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 438, 
	428, 443, 444, 445, 449, 119, 433, 434, 
	435, 428, 428, 149, 447, 428, 428, 437, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 438, 428, 440, 
	428, 505, 428, 486, 486, 119, 433, 434, 
	435, 428, 428, 428, 442, 428, 440, 428, 
	440, 428, 428, 428, 428, 428, 428, 433, 
	434, 435, 428, 428, 428, 442, 428, 440, 
	428, 440, 428, 428, 428, 428, 506, 428, 
	433, 434, 435, 428, 428, 428, 442, 428, 
	440, 428, 440, 428, 505, 428, 428, 428, 
	428, 433, 434, 435, 428, 428, 428, 442, 
	428, 440, 428, 440, 116, 428, 428, 132, 
	441, 428, 433, 434, 435, 428, 428, 428, 
	442, 428, 440, 428, 429, 430, 432, 432, 
	119, 433, 434, 435, 428, 428, 428, 436, 
	428, 428, 437, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	438, 428, 181, 182, 183, 184, 507, 359, 
	81, 187, 188, 189, 190, 190, 152, 191, 
	357, 181, 194, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	196, 357, 198, 508, 200, 201, 5, 202, 
	203, 204, 197, 197, 37, 205, 197, 197, 
	206, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 207, 197, 
	210, 182, 183, 184, 509, 510, 81, 511, 
	512, 513, 197, 190, 152, 514, 197, 210, 
	194, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 196, 197, 
	113, 80, 80, 81, 202, 203, 204, 197, 
	197, 152, 515, 197, 516, 2, 357, 357, 
	357, 426, 357, 187, 188, 189, 357, 357, 
	357, 362, 357, 516, 357, 517, 364, 518, 
	519, 81, 511, 512, 513, 197, 197, 153, 
	367, 197, 197, 194, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 196, 197, 520, 364, 369, 369, 81, 
	511, 512, 513, 197, 197, 197, 367, 197, 
	197, 194, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 196, 
	197, 364, 369, 369, 81, 511, 512, 513, 
	197, 197, 197, 367, 197, 197, 194, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 196, 197, 521, 197, 
	197, 522, 512, 513, 197, 512, 513, 197, 
	250, 197, 512, 523, 197, 512, 524, 197, 
	512, 197, 521, 197, 197, 197, 512, 513, 
	197, 517, 364, 369, 369, 81, 511, 512, 
	513, 197, 197, 197, 367, 197, 197, 194, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 196, 197, 517, 
	364, 518, 369, 81, 511, 512, 513, 197, 
	197, 153, 367, 197, 197, 194, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 196, 197, 210, 197, 275, 
	113, 525, 525, 155, 202, 203, 204, 197, 
	197, 197, 515, 197, 210, 197, 526, 179, 
	527, 528, 157, 511, 512, 513, 197, 197, 
	197, 529, 197, 179, 527, 528, 157, 511, 
	512, 513, 197, 197, 197, 529, 197, 527, 
	527, 157, 511, 512, 513, 197, 197, 197, 
	529, 197, 530, 176, 531, 532, 160, 511, 
	512, 513, 197, 197, 197, 529, 197, 176, 
	531, 532, 160, 511, 512, 513, 197, 197, 
	197, 529, 197, 531, 531, 160, 511, 512, 
	513, 197, 197, 197, 529, 197, 533, 173, 
	534, 535, 163, 511, 512, 513, 197, 197, 
	197, 529, 197, 173, 534, 535, 163, 511, 
	512, 513, 197, 197, 197, 529, 197, 534, 
	534, 163, 511, 512, 513, 197, 197, 197, 
	529, 197, 536, 170, 197, 537, 197, 511, 
	512, 513, 197, 197, 197, 529, 197, 170, 
	197, 537, 197, 511, 512, 513, 197, 197, 
	197, 529, 197, 511, 512, 513, 197, 197, 
	197, 529, 197, 538, 197, 539, 540, 197, 
	511, 512, 513, 197, 197, 167, 197, 166, 
	197, 197, 197, 197, 511, 512, 513, 197, 
	511, 512, 513, 197, 538, 197, 197, 197, 
	197, 511, 512, 513, 197, 538, 197, 539, 
	197, 197, 511, 512, 513, 197, 197, 167, 
	197, 516, 166, 357, 357, 95, 361, 357, 
	187, 188, 189, 357, 357, 357, 362, 357, 
	516, 357, 542, 541, 541, 541, 541, 543, 
	544, 545, 541, 543, 544, 545, 541, 546, 
	541, 541, 547, 544, 545, 541, 544, 545, 
	541, 548, 541, 544, 549, 541, 544, 550, 
	541, 544, 541, 546, 541, 541, 541, 544, 
	545, 541, 0
};

static const short _indic_syllable_machine_trans_targs[] = {
	170, 199, 201, 202, 3, 205, 4, 6, 
	208, 7, 9, 211, 10, 12, 214, 13, 
	15, 16, 191, 18, 19, 213, 21, 22, 
	210, 24, 25, 207, 216, 221, 225, 228, 
	232, 235, 239, 242, 246, 249, 170, 279, 
	281, 282, 39, 285, 40, 42, 288, 43, 
	45, 291, 46, 48, 294, 49, 51, 52, 
	271, 54, 55, 293, 57, 58, 290, 60, 
	61, 287, 296, 301, 305, 308, 312, 315, 
	319, 322, 326, 330, 170, 358, 360, 361, 
	75, 364, 170, 76, 78, 367, 79, 81, 
	370, 82, 84, 373, 85, 87, 88, 350, 
	90, 91, 372, 93, 94, 369, 96, 97, 
	366, 375, 380, 384, 387, 391, 394, 398, 
	401, 405, 170, 439, 441, 442, 110, 445, 
	111, 113, 448, 114, 116, 451, 117, 119, 
	454, 120, 122, 123, 431, 125, 126, 453, 
	128, 129, 450, 131, 132, 447, 456, 461, 
	465, 468, 472, 475, 479, 482, 486, 489, 
	409, 505, 146, 508, 148, 511, 149, 151, 
	514, 152, 154, 517, 155, 520, 522, 523, 
	159, 160, 519, 162, 163, 516, 165, 166, 
	513, 168, 169, 510, 170, 171, 251, 331, 
	333, 408, 410, 351, 353, 354, 411, 407, 
	490, 491, 378, 526, 379, 170, 172, 174, 
	35, 250, 192, 194, 195, 248, 219, 220, 
	173, 34, 175, 244, 0, 176, 178, 33, 
	243, 241, 177, 32, 179, 237, 180, 182, 
	31, 236, 234, 181, 30, 183, 230, 184, 
	186, 29, 229, 227, 185, 28, 187, 223, 
	188, 190, 27, 222, 218, 189, 26, 204, 
	193, 198, 170, 196, 197, 200, 1, 203, 
	2, 206, 5, 23, 209, 8, 20, 212, 
	11, 17, 215, 14, 217, 224, 226, 231, 
	233, 238, 240, 245, 247, 170, 252, 254, 
	71, 328, 272, 274, 275, 329, 299, 300, 
	253, 70, 255, 324, 36, 256, 258, 69, 
	323, 321, 257, 68, 259, 317, 260, 262, 
	67, 316, 314, 261, 66, 263, 310, 264, 
	266, 65, 309, 307, 265, 64, 267, 303, 
	268, 270, 63, 302, 298, 269, 62, 284, 
	273, 278, 170, 276, 277, 280, 37, 283, 
	38, 286, 41, 59, 289, 44, 56, 292, 
	47, 53, 295, 50, 297, 304, 306, 311, 
	313, 318, 320, 325, 327, 170, 332, 106, 
	334, 403, 72, 335, 337, 105, 402, 400, 
	336, 104, 338, 396, 339, 341, 103, 395, 
	393, 340, 102, 342, 389, 343, 345, 101, 
	388, 386, 344, 100, 346, 382, 347, 349, 
	99, 381, 377, 348, 98, 363, 352, 357, 
	170, 355, 356, 359, 73, 362, 74, 365, 
	77, 95, 368, 80, 92, 371, 83, 89, 
	374, 86, 376, 383, 385, 390, 392, 397, 
	399, 404, 406, 170, 170, 412, 414, 142, 
	141, 432, 434, 435, 488, 459, 460, 413, 
	415, 484, 107, 416, 418, 140, 483, 481, 
	417, 139, 419, 477, 420, 422, 138, 476, 
	474, 421, 137, 423, 470, 424, 426, 136, 
	469, 467, 425, 135, 427, 463, 428, 430, 
	134, 462, 458, 429, 133, 444, 433, 438, 
	170, 436, 437, 440, 108, 443, 109, 446, 
	112, 130, 449, 115, 127, 452, 118, 124, 
	455, 121, 457, 464, 466, 471, 473, 478, 
	480, 485, 487, 143, 492, 493, 507, 498, 
	500, 501, 525, 494, 495, 496, 144, 506, 
	497, 499, 504, 502, 503, 145, 509, 147, 
	167, 156, 512, 150, 164, 515, 153, 161, 
	518, 158, 521, 157, 524, 170, 527, 528, 
	530, 531, 529, 534, 170, 532, 533
};

static const char _indic_syllable_machine_trans_actions[] = {
	1, 2, 0, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 4, 2, 0, 0, 
	0, 2, 5, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 2, 6, 2, 6, 2, 6, 2, 
	6, 2, 7, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	6, 8, 0, 2, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 2, 0, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 11, 2, 2, 6, 
	2, 12, 12, 0, 0, 0, 2, 2, 
	6, 2, 6, 0, 6, 13, 2, 2, 
	0, 2, 0, 0, 0, 2, 2, 2, 
	2, 0, 2, 2, 0, 2, 2, 0, 
	2, 2, 2, 0, 2, 2, 2, 2, 
	0, 2, 2, 2, 0, 2, 2, 2, 
	2, 0, 2, 2, 2, 0, 2, 2, 
	2, 2, 0, 2, 2, 2, 0, 2, 
	0, 0, 14, 0, 0, 0, 0, 2, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 15, 2, 2, 
	0, 2, 0, 0, 0, 2, 2, 2, 
	2, 0, 2, 2, 0, 2, 2, 0, 
	2, 2, 2, 0, 2, 2, 2, 2, 
	0, 2, 2, 2, 0, 2, 2, 2, 
	2, 0, 2, 2, 2, 0, 2, 2, 
	2, 2, 0, 2, 2, 2, 0, 2, 
	0, 0, 16, 0, 0, 0, 0, 2, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 17, 6, 0, 
	6, 6, 0, 6, 2, 0, 6, 2, 
	6, 0, 6, 6, 6, 2, 0, 6, 
	2, 6, 0, 6, 6, 6, 2, 0, 
	6, 2, 6, 0, 6, 6, 6, 2, 
	0, 6, 2, 6, 0, 6, 0, 0, 
	18, 0, 0, 0, 0, 2, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 19, 20, 2, 2, 0, 
	0, 0, 0, 0, 2, 2, 2, 2, 
	2, 2, 0, 2, 2, 0, 2, 2, 
	2, 0, 2, 2, 2, 2, 0, 2, 
	2, 2, 0, 2, 2, 2, 2, 0, 
	2, 2, 2, 0, 2, 2, 2, 2, 
	0, 2, 2, 2, 0, 2, 0, 0, 
	21, 0, 0, 0, 0, 2, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 0, 0, 8, 2, 0, 
	0, 0, 2, 2, 8, 8, 0, 8, 
	8, 0, 0, 0, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 0, 2, 22, 0, 0, 
	0, 0, 0, 0, 23, 0, 0
};

static const char _indic_syllable_machine_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 9, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0
};

static const char _indic_syllable_machine_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 10, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0
};

static const short _indic_syllable_machine_eof_trans[] = {
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	77, 77, 77, 83, 83, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	83, 77, 77, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 77, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 0, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	428, 358, 428, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 358, 198, 198, 198, 358, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 358, 542, 542, 
	542, 542, 542, 542, 542, 542, 542
};

static const int indic_syllable_machine_start = 170;
static const int indic_syllable_machine_first_final = 170;
static const int indic_syllable_machine_error = -1;

static const int indic_syllable_machine_en_main = 170;


#line 36 "../../src/hb-ot-shape-complex-indic-machine.rl"



#line 97 "../../src/hb-ot-shape-complex-indic-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %d..%d %s\n", last, p+1, #syllable_type); \
    for (unsigned int i = last; i < p+1; i++) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    last = p+1; \
    syllable_serial++; \
    if (unlikely (syllable_serial == 16)) syllable_serial = 1; \
  } HB_STMT_END

static void
find_syllables (hb_buffer_t *buffer)
{
  unsigned int p, pe, eof, ts HB_UNUSED, te HB_UNUSED, act HB_UNUSED;
  int cs;
  hb_glyph_info_t *info = buffer->info;
  
#line 1554 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	{
	cs = indic_syllable_machine_start;
	ts = 0;
	te = 0;
	act = 0;
	}

#line 118 "../../src/hb-ot-shape-complex-indic-machine.rl"


  p = 0;
  pe = eof = buffer->len;

  unsigned int last = 0;
  unsigned int syllable_serial = 1;
  
#line 1571 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	{
	int _slen;
	int _trans;
	const unsigned char *_keys;
	const short *_inds;
	if ( p == pe )
		goto _test_eof;
_resume:
	switch ( _indic_syllable_machine_from_state_actions[cs] ) {
	case 10:
#line 1 "NONE"
	{ts = p;}
	break;
#line 1585 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	}

	_keys = _indic_syllable_machine_trans_keys + (cs<<1);
	_inds = _indic_syllable_machine_indicies + _indic_syllable_machine_index_offsets[cs];

	_slen = _indic_syllable_machine_key_spans[cs];
	_trans = _inds[ _slen > 0 && _keys[0] <=( info[p].indic_category()) &&
		( info[p].indic_category()) <= _keys[1] ?
		( info[p].indic_category()) - _keys[0] : _slen ];

_eof_trans:
	cs = _indic_syllable_machine_trans_targs[_trans];

	if ( _indic_syllable_machine_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _indic_syllable_machine_trans_actions[_trans] ) {
	case 2:
#line 1 "NONE"
	{te = p+1;}
	break;
	case 14:
#line 88 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (consonant_syllable); }}
	break;
	case 16:
#line 89 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (vowel_syllable); }}
	break;
	case 21:
#line 90 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (standalone_cluster); }}
	break;
	case 23:
#line 91 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (symbol_cluster); }}
	break;
	case 18:
#line 92 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (broken_cluster); }}
	break;
	case 11:
#line 93 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (non_indic_cluster); }}
	break;
	case 13:
#line 88 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (consonant_syllable); }}
	break;
	case 15:
#line 89 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (vowel_syllable); }}
	break;
	case 20:
#line 90 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (standalone_cluster); }}
	break;
	case 22:
#line 91 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (symbol_cluster); }}
	break;
	case 17:
#line 92 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (broken_cluster); }}
	break;
	case 19:
#line 93 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (non_indic_cluster); }}
	break;
	case 1:
#line 88 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (consonant_syllable); }}
	break;
	case 3:
#line 89 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (vowel_syllable); }}
	break;
	case 7:
#line 90 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (standalone_cluster); }}
	break;
	case 4:
#line 92 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (broken_cluster); }}
	break;
	case 5:
#line 1 "NONE"
	{	switch( act ) {
	case 1:
	{{p = ((te))-1;} found_syllable (consonant_syllable); }
	break;
	case 5:
	{{p = ((te))-1;} found_syllable (broken_cluster); }
	break;
	case 6:
	{{p = ((te))-1;} found_syllable (non_indic_cluster); }
	break;
	}
	}
	break;
	case 8:
#line 1 "NONE"
	{te = p+1;}
#line 88 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{act = 1;}
	break;
	case 6:
#line 1 "NONE"
	{te = p+1;}
#line 92 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{act = 5;}
	break;
	case 12:
#line 1 "NONE"
	{te = p+1;}
#line 93 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{act = 6;}
	break;
#line 1704 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	}

_again:
	switch ( _indic_syllable_machine_to_state_actions[cs] ) {
	case 9:
#line 1 "NONE"
	{ts = 0;}
	break;
#line 1713 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	}

	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	if ( _indic_syllable_machine_eof_trans[cs] > 0 ) {
		_trans = _indic_syllable_machine_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	}

#line 127 "../../src/hb-ot-shape-complex-indic-machine.rl"

}

#endif /* HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH */
