/*Copyright (c) 1993-1994 Xerox Corporation.  All Rights Reserved.

  Permission to use, copy, modify  and  distribute  without  charge
  this  software,  documentation, images, etc. is granted, provided
  that this copyright and the author's name is retained.

  A fee may be charged for this program ONLY to recover  costs  for
  distribution  (i.e.  media costs).  No profit can be made on this
  program.

  The author assumes no responsibility for  disasters  (natural  or
  otherwise) as a consequence of use of this software.

  Adam Stein (adam@iset.scan.mc.xerox.com)
*/

#include <stdio.h>
#include <X11/Xlib.h>
#include "xtoolplaces.h"

int aindex;
char *missing_list[50];
extern char *missing,*program;

/*This function will read in the list of X applications that don't set
  WM_COMMAND and need to be saved.

  Inputs:  none
  Outputs: none
  Locals:  fp           - file pointer to read from
           line         - line of text read in
  Globals: aindex       - index into name list
           missing      - name of file containing X applications
           missing_list - list of X applications that don't set WM_COMMAND
           program      - name of currently executing program
           stderr       - standard error
           NULL         - 0
*/
read_missing()
{
        char line[200];
        FILE *fp;

        /*Open the file for reading*/
        if((fp = fopen(missing,"r")) == NULL) {
          fprintf(stderr,"%s: can't open {%s}\n",program,missing);
          exit(1);
        }

        aindex = 0;

        /*Read lines from file until there is no more*/
        while(fgets(line,200,fp) != NULL)
          switch(line[0]) {
            case '#':                   /*Comment character - ignore line*/
            case '\n':                  /*Blank line - ignore line*/
                        break;
            default:
                        line[strlen(line)-1] = '\0';  /*Take out NL char*/
                        if((missing_list[aindex++] = strdup(line)) == NULL) {
                          perror(program);
                          exit(1);
                        }

                        break;
          }
}

/*This function will determine if an application's window is on the missing
  applications list.  A 1 is returned if on the list, 0 if not.

  Inputs:  window       - ID of the window that we are going to check
  Outputs: result       - 1 if application is on the list, 0 if not
  Locals:  loop         - loop through name list
           name         - name of window
           result       - flag indicating if window is on list or not
  Globals: aindex       - number of entries in the name list
           missing      - name of file containing X applications
           missing_list - list of X applications that don't set WM_COMMAND
*/
on_list(window)
Window window;
{
        int loop,result;
        char *name;
        char *getname();

        result = 0;

        /*Check name list if '-m' was given*/
        if(missing)
          if(name = getname(window)) {
            for(loop = 0;!result && (loop < aindex);++loop)
              if(!strcmp(name,missing_list[loop])) result = 1;

            XFree(name);
          }

        return(result);
}

