;{{{ module LOADING

(module loading
	(export
	 (load-silent file)
	 (require-library lib file)

	 (loading-verbosity . level)	; HACK to not import that variable

	 (v-load lib dest type)		; OBSOLETE
	 )
	(import
	 (memoize control "control.scm")
	 (files "files.scm")		; too much imported, bigloo doesn't
	                         ; like (path-find-files files "files.scm")

	 (message typeset "typeset.scm")
	 ))

;}}}
;{{{ Verbosity

(define *verbosely* 1)

(define (loading-verbosity . level)
  (if (pair? level)
      (set! *verbosely* (car level)))
  *verbosely*)

;}}}
;{{{ loading files at run time

(define (load-silent file)
  (with-output-to-file "/dev/null" (lambda () (load file))))

(define (load-*verbosely* fn)
  (if (> *verbosely* 2)
      (load fn)
      (load-silent fn)))

(define (load-library-*verbosely* lib file)
  (let ((fn (path-find-file lib file)))
    (if fn
	(load-*verbosely* fn)
	(begin (message 0 "No file in load path for " file)
	       #f))))

;}}}
;{{{ require-load

; Load a file from the *typeset-lib* path into mem
; RETURN:     what a load would have
; PARAMETER:  *verbosely*, level of verbosity
; ASIDE:      Memoize values; don't load it twice!

(define require-library-cache		; internal
					; bigloo allows reassign to
					; variables like that but not
					; to functions like the next
  (memoize
   (lambda (lib fn) (load-library-*verbosely* lib fn))
   (lambda (x y) #t)			; ignore lib path; HACK
   equal?))

(define (require-library lib file)
  (require-library-cache lib file))

;}}}
;{{{ v-load (OBSOLETE)

; load from lib/dest/type silent or not depending on *verbosely*

(define (v-load lib dest type)
  (let* ((fn (apply string-append 
	      (if (not (equal? dest "")) `(,dest "/" ,type ".scm")
	      `(type ".scm")))))
    (load-library-*verbosely* lib fn)))

;}}}
