/*
 * upsnet.c - Network support for the apcd daemon
 *
 * Copyright (c) 1995 Pavel Korensky
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL PAVEL KORENSKY BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF PAVEL
 * KORENSKY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * PAVEL KORENSKY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND PAVEL KORENSKY HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

/*	
 * Version:
 *	
 * $Id: upsnet.c,v 1.1 1995/11/07 12:41:07 root Exp root $
 *	
 *	
 * History:
 *	
 * $Log: upsnet.c,v $
 * Revision 1.1  1995/11/07  12:41:07  root
 * Initial revision
 *
 *	
 */	


#include "apcd.h"
#include "version.h"

#ifndef lint
static char *version="$Id: upsnet.c,v 1.1 1995/11/07 12:41:07 root Exp root $";
#endif

int		slavesocket[MAX_SLAVES];
struct sockaddr_in	slave_adr[MAX_SLAVES];

int prepare_slave()	/* Bind socket, fill adress */
{				      
	struct	sockaddr_in	my_adr;
	int	masterlen;
	struct	sockaddr_in	master_adr;
	struct	hostent		*mastent;
	int			c,i;

	bzero ((char *) &my_adr, sizeof(my_adr));
	my_adr.sin_family = AF_INET;
	my_adr.sin_addr.s_addr = htonl(INADDR_ANY);
	my_adr.sin_port = htons(UPS_TCP_PORT);
	if(bind(socketfd, (struct sockaddr *) &my_adr, sizeof(my_adr)) < 0) {
		syslog(LOG_ERR,"Can't bind local address");
		return(-1);
	}


	i = 1;
	c = 0;
	while((c == 0) && (i<=10)) {
		listen(socketfd, 1);
		masterlen = sizeof(master_adr);
		newsocketfd = accept(socketfd, (struct sockaddr *) &master_adr, &masterlen);
		if (newsocketfd < 0) {
			syslog(LOG_ERR,"Accept error %d try %d error",i,errno);
			i++;
		}
		else c = 1;
	}
	if (c == 0) return (-1);
	if ((mastent = gethostbyname(master_name)) == NULL) {
		syslog(LOG_ERR,"Can't resolve master name %s",master_name);
		return(-1);
	}

	/* Let's add some basic security */

	if (memcmp((void *) &master_adr.sin_addr,(void *)mastent->h_addr,sizeof(struct in_addr)) != 0) {
		syslog(LOG_ERR,"Unauthorised attempt from %s",inet_ntoa(master_adr.sin_addr));
		return(-1);
	}
	return(0);	
}
		
 
int get_master_message(int sfd)            /* Get data from master */
{
	int	i,j,t;
	char	c;
	char	line[MAXLINE];

	j=0;
	for(j=0;j<MAXLINE;j++) {
		if((i = read(sfd, &c, 1)) == 1) {
			line[j] = c;
			if (c == '\n') break;
		}
		else break;
	}
	if (line[0] == UPS_ON_LINE) {
		gotpowerok = 1;
		return(0);
	}
	if (line[0] == BATT_LOW) {
		masterbatlow = 1;
		return(0);
	}
	if(sscanf(line,"%d",&t) != 1) {
		gottimeout = 0;
		return (-1);
	}
	gottimeout = 1;
	mastertimeout = (t / 60) - 1;	/* One minute before master */
	return(0);
}

int send_to_slaves(int what)		  /* Make call to all my slaves */
{
	int	i;

	for (i=0;i<num_slaves;i++) send_info(i,what);
	return(0);
}

int prepare_master()
{
	struct hostent		*slavent;
	int			i,j,c;

	for(i=0;i<num_slaves;i++) {
		if ((slavent = gethostbyname(slaves[i])) == NULL) {
			syslog(LOG_ERR,"Can't resolve slave name %s",slaves[i]);
		}
		else {
			c = 0;
			j = 1;
			while((c == 0) && (j<=30)) {
				if((slavesocket[i] = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
					syslog(LOG_ERR,"Can't allocate socket");
					return (-1);
				}
				bzero ((char *) &slave_adr[i], sizeof(slave_adr[i]));
				slave_adr[i].sin_family = AF_INET;
				memcpy((void *)&slave_adr[i].sin_addr,(void *)slavent->h_addr,sizeof(struct in_addr));
				slave_adr[i].sin_port = htons(UPS_TCP_PORT);
				if(connect(slavesocket[i], (struct sockaddr *) &slave_adr[i], sizeof(slave_adr[i])) < 0) {
					syslog(LOG_INFO,"Can't connect to slave %s %d try",slaves[i],j);
					close(slavesocket[i]);
					sleep(10);
					j++;
				}
				else c=1;
			}
#ifdef DEBUGGING
			if (c == 1) syslog(LOG_INFO,"Connected to slave %s",slaves[i]);
#endif
		}
	}
	return(0);
}


int send_info(int slave, int what)	/* Send the data to the slave */
{
	char			c;
	char			time[10];

	if (what == -1) {
		c = UPS_ON_LINE;
		if(write(slavesocket[slave],&c,1) != 1) {
			syslog(LOG_ERR,"Can't write to socket");
			return(-1);
		}
#ifdef DEBUGGING
		syslog(LOG_INFO,"Sent UPS_ON_LINE");
#endif
	}
	if (what == -2) {
		c = BATT_LOW;
		if(write(slavesocket[slave],&c,1) != 1) {
			syslog(LOG_ERR,"Can't write to socket");
			return(-1);
		}
#ifdef DEBUGGING
		syslog(LOG_INFO,"Sent BATT_LOW");
#endif
	}
	if (what >=0) {
		sprintf(time,"%d",what);
		if(write(slavesocket[slave],&time,strlen(time)) != strlen(time)) {
			syslog(LOG_ERR,"Can't write to socket");
			return(-1);
		}
#ifdef DEBUGGING
		syslog(LOG_INFO,"Sent timeout %d",what);
#endif
	}
	c = '\n';
	if(write(slavesocket[slave],&c,1) != 1) {
		syslog(LOG_ERR,"Can't write to socket");
		return(-1);
	}
#ifdef DEBUGGING
	syslog(LOG_INFO,"Sent EOL");
#endif		
	return(0);
}





		
		
			

