#!	/bin/sh
# Boot Disk maker. Bruce Perens, July-September 1995
#                  Enrique Zanardi, January 1998
# This is free software under the GNU General Public License.

# Abort on any non-zero return.
set -e

# Verbose shell execution.
#set -x
#set -v

# Print a usage message and exit if the argument count is wrong.
if [ $# -ne 5 ]; then
echo "Usage: $0 revision-extension blocks modules-archive modcont-file modconf-debfile" 1>&2
	cat 1>&2 << EOF

	revision-extension: the revision extension of the kernel.
	blocks: the size of the floppy in 1K blocks, use 720, 1200, or 1440
	modules-archive: tgz containing the modules
	modcont-file: text file containing the list of modules in each subdir
		(generated by kernel.sh)
	archive: the directory containing the Debian binary packages.

EOF

	exit -1
fi

floppy=/var/tmp/floppy-image.$$

mnt=/var/tmp/mnt.$$

revext="$1"

blocks=$2

modules=$3

modcont=$4

archive=$5

# Find the target architecture
arch="`dpkg --print-architecture`"

# Make sure the required files are there.
if [ ! -f $modules ]; then
        echo "Can't find $modules" 1>&2
        exit -1
fi
if [ ! -f $modcont ]; then
        echo "Can't find $modcont" 1>&2
        exit -1
fi
if [ ! -d $archive ]; then
	echo "Can't find $archive" 1>&2
	exit -1
fi


. common.sh

# Try to unmount anything that should not be mounted. Aborted runs of this
# script may have left things mounted.
(umount $mnt; umount $floppy; true)2>/dev/null >/dev/null

mkdir -p $mnt

# Zero the entire disk, so that if I compress the raw disk image,
# unused blocks will compress well.
dd if=/dev/zero of=$floppy bs=1k count=$blocks

# Make the filesystem.
if [ $arch = sparc ]; then
	# sparc uses ext2 formatted floppies
	mke2fs -F $floppy $blocks
	# mount the disk
	mount -t ext2 -o loop $floppy $mnt
else
	/sbin/mkdosfs -r 16 -F 12 -n drivers -m scripts/drivers/boot.txt $floppy $blocks
	# mount the disk
	mount -t msdos -o loop -o fat=12 $floppy $mnt
fi

# Temporary directories
E=/var/tmp/extract-tmp-$$

exit=false

# luisgh: Added pcmcia-cs to the packages.
PACKAGE_PATH=`make_paths modconf`
if [ $arch = i386 ]; then
	PACKAGE_PATH="$PACKAGE_PATH `make_paths pcmcia-cs`"
fi

if $exit; then
	exit -1
fi

if [ -d $E ]; then
        mv -f $E $E.old
        rm -f -r $E.old &
fi
mkdir -p -m 755 $E

for i in $PACKAGE_PATH; do
        echo Extracting $i 1>&2
        dpkg-deb --extract $i $E
done

# luisgh: Added the pcmcia stuff
#         We'll remove the files that we'll configure.
#         By touching them we avoid cardmgr failures before a certain file
#         is configured. This way cardmgr can be started even if a necessary
#         file is not yet there.
# update: We won't remove the files, to provide a default configuration
#	  to users that aren't configuring things at install-time.
if [ "$arch" = "i386" ]; then
#	rm $E/etc/pcmcia/serial.opts
#	rm $E/etc/pcmcia/cdrom.opts
#	rm $E/etc/pcmcia/network.opts
#	touch $E/etc/pcmcia/serial.opts
#	touch $E/etc/pcmcia/cdrom.opts
#	touch $E/etc/pcmcia/network.opts
	(cd $E && tar -cf pcmcia.tar etc/* )
	gzip $E/pcmcia.tar
	cp $E/pcmcia.tar.gz $mnt/pcmcia.tgz
fi
cp $E/usr/sbin/modconf $mnt/modconf
cp $E/usr/lib/module_help/eval $mnt/

# Kludge to include additional descriptions that are not in modconf*.deb
# yet.
cp scripts/drivers/descr.additional $mnt/descr
zcat $E/usr/lib/module_help/descr.gz >>$mnt/descr
gzip -9f $mnt/descr

rm -f -r $E &

cp $modules $mnt/modules.tgz
cp $modcont $mnt/modcont

cp scripts/drivers/install.sh $mnt/install.sh
chmod 777 $mnt/install.sh
#echo ${revext}"drivers">$mnt/type.txt
echo drivers>$mnt/type.txt

umount $mnt
rmdir $mnt

mv $floppy drv${blocks}${revext}.bin
ls -l drv${blocks}${revext}.bin
exit 0
