#ifndef _DINSTALL_H_
#define _DINSTALL_H_

#define KERDISKIMG	"resc1440.bin"
#define DRVDISKIMG	"drv1440.bin"
#define BASETGZ		"base2_0.tgz"
#define KERDISKIMG_TECRA	"resc1440tecra.bin"
#define DRVDISKIMG_TECRA	"drv1440tecra.bin"

#define  CLEAR "[H[J"

#include <string.h>

#ifdef TEST

char foolbuf[1024];

#define T_FILE(name) strcat(strcpy(foolbuf,"./test-root"),name)

#else

#define T_FILE(name) name

#endif /*TEST*/

#ifdef LOG
#include <stdarg.h>
void dinstall_log(const char * pattern, ...);
#endif	

#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/stat.h>
#include "../libfdisk/fdisk.h"

#define NAME_ISDIR(name,statbuf) \
	( (! stat(name,statbuf) ) && S_ISDIR((statbuf)->st_mode) )
#define NAME_ISREG(name,statbuf) \
	( (! stat(name,statbuf) ) && S_ISREG((statbuf)->st_mode) )
#define NAME_ISEXE(name,statbuf) \
	( (! stat(name,statbuf) ) && S_ISREG((statbuf)->st_mode) && \
	  ( S_IXUSR & (statbuf)->st_mode ) )
 
int no_match(const char *path, const char *name, __mode_t mode);

#define DLG_ERROR               -1
#define DLG_OKAY                0
#define DLG_CANCEL              1

struct d_choices
 {
   char* tag;
   char* string;
   int   state;
};

struct BootArgs {
  char *root;
  int istecra;
} bootargs;

enum extract_type { kernel, base } disqtype;

#define PRTBUFSIZE 2048
char prtbuf[PRTBUFSIZE];
char *InstallationRootDevice,*Archive_Dir; 
struct fdisk_partition *Root;
int noSwap, notCreatedBootFloppy, notInstalledLILO;
#if #cpu (m68k)
  char *Arch2;
#endif

struct fdisk_partition *
    select_not_mounted(const char *message, const char *title, int ntypes, ...);

int pleaseWaitBox(const char *text);
int problemBox(const char *text, const char *title);
int perrorBox(const char *text);
int twoButtonBox(const char *text, const char *title, const char *button1, const char* button2);
int yesNoBox(const char *text, const char *title);
char *inputBox(const char *text, const char *title, const char *proto);
int choice_box(const char* text, const char* title, int height, int width,
               struct d_choices* choices, int nchoices, int *selected);
int menus(const char* text, const char* title,struct d_choices* choices,int nchoices);
int check_box(const char* text, const char* title, int height, int width,
            char** choices, char** values, int nchoices);


int addtolist(char **list, const char *element);
int mount_and_check_floppy (char *device, const char *type, const char *text);
int choose_medium(void);
int getFloppies(const char * device, const char * filename);

int color_or_monochrome(void);
int release_notes(void);
int is_root_a_floppy (void);
int main_menu (void);
int partition_disk (void);
int init_swap (void);
int init_linux (void);
int no_swap (void);
int mount_any (void);
int unmount_any (void);
int activate_swap (void);
int configure_keyboard (void);
int extract_kernel_and_modules (void);
int extract_base (void);
int view_partitions (void);
int interactive_shell (void);
int reboot_system (void);
int configure_drivers (void);
int configure_base (void);
int make_bootable (void);
int make_boot_floppy (void);
int configure_network (void);
int configure_pcmcia (void);

#if #cpu (sparc)
# define SERIAL_CONSOLE
# define DO_EJECT
void eject_floppy(const char *device);
int do_eject (void);
#else
# define eject_floppy(device)	/* nada */
#endif

#endif
