#include <string.h>
#include <stdio.h>
#include "dinstall.h"
#include <newt.h>
#include "../busybox/internal.h"
#include "lang.h"

static int extract_from_file (const char *fil, const char *descr) {
  int status;
  sprintf(prtbuf,MSG_BEING_EXTRACTED,descr,fil);
  pleaseWaitBox(prtbuf);
  chdir("/target");
  sprintf(prtbuf,"zcat < %s | star",fil);
  status=system(prtbuf);
  chdir("/");
  newtPopWindow();
  if (status) {
    sprintf(prtbuf,MSG_PROBLEM_EXTRACTING,descr,fil);
    problemBox(prtbuf,MSG_FILE_ERROR);
    return 1;
  }
  return 0;
}

static int extract_from_floppy (const char *device, const char *file,
  const char *descr) {
  int status;
  struct stat statbuf;
  const char tmpdir[]="/target/tmp";

  if (NAME_ISREG(T_FILE(file),&statbuf)) {
    unlink(file);
  }
  if (! NAME_ISDIR( T_FILE(tmpdir), &statbuf ) ) {
    struct FileInfo finfo;
    finfo.source = T_FILE(tmpdir);
    finfo.orWithMode = strtol("1777", 0, 010);
    finfo.makeParentDirectories = 1;
    if (! mkdir_fn(&finfo)) {
      chown(finfo.source, 0, 3); /* root_uid= 0 , sys_gid= 3 */
    }
  }
  status=getFloppies(device,file);
  if ( status == 0) {
    status=extract_from_file(file,descr);
  } else {
    sprintf(prtbuf,MSG_PROBLEM_READING,descr,device); 
    problemBox(prtbuf,MSG_FLOPPY_ERROR);
  }
  if (NAME_ISREG(T_FILE(file),&statbuf)) {
    unlink(file);
  }
  return (status);
}

int extract_base (void) {
  int status;
  struct stat statbuf;
  char *file;

  disqtype=base;
  if ( choose_medium() ) return 1;

  if (strncmp(Archive_Dir,"/dev/fd",7)) {
    sprintf(prtbuf,"%s/%s",Archive_Dir,BASETGZ);
    file=strdup(prtbuf);
    status=extract_from_file(file,MSG_BASE_SYSTEM);
    free(file);
    do_umount("/instmnt",0);
  } else {
    status=extract_from_floppy(Archive_Dir,"/target/" BASETGZ,MSG_BASE_SYSTEM);
  }
/*  free(Archive_Dir); */
/*  Archive_Dir=NULL; */
  if (status) return 1;

  if (NAME_ISREG(T_FILE("/target/etc/inittab"),&statbuf)) {
    rename(T_FILE("/target/etc/inittab"),T_FILE("/target/etc/inittab.real"));
  }
  sprintf(prtbuf,"cp %s %s",T_FILE("/etc/init_tab"),
    T_FILE("/target/etc/inittab")); 
  system(prtbuf);

  sync();
  return 0;
}
