# List-processing functions for the shell.

# Exclude the members of the first from the second list. Write the result
# to stdout.
exclude () {
	local exclude="$1"
	local members="$2"
	local result=""

	if [ -z "$members" ]; then
		return 0
	fi
	if [ -z "$exclude" ]; then
		echo "$members"
		return 0
	fi

	for m in $members; do
		local add_to_set=1
		for e in $exclude; do
			if [ $m = $e ]; then
				add_to_set=0
				break
			fi
		done
		if [ $add_to_set -eq 1 ]; then
			result="$result $m"
		fi
	done
	echo $result
	return 0
}

# Search for a pattern in a list.
match_list () {
	local pattern="`echo \"$1\" | sed -e 's:/:\\\/:g'`"
	local candidates="$2"
	local matches=""
	local match

	for c in $candidates; do
		match=`echo $c | sed -n -e "/$pattern/p"`
		if [ $? -eq 0 -a -n "$match" ]; then
			matches="$matches $c"
		fi
	done
	echo $matches | sed -e 's:\\::g'
	return 0
}

# Reverse a list.
reverse () {
	local reversed=""
	for p in ""$@; do
		reversed="$p $reversed"
	done
	echo $reversed
}
count_words ()
{
	echo "$#"
}

first ()
{
	echo "$1"
}

second ()
{
	echo "$2"
}

third ()
{
	echo "$3"
}

fourth ()
{
	echo "$4"
}

last ()
{
	eval echo $"$#"
}

not ()
{
	if [ "$1" -eq 0 -o "$1" = "" ]; then
		echo 1
	else
		echo 0
	fi
}
