#include <stdio.h>
#include "dinstall.h"
#include <newt.h>
#include "lang.h"

static char *fstype_name[FSTYPE_MAX] = {
    "ext2",
    "swap",
    "msdos",
    "minix",
    "affs",
    "hfs",
    "extended",
    NULL /* FSTYPE_UNKNOWN */
};

struct fdisk_partition *
select_not_mounted( const char *message, const char *title, int ntypes, ... ) {
  struct fdisk_partition *p;
  va_list argp;
  char *name, *fstypes_list=NULL;
  int height,fstype,i,it=0;
  newtComponent t1,lb,f1;

  height=1+strlen(message)/70;
  t1 = newtTextbox (1, 1, 70, height, NEWT_FLAG_WRAP);
  newtTextboxSetText(t1,message);
  lb = newtListbox(25,height+2, 0, NEWT_FLAG_DOBORDER | NEWT_FLAG_RETURNEXIT);
  
  if (ntypes) {
    va_start (argp, ntypes); 
    for (i = 0; i < ntypes; i++) {
      fstype= va_arg(argp, int);    
      name = fstype_name[fstype];
      if (fstypes_list)
        addtolist(&fstypes_list,name);
      else
        fstypes_list = strdup(name);
      p = fdisk_partitions_by_type[fstype];
      while (p) {
        if (! p->in_use){
          newtListboxAddEntry(lb,p->name,p);
          it++;
        }
        p = p->next_by_type;
      }
    }
    va_end (ap);
  } else {
    p = fdisk_partitions;
    while (p) {
      if (! p->in_use){
        newtListboxAddEntry(lb,p->name,p);
        it++;
      }
      p = p->next;
    }
  }

  if (! it){
    if (ntypes) {
      sprintf(prtbuf,MSG_ERROR_NO_X_PARTITIONS,fstypes_list);
      problemBox(prtbuf,MSG_PROBLEM);
    } else {
      problemBox(MSG_ERROR_NO_PARTITIONS,MSG_PROBLEM);
    }
    return NULL;
  }

  f1 = newtForm(NULL, NULL, 0);
  newtFormAddComponents (f1, t1, lb, NULL);

  newtOpenWindow (5, 8-(height+it)/2, 71, 4+height+it, title);
  newtRunForm(f1);
  p = newtListboxGetCurrent(lb);

  newtPopWindow();
  newtFormDestroy(f1);

  return(p);
}
