#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>

#include "fdisk.h"

char *fsname[FSTYPE_MAX] = {
	"ext2", "swap", "msdos", "minix", "affs", "hfs", "unknown"
};

int main() {
  int i;
  struct fdisk_disk *d;
  struct fdisk_partition *p;

  fdisk_reread();

  d = fdisk_disks;

  while (d) {
    printf("%s: ", d->name);
    p = d->partitions;
    while (p) {
      printf("%s, ", p->name);
      p = p->next_by_disk;
    }
    printf("\n");

    d = d->next;
  }

  p = fdisk_partitions;
  while (p) {
    printf("%s (%s), ", p->name, sysname(p->type));
    p = p->next;
  }
  printf("\n");

  printf("Mounted partitions:");
  p = mounted_partitions;
  while (p) {
    printf("%s (on %s), ", p->name, p->mount_point);
    p = p->next_in_use;
  }
  printf("\n");

  printf("Swap partitions in use:");
  p = swapon_partitions;
  while (p) {
    printf("%s, ", p->name);
    p = p->next_in_use;
  }
  printf("\n");

  for( i = 0; i < FSTYPE_MAX; ++i ) {
	  printf( "%s fs partitions: ", fsname[i] );
	  p = fdisk_partitions_by_type[i];
	  while (p) {
		  printf("%s, ", p->name);
		  p = p->next_by_type;
	  }
	  printf("\n");
  }
  
  return(0);
}
