### Copyright (C) 1995-1997 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


######################################################################
### This function checks that a saveif a save file exists from
### version 1.1, and updates this to an export file.
### This is necesary to do explicit, because the save file is called
### what the directory is called in ver 2.0 and greater.
######################################################################
proc updateFromVer-1.1 {} {
  global module argv __system
  set mv $__system(mv)
  set cp $__system(cp)
  set rm $__system(rm)
  set mkdir $__system(mkdir)
  set tclsh $__system(tclsh)
  ### Check if there exists any save file
  if {![file isfile [myGlob ~]/.dotfile/$module(name)]} {
    return
  }

  set IN [open [myGlob ~]/.dotfile/$module(name)]
  gets $IN
  set line [gets $IN]
  close $IN

  ### If ~/.dotfile/<module> is a file, and it's version is not 1.1
  ### it must be older, and then it is too old.
  if {![regexp "^# Dotfile Generator version 1.1(b3)?\$" $line]} {
    eval "exec $mv [myGlob ~]/.dotfile/$module(name) [myGlob ~]/.dotfile/$module(name).old"
    tk_dialog .info "Save file to old" "Save file located in \"[myGlob ~]/.dotfile/$module(name)\" was written with a version of The Dotfile Generator, which was to old to update. It has been moved to \"[myGlob ~]/.dotfile/$module(name).old\"" info 0 OK
    return
  }

  ### Now make a backup, in case the exec's shouldn't work.
  ### and write to standard output what is going to be done
  eval "exec $cp [myGlob ~]/.dotfile/$module(name) [myGlob ~]/.dotfile/$module(name).old"
  puts "The update consist of the following steps:\n"
  puts "tclsh [lindex $argv 0]/update-from-1.1.tcl [myGlob ~]/.dotfile/$module(name) [lindex $argv 0]/oldVersions/1.1/$module(name) [myGlob ~]/.dotfile/$module(name).export $module(name)"
  puts "rm [myGlob ~]/.dotfile/$module(name)"
  puts "mkdir [myGlob ~]/.dotfile/$module(name)"
  puts "mkdir [myGlob ~]/.dotfile/$module(name)/export-files"
  puts "mv [myGlob ~]/.dotfile/$module(name).export [myGlob ~]/.dotfile/$module(name)/export-files"
  puts "create the file called \"[myGlob ~]/.dotfile/$module(name)/export-files/contents\" with the following line:"
  puts "Content $module(name).export {} \"Original save-file\"  \"This file is the original savefile from Dot.Gen. ver 1.1\""

  ### ask the user wether he want this done automaticly
  set answer [tk_dialog .info "Update of the save-file" "The Dotfile Generator have found a save file from version 1.1. It will now update this to version 2.0. This involves a lot os shell executaion, so to avoid destroying your work so far, the file has been save. Please check that a file called [myGlob ~]/.dotfile/$module(name).old now exists. If it doesn't you should stop, and do the update yourself. Please check stdout for a description of what will be done."  info 0 "Do The update your self" "Let The Dot. Gen. do it"]
  if {$answer == 0} {
    exit -1
  } else {  
    exec $tclsh [lindex $argv 0]/update-from-1.1.tcl [myGlob ~]/.dotfile/$module(name) [lindex $argv 0]/oldVersions/1.1/$module(name) [myGlob ~]/.dotfile/$module(name).export $module(name)
    eval "exec $rm [myGlob ~]/.dotfile/$module(name)"
    eval "exec $mkdir [myGlob ~]/.dotfile/$module(name)"
    eval "exec $mkdir [myGlob ~]/.dotfile/$module(name)/export-files"
    eval "exec $mv [myGlob ~]/.dotfile/$module(name).export [myGlob ~]/.dotfile/$module(name)/export-files"
    set IN [open [myGlob ~]/.dotfile/$module(name)/export-files/contents w]
    puts $IN "Content $module(name).export {} \"Original save-file\" \
  \"This file is the original savefile from Dot.Gen. ver 1.1\""
    close $IN
  }
}
