------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--          S Y S T E M . T A S K _ P R I M I T I V E S . D E B U G         --
--                                                                          --
--                                  B o d y                                 --
--                         (Version for new GNARL)                          --
--                                                                          --
--                             $Revision: 1.2 $                             --
--                                                                          --
--              Copyright (C) 1997, Free Software Foundation, Inc.          --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This is a Linux (FSU THREADS) version of this package.
--  This package encapsulates all direct interfaces to task debugging services
--  that are needed by System.Task_Debug

--  This version is for POSIX-like operating systems

with System.Task_Primitives;
--  used for visibility of LL.Thread component of ATCB

with System.OS_Interface;
with Unchecked_Conversion;

package body System.Task_Primitives.Debug is

   subtype thread_t is System.OS_Interface.pthread_t;

   function To_Long is new Unchecked_Conversion
     (thread_t, Interfaces.C.Unsigned_Long);

   procedure Suspend_Task (T : in System.Tasking.Task_ID) is
   begin
      null;
   end Suspend_Task;

   procedure Continue_Task (T : in System.Tasking.Task_ID) is
   begin
      null;
   end Continue_Task;

   function Get_Thread (T : in System.Tasking.Task_ID)
     return Interfaces.C.Unsigned_Long is
   begin
      return To_Long (T.LL.Thread);
   end Get_Thread;

end System.Task_Primitives.Debug;
