/****************************************************************************/
/*                                                                          */
/*                          GNAT RUN-TIME COMPONENTS                        */
/*                                                                          */
/*              Auxiliary C functions for Interfaces.C.Streams              */
/*                                                                          */
/*                                   Body                                   */
/*                                                                          */
/*                              $Revision: 1.28 $                           */
/*                                                                          */
/*          Copyright (C) 1992-1997 Free Software Foundation, Inc.          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, */
/* MA 02111-1307, USA.                                                      */
/*                                                                          */
/* As a  special  exception,  if you  link  this file  with other  files to */
/* produce an executable,  this file does not by itself cause the resulting */
/* executable to be covered by the GNU General Public License. This except- */
/* ion does not  however invalidate  any other reasons  why the  executable */
/* file might be covered by the  GNU Public License.                        */
/*                                                                          */
/* GNAT was originally developed  by the GNAT team at  New York University. */
/* It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). */
/*                                                                          */
/****************************************************************************/

/* Routines required for implementing routines in Interfaces.C.Streams */

#include "config.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

#ifdef __EMX__
#include <stdlib.h>
int max_path_len = _MAX_PATH;
#else
#ifdef VMS
#include <unixlib.h>
/* #include <limits.h> */
int max_path_len = 255; /* PATH_MAX */
#else
#ifdef __vxworks
#include <limits.h>
int max_path_len = PATH_MAX;
#else
#include <sys/param.h>

/* If we can't find MAXPATHLEN there, try in unistd.h.  That file might
   not exist, but we'll blow up anyway if we don't try something.  */
#ifndef MAXPATHLEN
#include <unistd.h>
#endif

int max_path_len = MAXPATHLEN;
#endif
#endif
#endif

int
feof__ (stream)
     FILE *stream;
{
  return (feof (stream));
}

int
ferror__ (stream)
     FILE *stream;
{
   return (ferror (stream));
}

int
fileno__ (stream)
     FILE *stream;
{
   return (fileno (stream));
}

int
is_regular_file_fd (fd)
     int fd;
{
  int ret;
  struct stat statbuf;

  ret = fstat (fd, &statbuf);
  return (!ret && S_ISREG (statbuf.st_mode));
}

/* on some systems, the constants for seek are not defined, if so, then
   provide the conventional definitions */

#ifndef SEEK_SET
#define SEEK_SET 0  /* Set file pointer to offset                           */
#define SEEK_CUR 1  /* Set file pointer to its current value plus offset    */
#define SEEK_END 2  /* Set file pointer to the size of the file plus offset */
#endif

/* if L_tmpnam is not set, use a large number that should be safe */
#ifndef L_tmpnam
#define L_tmpnam 256
#endif

int    c_constant_eof      = EOF;
int    c_constant_iofbf    = _IOFBF;
int    c_constant_iolbf    = _IOLBF;
int    c_constant_ionbf    = _IONBF;
int    c_constant_l_tmpnam = L_tmpnam;
int    c_constant_seek_cur = SEEK_CUR;
int    c_constant_seek_end = SEEK_END;
int    c_constant_seek_set = SEEK_SET;

FILE *
c_constant_stderr ()
{
  return stderr;
}

FILE *
c_constant_stdin ()
{
  return stdin;
}

FILE *
c_constant_stdout ()
{
  return stdout;
}

char *
full_name (nam, buffer)
     char *nam;
     char *buffer;
{
   char *p;

#ifdef __EMX__
   _fullpath (buffer, nam, max_path_len);
   for (p = buffer; *p; p++)
     if (*p == '/')
       *p = '\\';

#else
#ifdef MSDOS
   _fixpath (nam, buffer);

#else
#if defined (sgi) || defined (sun) || defined (linux)

   /* Use realpath function which resolves links and references to .. and ..
      on those Unix systems that support it. */
   realpath (nam, buffer);

#else
#ifdef _WINNT

   /* The Cygnus development environment supports Unix-like filenames
      and provides a routine for converting paths to their full
      specification.  If not using Cygwin32 (i.e. Mingw32), then use
      the MS routine. */
#ifdef __CYGWIN32__
   cygwin32_conv_to_full_win32_path (nam, buffer, max_path_len);
#else
   _fullpath (nam, buffer);
#endif

#else
#ifdef VMS
   /* This only handles pure filenames and absolute paths and ignores anything
      with a relative path since VMS paths cant be simply concatenated
      together, but to do it right requires RMS services and the header files
      arent in a format that gcc can use.  Fix later ??? */
   if (strchr (nam, '[') || strchr (nam, ':'))
     strcpy (buffer, nam);

   else
     {
       buffer = getcwd (buffer, max_path_len);
       strcat (buffer, nam);
     }

#else
   extern char *getcwd();

   if (nam[0] != '/')
     {
       p = getcwd (buffer, max_path_len);
       if (p == 0)
	 {
	   buffer[0] = '\0';
	   return NULL;
	 }

       strcat (buffer, "/");
       strcat (buffer, nam);
     }
   else
     strcpy (buffer, nam);

#endif
#endif
#endif
#endif
#endif
}
