------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                     S Y S T E M . T A S K _ D E B U G                    --
--                                                                          --
--                                  B o d y                                 --
--                         (Version for old GNARL)                          --
--                                                                          --
--                             $Revision: 1.2 $                             --
--                                                                          --
--              Copyright (C) 1997, Free Software Foundation, Inc.          --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This package encapsulates all direct interfaces to task debugging services
--  that are needed by gdb with gnat mode (1.13 and higher)

--  This version is for POSIX-like operating systems

with System.Tasking.Initialization;
with System.Task_Info;

package body System.Task_Debug is

   use Interfaces.C;
   use Interfaces.C.Strings;
   use System.Tasking;

   procedure Convert_Task_Info (C : in     System.Tasking.Task_ID;
                                D :    out Task_ID);

   ------------------
   -- Suspend_Task --
   ------------------

   procedure Suspend_Task (T : in Task_ID) is
   begin
      null;
   end Suspend_Task;

   -------------------
   -- Continue_Task --
   -------------------

   procedure Continue_Task (T : in Task_ID) is
   begin
      null;
   end Continue_Task;

   --  intern procedures

   procedure Convert_Task_Info (C : in     System.Tasking.Task_ID;
                                D :    out Task_ID) is
      use type System.Task_Info.Task_Image_Type;
   begin
      D.ID := C;
      D.Entry_Num := int (C.Entry_Num);
      D.Task_Entry_Point := C.Task_Entry_Point;
      D.Task_Arg := C.Task_Arg;

      D.Stack_Size := int (C.Stack_Size);
      D.Base_Priority := int (C.Base_Priority);
      D.New_Base_Priority := int (C.New_Base_Priority);
      D.All_Tasks_Link := null;

      D.Activation_Link := null;
      D.Activator := null;
      D.Parent := null;

      D.Master_of_Task := int (C.Awake_Count);
      D.Master_Within := int (C.Awake_Count);
      D.Activation_Count := int (C.Awake_Count);
      D.Awake_Count := int (C.Awake_Count);
      D.Awaited_Dependent_Count := int (C.Awaited_Dependent_Count);
      D.Terminating_Dependent_Count := int (C.Terminating_Dependent_Count);
      D.Pending_ATC_Level := int (C.Pending_ATC_Level);
      D.ATC_Nesting_Level := int (C.ATC_Nesting_Level);

      case C.Stage is
         when System.Tasking.Created => D.Stage := Created;
         when System.Tasking.Can_Activate => D.Stage := Can_Activate;
         when System.Tasking.Active => D.Stage := Active;
         when System.Tasking.Await_Dependents => D.Stage := Await_Dependents;
         when System.Tasking.Passive => D.Stage := Passive;
         when System.Tasking.Complete => D.Stage := Complete;
         when System.Tasking.Terminated => D.Stage := Terminated;
         when System.Tasking.Completing => D.Stage := Completing;
      end case;

      --  beginning of flags

      D.Cancel_Was_Successful := Boolean'Pos (C.Cancel_Was_Successful);

      case C.Accepting is
         when System.Tasking.Not_Accepting => D.Accepting := Not_Accepting;
         when System.Tasking.Trivial_Accept => D.Accepting := Trivial_Accept;
         when System.Tasking.Simple_Accept => D.Accepting := Simple_Accept;
         when System.Tasking.Select_Wait => D.Accepting := Select_Wait;
      end case;

      D.Aborting := Boolean'Pos (C.Aborting);
      D.Terminate_Alternative := Boolean'Pos (C.Terminate_Alternative);

      --  end of flags

      if C.Task_Image /= null then
         D.Task_Image := New_String (String (C.Task_Image.all));
      end if;

   end Convert_Task_Info;

   -------------------
   -- Current_Task --
   -------------------

   function Current_Task return Task_ID is
      Result : Task_ID;
   begin
      Result := new Ada_Task_Control_Block;
      Convert_Task_Info (System.Tasking.Self, Result);
      return Result;
   end Current_Task;

   function Self return System.Tasking.Task_ID
     renames System.Tasking.Self;

   function Info_Tasks return Task_ID is
      C      : System.Tasking.Task_ID;
      D      : Task_ID;
      Result : Task_ID;
   begin
      --  TPO.Write_Lock (All_Tasks_L'Access);
      --  see note DEADLOCK
      C := System.Tasking.Initialization.All_Tasks_List;
      Result := new Ada_Task_Control_Block;
      D := Result;
      while C /= null loop
         Convert_Task_Info (C, D);
         C := C.All_Tasks_Link;
         if C /= null then
            D.All_Tasks_Link := new Ada_Task_Control_Block;
            D := D.All_Tasks_Link;
         end if;
      end loop;
      --  TPO.Unlock (All_Tasks_L'Access);
      --  see note DEADLOCK
      return Result;
   end Info_Tasks;

   procedure Stop_Tasks is
   begin
      null;
   end Stop_Tasks;

   procedure Resume_Tasks is
   begin
      null;
   end Resume_Tasks;

end System.Task_Debug;
