------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                     S Y S T E M . T A S K _ D E B U G                    --
--                                                                          --
--                                  S p e c                                 --
--                         (Version for old GNARL)                          --
--                                                                          --
--                             $Revision: 1.2 $                             --
--                                                                          --
--              Copyright (C) 1997, Free Software Foundation, Inc.          --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This package encapsulates all direct interfaces to task debugging services
--  that are needed by gdb with gnat mode (1.13 and higher)

--  This version is for POSIX-like operating systems

with Interfaces.C;
with Interfaces.C.Strings;
with System.Tasking;

package System.Task_Debug is

   package IC renames Interfaces.C;
   package ICS renames Interfaces.C.Strings;

   -------------------------
   --  types definitions  --
   -------------------------

   -----------------------
   -- Enumeration types --
   -----------------------

   type Task_Stage is (
      Created,
      Can_Activate,
      Active,
      Await_Dependents,
      Passive,
      Completing,
      Complete,
      Terminated);
   pragma Convention (C, Task_Stage);

   type Accepting_State is (
      Not_Accepting,
      Trivial_Accept,
      Simple_Accept,
      Select_Wait);
   pragma Convention (C, Accepting_State);

   type Call_Modes is (Simple_Call, Conditional_Call, Asynchronous_Call);
   pragma Convention (C, Call_Modes);

   type Select_Modes is (Simple_Mode, Else_Mode, Terminate_Mode, Delay_Mode);
   pragma Convention (C, Select_Modes);

   ----------------------------------------------
   -- Ada_Task_Control_Block (ATCB) definition --
   ----------------------------------------------

   type Ada_Task_Control_Block;
   type Task_ID is access Ada_Task_Control_Block;

   type Ada_Task_Control_Block is record
      ID        : System.Tasking.Task_ID;
      Entry_Num : IC.int;

      --  LL_TCB : System.Task_Primitives.Private_Data;
      Thread    : IC.Unsigned_Long := 0;  --  not used

      Task_Entry_Point : System.Tasking.Task_Procedure_Access;
      Task_Arg : System.Address;

      --  Task_Info : System.Task_Info.Task_Info_Type;

      Stack_Size : IC.int;
      Base_Priority : IC.int;
      New_Base_Priority : IC.int;
      All_Tasks_Link : Task_ID;
      Activation_Link : Task_ID;  --  currently not used
      Activator : Task_ID;        --  not used
      Parent : Task_ID;           --  not used
      Master_of_Task : IC.int;
      Master_Within : IC.int;
      Activation_Count : IC.int;
      Awake_Count : IC.int;
      Awaited_Dependent_Count : IC.int;
      Terminating_Dependent_Count : IC.int;
      Pending_ATC_Level : IC.int;
      ATC_Nesting_Level : IC.int;
      Stage : Task_Stage;

      --  beginning of flags

      Cancel_Was_Successful : IC.int;
      Accepting : Accepting_State;
      Aborting : IC.int;
      Terminate_Alternative : IC.int;

      --  end of flags

      Task_Image : ICS.chars_ptr;
   end record;
   pragma Convention (C, Ada_Task_Control_Block);

   ------------------

   function Info_Tasks return Task_ID;
   --  returns a list of all the known Ada tasks
   --  each All_Tasks_Link value is correct and points to the next
   --  Task_ID.
   --  Activation_Link, Activator and Parent are not set up correctly,
   --  do not use them

   function Current_Task return Task_ID;
   --  returns Task_ID of current task
   --  All_Tasks_Link is not set up (null value)
   --  Activation_Link, Activator and Parent are not set up correctly,
   --  do not use them

   function Self return System.Tasking.Task_ID;
   --  returns system ID of current task (not modified)

   procedure Suspend_Task (T : in Task_ID);
   --  tries to suspend task T

   procedure Continue_Task (T : in Task_ID);
   --  tries to continue the task T

   procedure Stop_Tasks;
   --  tries to suspend all Ada tasks except for the current task

   procedure Resume_Tasks;
   --  tries to resume the tasks suspended by Stop_Tasks

end System.Task_Debug;
