/* Typedefs and defines for the files GNATS will read and write.
   Copyright (C) 1993-96, 1997 Free Software Foundation, Inc.
   Originally contributed by Tim Wicinski (wicinski@barn.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#ifndef _files_h_
#define _files_h_

/* Format of a submitters file.  */
typedef struct
{
  /* Unique submitter-id string.  */
  char *key;

  /* Full submitter name.  */
    char *fullname;

  /* Type of submitter; e.g., can be type of contract ("none", "leverage",
     etc.).  */
    char *type;

  /* Response time in business hours.  9 hours currently means 24 "real-hours"
     response time, 0 means none, and -1 means submitter "expired".  */
    int  rtime;

  /* Mail address of principal contact for submitter.  */ 
    char *contact;

  /* Addresses to which notification is also sent, in addition to the
     address in CONTACT.  */
    char *notify;
} Submitter;

#define NUM_SUBMITTER_FIELDS 6

/* Format of a categories file.  */
typedef struct
{
  /* Category */
  char *key;

  /* Description of the category.  A `*' means it's valid only for the
     support site.  */
  char *fullname;

  /* Email address of the person responsible (by default) for this category;
     the file `responsible' in GNATS_ROOT/gnats-adm is the default location. */
  char *person;

  /* Other mail addresses to whom notification should be sent with bugs
     in this category.  */
  char *notify;
} Category;

#define NUM_CATEGORY_FIELDS 4

/*  Format for the responsible file.  */
typedef struct responsible_entry {
  /* Email address, username, or alias for a responsible maintainer.  */
  char *key; 

  /* Full name of the person (cf. /etc/passwd, possibly).  */
  char *fullname;

  /* Email address of the person.  If this is empty, the KEY is used as
     the address, assuming that it is a local user.  */
  char *alias;

  /* Whether this entry is "authentic" or not.  I.e., if this is true,
     then the entry indicates someone who was found either in the
     "responsible" field or in the passwd file; if it's false, then
     the entry indicates an entry that was constructed dynamically
     (e.g., perhaps because the person left the company and is no
     longer in the passwd file, but they still appear in the
     Responsible field of some PRs so the value should be considered
     valid). */
  int authentic;

  /* pointer to next record */
  struct responsible_entry *next;

} Responsible;

#define NUM_RESPONSIBLE_FIELDS 3

#endif /* _files_h_ */
