#ifndef GTKMM_SIGCOMMON
#define GTKMM_SIGCOMMON

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_VOID_RETURN_TYPE
#define VR_RETURN return
#else
#define VR_RETURN
#endif

#ifdef HAVE_PARTIAL_SPECIALIZATION
#define SP_RETURN return
#else
#define SP_RETURN
#endif


#include <gtk/gtksignal.h>
#include <gtk/gtkwidget.h>

//
// Connections are stored to two lists - one at the signal and one at
// the receiver.
//
// This object must know how to disconnect it from both lists!
// That's why we have this alittle odd looking list implementations here.
//


class Connection_impl {
public:
    // first list is stored at signals
    Connection_impl *next;
    Connection_impl *prev;
    // 2nd list is stored at Gtk_object
    Connection_impl *snext;
    Connection_impl *sprev;
    
    GtkObject *gtkobj;
    gint connid;
    void setgtkconnection(GtkObject *gtko, gint cid) 
    { connid=cid; gtkobj=gtko; }
    
    Connection_impl() : next(0),prev(0),snext(0),sprev(0),gtkobj(0),connid(0) {
    }
    

    void disconnect() {
	if (next) { 
	    next->prev=prev;
	    prev->next=next;
	}
	if (snext) {
	    snext->sprev=sprev;
	    sprev->snext=snext;
	}
	if (gtkobj) {
	    gtk_signal_disconnect(gtkobj,connid);
	}
    }
};

#ifdef HAVE_MUTABLE
#define GTKMM_CONST const
#define GTKMM_MUTABLE mutable
#else
#define GTKMM_CONST
#define GTKMM_MUTABLE
#endif

// This is an object given to user -- user can store it, mess with it
// and call disconnect() for it. -- or user can just dump this object
// and the disconnect is made automatically either at Gtk_Object's
// destructor or Signal's destructor. (actually G_List/G_SList) 
class Connection {

  GTKMM_MUTABLE Connection_impl *c;
public:
  // can assign this to another object, but then the original loses
  // its ability to disconnect the signal -- This is for making it
  // possible to pass Connection to the user.
  void operator=(GTKMM_CONST Connection &obj) { c=obj.c; obj.c=0; }
  Connection(const Connection &conn) {
       Connection &co=const_cast<Connection&>(conn); 
       c=co.c; co.c=0; }
  Connection(Connection_impl *c_) : c(c_) { }
  Connection() : c(0) { }
  void disconnect() GTKMM_CONST 
    { if (c) { c->disconnect(); delete c; c=0; } }

  // access to low level gdk signal stuffs. Try to avoid use of this.
  gint GetSignalID() const { return c->connid; }

};


// This is a circular list for Connection_impl-items
class G_List {
  Connection_impl enditem; // one extra element for marking start and end
public:
  Connection_impl * begin() { return enditem.next; }
  Connection_impl * end() { return &enditem; }
  void insert(Connection_impl *item) {
    item->next=enditem.next;
    item->prev=&enditem;
    enditem.next->prev=item;
    enditem.next=item;
  }
  // Connection_impl -object handles disconnection from the list.
  
  G_List() { 
    enditem.next=&enditem; enditem.prev=&enditem; }
  ~G_List() { 
    while(begin()!=end()) {
      Connection_impl *c=begin();
      c->disconnect(); // remove from the lists.
      delete c; // delete the object.
    }
  }
};
// This is a circular list for Connection_impl-items -- uses snext/sprev
class G_SList {
  Connection_impl enditem; // one extra element for marking start and end
public:
  Connection_impl * begin() { return enditem.snext; }
  Connection_impl * end() { return &enditem; }
  void insert(Connection_impl *item) {
    item->snext=enditem.snext;
    item->sprev=&enditem;
    enditem.snext->sprev=item;
    enditem.snext=item;
  }
  // Connection_impl -object handles Connection from the list.
  
  G_SList() { 
    enditem.snext=&enditem; enditem.sprev=&enditem; }
  ~G_SList() { 
    while(begin()!=end()) {
      Connection_impl *c=begin();
      c->disconnect(); // remove from the lists.
      delete c; // delete the object.
    }
  }
};


class Gtk_Signal_Base {
    G_SList connectionlist; // support for signalN<> requires this.
public:
  void insert_connection(Connection_impl *item) 
  { connectionlist.insert(item); }

  virtual ~Gtk_Signal_Base() { }
};
#endif
