
/* GTK-- - a C++ wrapper for the Gtk toolkit
 *
 * The signal system used by gtk--
 *
 * This file handles communication of the gtk-- signal system and
 * existing C widgets.
 * 
 * Copyright (C) 1997 Elliot Lee <sopwith@redhat.com>      
 *                    Phil Dawes
 *                    Tero Pulkkinen
 *
 * Currently maintained by Tero Pulkkinen. <terop@modeemi.cs.tut.fi>
 *                                                        
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef GTKMM_SIGPROXY
#define GTKMM_SIGPROXY

#include <gtk/gtksignal.h>
#include <gtk/gtkwidget.h>


#include <gtk--sigcommon.h>
#include <gtk--sigslot.h>
#include <gtk--sigcpp.h>
class Gtk_Object;

template<class rettype, class objtype>
class Signal_proxy0 {
public:
  gchar *signal_name; // needed for calling C's signal
  Gtk_Object *sender; // parent
  Signal_proxy0(gchar *name, objtype *obj);
  rettype operator()(); // emit replacement
};



#define COMMA ,

class Signal_proxy_base {
public:
  gchar *signal_name;
  Gtk_Object *sender;
  Signal_proxy_base(gchar *sign,Gtk_Object *send) : signal_name(sign), sender(send) { }
};

#define SIGNAL_PROXY_CREATOR(num,paramclass,paramboth,paramtypes,paramnames,needcomma) \
template<class rettype, class objtype, paramclass> \
class Signal_proxy##num : public Signal_proxy_base { \
public: \
  Signal_proxy##num(gchar *name, Gtk_Object *obj); \
  rettype operator()(paramboth); \
};

// uh, not possible to do typedef for these :( will have to convert by hand. :)

SIGNAL_PROXY_CREATOR(1,class P1, P1 p1,P1,p1,COMMA)
SIGNAL_PROXY_CREATOR(2,class P1 COMMA class P2, P1 p1 COMMA P2 p2,P1 COMMA P2,p1 COMMA p2,COMMA)
SIGNAL_PROXY_CREATOR(3,class P1 COMMA class P2 COMMA class P3, P1 p1 COMMA P2 p2 COMMA P3 p3,P1 COMMA P2 COMMA P3,p1 COMMA p2 COMMA p3,COMMA)
SIGNAL_PROXY_CREATOR(4,class P1 COMMA class P2 COMMA class P3 COMMA class P4, P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4,P1 COMMA P2 COMMA P3 COMMA P4,p1 COMMA p2 COMMA p3 COMMA p4,COMMA)
SIGNAL_PROXY_CREATOR(5,class P1 COMMA class P2 COMMA class P3 COMMA class P4 COMMA class P5, P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4 COMMA P5 p5, P1 COMMA P2 COMMA P3 COMMA P4 COMMA P5,p1 COMMA p2 COMMA p3 COMMA p4 COMMA p5,COMMA)

#undef SIGNAL_PROXY_CREATOR
#undef COMMA



template<class rettype, class objtype>
Signal_proxy0<rettype,objtype>::Signal_proxy0(gchar *name, objtype *obj) 
  : signal_name(name), // must be statically allocated
    sender(obj)
{ }

template<class rettype, class objtype>
rettype Signal_proxy0<rettype,objtype>::operator()() {
  gtk_signal_emit_by_name(sender->gtkobject,signal_name);
}
  

template<class rettype, class widgettype, class T>
Connection
connect_to_method(Signal_proxy0<rettype,widgettype> &p, T *receiver, rettype (T::*method)()) {
  Connection_impl* s = new Slot<rettype,T>(receiver,method);
  p.sender->insert_connection(s);
  gint conn=p.sender->signal_connect(p.signal_name, GtkSignalFunc(Slot<rettype,T>::callback),s);
  s->setgtkconnection(p.sender->gtkobject,conn);
  return Connection(s);
}

template<class rettype,class widgettype, class T, class E>
Connection
connect_to_method(Signal_proxy0<rettype,widgettype> &p, T *receiver, rettype (T::*method)(E), E arg ) {
  Connection_impl* s = new Slotcb<rettype,T,E>(receiver,method,arg);
  p.sender->insert_connection(s);
  gint conn=p.sender->signal_connect(p.signal_name, GtkSignalFunc(Slotcb<rettype,T,E>::callback),s);
  s->setgtkconnection(p.sender->gtkobject,conn);
  return Connection(s);
}


 template<class rettype,class widgettype>
 Connection
 connect_to_function(Signal_proxy0<rettype,widgettype> &p, rettype (*method)() ) {
   Connection_impl* s = new Concretegtkslot0<rettype,rettype(*)()>(method);
   p.sender->insert_connection(s);
   gint conn=p.sender->signal_connect(p.signal_name, GtkSignalFunc(Concretegtkslot0<rettype,rettype(*)()>::callback),s);
   s->setgtkconnection(p.sender->gtkobject,conn);
   return Connection(s);
 }

template<class rettype,class widgettype, class M>
Connection
connect_to_signal(Signal_proxy0<rettype,widgettype> &p, M &method ) {
  Connection_impl* s = new Concretegtkslot0<rettype,M&>(method);
  p.sender->insert_connection(s);
  gint conn=p.sender->signal_connect(p.signal_name, GtkSignalFunc(Concretegtkslot0<rettype,M&>::callback),s);
  s->setgtkconnection(p.sender->gtkobject,conn);
  return Connection(s);
}


template<class rettype, class widgettype, class E>
Connection
  connect_to_function(Signal_proxy0<rettype,widgettype> &p, rettype (*method)(E), E arg ) {
  Connection_impl* s = new Concretegtkslot0cb<rettype,rettype(*)(E),E>(method,arg);
  p.sender->insert_connection(s);
  gint conn=p.sender->signal_connect(p.signal_name, GtkSignalFunc(Concretegtkslot0cb<rettype,rettype(*)(E),E>::callback),s);
  s->setgtkconnection(p.sender->gtkobject,conn);
  return Connection(s);
}

template<class rettype, class widgettype, class M, class E>
Connection
  connect_to_signal(Signal_proxy0<rettype,widgettype> &p, M &method, E arg ) {
  Connection_impl* s = new Concretegtkslot0cb<rettype,M&,E>(method,arg);
  p.sender->insert_connection(s);
  gint conn=p.sender->signal_connect(p.signal_name, GtkSignalFunc(Concretegtkslot0cb<rettype,M&,E>::callback),s);
  s->setgtkconnection(p.sender->gtkobject,conn);
  return Connection(s);
}



#define COMMA ,
#define SIG_COM_CREATE(num,PARAMCLASSES, PARAMTYPES, PARAMBOTH, PARAMNAMES, NEEDCOMMA)\
template<class rettype,class widgettype,class T NEEDCOMMA PARAMCLASSES> \
Connection \
connect_to_method(Signal_proxy##num<rettype,widgettype NEEDCOMMA PARAMTYPES> &p, T *receiver, \
	rettype (T::*method)(PARAMTYPES) ) { \
  Connection_impl* s = new Slot##num<rettype,T NEEDCOMMA PARAMTYPES>(receiver,method); \
  p.sender->insert_connection(s); \
  gint conn=p.sender->signal_connect(p.signal_name, \
       GtkSignalFunc(Slot##num<rettype,T NEEDCOMMA PARAMTYPES>::callback),s); \
  s->setgtkconnection(p.sender->gtkobject,conn); \
  return Connection(s); \
} \
template<class rettype, class widgettype,class T NEEDCOMMA PARAMCLASSES,class E> \
Connection \
connect_to_method(Signal_proxy##num<rettype,widgettype NEEDCOMMA PARAMTYPES> &p, T *receiver, \
	rettype (T::*method)(PARAMTYPES), E arg ) { \
  Connection_impl* s = new Slot##num##cb<rettype,T NEEDCOMMA PARAMTYPES,E>(receiver,method,arg); \
  p.sender->insert_connection(s); \
  gint conn; \
  conn=p.sender->signal_connect(p.signal_name, \
      GtkSignalFunc(Slot##num##cb<rettype,T NEEDCOMMA PARAMTYPES,E>::callback),s); \
  s->setgtkconnection(p.sender->gtkobject,conn); \
  return Connection(s); \
} \
template<class rettype,class widgettype,PARAMCLASSES> \
Connection \
connect_to_function(Signal_proxy##num<rettype,widgettype,PARAMTYPES> &p, rettype (*method)(PARAMTYPES) ) { \
  Connection_impl* s = new Concretegtkslot##num<rettype,rettype(*)(PARAMTYPES),PARAMTYPES>(method); \
  p.sender->insert_connection(s); \
  gint conn=p.sender->signal_connect(p.signal_name, \
       GtkSignalFunc(Concretegtkslot##num<rettype,rettype(*)(PARAMTYPES),PARAMTYPES>::callback),s); \
  s->setgtkconnection(p.sender->gtkobject,conn); \
  return Connection(s); \
} \
template<class rettype,class widgettype,PARAMCLASSES,class E> \
Connection \
connect_to_function(Signal_proxy##num<rettype,widgettype,PARAMTYPES> &p, rettype (*method)(PARAMTYPES), E arg ) { \
  Connection_impl* s = new Concretegtkslot##num##cb<rettype,rettype(*)(PARAMTYPES),PARAMTYPES,E>(method,arg); \
  p.sender->insert_connection(s); \
  gint conn; \
  conn=p.sender->signal_connect(p.signal_name, \
      GtkSignalFunc(Concretegtkslot##num##cb<rettype,rettype(*)(PARAMTYPES),PARAMTYPES,E>::callback),s); \
  s->setgtkconnection(p.sender->gtkobject,conn); \
  return Connection(s); \
} \
template<class rettype,class widgettype, class M,PARAMCLASSES> \
Connection \
connect_to_signal(Signal_proxy##num<rettype,widgettype,PARAMTYPES> &p, M & method) { \
  Connection_impl* s = new Concretegtkslot##num<rettype,M&,PARAMTYPES>(method); \
  p.sender->insert_connection(s); \
  gint conn=p.sender->signal_connect(p.signal_name, \
       GtkSignalFunc(Concretegtkslot##num<rettype,M&,PARAMTYPES>::callback),s); \
  s->setgtkconnection(p.sender->gtkobject,conn); \
  return Connection(s); \
} \
template<class rettype,class widgettype,class M,PARAMCLASSES,class E> \
Connection \
connect_to_signal(Signal_proxy##num<rettype,widgettype,PARAMTYPES> &p, M &method, E arg ) { \
  Connection_impl* s = new Concretegtkslot##num##cb<rettype,M&,PARAMTYPES,E>(method,arg); \
  p.sender->insert_connection(s); \
  gint conn; \
  conn=p.sender->signal_connect(p.signal_name, \
      GtkSignalFunc(Concretegtkslot##num##cb<rettype,M&,PARAMTYPES,E>::callback),s); \
  s->setgtkconnection(p.sender->gtkobject,conn); \
  return Connection(s); \
} \
template<class rettype,class widgettype,PARAMCLASSES> \
rettype Signal_proxy##num<rettype,widgettype,PARAMTYPES>::operator()(PARAMBOTH) { \
  gtk_signal_emit_by_name(sender->gtkobject,signal_name NEEDCOMMA PARAMNAMES); \
} \
template<class rettype,class widgettype, PARAMCLASSES> \
Signal_proxy##num <rettype,widgettype,PARAMTYPES>::Signal_proxy##num(gchar *name, Gtk_Object *obj) \
  : Signal_proxy_base(name,obj) { }

SIG_COM_CREATE(1,class P1,P1,P1 p1, p1, COMMA)
SIG_COM_CREATE(2,class P1 COMMA class P2,P1 COMMA P2,P1 p1 COMMA P2 p2, p1 COMMA p2, COMMA)
SIG_COM_CREATE(3,class P1 COMMA class P2 COMMA class P3,P1 COMMA P2 COMMA P3,P1 p1 COMMA P2 p2 COMMA P3 p3, p1 COMMA p2 COMMA p3, COMMA)
SIG_COM_CREATE(4,class P1 COMMA class P2 COMMA class P3 COMMA class P4,P1 COMMA P2 COMMA P3 COMMA P4,P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4, p1 COMMA p2 COMMA p3 COMMA p4, COMMA)
SIG_COM_CREATE(5,class P1 COMMA class P2 COMMA class P3 COMMA class P4 COMMA class P5,P1 COMMA P2 COMMA P3 COMMA P4 COMMA P5,P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4 COMMA P5 p5, p1 COMMA p2 COMMA p3 COMMA p4 COMMA p5, COMMA)

#undef SIG_COM_CREATE
#undef COMMA

#endif
