#include <stdio.h>

#include "multlang.hh"

/* an implementation of the Squarer object */

class multlang_T_Squarer_impl : public virtual multlang_T_Squarer {
public:
  multlang_T_Squarer_impl(char *instanceHandle, iluServer *server);

  virtual char * ILUGetInstanceHandle();
  virtual iluServer * ILUGetServer();

  virtual ilu_Cardinal ObtainSquare (multlangStatus *_status, ilu_Cardinal val);

private:
  char *ourInstanceHandle;
  iluServer *ourServer;
};

multlang_T_Squarer_impl::multlang_T_Squarer_impl(char *instanceHandle, iluServer *server)
{
  this->ourInstanceHandle = instanceHandle;
  this->ourServer = server;
}

char * multlang_T_Squarer_impl::ILUGetInstanceHandle()
{
  return this->ourInstanceHandle;
}

iluServer * multlang_T_Squarer_impl::ILUGetServer()
{
  return this->ourServer;
}

ilu_Cardinal multlang_T_Squarer_impl::ObtainSquare (multlangStatus *_status,
						    ilu_Cardinal val)
{
  static multlang_T_Multiplier *theMultiplier = NULL;

  if (theMultiplier == NULL) {
    theMultiplier =
      (multlang_T_Multiplier *) iluObject::Lookup("Server1",
						  "theMultiplierObject",
						  multlang_T_Multiplier::ILUClassRecord);
    if (theMultiplier == NULL)
      return 0;
  }
  return theMultiplier->Multiply (_status, val, val);
}

/* Initialization code */

extern "C" {
  ilu_boolean multlang_StartCPlusPlus (void);
};

ilu_boolean multlang_StartCPlusPlus (void) {

  iluServer s ("Server2", NULL);
  multlang_T_Multiplier *theMultiplier;
  multlang_T_Squarer_impl *theSquarer;

  s.AddPort (NULL, NULL, ilu_TRUE);
  ilu::SetDefaultServer(&s);

  theSquarer = new multlang_T_Squarer_impl("theSquarerObject", &s);
  if ((theSquarer == NULL) || (!theSquarer->ILUPublish())) {
    fprintf (stderr, "Can't create multlang.Squarer object in C++\n");
    return ilu_FALSE;
  };
  return ilu_TRUE;
};
  
