/* IluIdentityType.java */
/* Chris Jacobi, September 2, 1997 12:07 pm PDT */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* 
 * $Id: IluIdentityType.java,v 1.2 1997/09/02 19:12:19 jacobi Exp $ 
 */


/* 
 * Representation for ilu_IdentityType <p>
 * See IluJava_IluPort.c
 */


package xerox.ilu;

/**
 * An IluIdentityType represents a "kind" or "class" of identities.<p> 
 * 
 * There are a few standard ilu IluIdentityType and we probably will 
 * define a meta interface to generate IluIdentityType's from java.<p>
 *
 * This class deals with the creation of IluIdentity, but the mechanism
 * is somewhat unfinished.
 *
 * @see IluIdentity
 * @see IluPassport
 */
public class IluIdentityType extends IluWPBase {
    private static java.util.Hashtable gtable = new java.util.Hashtable();
    /*friendly*/ long yIluIdentityType = 0;
    /*friendly*/ java.lang.String name = null;
    
    /**
     * Disables unauthorized creation or subclassing
     */
    /*friendly*/ IluIdentityType() {
    }
    
    /**
     * Returns the name of the IluIdentityType
     */
    public final java.lang.String getName() {
        return name; 
    }
    
    /**
     * Finds the IluIdentityType with a given name
     */
    public final static IluIdentityType fromName(java.lang.String name) {
        java.lang.Object x = gtable.get(name);
        if (x==null) {
                throw new IluSomeSystemException("not found");
        } 
        return (IluIdentityType) x;
    } //fromName
    
    /**
     * Step in conversion of IluIdentity to String<p>
     * This can be subclassed, but the subclasses are likely
     * to need to call super.identityToStringPart...
     */
    protected java.lang.String identityToStringPart(IluIdentity ii) {
        if (ii.it != this) {
            throw new IluSomeSystemException("bad IluIdentity type");
        }
        return ii.nId2String();
    } //identityToStringPart

     
    /*friendly*/ native int nRegStdIdentityType(int key);
    
    /**
     * Initialization for a few standard IluIdentityType-s
     */
    /*friendly*/ static IluIdentityType createStandardIdtType(
            java.lang.String name, int key
            )
    {
        IluIdentityType it = new IluIdentityType();
        it.name = name;
        synchronized (gtable) {
            if (gtable.get(name) != null) {
                throw new IluSomeSystemException("duplicate");
            }
            if (it.nRegStdIdentityType(key)<0) {
                throw new IluSomeSystemException("bad standardIluIdentityType");
            }
            gtable.put(name, it);
        }
        return it;
    } //createStandardIdtType;
    
    
    /**
     * Create an IluIdentity of this type.
     * We expect this to be sub-classed 
     */
    public IluIdentity createIluIdentity()
    {
        throw new IluSomeSystemException("not impl");
    } //createIluIdentity;
   
    
    private static IluIdentityType connectionIdentity_Type = null;
    private static IluIdentityType noIdentity_Type = null;
    
    /**
     * Returns the IluIdentityType used for connectionIdentity<p>
     */
    public static IluIdentityType getConnectionIdentityType() {
        return connectionIdentity_Type;
    } //getConnectionIdentityType

    /**
     * Returns the IluIdentityType used for noIdentity<p>
     */
    public static IluIdentityType getNoIdentityType() {
        return noIdentity_Type;
    } //getNoIdentityType
    
    public static void init() {
        if (noIdentity_Type == null) {
            IluInit.init();
            noIdentity_Type = 
                createStandardIdtType("NoIdentity", 0);
            connectionIdentity_Type = 
                createStandardIdtType("ConnectionIdentity", 1);
        }
    } //init
    
} //IluIdentityType
