/* IluJava_IluDebug.c */
/* Chris Jacobi, November 6, 1997 3:14 pm PST */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluJava_IluDebug.c,v 1.28 1997/11/06 23:28:17 jacobi Exp $ */
 
/*
 * Native impl for IluDebug.java, IluDebugWriter.java, IluDebugHooks.java
 * including a few native utilities...
 */


#include "IluJava_Includes.h"
#include "IluJava_Common.h"

#include "xerox_ilu_IluDebugHooks.h"
#include "xerox_ilu_IluDebug.h"
#include "xerox_ilu_IluDebugWriter.h"
#include "xerox_ilu_IluRT0.h"
#include "xerox_ilu_IluOInt.h"
#include "xerox_ilu_IluClassRep.h"
#include "xerox_ilu_IluServer.h"

#include "IluJava_JTypes.h"
#include "IluJava_JArrays.h"
#include "IluJava_JGC.h"

#define JIluDebug Hxerox_ilu_IluDebug*
#define JIluDebugHooks Hxerox_ilu_IluDebugHooks*


EXPORTLIMITEDVAR ilu_LanguageIndex _ilujava_langidx = 0;
static ilu_boolean _ilujava_langRegistered = FALSE;


static ilu_LanguageIndex _ilujava_LangIdx(void)
{
    if (! _ilujava_langRegistered) {
        _ilujava_langidx = ilu_RegisterLanguage("Java");
        _ilujava_langRegistered = ilu_TRUE;
    }
    return _ilujava_langidx;
}


EXPORTLIMITED void
_ilujava_DebugPrint(char * f)
{
    ilu_DebugPrintf("$** Ilu_Java BUG: %s \n", f);
    if (_ilujava_iluGenericFlag > 1) {
        _ilujava_PANIC(f);
    }
}


EXPORTLIMITED void
_ilujava_DebugPrintAndSignal(char * f)
{
    _ilujava_DebugPrint(f);
    SignalError(EE(), "xerox/ilu/IluSomeSystemException", "**_ilujava_bug");
}


EXPORTLIMITED void
_ilujava_PANIC(char * f)
{
    ilu_DebugPrintf("$** Ilu_Java PANIC: %s \n", f);
    _ilu_Assert(0, f);
}


/* immutable instances from set up */
static JGC_WP_TYPE(JIluDebug) _ilujava_jjIluDebugTheInst = 0;
static JGC_WP_TYPE(JIluDebugHooks) _ilujava_jjIluDebugHooksTheInst = 0;

/* dynamicly registered instances */
static JGC_WP_TYPE(JIluDebugHooks) _ilujava_jjAssertionFailure = 0;
static JGC_WP_TYPE(JIluDebugHooks) _ilujava_jjCheckFailure     = 0;
static JGC_WP_TYPE(JIluDebugHooks) _ilujava_jjDebugHook        = 0;  


/* Calls into Java */
INTERNALONLY void 
_ilujava_RaiseDebugHook(ilu_ErrorType et, const char *file, int line)
/* Register this with Ilu;
 * It is ok here to do no action if we are not debugging
 */
{
    JIluDebugHooks jjdh = (JIluDebugHooks) JGC_WP_REVEAL(_ilujava_jjDebugHook);
    if (jjdh) {
        JString js = 0;
        long li = line;
        long let = (long) et;
        if (file) {
            /*javaString.h*/ 
            js = makeJavaString((char *) file, strlen(file));
        }
        JCALL_IluDebugHooks_reportDebugHook(jjdh, js, li, let);
    }
}


/* Calls into Java */
INTERNALONLY void 
_ilujava_AssertionFailConsumer(const char *file, int line)
/* Register this with Ilu;
 * Always do something
 */
{
    JIluDebugHooks jjaf = (JIluDebugHooks)
        JGC_WP_REVEAL(_ilujava_jjAssertionFailure);
    if (jjaf) {
        JString js = 0;
        long li = line;
        if (file) {
            /*javaString.h*/ 
            js = makeJavaString((char *) file, strlen(file));
        }
        JCALL_IluDebugHooks_reportAssertionFailure(jjaf, js, li);
    } else {
        _ilujava_DebugPrintAndSignal("ASSERTION FAILURE");
    }
}


/* Calls into Java */
INTERNALONLY void 
_ilujava_CheckFailureConsumer(const char *file, int line)
/* Register this with Ilu;
 * Always do something
 */
{
    JIluDebugHooks jjdh = (JIluDebugHooks)
        JGC_WP_REVEAL(_ilujava_jjCheckFailure);
    if (jjdh) {
        JString js = 0;
        long li = line;
        if (file) {
            /*javaString.h*/ 
            js = makeJavaString((char *) file, strlen(file));
        }
        JCALL_IluDebugHooks_reportCheckFailure(jjdh, js, li);
    } else {
        _ilujava_DebugPrintAndSignal("CONSISTENCY CHECK");
    }
}


JAVAEXPORT(IluDebug_registerTheInst, void) 
    JIluDebug jjd
    ENDJAVAEXPORT
/* Called once at initialization */
{
	if (_ilujava_jjIluDebugTheInst != 0) 
		JGC_WP_RELEASE(_ilujava_jjIluDebugTheInst);
    _ilujava_jjIluDebugTheInst = JGC_WP_MAKE((JGC_WP_TYPE(JIluDebug))jjd);
    _ilujava_langidx = _ilujava_LangIdx();
}


JAVAEXPORT(IluDebugHooks_registerTheInst, void) 
    JIluDebugHooks jjdh
    ENDJAVAEXPORT
/* Called once at initialization */
{
 	if (_ilujava_jjIluDebugHooksTheInst != 0) 
		JGC_WP_RELEASE(_ilujava_jjIluDebugHooksTheInst);
   _ilujava_jjIluDebugHooksTheInst = JGC_WP_MAKE((JGC_WP_TYPE(JIluDebugHooks))jjdh);
    /* set a few defaults */
    if (_ilujava_jjAssertionFailure==0) 
		_ilujava_jjAssertionFailure = JGC_WP_MAKE((JGC_WP_TYPE(JIluDebugHooks))jjdh);
    if (_ilujava_jjCheckFailure==0)     
		_ilujava_jjCheckFailure     = JGC_WP_MAKE((JGC_WP_TYPE(JIluDebugHooks))jjdh);
    /* but don't automatically set jjDebugHook */
    _ilujava_langidx = _ilujava_LangIdx();
}


/* calls into Java */
JAVAEXPORT(IluDebugHooks_defineDebugHook, void) 
    JIluDebugHooks unused, 
    JIluDebugHooks jdbh
    ENDJAVAEXPORT
/* Java client registers an IluDebugHooks instance (or subclass).
 * It is ok to be not debugging...
 */
{
    if (_ilujava_jjDebugHook)
		JGC_WP_RELEASE(_ilujava_jjDebugHook);
	_ilujava_jjDebugHook = JGC_WP_MAKE((JGC_WP_TYPE(JIluDebugHooks))jdbh);
    if (jdbh) {
         ilu_SetRaiseDebugHook(&_ilujava_RaiseDebugHook);
    } else {
         ilu_SetRaiseDebugHook(0);
    }
}


JAVAEXPORT(IluDebugHooks_defineAssertionFailure, void)
    JIluDebugHooks unused, 
    JIluDebugHooks jjaf
    ENDJAVAEXPORT
/* Java client registers an IluDebugHooks instance (or subclass).
 * It makes no sense to do nothing.
 */
{
    if (jjaf==0) 
		jjaf = (JIluDebugHooks) JGC_WP_REVEAL(_ilujava_jjIluDebugHooksTheInst);
    _ilujava_jjAssertionFailure = JGC_WP_MAKE((JGC_WP_TYPE(JIluDebugHooks))jjaf);
    ilu_SetAssertionFailConsumer(&_ilujava_AssertionFailConsumer);
}
        

JAVAEXPORT(IluDebugHooks_defineCheckFailure, void) 
    JIluDebugHooks unused, 
    JIluDebugHooks jjcf
    ENDJAVAEXPORT
/* Java client registers an IluDebugHooks instance (or subclass).
 * It makes no sense to do nothing.
 */
{
    if (jjcf==0) 
		jjcf = (JIluDebugHooks) JGC_WP_REVEAL(_ilujava_jjIluDebugHooksTheInst);
	if (_ilujava_jjCheckFailure) \
		JGC_WP_RELEASE(_ilujava_jjCheckFailure);
    _ilujava_jjCheckFailure = JGC_WP_MAKE((JGC_WP_TYPE(JIluDebugHooks))jjcf);
    ilu_SetCheckFailureConsumer(&_ilujava_CheckFailureConsumer);
}


EXPORTLIMITEDVAR int _ilujava_iluGenericFlag = 99;
EXPORTLIMITEDVAR int _ilujava_iluSpare1Flag    = 99;
EXPORTLIMITEDVAR int _ilujava_iluSpare2Flag    = 99;
EXPORTLIMITEDVAR int _ilujava_objectsFlag      = 99;
EXPORTLIMITEDVAR int _ilujava_pickleFlag       = 99;
EXPORTLIMITEDVAR int _ilujava_callsFlag        = 99;
EXPORTLIMITEDVAR int _ilujava_definitionsFlag  = 99;
EXPORTLIMITEDVAR int _ilujava_pctFlag          = 99;
EXPORTLIMITEDVAR int _ilujava_traceFlag        = 99;
EXPORTLIMITEDVAR int _ilujava_gcFlag           = 99;
EXPORTLIMITEDVAR int _ilujava_lockFlag         =  0;
EXPORTLIMITEDVAR int _ilujava_alarmFlag        =  0;


JAVAEXPORT(IluDebug_reportFlags, void)
    JIluDebug unused, 
    Jint iluGenericFlag,
    Jint iluSpare1Flag,
    Jint iluSpare2Flag,
    Jint objectsFlag,
    Jint pickleFlag,
    Jint callsFlag,
    Jint definitionsFlag,
    Jint pctFlag,
    Jint gcFlag,
    Jint lockFlag,
    Jint alarmFlag
    ENDJAVAEXPORT
{
    _ilujava_iluGenericFlag   = iluGenericFlag;
    _ilujava_iluSpare1Flag      = iluSpare1Flag;
    _ilujava_iluSpare2Flag      = iluSpare2Flag;
    _ilujava_objectsFlag        = objectsFlag;
    _ilujava_pickleFlag         = pickleFlag;
    _ilujava_callsFlag          = callsFlag;
    _ilujava_definitionsFlag    = definitionsFlag;
    _ilujava_pctFlag            = pctFlag;
    _ilujava_gcFlag             = gcFlag;
    _ilujava_lockFlag           = lockFlag;
    _ilujava_alarmFlag          = alarmFlag;
}



JAVAEXPORT(IluDebugWriter_debugWrite1, void)
    Hxerox_ilu_IluDebugWriter * unused, 
    Jint b
    ENDJAVAEXPORT
{
    ilu_DebugPrintf("%c", b);
}


EXPORTLIMITED char * 
_ilujava_captureJavaStack()
{
    HObject* jjDebInst;
	char* pc_stacktrace = ILU_NIL;
	jjDebInst = (HObject*)JGC_WP_REVEAL(_ilujava_jjIluDebugTheInst);
	if (jjDebInst) {
        JString js;
        js = (JString) JCALL_IluDebug_dynamicCaptureStackTrace(jjDebInst);
        if (js) 
			pc_stacktrace = COPY_TO_FREEABLE_C_STRING(js);
    } 
    return pc_stacktrace;
}


/* Calls into Java */
EXPORTLIMITED int 
_ilujava_getIntProp(char * key, int deflt)
/* Read a java property value */
{
    int val = deflt;
    JIluDebug jjDebInst;
	jjDebInst = (JIluDebug) JGC_WP_REVEAL(_ilujava_jjIluDebugTheInst);
    if (jjDebInst != 0 AND key != 0) {
        long ldeflt = deflt;
        JString js = makeJavaString(key, strlen(key));
        val = (int) JCALL_IluDebug_dynamicGetIntProp(jjDebInst, js, ldeflt);
    } 
    return val;
}


/* end */
