/* IluJava_IluInit.c */
/* Chris Jacobi, September 11, 1997 11:01 am PDT */

/*
 * Copyright (c) 1996, 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* 
 * $Id: IluJava_IluInit.c,v 1.20 1997/09/11 18:02:58 jacobi Exp $ 
 *
 *
 * See IluInit.java, IluInit2.java
 */


#include "IluJava_Includes.h"
#include "IluJava_Common.h"
#include "xerox_ilu_IluInit2.h"


/* ------------------------------------------------------------------
 * For RNI, we are required to export this function.
 * Perhaps there is a better file for this?
 */
  
#ifdef RNI
 
__declspec(dllexport) DWORD __cdecl RNIGetCompatibleVersion() {
	return RNIVER;
}
 
#endif
 
 
/* ------------------------------------------------------------------
 * Version checking
 */

JAVAEXPORT(IluInit2_checkLibrary_9_9_1997, Jint)
	Hxerox_ilu_IluInit2 * unused
	ENDJAVAEXPORT
{
    int  x = 15;
    /* this makes applying */
    /* multiple patches */
    /* more easy */
    x = x + 1;
    /* by providing */
    /* multiple lines */
    /* which */
    x = x + 1;
    /* are patchable */
    /* independently */
    /* from each other */
    return (x + 1);
}


/* ------------------------------------------------------------------
 * Main initialization 
 */


#define DEBUGGINGTHIS 0
#define DEBUGPRINT(x) if (DEBUGGINGTHIS) \
    ilu_DebugPrintf("$ IluJava_IluInit2 " x "\n");


    /* 
     * The current java IO doesn't provide non blocking
     * calls which actually work.  Java does convert the
     * IO into non-blocking, but it blocks the java thread.
     *
     * Registering the real system calls will work simply
     * because we trust that in ilu all read and write are 
     * non blocking 
     */
#if (defined(__sgi) || defined(__SGI) || defined(__FreeBSD__))

#include <dlfcn.h>

typedef int (*My_ReadProc)(int,void*,int);
typedef int (*My_WriteProc)(int,const void *,int);

static My_ReadProc _ilujava_read; 
static My_WriteProc _ilujava_write; 

static int
_ilujava_recv(int fd, char *buf, int nbytes, int flags)
{
    return _ilujava_read(fd, buf, nbytes);
}

static int
_ilujava_send(int fd, const char *buf, int nbytes, int flags)
{
    return _ilujava_write(fd, buf, nbytes);
}

static void 
fixIO() 
{
    #if (defined(__FreeBSD__))
    void *handle = dlopen("libc.so", 1);
    #else
    void *handle = dlopen("libc.so", RTLD_LAZY);
    #endif
    _ilujava_read = (My_ReadProc) dlsym(handle, "_read");
    _ilujava_write = (My_WriteProc) dlsym(handle, "_write");
    ilu_SetRecvSendProcs(&_ilujava_recv, &_ilujava_send);
}

#else
#ifndef WIN32

extern int _read(int,char*,int);
extern int _write(int,const char*,int);

static int
_ilujava_recv(int fd, char *buf, int nbytes, int flags)
{
    return _read(fd, buf, nbytes);
}

static int
_ilujava_send(int fd, const char *buf, int nbytes, int flags)
{
    return _write(fd, buf, nbytes);
}

static void 
fixIO() 
{
    ilu_SetRecvSendProcs(&_ilujava_recv, &_ilujava_send);
}

#endif
#endif


JAVAEXPORT(IluInit2_initializeLibrary, void)
	Hxerox_ilu_IluInit2 * unused
	ENDJAVAEXPORT
{
	    DEBUGPRINT("start IluInit2_initializeLibrary");

#ifndef WIN32
    fixIO();
    DEBUGPRINT("did fixIO");
#endif
    _ilujava_LockTechInit(); /*ilu wants this early*/
    DEBUGPRINT("did LockTechInit");
    _ilujava_WaitTechInit();
    DEBUGPRINT("did WaitTechInit");
    _ilujava_AlarmTechInit();
    DEBUGPRINT("did AlarmTechInit");
    _ilujava_IluRt0InitHashTable();
    DEBUGPRINT("did IluRt0InitHashTable");
    _ilujava_PassportInit();
    DEBUGPRINT("did PassportInit");
    _ilujava_IluServerInit();
    DEBUGPRINT("did IluServerInit");
    _ilujava_IluOIntInit();
    DEBUGPRINT("did IluOIntInit");
    initNativeHeaders();
    DEBUGPRINT("did initNativeHeaders");
    DEBUGPRINT("IluInit2_initializeLibrary done");
}


/* end */
