/* IluJava_JTypes.h */
/* Chris Jacobi, November 7, 1997 9:07 am PST */

/*
 * Copyright (c) 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluJava_JTypes.h,v 1.13 1997/11/07 17:07:17 jacobi Exp $ */

/*
 * Macros to make the java stuff more portable
 */

#include "IluJava_Includes.h"

#ifndef _ILUJAVA_JTypes_
#define _ILUJAVA_JTypes_

/*
 * These macros define c types to be used in the ilu runtime to 
 * represent whatever the javah ntive stubber generates for the
 * hinted java type.
 * 
 * See IluConfigureSample.java for a sample java program to
 * run javah on and determine the right types for here.
 */


#if defined(JNI)

  #define Jint jint
  #define Jshort jshort
  #define Jboolean jboolean
  #define Jbyte jbyte
  #define Jlong jlong
  #define Jfloat jfloat
  #define Jdouble jdouble
  #define Jchar jchar
  
  #define JObject jobject
  #define JString jstring
  #define JArrayOfChar jcharArray
  #define JArrayOfByte jbyteArray
  #define JArrayOfString jobjectArray
  #define JArrayOfInt jintArray
  #define JArrayOfObject jobjectArray
  
#else

  #define Jint long
      /* surprize... but javah says long */ 
  #define Jshort short
  #define Jboolean long
      /* surprize... but javah says long */ 
  #define Jbyte char
  #define Jlong int64_t
  #define Jfloat float
  #define Jdouble double
  #define Jchar unicode
  
  #define JObject Hjava_lang_Object*
  #define JString Hjava_lang_String*
  #define JArrayOfChar HArrayOfChar*
  #define JArrayOfByte HArrayOfByte*
  #define JArrayOfString HArrayOfString*
  #define JArrayOfInt HArrayOfInt*
  #define JArrayOfObject HArrayOfObject*
 
#endif 


/*
 * Conversion macros
 */

#define TOIluInt64(i) ( * (ilu_longinteger *) &(i))
#define TOJavaIC64(i) ( * (Jlong *) &(i))
#define TOIluCard64(i) ( * (ilu_longcardinal *) &(i))


/*
 * Ilu classes
 */

#define JIluClassRep Hxerox_ilu_IluClassRep*
#define JIluCall Hxerox_ilu_IluCall*
#define JIluObject xerox_ilu_IluObject*
#define JIluMethodRep Hxerox_ilu_IluMethodRep*
#define JIluRT0 Hxerox_ilu_IluRT0*
#define JIluOInt Hxerox_ilu_IluOInt*
#define JIluServer Hxerox_ilu_IluServer*
#define JIluWPBase Hxerox_ilu_IluWPBase*
#define JIluExceptionRep Hxerox_ilu_IluExceptionRep*
#define JIluAlarmTech Hxerox_ilu_IluAlarmTech*
#define JIluPassport Hxerox_ilu_IluPassport*

#endif /* _ILUJAVA_JTypes_ */
