/* IluSystemException.java */
/* Chris Jacobi, November 6, 1997 4:45 pm PST */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */ 
 

/*
 * $Id: IluSystemException.java,v 1.10 1997/11/07 01:05:39 jacobi Exp $
 */

package xerox.ilu;

/**
 * IluSystemException.java
 * - applications may catch this exception 
 */
public class IluSystemException extends org.omg.CORBA.SystemException {

    public IluSystemException() {
	this("IluSystemException");
    }

    public IluSystemException(java.lang.String s) {
	super(s);
    }

    /**
     * Corba level constructor from ILU level class is not really
     * for clients (no harm however).  It is here, so corba
     * level code can use inheritance.
     */
    public IluSystemException(
            int minor, org.omg.CORBA.CompletionStatus completed) {
	super();
	super.minor = minor;
	super.completed = completed;
    }
    
    /**
     * Corba level constructor from ILU level class is not really
     * for clients (no harm however).  It is here, so corba
     * level code can use inheritance.
     */
    public IluSystemException(java.lang.String s, 
            int minor, org.omg.CORBA.CompletionStatus completed) {
	super(s);
	super.minor = minor;
 	super.completed = completed;
    }
    
    public java.lang.String repositoryId() {
        return theRepositoryId;
    }

    public static java.lang.String classNameOf (java.lang.String repositoryId) {
	/* what the hell is that ? */
	return null;
    }
    
    private java.lang.String theRepositoryId = null;
    
    //straight from iluxport.h
    /*friendly*/ static final int protocolException_Success = 0;
    /*friendly*/ static final int protocolException_NoSuchClassAtServer = 1;
    /*friendly*/ static final int protocolException_ClassVersionMismatch = 2;
    /*friendly*/ static final int protocolException_NoSuchMethodOnClass = 3;
    /*friendly*/ static final int protocolException_GarbageArguments = 4;
    /*friendly*/ static final int protocolException_Unknown = 5;
    /*friendly*/ static final int protocolException_LostConnection = 6;
    /*friendly*/ static final int protocolException_RequestRejected = 7;
    /*friendly*/ static final int protocolException_RequestTimeout = 8;
    /*friendly*/ static final int protocolException_Not = 9;
        // non-protocol failure; see *err 
       

    public static IluSystemException fromIluProtocolException(int code) {
        if (code<0) code = -code;
        switch (code) {
            case protocolException_Success: 
                return new IluSomeSystemException("BadStub");
            case protocolException_NoSuchClassAtServer: 
                return new IluSomeSystemException("NoSuchClassAtServer");
            case protocolException_ClassVersionMismatch: 
                return new IluSomeSystemException("ClassVersionMismatch");
            case protocolException_NoSuchMethodOnClass: 
                return new IluSomeSystemException("NoSuchMethodOnClass");
            case protocolException_GarbageArguments: 
                return new IluSomeSystemException("GarbageArguments");
            case protocolException_Unknown: 
                return new IluSomeSystemException("Unknown");
            case protocolException_LostConnection: 
                return new IluSomeSystemException("LostConnection");
            case protocolException_RequestRejected: 
                return new IluSomeSystemException("RequestRejected");
            case protocolException_RequestTimeout: 
                return new IluSomeSystemException("RequestTimeout");
            case protocolException_Not: 
                return new IluSomeSystemException("NotProtocolException");
            default: break;
        }
        return new IluSomeSystemException("UnknownProtocolException");
    } //fromIluProtocolException

} // IluSystemException

