/* IluWPBase.java */
/* Chris Jacobi, September 3, 1997 3:54 pm PDT */

/*
 * Copyright (c) 1996, 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluWPBase.java,v 1.4 1997/09/03 22:54:35 jacobi Exp $ */
 

package xerox.ilu;

/**
 * Base super class for ilu classes which need to carry
 * a weak pointer on the native side.  <p>
 *
 *
 * Not public at all... <br>
 * Security note: all constructors are guarded:
 * either by making them friendly, or by requiring a key.
 * It is assumed that Ilu will only pass the key to other
 * priviledged packages, like org.omg.CORBA.<p>
 * (reason: errors with finalization must be avoided)
 */
public class IluWPBase {
    /**
     * Key could be passed to priviledged applications. 
     */
    /*friendly*/ static java.lang.Object staticKey = new java.lang.Object();
    private long ywpx = 0; 
        //Storage space for weak pointer on native side.  This
        //field is not accessed from the java side.
        //The kind of weak pointer used may depend on the subclass.
    
    /**
     * Constructor not available to the general public
     */
    /*friendly*/ IluWPBase() {
        this.setupIluWPBase();
    } //constructor
    
    /**
     * Constructor available to the general public, but needs
     * a matching key, so only priviledged applications having
     * key can construct objects. 
     */
    protected IluWPBase(java.lang.Object key) {
        if (key != staticKey) {
            throw new java.lang.SecurityException("don't subclass IluWPBase"); 
        }
        this.setupIluWPBase();
    } //constructor
    
    private native void setupIluWPBase();
        
    protected native void finalize() throws java.lang.Throwable;
        //Subclass overriding this MUST call this on finalization
        //and nowhere else...
    
    /**
     * Loads class. Idempotent.
     */
    public static void init() {
    } //init
    
    static {
        xerox.ilu.IluInit.init();
    }
    
} //IluWPBase
