.TH CHESVX l "08 October 1994" "LAPACK version 2.0" "LAPACK driver routine (version 2.0)"
.TH CHESVX l "08 October 1994" "BLAS routine" "BLAS routine"
.SH NAME
CHESVX - use the diagonal pivoting factorization to compute the solution to a complex system of linear equations A * X = B,
.SH SYNOPSIS
.TP 19
SUBROUTINE CHESVX(
FACT, UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B,
LDB, X, LDX, RCOND, FERR, BERR, WORK, LWORK,
RWORK, INFO )
.TP 19
.ti +4
CHARACTER
FACT, UPLO
.TP 19
.ti +4
INTEGER
INFO, LDA, LDAF, LDB, LDX, LWORK, N, NRHS
.TP 19
.ti +4
REAL
RCOND
.TP 19
.ti +4
INTEGER
IPIV( * )
.TP 19
.ti +4
REAL
BERR( * ), FERR( * ), RWORK( * )
.TP 19
.ti +4
COMPLEX
A( LDA, * ), AF( LDAF, * ), B( LDB, * ),
WORK( * ), X( LDX, * )
.SH PURPOSE
CHESVX uses the diagonal pivoting factorization to compute the
solution to a complex system of linear equations A * X = B,
where A is an N-by-N Hermitian matrix and X and B are N-by-NRHS
matrices.
.br

Error bounds on the solution and a condition estimate are also
provided.
.br

.SH DESCRIPTION
The following steps are performed:
.br

1. If FACT = 'N', the diagonal pivoting method is used to factor A.
   The form of the factorization is
.br
      A = U * D * U**H,  if UPLO = 'U', or
.br
      A = L * D * L**H,  if UPLO = 'L',
.br
   where U (or L) is a product of permutation and unit upper (lower)
   triangular matrices, and D is Hermitian and block diagonal with
   1-by-1 and 2-by-2 diagonal blocks.
.br

2. The factored form of A is used to estimate the condition number
   of the matrix A.  If the reciprocal of the condition number is
   less than machine precision, steps 3 and 4 are skipped.

3. The system of equations is solved for X using the factored form
   of A.
.br

4. Iterative refinement is applied to improve the computed solution
   matrix and calculate error bounds and backward error estimates
   for it.
.br

.SH ARGUMENTS
.TP 8
FACT    (input) CHARACTER*1
Specifies whether or not the factored form of A has been
supplied on entry.
= 'F':  On entry, AF and IPIV contain the factored form
of A.  A, AF and IPIV will not be modified.
= 'N':  The matrix A will be copied to AF and factored.
.TP 8
UPLO    (input) CHARACTER*1
.br
= 'U':  Upper triangle of A is stored;
.br
= 'L':  Lower triangle of A is stored.
.TP 8
N       (input) INTEGER
The number of linear equations, i.e., the order of the
matrix A.  N >= 0.
.TP 8
NRHS    (input) INTEGER
The number of right hand sides, i.e., the number of columns
of the matrices B and X.  NRHS >= 0.
.TP 8
A       (input) COMPLEX array, dimension (LDA,N)
The Hermitian matrix A.  If UPLO = 'U', the leading N-by-N
upper triangular part of A contains the upper triangular part
of the matrix A, and the strictly lower triangular part of A
is not referenced.  If UPLO = 'L', the leading N-by-N lower
triangular part of A contains the lower triangular part of
the matrix A, and the strictly upper triangular part of A is
not referenced.
.TP 8
LDA     (input) INTEGER
The leading dimension of the array A.  LDA >= max(1,N).
.TP 8
AF      (input or output) COMPLEX array, dimension (LDAF,N)
If FACT = 'F', then AF is an input argument and on entry
contains the block diagonal matrix D and the multipliers used
to obtain the factor U or L from the factorization
A = U*D*U**H or A = L*D*L**H as computed by CHETRF.

If FACT = 'N', then AF is an output argument and on exit
returns the block diagonal matrix D and the multipliers used
to obtain the factor U or L from the factorization
A = U*D*U**H or A = L*D*L**H.
.TP 8
LDAF    (input) INTEGER
The leading dimension of the array AF.  LDAF >= max(1,N).
.TP 8
IPIV    (input or output) INTEGER array, dimension (N)
If FACT = 'F', then IPIV is an input argument and on entry
contains details of the interchanges and the block structure
of D, as determined by CHETRF.
If IPIV(k) > 0, then rows and columns k and IPIV(k) were
interchanged and D(k,k) is a 1-by-1 diagonal block.
If UPLO = 'U' and IPIV(k) = IPIV(k-1) < 0, then rows and
columns k-1 and -IPIV(k) were interchanged and D(k-1:k,k-1:k)
is a 2-by-2 diagonal block.  If UPLO = 'L' and IPIV(k) =
IPIV(k+1) < 0, then rows and columns k+1 and -IPIV(k) were
interchanged and D(k:k+1,k:k+1) is a 2-by-2 diagonal block.

If FACT = 'N', then IPIV is an output argument and on exit
contains details of the interchanges and the block structure
of D, as determined by CHETRF.
.TP 8
B       (input) COMPLEX array, dimension (LDB,NRHS)
The N-by-NRHS right hand side matrix B.
.TP 8
LDB     (input) INTEGER
The leading dimension of the array B.  LDB >= max(1,N).
.TP 8
X       (output) COMPLEX array, dimension (LDX,NRHS)
If INFO = 0, the N-by-NRHS solution matrix X.
.TP 8
LDX     (input) INTEGER
The leading dimension of the array X.  LDX >= max(1,N).
.TP 8
RCOND   (output) REAL
The estimate of the reciprocal condition number of the matrix
A.  If RCOND is less than the machine precision (in
particular, if RCOND = 0), the matrix is singular to working
precision.  This condition is indicated by a return code of
INFO > 0, and the solution and error bounds are not computed.
.TP 8
FERR    (output) REAL array, dimension (NRHS)
The estimated forward error bound for each solution vector
X(j) (the j-th column of the solution matrix X).
If XTRUE is the true solution corresponding to X(j), FERR(j)
is an estimated upper bound for the magnitude of the largest
element in (X(j) - XTRUE) divided by the magnitude of the
largest element in X(j).  The estimate is as reliable as
the estimate for RCOND, and is almost always a slight
overestimate of the true error.
.TP 8
BERR    (output) REAL array, dimension (NRHS)
The componentwise relative backward error of each solution
vector X(j) (i.e., the smallest relative change in
any element of A or B that makes X(j) an exact solution).
.TP 8
WORK    (workspace/output) COMPLEX array, dimension (LWORK)
On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
.TP 8
LWORK   (input) INTEGER
The length of WORK.  LWORK >= 2*N, and for best performance
LWORK >= N*NB, where NB is the optimal blocksize for
CHETRF.
.TP 8
RWORK   (workspace) REAL array, dimension (N)
.TP 8
INFO    (output) INTEGER
= 0: successful exit
.br
< 0: if INFO = -i, the i-th argument had an illegal value
.br
> 0: if INFO = i, and i is
.br
<= N: D(i,i) is exactly zero.  The factorization has
has been completed, but the block diagonal
matrix D is exactly singular, so the solution and
error bounds could not be computed.
= N+1: the block diagonal matrix D is nonsingular, but
RCOND is less than machine precision.  The
factorization has been completed, but the matrix
is singular to working precision, so the solution
and error bounds have not been computed.
