#
# x86_linux_2.0.mk - make variables and rules specific to Linux 2.0 on 
#                     intel x86.
#

PLATFORM = x86_linux_2.0
LIBDIR   = $(TOP)/lib
BINDIR   = $(TOP)/bin

#
# C preprocessor macro definitions for this architecture
#

PLATFORM_CPPFLAGS = -D__linux__ -D__i86__ -D__OSVERSION__=2

#
# Standard programs
#

AR              = ar cq
RANLIB		= ranlib
MKDIRHIER	= /usr/X11R6/bin/mkdirhier
CP		= cp
MV		= mv -f
RM              = rm -f

CXX             = gcc
CXXFLAGS        = $(CXXDEBUGFLAGS) $(CXXOPTIONS) $(CPPFLAGS)
CXXDEBUGFLAGS   =
CXXOPTIONS      = -fhandle-exceptions -Wall -Wno-unused
CXXLINK		= g++
CXXLINKOPTIONS  = $(CXXDEBUGFLAGS) $(CXXOPTIONS)

CPPFLAGS        = $(DIR_CPPFLAGS) $(PLATFORM_CPPFLAGS)


.SUFFIXES: .o .cc .C .cpp .cxx

.cc.o:
	$(CXX) -c $(CXXFLAGS) -o $@ $<

.C.o:
	$(CXX) -c $(CXXFLAGS) -o $@ $<

.cpp.o:
	$(CXX) -c $(CXXFLAGS) -o $@ $<

.cxx.o:
	$(CXX) -c $(CXXFLAGS) -o $@ $<


# To build omnithread on top of linux-threads 0.5, uncomment the following
# three lines and comment out the corresponding ones in the mit pthreads 
# section below.
OMNITHREAD_POSIX_CPPFLAGS = -DNoNanoSleep -DPthreadDraftVersion=10
OMNITHREAD_CPPFLAGS = -I$(TOP)/include -D_REENTRANT
OMNITHREAD_LIB = -lomnithread -lpthread
OMNITHREAD_STATIC_LIB = -Wl,-Bstatic -lomnithread -Wl,-Bdynamic -lpthread

# To build omnithread on top of mit pthread, uncomment the following
# three lines and comment out the corresponding ones in the linux-threads
# section above.
#OMNITHREAD_POSIX_CPPFLAGS = -DNoNanoSleep -DPthreadDraftVersion=8 
#OMNITHREAD_CPPFLAGS = -I$(TOP)/include -D_REENTRANT -D_MIT_POSIX_THREADS
#OMNITHREAD_LIB = -lomnithread -lpthreads
#OMNITHREAD_STATIC_LIB = -Wl,-Bstatic -lomnithread -Wl,-Bdynamic -lpthreads

# Default location of the omniORB2 configuration file [falls back to this if
# the environment variable OMNIORB_CONFIG is not set] :
OMNIORB_CONFIG_DEFAULT_LOCATION = \"/etc/omniORB.cfg\"

OMNIORB_CPPFLAGS = -D__OMNIORB2__ $(OMNITHREAD_CPPFLAGS)
OMNIORB_LIB = -lomniORB2 $(OMNITHREAD_LIB) 
OMNIORB_STATIC_LIB = -Wl,-Bstatic -lomniORB2 -Wl,-Bdynamic \
                     $(OMNITHREAD_STATIC_LIB)

# Default directory for the omniNames log files.
OMNINAMES_LOG_DEFAULT_LOCATION = \"/var/omninames\"
