#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/mathlib/arith.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.9
 | File mod date:    1997.11.29 23:10:36
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  mathlib
 |
 | Purpose:          high-level arithmetic (transcendentals, etc)
 `------------------------------------------------------------------------|#

(define-method floor ((self <fixnum>))
  self)

(define-method floor ((self <double-float>))
  (float-floor self))

;;

(define-method ceiling ((self <fixnum>))
  self)

(define-method ceiling ((self <double-float>))
  (float-ceiling self))

;;

(define-method truncate ((self <fixnum>))
  self)

(define-method truncate ((self <double-float>))
  (raw-int->double-float (float-truncate self)))

(define-method round ((self <fixnum>))
  self)

(define-method round ((self <double-float>))
  (float-round self))

(define-glue (float-round x)
{
  IEEE_64 a = extract_float(x);
  INT_32 ai;
    
  if (a < 0)
    {
      ai = (int)(a - 0.5);
      if (ai >= -536870912)
	REG0 = int2fx( ai );
      else
	REG0 = x;
    }
  else
    {
      ai = (int)(a + 0.5);
      if (ai <= 536870911)
	REG0 = int2fx( ai );
      else
	REG0 = x;
    }
    RETURN(1);
})

(define-method exact->inexact ((self <fixnum>))
  (raw-int->double-float self))

(define-method exact->inexact ((self <double-float>))
  self)

(define-method inexact->exact ((self <fixnum>))
  self)

(define-method inexact->exact ((self <double-float>))
  (float-truncate self))

(define-rewriter (real-operator form)
  (let* ((op (symbol->string (cadr form)))
	 (fl (string->symbol (string-append "float-" op))))
    `(define (,(cadr form) (z <number>))
       (if (double-float? z)
	   (,fl z)
	   (,fl (exact->inexact z))))))

(real-operator exp)
(real-operator log)
(real-operator sin)
(real-operator cos)
(real-operator tan)
(real-operator asin)
(real-operator acos)
(real-operator sqrt)

;;

(define-syntax with-raw-float 
  (syntax-form (head x)
    (if (double-float? x)
	(head x)
	(if (fixnum? x)
	    (head (raw-int->raw-float x))
	    (head (exact->inexact x)))))
  (syntax-form (head x y)
    (if (double-float? x)
	(if (double-float? y)
	    (head x y)
	    (if (fixnum? y)
		(head x (raw-int->raw-float y))
		(head x (exact->inexact y))))
	(if (fixnum? x)
	    (if (double-float? y)
		(head (raw-int->raw-float x) y)
		(head (raw-int->raw-float x) (exact->inexact y)))
	    (head (exact->inexact x)
		  (exact->inexact y))))))

(define (atan (z <number>) . rest)
  (if (null? rest)
      (with-raw-float float-atan1 z)
      (if (null? (cdr rest))
	  (with-raw-float float-atan2 z (car rest))
	  (error "atan: too many args"))))

(define (float-result-expt z1 z2)
  (with-raw-float float-pow z1 z2))
